/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;

final class JavaInfo {
    private static final String PROBE_PATH = "modules/ext/profilerprobe.jar";
    private static String PROBE_JAR;

    static String getCurrentJDKExecutable() {
        return JavaInfo.getJDKExecutable(System.getProperty("java.home"));
    }

    static String getJDKExecutable(String jdkHome) {
        if (jdkHome == null || jdkHome.trim().isEmpty()) {
            return null;
        }
        String jreSuffix = File.separator + "jre";
        if (jdkHome.endsWith(jreSuffix)) {
            jdkHome = jdkHome.substring(0, jdkHome.length() - jreSuffix.length());
        }
        String jdkExe = jdkHome + File.separator + "bin" + File.separator + "java" + (Platform.isWindows() ? ".exe" : "");
        return jdkExe;
    }

    static String[] getSystemProperties(File java, String ... keys) {
        if (keys.length == 0) {
            return new String[0];
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(java.getAbsolutePath());
            list.add("-jar");
            list.add(JavaInfo.getProbeJar());
            list.addAll(Arrays.asList(keys));
            Process p = Runtime.getRuntime().exec(list.toArray(new String[list.size()]));
            list.clear();
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            try (BufferedReader br = new BufferedReader(isr);){
                String line = br.readLine();
                while (line != null) {
                    list.add(line);
                    line = br.readLine();
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Throwable t) {
            System.err.println("Error getting system properties from " + java.toString() + ": " + t.getMessage());
            t.printStackTrace(System.err);
            return null;
        }
    }

    private static synchronized String getProbeJar() {
        if (PROBE_JAR == null) {
            InstalledFileLocator loc = InstalledFileLocator.getDefault();
            ModuleInfo info = Modules.getDefault().ownerOf(JavaInfo.class);
            File jar = loc.locate(PROBE_PATH, info.getCodeNameBase(), false);
            PROBE_JAR = jar.getAbsolutePath();
        }
        return PROBE_JAR;
    }

    private JavaInfo() {
    }
}

