/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.swing;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import mediathek.config.Config;
import mediathek.tool.swing.LookAndFeelType;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwingUIFontChanger {
    private static final Logger logger = LogManager.getLogger();
    public static final String NIMBUS_DEFAULT_FONT = "defaultFont";
    public static final String WINDOWS_DEFAULT_FONT = "Table.font";

    public void changeFontSize(float size) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return;
        }
        switch (LookAndFeelType.get(UIManager.getLookAndFeel().getClass().getName())) {
            case Windows: {
                this.changeWindowsFontSize(size);
                break;
            }
            case Nimbus: {
                this.changeNimbusFontSize(size);
                break;
            }
            default: {
                logger.error("Unknown Look&Feel, cannot change font size");
            }
        }
    }

    private void changeNimbusFontSize(float size) {
        UIDefaults defaults = UIManager.getLookAndFeel().getDefaults();
        Font font = (Font)defaults.get(NIMBUS_DEFAULT_FONT);
        font = font.deriveFont(size);
        logger.info("Changing Nimbus font size");
        defaults.put(NIMBUS_DEFAULT_FONT, font);
    }

    private void changeWindowsFontSize(float size) {
        ArrayList<String> keyList = new ArrayList<String>();
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys2 = defaults.keys();
        while (keys2.hasMoreElements()) {
            String str_key;
            Object k = keys2.nextElement();
            if (!(k instanceof String) || !(str_key = (String)k).endsWith(".font")) continue;
            keyList.add(str_key);
        }
        String[] ui_keys = (String[])keyList.stream().distinct().sorted().toArray(String[]::new);
        if (Config.isDebugModeEnabled()) {
            Arrays.stream(ui_keys).forEach(logger::debug);
        }
        logger.info("Changing Windows font sizes to {}", (Object)Float.valueOf(size));
        Arrays.stream(ui_keys).forEach(key -> {
            Font font = defaults.getFont(key);
            font = font.deriveFont(size);
            UIManager.put(key, font);
        });
    }
}

