# This file has been autogenerated by the pywayland scanner

# Copyright 2021 Isaac Freund
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .ext_session_lock_v1 import ExtSessionLockV1


class ExtSessionLockManagerV1(Interface):
    """Used to lock the session

    This interface is used to request that the session be locked.
    """

    name = "ext_session_lock_manager_v1"
    version = 1


class ExtSessionLockManagerV1Proxy(Proxy[ExtSessionLockManagerV1]):
    interface = ExtSessionLockManagerV1

    @ExtSessionLockManagerV1.request()
    def destroy(self) -> None:
        """Destroy the session lock manager object

        This informs the compositor that the session lock manager object will
        no longer be used. Existing objects created through this interface
        remain valid.
        """
        self._marshal(0)
        self._destroy()

    @ExtSessionLockManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtSessionLockV1),
    )
    def lock(self) -> Proxy[ExtSessionLockV1]:
        """Attempt to lock the session

        This request creates a session lock and asks the compositor to lock the
        session. The compositor will send either the
        :func:`ExtSessionLockV1.locked()
        <pywayland.protocol.ext_session_lock_v1.ExtSessionLockV1.locked>` or
        :func:`ExtSessionLockV1.finished()
        <pywayland.protocol.ext_session_lock_v1.ExtSessionLockV1.finished>`
        event on the created object in response to this request.

        :returns:
            :class:`~pywayland.protocol.ext_session_lock_v1.ExtSessionLockV1`
        """
        id = self._marshal_constructor(1, ExtSessionLockV1)
        return id


class ExtSessionLockManagerV1Resource(Resource):
    interface = ExtSessionLockManagerV1


class ExtSessionLockManagerV1Global(Global):
    interface = ExtSessionLockManagerV1


ExtSessionLockManagerV1._gen_c()
ExtSessionLockManagerV1.proxy_class = ExtSessionLockManagerV1Proxy
ExtSessionLockManagerV1.resource_class = ExtSessionLockManagerV1Resource
ExtSessionLockManagerV1.global_class = ExtSessionLockManagerV1Global
