"use strict";
/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServer = exports.TestLspServer = exports.lastPosition = exports.positionAfter = exports.position = exports.positionAt = exports.readContents = exports.filePath = exports.uri = exports.getDefaultClientCapabilities = void 0;
const path = __importStar(require("path"));
const fs = __importStar(require("fs"));
const lsp = __importStar(require("vscode-languageserver/node"));
const protocol_translation_1 = require("./protocol-translation");
const lsp_server_1 = require("./lsp-server");
const logger_1 = require("./logger");
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
const versionProvider_1 = require("./utils/versionProvider");
function getDefaultClientCapabilities() {
    return {
        textDocument: {
            documentSymbol: {
                hierarchicalDocumentSymbolSupport: true
            },
            publishDiagnostics: {
                tagSupport: {
                    valueSet: [
                        lsp.DiagnosticTag.Unnecessary,
                        lsp.DiagnosticTag.Deprecated
                    ]
                }
            },
            moniker: {}
        }
    };
}
exports.getDefaultClientCapabilities = getDefaultClientCapabilities;
function uri(...components) {
    const resolved = filePath(...components);
    return (0, protocol_translation_1.pathToUri)(resolved, undefined);
}
exports.uri = uri;
function filePath(...components) {
    return (0, protocol_translation_1.normalizePath)(path.resolve(__dirname, '..', 'test-data', ...components));
}
exports.filePath = filePath;
function readContents(path) {
    return fs.readFileSync(path, 'utf-8').toString();
}
exports.readContents = readContents;
function positionAt(document, idx) {
    const doc = vscode_languageserver_textdocument_1.TextDocument.create(document.uri, document.languageId, document.version, document.text);
    const pos = doc.positionAt(idx);
    return {
        line: pos.line,
        character: pos.character
    };
}
exports.positionAt = positionAt;
function position(document, match) {
    return positionAt(document, document.text.indexOf(match));
}
exports.position = position;
function positionAfter(document, match) {
    return positionAt(document, document.text.indexOf(match) + match.length);
}
exports.positionAfter = positionAfter;
function lastPosition(document, match) {
    return positionAt(document, document.text.lastIndexOf(match));
}
exports.lastPosition = lastPosition;
class TestLspServer extends lsp_server_1.LspServer {
    constructor() {
        super(...arguments);
        this.workspaceEdits = [];
    }
}
exports.TestLspServer = TestLspServer;
function createServer(options) {
    return __awaiter(this, void 0, void 0, function* () {
        const typescriptVersionProvider = new versionProvider_1.TypeScriptVersionProvider();
        const bundled = typescriptVersionProvider.bundledVersion();
        const logger = new logger_1.ConsoleLogger(false);
        const server = new TestLspServer({
            logger,
            tsserverPath: bundled.tsServerPath,
            tsserverLogVerbosity: options.tsserverLogVerbosity,
            tsserverLogFile: path.resolve(__dirname, '../tsserver.log'),
            lspClient: {
                setClientCapabilites() { },
                createProgressReporter() {
                    return {
                        begin() { },
                        report() { },
                        end() { }
                    };
                },
                publishDiagnostics: options.publishDiagnostics,
                showMessage(args) {
                    throw args; // should not be called.
                },
                logMessage(args) {
                    logger.log('logMessage', JSON.stringify(args));
                },
                telemetry(args) {
                    logger.log('telemetry', JSON.stringify(args));
                },
                applyWorkspaceEdit(args) {
                    return __awaiter(this, void 0, void 0, function* () {
                        server.workspaceEdits.push(args);
                        return { applied: true };
                    });
                },
                rename: () => Promise.reject(new Error('unsupported'))
            }
        });
        yield server.initialize({
            rootPath: undefined,
            rootUri: options.rootUri,
            processId: 42,
            capabilities: options.clientCapabilitiesOverride || getDefaultClientCapabilities(),
            workspaceFolders: null
        });
        return server;
    });
}
exports.createServer = createServer;
//# sourceMappingURL=test-utils.js.map