/* window.c generated by valac 0.56.0, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Color lines for GNOME
 * Copyright © 1999 Free Software Foundation
 * Authors: Robert Szokovacs <szo@szo.hu>
 *          Szabolcs Ban <shooby@gnome.hu>
 *          Karuna Grewal <karunagrewal98@gmail.com>
 *          Ruxandra Simion <ruxandra.simion93@gmail.com>
 * Copyright © 2007 Christian Persch
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libgnome-games-support.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <cairo-gobject.h>

#define FIVE_OR_MORE_APP_KEY_SIZE "size"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME_RENDERER (theme_renderer_get_type ())
#define THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_RENDERER, ThemeRenderer))
#define THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_RENDERER, ThemeRendererClass))
#define IS_THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_RENDERER))
#define IS_THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_RENDERER))
#define THEME_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_RENDERER, ThemeRendererClass))

typedef struct _ThemeRenderer ThemeRenderer;
typedef struct _ThemeRendererClass ThemeRendererClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY,
	GAME_WINDOW_WINDOW_WIDTH_PROPERTY,
	GAME_WINDOW_WINDOW_HEIGHT_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _theme_renderer_unref0(var) ((var == NULL) ? NULL : (var = (theme_renderer_unref (var), NULL)))

#define TYPE_NEXT_PIECES_WIDGET (next_pieces_widget_get_type ())
#define NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidget))
#define NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))
#define IS_NEXT_PIECES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEXT_PIECES_WIDGET))
#define IS_NEXT_PIECES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEXT_PIECES_WIDGET))
#define NEXT_PIECES_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEXT_PIECES_WIDGET, NextPiecesWidgetClass))

typedef struct _NextPiecesWidget NextPiecesWidget;
typedef struct _NextPiecesWidgetClass NextPiecesWidgetClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_BOARD (board_get_type ())
#define BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD, Board))
#define BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD, BoardClass))
#define IS_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD))
#define IS_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD))
#define BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD, BoardClass))

typedef struct _Board Board;
typedef struct _BoardClass BoardClass;

#define TYPE_CELL (cell_get_type ())
#define CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELL, Cell))
#define CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELL, CellClass))
#define IS_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELL))
#define IS_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELL))
#define CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELL, CellClass))

typedef struct _Cell Cell;
typedef struct _CellClass CellClass;

#define TYPE_PIECE (piece_get_type ())
#define PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIECE, Piece))
#define PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIECE, PieceClass))
#define IS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIECE))
#define IS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIECE))
#define PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIECE, PieceClass))

typedef struct _Piece Piece;
typedef struct _PieceClass PieceClass;
typedef enum  {
	STATUS_MESSAGE_DESCRIPTION,
	STATUS_MESSAGE_NO_PATH,
	STATUS_MESSAGE_GAME_OVER,
	STATUS_MESSAGE_NONE
} StatusMessage;

#define TYPE_STATUS_MESSAGE (status_message_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIEW (view_get_type ())
#define VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW, View))
#define VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW, ViewClass))
#define IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW))
#define IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW))
#define VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW, ViewClass))

typedef struct _View View;
typedef struct _ViewClass ViewClass;
typedef enum  {
	BOARD_SIZE_UNSET,
	BOARD_SIZE_SMALL,
	BOARD_SIZE_MEDIUM,
	BOARD_SIZE_LARGE,
	BOARD_SIZE_MAX_SIZE
} BoardSize;

#define TYPE_BOARD_SIZE (board_size_get_type ())

#define TYPE_KEY_VALUE (key_value_get_type ())
typedef struct _KeyValue KeyValue;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	GtkHeaderBar* headerbar;
	GtkBox* preview_hbox;
	GtkMenuButton* primary_menu_button;
	GamesGridFrame* grid_frame;
	GSettings* settings;
	gboolean window_tiled;
	gboolean _window_maximized;
	gint _window_width;
	gint _window_height;
	Game* game;
	ThemeRenderer* theme;
	GamesScoresContext* highscores;
	gchar** status;
	gint status_length1;
	gint _status_size_;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Board* board;
	gint n_next_pieces;
	gint n_filled_cells;
	GeeArrayList* current_path;
	gboolean animating;
	Piece* animating_piece;
	gint n_categories;
	gchar* score_current_category;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _KeyValue {
	gchar* key;
	gchar* name;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;

VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN gpointer theme_renderer_ref (gpointer instance);
VALA_EXTERN void theme_renderer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_theme_renderer (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_theme_renderer (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_theme_renderer (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_theme_renderer (const GValue* value);
VALA_EXTERN GType theme_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeRenderer, theme_renderer_unref)
VALA_EXTERN GameWindow* game_window_new (GtkApplication* app,
                             GSettings* settings);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   GtkApplication* app,
                                   GSettings* settings);
VALA_EXTERN Game* game_new (GSettings* settings);
VALA_EXTERN Game* game_construct (GType object_type,
                      GSettings* settings);
VALA_EXTERN ThemeRenderer* theme_renderer_new (GSettings* settings);
VALA_EXTERN ThemeRenderer* theme_renderer_construct (GType object_type,
                                         GSettings* settings);
VALA_EXTERN GType next_pieces_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NextPiecesWidget, g_object_unref)
VALA_EXTERN NextPiecesWidget* next_pieces_widget_new (GSettings* settings,
                                          Game* game,
                                          ThemeRenderer* theme);
VALA_EXTERN NextPiecesWidget* next_pieces_widget_construct (GType object_type,
                                                GSettings* settings,
                                                Game* game,
                                                ThemeRenderer* theme);
VALA_EXTERN gint game_get_n_cols (Game* self);
VALA_EXTERN gint game_get_n_rows (Game* self);
VALA_EXTERN gpointer board_ref (gpointer instance);
VALA_EXTERN void board_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_board (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_board (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_board (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_board (const GValue* value);
VALA_EXTERN GType board_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Board, board_unref)
VALA_EXTERN gpointer cell_ref (gpointer instance);
VALA_EXTERN void cell_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_cell (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_cell (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_cell (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_cell (const GValue* value);
VALA_EXTERN GType cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Cell, cell_unref)
VALA_EXTERN gpointer piece_ref (gpointer instance);
VALA_EXTERN void piece_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_piece (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_piece (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_piece (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_piece (const GValue* value);
VALA_EXTERN GType piece_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Piece, piece_unref)
static void __lambda5_ (GameWindow* self);
static void ___lambda5__board_board_changed (Board* _sender,
                                      gpointer self);
static void __lambda6_ (GameWindow* self,
                 GObject* s,
                 GParamSpec* p);
static void game_window_set_status_message (GameWindow* self,
                                     const gchar* message);
VALA_EXTERN GType status_message_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint game_get_score (Game* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (GameWindow* self,
                 GObject* s,
                 GParamSpec* p);
VALA_EXTERN StatusMessage game_get_status_message (Game* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN GType view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (View, g_object_unref)
VALA_EXTERN View* view_new (GSettings* settings,
                Game* game,
                ThemeRenderer* theme);
VALA_EXTERN View* view_construct (GType object_type,
                      GSettings* settings,
                      Game* game,
                      ThemeRenderer* theme);
static GamesScoresCategory* game_window_create_category_from_key (GameWindow* self,
                                                           const gchar* key);
static GamesScoresCategory* _game_window_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                       gpointer self);
static void game_window_score_cb (GameWindow* self);
static void _game_window_score_cb_game_game_over (Game* _sender,
                                           gpointer self);
static gboolean game_window_real_window_state_event (GtkWidget* base,
                                              GdkEventWindowState* event);
static void game_window_set_window_maximized (GameWindow* self,
                                       gboolean value);
static void game_window_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation);
VALA_EXTERN gboolean game_window_get_window_maximized (GameWindow* self);
static void game_window_set_window_width (GameWindow* self,
                                   gint value);
static void game_window_set_window_height (GameWindow* self,
                                    gint value);
static gchar* game_window_category_name_from_key (GameWindow* self,
                                           const gchar* key);
VALA_EXTERN void game_window_show_scores (GameWindow* self);
VALA_EXTERN void game_window_restart_game (GameWindow* self);
VALA_EXTERN void game_restart (Game* self);
VALA_EXTERN GType board_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void game_window_change_size (GameWindow* self,
                              BoardSize size);
VALA_EXTERN GType key_value_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyValue* key_value_dup (const KeyValue* self);
VALA_EXTERN void key_value_free (KeyValue* self);
VALA_EXTERN void key_value_copy (const KeyValue* self,
                     KeyValue* dest);
VALA_EXTERN void key_value_destroy (KeyValue* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (KeyValue, key_value_destroy)
VALA_EXTERN gint game_window_get_window_width (GameWindow* self);
VALA_EXTERN gint game_window_get_window_height (GameWindow* self);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);
static void _vala_game_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_game_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const KeyValue GAME_scorecats[3];

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (GameWindow* self)
{
	GamesGridFrame* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = self->priv->grid_frame;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_n_cols (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_n_rows (_tmp4_);
	_tmp6_ = _tmp5_;
	games_grid_frame_set (_tmp0_, _tmp3_, _tmp6_);
}

static void
___lambda5__board_board_changed (Board* _sender,
                                 gpointer self)
{
	__lambda5_ ((GameWindow*) self);
}

static void
__lambda6_ (GameWindow* self,
            GObject* s,
            GParamSpec* p)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	Game* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->status;
	_tmp0__length1 = self->priv->status_length1;
	_tmp1_ = _tmp0_[STATUS_MESSAGE_NONE];
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_score (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	game_window_set_status_message (self, _tmp6_);
	_g_free0 (_tmp6_);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((GameWindow*) self, _sender, pspec);
}

static void
__lambda7_ (GameWindow* self,
            GObject* s,
            GParamSpec* p)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	Game* _tmp1_;
	StatusMessage _tmp2_;
	StatusMessage _tmp3_;
	const gchar* _tmp4_;
	Game* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->status;
	_tmp0__length1 = self->priv->status_length1;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_status_message (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_[_tmp3_];
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_score (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	game_window_set_status_message (self, _tmp9_);
	_g_free0 (_tmp9_);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((GameWindow*) self, _sender, pspec);
}

static GamesScoresCategory*
_game_window_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                                  gpointer self)
{
	GamesScoresCategory* result;
	result = game_window_create_category_from_key ((GameWindow*) self, category_key);
	return result;
}

static void
_game_window_score_cb_game_game_over (Game* _sender,
                                      gpointer self)
{
	game_window_score_cb ((GameWindow*) self);
}

GameWindow*
game_window_construct (GType object_type,
                       GtkApplication* app,
                       GSettings* settings)
{
	GameWindow * self = NULL;
	GSettings* _tmp0_;
	Game* _tmp1_;
	ThemeRenderer* _tmp2_;
	NextPiecesWidget* next_pieces_widget = NULL;
	Game* _tmp3_;
	ThemeRenderer* _tmp4_;
	NextPiecesWidget* _tmp5_;
	GtkBox* _tmp6_;
	GamesGridFrame* _tmp7_;
	Game* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Game* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Game* _tmp14_;
	Board* _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	Game* _tmp19_;
	StatusMessage _tmp20_;
	StatusMessage _tmp21_;
	const gchar* _tmp22_;
	View* game_view = NULL;
	Game* _tmp23_;
	ThemeRenderer* _tmp24_;
	View* _tmp25_;
	GamesGridFrame* _tmp26_;
	GamesGridFrame* _tmp27_;
	GamesScoresDirectoryImporter* importer = NULL;
	GamesScoresDirectoryImporter* _tmp28_;
	GamesScoresContext* _tmp29_;
	Game* _tmp30_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (GameWindow*) g_object_new (object_type, "application", app, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = game_new (settings);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = theme_renderer_new (settings);
	_theme_renderer_unref0 (self->priv->theme);
	self->priv->theme = _tmp2_;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (settings, "window-width"), g_settings_get_int (settings, "window-height"));
	if (g_settings_get_boolean (settings, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp3_ = self->priv->game;
	_tmp4_ = self->priv->theme;
	_tmp5_ = next_pieces_widget_new (settings, _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	next_pieces_widget = _tmp5_;
	_tmp6_ = self->priv->preview_hbox;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) next_pieces_widget, TRUE, TRUE, (guint) 0);
	gtk_widget_realize ((GtkWidget*) next_pieces_widget);
	gtk_widget_show ((GtkWidget*) next_pieces_widget);
	_tmp7_ = self->priv->grid_frame;
	_tmp8_ = self->priv->game;
	_tmp9_ = game_get_n_cols (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->game;
	_tmp12_ = game_get_n_rows (_tmp11_);
	_tmp13_ = _tmp12_;
	games_grid_frame_set (_tmp7_, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->game;
	_tmp15_ = _tmp14_->board;
	g_signal_connect_object (_tmp15_, "board-changed", (GCallback) ___lambda5__board_board_changed, self, 0);
	_tmp16_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::score", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp17_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::status-message", (GCallback) ___lambda7__g_object_notify, self, 0);
	_tmp18_ = self->priv->status;
	_tmp18__length1 = self->priv->status_length1;
	_tmp19_ = self->priv->game;
	_tmp20_ = game_get_status_message (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp18_[_tmp21_];
	game_window_set_status_message (self, _tmp22_);
	_tmp23_ = self->priv->game;
	_tmp24_ = self->priv->theme;
	_tmp25_ = view_new (settings, _tmp23_, _tmp24_);
	g_object_ref_sink (_tmp25_);
	game_view = _tmp25_;
	_tmp26_ = self->priv->grid_frame;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) game_view);
	gtk_widget_show ((GtkWidget*) game_view);
	_tmp27_ = self->priv->grid_frame;
	gtk_widget_show ((GtkWidget*) _tmp27_);
	_tmp28_ = games_scores_directory_importer_new ();
	importer = _tmp28_;
	_tmp29_ = games_scores_context_new_with_importer ("five-or-more", _ ("Board Size: "), (GtkWindow*) self, _game_window_create_category_from_key_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) importer);
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp29_;
	_tmp30_ = self->priv->game;
	g_signal_connect_object (_tmp30_, "game-over", (GCallback) _game_window_score_cb_game_game_over, self, 0);
	_g_object_unref0 (importer);
	_g_object_unref0 (game_view);
	_g_object_unref0 (next_pieces_widget);
	return self;
}

GameWindow*
game_window_new (GtkApplication* app,
                 GSettings* settings)
{
	return game_window_construct (TYPE_GAME_WINDOW, app, settings);
}

static gboolean
game_window_real_window_state_event (GtkWidget* base,
                                     GdkEventWindowState* event)
{
	GameWindow * self;
	gboolean result;
	self = (GameWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		game_window_set_window_maximized (self, (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0);
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_TILED) != 0) {
		self->priv->window_tiled = (event->new_window_state & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}

static void
game_window_real_size_allocate (GtkWidget* base,
                                GtkAllocation* allocation)
{
	GameWindow * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	self = (GameWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (game_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), &_tmp0_);
	_tmp2_ = self->priv->_window_maximized;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->window_tiled;
	}
	if (_tmp1_) {
		return;
	}
	_tmp3_ = *allocation;
	game_window_set_window_width (self, _tmp3_.width);
	_tmp4_ = *allocation;
	game_window_set_window_height (self, _tmp4_.height);
}

static void
game_window_score_cb (GameWindow* self)
{
	gchar* name = NULL;
	Game* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GamesScoresCategory* current_category = NULL;
	Game* _tmp3_;
	const gchar* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresContext* _tmp6_;
	Game* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->score_current_category;
	_tmp2_ = game_window_category_name_from_key (self, _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->game;
	_tmp4_ = _tmp3_->score_current_category;
	_tmp5_ = games_scores_category_new (_tmp4_, name);
	current_category = _tmp5_;
	_tmp6_ = self->priv->highscores;
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_score (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_cancellable_new ();
	_tmp11_ = _tmp10_;
	games_scores_context_add_score (_tmp6_, (glong) _tmp9_, current_category, _tmp11_, NULL, NULL);
	_g_object_unref0 (_tmp11_);
	game_window_show_scores (self);
	_g_object_unref0 (current_category);
	_g_free0 (name);
}

void
game_window_restart_game (GameWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_restart (_tmp0_);
}

static void
game_window_set_status_message (GameWindow* self,
                                const gchar* message)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_subtitle (_tmp0_, message);
}

void
game_window_show_scores (GameWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highscores;
	games_scores_context_run_dialog (_tmp0_);
}

void
game_window_change_size (GameWindow* self,
                         BoardSize size)
{
	gint game_size = 0;
	GSettings* _tmp0_;
	GtkMenuButton* _tmp1_;
	Game* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	game_size = g_settings_get_int (_tmp0_, "size");
	if (game_size == ((gint) size)) {
		return;
	}
	_tmp1_ = self->priv->primary_menu_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, FALSE);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_score (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GtkDialogFlags flags = 0U;
		GtkMessageDialog* restart_game_dialog = NULL;
		GtkMessageDialog* _tmp5_;
		GtkMessageDialog* _tmp6_;
		gint _result_ = 0;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
		flags = GTK_DIALOG_DESTROY_WITH_PARENT;
		_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, flags, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _ ("Are you sure you want to restart the game?"), NULL);
		g_object_ref_sink (_tmp5_);
		restart_game_dialog = _tmp5_;
		_tmp6_ = restart_game_dialog;
		gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Restart"), GTK_RESPONSE_OK, NULL, NULL);
		_tmp7_ = restart_game_dialog;
		_result_ = gtk_dialog_run ((GtkDialog*) _tmp7_);
		_tmp8_ = restart_game_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
		switch (_result_) {
			case GTK_RESPONSE_OK:
			{
				GSettings* _tmp9_;
				_tmp9_ = self->priv->settings;
				if (!g_settings_set_int (_tmp9_, FIVE_OR_MORE_APP_KEY_SIZE, (gint) size)) {
					g_warning ("window.vala:171: Failed to set size: %d", (gint) size);
				}
				break;
			}
			case GTK_RESPONSE_CANCEL:
			{
				break;
			}
			default:
			break;
		}
		_g_object_unref0 (restart_game_dialog);
	} else {
		GSettings* _tmp10_;
		_tmp10_ = self->priv->settings;
		g_settings_set_int (_tmp10_, FIVE_OR_MORE_APP_KEY_SIZE, (gint) size);
	}
}

static GamesScoresCategory*
game_window_create_category_from_key (GameWindow* self,
                                      const gchar* key)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = game_window_category_name_from_key (self, key);
	name = _tmp0_;
	_tmp1_ = games_scores_category_new (key, name);
	result = _tmp1_;
	_g_free0 (name);
	return result;
}

static gchar*
game_window_category_name_from_key (GameWindow* self,
                                    const gchar* key)
{
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Game* _tmp2_;
				KeyValue _tmp3_;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				if (!(i < _tmp2_->n_categories)) {
					break;
				}
				_tmp3_ = GAME_scorecats[i];
				_tmp4_ = _tmp3_.key;
				if (g_strcmp0 (_tmp4_, key) == 0) {
					KeyValue _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp5_ = GAME_scorecats[i];
					_tmp6_ = _tmp5_.name;
					_tmp7_ = g_strdup (_tmp6_);
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

gboolean
game_window_get_window_maximized (GameWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_window_maximized;
	return result;
}

static void
game_window_set_window_maximized (GameWindow* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_window_maximized (self);
	if (old_value != value) {
		self->priv->_window_maximized = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY]);
	}
}

gint
game_window_get_window_width (GameWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_width;
	return result;
}

static void
game_window_set_window_width (GameWindow* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_window_width (self);
	if (old_value != value) {
		self->priv->_window_width = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_WINDOW_WIDTH_PROPERTY]);
	}
}

gint
game_window_get_window_height (GameWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_height;
	return result;
}

static void
game_window_set_window_height (GameWindow* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_window_height (self);
	if (old_value != value) {
		self->priv->_window_height = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_WINDOW_HEIGHT_PROPERTY]);
	}
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	((GtkWidgetClass *) klass)->window_state_event = (gboolean (*) (GtkWidget*, GdkEventWindowState*)) game_window_real_window_state_event;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) game_window_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY, game_window_properties[GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY] = g_param_spec_boolean ("window-maximized", "window-maximized", "window-maximized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_WINDOW_WIDTH_PROPERTY, game_window_properties[GAME_WINDOW_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_WINDOW_HEIGHT_PROPERTY, game_window_properties[GAME_WINDOW_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/five-or-more/ui/five-or-more.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_hbox", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, preview_hbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "primary_menu_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, primary_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_frame", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, grid_frame));
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	self->priv = game_window_get_instance_private (self);
	self->priv->settings = NULL;
	self->priv->game = NULL;
	self->priv->theme = NULL;
	_tmp0_ = g_strdup (_ ("Match five objects of the same type in a row to score!"));
	_tmp1_ = g_strdup (_ ("You can’t move there!"));
	_tmp2_ = g_strdup (_ ("Game Over!"));
	_tmp3_ = g_strdup (_ ("Score: %d"));
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	self->priv->status = _tmp4_;
	self->priv->status_length1 = 4;
	self->priv->_status_size_ = self->priv->status_length1;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_theme_renderer_unref0 (self->priv->theme);
	_g_object_unref0 (self->priv->highscores);
	self->priv->status = (_vala_array_free (self->priv->status, self->priv->status_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

static void
_vala_game_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY:
		g_value_set_boolean (value, game_window_get_window_maximized (self));
		break;
		case GAME_WINDOW_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, game_window_get_window_width (self));
		break;
		case GAME_WINDOW_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, game_window_get_window_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_WINDOW_MAXIMIZED_PROPERTY:
		game_window_set_window_maximized (self, g_value_get_boolean (value));
		break;
		case GAME_WINDOW_WINDOW_WIDTH_PROPERTY:
		game_window_set_window_width (self, g_value_get_int (value));
		break;
		case GAME_WINDOW_WINDOW_HEIGHT_PROPERTY:
		game_window_set_window_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

