// services/content/public/mojom/navigable_contents.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/content/public/mojom/navigable_contents.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/content/public/mojom/navigable_contents.mojom-params-data.h"
#include "services/content/public/mojom/navigable_contents.mojom-shared-message-ids.h"

#include "services/content/public/mojom/navigable_contents.mojom-import-headers.h"


#ifndef SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_JUMBO_H_
#define SERVICES_CONTENT_PUBLIC_MOJOM_NAVIGABLE_CONTENTS_MOJOM_JUMBO_H_
#endif
namespace content {
namespace mojom {
NavigateParams::NavigateParams()
    : should_clear_session_history(false) {}

NavigateParams::NavigateParams(
    bool should_clear_session_history_in)
    : should_clear_session_history(std::move(should_clear_session_history_in)) {}

NavigateParams::~NavigateParams() = default;
size_t NavigateParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->should_clear_session_history);
  return seed;
}

void NavigateParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("should_clear_session_history", this->should_clear_session_history);
}

bool NavigateParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NavigableContents::Name_[] = "content.mojom.NavigableContents";

class NavigableContents_GoBack_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigableContents_GoBack_ForwardToCallback(
      NavigableContents::GoBackCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigableContents::GoBackCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigableContents_GoBack_ForwardToCallback);
};

class NavigableContents_CreateView_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NavigableContents_CreateView_ForwardToCallback(
      NavigableContents::CreateViewCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NavigableContents::CreateViewCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NavigableContents_CreateView_ForwardToCallback);
};

NavigableContentsProxy::NavigableContentsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigableContentsProxy::Navigate(
    const ::GURL& in_url, NavigateParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContents::Navigate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_Navigate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_Navigate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NavigableContents.Navigate request");
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::content::mojom::NavigateParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NavigableContents.Navigate request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("Navigate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsProxy::GoBack(
    GoBackCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::NavigableContents::GoBack");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_GoBack_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_GoBack_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("GoBack");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigableContents_GoBack_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NavigableContentsProxy::CreateView(
    CreateViewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::NavigableContents::CreateView");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_CreateView_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_CreateView_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("CreateView");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NavigableContents_CreateView_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NavigableContentsProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::NavigableContents::Focus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_Focus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_Focus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsProxy::FocusThroughTabTraversal(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContents::FocusThroughTabTraversal", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("reverse", in_reverse);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_FocusThroughTabTraversal_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_FocusThroughTabTraversal_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->reverse = in_reverse;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("FocusThroughTabTraversal");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NavigableContents_GoBack_ProxyToResponder {
 public:
  static NavigableContents::GoBackCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigableContents_GoBack_ProxyToResponder> proxy(
        new NavigableContents_GoBack_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigableContents_GoBack_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigableContents_GoBack_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigableContents_GoBack_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigableContents::GoBackCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigableContents_GoBack_ProxyToResponder);
};

bool NavigableContents_GoBack_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigableContents::GoBackCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NavigableContents_GoBack_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigableContents_GoBack_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NavigableContents_GoBack_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigableContents::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void NavigableContents_GoBack_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigableContents::GoBackCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_GoBack_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_GoBack_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigableContents::GoBackCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("GoBack");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NavigableContents_CreateView_ProxyToResponder {
 public:
  static NavigableContents::CreateViewCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NavigableContents_CreateView_ProxyToResponder> proxy(
        new NavigableContents_CreateView_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NavigableContents_CreateView_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NavigableContents_CreateView_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NavigableContents_CreateView_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NavigableContents::CreateViewCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_embed_token);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NavigableContents_CreateView_ProxyToResponder);
};

bool NavigableContents_CreateView_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "content::mojom::NavigableContents::CreateViewCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NavigableContents_CreateView_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NavigableContents_CreateView_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::UnguessableToken p_embed_token{};
  NavigableContents_CreateView_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadEmbedToken(&p_embed_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NavigableContents::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_embed_token));
  return true;
}

void NavigableContents_CreateView_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_embed_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)content::mojom::NavigableContents::CreateViewCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("embed_token", base::trace_event::ValueToString(in_embed_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContents_CreateView_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContents_CreateView_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->embed_token)::BaseType::BufferWriter
      embed_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_embed_token, buffer, &embed_token_writer, &serialization_context);
  params->embed_token.Set(
      embed_token_writer.is_null() ? nullptr : embed_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embed_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embed_token in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)content::mojom::NavigableContents::CreateViewCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContents::Name_);
  message.set_method_name("CreateView");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NavigableContentsStubDispatch::Accept(
    NavigableContents* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNavigableContents_Navigate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContents::Navigate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContents::Navigate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContents_Navigate_Params_Data* params =
          reinterpret_cast<internal::NavigableContents_Navigate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      NavigateParamsPtr p_params{};
      NavigableContents_Navigate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContents::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Navigate(
std::move(p_url), 
std::move(p_params));
      return true;
    }
    case internal::kNavigableContents_GoBack_Name: {
      break;
    }
    case internal::kNavigableContents_CreateView_Name: {
      break;
    }
    case internal::kNavigableContents_Focus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContents::Focus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContents::Focus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContents_Focus_Params_Data* params =
          reinterpret_cast<internal::NavigableContents_Focus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NavigableContents_Focus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContents::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus();
      return true;
    }
    case internal::kNavigableContents_FocusThroughTabTraversal_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContents::FocusThroughTabTraversal",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContents::FocusThroughTabTraversal");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContents_FocusThroughTabTraversal_Params_Data* params =
          reinterpret_cast<internal::NavigableContents_FocusThroughTabTraversal_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reverse{};
      NavigableContents_FocusThroughTabTraversal_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContents::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusThroughTabTraversal(
std::move(p_reverse));
      return true;
    }
  }
  return false;
}

// static
bool NavigableContentsStubDispatch::AcceptWithResponder(
    NavigableContents* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigableContents_Navigate_Name: {
      break;
    }
    case internal::kNavigableContents_GoBack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContents::GoBack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContents::GoBack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigableContents_GoBack_Params_Data* params =
          reinterpret_cast<
              internal::NavigableContents_GoBack_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NavigableContents_GoBack_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContents::Name_, 1, false);
        return false;
      }
      NavigableContents::GoBackCallback callback =
          NavigableContents_GoBack_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoBack(std::move(callback));
      return true;
    }
    case internal::kNavigableContents_CreateView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContents::CreateView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContents::CreateView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NavigableContents_CreateView_Params_Data* params =
          reinterpret_cast<
              internal::NavigableContents_CreateView_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NavigableContents_CreateView_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContents::Name_, 2, false);
        return false;
      }
      NavigableContents::CreateViewCallback callback =
          NavigableContents_CreateView_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateView(std::move(callback));
      return true;
    }
    case internal::kNavigableContents_Focus_Name: {
      break;
    }
    case internal::kNavigableContents_FocusThroughTabTraversal_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigableContentsValidationInfo[] = {
    {internal::kNavigableContents_Navigate_Name,
     {&internal::NavigableContents_Navigate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContents_GoBack_Name,
     {&internal::NavigableContents_GoBack_Params_Data::Validate,
      &internal::NavigableContents_GoBack_ResponseParams_Data::Validate}},
    {internal::kNavigableContents_CreateView_Name,
     {&internal::NavigableContents_CreateView_Params_Data::Validate,
      &internal::NavigableContents_CreateView_ResponseParams_Data::Validate}},
    {internal::kNavigableContents_Focus_Name,
     {&internal::NavigableContents_Focus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContents_FocusThroughTabTraversal_Name,
     {&internal::NavigableContents_FocusThroughTabTraversal_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NavigableContentsRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigableContents::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigableContentsValidationInfo);
}

bool NavigableContentsResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigableContents::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNavigableContentsValidationInfo);

}
const char NavigableContentsClient::Name_[] = "content.mojom.NavigableContentsClient";

NavigableContentsClientProxy::NavigableContentsClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NavigableContentsClientProxy::ClearViewFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::NavigableContentsClient::ClearViewFocus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_ClearViewFocus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_ClearViewFocus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("ClearViewFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::DidFinishNavigation(
    const ::GURL& in_url, bool in_is_main_frame, bool in_is_error_page, const ::scoped_refptr<::net::HttpResponseHeaders>& in_response_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::DidFinishNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetBoolean("is_main_frame", in_is_main_frame);
      raw_value->SetBoolean("is_error_page", in_is_error_page);
      raw_value->SetString("response_headers", base::trace_event::ValueToString(in_response_headers, "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_DidFinishNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_DidFinishNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NavigableContentsClient.DidFinishNavigation request");
  params->is_main_frame = in_is_main_frame;
  params->is_error_page = in_is_error_page;
  typename decltype(params->response_headers)::BaseType::BufferWriter
      response_headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_response_headers, buffer, &response_headers_writer, &serialization_context);
  params->response_headers.Set(
      response_headers_writer.is_null() ? nullptr : response_headers_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("DidFinishNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "content::mojom::NavigableContentsClient::DidStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_DidStopLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_DidStopLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::DidAutoResizeView(
    const ::gfx::Size& in_new_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::DidAutoResizeView", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("new_size", base::trace_event::ValueToString(in_new_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_DidAutoResizeView_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_DidAutoResizeView_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->new_size)::BaseType::BufferWriter
      new_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_new_size, buffer, &new_size_writer, &serialization_context);
  params->new_size.Set(
      new_size_writer.is_null() ? nullptr : new_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_size in NavigableContentsClient.DidAutoResizeView request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("DidAutoResizeView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::DidSuppressNavigation(
    const ::GURL& in_url, ::WindowOpenDisposition in_disposition, bool in_from_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::DidSuppressNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetInteger("disposition", static_cast<int>(in_disposition));
      raw_value->SetBoolean("from_user_gesture", in_from_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_DidSuppressNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_DidSuppressNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NavigableContentsClient.DidSuppressNavigation request");
  mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
      in_disposition, &params->disposition);
  params->from_user_gesture = in_from_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("DidSuppressNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::UpdateCanGoBack(
    bool in_can_go_back) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::UpdateCanGoBack", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("can_go_back", in_can_go_back);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_UpdateCanGoBack_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_UpdateCanGoBack_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->can_go_back = in_can_go_back;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("UpdateCanGoBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::UpdateContentAXTree(
    const ::ui::AXTreeID& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::UpdateContentAXTree", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type const ::ui::AXTreeID&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_UpdateContentAXTree_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_UpdateContentAXTree_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BufferWriter id_writer;
  id_writer.AllocateInline(buffer, &params->id);
  mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_id, buffer, &id_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in NavigableContentsClient.UpdateContentAXTree request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("UpdateContentAXTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NavigableContentsClientProxy::FocusedNodeChanged(
    bool in_is_editable_node, const ::gfx::Rect& in_node_bounds_in_screen) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "content::mojom::NavigableContentsClient::FocusedNodeChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_editable_node", in_is_editable_node);
      raw_value->SetString("node_bounds_in_screen", base::trace_event::ValueToString(in_node_bounds_in_screen, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNavigableContentsClient_FocusedNodeChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::content::mojom::internal::NavigableContentsClient_FocusedNodeChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_editable_node = in_is_editable_node;
  typename decltype(params->node_bounds_in_screen)::BaseType::BufferWriter
      node_bounds_in_screen_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_node_bounds_in_screen, buffer, &node_bounds_in_screen_writer, &serialization_context);
  params->node_bounds_in_screen.Set(
      node_bounds_in_screen_writer.is_null() ? nullptr : node_bounds_in_screen_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->node_bounds_in_screen.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null node_bounds_in_screen in NavigableContentsClient.FocusedNodeChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NavigableContentsClient::Name_);
  message.set_method_name("FocusedNodeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NavigableContentsClientStubDispatch::Accept(
    NavigableContentsClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNavigableContentsClient_ClearViewFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::ClearViewFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::ClearViewFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_ClearViewFocus_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_ClearViewFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NavigableContentsClient_ClearViewFocus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearViewFocus();
      return true;
    }
    case internal::kNavigableContentsClient_DidFinishNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::DidFinishNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::DidFinishNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_DidFinishNavigation_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_DidFinishNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      bool p_is_main_frame{};
      bool p_is_error_page{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_response_headers{};
      NavigableContentsClient_DidFinishNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_main_frame = input_data_view.is_main_frame();
      if (success)
        p_is_error_page = input_data_view.is_error_page();
      if (success && !input_data_view.ReadResponseHeaders(&p_response_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishNavigation(
std::move(p_url), 
std::move(p_is_main_frame), 
std::move(p_is_error_page), 
std::move(p_response_headers));
      return true;
    }
    case internal::kNavigableContentsClient_DidStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::DidStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::DidStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NavigableContentsClient_DidStopLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading();
      return true;
    }
    case internal::kNavigableContentsClient_DidAutoResizeView_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::DidAutoResizeView",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::DidAutoResizeView");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_DidAutoResizeView_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_DidAutoResizeView_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_new_size{};
      NavigableContentsClient_DidAutoResizeView_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadNewSize(&p_new_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAutoResizeView(
std::move(p_new_size));
      return true;
    }
    case internal::kNavigableContentsClient_DidSuppressNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::DidSuppressNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::DidSuppressNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_DidSuppressNavigation_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_DidSuppressNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::WindowOpenDisposition p_disposition{};
      bool p_from_user_gesture{};
      NavigableContentsClient_DidSuppressNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success)
        p_from_user_gesture = input_data_view.from_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidSuppressNavigation(
std::move(p_url), 
std::move(p_disposition), 
std::move(p_from_user_gesture));
      return true;
    }
    case internal::kNavigableContentsClient_UpdateCanGoBack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::UpdateCanGoBack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::UpdateCanGoBack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_UpdateCanGoBack_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_UpdateCanGoBack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_can_go_back{};
      NavigableContentsClient_UpdateCanGoBack_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_can_go_back = input_data_view.can_go_back();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCanGoBack(
std::move(p_can_go_back));
      return true;
    }
    case internal::kNavigableContentsClient_UpdateContentAXTree_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::UpdateContentAXTree",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::UpdateContentAXTree");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_UpdateContentAXTree_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_UpdateContentAXTree_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::AXTreeID p_id{};
      NavigableContentsClient_UpdateContentAXTree_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateContentAXTree(
std::move(p_id));
      return true;
    }
    case internal::kNavigableContentsClient_FocusedNodeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)content::mojom::NavigableContentsClient::FocusedNodeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)content::mojom::NavigableContentsClient::FocusedNodeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NavigableContentsClient_FocusedNodeChanged_Params_Data* params =
          reinterpret_cast<internal::NavigableContentsClient_FocusedNodeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_editable_node{};
      ::gfx::Rect p_node_bounds_in_screen{};
      NavigableContentsClient_FocusedNodeChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_editable_node = input_data_view.is_editable_node();
      if (success && !input_data_view.ReadNodeBoundsInScreen(&p_node_bounds_in_screen))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NavigableContentsClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusedNodeChanged(
std::move(p_is_editable_node), 
std::move(p_node_bounds_in_screen));
      return true;
    }
  }
  return false;
}

// static
bool NavigableContentsClientStubDispatch::AcceptWithResponder(
    NavigableContentsClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNavigableContentsClient_ClearViewFocus_Name: {
      break;
    }
    case internal::kNavigableContentsClient_DidFinishNavigation_Name: {
      break;
    }
    case internal::kNavigableContentsClient_DidStopLoading_Name: {
      break;
    }
    case internal::kNavigableContentsClient_DidAutoResizeView_Name: {
      break;
    }
    case internal::kNavigableContentsClient_DidSuppressNavigation_Name: {
      break;
    }
    case internal::kNavigableContentsClient_UpdateCanGoBack_Name: {
      break;
    }
    case internal::kNavigableContentsClient_UpdateContentAXTree_Name: {
      break;
    }
    case internal::kNavigableContentsClient_FocusedNodeChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNavigableContentsClientValidationInfo[] = {
    {internal::kNavigableContentsClient_ClearViewFocus_Name,
     {&internal::NavigableContentsClient_ClearViewFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_DidFinishNavigation_Name,
     {&internal::NavigableContentsClient_DidFinishNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_DidStopLoading_Name,
     {&internal::NavigableContentsClient_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_DidAutoResizeView_Name,
     {&internal::NavigableContentsClient_DidAutoResizeView_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_DidSuppressNavigation_Name,
     {&internal::NavigableContentsClient_DidSuppressNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_UpdateCanGoBack_Name,
     {&internal::NavigableContentsClient_UpdateCanGoBack_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_UpdateContentAXTree_Name,
     {&internal::NavigableContentsClient_UpdateContentAXTree_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNavigableContentsClient_FocusedNodeChanged_Name,
     {&internal::NavigableContentsClient_FocusedNodeChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NavigableContentsClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::content::mojom::NavigableContentsClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNavigableContentsClientValidationInfo);
}

}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::NavigateParams::DataView, ::content::mojom::NavigateParamsPtr>::Read(
    ::content::mojom::NavigateParams::DataView input,
    ::content::mojom::NavigateParamsPtr* output) {
  bool success = true;
  ::content::mojom::NavigateParamsPtr result(::content::mojom::NavigateParams::New());
  
      if (success)
        result->should_clear_session_history = input.should_clear_session_history();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif