/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import mediathek.javafx.tool.JFXHiddenApplication;
import org.apache.commons.lang3.SystemUtils;

public class MemoryMonitor
extends Stage {
    private static final int TIMELINE_SIZE = 60;
    private final AtomicInteger time = new AtomicInteger();
    private final XYChart.Series<Number, Number> series = new XYChart.Series();
    private Timeline updateMemoryTimer;
    private LongProperty totalMemory;
    private LongProperty freeMemory;
    private LongProperty maxMemory;
    private NumberBinding usedMemory;
    private LineChart<Number, Number> chart;

    public MemoryMonitor() {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Speicherverbrauch");
        this.initOwner(JFXHiddenApplication.getPrimaryStage());
        this.getIcons().add(JFXHiddenApplication.getApplicationImage());
        this.setAlwaysOnTop(true);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.initStyle(StageStyle.UTILITY);
        }
        this.createPropertiesAndBindings();
        Scene scene = new Scene(this.createMemoryMonitor());
        this.setScene(scene);
        this.setOnHiding(e -> this.updateMemoryTimer.stop());
        this.setOnShowing(e -> this.updateMemoryTimer.play());
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            Transition animation = new Transition(){
                {
                    this.setCycleDuration(Duration.millis(1000.0));
                    this.setInterpolator(Interpolator.EASE_OUT);
                }

                @Override
                protected void interpolate(double frac) {
                    Color vColor = new Color(1.0, 0.0, 0.0, 1.0 - frac);
                    MemoryMonitor.this.chart.setBackground(new Background(new BackgroundFill(vColor, CornerRadii.EMPTY, Insets.EMPTY)));
                }
            };
            animation.play();
            System.gc();
        });
    }

    private long toMegabytes(long bytes) {
        return bytes / 0x100000L;
    }

    private void createPropertiesAndBindings() {
        this.totalMemory = new SimpleLongProperty(this.toMegabytes(Runtime.getRuntime().totalMemory()));
        this.freeMemory = new SimpleLongProperty(this.toMegabytes(Runtime.getRuntime().freeMemory()));
        this.maxMemory = new SimpleLongProperty(this.toMegabytes(Runtime.getRuntime().maxMemory()));
        this.usedMemory = this.totalMemory.subtract(this.freeMemory);
    }

    private void createUpdateTimer() {
        this.updateMemoryTimer = new Timeline(new KeyFrame(Duration.seconds(1.0), event -> {
            this.totalMemory.set(this.toMegabytes(Runtime.getRuntime().totalMemory()));
            this.freeMemory.set(this.toMegabytes(Runtime.getRuntime().freeMemory()));
            this.maxMemory.set(this.toMegabytes(Runtime.getRuntime().maxMemory()));
            this.series.getData().add(new XYChart.Data<Integer, Number>(this.time.incrementAndGet(), (Number)this.usedMemory.getValue()));
            if (this.series.getData().size() > 60) {
                this.series.getData().subList(0, this.series.getData().size() - 60).clear();
            }
        }, new KeyValue[0]));
        this.updateMemoryTimer.setCycleCount(-1);
        this.updateMemoryTimer.play();
    }

    private Pane createMemoryMonitor() {
        this.series.setName("Speicherverbrauch (MByte)");
        this.createUpdateTimer();
        this.chart = this.createChart();
        return new BorderPane((Node)this.chart, (Node)this.createLabels(), null, null, null);
    }

    private Pane createLabels() {
        Label lblUsed = new Label();
        lblUsed.textProperty().bind(this.usedMemory.asString("Used: %,d"));
        Label lblFree = new Label();
        lblFree.textProperty().bind(this.freeMemory.asString("Free: %,d"));
        Label lblTotal = new Label();
        lblTotal.textProperty().bind(this.totalMemory.asString("Total: %,d"));
        Label lblMax = new Label();
        lblMax.textProperty().bind(this.maxMemory.asString("Max: %,d"));
        HBox labels = new HBox(lblUsed, lblFree, lblTotal, lblMax);
        labels.setSpacing(10.0);
        return labels;
    }

    private LineChart<Number, Number> createChart() {
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLabel("Laufzeit");
        xAxis.setForceZeroInRange(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("Speicher");
        LineChart<Number, Number> chart = new LineChart<Number, Number>(xAxis, yAxis);
        chart.setAnimated(false);
        chart.getData().add(this.series);
        chart.createSymbolsProperty().setValue(false);
        return chart;
    }
}

