/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-time.h"
#include "libical-glib-private.h"
#include "i-cal-time-span.h"
#include "i-cal-duration.h"
#include "i-cal-timezone.h"

G_DEFINE_TYPE (ICalTime, i_cal_time, I_CAL_TYPE_OBJECT)

static void i_cal_time_class_init (G_GNUC_UNUSED ICalTimeClass *klass)
{
}

static void i_cal_time_init (G_GNUC_UNUSED ICalTime *self)
{
}

/**
 * i_cal_time_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTime *
i_cal_time_new_full (struct icaltimetype native)
{
    ICalTime *object;
    struct icaltimetype *clone;
    
    
    clone = g_new (struct icaltimetype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_TIME,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_time_new:
 *
 * Creates a new #ICalTime.
 *
 * Returns: (transfer full): The newly created #ICalTime. It is a null time
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new (void)
{
	return i_cal_time_new_full(icaltime_null_time());
}

/**
 * i_cal_time_clone:
 * @timetype: The #ICalTime to clone
 *
 * Creates a new #ICalTime, copy of @timetype.
 *
 * Returns: (transfer full): The newly created #ICalTime, copy of @timetype.
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_clone (const ICalTime *timetype)
{
    struct icaltimetype *itt;

    g_return_val_if_fail(I_CAL_IS_TIME(timetype), NULL);

    itt = (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype);
    g_return_val_if_fail(itt != NULL, NULL);

    return i_cal_time_new_full(*itt);
}

/**
 * i_cal_time_new_null_time:
 *
 * Creates a default time which is an epoch time.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_null_time (void)
{
	return i_cal_time_new_full (icaltime_null_time ());
}

/**
 * i_cal_time_new_null_date:
 *
 * Creates a null date, which indicates no time has been set.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_null_date (void)
{
	return i_cal_time_new_full (icaltime_null_date ());
}

/**
 * i_cal_time_new_current_with_zone:
 * @zone: (nullable): The timezone used to create a #ICalTime according to the current time
 *
 * Creates a #ICalTime according to the timezone and current time.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_current_with_zone (ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return i_cal_time_new_full (icaltime_current_time_with_zone (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL)));
}

/**
 * i_cal_time_new_today:
 *
 * Creates a #ICalTime representing today.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_today (void)
{
	return i_cal_time_new_full (icaltime_today ());
}

/**
 * i_cal_time_new_from_timet_with_zone:
 * @v: The seconds past since epoch time
 * @is_date: Whether it is a date type, 1 if yes, 0 if not
 * @zone: (nullable): The timezone, or %NULL
 *
 * Converts seconds past UNIX epoch to a timetype, using timezones.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_from_timet_with_zone (const time_t v, 
                                     gint is_date, 
                                     ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return i_cal_time_new_full (icaltime_from_timet_with_zone (v, is_date, ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL)));
}

/**
 * i_cal_time_new_from_string:
 * @str: The ISO format string
 *
 * Creates a time from an ISO format string.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_time_new_full (icaltime_from_string (str));
}

/**
 * i_cal_time_new_from_day_of_year:
 * @day: The day of a year
 * @year: The year
 *
 * Creates a new time, given a day of year and a year.
 *
 * Returns: (transfer full): The newly created #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_new_from_day_of_year (const gint day, 
                                 const gint year)
{
	return i_cal_time_new_full (icaltime_from_day_of_year (day, year));
}

/**
 * i_cal_time_as_timet:
 * @tt: The #ICalTime to be converted
 *
 * Returns the time as seconds past the UNIX epoch.
 *
 * Returns: The time as seconds past the UNIX epoch
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_as_timet (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltime_as_timet (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_as_timet_with_zone:
 * @tt: The #ICalTime to be converted
 * @zone: (nullable): The timezone
 *
 * Returns the time as seconds past the UNIX epoch, using timezones.
 *
 * Returns: The time as seconds past the UNIX epoch
 *
 * Since: 1.0
 *
 **/
time_t
i_cal_time_as_timet_with_zone (const ICalTime *tt, 
                               const ICalTimezone *zone)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);

	return icaltime_as_timet_with_zone (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_time_as_ical_string:
 * @tt: The #ICalTime to be converted
 *
 * Returns a string represention of the time, in RFC2445 format.
 *
 * Returns: (transfer full): The string representation
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_time_as_ical_string (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), NULL);

	return icaltime_as_ical_string_r (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_get_timezone:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 *
 * Returns the timezone, the #ICalTimezone object is cached and can be either unreferenced once the last
 * instance is used or can be kept until i_cal_object_free_global_objects() is called (usually at the very
 * end of the program).
 *
 * Returns: (transfer none): The timezone information
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_time_get_timezone (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), NULL);

	return i_cal_timezone_new_full ((void *)icaltime_get_timezone (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt))), (GObject *)tt, TRUE);
}

/**
 * i_cal_time_set_timezone:
 * @tt: The #ICalTime
 * @zone: (nullable): The timezone
 *
 * Sets the timezone of the @tt.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_timezone (ICalTime *tt, 
                         const ICalTimezone *zone)
{
	g_return_if_fail (I_CAL_IS_TIME (tt));
	if(zone)
		g_return_if_fail (I_CAL_IS_TIMEZONE (zone));

	icaltime_set_timezone ((struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_time_get_tzid:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 *
 * Returns the tzid, or NULL for a floating time.
 *
 * Returns: (nullable) (transfer none): The tzid of #ICalTime, or NULL if floating type
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_time_get_tzid (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), NULL);

	return icaltime_get_tzid (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_day_of_year:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 *
 * Returns the day of the year of the given time.
 *
 * Returns: The day of the year of the given time
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_day_of_year (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltime_day_of_year (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_day_of_week:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 *
 * Returns the day of the week of the given time. Sunday is 1.
 *
 * Returns: The day of the week of the given time. Sunday is 1.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_day_of_week (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltime_day_of_week (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_start_doy_week:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 * @fdow: The first day of the week
 *
 * Returns the day of the year for the first day of the week that the given time is within.
 *
 * Returns: The day of the year for the Sunday of the week that the given time is within.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_start_doy_week (const ICalTime *tt, 
                           gint fdow)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltime_start_doy_week (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), fdow);
}

/**
 * i_cal_time_week_number:
 * @tt: (in) (transfer none): The #ICalTime to be queried
 *
 * Returns the week number for the week the given time is within.
 *
 * Returns: The week number for the week the given time is within.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_week_number (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltime_week_number (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_is_null_time:
 * @tt: (in) (transfer none): The #ICalTime to be checked
 *
 * Returns true if the time is null.
 *
 * Returns: Whether @tt is null_time. 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_is_null_time (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), FALSE);

	return icaltime_is_null_time (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_is_valid_time:
 * @tt: (in) (transfer none): The #ICalTime to be checked
 *
 * Returns true if the time is null.
 *
 * Returns: Whether @tt is null_time. 1 if yes, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_is_valid_time (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), FALSE);

	return icaltime_is_valid_time (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_is_date:
 * @tt: (in) (transfer none): The #ICalTime to be checked
 *
 * Returns true if time is of DATE type, false if DATE-TIME.
 *
 * Returns: True if time is of DATE type, false if DATE-TIME.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_is_date (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), FALSE);

	return icaltime_is_date (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_is_utc:
 * @tt: (in) (transfer none): The #ICalTime to be checked
 *
 * Returns true if time is relative to UTC zone.
 *
 * Returns: True if time is relative to UTC zone.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_is_utc (const ICalTime *tt)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), FALSE);

	return icaltime_is_utc (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)));
}

/**
 * i_cal_time_compare:
 * @a: (in) (transfer none): The #ICalTime to be compared
 * @b: (in) (transfer none): The #ICalTime to be compared
 *
 * Returns -1, 0, or 1 to indicate that a less than b, a==b or a larger than b.
 *
 * Returns: -1, 0, or 1 to indicate that a less than b, a==b or a larger than b.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_compare (const ICalTime *a, 
                    const ICalTime *b)
{
	g_return_val_if_fail (I_CAL_IS_TIME (a), 0);
	g_return_val_if_fail (I_CAL_IS_TIME (b), 0);

	return icaltime_compare (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (a)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (b)));
}

/**
 * i_cal_time_compare_date_only:
 * @a: (in) (transfer none): The #ICalTime to be compared
 * @b: (in) (transfer none): The #ICalTime to be compared
 *
 * Like i_cal_time_compare(), but only use the date parts.
 *
 * Returns: -1, 0, or 1 to indicate that a less than b, a==b or a larger than b.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_compare_date_only (const ICalTime *a, 
                              const ICalTime *b)
{
	g_return_val_if_fail (I_CAL_IS_TIME (a), 0);
	g_return_val_if_fail (I_CAL_IS_TIME (b), 0);

	return icaltime_compare_date_only (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (a)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (b)));
}

/**
 * i_cal_time_compare_date_only_tz:
 * @a: (in) (transfer none): The #ICalTime to be compared
 * @b: (in) (transfer none): The #ICalTime to be compared
 * @zone: (nullable): The target timezone
 *
 * Like i_cal_time_compare_tz(), but only use the date parts; accepts timezone.
 *
 * Returns: -1, 0, or 1 to indicate that a less than b, a==b or a larger than b.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_compare_date_only_tz (const ICalTime *a, 
                                 const ICalTime *b, 
                                 ICalTimezone *zone)
{
	g_return_val_if_fail (I_CAL_IS_TIME (a), 0);
	g_return_val_if_fail (I_CAL_IS_TIME (b), 0);
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);

	return icaltime_compare_date_only_tz (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (a)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (b)), ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_time_adjust:
 * @tt: The #ICalTime to be set
 * @days: Difference of days adjusted
 * @hours: Difference of hours adjusted
 * @minutes: Difference of minutes adjusted
 * @seconds: Difference of seconds adjusted
 *
 * Adds or subtracts a number of days, hours, minutes and seconds from @tt.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_adjust (ICalTime *tt, 
                   const gint days, 
                   const gint hours, 
                   const gint minutes, 
                   const gint seconds)
{
	g_return_if_fail (I_CAL_IS_TIME (tt));

	icaltime_adjust ((struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), days, hours, minutes, seconds);
}

/**
 * i_cal_time_normalize:
 * @t: (in) (transfer none): The #ICalTime to be normalized
 *
 * Normalizes the icaltime, so that all fields are within the normal range.
 *
 * Returns: (transfer full): The #ICalTime normalized
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_normalize (const ICalTime *t)
{
	g_return_val_if_fail (I_CAL_IS_TIME (t), NULL);

	return i_cal_time_new_full (icaltime_normalize (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (t))));
}

/**
 * i_cal_time_normalize_inplace:
 * @tt: The #ICalTime to be normalized
 *
 * Normalizes the @tt, so that all fields are within the normal range.
 *
 * Since: 3.0.5
 *
 **/
void
i_cal_time_normalize_inplace (ICalTime *tt)
{
    icaltimetype *itt;

    g_return_if_fail(I_CAL_IS_TIME (tt));

    itt = i_cal_object_get_native(I_CAL_OBJECT (tt));
    g_return_if_fail (itt != NULL);

    *itt = icaltime_normalize(*itt);
}

/**
 * i_cal_time_convert_to_zone:
 * @tt: (in) (transfer none): The #ICalTime to be converted
 * @zone: (nullable): The target timezone
 *
 * Converts @tt to @zone and return new #ICalTime object.
 *
 * Returns: (transfer full): The converted #ICalTime
 *
 * Since: 1.0
 *
 **/
ICalTime *
i_cal_time_convert_to_zone (const ICalTime *tt, 
                            ICalTimezone *zone)
{
	g_return_val_if_fail (I_CAL_IS_TIME (tt), NULL);
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return i_cal_time_new_full (icaltime_convert_to_zone (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL)));
}

/**
 * i_cal_time_convert_to_zone_inplace:
 * @tt: The #ICalTime to be converted
 * @zone: (nullable): The target timezone
 *
 * Converts @tt to @zone and store the result into @tt.
 *
 * Since: 3.0.5
 *
 **/
void
i_cal_time_convert_to_zone_inplace (ICalTime *tt, 
                                    ICalTimezone *zone)
{
    icaltimetype *itt;

    g_return_if_fail(I_CAL_IS_TIME(tt));
    if(zone)
        g_return_if_fail(I_CAL_IS_TIMEZONE(zone));

    itt = i_cal_object_get_native(I_CAL_OBJECT(tt));
    g_return_if_fail(itt != NULL);

    *itt = icaltime_convert_to_zone(*itt, ((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_time_days_in_month:
 * @month: The target month
 * @year: The target year
 *
 * Gets the number of days in the target month in the target year.
 *
 * Returns: The number of days in the target month in the target year.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_days_in_month (gint month, 
                          gint year)
{
	return icaltime_days_in_month (month, year);
}

/**
 * i_cal_time_days_is_leap_year:
 * @year: The target year
 *
 * Checks whether a year is a leap year.
 *
 * Returns: Whether the @year is a leap year
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_days_is_leap_year (gint year)
{
	return icaltime_is_leap_year (year);
}

/**
 * i_cal_time_days_in_year:
 * @year: The target year
 *
 * Returns the number of days in this year.
 *
 * Returns: Days in this year.
 *
 * Since: 2.0
 *
 **/
gint
i_cal_time_days_in_year (gint year)
{
	return icaltime_days_in_year (year);
}

/**
 * i_cal_time_span_new:
 * @dtstart: The start of #ICalTimeSpan
 * @dtend: The end of #ICalTimeSpan
 * @is_busy: Whether this span is busy
 *
 * Creates a new #ICalTimeSpan.
 *
 * Returns: (transfer full): The newly created #ICalTimeSpan
 *
 * Since: 1.0
 *
 **/
ICalTimeSpan *
i_cal_time_span_new (ICalTime *dtstart, 
                     ICalTime *dtend, 
                     gint is_busy)
{
	g_return_val_if_fail (I_CAL_IS_TIME (dtstart), NULL);
	g_return_val_if_fail (I_CAL_IS_TIME (dtend), NULL);

	return i_cal_time_span_new_full (icaltime_span_new (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (dtstart)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (dtend)), is_busy));
}

/**
 * i_cal_time_span_overlaps:
 * @s1: The first #ICalTimeSpan
 * @s2: The second #ICalTimeSpan
 *
 * Checks whether two spans overlap.
 *
 * Returns: Whether these two span are overlapped.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_span_overlaps (ICalTimeSpan *s1, 
                          ICalTimeSpan *s2)
{
	g_return_val_if_fail (I_CAL_IS_TIME_SPAN (s1), 0);
	g_return_val_if_fail (I_CAL_IS_TIME_SPAN (s2), 0);

	return icaltime_span_overlaps ((struct icaltime_span *)i_cal_object_get_native (I_CAL_OBJECT (s1)), (struct icaltime_span *)i_cal_object_get_native (I_CAL_OBJECT (s2)));
}

/**
 * i_cal_time_span_contains:
 * @s: The test #ICalTimeSpan
 * @container: The target container of #ICalTimeSpan
 *
 * Checks whether one #ICalTimeSpan is contained in another #ICalTimeSpan.
 *
 * Returns: Whether one #ICalTimeSpan is contained in another #ICalTimeSpan.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_span_contains (ICalTimeSpan *s, 
                          ICalTimeSpan *container)
{
	g_return_val_if_fail (I_CAL_IS_TIME_SPAN (s), 0);
	g_return_val_if_fail (I_CAL_IS_TIME_SPAN (container), 0);

	return icaltime_span_contains ((struct icaltime_span *)i_cal_object_get_native (I_CAL_OBJECT (s)), (struct icaltime_span *)i_cal_object_get_native (I_CAL_OBJECT (container)));
}

/**
 * i_cal_time_add:
 * @t: A #ICalTime to be operated on
 * @d: A #ICalDuration as the difference
 *
 * Adds a time duration on the time.
 *
 * Returns: (transfer full): The #ICalTime results. The native object is the same. But since it is a bare object, so it won't cause segmentation.
 *
 * Since: 2.0
 *
 **/
ICalTime *
i_cal_time_add (ICalTime *t, 
                ICalDuration *d)
{
	g_return_val_if_fail (I_CAL_IS_TIME (t), NULL);
	g_return_val_if_fail (I_CAL_IS_DURATION (d), NULL);

	return i_cal_time_new_full (icaltime_add (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (t)), * (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (d))));
}

/**
 * i_cal_time_subtract:
 * @t1: The subtracted #ICalTime
 * @t2: The subtracting #ICalTime
 *
 * Gets the duration between two time.
 *
 * Returns: (transfer full): The #ICalDuration between two #ICalTime.
 *
 * Since: 2.0
 *
 **/
ICalDuration *
i_cal_time_subtract (ICalTime *t1, 
                     ICalTime *t2)
{
	g_return_val_if_fail (I_CAL_IS_TIME (t1), NULL);
	g_return_val_if_fail (I_CAL_IS_TIME (t2), NULL);

	return i_cal_duration_new_full (icaltime_subtract (* (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (t1)), * (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (t2))));
}

/**
 * i_cal_time_get_year:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the year of #ICalTime.
 *
 * Returns: The year.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_year (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->year;
}

/**
 * i_cal_time_set_year:
 * @timetype: The #ICalTime to be set
 * @year: The year
 *
 * Sets the year of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_year (ICalTime *timetype, 
                     gint year)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->year = year;
}

/**
 * i_cal_time_get_month:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the month of #ICalTime.
 *
 * Returns: The month.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_month (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->month;
}

/**
 * i_cal_time_set_month:
 * @timetype: The #ICalTime to be set
 * @month: The month
 *
 * Sets the month of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_month (ICalTime *timetype, 
                      gint month)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->month = month;
}

/**
 * i_cal_time_get_day:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the day of #ICalTime.
 *
 * Returns: The day.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_day (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->day;
}

/**
 * i_cal_time_set_day:
 * @timetype: The #ICalTime to be set
 * @day: The day
 *
 * Sets the day of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_day (ICalTime *timetype, 
                    gint day)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->day = day;
}

/**
 * i_cal_time_get_hour:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the hour of #ICalTime.
 *
 * Returns: The hour.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_hour (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->hour;
}

/**
 * i_cal_time_set_hour:
 * @timetype: The #ICalTime to be set
 * @hour: The hour
 *
 * Sets the hour of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_hour (ICalTime *timetype, 
                     gint hour)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->hour = hour;
}

/**
 * i_cal_time_get_minute:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the minute of #ICalTime.
 *
 * Returns: The minute.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_minute (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->minute;
}

/**
 * i_cal_time_set_minute:
 * @timetype: The #ICalTime to be set
 * @minute: The minute
 *
 * Sets the minute of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_minute (ICalTime *timetype, 
                       gint minute)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->minute = minute;
}

/**
 * i_cal_time_get_second:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the second of #ICalTime.
 *
 * Returns: The second.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_time_get_second (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->second;
}

/**
 * i_cal_time_set_second:
 * @timetype: The #ICalTime to be set
 * @second: The second
 *
 * Sets the second of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_second (ICalTime *timetype, 
                       gint second)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->second = second;
}

/**
 * i_cal_time_set_is_date:
 * @timetype: The #ICalTime to be set
 * @is_date: The is_date
 *
 * Sets the is_date of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_is_date (ICalTime *timetype, 
                        gboolean is_date)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->is_date = is_date ? 1 : 0;
}

/**
 * i_cal_time_is_daylight:
 * @timetype: The #ICalTime to be queried
 *
 * Gets the is_daylight of #ICalTime.
 *
 * Returns: The is_daylight.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_time_is_daylight (const ICalTime *timetype)
{
	g_return_val_if_fail (timetype != NULL, 0);
	return ((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->is_daylight;
}

/**
 * i_cal_time_set_is_daylight:
 * @timetype: The #ICalTime to be set
 * @is_daylight: The is_daylight
 *
 * Sets the is_daylight of #ICalTime.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_is_daylight (ICalTime *timetype, 
                            gboolean is_daylight)
{
	g_return_if_fail (timetype != NULL && I_CAL_IS_TIME(timetype));
	((struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype))->is_daylight = is_daylight ? 1 : 0;
}

/**
 * i_cal_time_get_date:
 * @timetype: The #ICalTime to be queried
 * @year: (out caller-allocates) (optional): Out parameter for the 'year' part of the date
 * @month: (out caller-allocates) (optional): Out parameter for the 'month' part of the date
 * @day: (out caller-allocates) (optional): Out parameter for the 'day' part of the date
 *
 * Gets the year/month/date parts of the @timetype in one call.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_get_date (const ICalTime *timetype, 
                     gint *year, 
                     gint *month, 
                     gint *day)
{
    icaltimetype *itt;
    g_return_if_fail(timetype != NULL);
    itt = (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype);
    g_return_if_fail(itt != NULL);
    if(year)
        *year = itt->year;
    if(month)
        *month = itt->month;
    if(day)
        *day = itt->day; 
}

/**
 * i_cal_time_set_date:
 * @timetype: The #ICalTime to be set to
 * @year: The 'year' part of the date
 * @month: The 'month' part of the date
 * @day: The 'day' part of the date
 *
 * Sets the year/month/date parts of the @timetype in one call. This doesn't verify validity of the given
 * date.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_date (ICalTime *timetype, 
                     gint year, 
                     gint month, 
                     gint day)
{
    icaltimetype *itt;
    g_return_if_fail(timetype != NULL);
    itt = (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype);
    g_return_if_fail(itt != NULL);
    itt->year = year;
    itt->month = month;
    itt->day = day; 
}

/**
 * i_cal_time_get_time:
 * @timetype: The #ICalTime to be queried
 * @hour: (out caller-allocates) (optional): Out parameter for the 'hour' part of the time
 * @minute: (out caller-allocates) (optional): Out parameter for the 'minute' part of the time
 * @second: (out caller-allocates) (optional): Out parameter for the 'second' part of the time
 *
 * Gets the hour/minute/second parts of the @timetype in one call.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_get_time (const ICalTime *timetype, 
                     gint *hour, 
                     gint *minute, 
                     gint *second)
{
    icaltimetype *itt;
    g_return_if_fail(timetype != NULL);
    itt = (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype);
    g_return_if_fail(itt != NULL);
    if(hour)
        *hour = itt->hour;
    if(minute)
        *minute = itt->minute;
    if(second)
        *second = itt->second; 
}

/**
 * i_cal_time_set_time:
 * @timetype: The #ICalTime to be set to
 * @hour: The 'hour' part of the time
 * @minute: The 'minute' part of the time
 * @second: The 'second' part of the time
 *
 * Sets the hour/minute/second parts of the @timetype in one call. This doesn't verify validity of the given
 * time.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_set_time (ICalTime *timetype, 
                     gint hour, 
                     gint minute, 
                     gint second)
{
    icaltimetype *itt;
    g_return_if_fail(timetype != NULL);
    itt = (struct icaltimetype *)i_cal_object_get_native ((ICalObject *)timetype);
    g_return_if_fail(itt != NULL);
    itt->hour = hour;
    itt->minute = minute;
    itt->second = second; 
}
