/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.FunctionMapper;
import jakarta.el.ImportHandler;
import jakarta.el.VariableMapper;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ELException;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.JspTag;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspSourceImports;

public class JspContextWrapper
extends PageContext
implements VariableResolver {
    private final JspTag jspTag;
    private final PageContext invokingJspCtxt;
    private final transient HashMap<String, Object> pageAttributes;
    private final ArrayList<String> nestedVars;
    private final ArrayList<String> atBeginVars;
    private final ArrayList<String> atEndVars;
    private final Map<String, String> aliases;
    private final HashMap<String, Object> originalNestedVars;
    private ServletContext servletContext = null;
    private ELContext elContext = null;
    private final PageContext rootJspCtxt;

    public JspContextWrapper(JspTag jspTag, JspContext jspContext, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, Map<String, String> map) {
        this.jspTag = jspTag;
        this.invokingJspCtxt = (PageContext)jspContext;
        this.rootJspCtxt = jspContext instanceof JspContextWrapper ? ((JspContextWrapper)jspContext).rootJspCtxt : this.invokingJspCtxt;
        this.nestedVars = arrayList;
        this.atBeginVars = arrayList2;
        this.atEndVars = arrayList3;
        this.pageAttributes = new HashMap(16);
        this.aliases = map;
        this.originalNestedVars = arrayList != null ? new HashMap(arrayList.size()) : null;
        this.syncBeginTagFile();
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException, IllegalStateException, IllegalArgumentException {
    }

    public Object getAttribute(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.pageAttributes.get(string);
    }

    public Object getAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (n == 1) {
            return this.pageAttributes.get(string);
        }
        return this.rootJspCtxt.getAttribute(string, n);
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (object != null) {
            this.pageAttributes.put(string, object);
        } else {
            this.removeAttribute(string, 1);
        }
    }

    public void setAttribute(String string, Object object, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (n == 1) {
            if (object != null) {
                this.pageAttributes.put(string, object);
            } else {
                this.removeAttribute(string, 1);
            }
        } else {
            this.rootJspCtxt.setAttribute(string, object, n);
        }
    }

    public Object findAttribute(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        Object object = this.pageAttributes.get(string);
        if (object == null && (object = this.rootJspCtxt.getAttribute(string, 2)) == null) {
            if (this.getSession() != null) {
                try {
                    object = this.rootJspCtxt.getAttribute(string, 3);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (object == null) {
                object = this.rootJspCtxt.getAttribute(string, 4);
            }
        }
        return object;
    }

    public void removeAttribute(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        this.pageAttributes.remove(string);
        this.rootJspCtxt.removeAttribute(string, 2);
        if (this.getSession() != null) {
            this.rootJspCtxt.removeAttribute(string, 3);
        }
        this.rootJspCtxt.removeAttribute(string, 4);
    }

    public void removeAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (n == 1) {
            this.pageAttributes.remove(string);
        } else {
            this.rootJspCtxt.removeAttribute(string, n);
        }
    }

    public int getAttributesScope(String string) {
        if (string == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (this.pageAttributes.get(string) != null) {
            return 1;
        }
        return this.rootJspCtxt.getAttributesScope(string);
    }

    public Enumeration<String> getAttributeNamesInScope(int n) {
        if (n == 1) {
            return Collections.enumeration(this.pageAttributes.keySet());
        }
        return this.rootJspCtxt.getAttributeNamesInScope(n);
    }

    public void release() {
        this.invokingJspCtxt.release();
    }

    public JspWriter getOut() {
        return this.rootJspCtxt.getOut();
    }

    public HttpSession getSession() {
        return this.rootJspCtxt.getSession();
    }

    public Object getPage() {
        return this.invokingJspCtxt.getPage();
    }

    public ServletRequest getRequest() {
        return this.invokingJspCtxt.getRequest();
    }

    public ServletResponse getResponse() {
        return this.rootJspCtxt.getResponse();
    }

    public Exception getException() {
        return this.invokingJspCtxt.getException();
    }

    public ServletConfig getServletConfig() {
        return this.invokingJspCtxt.getServletConfig();
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            this.servletContext = this.rootJspCtxt.getServletContext();
        }
        return this.servletContext;
    }

    public void forward(String string) throws ServletException, IOException {
        this.invokingJspCtxt.forward(string);
    }

    public void include(String string) throws ServletException, IOException {
        this.invokingJspCtxt.include(string);
    }

    public void include(String string, boolean bl) throws ServletException, IOException {
        this.invokingJspCtxt.include(string, false);
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return this;
    }

    public BodyContent pushBody() {
        return this.invokingJspCtxt.pushBody();
    }

    public JspWriter pushBody(Writer writer) {
        return this.invokingJspCtxt.pushBody(writer);
    }

    public JspWriter popBody() {
        return this.invokingJspCtxt.popBody();
    }

    @Deprecated
    public ExpressionEvaluator getExpressionEvaluator() {
        return this.invokingJspCtxt.getExpressionEvaluator();
    }

    public void handlePageException(Exception exception) throws IOException, ServletException {
        this.handlePageException((Throwable)exception);
    }

    public void handlePageException(Throwable throwable) throws IOException, ServletException {
        this.invokingJspCtxt.handlePageException(throwable);
    }

    @Deprecated
    public Object resolveVariable(String string) throws ELException {
        ELContext eLContext = this.getELContext();
        return eLContext.getELResolver().getValue(eLContext, null, (Object)string);
    }

    public void syncBeginTagFile() {
        this.saveNestedVariables();
    }

    public void syncBeforeInvoke() {
        this.copyTagToPageScope(0);
        this.copyTagToPageScope(1);
    }

    public void syncEndTagFile() {
        this.copyTagToPageScope(1);
        this.copyTagToPageScope(2);
        this.restoreNestedVariables();
    }

    private void copyTagToPageScope(int n) {
        Iterator<String> iterator = null;
        switch (n) {
            case 0: {
                if (this.nestedVars == null) break;
                iterator = this.nestedVars.iterator();
                break;
            }
            case 1: {
                if (this.atBeginVars == null) break;
                iterator = this.atBeginVars.iterator();
                break;
            }
            case 2: {
                if (this.atEndVars == null) break;
                iterator = this.atEndVars.iterator();
            }
        }
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            Object object = this.getAttribute(string);
            string = this.findAlias(string);
            if (object != null) {
                this.invokingJspCtxt.setAttribute(string, object);
                continue;
            }
            this.invokingJspCtxt.removeAttribute(string, 1);
        }
    }

    private void saveNestedVariables() {
        if (this.nestedVars != null) {
            for (String string : this.nestedVars) {
                Object object = this.invokingJspCtxt.getAttribute(string = this.findAlias(string));
                if (object == null) continue;
                this.originalNestedVars.put(string, object);
            }
        }
    }

    private void restoreNestedVariables() {
        if (this.nestedVars != null) {
            for (String string : this.nestedVars) {
                Object object = this.originalNestedVars.get(string = this.findAlias(string));
                if (object != null) {
                    this.invokingJspCtxt.setAttribute(string, object);
                    continue;
                }
                this.invokingJspCtxt.removeAttribute(string, 1);
            }
        }
    }

    private String findAlias(String string) {
        if (this.aliases == null) {
            return string;
        }
        String string2 = this.aliases.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = new ELContextWrapper(this.rootJspCtxt.getELContext(), this.jspTag, this);
            JspFactory jspFactory = JspFactory.getDefaultFactory();
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(this.servletContext);
            if (jspApplicationContext instanceof JspApplicationContextImpl) {
                ((JspApplicationContextImpl)jspApplicationContext).fireListeners(this.elContext);
            }
        }
        return this.elContext;
    }

    static class ELContextWrapper
    extends ELContext {
        private final ELContext wrapped;
        private final JspTag jspTag;
        private final PageContext pageContext;
        private ImportHandler importHandler;

        private ELContextWrapper(ELContext eLContext, JspTag jspTag, PageContext pageContext) {
            this.wrapped = eLContext;
            this.jspTag = jspTag;
            this.pageContext = pageContext;
        }

        ELContext getWrappedELContext() {
            return this.wrapped;
        }

        public void setPropertyResolved(boolean bl) {
            this.wrapped.setPropertyResolved(bl);
        }

        public void setPropertyResolved(Object object, Object object2) {
            this.wrapped.setPropertyResolved(object, object2);
        }

        public boolean isPropertyResolved() {
            return this.wrapped.isPropertyResolved();
        }

        public void putContext(Class<?> clazz, Object object) {
            if (clazz != JspContext.class) {
                this.wrapped.putContext(clazz, object);
            }
        }

        public Object getContext(Class<?> clazz) {
            if (clazz == JspContext.class) {
                return this.pageContext;
            }
            return this.wrapped.getContext(clazz);
        }

        public ImportHandler getImportHandler() {
            if (this.importHandler == null) {
                this.importHandler = new ImportHandler();
                if (this.jspTag instanceof JspSourceImports) {
                    Object object;
                    Object object2;
                    Set<String> set = ((JspSourceImports)this.jspTag).getPackageImports();
                    if (set != null) {
                        object2 = set.iterator();
                        while (object2.hasNext()) {
                            object = (String)object2.next();
                            this.importHandler.importPackage((String)object);
                        }
                    }
                    if ((object2 = ((JspSourceImports)this.jspTag).getClassImports()) != null) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            String string = (String)object.next();
                            this.importHandler.importClass(string);
                        }
                    }
                }
            }
            return this.importHandler;
        }

        public Locale getLocale() {
            return this.wrapped.getLocale();
        }

        public void setLocale(Locale locale) {
            this.wrapped.setLocale(locale);
        }

        public void addEvaluationListener(EvaluationListener evaluationListener) {
            this.wrapped.addEvaluationListener(evaluationListener);
        }

        public List<EvaluationListener> getEvaluationListeners() {
            return this.wrapped.getEvaluationListeners();
        }

        public void notifyBeforeEvaluation(String string) {
            this.wrapped.notifyBeforeEvaluation(string);
        }

        public void notifyAfterEvaluation(String string) {
            this.wrapped.notifyAfterEvaluation(string);
        }

        public void notifyPropertyResolved(Object object, Object object2) {
            this.wrapped.notifyPropertyResolved(object, object2);
        }

        public boolean isLambdaArgument(String string) {
            return this.wrapped.isLambdaArgument(string);
        }

        public Object getLambdaArgument(String string) {
            return this.wrapped.getLambdaArgument(string);
        }

        public void enterLambdaScope(Map<String, Object> map) {
            this.wrapped.enterLambdaScope(map);
        }

        public void exitLambdaScope() {
            this.wrapped.exitLambdaScope();
        }

        public Object convertToType(Object object, Class<?> clazz) {
            return this.wrapped.convertToType(object, clazz);
        }

        public ELResolver getELResolver() {
            return this.wrapped.getELResolver();
        }

        public FunctionMapper getFunctionMapper() {
            return this.wrapped.getFunctionMapper();
        }

        public VariableMapper getVariableMapper() {
            return this.wrapped.getVariableMapper();
        }
    }
}

