/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ForkDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherClassPathUtil;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.LaunchDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestClasses;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class JUnitLauncherTask
extends Task {
    private static final String LAUNCHER_SUPPORT_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junitlauncher.LauncherSupport";
    private static final String IN_VM_TEST_EXECUTION_CONTEXT_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junitlauncher.InVMExecution";
    private static final String TEST_EXECUTION_CONTEXT_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext";
    private Path classPath;
    private boolean haltOnFailure;
    private String failureProperty;
    private boolean printSummary;
    private final List<TestDefinition> tests = new ArrayList<TestDefinition>();
    private final List<ListenerDefinition> listeners = new ArrayList<ListenerDefinition>();
    private List<String> includeTags = new ArrayList<String>();
    private List<String> excludeTags = new ArrayList<String>();

    public void execute() throws BuildException {
        if (this.tests.isEmpty()) {
            return;
        }
        Project project = this.getProject();
        for (TestDefinition test : this.tests) {
            if (!test.shouldRun(project)) {
                this.log("Excluding test " + test + " since it's considered not to run in context of project " + project, 4);
                continue;
            }
            if (test.getForkDefinition() != null) {
                this.forkTest(test);
                continue;
            }
            this.launchViaReflection(new InVMLaunch(Collections.singletonList(test)));
        }
    }

    public void addConfiguredClassPath(Path path) {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        this.classPath.add(path);
    }

    public void addConfiguredTest(SingleTestClass test) {
        this.preConfigure(test);
        this.tests.add(test);
    }

    public void addConfiguredTestClasses(TestClasses testClasses) {
        this.preConfigure(testClasses);
        this.tests.add(testClasses);
    }

    public void addConfiguredListener(ListenerDefinition listener) {
        this.listeners.add(listener);
    }

    public void setHaltonfailure(boolean haltonfailure) {
        this.haltOnFailure = haltonfailure;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public void setIncludeTags(String includes) {
        StringTokenizer tokens = new StringTokenizer(includes, ",");
        while (tokens.hasMoreTokens()) {
            this.includeTags.add(tokens.nextToken().trim());
        }
    }

    public void setExcludeTags(String excludes) {
        StringTokenizer tokens = new StringTokenizer(excludes, ",");
        while (tokens.hasMoreTokens()) {
            this.excludeTags.add(tokens.nextToken().trim());
        }
    }

    private void preConfigure(TestDefinition test) {
        if (test.getHaltOnFailure() == null) {
            test.setHaltOnFailure(this.haltOnFailure);
        }
        if (test.getFailureProperty() == null) {
            test.setFailureProperty(this.failureProperty);
        }
    }

    private void launchViaReflection(InVMLaunch launchDefinition) {
        Object testExecutionCtx;
        Class<?> klass;
        Class<?> testExecutionCtxClass;
        ClassLoader cl = launchDefinition.getClassLoader();
        try {
            testExecutionCtxClass = Class.forName(TEST_EXECUTION_CONTEXT_CLASS_NAME, false, cl);
            klass = Class.forName(IN_VM_TEST_EXECUTION_CONTEXT_CLASS_NAME, false, cl);
            testExecutionCtx = klass.getConstructor(JUnitLauncherTask.class).newInstance(new Object[]{this});
        }
        catch (Exception e) {
            throw new BuildException("Failed to create a test execution context for in-vm tests", (Throwable)e);
        }
        try {
            klass = Class.forName(LAUNCHER_SUPPORT_CLASS_NAME, false, cl);
            Object launcherSupport = klass.getConstructor(LaunchDefinition.class, testExecutionCtxClass).newInstance(launchDefinition, testExecutionCtx);
            klass.getMethod("launch", new Class[0]).invoke(launcherSupport, new Object[0]);
        }
        catch (Exception e) {
            throw new BuildException("Failed to launch in-vm tests", (Throwable)e);
        }
    }

    private java.nio.file.Path dumpProjectProperties() throws IOException {
        java.nio.file.Path propsPath = FileUtils.getFileUtils().createTempFile(this.getProject(), null, "properties", null, true, true).toPath();
        Hashtable props = this.getProject().getProperties();
        Properties projProperties = new Properties();
        projProperties.putAll((Map<?, ?>)props);
        try (OutputStream os = Files.newOutputStream(propsPath, new OpenOption[0]);){
            projProperties.store(os, StandardCharsets.UTF_8.name());
        }
        return propsPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forkTest(TestDefinition test) {
        java.nio.file.Path projectPropsPath;
        ForkDefinition forkDefinition = test.getForkDefinition();
        CommandlineJava commandlineJava = forkDefinition.generateCommandLine(this);
        if (this.classPath != null) {
            commandlineJava.createClasspath(this.getProject()).createPath().append(this.classPath);
        }
        try {
            projectPropsPath = this.dumpProjectProperties();
        }
        catch (IOException e) {
            throw new BuildException("Could not create the necessary properties file while forking a process for a test", (Throwable)e);
        }
        commandlineJava.createArgument().setValue("--properties");
        commandlineJava.createArgument().setValue(projectPropsPath.toAbsolutePath().toString());
        java.nio.file.Path launchDefXmlPath = this.newLaunchDefinitionXml();
        try (OutputStream os = Files.newOutputStream(launchDefXmlPath, new OpenOption[0]);
             XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(os, "UTF-8");){
            writer.writeStartDocument();
            writer.writeStartElement("launch-definition");
            if (this.printSummary) {
                writer.writeAttribute("printSummary", "true");
            }
            if (this.haltOnFailure) {
                writer.writeAttribute("haltOnFailure", "true");
            }
            if (this.includeTags.size() > 0) {
                writer.writeAttribute("includeTags", JUnitLauncherTask.commaSeparatedListElements(this.includeTags));
            }
            if (this.excludeTags.size() > 0) {
                writer.writeAttribute("excludeTags", JUnitLauncherTask.commaSeparatedListElements(this.excludeTags));
            }
            for (ListenerDefinition listenerDef : this.listeners) {
                if (!listenerDef.shouldUse(this.getProject())) continue;
                listenerDef.toForkedRepresentation(writer);
            }
            test.toForkedRepresentation(this, writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (Exception e) {
            throw new BuildException("Failed to construct command line for test", (Throwable)e);
        }
        commandlineJava.createArgument().setValue("--launch-definition");
        commandlineJava.createArgument().setValue(launchDefXmlPath.toAbsolutePath().toString());
        int exitCode = this.executeForkedTest(forkDefinition, commandlineJava);
        switch (exitCode) {
            case 0: {
                break;
            }
            case 1: {
                throw new BuildException("Forked test(s) failed with an exception");
            }
            case 2: {
                try {
                    if (test.getFailureProperty() != null) {
                        this.getProject().setNewProperty(test.getFailureProperty(), "true");
                    }
                }
                finally {
                    if (!test.isHaltOnFailure()) break;
                    String errorMessage = test instanceof NamedTest ? "Test " + ((NamedTest)((Object)test)).getName() + " has failure(s)" : "Some test(s) have failure(s)";
                    throw new BuildException(errorMessage);
                }
            }
            case 3: {
                throw new BuildException((Throwable)new TimeoutException("Forked test(s) timed out"));
            }
        }
    }

    private static String commaSeparatedListElements(List<String> stringList) {
        return stringList.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private int executeForkedTest(ForkDefinition forkDefinition, CommandlineJava commandlineJava) {
        int exitCode;
        Environment env;
        LogOutputStream outStream = new LogOutputStream((Task)this, 2);
        LogOutputStream errStream = new LogOutputStream((Task)this, 1);
        ExecuteWatchdog watchdog = forkDefinition.getTimeout() > 0L ? this.createExecuteWatchdog(forkDefinition.getTimeout()) : null;
        Execute execute = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream), watchdog);
        execute.setCommandline(commandlineJava.getCommandline());
        execute.setAntRun(this.getProject());
        if (forkDefinition.getDir() != null) {
            execute.setWorkingDirectory(Paths.get(forkDefinition.getDir(), new String[0]).toFile());
        }
        if ((env = forkDefinition.getEnv()) != null && env.getVariables() != null) {
            execute.setEnvironment(env.getVariables());
        }
        this.log(commandlineJava.describeCommand(), 3);
        try {
            exitCode = execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed", (Throwable)e, this.getLocation());
        }
        return watchdog != null && watchdog.killedProcess() ? 3 : exitCode;
    }

    protected ExecuteWatchdog createExecuteWatchdog(long timeout) {
        return new ExecuteWatchdog(timeout);
    }

    private java.nio.file.Path newLaunchDefinitionXml() {
        return FileUtils.getFileUtils().createTempFile(this.getProject(), null, ".xml", null, true, true).toPath();
    }

    private final class InVMLaunch
    implements LaunchDefinition {
        private final List<TestDefinition> inVMTests;
        private final ClassLoader executionCL;

        private InVMLaunch(List<TestDefinition> inVMTests) {
            this.inVMTests = inVMTests;
            this.executionCL = this.createInVMExecutionClassLoader();
        }

        @Override
        public List<TestDefinition> getTests() {
            return this.inVMTests;
        }

        @Override
        public List<ListenerDefinition> getListeners() {
            return JUnitLauncherTask.this.listeners;
        }

        @Override
        public boolean isPrintSummary() {
            return JUnitLauncherTask.this.printSummary;
        }

        @Override
        public boolean isHaltOnFailure() {
            return JUnitLauncherTask.this.haltOnFailure;
        }

        @Override
        public List<String> getIncludeTags() {
            return JUnitLauncherTask.this.includeTags;
        }

        @Override
        public List<String> getExcludeTags() {
            return JUnitLauncherTask.this.excludeTags;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.executionCL;
        }

        private ClassLoader createInVMExecutionClassLoader() {
            Path taskConfiguredClassPath = JUnitLauncherTask.this.classPath;
            if (taskConfiguredClassPath == null) {
                return JUnitLauncherTask.class.getClassLoader();
            }
            if (JUnitLauncherClassPathUtil.hasJUnitPlatformResources(JUnitLauncherTask.class.getClassLoader())) {
                return new AntClassLoader(JUnitLauncherTask.class.getClassLoader(), JUnitLauncherTask.this.getProject(), taskConfiguredClassPath, true);
            }
            Path cp = new Path(JUnitLauncherTask.this.getProject());
            cp.add(taskConfiguredClassPath);
            JUnitLauncherClassPathUtil.addLauncherSupportResourceLocation(cp, JUnitLauncherTask.class.getClassLoader());
            return new TaskConfiguredPathClassLoader(JUnitLauncherTask.class.getClassLoader(), cp, JUnitLauncherTask.this.getProject());
        }
    }

    private final class TaskConfiguredPathClassLoader
    extends AntClassLoader {
        private TaskConfiguredPathClassLoader(ClassLoader parent, Path path, Project project) {
            super(parent, project, path, true);
        }

        protected synchronized Class<?> loadClass(String classname, boolean resolve) throws ClassNotFoundException {
            String packageName;
            Class theClass = this.findLoadedClass(classname);
            if (theClass != null) {
                return theClass;
            }
            String string = packageName = classname.contains(".") ? classname.substring(0, classname.lastIndexOf(46)) : "";
            if (packageName.equals("org.apache.tools.ant.taskdefs.optional.junitlauncher")) {
                theClass = this.findClass(classname);
                if (resolve) {
                    this.resolveClass(theClass);
                }
                return theClass;
            }
            return super.loadClass(classname, resolve);
        }
    }
}

