/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.Device.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.Device
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusDevice
 * @title: NMDBusDevice
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.Device D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.Device ---- */

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_reapply_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_reapply_IN_ARG_version_id =
{
  {
    -1,
    (gchar *) "version_id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_reapply_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_method_info_reapply_IN_ARG_pointers[] =
{
  &_nmdbus_device_method_info_reapply_IN_ARG_connection.parent_struct,
  &_nmdbus_device_method_info_reapply_IN_ARG_version_id.parent_struct,
  &_nmdbus_device_method_info_reapply_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_method_info_reapply =
{
  {
    -1,
    (gchar *) "Reapply",
    (GDBusArgInfo **) &_nmdbus_device_method_info_reapply_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reapply",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_get_applied_connection_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_method_info_get_applied_connection_IN_ARG_pointers[] =
{
  &_nmdbus_device_method_info_get_applied_connection_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_get_applied_connection_OUT_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_method_info_get_applied_connection_OUT_ARG_version_id =
{
  {
    -1,
    (gchar *) "version_id",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_method_info_get_applied_connection_OUT_ARG_pointers[] =
{
  &_nmdbus_device_method_info_get_applied_connection_OUT_ARG_connection.parent_struct,
  &_nmdbus_device_method_info_get_applied_connection_OUT_ARG_version_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_method_info_get_applied_connection =
{
  {
    -1,
    (gchar *) "GetAppliedConnection",
    (GDBusArgInfo **) &_nmdbus_device_method_info_get_applied_connection_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_device_method_info_get_applied_connection_OUT_ARG_pointers,
    NULL
  },
  "handle-get-applied-connection",
  FALSE
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_method_info_disconnect =
{
  {
    -1,
    (gchar *) "Disconnect",
    NULL,
    NULL,
    NULL
  },
  "handle-disconnect",
  FALSE
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    NULL,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const GDBusMethodInfo * const _nmdbus_device_method_info_pointers[] =
{
  &_nmdbus_device_method_info_reapply.parent_struct,
  &_nmdbus_device_method_info_get_applied_connection.parent_struct,
  &_nmdbus_device_method_info_disconnect.parent_struct,
  &_nmdbus_device_method_info_delete.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_device_signal_info_state_changed_ARG_new_state =
{
  {
    -1,
    (gchar *) "new_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_signal_info_state_changed_ARG_old_state =
{
  {
    -1,
    (gchar *) "old_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_signal_info_state_changed_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_signal_info_state_changed_ARG_pointers[] =
{
  &_nmdbus_device_signal_info_state_changed_ARG_new_state.parent_struct,
  &_nmdbus_device_signal_info_state_changed_ARG_old_state.parent_struct,
  &_nmdbus_device_signal_info_state_changed_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_device_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_nmdbus_device_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _nmdbus_device_signal_info_pointers[] =
{
  &_nmdbus_device_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_udi =
{
  {
    -1,
    (gchar *) "Udi",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "udi",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_path =
{
  {
    -1,
    (gchar *) "Path",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "path",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_interface =
{
  {
    -1,
    (gchar *) "Interface",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "interface",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip_interface =
{
  {
    -1,
    (gchar *) "IpInterface",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip-interface",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_driver =
{
  {
    -1,
    (gchar *) "Driver",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "driver",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_driver_version =
{
  {
    -1,
    (gchar *) "DriverVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "driver-version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_firmware_version =
{
  {
    -1,
    (gchar *) "FirmwareVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "firmware-version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_capabilities =
{
  {
    -1,
    (gchar *) "Capabilities",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip4_address =
{
  {
    -1,
    (gchar *) "Ip4Address",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip4-address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_state_reason =
{
  {
    -1,
    (gchar *) "StateReason",
    (gchar *) "(uu)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state-reason",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_active_connection =
{
  {
    -1,
    (gchar *) "ActiveConnection",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-connection",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip4_config =
{
  {
    -1,
    (gchar *) "Ip4Config",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip4-config",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_dhcp4_config =
{
  {
    -1,
    (gchar *) "Dhcp4Config",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "dhcp4-config",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip6_config =
{
  {
    -1,
    (gchar *) "Ip6Config",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip6-config",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_dhcp6_config =
{
  {
    -1,
    (gchar *) "Dhcp6Config",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "dhcp6-config",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_managed =
{
  {
    -1,
    (gchar *) "Managed",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "managed",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_autoconnect =
{
  {
    -1,
    (gchar *) "Autoconnect",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "autoconnect",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_firmware_missing =
{
  {
    -1,
    (gchar *) "FirmwareMissing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "firmware-missing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_nm_plugin_missing =
{
  {
    -1,
    (gchar *) "NmPluginMissing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nm-plugin-missing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_device_type =
{
  {
    -1,
    (gchar *) "DeviceType",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_available_connections =
{
  {
    -1,
    (gchar *) "AvailableConnections",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-connections",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_physical_port_id =
{
  {
    -1,
    (gchar *) "PhysicalPortId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "physical-port-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_mtu =
{
  {
    -1,
    (gchar *) "Mtu",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mtu",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_metered =
{
  {
    -1,
    (gchar *) "Metered",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metered",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_lldp_neighbors =
{
  {
    -1,
    (gchar *) "LldpNeighbors",
    (gchar *) "aa{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "lldp-neighbors",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_real =
{
  {
    -1,
    (gchar *) "Real",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "real",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip4_connectivity =
{
  {
    -1,
    (gchar *) "Ip4Connectivity",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip4-connectivity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ip6_connectivity =
{
  {
    -1,
    (gchar *) "Ip6Connectivity",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ip6-connectivity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_interface_flags =
{
  {
    -1,
    (gchar *) "InterfaceFlags",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "interface-flags",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_hw_address =
{
  {
    -1,
    (gchar *) "HwAddress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hw-address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_property_info_ports =
{
  {
    -1,
    (gchar *) "Ports",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ports",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_device_property_info_pointers[] =
{
  &_nmdbus_device_property_info_udi.parent_struct,
  &_nmdbus_device_property_info_path.parent_struct,
  &_nmdbus_device_property_info_interface.parent_struct,
  &_nmdbus_device_property_info_ip_interface.parent_struct,
  &_nmdbus_device_property_info_driver.parent_struct,
  &_nmdbus_device_property_info_driver_version.parent_struct,
  &_nmdbus_device_property_info_firmware_version.parent_struct,
  &_nmdbus_device_property_info_capabilities.parent_struct,
  &_nmdbus_device_property_info_ip4_address.parent_struct,
  &_nmdbus_device_property_info_state.parent_struct,
  &_nmdbus_device_property_info_state_reason.parent_struct,
  &_nmdbus_device_property_info_active_connection.parent_struct,
  &_nmdbus_device_property_info_ip4_config.parent_struct,
  &_nmdbus_device_property_info_dhcp4_config.parent_struct,
  &_nmdbus_device_property_info_ip6_config.parent_struct,
  &_nmdbus_device_property_info_dhcp6_config.parent_struct,
  &_nmdbus_device_property_info_managed.parent_struct,
  &_nmdbus_device_property_info_autoconnect.parent_struct,
  &_nmdbus_device_property_info_firmware_missing.parent_struct,
  &_nmdbus_device_property_info_nm_plugin_missing.parent_struct,
  &_nmdbus_device_property_info_device_type.parent_struct,
  &_nmdbus_device_property_info_available_connections.parent_struct,
  &_nmdbus_device_property_info_physical_port_id.parent_struct,
  &_nmdbus_device_property_info_mtu.parent_struct,
  &_nmdbus_device_property_info_metered.parent_struct,
  &_nmdbus_device_property_info_lldp_neighbors.parent_struct,
  &_nmdbus_device_property_info_real.parent_struct,
  &_nmdbus_device_property_info_ip4_connectivity.parent_struct,
  &_nmdbus_device_property_info_ip6_connectivity.parent_struct,
  &_nmdbus_device_property_info_interface_flags.parent_struct,
  &_nmdbus_device_property_info_hw_address.parent_struct,
  &_nmdbus_device_property_info_ports.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_device_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.Device",
    (GDBusMethodInfo **) &_nmdbus_device_method_info_pointers,
    (GDBusSignalInfo **) &_nmdbus_device_signal_info_pointers,
    (GDBusPropertyInfo **) &_nmdbus_device_property_info_pointers,
    NULL
  },
  "device",
};


/**
 * nmdbus_device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct;
}

/**
 * nmdbus_device_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusDevice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "udi");
  g_object_class_override_property (klass, property_id_begin++, "path");
  g_object_class_override_property (klass, property_id_begin++, "interface");
  g_object_class_override_property (klass, property_id_begin++, "ip-interface");
  g_object_class_override_property (klass, property_id_begin++, "driver");
  g_object_class_override_property (klass, property_id_begin++, "driver-version");
  g_object_class_override_property (klass, property_id_begin++, "firmware-version");
  g_object_class_override_property (klass, property_id_begin++, "capabilities");
  g_object_class_override_property (klass, property_id_begin++, "ip4-address");
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "state-reason");
  g_object_class_override_property (klass, property_id_begin++, "active-connection");
  g_object_class_override_property (klass, property_id_begin++, "ip4-config");
  g_object_class_override_property (klass, property_id_begin++, "dhcp4-config");
  g_object_class_override_property (klass, property_id_begin++, "ip6-config");
  g_object_class_override_property (klass, property_id_begin++, "dhcp6-config");
  g_object_class_override_property (klass, property_id_begin++, "managed");
  g_object_class_override_property (klass, property_id_begin++, "autoconnect");
  g_object_class_override_property (klass, property_id_begin++, "firmware-missing");
  g_object_class_override_property (klass, property_id_begin++, "nm-plugin-missing");
  g_object_class_override_property (klass, property_id_begin++, "device-type");
  g_object_class_override_property (klass, property_id_begin++, "available-connections");
  g_object_class_override_property (klass, property_id_begin++, "physical-port-id");
  g_object_class_override_property (klass, property_id_begin++, "mtu");
  g_object_class_override_property (klass, property_id_begin++, "metered");
  g_object_class_override_property (klass, property_id_begin++, "lldp-neighbors");
  g_object_class_override_property (klass, property_id_begin++, "real");
  g_object_class_override_property (klass, property_id_begin++, "ip4-connectivity");
  g_object_class_override_property (klass, property_id_begin++, "ip6-connectivity");
  g_object_class_override_property (klass, property_id_begin++, "interface-flags");
  g_object_class_override_property (klass, property_id_begin++, "hw-address");
  g_object_class_override_property (klass, property_id_begin++, "ports");
  return property_id_begin - 1;
}



/**
 * NMDBusDevice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link>.
 */

/**
 * NMDBusDeviceIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #NMDBusDevice::handle-delete signal.
 * @handle_disconnect: Handler for the #NMDBusDevice::handle-disconnect signal.
 * @handle_get_applied_connection: Handler for the #NMDBusDevice::handle-get-applied-connection signal.
 * @handle_reapply: Handler for the #NMDBusDevice::handle-reapply signal.
 * @get_active_connection: Getter for the #NMDBusDevice:active-connection property.
 * @get_autoconnect: Getter for the #NMDBusDevice:autoconnect property.
 * @get_available_connections: Getter for the #NMDBusDevice:available-connections property.
 * @get_capabilities: Getter for the #NMDBusDevice:capabilities property.
 * @get_device_type: Getter for the #NMDBusDevice:device-type property.
 * @get_dhcp4_config: Getter for the #NMDBusDevice:dhcp4-config property.
 * @get_dhcp6_config: Getter for the #NMDBusDevice:dhcp6-config property.
 * @get_driver: Getter for the #NMDBusDevice:driver property.
 * @get_driver_version: Getter for the #NMDBusDevice:driver-version property.
 * @get_firmware_missing: Getter for the #NMDBusDevice:firmware-missing property.
 * @get_firmware_version: Getter for the #NMDBusDevice:firmware-version property.
 * @get_interface: Getter for the #NMDBusDevice:interface property.
 * @get_ip4_address: Getter for the #NMDBusDevice:ip4-address property.
 * @get_ip4_config: Getter for the #NMDBusDevice:ip4-config property.
 * @get_ip6_config: Getter for the #NMDBusDevice:ip6-config property.
 * @get_ip_interface: Getter for the #NMDBusDevice:ip-interface property.
 * @get_lldp_neighbors: Getter for the #NMDBusDevice:lldp-neighbors property.
 * @get_managed: Getter for the #NMDBusDevice:managed property.
 * @get_metered: Getter for the #NMDBusDevice:metered property.
 * @get_mtu: Getter for the #NMDBusDevice:mtu property.
 * @get_nm_plugin_missing: Getter for the #NMDBusDevice:nm-plugin-missing property.
 * @get_path: Getter for the #NMDBusDevice:path property.
 * @get_physical_port_id: Getter for the #NMDBusDevice:physical-port-id property.
 * @get_real: Getter for the #NMDBusDevice:real property.
 * @get_state: Getter for the #NMDBusDevice:state property.
 * @get_state_reason: Getter for the #NMDBusDevice:state-reason property.
 * @get_udi: Getter for the #NMDBusDevice:udi property.
 * @state_changed: Handler for the #NMDBusDevice::state-changed signal.
 * @get_ip4_connectivity: Getter for the #NMDBusDevice:ip4-connectivity property.
 * @get_ip6_connectivity: Getter for the #NMDBusDevice:ip6-connectivity property.
 * @get_interface_flags: Getter for the #NMDBusDevice:interface-flags property.
 * @get_hw_address: Getter for the #NMDBusDevice:hw-address property.
 * @get_ports: Getter for the #NMDBusDevice:ports property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link>.
 */

typedef NMDBusDeviceIface NMDBusDeviceInterface;
G_DEFINE_INTERFACE (NMDBusDevice, nmdbus_device, G_TYPE_OBJECT)

static void
nmdbus_device_default_init (NMDBusDeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NMDBusDevice::handle-reapply:
   * @object: A #NMDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   * @arg_version_id: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Reapply">Reapply()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_complete_reapply() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reapply",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceIface, handle_reapply),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_UINT64, G_TYPE_UINT);

  /**
   * NMDBusDevice::handle-get-applied-connection:
   * @object: A #NMDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.GetAppliedConnection">GetAppliedConnection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_complete_get_applied_connection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-applied-connection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceIface, handle_get_applied_connection),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * NMDBusDevice::handle-disconnect:
   * @object: A #NMDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Disconnect">Disconnect()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_complete_disconnect() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disconnect",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceIface, handle_disconnect),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusDevice::handle-delete:
   * @object: A #NMDBusDevice.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * NMDBusDevice::state-changed:
   * @object: A #NMDBusDevice.
   * @arg_new_state: Argument.
   * @arg_old_state: Argument.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusDevice:udi:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Udi">"Udi"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("udi", "Udi", "Udi", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Path">"Path"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("path", "Path", "Path", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:interface:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Interface">"Interface"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("interface", "Interface", "Interface", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip-interface:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.IpInterface">"IpInterface"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("ip-interface", "IpInterface", "IpInterface", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:driver:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Driver">"Driver"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("driver", "Driver", "Driver", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:driver-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DriverVersion">"DriverVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("driver-version", "DriverVersion", "DriverVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:firmware-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareVersion">"FirmwareVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("firmware-version", "FirmwareVersion", "FirmwareVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Capabilities">"Capabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("capabilities", "Capabilities", "Capabilities", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip4-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Address">"Ip4Address"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("ip4-address", "Ip4Address", "Ip4Address", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:state-reason:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.StateReason">"StateReason"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("state-reason", "StateReason", "StateReason", G_VARIANT_TYPE ("(uu)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:active-connection:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.ActiveConnection">"ActiveConnection"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("active-connection", "ActiveConnection", "ActiveConnection", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip4-config:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Config">"Ip4Config"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("ip4-config", "Ip4Config", "Ip4Config", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:dhcp4-config:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp4Config">"Dhcp4Config"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("dhcp4-config", "Dhcp4Config", "Dhcp4Config", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip6-config:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Config">"Ip6Config"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("ip6-config", "Ip6Config", "Ip6Config", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:dhcp6-config:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp6Config">"Dhcp6Config"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("dhcp6-config", "Dhcp6Config", "Dhcp6Config", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:managed:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Managed">"Managed"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("managed", "Managed", "Managed", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:autoconnect:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Autoconnect">"Autoconnect"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("autoconnect", "Autoconnect", "Autoconnect", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:firmware-missing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareMissing">"FirmwareMissing"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("firmware-missing", "FirmwareMissing", "FirmwareMissing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:nm-plugin-missing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.NmPluginMissing">"NmPluginMissing"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("nm-plugin-missing", "NmPluginMissing", "NmPluginMissing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:device-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DeviceType">"DeviceType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("device-type", "DeviceType", "DeviceType", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:available-connections:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.AvailableConnections">"AvailableConnections"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("available-connections", "AvailableConnections", "AvailableConnections", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:physical-port-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.PhysicalPortId">"PhysicalPortId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("physical-port-id", "PhysicalPortId", "PhysicalPortId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:mtu:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Mtu">"Mtu"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("mtu", "Mtu", "Mtu", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:metered:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Metered">"Metered"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("metered", "Metered", "Metered", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:lldp-neighbors:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.LldpNeighbors">"LldpNeighbors"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("lldp-neighbors", "LldpNeighbors", "LldpNeighbors", G_VARIANT_TYPE ("aa{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:real:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Real">"Real"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("real", "Real", "Real", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip4-connectivity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Connectivity">"Ip4Connectivity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.16
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("ip4-connectivity", "Ip4Connectivity", "Ip4Connectivity", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ip6-connectivity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Connectivity">"Ip6Connectivity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.16
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("ip6-connectivity", "Ip6Connectivity", "Ip6Connectivity", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:interface-flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.InterfaceFlags">"InterfaceFlags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.22
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("interface-flags", "InterfaceFlags", "InterfaceFlags", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:hw-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.HwAddress">"HwAddress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.24
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hw-address", "HwAddress", "HwAddress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDevice:ports:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ports">"Ports"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.34
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("ports", "Ports", "Ports", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_device_get_udi: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Udi">"Udi"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_udi() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_udi (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_udi (object);
}

/**
 * nmdbus_device_dup_udi: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Udi">"Udi"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_udi (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "udi", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_udi: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Udi">"Udi"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_udi (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "udi", value, NULL);
}

/**
 * nmdbus_device_get_path: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Path">"Path"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_path (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_path (object);
}

/**
 * nmdbus_device_dup_path: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Path">"Path"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_path (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "path", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_path: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Path">"Path"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_path (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "path", value, NULL);
}

/**
 * nmdbus_device_get_interface: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Interface">"Interface"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_interface() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_interface (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_interface (object);
}

/**
 * nmdbus_device_dup_interface: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Interface">"Interface"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_interface (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "interface", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_interface: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Interface">"Interface"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_interface (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "interface", value, NULL);
}

/**
 * nmdbus_device_get_ip_interface: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.IpInterface">"IpInterface"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_ip_interface() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_ip_interface (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip_interface (object);
}

/**
 * nmdbus_device_dup_ip_interface: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.IpInterface">"IpInterface"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_ip_interface (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "ip-interface", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_ip_interface: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.IpInterface">"IpInterface"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_ip_interface (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "ip-interface", value, NULL);
}

/**
 * nmdbus_device_get_driver: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Driver">"Driver"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_driver() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_driver (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_driver (object);
}

/**
 * nmdbus_device_dup_driver: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Driver">"Driver"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_driver (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "driver", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_driver: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Driver">"Driver"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_driver (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "driver", value, NULL);
}

/**
 * nmdbus_device_get_driver_version: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DriverVersion">"DriverVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_driver_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_driver_version (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_driver_version (object);
}

/**
 * nmdbus_device_dup_driver_version: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DriverVersion">"DriverVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_driver_version (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "driver-version", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_driver_version: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DriverVersion">"DriverVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_driver_version (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "driver-version", value, NULL);
}

/**
 * nmdbus_device_get_firmware_version: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareVersion">"FirmwareVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_firmware_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_firmware_version (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_firmware_version (object);
}

/**
 * nmdbus_device_dup_firmware_version: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareVersion">"FirmwareVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_firmware_version (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "firmware-version", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_firmware_version: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareVersion">"FirmwareVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_firmware_version (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "firmware-version", value, NULL);
}

/**
 * nmdbus_device_get_capabilities: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_capabilities (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_capabilities (object);
}

/**
 * nmdbus_device_set_capabilities: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Capabilities">"Capabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_capabilities (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "capabilities", value, NULL);
}

/**
 * nmdbus_device_get_ip4_address: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Address">"Ip4Address"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_ip4_address (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip4_address (object);
}

/**
 * nmdbus_device_set_ip4_address: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Address">"Ip4Address"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_ip4_address (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "ip4-address", value, NULL);
}

/**
 * nmdbus_device_get_state: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_state (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_state (object);
}

/**
 * nmdbus_device_set_state: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_state (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * nmdbus_device_get_state_reason: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.StateReason">"StateReason"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_state_reason() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_device_get_state_reason (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_state_reason (object);
}

/**
 * nmdbus_device_dup_state_reason: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.StateReason">"StateReason"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_device_dup_state_reason (NMDBusDevice *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "state-reason", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_state_reason: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.StateReason">"StateReason"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_state_reason (NMDBusDevice *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "state-reason", value, NULL);
}

/**
 * nmdbus_device_get_active_connection: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.ActiveConnection">"ActiveConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_active_connection() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_active_connection (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_active_connection (object);
}

/**
 * nmdbus_device_dup_active_connection: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.ActiveConnection">"ActiveConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_active_connection (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "active-connection", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_active_connection: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.ActiveConnection">"ActiveConnection"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_active_connection (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "active-connection", value, NULL);
}

/**
 * nmdbus_device_get_ip4_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Config">"Ip4Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_ip4_config() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_ip4_config (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip4_config (object);
}

/**
 * nmdbus_device_dup_ip4_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Config">"Ip4Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_ip4_config (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "ip4-config", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_ip4_config: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Config">"Ip4Config"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_ip4_config (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "ip4-config", value, NULL);
}

/**
 * nmdbus_device_get_dhcp4_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp4Config">"Dhcp4Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_dhcp4_config() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_dhcp4_config (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_dhcp4_config (object);
}

/**
 * nmdbus_device_dup_dhcp4_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp4Config">"Dhcp4Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_dhcp4_config (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "dhcp4-config", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_dhcp4_config: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp4Config">"Dhcp4Config"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_dhcp4_config (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "dhcp4-config", value, NULL);
}

/**
 * nmdbus_device_get_ip6_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Config">"Ip6Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_ip6_config() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_ip6_config (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip6_config (object);
}

/**
 * nmdbus_device_dup_ip6_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Config">"Ip6Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_ip6_config (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "ip6-config", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_ip6_config: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Config">"Ip6Config"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_ip6_config (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "ip6-config", value, NULL);
}

/**
 * nmdbus_device_get_dhcp6_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp6Config">"Dhcp6Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_dhcp6_config() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_dhcp6_config (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_dhcp6_config (object);
}

/**
 * nmdbus_device_dup_dhcp6_config: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp6Config">"Dhcp6Config"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_dhcp6_config (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "dhcp6-config", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_dhcp6_config: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Dhcp6Config">"Dhcp6Config"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_dhcp6_config (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "dhcp6-config", value, NULL);
}

/**
 * nmdbus_device_get_managed: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Managed">"Managed"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_get_managed (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_managed (object);
}

/**
 * nmdbus_device_set_managed: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Managed">"Managed"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_device_set_managed (NMDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "managed", value, NULL);
}

/**
 * nmdbus_device_get_autoconnect: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Autoconnect">"Autoconnect"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_get_autoconnect (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_autoconnect (object);
}

/**
 * nmdbus_device_set_autoconnect: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Autoconnect">"Autoconnect"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_device_set_autoconnect (NMDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "autoconnect", value, NULL);
}

/**
 * nmdbus_device_get_firmware_missing: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareMissing">"FirmwareMissing"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_get_firmware_missing (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_firmware_missing (object);
}

/**
 * nmdbus_device_set_firmware_missing: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.FirmwareMissing">"FirmwareMissing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_firmware_missing (NMDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "firmware-missing", value, NULL);
}

/**
 * nmdbus_device_get_nm_plugin_missing: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.NmPluginMissing">"NmPluginMissing"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_get_nm_plugin_missing (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_nm_plugin_missing (object);
}

/**
 * nmdbus_device_set_nm_plugin_missing: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.NmPluginMissing">"NmPluginMissing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_nm_plugin_missing (NMDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "nm-plugin-missing", value, NULL);
}

/**
 * nmdbus_device_get_device_type: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DeviceType">"DeviceType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_device_type (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_device_type (object);
}

/**
 * nmdbus_device_set_device_type: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.DeviceType">"DeviceType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_device_type (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "device-type", value, NULL);
}

/**
 * nmdbus_device_get_available_connections: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.AvailableConnections">"AvailableConnections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_available_connections() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_device_get_available_connections (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_available_connections (object);
}

/**
 * nmdbus_device_dup_available_connections: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.AvailableConnections">"AvailableConnections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_device_dup_available_connections (NMDBusDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "available-connections", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_available_connections: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.AvailableConnections">"AvailableConnections"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_available_connections (NMDBusDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "available-connections", value, NULL);
}

/**
 * nmdbus_device_get_physical_port_id: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.PhysicalPortId">"PhysicalPortId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_physical_port_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_get_physical_port_id (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_physical_port_id (object);
}

/**
 * nmdbus_device_dup_physical_port_id: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.PhysicalPortId">"PhysicalPortId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_dup_physical_port_id (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "physical-port-id", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_physical_port_id: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.PhysicalPortId">"PhysicalPortId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_physical_port_id (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "physical-port-id", value, NULL);
}

/**
 * nmdbus_device_get_mtu: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Mtu">"Mtu"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_mtu (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_mtu (object);
}

/**
 * nmdbus_device_set_mtu: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Mtu">"Mtu"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_mtu (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "mtu", value, NULL);
}

/**
 * nmdbus_device_get_metered: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Metered">"Metered"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_get_metered (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_metered (object);
}

/**
 * nmdbus_device_set_metered: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Metered">"Metered"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_metered (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "metered", value, NULL);
}

/**
 * nmdbus_device_get_lldp_neighbors: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.LldpNeighbors">"LldpNeighbors"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_lldp_neighbors() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_device_get_lldp_neighbors (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_lldp_neighbors (object);
}

/**
 * nmdbus_device_dup_lldp_neighbors: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.LldpNeighbors">"LldpNeighbors"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_device_dup_lldp_neighbors (NMDBusDevice *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "lldp-neighbors", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_lldp_neighbors: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.LldpNeighbors">"LldpNeighbors"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_lldp_neighbors (NMDBusDevice *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "lldp-neighbors", value, NULL);
}

/**
 * nmdbus_device_get_real: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Real">"Real"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_get_real (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_real (object);
}

/**
 * nmdbus_device_set_real: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Real">"Real"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_set_real (NMDBusDevice *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "real", value, NULL);
}

/**
 * nmdbus_device_get_ip4_connectivity: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Connectivity">"Ip4Connectivity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 1.16
 */
guint 
nmdbus_device_get_ip4_connectivity (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip4_connectivity (object);
}

/**
 * nmdbus_device_set_ip4_connectivity: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip4Connectivity">"Ip4Connectivity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.16
 */
void
nmdbus_device_set_ip4_connectivity (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "ip4-connectivity", value, NULL);
}

/**
 * nmdbus_device_get_ip6_connectivity: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Connectivity">"Ip6Connectivity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 1.16
 */
guint 
nmdbus_device_get_ip6_connectivity (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ip6_connectivity (object);
}

/**
 * nmdbus_device_set_ip6_connectivity: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ip6Connectivity">"Ip6Connectivity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.16
 */
void
nmdbus_device_set_ip6_connectivity (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "ip6-connectivity", value, NULL);
}

/**
 * nmdbus_device_get_interface_flags: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.InterfaceFlags">"InterfaceFlags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 1.22
 */
guint 
nmdbus_device_get_interface_flags (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_interface_flags (object);
}

/**
 * nmdbus_device_set_interface_flags: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.InterfaceFlags">"InterfaceFlags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.22
 */
void
nmdbus_device_set_interface_flags (NMDBusDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "interface-flags", value, NULL);
}

/**
 * nmdbus_device_get_hw_address: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_hw_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 1.24
 */
const gchar *
nmdbus_device_get_hw_address (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_hw_address (object);
}

/**
 * nmdbus_device_dup_hw_address: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 *
 * Since: 1.24
 */
gchar *
nmdbus_device_dup_hw_address (NMDBusDevice *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hw-address", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_hw_address: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.HwAddress">"HwAddress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.24
 */
void
nmdbus_device_set_hw_address (NMDBusDevice *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hw-address", value, NULL);
}

/**
 * nmdbus_device_get_ports: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ports">"Ports"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_dup_ports() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 *
 * Since: 1.34
 */
const gchar *const *
nmdbus_device_get_ports (NMDBusDevice *object)
{
  return NMDBUS_DEVICE_GET_IFACE (object)->get_ports (object);
}

/**
 * nmdbus_device_dup_ports: (skip)
 * @object: A #NMDBusDevice.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ports">"Ports"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 *
 * Since: 1.34
 */
gchar **
nmdbus_device_dup_ports (NMDBusDevice *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "ports", &value, NULL);
  return value;
}

/**
 * nmdbus_device_set_ports: (skip)
 * @object: A #NMDBusDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device.Ports">"Ports"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.34
 */
void
nmdbus_device_set_ports (NMDBusDevice *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "ports", value, NULL);
}

/**
 * nmdbus_device_emit_state_changed:
 * @object: A #NMDBusDevice.
 * @arg_new_state: Argument to pass with the signal.
 * @arg_old_state: Argument to pass with the signal.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
nmdbus_device_emit_state_changed (
    NMDBusDevice *object,
    guint arg_new_state,
    guint arg_old_state,
    guint arg_reason)
{
  g_signal_emit_by_name (object, "state-changed", arg_new_state, arg_old_state, arg_reason);
}

/**
 * nmdbus_device_call_reapply:
 * @proxy: A #NMDBusDeviceProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_version_id: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Reapply">Reapply()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_call_reapply_finish() to get the result of the operation.
 *
 * See nmdbus_device_call_reapply_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_call_reapply (
    NMDBusDevice *proxy,
    GVariant *arg_connection,
    guint64 arg_version_id,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reapply",
    g_variant_new ("(@a{sa{sv}}tu)",
                   arg_connection,
                   arg_version_id,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_call_reapply_finish:
 * @proxy: A #NMDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_call_reapply().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_call_reapply().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_reapply_finish (
    NMDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_reapply_sync:
 * @proxy: A #NMDBusDeviceProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_version_id: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Reapply">Reapply()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_call_reapply() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_reapply_sync (
    NMDBusDevice *proxy,
    GVariant *arg_connection,
    guint64 arg_version_id,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reapply",
    g_variant_new ("(@a{sa{sv}}tu)",
                   arg_connection,
                   arg_version_id,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_get_applied_connection:
 * @proxy: A #NMDBusDeviceProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.GetAppliedConnection">GetAppliedConnection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_call_get_applied_connection_finish() to get the result of the operation.
 *
 * See nmdbus_device_call_get_applied_connection_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_call_get_applied_connection (
    NMDBusDevice *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppliedConnection",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_call_get_applied_connection_finish:
 * @proxy: A #NMDBusDeviceProxy.
 * @out_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_call_get_applied_connection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_call_get_applied_connection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_get_applied_connection_finish (
    NMDBusDevice *proxy,
    GVariant **out_connection,
    guint64 *out_version_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}}t)",
                 out_connection,
                 out_version_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_get_applied_connection_sync:
 * @proxy: A #NMDBusDeviceProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.GetAppliedConnection">GetAppliedConnection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_call_get_applied_connection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_get_applied_connection_sync (
    NMDBusDevice *proxy,
    guint arg_flags,
    GVariant **out_connection,
    guint64 *out_version_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppliedConnection",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}}t)",
                 out_connection,
                 out_version_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_disconnect:
 * @proxy: A #NMDBusDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Disconnect">Disconnect()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_call_disconnect_finish() to get the result of the operation.
 *
 * See nmdbus_device_call_disconnect_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_call_disconnect (
    NMDBusDevice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_call_disconnect_finish:
 * @proxy: A #NMDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_call_disconnect().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_call_disconnect().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_disconnect_finish (
    NMDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_disconnect_sync:
 * @proxy: A #NMDBusDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Disconnect">Disconnect()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_call_disconnect() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_disconnect_sync (
    NMDBusDevice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disconnect",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_delete:
 * @proxy: A #NMDBusDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_call_delete_finish() to get the result of the operation.
 *
 * See nmdbus_device_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_call_delete (
    NMDBusDevice *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_call_delete_finish:
 * @proxy: A #NMDBusDeviceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_delete_finish (
    NMDBusDevice *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_call_delete_sync:
 * @proxy: A #NMDBusDeviceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_call_delete_sync (
    NMDBusDevice *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_complete_reapply:
 * @object: A #NMDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Reapply">Reapply()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_complete_reapply (
    NMDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_device_complete_get_applied_connection:
 * @object: A #NMDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @connection: Parameter to return.
 * @version_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.GetAppliedConnection">GetAppliedConnection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_complete_get_applied_connection (
    NMDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *connection,
    guint64 version_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}}t)",
                   connection,
                   version_id));
}

/**
 * nmdbus_device_complete_disconnect:
 * @object: A #NMDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Disconnect">Disconnect()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_complete_disconnect (
    NMDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_device_complete_delete:
 * @object: A #NMDBusDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_complete_delete (
    NMDBusDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceProxy:
 *
 * The #NMDBusDeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceProxy.
 */

struct _NMDBusDeviceProxyPrivate
{
  GData *qdata;
};

static void nmdbus_device_proxy_iface_init (NMDBusDeviceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceProxy, nmdbus_device_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusDeviceProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE, nmdbus_device_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceProxy, nmdbus_device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE, nmdbus_device_proxy_iface_init))

#endif
static void
nmdbus_device_proxy_finalize (GObject *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_device_proxy_parent_class)->finalize (object);
}

static void
nmdbus_device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 32);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_device_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.Device: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 32);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.Device", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_device_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
nmdbus_device_proxy_get_udi (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Udi");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_path (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Path");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_interface (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Interface");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_ip_interface (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IpInterface");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_driver (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Driver");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_driver_version (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DriverVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_firmware_version (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FirmwareVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_capabilities (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Capabilities");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_ip4_address (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ip4Address");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_state (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nmdbus_device_proxy_get_state_reason (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "StateReason");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
nmdbus_device_proxy_get_active_connection (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveConnection");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_ip4_config (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ip4Config");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_dhcp4_config (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Dhcp4Config");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_ip6_config (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ip6Config");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_dhcp6_config (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Dhcp6Config");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_device_proxy_get_managed (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Managed");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_device_proxy_get_autoconnect (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Autoconnect");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_device_proxy_get_firmware_missing (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FirmwareMissing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_device_proxy_get_nm_plugin_missing (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NmPluginMissing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_device_type (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DeviceType");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_device_proxy_get_available_connections (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "AvailableConnections");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableConnections");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "AvailableConnections", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_physical_port_id (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PhysicalPortId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_mtu (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Mtu");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_metered (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metered");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nmdbus_device_proxy_get_lldp_neighbors (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LldpNeighbors");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gboolean 
nmdbus_device_proxy_get_real (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Real");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_ip4_connectivity (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ip4Connectivity");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_ip6_connectivity (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ip6Connectivity");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_proxy_get_interface_flags (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InterfaceFlags");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_proxy_get_hw_address (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HwAddress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_device_proxy_get_ports (NMDBusDevice *object)
{
  NMDBusDeviceProxy *proxy = NMDBUS_DEVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Ports");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ports");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Ports", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_device_proxy_init (NMDBusDeviceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_device_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_DEVICE_PROXY, NMDBusDeviceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_device_interface_info ());
}

static void
nmdbus_device_proxy_class_init (NMDBusDeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_device_proxy_finalize;
  gobject_class->get_property = nmdbus_device_proxy_get_property;
  gobject_class->set_property = nmdbus_device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_device_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_device_proxy_g_properties_changed;

  nmdbus_device_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceProxyPrivate));
#endif
}

static void
nmdbus_device_proxy_iface_init (NMDBusDeviceIface *iface)
{
  iface->get_udi = nmdbus_device_proxy_get_udi;
  iface->get_path = nmdbus_device_proxy_get_path;
  iface->get_interface = nmdbus_device_proxy_get_interface;
  iface->get_ip_interface = nmdbus_device_proxy_get_ip_interface;
  iface->get_driver = nmdbus_device_proxy_get_driver;
  iface->get_driver_version = nmdbus_device_proxy_get_driver_version;
  iface->get_firmware_version = nmdbus_device_proxy_get_firmware_version;
  iface->get_capabilities = nmdbus_device_proxy_get_capabilities;
  iface->get_ip4_address = nmdbus_device_proxy_get_ip4_address;
  iface->get_state = nmdbus_device_proxy_get_state;
  iface->get_state_reason = nmdbus_device_proxy_get_state_reason;
  iface->get_active_connection = nmdbus_device_proxy_get_active_connection;
  iface->get_ip4_config = nmdbus_device_proxy_get_ip4_config;
  iface->get_dhcp4_config = nmdbus_device_proxy_get_dhcp4_config;
  iface->get_ip6_config = nmdbus_device_proxy_get_ip6_config;
  iface->get_dhcp6_config = nmdbus_device_proxy_get_dhcp6_config;
  iface->get_managed = nmdbus_device_proxy_get_managed;
  iface->get_autoconnect = nmdbus_device_proxy_get_autoconnect;
  iface->get_firmware_missing = nmdbus_device_proxy_get_firmware_missing;
  iface->get_nm_plugin_missing = nmdbus_device_proxy_get_nm_plugin_missing;
  iface->get_device_type = nmdbus_device_proxy_get_device_type;
  iface->get_available_connections = nmdbus_device_proxy_get_available_connections;
  iface->get_physical_port_id = nmdbus_device_proxy_get_physical_port_id;
  iface->get_mtu = nmdbus_device_proxy_get_mtu;
  iface->get_metered = nmdbus_device_proxy_get_metered;
  iface->get_lldp_neighbors = nmdbus_device_proxy_get_lldp_neighbors;
  iface->get_real = nmdbus_device_proxy_get_real;
  iface->get_ip4_connectivity = nmdbus_device_proxy_get_ip4_connectivity;
  iface->get_ip6_connectivity = nmdbus_device_proxy_get_ip6_connectivity;
  iface->get_interface_flags = nmdbus_device_proxy_get_interface_flags;
  iface->get_hw_address = nmdbus_device_proxy_get_hw_address;
  iface->get_ports = nmdbus_device_proxy_get_ports;
}

/**
 * nmdbus_device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device", NULL);
}

/**
 * nmdbus_device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDevice *
nmdbus_device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDevice *
nmdbus_device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE (ret);
  else
    return NULL;
}


/**
 * nmdbus_device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device", NULL);
}

/**
 * nmdbus_device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDevice *
nmdbus_device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDevice *
nmdbus_device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceSkeleton:
 *
 * The #NMDBusDeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceSkeleton.
 */

struct _NMDBusDeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_device_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_device_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_device_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_device_skeleton_vtable =
{
  _nmdbus_device_skeleton_handle_method_call,
  _nmdbus_device_skeleton_handle_get_property,
  _nmdbus_device_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_device_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_device_skeleton_vtable;
}

static GVariant *
nmdbus_device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_device_emit_changed (gpointer user_data);

static void
nmdbus_device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_device_emit_changed (skeleton);
}

static void
_nmdbus_device_on_signal_state_changed (
    NMDBusDevice *object,
    guint arg_new_state,
    guint arg_old_state,
    guint arg_reason)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uuu)",
                   arg_new_state,
                   arg_old_state,
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nmdbus_device_skeleton_iface_init (NMDBusDeviceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceSkeleton, nmdbus_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusDeviceSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE, nmdbus_device_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceSkeleton, nmdbus_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE, nmdbus_device_skeleton_iface_init))

#endif
static void
nmdbus_device_skeleton_finalize (GObject *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 32; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_device_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_device_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 32);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_device_emit_changed (gpointer user_data)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.Device",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_device_schedule_emit_changed (NMDBusDeviceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_device_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_device_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_device_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_device_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 32);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_device_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_device_skeleton_init (NMDBusDeviceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_device_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_DEVICE_SKELETON, NMDBusDeviceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 32);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[26], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[27], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[28], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[29], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[30], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[31], G_TYPE_STRV);
}

static const gchar *
nmdbus_device_skeleton_get_udi (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_path (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_interface (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_ip_interface (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_driver (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_driver_version (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_firmware_version (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_capabilities (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_ip4_address (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_state (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_device_skeleton_get_state_reason (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_active_connection (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_ip4_config (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_dhcp4_config (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_ip6_config (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_dhcp6_config (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_skeleton_get_managed (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_skeleton_get_autoconnect (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_skeleton_get_firmware_missing (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_skeleton_get_nm_plugin_missing (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_device_type (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_device_skeleton_get_available_connections (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_physical_port_id (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_mtu (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_metered (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_device_skeleton_get_lldp_neighbors (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[25]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_skeleton_get_real (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[26]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_ip4_connectivity (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[27]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_ip6_connectivity (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[28]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_skeleton_get_interface_flags (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[29]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_skeleton_get_hw_address (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[30]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_device_skeleton_get_ports (NMDBusDevice *object)
{
  NMDBusDeviceSkeleton *skeleton = NMDBUS_DEVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[31]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_device_skeleton_class_init (NMDBusDeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_device_skeleton_finalize;
  gobject_class->get_property = nmdbus_device_skeleton_get_property;
  gobject_class->set_property = nmdbus_device_skeleton_set_property;
  gobject_class->notify       = nmdbus_device_skeleton_notify;


  nmdbus_device_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_device_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceSkeletonPrivate));
#endif
}

static void
nmdbus_device_skeleton_iface_init (NMDBusDeviceIface *iface)
{
  iface->state_changed = _nmdbus_device_on_signal_state_changed;
  iface->get_udi = nmdbus_device_skeleton_get_udi;
  iface->get_path = nmdbus_device_skeleton_get_path;
  iface->get_interface = nmdbus_device_skeleton_get_interface;
  iface->get_ip_interface = nmdbus_device_skeleton_get_ip_interface;
  iface->get_driver = nmdbus_device_skeleton_get_driver;
  iface->get_driver_version = nmdbus_device_skeleton_get_driver_version;
  iface->get_firmware_version = nmdbus_device_skeleton_get_firmware_version;
  iface->get_capabilities = nmdbus_device_skeleton_get_capabilities;
  iface->get_ip4_address = nmdbus_device_skeleton_get_ip4_address;
  iface->get_state = nmdbus_device_skeleton_get_state;
  iface->get_state_reason = nmdbus_device_skeleton_get_state_reason;
  iface->get_active_connection = nmdbus_device_skeleton_get_active_connection;
  iface->get_ip4_config = nmdbus_device_skeleton_get_ip4_config;
  iface->get_dhcp4_config = nmdbus_device_skeleton_get_dhcp4_config;
  iface->get_ip6_config = nmdbus_device_skeleton_get_ip6_config;
  iface->get_dhcp6_config = nmdbus_device_skeleton_get_dhcp6_config;
  iface->get_managed = nmdbus_device_skeleton_get_managed;
  iface->get_autoconnect = nmdbus_device_skeleton_get_autoconnect;
  iface->get_firmware_missing = nmdbus_device_skeleton_get_firmware_missing;
  iface->get_nm_plugin_missing = nmdbus_device_skeleton_get_nm_plugin_missing;
  iface->get_device_type = nmdbus_device_skeleton_get_device_type;
  iface->get_available_connections = nmdbus_device_skeleton_get_available_connections;
  iface->get_physical_port_id = nmdbus_device_skeleton_get_physical_port_id;
  iface->get_mtu = nmdbus_device_skeleton_get_mtu;
  iface->get_metered = nmdbus_device_skeleton_get_metered;
  iface->get_lldp_neighbors = nmdbus_device_skeleton_get_lldp_neighbors;
  iface->get_real = nmdbus_device_skeleton_get_real;
  iface->get_ip4_connectivity = nmdbus_device_skeleton_get_ip4_connectivity;
  iface->get_ip6_connectivity = nmdbus_device_skeleton_get_ip6_connectivity;
  iface->get_interface_flags = nmdbus_device_skeleton_get_interface_flags;
  iface->get_hw_address = nmdbus_device_skeleton_get_hw_address;
  iface->get_ports = nmdbus_device_skeleton_get_ports;
}

/**
 * nmdbus_device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device.top_of_page">org.freedesktop.NetworkManager.Device</link>.
 *
 * Returns: (transfer full) (type NMDBusDeviceSkeleton): The skeleton object.
 */
NMDBusDevice *
nmdbus_device_skeleton_new (void)
{
  return NMDBUS_DEVICE (g_object_new (NMDBUS_TYPE_DEVICE_SKELETON, NULL));
}

