// ui/base/ime/mojom/ime_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/ime/mojom/ime_types.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "ui/base/ime/mojom/ime_types.mojom-params-data.h"
namespace ui {
namespace mojom {

std::ostream& operator<<(std::ostream& os, TextInputMode value) {
  switch(value) {
    case TextInputMode::kDefault:
      return os << "TextInputMode::kDefault";
    case TextInputMode::kNone:
      return os << "TextInputMode::kNone";
    case TextInputMode::kText:
      return os << "TextInputMode::kText";
    case TextInputMode::kTel:
      return os << "TextInputMode::kTel";
    case TextInputMode::kUrl:
      return os << "TextInputMode::kUrl";
    case TextInputMode::kEmail:
      return os << "TextInputMode::kEmail";
    case TextInputMode::kNumeric:
      return os << "TextInputMode::kNumeric";
    case TextInputMode::kDecimal:
      return os << "TextInputMode::kDecimal";
    case TextInputMode::kSearch:
      return os << "TextInputMode::kSearch";
    default:
      return os << "Unknown TextInputMode value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, TextInputAction value) {
  switch(value) {
    case TextInputAction::kDefault:
      return os << "TextInputAction::kDefault";
    case TextInputAction::kEnter:
      return os << "TextInputAction::kEnter";
    case TextInputAction::kDone:
      return os << "TextInputAction::kDone";
    case TextInputAction::kGo:
      return os << "TextInputAction::kGo";
    case TextInputAction::kNext:
      return os << "TextInputAction::kNext";
    case TextInputAction::kPrevious:
      return os << "TextInputAction::kPrevious";
    case TextInputAction::kSearch:
      return os << "TextInputAction::kSearch";
    case TextInputAction::kSend:
      return os << "TextInputAction::kSend";
    default:
      return os << "Unknown TextInputAction value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, TextInputType value) {
  switch(value) {
    case TextInputType::NONE:
      return os << "TextInputType::NONE";
    case TextInputType::TEXT:
      return os << "TextInputType::TEXT";
    case TextInputType::PASSWORD:
      return os << "TextInputType::PASSWORD";
    case TextInputType::SEARCH:
      return os << "TextInputType::SEARCH";
    case TextInputType::EMAIL:
      return os << "TextInputType::EMAIL";
    case TextInputType::NUMBER:
      return os << "TextInputType::NUMBER";
    case TextInputType::TELEPHONE:
      return os << "TextInputType::TELEPHONE";
    case TextInputType::URL:
      return os << "TextInputType::URL";
    case TextInputType::DATE:
      return os << "TextInputType::DATE";
    case TextInputType::DATE_TIME:
      return os << "TextInputType::DATE_TIME";
    case TextInputType::DATE_TIME_LOCAL:
      return os << "TextInputType::DATE_TIME_LOCAL";
    case TextInputType::MONTH:
      return os << "TextInputType::MONTH";
    case TextInputType::TIME:
      return os << "TextInputType::TIME";
    case TextInputType::WEEK:
      return os << "TextInputType::WEEK";
    case TextInputType::TEXT_AREA:
      return os << "TextInputType::TEXT_AREA";
    case TextInputType::CONTENT_EDITABLE:
      return os << "TextInputType::CONTENT_EDITABLE";
    case TextInputType::DATE_TIME_FIELD:
      return os << "TextInputType::DATE_TIME_FIELD";
    case TextInputType::TYPE_NULL:
      return os << "TextInputType::{TYPE_NULL, MAX}";
    default:
      return os << "Unknown TextInputType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanType value) {
  switch(value) {
    case ImeTextSpanType::kComposition:
      return os << "ImeTextSpanType::kComposition";
    case ImeTextSpanType::kSuggestion:
      return os << "ImeTextSpanType::kSuggestion";
    case ImeTextSpanType::kMisspellingSuggestion:
      return os << "ImeTextSpanType::kMisspellingSuggestion";
    case ImeTextSpanType::kAutocorrect:
      return os << "ImeTextSpanType::kAutocorrect";
    default:
      return os << "Unknown ImeTextSpanType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanThickness value) {
  switch(value) {
    case ImeTextSpanThickness::kNone:
      return os << "ImeTextSpanThickness::kNone";
    case ImeTextSpanThickness::kThin:
      return os << "ImeTextSpanThickness::kThin";
    case ImeTextSpanThickness::kThick:
      return os << "ImeTextSpanThickness::kThick";
    default:
      return os << "Unknown ImeTextSpanThickness value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ImeTextSpanUnderlineStyle value) {
  switch(value) {
    case ImeTextSpanUnderlineStyle::kNone:
      return os << "ImeTextSpanUnderlineStyle::kNone";
    case ImeTextSpanUnderlineStyle::kSolid:
      return os << "ImeTextSpanUnderlineStyle::kSolid";
    case ImeTextSpanUnderlineStyle::kDot:
      return os << "ImeTextSpanUnderlineStyle::kDot";
    case ImeTextSpanUnderlineStyle::kDash:
      return os << "ImeTextSpanUnderlineStyle::kDash";
    case ImeTextSpanUnderlineStyle::kSquiggle:
      return os << "ImeTextSpanUnderlineStyle::kSquiggle";
    default:
      return os << "Unknown ImeTextSpanUnderlineStyle value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool ImeTextSpan_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImeTextSpan_Data* object = static_cast<const ImeTextSpan_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::ui::mojom::internal::ImeTextSpanType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanThickness_Data
        ::Validate(object->thickness, validation_context))
    return false;


  if (!::ui::mojom::internal::ImeTextSpanUnderlineStyle_Data
        ::Validate(object->underline_style, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams suggestions_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  return true;
}

ImeTextSpan_Data::ImeTextSpan_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui