/* contacts-avatar.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-avatar.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
typedef struct _ContactsAvatarPrivate ContactsAvatarPrivate;
enum  {
	CONTACTS_AVATAR_0_PROPERTY,
	CONTACTS_AVATAR_NUM_PROPERTIES
};
static GParamSpec* contacts_avatar_properties[CONTACTS_AVATAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsAvatarLoadAvatarData ContactsAvatarLoadAvatarData;
typedef struct _ContactsAvatarReloadData ContactsAvatarReloadData;

struct _ContactsAvatar {
	AdwBin parent_instance;
	ContactsAvatarPrivate * priv;
};

struct _ContactsAvatarClass {
	AdwBinClass parent_class;
};

struct _ContactsAvatarPrivate {
	FolksIndividual* individual;
	gint avatar_size;
	gboolean load_avatar_started;
};

struct _ContactsAvatarLoadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatar* self;
	gboolean _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	GLoadableIcon* _tmp3_;
	GLoadableIcon* _tmp4_;
	GInputStream* stream;
	FolksIndividual* _tmp5_;
	GLoadableIcon* _tmp6_;
	GLoadableIcon* _tmp7_;
	GInputStream* _tmp8_;
	GdkPixbuf* pixbuf;
	GInputStream* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GError* e;
	FolksIndividual* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _ContactsAvatarReloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatar* self;
};

static gint ContactsAvatar_private_offset;
static gpointer contacts_avatar_parent_class = NULL;

VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
static gchar* contacts_avatar_find_display_name (ContactsAvatar* self);
VALA_EXTERN void contacts_avatar_load_avatar (ContactsAvatar* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void contacts_avatar_load_avatar_finish (ContactsAvatar* self,
                                         GAsyncResult* _res_);
static void contacts_avatar_load_avatar_data_free (gpointer _data);
static gboolean contacts_avatar_load_avatar_co (ContactsAvatarLoadAvatarData* _data_);
static void contacts_avatar_load_avatar_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
VALA_EXTERN void contacts_avatar_set_pixbuf (ContactsAvatar* self,
                                 GdkPixbuf* a_pixbuf);
static void contacts_avatar_reload_data_free (gpointer _data);
VALA_EXTERN void contacts_avatar_reload (ContactsAvatar* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void contacts_avatar_reload_finish (ContactsAvatar* self,
                                    GAsyncResult* _res_);
static gboolean contacts_avatar_reload_co (ContactsAvatarReloadData* _data_);
static void contacts_avatar_reload_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static const gchar* contacts_avatar_look_up_alias_for_display_name (ContactsAvatar* self,
                                                             FolksPersona* p);
static gchar* contacts_avatar_look_up_name_details_for_display_name (ContactsAvatar* self,
                                                              FolksPersona* p);
static void contacts_avatar_finalize (GObject * obj);
static GType contacts_avatar_get_type_once (void);

static inline gpointer
contacts_avatar_get_instance_private (ContactsAvatar* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAvatar_private_offset);
}

ContactsAvatar*
contacts_avatar_construct (GType object_type,
                           gint size,
                           FolksIndividual* individual)
{
	ContactsAvatar * self = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	gboolean show_initials = FALSE;
	FolksIndividual* _tmp1_;
	const gchar* _tmp8_;
	AdwAvatar* _tmp9_;
	AdwAvatar* _tmp10_;
	self = (ContactsAvatar*) g_object_new (object_type, NULL);
	self->priv->individual = individual;
	self->priv->avatar_size = size;
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	show_initials = FALSE;
	_tmp1_ = self->priv->individual;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = contacts_avatar_find_display_name (self);
		_g_free0 (name);
		name = _tmp2_;
		_tmp3_ = name;
		if (g_strcmp0 (_tmp3_, "") == 0) {
			FolksIndividual* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = self->priv->individual;
			_tmp5_ = folks_individual_get_display_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (name);
			name = _tmp7_;
		} else {
			show_initials = TRUE;
		}
	}
	_tmp8_ = name;
	_tmp9_ = (AdwAvatar*) adw_avatar_new (size, _tmp8_, show_initials);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	contacts_avatar_load_avatar (self, NULL, NULL);
	_g_free0 (name);
	return self;
}

ContactsAvatar*
contacts_avatar_new (gint size,
                     FolksIndividual* individual)
{
	return contacts_avatar_construct (CONTACTS_TYPE_AVATAR, size, individual);
}

static void
contacts_avatar_load_avatar_data_free (gpointer _data)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarLoadAvatarData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_avatar_load_avatar (ContactsAvatar* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ContactsAvatarLoadAvatarData* _data_;
	ContactsAvatar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarLoadAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_load_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_avatar_load_avatar_co (_data_);
}

void
contacts_avatar_load_avatar_finish (ContactsAvatar* self,
                                    GAsyncResult* _res_)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_avatar_load_avatar_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_avatar_load_avatar_co (_data_);
}

static gboolean
contacts_avatar_load_avatar_co (ContactsAvatarLoadAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->load_avatar_started) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->individual;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->individual;
		_data_->_tmp3_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->load_avatar_started = TRUE;
	{
		_data_->_tmp5_ = _data_->self->priv->individual;
		_data_->_tmp6_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		g_loadable_icon_load_async (_data_->_tmp7_, _data_->self->priv->avatar_size, NULL, contacts_avatar_load_avatar_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = g_loadable_icon_load_finish (_data_->_tmp7_, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->stream;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async (_data_->_tmp9_, _data_->self->priv->avatar_size, _data_->self->priv->avatar_size, TRUE, NULL, contacts_avatar_load_avatar_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->pixbuf;
		contacts_avatar_set_pixbuf (_data_->self, _data_->_tmp11_);
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->individual;
		_data_->_tmp13_ = folks_individual_get_display_name (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->e;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning ("contacts-avatar.vala:74: Couldn't load avatar of '%s': %s", _data_->_tmp14_, _data_->_tmp16_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_avatar_reload_data_free (gpointer _data)
{
	ContactsAvatarReloadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarReloadData, _data_);
}

void
contacts_avatar_reload (ContactsAvatar* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	ContactsAvatarReloadData* _data_;
	ContactsAvatar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarReloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_reload_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_avatar_reload_co (_data_);
}

void
contacts_avatar_reload_finish (ContactsAvatar* self,
                               GAsyncResult* _res_)
{
	ContactsAvatarReloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Forces a reload of the avatar (e.g. after a property change).
   */
static void
contacts_avatar_reload_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	ContactsAvatarReloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_avatar_reload_co (_data_);
}

static gboolean
contacts_avatar_reload_co (ContactsAvatarReloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->load_avatar_started = FALSE;
	_data_->_state_ = 1;
	contacts_avatar_load_avatar (_data_->self, contacts_avatar_reload_ready, _data_);
	return FALSE;
	_state_1:
	contacts_avatar_load_avatar_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Manually set the avatar to the given pixbuf, even if the contact has an avatar.
   */
void
contacts_avatar_set_pixbuf (ContactsAvatar* self,
                            GdkPixbuf* a_pixbuf)
{
	g_return_if_fail (self != NULL);
	if (a_pixbuf != NULL) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GdkTexture* _tmp2_;
		GdkTexture* _tmp3_;
		_tmp0_ = adw_bin_get_child ((AdwBin*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gdk_texture_new_for_pixbuf (a_pixbuf);
		_tmp3_ = _tmp2_;
		adw_avatar_set_custom_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, adw_avatar_get_type (), AdwAvatar), (GdkPaintable*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	} else {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = adw_bin_get_child ((AdwBin*) self);
		_tmp5_ = _tmp4_;
		adw_avatar_set_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, adw_avatar_get_type (), AdwAvatar), "avatar-default-symbolic");
	}
}

static gchar*
contacts_avatar_find_display_name (ContactsAvatar* self)
{
	FolksPersona* primary_persona = NULL;
	const gchar* alias = NULL;
	FolksPersona* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp40_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	primary_persona = NULL;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->priv->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp4_ = _p_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			p = (FolksPersona*) _tmp6_;
			_tmp7_ = p;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_is_primary_store (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				FolksPersona* _tmp12_;
				_tmp12_ = p;
				primary_persona = _tmp12_;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp13_ = primary_persona;
	_tmp14_ = contacts_avatar_look_up_alias_for_display_name (self, _tmp13_);
	alias = _tmp14_;
	_tmp15_ = alias;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = alias;
		_tmp17_ = g_strdup (_tmp16_);
		result = _tmp17_;
		return result;
	}
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeIterator* _tmp21_;
		_tmp18_ = self->priv->individual;
		_tmp19_ = folks_individual_get_personas (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_p_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp23_;
			gpointer _tmp24_;
			FolksPersona* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp22_ = _p_it;
			if (!gee_iterator_next (_tmp22_)) {
				break;
			}
			_tmp23_ = _p_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			p = (FolksPersona*) _tmp24_;
			_tmp25_ = p;
			_tmp26_ = contacts_avatar_look_up_alias_for_display_name (self, _tmp25_);
			alias = _tmp26_;
			_tmp27_ = alias;
			if (g_strcmp0 (_tmp27_, "") != 0) {
				const gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp28_ = alias;
				_tmp29_ = g_strdup (_tmp28_);
				result = _tmp29_;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp30_;
		GeeSet* _tmp31_;
		GeeSet* _tmp32_;
		GeeIterator* _tmp33_;
		_tmp30_ = self->priv->individual;
		_tmp31_ = folks_individual_get_personas (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
		_p_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp35_;
			gpointer _tmp36_;
			gchar* name = NULL;
			FolksPersona* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp34_ = _p_it;
			if (!gee_iterator_next (_tmp34_)) {
				break;
			}
			_tmp35_ = _p_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			p = (FolksPersona*) _tmp36_;
			_tmp37_ = p;
			_tmp38_ = contacts_avatar_look_up_name_details_for_display_name (self, _tmp37_);
			name = _tmp38_;
			_tmp39_ = name;
			if (g_strcmp0 (_tmp39_, "") != 0) {
				result = name;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_free0 (name);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp40_ = g_strdup ("");
	result = _tmp40_;
	return result;
}

static const gchar*
contacts_avatar_look_up_alias_for_display_name (ContactsAvatar* self,
                                                FolksPersona* p)
{
	FolksAliasDetails* a = NULL;
	gboolean _tmp0_ = FALSE;
	FolksAliasDetails* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	a = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_ALIAS_DETAILS) ? ((FolksAliasDetails*) p) : NULL;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		FolksAliasDetails* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = a;
		_tmp3_ = folks_alias_details_get_alias (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FolksAliasDetails* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = a;
		_tmp6_ = folks_alias_details_get_alias (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	}
	result = "";
	return result;
}

static gchar*
contacts_avatar_look_up_name_details_for_display_name (ContactsAvatar* self,
                                                       FolksPersona* p)
{
	FolksNameDetails* n = NULL;
	FolksNameDetails* _tmp0_;
	gchar* _tmp26_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	n = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) p) : NULL;
	_tmp0_ = n;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		FolksNameDetails* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = n;
		_tmp3_ = folks_name_details_get_full_name (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			FolksNameDetails* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = n;
			_tmp6_ = folks_name_details_get_full_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = g_strcmp0 (_tmp7_, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			FolksNameDetails* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = n;
			_tmp9_ = folks_name_details_get_full_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		} else {
			FolksNameDetails* _tmp12_;
			FolksStructuredName* _tmp13_;
			FolksStructuredName* _tmp14_;
			_tmp12_ = n;
			_tmp13_ = folks_name_details_get_structured_name (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				FolksNameDetails* _tmp15_;
				FolksStructuredName* _tmp16_;
				FolksStructuredName* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = n;
				_tmp16_ = folks_name_details_get_structured_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = folks_structured_name_to_string (_tmp17_);
				result = _tmp18_;
				return result;
			} else {
				FolksNameDetails* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp19_ = n;
				_tmp20_ = folks_name_details_get_nickname (_tmp19_);
				_tmp21_ = _tmp20_;
				if (g_strcmp0 (_tmp21_, "") != 0) {
					FolksNameDetails* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp22_ = n;
					_tmp23_ = folks_name_details_get_nickname (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strdup (_tmp24_);
					result = _tmp25_;
					return result;
				}
			}
		}
	}
	_tmp26_ = g_strdup ("");
	result = _tmp26_;
	return result;
}

static void
contacts_avatar_class_init (ContactsAvatarClass * klass,
                            gpointer klass_data)
{
	contacts_avatar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAvatar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_finalize;
}

static void
contacts_avatar_instance_init (ContactsAvatar * self,
                               gpointer klass)
{
	self->priv = contacts_avatar_get_instance_private (self);
	self->priv->individual = NULL;
	self->priv->load_avatar_started = FALSE;
}

static void
contacts_avatar_finalize (GObject * obj)
{
	ContactsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR, ContactsAvatar);
	G_OBJECT_CLASS (contacts_avatar_parent_class)->finalize (obj);
}

/**
 * The Avatar of a Contact is responsible for showing an {@link Folks.Individual}'s
 * avatar, or a fallback if it's not available.
 */
 G_GNUC_NO_INLINE static GType
contacts_avatar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatar), 0, (GInstanceInitFunc) contacts_avatar_instance_init, NULL };
	GType contacts_avatar_type_id;
	contacts_avatar_type_id = g_type_register_static (adw_bin_get_type (), "ContactsAvatar", &g_define_type_info, 0);
	ContactsAvatar_private_offset = g_type_add_instance_private (contacts_avatar_type_id, sizeof (ContactsAvatarPrivate));
	return contacts_avatar_type_id;
}

GType
contacts_avatar_get_type (void)
{
	static volatile gsize contacts_avatar_type_id__once = 0;
	if (g_once_init_enter (&contacts_avatar_type_id__once)) {
		GType contacts_avatar_type_id;
		contacts_avatar_type_id = contacts_avatar_get_type_once ();
		g_once_init_leave (&contacts_avatar_type_id__once, contacts_avatar_type_id);
	}
	return contacts_avatar_type_id__once;
}

