/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SearchPanel
extends JPanel
implements FocusListener,
ActionListener {
    private static SearchPanel currentlyShown = null;
    private boolean replacing;
    private List<PresenterProxy> presenters;
    private DialogDescriptor dialogDescr;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox newTabCheckBox;
    JTabbedPane tabbedPane = null;
    private Dialog dialog;
    private SearchProvider.Presenter selectedPresenter = null;
    private boolean preferScopeSelection = false;

    public SearchPanel(boolean bl) {
        this(bl, null);
    }

    public SearchPanel(boolean bl, SearchProvider.Presenter presenter) {
        this.replacing = bl;
        this.init(presenter);
    }

    private void init(SearchProvider.Presenter presenter) {
        this.presenters = this.makePresenters(presenter);
        this.setLayout(new GridLayout(1, 1));
        if (this.presenters.isEmpty()) {
            throw new IllegalStateException("No presenter found");
        }
        if (this.presenters.size() == 1) {
            this.selectedPresenter = this.presenters.get(0).getPresenter();
            this.add(this.selectedPresenter.getForm());
        } else {
            this.tabbedPane = new JTabbedPane();
            for (PresenterProxy presenterProxy : this.presenters) {
                Component component = this.tabbedPane.add(presenterProxy.getForm());
                if (!presenterProxy.isInitialized()) continue;
                this.tabbedPane.setSelectedComponent(component);
                this.selectedPresenter = presenterProxy.getPresenter();
            }
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    SearchPanel.this.tabChanged();
                }
            });
            this.add(this.tabbedPane);
        }
        if (this.selectedPresenter == null) {
            this.chooseLastUsedPresenter();
        }
        this.newTabCheckBox = new JCheckBox(NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_NEW_TAB"));
        this.newTabCheckBox.setMaximumSize(new Dimension(1000, 200));
        this.newTabCheckBox.setSelected(FindDialogMemory.getDefault().isOpenInNewTab());
        this.initLocalStrings();
        this.initAccessibility();
    }

    private void chooseLastUsedPresenter() {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        String string = findDialogMemory.getProvider();
        if (string != null) {
            for (PresenterProxy presenterProxy : this.presenters) {
                if (!string.equals(presenterProxy.getTitle())) continue;
                this.selectedPresenter = presenterProxy.getPresenter();
                this.tabbedPane.setSelectedComponent(presenterProxy.getForm());
                return;
            }
        }
        this.selectedPresenter = this.presenters.get(0).getPresenter();
    }

    private void initLocalStrings() throws MissingResourceException {
        this.setName(NbBundle.getMessage(SearchPanel.class, (String)"TEXT_TITLE_CUSTOMIZE"));
        String string = this.isSearchAndReplace() ? "TEXT_BUTTON_SEARCH_CONTINUE" : "TEXT_BUTTON_SEARCH";
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(SearchPanel.class, (String)string));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_CANCEL"));
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescr = dialogDescriptor;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"ACS_SearchPanel"));
        if (this.tabbedPane != null) {
            this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchPanel.class, (String)"ACSN_Tabs"));
            this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"ACSD_Tabs"));
        }
        String string = NbBundle.getMessage(SearchPanel.class, (String)(this.isSearchAndReplace() ? "ACS_TEXT_BUTTON_SEARCH_CONTINUE" : "ACS_TEXT_BUTTON_SEARCH"));
        this.okButton.getAccessibleContext().setAccessibleDescription(string);
        this.okButton.setToolTipText(string);
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"ACS_TEXT_BUTTON_CANCEL"));
        this.newTabCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchPanel.class, (String)"ACS_TEXT_BUTTON_NEW_TAB"));
    }

    List<PresenterProxy> makePresenters(SearchProvider.Presenter presenter) {
        LinkedList<PresenterProxy> linkedList = new LinkedList<PresenterProxy>();
        SearchProvider searchProvider = presenter == null ? null : presenter.getSearchProvider();
        for (SearchProvider searchProvider2 : Lookup.getDefault().lookupAll(SearchProvider.class)) {
            if (this.replacing && !searchProvider2.isReplaceSupported() || searchProvider2 != searchProvider && !searchProvider2.isEnabled()) continue;
            if (searchProvider == searchProvider2) {
                linkedList.add(new PresenterProxy(searchProvider, presenter));
                continue;
            }
            linkedList.add(new PresenterProxy(searchProvider2));
        }
        return linkedList;
    }

    public void showDialog() {
        String string = this.replacing ? "LBL_ReplaceInProjects" : "LBL_FindInProjects";
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)string), false, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass().getCanonicalName() + "." + this.replacing), (ActionListener)this);
        dialogDescriptor.setTitle(NbBundle.getMessage(this.getClass(), (String)string));
        dialogDescriptor.createNotificationLineSupport();
        dialogDescriptor.setAdditionalOptions(new Object[]{this.newTabCheckBox});
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.addWindowListener(new DialogCloseListener());
        this.setDialogDescriptor(dialogDescriptor);
        this.dialog.pack();
        SearchPanel.setCurrentlyShown(this);
        this.dialog.setVisible(true);
        this.dialog.requestFocus();
        this.requestFocusInWindow();
        this.updateHelp();
        this.updateUsability();
        if (this.selectedPresenter == null) {
            this.chooseLastUsedPresenter();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.tabChanged();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.tabChanged();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.selectedPresenter.getForm().requestFocusInWindow();
    }

    private void tabChanged() {
        if (this.tabbedPane != null) {
            int n = this.tabbedPane.getSelectedIndex();
            PresenterProxy presenterProxy = this.presenters.get(n);
            this.selectedPresenter = presenterProxy.getPresenter();
            if (this.dialogDescr != null) {
                this.dialogDescr.getNotificationLineSupport().clearMessages();
                this.updateUsability();
                this.dialog.pack();
            }
            this.updateHelp();
            FindDialogMemory.getDefault().setProvider(this.selectedPresenter.getSearchProvider().getTitle());
        }
    }

    private void updateHelp() {
        HelpCtx helpCtx = this.selectedPresenter.getHelpCtx();
        if (this.dialogDescr != null) {
            this.dialogDescr.setHelpCtx(helpCtx);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.search();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancel();
        }
    }

    private void search() {
        SearchComposition<?> searchComposition;
        if (this.selectedPresenter != null && (searchComposition = this.selectedPresenter.composeSearch()) != null) {
            SearchTask searchTask = new SearchTask(searchComposition, this.replacing);
            boolean bl = this.newTabCheckBox.isSelected();
            if (!bl) {
                ResultView.getInstance().markCurrentTabAsReusable();
            }
            FindDialogMemory.getDefault().setOpenInNewTab(bl);
            Manager.getInstance().scheduleSearchTask(searchTask);
            this.close();
        }
    }

    private void cancel() {
        this.close();
        ResultView.getInstance().clearReusableTab();
    }

    boolean isSearchAndReplace() {
        return this.replacing;
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    void focusDialog() {
        if (this.dialog != null) {
            this.dialog.requestFocus();
        }
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchPanel getCurrentlyShown() {
        Class<SearchPanel> clazz = SearchPanel.class;
        synchronized (SearchPanel.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentlyShown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentlyShown(SearchPanel searchPanel) {
        Class<SearchPanel> clazz = SearchPanel.class;
        synchronized (SearchPanel.class) {
            currentlyShown = searchPanel;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void initChangeListener(final SearchProvider.Presenter presenter) {
        presenter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchPanel.this.okButton.setEnabled(presenter.isUsable(SearchPanel.this.dialogDescr.getNotificationLineSupport()));
            }
        });
    }

    private void updateUsability() {
        this.okButton.setEnabled(this.selectedPresenter.isUsable(this.dialogDescr.getNotificationLineSupport()));
    }

    public boolean isPreferScopeSelection() {
        return this.preferScopeSelection;
    }

    public void setPreferScopeSelection(boolean bl) {
        this.preferScopeSelection = bl;
    }

    public static boolean isOpenedForSelection() {
        SearchPanel searchPanel = SearchPanel.getCurrentlyShown();
        if (searchPanel == null) {
            return false;
        }
        return searchPanel.isPreferScopeSelection();
    }

    private class PresenterProxy {
        private SearchProvider searchProvider;
        private SearchProvider.Presenter presenter;
        private JPanel panel;

        PresenterProxy(SearchProvider searchProvider) {
            this(searchProvider, null);
        }

        PresenterProxy(SearchProvider searchProvider, SearchProvider.Presenter presenter) {
            this.searchProvider = searchProvider;
            this.presenter = presenter;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 3));
            this.panel.setName(this.getTitle());
            if (presenter != null) {
                this.initUI();
            }
        }

        final String getTitle() {
            return this.searchProvider.getTitle();
        }

        synchronized SearchProvider.Presenter getPresenter() {
            if (this.presenter == null) {
                this.presenter = this.searchProvider.createPresenter(SearchPanel.this.replacing);
                this.initUI();
            }
            return this.presenter;
        }

        synchronized boolean isInitialized() {
            return this.presenter != null;
        }

        synchronized JComponent getForm() {
            return this.panel;
        }

        private void initUI() {
            this.panel.add(this.presenter.getForm());
            SearchPanel.this.initChangeListener(this.presenter);
            this.panel.validate();
        }

        public String toString() {
            return "Proxy presenter for " + this.getTitle();
        }
    }

    private class DialogCloseListener
    extends WindowAdapter {
        private DialogCloseListener() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            for (PresenterProxy presenterProxy : SearchPanel.this.presenters) {
                if (!presenterProxy.isInitialized()) continue;
                presenterProxy.getPresenter().clean();
            }
            if (SearchPanel.getCurrentlyShown() == SearchPanel.this) {
                SearchPanel.setCurrentlyShown(null);
            }
        }
    }
}

