/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.jfluid.heap.HprofFileBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofLongMappedByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofMappedByteBuffer;

abstract class HprofByteBuffer {
    static final String magic1 = "JAVA PROFILE 1.0.1";
    static final String magic2 = "JAVA PROFILE 1.0.2";
    static final String magic3 = "JAVA PROFILE 1.0.3";
    static final int JAVA_PROFILE_1_0_1 = 1;
    static final int JAVA_PROFILE_1_0_2 = 2;
    static final int JAVA_PROFILE_1_0_3 = 3;
    static final int MINIMAL_SIZE = 30;
    static final boolean DEBUG = false;
    int idSize;
    int version;
    long headerSize;
    long length;
    long time;

    HprofByteBuffer() {
    }

    static HprofByteBuffer createHprofByteBuffer(File dumpFile) throws IOException {
        long fileLen = dumpFile.length();
        if (fileLen < 30L) {
            String errText = ResourceBundle.getBundle("org/graalvm/visualvm/lib/jfluid/heap/Bundle").getString("HprofByteBuffer_ShortFile");
            throw new IOException(errText);
        }
        try {
            if (fileLen < Integer.MAX_VALUE) {
                return new HprofMappedByteBuffer(dumpFile);
            }
            return new HprofLongMappedByteBuffer(dumpFile);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof OutOfMemoryError) {
                return new HprofFileBuffer(dumpFile);
            }
            throw ex;
        }
    }

    abstract char getChar(long var1);

    abstract double getDouble(long var1);

    abstract float getFloat(long var1);

    long getHeaderSize() {
        return this.headerSize;
    }

    long getID(long offset) {
        if (this.idSize == 4) {
            return (long)this.getInt(offset) & 0xFFFFFFFFL;
        }
        if (this.idSize == 8) {
            return this.getLong(offset);
        }
        assert (false);
        return -1L;
    }

    int getIDSize() {
        return this.idSize;
    }

    int getFoffsetSize() {
        return this.length < Integer.MAX_VALUE ? 4 : 8;
    }

    abstract int getInt(long var1);

    abstract long getLong(long var1);

    abstract short getShort(long var1);

    long getTime() {
        return this.time;
    }

    long capacity() {
        return this.length;
    }

    abstract byte get(long var1);

    abstract void get(long var1, byte[] var3);

    final void readHeader() throws IOException {
        long[] offset = new long[1];
        String magic = this.readStringNull(offset, 30);
        if (magic1.equals(magic)) {
            this.version = 1;
        } else if (magic2.equals(magic)) {
            this.version = 2;
        } else if (magic3.equals(magic)) {
            this.version = 3;
        } else {
            String errText = ResourceBundle.getBundle("org/graalvm/visualvm/lib/jfluid/heap/Bundle").getString("HprofByteBuffer_InvalidFormat");
            throw new IOException(errText);
        }
        this.idSize = this.getInt(offset[0]);
        offset[0] = offset[0] + 4L;
        this.time = this.getLong(offset[0]);
        offset[0] = offset[0] + 8L;
        this.headerSize = offset[0];
    }

    private String readStringNull(long[] offset, int len) {
        StringBuilder s = new StringBuilder(20);
        long l = offset[0];
        offset[0] = l + 1L;
        byte b = this.get(l);
        while (b > 0 && s.length() < len) {
            s.append((char)b);
            long l2 = offset[0];
            offset[0] = l2 + 1L;
            b = this.get(l2);
        }
        return s.toString();
    }
}

