
/* autogenerated from tvtime.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union { orc_int16 i; orc_int8 x2[2]; } orc_union16;
typedef union { orc_int32 i; float f; orc_int16 x2[2]; orc_int8 x4[4]; } orc_union32;
typedef union { orc_int64 i; double f; orc_int32 x2[2]; float x2f[2]; orc_int16 x4[4]; } orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void deinterlace_line_vfir (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const guint8 * ORC_RESTRICT s5, int n);
void deinterlace_line_linear (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void deinterlace_line_linear_blend (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n);
void deinterlace_line_greedy (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int p1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX (orc_uint8) 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX (orc_uint16)65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* deinterlace_line_vfir */
#ifdef DISABLE_ORC
void
deinterlace_line_vfir (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const guint8 * ORC_RESTRICT s5, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  const orc_int8 * ORC_RESTRICT ptr8;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_int8 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;
  ptr8 = (orc_int8 *)s5;

    /* 16: loadpw */
    var40.i = 0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr8[i];
    /* 3: convubw */
    var43.i = (orc_uint8)var36;
    /* 4: addw */
    var44.i = var42.i + var43.i;
    /* 5: loadb */
    var37 = ptr5[i];
    /* 6: convubw */
    var45.i = (orc_uint8)var37;
    /* 7: loadb */
    var38 = ptr7[i];
    /* 8: convubw */
    var46.i = (orc_uint8)var38;
    /* 9: addw */
    var47.i = var45.i + var46.i;
    /* 10: shlw */
    var48.i = ((orc_uint16)var47.i) << 2;
    /* 11: loadb */
    var39 = ptr6[i];
    /* 12: convubw */
    var49.i = (orc_uint8)var39;
    /* 13: shlw */
    var50.i = ((orc_uint16)var49.i) << 1;
    /* 14: subw */
    var51.i = var48.i - var44.i;
    /* 15: addw */
    var52.i = var51.i + var50.i;
    /* 17: addw */
    var53.i = var52.i + var40.i;
    /* 18: shrsw */
    var54.i = var53.i >> 3;
    /* 19: convsuswb */
    var41 = ORC_CLAMP_UB(var54.i);
    /* 20: storeb */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_deinterlace_line_vfir (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  const orc_int8 * ORC_RESTRICT ptr8;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_int8 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];
  ptr8 = (orc_int8 *)ex->arrays[8];

    /* 16: loadpw */
    var40.i = 0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr8[i];
    /* 3: convubw */
    var43.i = (orc_uint8)var36;
    /* 4: addw */
    var44.i = var42.i + var43.i;
    /* 5: loadb */
    var37 = ptr5[i];
    /* 6: convubw */
    var45.i = (orc_uint8)var37;
    /* 7: loadb */
    var38 = ptr7[i];
    /* 8: convubw */
    var46.i = (orc_uint8)var38;
    /* 9: addw */
    var47.i = var45.i + var46.i;
    /* 10: shlw */
    var48.i = ((orc_uint16)var47.i) << 2;
    /* 11: loadb */
    var39 = ptr6[i];
    /* 12: convubw */
    var49.i = (orc_uint8)var39;
    /* 13: shlw */
    var50.i = ((orc_uint16)var49.i) << 1;
    /* 14: subw */
    var51.i = var48.i - var44.i;
    /* 15: addw */
    var52.i = var51.i + var50.i;
    /* 17: addw */
    var53.i = var52.i + var40.i;
    /* 18: shrsw */
    var54.i = var53.i >> 3;
    /* 19: convsuswb */
    var41 = ORC_CLAMP_UB(var54.i);
    /* 20: storeb */
    ptr0[i] = var41;
  }

}

void
deinterlace_line_vfir (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const guint8 * ORC_RESTRICT s5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 100, 101, 105, 110, 116, 101, 114, 108, 97, 99, 101, 95, 108, 
        105, 110, 101, 95, 118, 102, 105, 114, 11, 1, 1, 12, 1, 1, 12, 1, 
        1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 2, 2, 0, 0, 0, 
        14, 2, 1, 0, 0, 0, 14, 2, 4, 0, 0, 0, 14, 2, 3, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 150, 32, 4, 150, 33, 8, 70, 32, 
        32, 33, 150, 33, 5, 150, 34, 7, 70, 33, 33, 34, 93, 33, 33, 16, 
        150, 34, 6, 93, 34, 34, 17, 98, 33, 33, 32, 70, 33, 33, 34, 70, 
        33, 33, 18, 94, 33, 33, 19, 160, 0, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_deinterlace_line_vfir);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_vfir");
      orc_program_set_backup_function (p, _backup_deinterlace_line_vfir);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_source (p, 1, "s5");
      orc_program_add_constant (p, 2, 0x00000002, "c1");
      orc_program_add_constant (p, 2, 0x00000001, "c2");
      orc_program_add_constant (p, 2, 0x00000004, "c3");
      orc_program_add_constant (p, 2, 0x00000003, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;

  func = c->exec;
  func (ex);
}
#endif


/* deinterlace_line_linear */
#ifdef DISABLE_ORC
void
deinterlace_line_linear (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_deinterlace_line_linear (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: avgub */
    var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
deinterlace_line_linear (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 100, 101, 105, 110, 116, 101, 114, 108, 97, 99, 101, 95, 108, 
        105, 110, 101, 95, 108, 105, 110, 101, 97, 114, 11, 1, 1, 12, 1, 1, 
        12, 1, 1, 39, 0, 4, 5, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_deinterlace_line_linear);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_linear");
      orc_program_set_backup_function (p, _backup_deinterlace_line_linear);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* deinterlace_line_linear_blend */
#ifdef DISABLE_ORC
void
deinterlace_line_linear_blend (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 9: loadpw */
    var38.i = 0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var41.i = (orc_uint8)var36;
    /* 4: loadb */
    var37 = ptr6[i];
    /* 5: convubw */
    var42.i = (orc_uint8)var37;
    /* 6: addw */
    var43.i = var40.i + var41.i;
    /* 7: addw */
    var44.i = var42.i + var42.i;
    /* 8: addw */
    var45.i = var43.i + var44.i;
    /* 10: addw */
    var46.i = var45.i + var38.i;
    /* 11: shrsw */
    var47.i = var46.i >> 2;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB(var47.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_deinterlace_line_linear_blend (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 9: loadpw */
    var38.i = 0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var41.i = (orc_uint8)var36;
    /* 4: loadb */
    var37 = ptr6[i];
    /* 5: convubw */
    var42.i = (orc_uint8)var37;
    /* 6: addw */
    var43.i = var40.i + var41.i;
    /* 7: addw */
    var44.i = var42.i + var42.i;
    /* 8: addw */
    var45.i = var43.i + var44.i;
    /* 10: addw */
    var46.i = var45.i + var38.i;
    /* 11: shrsw */
    var47.i = var46.i >> 2;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB(var47.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

void
deinterlace_line_linear_blend (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 29, 100, 101, 105, 110, 116, 101, 114, 108, 97, 99, 101, 95, 108, 
        105, 110, 101, 95, 108, 105, 110, 101, 97, 114, 95, 98, 108, 101, 110, 100, 
        11, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 2, 2, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 150, 32, 4, 150, 33, 5, 150, 34, 
        6, 70, 32, 32, 33, 70, 34, 34, 34, 70, 32, 32, 34, 70, 32, 32, 
        16, 94, 32, 32, 16, 160, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_deinterlace_line_linear_blend);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_linear_blend");
      orc_program_set_backup_function (p, _backup_deinterlace_line_linear_blend);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 2, 0x00000002, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* deinterlace_line_greedy */
#ifdef DISABLE_ORC
void
deinterlace_line_greedy (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int p1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var44;
#else
  orc_int8 var44;
#endif
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_int8 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 11: loadpb */
    var44 = 0x00000080; /* 128 or 6.32404e-322f */
    /* 20: loadpb */
    var45 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var47 = ptr4[i];
    /* 1: loadb */
    var48 = ptr7[i];
    /* 2: loadb */
    var49 = ptr6[i];
    /* 3: loadb */
    var50 = ptr5[i];
    /* 4: avgub */
    var51 = ((orc_uint8)var50 + (orc_uint8)var49 + 1)>>1;
    /* 5: maxub */
    var52 = ORC_MAX((orc_uint8)var47, (orc_uint8)var51);
    /* 6: minub */
    var53 = ORC_MIN((orc_uint8)var47, (orc_uint8)var51);
    /* 7: subb */
    var54 = var52 - var53;
    /* 8: maxub */
    var55 = ORC_MAX((orc_uint8)var48, (orc_uint8)var51);
    /* 9: minub */
    var56 = ORC_MIN((orc_uint8)var48, (orc_uint8)var51);
    /* 10: subb */
    var57 = var55 - var56;
    /* 12: xorb */
    var58 = var54 ^ var44;
    /* 13: xorb */
    var59 = var57 ^ var44;
    /* 14: cmpgtsb */
    var60 = (var58 > var59) ? (~0) : 0;
    /* 15: andb */
    var61 = var48 & var60;
    /* 16: andnb */
    var62 = (~var60) & var47;
    /* 17: orb */
    var63 = var61 | var62;
    /* 18: maxub */
    var64 = ORC_MAX((orc_uint8)var50, (orc_uint8)var49);
    /* 19: minub */
    var65 = ORC_MIN((orc_uint8)var50, (orc_uint8)var49);
    /* 21: addusb */
    var66 = ORC_CLAMP_UB((orc_uint8)var64 + (orc_uint8)var45);
    /* 22: subusb */
    var67 = ORC_CLAMP_UB((orc_uint8)var65 - (orc_uint8)var45);
    /* 23: minub */
    var68 = ORC_MIN((orc_uint8)var63, (orc_uint8)var66);
    /* 24: maxub */
    var46 = ORC_MAX((orc_uint8)var68, (orc_uint8)var67);
    /* 25: storeb */
    ptr0[i] = var46;
  }

}

#else
static void
_backup_deinterlace_line_greedy (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var44;
#else
  orc_int8 var44;
#endif
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;
  orc_int8 var51;
  orc_int8 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_int8 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 11: loadpb */
    var44 = 0x00000080; /* 128 or 6.32404e-322f */
    /* 20: loadpb */
    var45 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var47 = ptr4[i];
    /* 1: loadb */
    var48 = ptr7[i];
    /* 2: loadb */
    var49 = ptr6[i];
    /* 3: loadb */
    var50 = ptr5[i];
    /* 4: avgub */
    var51 = ((orc_uint8)var50 + (orc_uint8)var49 + 1)>>1;
    /* 5: maxub */
    var52 = ORC_MAX((orc_uint8)var47, (orc_uint8)var51);
    /* 6: minub */
    var53 = ORC_MIN((orc_uint8)var47, (orc_uint8)var51);
    /* 7: subb */
    var54 = var52 - var53;
    /* 8: maxub */
    var55 = ORC_MAX((orc_uint8)var48, (orc_uint8)var51);
    /* 9: minub */
    var56 = ORC_MIN((orc_uint8)var48, (orc_uint8)var51);
    /* 10: subb */
    var57 = var55 - var56;
    /* 12: xorb */
    var58 = var54 ^ var44;
    /* 13: xorb */
    var59 = var57 ^ var44;
    /* 14: cmpgtsb */
    var60 = (var58 > var59) ? (~0) : 0;
    /* 15: andb */
    var61 = var48 & var60;
    /* 16: andnb */
    var62 = (~var60) & var47;
    /* 17: orb */
    var63 = var61 | var62;
    /* 18: maxub */
    var64 = ORC_MAX((orc_uint8)var50, (orc_uint8)var49);
    /* 19: minub */
    var65 = ORC_MIN((orc_uint8)var50, (orc_uint8)var49);
    /* 21: addusb */
    var66 = ORC_CLAMP_UB((orc_uint8)var64 + (orc_uint8)var45);
    /* 22: subusb */
    var67 = ORC_CLAMP_UB((orc_uint8)var65 - (orc_uint8)var45);
    /* 23: minub */
    var68 = ORC_MIN((orc_uint8)var63, (orc_uint8)var66);
    /* 24: maxub */
    var46 = ORC_MAX((orc_uint8)var68, (orc_uint8)var67);
    /* 25: storeb */
    ptr0[i] = var46;
  }

}

void
deinterlace_line_greedy (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, const orc_uint8 * ORC_RESTRICT s3, const orc_uint8 * ORC_RESTRICT s4, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 100, 101, 105, 110, 116, 101, 114, 108, 97, 99, 101, 95, 108, 
        105, 110, 101, 95, 103, 114, 101, 101, 100, 121, 11, 1, 1, 12, 1, 1, 
        12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 1, 128, 0, 0, 0, 16, 
        1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 
        1, 20, 1, 20, 1, 20, 1, 20, 1, 43, 32, 4, 43, 33, 7, 43, 
        34, 6, 43, 35, 5, 39, 36, 35, 34, 53, 39, 32, 36, 55, 40, 32, 
        36, 65, 37, 39, 40, 53, 39, 33, 36, 55, 40, 33, 36, 65, 38, 39, 
        40, 68, 37, 37, 16, 68, 38, 38, 16, 41, 40, 37, 38, 36, 39, 33, 
        40, 37, 40, 40, 32, 59, 41, 39, 40, 53, 43, 35, 34, 55, 42, 35, 
        34, 35, 43, 43, 24, 67, 42, 42, 24, 55, 41, 41, 43, 53, 0, 41, 
        42, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_deinterlace_line_greedy);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "deinterlace_line_greedy");
      orc_program_set_backup_function (p, _backup_deinterlace_line_greedy);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");
      orc_program_add_temporary (p, 1, "t9");
      orc_program_add_temporary (p, 1, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");

      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T8, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T9, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T6, ORC_VAR_T8, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T8, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T9, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "xorb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "cmpgtsb", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "andb", 0, ORC_VAR_T8, ORC_VAR_T2, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "andnb", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "orb", 0, ORC_VAR_T10, ORC_VAR_T8, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_T12, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T11, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addusb", 0, ORC_VAR_T12, ORC_VAR_T12, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "subusb", 0, ORC_VAR_T11, ORC_VAR_T11, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "minub", 0, ORC_VAR_T10, ORC_VAR_T10, ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "maxub", 0, ORC_VAR_D1, ORC_VAR_T10, ORC_VAR_T11, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


