// services/viz/public/mojom/compositing/quads.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/quads.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/quads.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/quads.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
DebugBorderQuadState::DebugBorderQuadState()
    : color(),
      width() {}

DebugBorderQuadState::DebugBorderQuadState(
    uint32_t color_in,
    int32_t width_in)
    : color(std::move(color_in)),
      width(std::move(width_in)) {}

DebugBorderQuadState::~DebugBorderQuadState() = default;
size_t DebugBorderQuadState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->color);
  seed = mojo::internal::Hash(seed, this->width);
  return seed;
}

void DebugBorderQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("color", base::NumberToString(this->color));
  value->SetInteger("width", this->width);
}

bool DebugBorderQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CompositorRenderPassQuadState::CompositorRenderPassQuadState()
    : render_pass_id(),
      mask_resource_id(),
      mask_uv_rect(),
      mask_texture_size(),
      filters_scale(),
      filters_origin(),
      tex_coord_rect(),
      force_anti_aliasing_off(),
      backdrop_filter_quality(),
      can_use_backdrop_filter_cache() {}

CompositorRenderPassQuadState::CompositorRenderPassQuadState(
    const ::viz::CompositorRenderPassId& render_pass_id_in,
    uint32_t mask_resource_id_in,
    const ::gfx::RectF& mask_uv_rect_in,
    const ::gfx::Size& mask_texture_size_in,
    const ::gfx::Vector2dF& filters_scale_in,
    const ::gfx::PointF& filters_origin_in,
    const ::gfx::RectF& tex_coord_rect_in,
    bool force_anti_aliasing_off_in,
    float backdrop_filter_quality_in,
    bool can_use_backdrop_filter_cache_in)
    : render_pass_id(std::move(render_pass_id_in)),
      mask_resource_id(std::move(mask_resource_id_in)),
      mask_uv_rect(std::move(mask_uv_rect_in)),
      mask_texture_size(std::move(mask_texture_size_in)),
      filters_scale(std::move(filters_scale_in)),
      filters_origin(std::move(filters_origin_in)),
      tex_coord_rect(std::move(tex_coord_rect_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)),
      backdrop_filter_quality(std::move(backdrop_filter_quality_in)),
      can_use_backdrop_filter_cache(std::move(can_use_backdrop_filter_cache_in)) {}

CompositorRenderPassQuadState::~CompositorRenderPassQuadState() = default;

void CompositorRenderPassQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("render_pass_id", base::trace_event::ValueToString(this->render_pass_id, "<value of type const ::viz::CompositorRenderPassId&>"));
  value->SetString("mask_resource_id", base::NumberToString(this->mask_resource_id));
  value->SetString("mask_uv_rect", base::trace_event::ValueToString(this->mask_uv_rect, "<value of type const ::gfx::RectF&>"));
  value->SetString("mask_texture_size", base::trace_event::ValueToString(this->mask_texture_size, "<value of type const ::gfx::Size&>"));
  value->SetString("filters_scale", base::trace_event::ValueToString(this->filters_scale, "<value of type const ::gfx::Vector2dF&>"));
  value->SetString("filters_origin", base::trace_event::ValueToString(this->filters_origin, "<value of type const ::gfx::PointF&>"));
  value->SetString("tex_coord_rect", base::trace_event::ValueToString(this->tex_coord_rect, "<value of type const ::gfx::RectF&>"));
  value->SetBoolean("force_anti_aliasing_off", this->force_anti_aliasing_off);
  value->SetDouble("backdrop_filter_quality", this->backdrop_filter_quality);
  value->SetBoolean("can_use_backdrop_filter_cache", this->can_use_backdrop_filter_cache);
}

bool CompositorRenderPassQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SolidColorQuadState::SolidColorQuadState()
    : color(),
      force_anti_aliasing_off() {}

SolidColorQuadState::SolidColorQuadState(
    uint32_t color_in,
    bool force_anti_aliasing_off_in)
    : color(std::move(color_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)) {}

SolidColorQuadState::~SolidColorQuadState() = default;
size_t SolidColorQuadState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->color);
  seed = mojo::internal::Hash(seed, this->force_anti_aliasing_off);
  return seed;
}

void SolidColorQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("color", base::NumberToString(this->color));
  value->SetBoolean("force_anti_aliasing_off", this->force_anti_aliasing_off);
}

bool SolidColorQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamVideoQuadState::StreamVideoQuadState()
    : resource_id(),
      resource_size_in_pixels(),
      uv_top_left(),
      uv_bottom_right() {}

StreamVideoQuadState::StreamVideoQuadState(
    uint32_t resource_id_in,
    const ::gfx::Size& resource_size_in_pixels_in,
    const ::gfx::PointF& uv_top_left_in,
    const ::gfx::PointF& uv_bottom_right_in)
    : resource_id(std::move(resource_id_in)),
      resource_size_in_pixels(std::move(resource_size_in_pixels_in)),
      uv_top_left(std::move(uv_top_left_in)),
      uv_bottom_right(std::move(uv_bottom_right_in)) {}

StreamVideoQuadState::~StreamVideoQuadState() = default;

void StreamVideoQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("resource_id", base::NumberToString(this->resource_id));
  value->SetString("resource_size_in_pixels", base::trace_event::ValueToString(this->resource_size_in_pixels, "<value of type const ::gfx::Size&>"));
  value->SetString("uv_top_left", base::trace_event::ValueToString(this->uv_top_left, "<value of type const ::gfx::PointF&>"));
  value->SetString("uv_bottom_right", base::trace_event::ValueToString(this->uv_bottom_right, "<value of type const ::gfx::PointF&>"));
}

bool StreamVideoQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SurfaceQuadState::SurfaceQuadState()
    : surface_range(),
      default_background_color(),
      stretch_content_to_fill_bounds(),
      is_reflection(),
      allow_merge() {}

SurfaceQuadState::SurfaceQuadState(
    const ::viz::SurfaceRange& surface_range_in,
    uint32_t default_background_color_in,
    bool stretch_content_to_fill_bounds_in,
    bool is_reflection_in,
    bool allow_merge_in)
    : surface_range(std::move(surface_range_in)),
      default_background_color(std::move(default_background_color_in)),
      stretch_content_to_fill_bounds(std::move(stretch_content_to_fill_bounds_in)),
      is_reflection(std::move(is_reflection_in)),
      allow_merge(std::move(allow_merge_in)) {}

SurfaceQuadState::~SurfaceQuadState() = default;

void SurfaceQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("surface_range", base::trace_event::ValueToString(this->surface_range, "<value of type const ::viz::SurfaceRange&>"));
  value->SetString("default_background_color", base::NumberToString(this->default_background_color));
  value->SetBoolean("stretch_content_to_fill_bounds", this->stretch_content_to_fill_bounds);
  value->SetBoolean("is_reflection", this->is_reflection);
  value->SetBoolean("allow_merge", this->allow_merge);
}

bool SurfaceQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextureQuadState::TextureQuadState()
    : resource_id(),
      resource_size_in_pixels(),
      premultiplied_alpha(),
      uv_top_left(),
      uv_bottom_right(),
      background_color(),
      vertex_opacity(),
      y_flipped(),
      nearest_neighbor(),
      secure_output_only(),
      is_video_frame(),
      protected_video_type() {}

TextureQuadState::TextureQuadState(
    uint32_t resource_id_in,
    const ::gfx::Size& resource_size_in_pixels_in,
    bool premultiplied_alpha_in,
    const ::gfx::PointF& uv_top_left_in,
    const ::gfx::PointF& uv_bottom_right_in,
    uint32_t background_color_in,
    std::vector<float> vertex_opacity_in,
    bool y_flipped_in,
    bool nearest_neighbor_in,
    bool secure_output_only_in,
    bool is_video_frame_in,
    ::gfx::ProtectedVideoType protected_video_type_in)
    : resource_id(std::move(resource_id_in)),
      resource_size_in_pixels(std::move(resource_size_in_pixels_in)),
      premultiplied_alpha(std::move(premultiplied_alpha_in)),
      uv_top_left(std::move(uv_top_left_in)),
      uv_bottom_right(std::move(uv_bottom_right_in)),
      background_color(std::move(background_color_in)),
      vertex_opacity(std::move(vertex_opacity_in)),
      y_flipped(std::move(y_flipped_in)),
      nearest_neighbor(std::move(nearest_neighbor_in)),
      secure_output_only(std::move(secure_output_only_in)),
      is_video_frame(std::move(is_video_frame_in)),
      protected_video_type(std::move(protected_video_type_in)) {}

TextureQuadState::~TextureQuadState() = default;

void TextureQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("resource_id", base::NumberToString(this->resource_id));
  value->SetString("resource_size_in_pixels", base::trace_event::ValueToString(this->resource_size_in_pixels, "<value of type const ::gfx::Size&>"));
  value->SetBoolean("premultiplied_alpha", this->premultiplied_alpha);
  value->SetString("uv_top_left", base::trace_event::ValueToString(this->uv_top_left, "<value of type const ::gfx::PointF&>"));
  value->SetString("uv_bottom_right", base::trace_event::ValueToString(this->uv_bottom_right, "<value of type const ::gfx::PointF&>"));
  value->SetString("background_color", base::NumberToString(this->background_color));
  value->BeginArray("vertex_opacity");
  for (const auto& item0 : this->vertex_opacity) {
    value->AppendDouble(item0);
  }
  value->EndArray();
  value->SetBoolean("y_flipped", this->y_flipped);
  value->SetBoolean("nearest_neighbor", this->nearest_neighbor);
  value->SetBoolean("secure_output_only", this->secure_output_only);
  value->SetBoolean("is_video_frame", this->is_video_frame);
  value->SetInteger("protected_video_type", static_cast<int>(this->protected_video_type));
}

bool TextureQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TileQuadState::TileQuadState()
    : tex_coord_rect(),
      texture_size(),
      is_premultiplied(),
      resource_id(),
      nearest_neighbor(),
      force_anti_aliasing_off() {}

TileQuadState::TileQuadState(
    const ::gfx::RectF& tex_coord_rect_in,
    const ::gfx::Size& texture_size_in,
    bool is_premultiplied_in,
    uint32_t resource_id_in,
    bool nearest_neighbor_in,
    bool force_anti_aliasing_off_in)
    : tex_coord_rect(std::move(tex_coord_rect_in)),
      texture_size(std::move(texture_size_in)),
      is_premultiplied(std::move(is_premultiplied_in)),
      resource_id(std::move(resource_id_in)),
      nearest_neighbor(std::move(nearest_neighbor_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)) {}

TileQuadState::~TileQuadState() = default;

void TileQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("tex_coord_rect", base::trace_event::ValueToString(this->tex_coord_rect, "<value of type const ::gfx::RectF&>"));
  value->SetString("texture_size", base::trace_event::ValueToString(this->texture_size, "<value of type const ::gfx::Size&>"));
  value->SetBoolean("is_premultiplied", this->is_premultiplied);
  value->SetString("resource_id", base::NumberToString(this->resource_id));
  value->SetBoolean("nearest_neighbor", this->nearest_neighbor);
  value->SetBoolean("force_anti_aliasing_off", this->force_anti_aliasing_off);
}

bool TileQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
YUVVideoQuadState::YUVVideoQuadState()
    : ya_tex_coord_rect(),
      uv_tex_coord_rect(),
      ya_tex_size(),
      uv_tex_size(),
      y_plane_resource_id(),
      u_plane_resource_id(),
      v_plane_resource_id(),
      a_plane_resource_id(),
      resource_offset(),
      resource_multiplier(),
      bits_per_channel(),
      video_color_space(),
      protected_video_type(),
      hdr_metadata() {}

YUVVideoQuadState::YUVVideoQuadState(
    const ::gfx::RectF& ya_tex_coord_rect_in,
    const ::gfx::RectF& uv_tex_coord_rect_in,
    const ::gfx::Size& ya_tex_size_in,
    const ::gfx::Size& uv_tex_size_in,
    uint32_t y_plane_resource_id_in,
    uint32_t u_plane_resource_id_in,
    uint32_t v_plane_resource_id_in,
    uint32_t a_plane_resource_id_in,
    float resource_offset_in,
    float resource_multiplier_in,
    uint32_t bits_per_channel_in,
    const ::gfx::ColorSpace& video_color_space_in,
    ::gfx::ProtectedVideoType protected_video_type_in,
    const ::gl::HDRMetadata& hdr_metadata_in)
    : ya_tex_coord_rect(std::move(ya_tex_coord_rect_in)),
      uv_tex_coord_rect(std::move(uv_tex_coord_rect_in)),
      ya_tex_size(std::move(ya_tex_size_in)),
      uv_tex_size(std::move(uv_tex_size_in)),
      y_plane_resource_id(std::move(y_plane_resource_id_in)),
      u_plane_resource_id(std::move(u_plane_resource_id_in)),
      v_plane_resource_id(std::move(v_plane_resource_id_in)),
      a_plane_resource_id(std::move(a_plane_resource_id_in)),
      resource_offset(std::move(resource_offset_in)),
      resource_multiplier(std::move(resource_multiplier_in)),
      bits_per_channel(std::move(bits_per_channel_in)),
      video_color_space(std::move(video_color_space_in)),
      protected_video_type(std::move(protected_video_type_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

YUVVideoQuadState::~YUVVideoQuadState() = default;

void YUVVideoQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("ya_tex_coord_rect", base::trace_event::ValueToString(this->ya_tex_coord_rect, "<value of type const ::gfx::RectF&>"));
  value->SetString("uv_tex_coord_rect", base::trace_event::ValueToString(this->uv_tex_coord_rect, "<value of type const ::gfx::RectF&>"));
  value->SetString("ya_tex_size", base::trace_event::ValueToString(this->ya_tex_size, "<value of type const ::gfx::Size&>"));
  value->SetString("uv_tex_size", base::trace_event::ValueToString(this->uv_tex_size, "<value of type const ::gfx::Size&>"));
  value->SetString("y_plane_resource_id", base::NumberToString(this->y_plane_resource_id));
  value->SetString("u_plane_resource_id", base::NumberToString(this->u_plane_resource_id));
  value->SetString("v_plane_resource_id", base::NumberToString(this->v_plane_resource_id));
  value->SetString("a_plane_resource_id", base::NumberToString(this->a_plane_resource_id));
  value->SetDouble("resource_offset", this->resource_offset);
  value->SetDouble("resource_multiplier", this->resource_multiplier);
  value->SetString("bits_per_channel", base::NumberToString(this->bits_per_channel));
  value->SetString("video_color_space", base::trace_event::ValueToString(this->video_color_space, "<value of type const ::gfx::ColorSpace&>"));
  value->SetInteger("protected_video_type", static_cast<int>(this->protected_video_type));
  value->SetString("hdr_metadata", base::trace_event::ValueToString(this->hdr_metadata, "<value of type const ::gl::HDRMetadata&>"));
}

bool YUVVideoQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoHoleQuadState::VideoHoleQuadState()
    : overlay_plane_id() {}

VideoHoleQuadState::VideoHoleQuadState(
    const ::base::UnguessableToken& overlay_plane_id_in)
    : overlay_plane_id(std::move(overlay_plane_id_in)) {}

VideoHoleQuadState::~VideoHoleQuadState() = default;

void VideoHoleQuadState::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("overlay_plane_id", base::trace_event::ValueToString(this->overlay_plane_id, "<value of type const ::base::UnguessableToken&>"));
}

bool VideoHoleQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DrawQuad::DrawQuad()
    : rect(),
      visible_rect(),
      needs_blending(),
      sqs(),
      draw_quad_state() {}

DrawQuad::DrawQuad(
    const ::gfx::Rect& rect_in,
    const ::gfx::Rect& visible_rect_in,
    bool needs_blending_in,
    const base::Optional<::viz::SharedQuadState>& sqs_in,
    DrawQuadStatePtr draw_quad_state_in)
    : rect(std::move(rect_in)),
      visible_rect(std::move(visible_rect_in)),
      needs_blending(std::move(needs_blending_in)),
      sqs(std::move(sqs_in)),
      draw_quad_state(std::move(draw_quad_state_in)) {}

DrawQuad::~DrawQuad() = default;

void DrawQuad::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("rect", base::trace_event::ValueToString(this->rect, "<value of type const ::gfx::Rect&>"));
  value->SetString("visible_rect", base::trace_event::ValueToString(this->visible_rect, "<value of type const ::gfx::Rect&>"));
  value->SetBoolean("needs_blending", this->needs_blending);
  value->SetString("sqs", base::trace_event::ValueToString(this->sqs, "<value of type const base::Optional<::viz::SharedQuadState>&>"));
  value->SetString("draw_quad_state", base::trace_event::ValueToString(this->draw_quad_state, "<value of type DrawQuadStatePtr>"));
}

bool DrawQuad::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DrawQuadState::DrawQuadState() : tag_(Tag::DEBUG_BORDER_QUAD_STATE) {
  data_.debug_border_quad_state = new DebugBorderQuadStatePtr;
}

DrawQuadState::~DrawQuadState() {
  DestroyActive();
}


void DrawQuadState::set_debug_border_quad_state(
    DebugBorderQuadStatePtr debug_border_quad_state) {
  if (tag_ == Tag::DEBUG_BORDER_QUAD_STATE) {
    *(data_.debug_border_quad_state) = std::move(debug_border_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::DEBUG_BORDER_QUAD_STATE;
    data_.debug_border_quad_state = new DebugBorderQuadStatePtr(
        std::move(debug_border_quad_state));
  }
}
void DrawQuadState::set_render_pass_quad_state(
    CompositorRenderPassQuadStatePtr render_pass_quad_state) {
  if (tag_ == Tag::RENDER_PASS_QUAD_STATE) {
    *(data_.render_pass_quad_state) = std::move(render_pass_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::RENDER_PASS_QUAD_STATE;
    data_.render_pass_quad_state = new CompositorRenderPassQuadStatePtr(
        std::move(render_pass_quad_state));
  }
}
void DrawQuadState::set_solid_color_quad_state(
    SolidColorQuadStatePtr solid_color_quad_state) {
  if (tag_ == Tag::SOLID_COLOR_QUAD_STATE) {
    *(data_.solid_color_quad_state) = std::move(solid_color_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::SOLID_COLOR_QUAD_STATE;
    data_.solid_color_quad_state = new SolidColorQuadStatePtr(
        std::move(solid_color_quad_state));
  }
}
void DrawQuadState::set_stream_video_quad_state(
    StreamVideoQuadStatePtr stream_video_quad_state) {
  if (tag_ == Tag::STREAM_VIDEO_QUAD_STATE) {
    *(data_.stream_video_quad_state) = std::move(stream_video_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::STREAM_VIDEO_QUAD_STATE;
    data_.stream_video_quad_state = new StreamVideoQuadStatePtr(
        std::move(stream_video_quad_state));
  }
}
void DrawQuadState::set_surface_quad_state(
    SurfaceQuadStatePtr surface_quad_state) {
  if (tag_ == Tag::SURFACE_QUAD_STATE) {
    *(data_.surface_quad_state) = std::move(surface_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::SURFACE_QUAD_STATE;
    data_.surface_quad_state = new SurfaceQuadStatePtr(
        std::move(surface_quad_state));
  }
}
void DrawQuadState::set_texture_quad_state(
    TextureQuadStatePtr texture_quad_state) {
  if (tag_ == Tag::TEXTURE_QUAD_STATE) {
    *(data_.texture_quad_state) = std::move(texture_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::TEXTURE_QUAD_STATE;
    data_.texture_quad_state = new TextureQuadStatePtr(
        std::move(texture_quad_state));
  }
}
void DrawQuadState::set_tile_quad_state(
    TileQuadStatePtr tile_quad_state) {
  if (tag_ == Tag::TILE_QUAD_STATE) {
    *(data_.tile_quad_state) = std::move(tile_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::TILE_QUAD_STATE;
    data_.tile_quad_state = new TileQuadStatePtr(
        std::move(tile_quad_state));
  }
}
void DrawQuadState::set_yuv_video_quad_state(
    YUVVideoQuadStatePtr yuv_video_quad_state) {
  if (tag_ == Tag::YUV_VIDEO_QUAD_STATE) {
    *(data_.yuv_video_quad_state) = std::move(yuv_video_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::YUV_VIDEO_QUAD_STATE;
    data_.yuv_video_quad_state = new YUVVideoQuadStatePtr(
        std::move(yuv_video_quad_state));
  }
}
void DrawQuadState::set_video_hole_quad_state(
    VideoHoleQuadStatePtr video_hole_quad_state) {
  if (tag_ == Tag::VIDEO_HOLE_QUAD_STATE) {
    *(data_.video_hole_quad_state) = std::move(video_hole_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::VIDEO_HOLE_QUAD_STATE;
    data_.video_hole_quad_state = new VideoHoleQuadStatePtr(
        std::move(video_hole_quad_state));
  }
}

void DrawQuadState::DestroyActive() {
  switch (tag_) {

    case Tag::DEBUG_BORDER_QUAD_STATE:

      delete data_.debug_border_quad_state;
      break;
    case Tag::RENDER_PASS_QUAD_STATE:

      delete data_.render_pass_quad_state;
      break;
    case Tag::SOLID_COLOR_QUAD_STATE:

      delete data_.solid_color_quad_state;
      break;
    case Tag::STREAM_VIDEO_QUAD_STATE:

      delete data_.stream_video_quad_state;
      break;
    case Tag::SURFACE_QUAD_STATE:

      delete data_.surface_quad_state;
      break;
    case Tag::TEXTURE_QUAD_STATE:

      delete data_.texture_quad_state;
      break;
    case Tag::TILE_QUAD_STATE:

      delete data_.tile_quad_state;
      break;
    case Tag::YUV_VIDEO_QUAD_STATE:

      delete data_.yuv_video_quad_state;
      break;
    case Tag::VIDEO_HOLE_QUAD_STATE:

      delete data_.video_hole_quad_state;
      break;
  }
}

bool DrawQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::DebugBorderQuadState::DataView, ::viz::mojom::DebugBorderQuadStatePtr>::Read(
    ::viz::mojom::DebugBorderQuadState::DataView input,
    ::viz::mojom::DebugBorderQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::DebugBorderQuadStatePtr result(::viz::mojom::DebugBorderQuadState::New());
  
      if (success)
        result->color = input.color();
      if (success)
        result->width = input.width();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::CompositorRenderPassQuadState::DataView, ::viz::mojom::CompositorRenderPassQuadStatePtr>::Read(
    ::viz::mojom::CompositorRenderPassQuadState::DataView input,
    ::viz::mojom::CompositorRenderPassQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::CompositorRenderPassQuadStatePtr result(::viz::mojom::CompositorRenderPassQuadState::New());
  
      if (success && !input.ReadRenderPassId(&result->render_pass_id))
        success = false;
      if (success)
        result->mask_resource_id = input.mask_resource_id();
      if (success && !input.ReadMaskUvRect(&result->mask_uv_rect))
        success = false;
      if (success && !input.ReadMaskTextureSize(&result->mask_texture_size))
        success = false;
      if (success && !input.ReadFiltersScale(&result->filters_scale))
        success = false;
      if (success && !input.ReadFiltersOrigin(&result->filters_origin))
        success = false;
      if (success && !input.ReadTexCoordRect(&result->tex_coord_rect))
        success = false;
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
      if (success)
        result->backdrop_filter_quality = input.backdrop_filter_quality();
      if (success)
        result->can_use_backdrop_filter_cache = input.can_use_backdrop_filter_cache();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::SolidColorQuadState::DataView, ::viz::mojom::SolidColorQuadStatePtr>::Read(
    ::viz::mojom::SolidColorQuadState::DataView input,
    ::viz::mojom::SolidColorQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::SolidColorQuadStatePtr result(::viz::mojom::SolidColorQuadState::New());
  
      if (success)
        result->color = input.color();
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::StreamVideoQuadState::DataView, ::viz::mojom::StreamVideoQuadStatePtr>::Read(
    ::viz::mojom::StreamVideoQuadState::DataView input,
    ::viz::mojom::StreamVideoQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::StreamVideoQuadStatePtr result(::viz::mojom::StreamVideoQuadState::New());
  
      if (success)
        result->resource_id = input.resource_id();
      if (success && !input.ReadResourceSizeInPixels(&result->resource_size_in_pixels))
        success = false;
      if (success && !input.ReadUvTopLeft(&result->uv_top_left))
        success = false;
      if (success && !input.ReadUvBottomRight(&result->uv_bottom_right))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::SurfaceQuadState::DataView, ::viz::mojom::SurfaceQuadStatePtr>::Read(
    ::viz::mojom::SurfaceQuadState::DataView input,
    ::viz::mojom::SurfaceQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::SurfaceQuadStatePtr result(::viz::mojom::SurfaceQuadState::New());
  
      if (success && !input.ReadSurfaceRange(&result->surface_range))
        success = false;
      if (success)
        result->default_background_color = input.default_background_color();
      if (success)
        result->stretch_content_to_fill_bounds = input.stretch_content_to_fill_bounds();
      if (success)
        result->is_reflection = input.is_reflection();
      if (success)
        result->allow_merge = input.allow_merge();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TextureQuadState::DataView, ::viz::mojom::TextureQuadStatePtr>::Read(
    ::viz::mojom::TextureQuadState::DataView input,
    ::viz::mojom::TextureQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::TextureQuadStatePtr result(::viz::mojom::TextureQuadState::New());
  
      if (success)
        result->resource_id = input.resource_id();
      if (success && !input.ReadResourceSizeInPixels(&result->resource_size_in_pixels))
        success = false;
      if (success)
        result->premultiplied_alpha = input.premultiplied_alpha();
      if (success && !input.ReadUvTopLeft(&result->uv_top_left))
        success = false;
      if (success && !input.ReadUvBottomRight(&result->uv_bottom_right))
        success = false;
      if (success)
        result->background_color = input.background_color();
      if (success && !input.ReadVertexOpacity(&result->vertex_opacity))
        success = false;
      if (success)
        result->y_flipped = input.y_flipped();
      if (success)
        result->nearest_neighbor = input.nearest_neighbor();
      if (success)
        result->secure_output_only = input.secure_output_only();
      if (success)
        result->is_video_frame = input.is_video_frame();
      if (success && !input.ReadProtectedVideoType(&result->protected_video_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::TileQuadState::DataView, ::viz::mojom::TileQuadStatePtr>::Read(
    ::viz::mojom::TileQuadState::DataView input,
    ::viz::mojom::TileQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::TileQuadStatePtr result(::viz::mojom::TileQuadState::New());
  
      if (success && !input.ReadTexCoordRect(&result->tex_coord_rect))
        success = false;
      if (success && !input.ReadTextureSize(&result->texture_size))
        success = false;
      if (success)
        result->is_premultiplied = input.is_premultiplied();
      if (success)
        result->resource_id = input.resource_id();
      if (success)
        result->nearest_neighbor = input.nearest_neighbor();
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::YUVVideoQuadState::DataView, ::viz::mojom::YUVVideoQuadStatePtr>::Read(
    ::viz::mojom::YUVVideoQuadState::DataView input,
    ::viz::mojom::YUVVideoQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::YUVVideoQuadStatePtr result(::viz::mojom::YUVVideoQuadState::New());
  
      if (success && !input.ReadYaTexCoordRect(&result->ya_tex_coord_rect))
        success = false;
      if (success && !input.ReadUvTexCoordRect(&result->uv_tex_coord_rect))
        success = false;
      if (success && !input.ReadYaTexSize(&result->ya_tex_size))
        success = false;
      if (success && !input.ReadUvTexSize(&result->uv_tex_size))
        success = false;
      if (success)
        result->y_plane_resource_id = input.y_plane_resource_id();
      if (success)
        result->u_plane_resource_id = input.u_plane_resource_id();
      if (success)
        result->v_plane_resource_id = input.v_plane_resource_id();
      if (success)
        result->a_plane_resource_id = input.a_plane_resource_id();
      if (success)
        result->resource_offset = input.resource_offset();
      if (success)
        result->resource_multiplier = input.resource_multiplier();
      if (success)
        result->bits_per_channel = input.bits_per_channel();
      if (success && !input.ReadVideoColorSpace(&result->video_color_space))
        success = false;
      if (success && !input.ReadProtectedVideoType(&result->protected_video_type))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::VideoHoleQuadState::DataView, ::viz::mojom::VideoHoleQuadStatePtr>::Read(
    ::viz::mojom::VideoHoleQuadState::DataView input,
    ::viz::mojom::VideoHoleQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::VideoHoleQuadStatePtr result(::viz::mojom::VideoHoleQuadState::New());
  
      if (success && !input.ReadOverlayPlaneId(&result->overlay_plane_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::DrawQuad::DataView, ::viz::mojom::DrawQuadPtr>::Read(
    ::viz::mojom::DrawQuad::DataView input,
    ::viz::mojom::DrawQuadPtr* output) {
  bool success = true;
  ::viz::mojom::DrawQuadPtr result(::viz::mojom::DrawQuad::New());
  
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success)
        result->needs_blending = input.needs_blending();
      if (success && !input.ReadSqs(&result->sqs))
        success = false;
      if (success && !input.ReadDrawQuadState(&result->draw_quad_state))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::DrawQuadState::DataView, ::viz::mojom::DrawQuadStatePtr>::Read(
    ::viz::mojom::DrawQuadState::DataView input,
    ::viz::mojom::DrawQuadStatePtr* output) {
  using UnionType = ::viz::mojom::DrawQuadState;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::DEBUG_BORDER_QUAD_STATE: {
      ::viz::mojom::DebugBorderQuadStatePtr result_debug_border_quad_state;
      if (!input.ReadDebugBorderQuadState(&result_debug_border_quad_state))
        return false;

      *output = UnionType::NewDebugBorderQuadState(
          std::move(result_debug_border_quad_state));
      break;
    }
    case Tag::RENDER_PASS_QUAD_STATE: {
      ::viz::mojom::CompositorRenderPassQuadStatePtr result_render_pass_quad_state;
      if (!input.ReadRenderPassQuadState(&result_render_pass_quad_state))
        return false;

      *output = UnionType::NewRenderPassQuadState(
          std::move(result_render_pass_quad_state));
      break;
    }
    case Tag::SOLID_COLOR_QUAD_STATE: {
      ::viz::mojom::SolidColorQuadStatePtr result_solid_color_quad_state;
      if (!input.ReadSolidColorQuadState(&result_solid_color_quad_state))
        return false;

      *output = UnionType::NewSolidColorQuadState(
          std::move(result_solid_color_quad_state));
      break;
    }
    case Tag::STREAM_VIDEO_QUAD_STATE: {
      ::viz::mojom::StreamVideoQuadStatePtr result_stream_video_quad_state;
      if (!input.ReadStreamVideoQuadState(&result_stream_video_quad_state))
        return false;

      *output = UnionType::NewStreamVideoQuadState(
          std::move(result_stream_video_quad_state));
      break;
    }
    case Tag::SURFACE_QUAD_STATE: {
      ::viz::mojom::SurfaceQuadStatePtr result_surface_quad_state;
      if (!input.ReadSurfaceQuadState(&result_surface_quad_state))
        return false;

      *output = UnionType::NewSurfaceQuadState(
          std::move(result_surface_quad_state));
      break;
    }
    case Tag::TEXTURE_QUAD_STATE: {
      ::viz::mojom::TextureQuadStatePtr result_texture_quad_state;
      if (!input.ReadTextureQuadState(&result_texture_quad_state))
        return false;

      *output = UnionType::NewTextureQuadState(
          std::move(result_texture_quad_state));
      break;
    }
    case Tag::TILE_QUAD_STATE: {
      ::viz::mojom::TileQuadStatePtr result_tile_quad_state;
      if (!input.ReadTileQuadState(&result_tile_quad_state))
        return false;

      *output = UnionType::NewTileQuadState(
          std::move(result_tile_quad_state));
      break;
    }
    case Tag::YUV_VIDEO_QUAD_STATE: {
      ::viz::mojom::YUVVideoQuadStatePtr result_yuv_video_quad_state;
      if (!input.ReadYuvVideoQuadState(&result_yuv_video_quad_state))
        return false;

      *output = UnionType::NewYuvVideoQuadState(
          std::move(result_yuv_video_quad_state));
      break;
    }
    case Tag::VIDEO_HOLE_QUAD_STATE: {
      ::viz::mojom::VideoHoleQuadStatePtr result_video_hole_quad_state;
      if (!input.ReadVideoHoleQuadState(&result_video_hole_quad_state))
        return false;

      *output = UnionType::NewVideoHoleQuadState(
          std::move(result_video_hole_quad_state));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif