// third_party/blink/public/mojom/timing/performance_mark_or_measure.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/timing/performance_mark_or_measure.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/timing/performance_mark_or_measure.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, PerformanceMarkOrMeasure_EntryType value) {
  switch(value) {
    case PerformanceMarkOrMeasure_EntryType::kMark:
      return os << "PerformanceMarkOrMeasure_EntryType::kMark";
    case PerformanceMarkOrMeasure_EntryType::kMeasure:
      return os << "PerformanceMarkOrMeasure_EntryType::kMeasure";
    default:
      return os << "Unknown PerformanceMarkOrMeasure_EntryType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool PerformanceMarkOrMeasure_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PerformanceMarkOrMeasure_Data* object = static_cast<const PerformanceMarkOrMeasure_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PerformanceMarkOrMeasure_EntryType_Data
        ::Validate(object->entry_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->detail, validation_context))
    return false;

  return true;
}

PerformanceMarkOrMeasure_Data::PerformanceMarkOrMeasure_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink