/* rygel-tracker-metadata-multivalues.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-tracker-metadata-multivalues.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-tracker3.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	RYGEL_TRACKER_METADATA_MULTI_VALUES_0_PROPERTY,
	RYGEL_TRACKER_METADATA_MULTI_VALUES_NUM_PROPERTIES
};
static GParamSpec* rygel_tracker_metadata_multi_values_properties[RYGEL_TRACKER_METADATA_MULTI_VALUES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static gpointer rygel_tracker_metadata_multi_values_parent_class = NULL;

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN void rygel_tracker_metadata_container_fetch_metadata_values (RygelTrackerMetadataContainer* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void rygel_tracker_metadata_container_fetch_metadata_values_finish (RygelTrackerMetadataContainer* self,
                                                                    GAsyncResult* _res_);
static RygelTrackerSelectionQuery* rygel_tracker_metadata_multi_values_real_create_query (RygelTrackerMetadataContainer* base);
static RygelTrackerSearchContainer* rygel_tracker_metadata_multi_values_real_create_container (RygelTrackerMetadataContainer* base,
                                                                                        const gchar* id,
                                                                                        const gchar* title,
                                                                                        const gchar* value);
static void rygel_tracker_metadata_multi_values_finalize (GObject * obj);
static GType rygel_tracker_metadata_multi_values_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

RygelTrackerMetadataMultiValues*
rygel_tracker_metadata_multi_values_construct (GType object_type,
                                               const gchar* id,
                                               RygelMediaContainer* parent,
                                               const gchar* title,
                                               RygelTrackerItemFactory* item_factory,
                                               gchar** key_chain,
                                               gint key_chain_length1,
                                               const gchar* child_class)
{
	RygelTrackerMetadataMultiValues * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	self = (RygelTrackerMetadataMultiValues*) rygel_tracker_metadata_container_construct (object_type, id, parent, title, item_factory, child_class);
	_tmp0_ = (key_chain != NULL) ? _vala_array_dup1 (key_chain, key_chain_length1) : key_chain;
	_tmp0__length1 = key_chain_length1;
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	self->key_chain = _tmp0_;
	self->key_chain_length1 = _tmp0__length1;
	rygel_tracker_metadata_container_fetch_metadata_values ((RygelTrackerMetadataContainer*) self, NULL, NULL);
	return self;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static RygelTrackerSelectionQuery*
rygel_tracker_metadata_multi_values_real_create_query (RygelTrackerMetadataContainer* base)
{
	RygelTrackerMetadataMultiValues * self;
	RygelTrackerQueryTriplets* _tmp0_;
	RygelTrackerQueryTriplets* _tmp1_;
	RygelTrackerItemFactory* _tmp2_;
	const gchar* _tmp3_;
	RygelTrackerQueryTriplet* _tmp4_;
	RygelTrackerQueryTriplet* _tmp5_;
	RygelTrackerQueryTriplets* _tmp6_;
	RygelTrackerQueryTriplet* _tmp7_;
	RygelTrackerQueryTriplet* _tmp8_;
	gint num_keys = 0;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** variables = NULL;
	gchar** _tmp10_;
	gint variables_length1;
	gint _variables_size_;
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp31_;
	gchar* last_variable = NULL;
	gchar** _tmp32_;
	gint _tmp32__length1;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	RygelTrackerQueryTriplets* _tmp37_;
	RygelTrackerItemFactory* _tmp38_;
	const gchar* _tmp39_;
	RygelTrackerSelectionQuery* _tmp40_;
	RygelTrackerSelectionQuery* result;
	self = (RygelTrackerMetadataMultiValues*) base;
	_tmp0_ = rygel_tracker_query_triplets_new ();
	_g_object_unref0 (((RygelTrackerMetadataContainer*) self)->triplets);
	((RygelTrackerMetadataContainer*) self)->triplets = _tmp0_;
	_tmp1_ = ((RygelTrackerMetadataContainer*) self)->triplets;
	_tmp2_ = ((RygelTrackerMetadataContainer*) self)->item_factory;
	_tmp3_ = _tmp2_->category;
	_tmp4_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", _tmp3_);
	_tmp5_ = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp5_);
	_rygel_tracker_query_triplet_unref0 (_tmp5_);
	_tmp6_ = ((RygelTrackerMetadataContainer*) self)->triplets;
	_tmp7_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "nie:isStoredAs", RYGEL_TRACKER_SELECTION_QUERY_STORAGE_VARIABLE);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
	_rygel_tracker_query_triplet_unref0 (_tmp8_);
	_tmp9_ = self->key_chain;
	_tmp9__length1 = self->key_chain_length1;
	num_keys = _tmp9__length1 - 1;
	_tmp10_ = g_new0 (gchar*, num_keys + 1);
	variables = _tmp10_;
	variables_length1 = num_keys;
	_variables_size_ = variables_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* subject = NULL;
				RygelTrackerQueryTriplets* _tmp23_;
				const gchar* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				RygelTrackerQueryTriplet* _tmp29_;
				RygelTrackerQueryTriplet* _tmp30_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < num_keys)) {
					break;
				}
				_tmp13_ = variables;
				_tmp13__length1 = variables_length1;
				_tmp14_ = self->key_chain;
				_tmp14__length1 = self->key_chain_length1;
				_tmp15_ = _tmp14_[i];
				_tmp16_ = string_replace (_tmp15_, ":", "_");
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("?", _tmp17_, NULL);
				_g_free0 (_tmp13_[i]);
				_tmp13_[i] = _tmp18_;
				_g_free0 (_tmp17_);
				if (i == 0) {
					gchar* _tmp19_;
					_tmp19_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
					_g_free0 (subject);
					subject = _tmp19_;
				} else {
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = variables;
					_tmp20__length1 = variables_length1;
					_tmp21_ = _tmp20_[i - 1];
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (subject);
					subject = _tmp22_;
				}
				_tmp23_ = ((RygelTrackerMetadataContainer*) self)->triplets;
				_tmp24_ = subject;
				_tmp25_ = self->key_chain;
				_tmp25__length1 = self->key_chain_length1;
				_tmp26_ = _tmp25_[i];
				_tmp27_ = variables;
				_tmp27__length1 = variables_length1;
				_tmp28_ = _tmp27_[i];
				_tmp29_ = rygel_tracker_query_triplet_new (_tmp24_, _tmp26_, _tmp28_);
				_tmp30_ = _tmp29_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp30_);
				_rygel_tracker_query_triplet_unref0 (_tmp30_);
				_g_free0 (subject);
			}
		}
	}
	_tmp31_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	selected = _tmp31_;
	_tmp32_ = variables;
	_tmp32__length1 = variables_length1;
	_tmp33_ = _tmp32_[num_keys - 1];
	_tmp34_ = g_strdup (_tmp33_);
	last_variable = _tmp34_;
	_tmp35_ = g_strconcat ("DISTINCT ", last_variable, NULL);
	_tmp36_ = _tmp35_;
	gee_abstract_collection_add ((GeeAbstractCollection*) selected, _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = ((RygelTrackerMetadataContainer*) self)->triplets;
	_tmp38_ = ((RygelTrackerMetadataContainer*) self)->item_factory;
	_tmp39_ = _tmp38_->graph;
	_tmp40_ = rygel_tracker_selection_query_new (selected, _tmp37_, NULL, _tmp39_, last_variable, 0, -1);
	result = _tmp40_;
	_g_free0 (last_variable);
	_g_object_unref0 (selected);
	variables = (_vala_array_free (variables, variables_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static RygelTrackerSearchContainer*
rygel_tracker_metadata_multi_values_real_create_container (RygelTrackerMetadataContainer* base,
                                                           const gchar* id,
                                                           const gchar* title,
                                                           const gchar* value)
{
	RygelTrackerMetadataMultiValues * self;
	RygelTrackerQueryTriplets* child_triplets = NULL;
	RygelTrackerQueryTriplets* _tmp0_;
	RygelTrackerQueryTriplets* _tmp1_;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp2_;
	gchar* filter = NULL;
	gpointer _tmp3_;
	RygelTrackerQueryTriplet* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RygelTrackerItemFactory* _tmp8_;
	RygelTrackerSearchContainer* _tmp9_;
	RygelTrackerSearchContainer* result;
	self = (RygelTrackerMetadataMultiValues*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = ((RygelTrackerMetadataContainer*) self)->triplets;
	_tmp1_ = rygel_tracker_query_triplets_new_clone (_tmp0_);
	child_triplets = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filters = _tmp2_;
	_tmp3_ = gee_list_last ((GeeList*) child_triplets);
	_tmp4_ = (RygelTrackerQueryTriplet*) _tmp3_;
	_tmp5_ = _tmp4_->obj;
	_tmp6_ = rygel_tracker_metadata_container_create_filter ((RygelTrackerMetadataContainer*) self, _tmp5_, value);
	_tmp7_ = _tmp6_;
	_rygel_tracker_query_triplet_unref0 (_tmp4_);
	filter = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, filter);
	_tmp8_ = ((RygelTrackerMetadataContainer*) self)->item_factory;
	_tmp9_ = rygel_tracker_search_container_new (id, (RygelMediaContainer*) self, title, _tmp8_, child_triplets, filters);
	result = _tmp9_;
	_g_free0 (filter);
	_g_object_unref0 (filters);
	_g_object_unref0 (child_triplets);
	return result;
}

static void
rygel_tracker_metadata_multi_values_class_init (RygelTrackerMetadataMultiValuesClass * klass,
                                                gpointer klass_data)
{
	rygel_tracker_metadata_multi_values_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerMetadataContainerClass *) klass)->create_query = (RygelTrackerSelectionQuery* (*) (RygelTrackerMetadataContainer*)) rygel_tracker_metadata_multi_values_real_create_query;
	((RygelTrackerMetadataContainerClass *) klass)->create_container = (RygelTrackerSearchContainer* (*) (RygelTrackerMetadataContainer*, const gchar*, const gchar*, const gchar*)) rygel_tracker_metadata_multi_values_real_create_container;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_metadata_multi_values_finalize;
}

static void
rygel_tracker_metadata_multi_values_instance_init (RygelTrackerMetadataMultiValues * self,
                                                   gpointer klass)
{
}

static void
rygel_tracker_metadata_multi_values_finalize (GObject * obj)
{
	RygelTrackerMetadataMultiValues * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_METADATA_MULTI_VALUES, RygelTrackerMetadataMultiValues);
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_tracker_metadata_multi_values_parent_class)->finalize (obj);
}

/**
 * Container listing possible values of a particuler Tracker metadata key.
 * This class is used for multivalue properties such as nao:Tag (via
 * nao:hasTag)
 */
static GType
rygel_tracker_metadata_multi_values_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataMultiValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_metadata_multi_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMetadataMultiValues), 0, (GInstanceInitFunc) rygel_tracker_metadata_multi_values_instance_init, NULL };
	GType rygel_tracker_metadata_multi_values_type_id;
	rygel_tracker_metadata_multi_values_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_METADATA_CONTAINER, "RygelTrackerMetadataMultiValues", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return rygel_tracker_metadata_multi_values_type_id;
}

GType
rygel_tracker_metadata_multi_values_get_type (void)
{
	static volatile gsize rygel_tracker_metadata_multi_values_type_id__once = 0;
	if (g_once_init_enter (&rygel_tracker_metadata_multi_values_type_id__once)) {
		GType rygel_tracker_metadata_multi_values_type_id;
		rygel_tracker_metadata_multi_values_type_id = rygel_tracker_metadata_multi_values_get_type_once ();
		g_once_init_leave (&rygel_tracker_metadata_multi_values_type_id__once, rygel_tracker_metadata_multi_values_type_id);
	}
	return rygel_tracker_metadata_multi_values_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

