/* chess-player.c generated by valac 0.56.0, the Vala compiler
 * generated from chess-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libchess.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	CHESS_PLAYER_0_PROPERTY,
	CHESS_PLAYER_LOCAL_HUMAN_PROPERTY,
	CHESS_PLAYER_NUM_PROPERTIES
};
static GParamSpec* chess_player_properties[CHESS_PLAYER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CHESS_PLAYER_DO_MOVE_SIGNAL,
	CHESS_PLAYER_DO_UNDO_SIGNAL,
	CHESS_PLAYER_DO_RESIGN_SIGNAL,
	CHESS_PLAYER_DO_CLAIM_DRAW_SIGNAL,
	CHESS_PLAYER_NUM_SIGNALS
};
static guint chess_player_signals[CHESS_PLAYER_NUM_SIGNALS] = {0};

struct _ChessPlayerPrivate {
	gboolean _local_human;
};

static gint ChessPlayer_private_offset;
static gpointer chess_player_parent_class = NULL;

static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void chess_player_finalize (GObject * obj);
static GType chess_player_get_type_once (void);
static void _vala_chess_player_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_chess_player_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static GType
color_get_type_once (void)
{
	static const GEnumValue values[] = {{COLOR_WHITE, "COLOR_WHITE", "white"}, {COLOR_BLACK, "COLOR_BLACK", "black"}, {0, NULL, NULL}};
	GType color_type_id;
	color_type_id = g_enum_register_static ("Color", values);
	return color_type_id;
}

GType
color_get_type (void)
{
	static volatile gsize color_type_id__once = 0;
	if (g_once_init_enter (&color_type_id__once)) {
		GType color_type_id;
		color_type_id = color_get_type_once ();
		g_once_init_leave (&color_type_id__once, color_type_id);
	}
	return color_type_id__once;
}

static inline gpointer
chess_player_get_instance_private (ChessPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, ChessPlayer_private_offset);
}

ChessPlayer*
chess_player_construct (GType object_type,
                        Color color)
{
	ChessPlayer * self = NULL;
	self = (ChessPlayer*) g_object_new (object_type, NULL);
	self->color = color;
	return self;
}

ChessPlayer*
chess_player_new (Color color)
{
	return chess_player_construct (TYPE_CHESS_PLAYER, color);
}

gboolean
chess_player_move (ChessPlayer* self,
                   const gchar* move,
                   gboolean apply)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	g_signal_emit (self, chess_player_signals[CHESS_PLAYER_DO_MOVE_SIGNAL], 0, move, apply, &_tmp0_);
	result = _tmp0_;
	return result;
}

gboolean
chess_player_move_with_coords (ChessPlayer* self,
                               gint r0,
                               gint f0,
                               gint r1,
                               gint f1,
                               gboolean apply,
                               PieceType promotion_type)
{
	gchar* move = NULL;
	gchar* _tmp0_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%c%d%c%d", 'a' + f0, r0 + 1, 'a' + f1, r1 + 1);
	move = _tmp0_;
	switch (promotion_type) {
		case PIECE_TYPE_QUEEN:
		{
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = move;
			_tmp2_ = g_strconcat (_tmp1_, "=N", NULL);
			_g_free0 (move);
			move = _tmp2_;
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = move;
			_tmp4_ = g_strconcat (_tmp3_, "=R", NULL);
			_g_free0 (move);
			move = _tmp4_;
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = move;
			_tmp6_ = g_strconcat (_tmp5_, "=B", NULL);
			_g_free0 (move);
			move = _tmp6_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp7_ = move;
	g_signal_emit (self, chess_player_signals[CHESS_PLAYER_DO_MOVE_SIGNAL], 0, _tmp7_, apply, &_tmp8_);
	result = _tmp8_;
	_g_free0 (move);
	return result;
}

void
chess_player_undo (ChessPlayer* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, chess_player_signals[CHESS_PLAYER_DO_UNDO_SIGNAL], 0);
}

gboolean
chess_player_resign (ChessPlayer* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, chess_player_signals[CHESS_PLAYER_DO_RESIGN_SIGNAL], 0, &_tmp0_);
	result = _tmp0_;
	return result;
}

void
chess_player_claim_draw (ChessPlayer* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, chess_player_signals[CHESS_PLAYER_DO_CLAIM_DRAW_SIGNAL], 0);
}

gboolean
chess_player_get_local_human (ChessPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_local_human;
	return result;
}

void
chess_player_set_local_human (ChessPlayer* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_local_human = value;
	g_object_notify_by_pspec ((GObject *) self, chess_player_properties[CHESS_PLAYER_LOCAL_HUMAN_PROPERTY]);
}

static void
g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static void
chess_player_class_init (ChessPlayerClass * klass,
                         gpointer klass_data)
{
	chess_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PLAYER_LOCAL_HUMAN_PROPERTY, chess_player_properties[CHESS_PLAYER_LOCAL_HUMAN_PROPERTY] = g_param_spec_boolean ("local-human", "local-human", "local-human", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	chess_player_signals[CHESS_PLAYER_DO_MOVE_SIGNAL] = g_signal_new ("do-move", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	chess_player_signals[CHESS_PLAYER_DO_UNDO_SIGNAL] = g_signal_new ("do-undo", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_player_signals[CHESS_PLAYER_DO_RESIGN_SIGNAL] = g_signal_new ("do-resign", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	chess_player_signals[CHESS_PLAYER_DO_CLAIM_DRAW_SIGNAL] = g_signal_new ("do-claim-draw", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
chess_player_instance_init (ChessPlayer * self,
                            gpointer klass)
{
	self->priv = chess_player_get_instance_private (self);
	self->priv->_local_human = FALSE;
}

static void
chess_player_finalize (GObject * obj)
{
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PLAYER, ChessPlayer);
	G_OBJECT_CLASS (chess_player_parent_class)->finalize (obj);
}

static GType
chess_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPlayer), 0, (GInstanceInitFunc) chess_player_instance_init, NULL };
	GType chess_player_type_id;
	chess_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPlayer", &g_define_type_info, 0);
	ChessPlayer_private_offset = g_type_add_instance_private (chess_player_type_id, sizeof (ChessPlayerPrivate));
	return chess_player_type_id;
}

GType
chess_player_get_type (void)
{
	static volatile gsize chess_player_type_id__once = 0;
	if (g_once_init_enter (&chess_player_type_id__once)) {
		GType chess_player_type_id;
		chess_player_type_id = chess_player_get_type_once ();
		g_once_init_leave (&chess_player_type_id__once, chess_player_type_id);
	}
	return chess_player_type_id__once;
}

static void
_vala_chess_player_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN_PROPERTY:
		g_value_set_boolean (value, chess_player_get_local_human (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_player_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN_PROPERTY:
		chess_player_set_local_human (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

