// services/network/public/mojom/cors_origin_pattern.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cors_origin_pattern.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-params-data.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
CorsOriginPattern::CorsOriginPattern()
    : protocol(),
      domain(),
      port(),
      domain_match_mode(),
      port_match_mode(),
      priority() {}

CorsOriginPattern::CorsOriginPattern(
    const std::string& protocol_in,
    const std::string& domain_in,
    uint16_t port_in,
    CorsDomainMatchMode domain_match_mode_in,
    CorsPortMatchMode port_match_mode_in,
    CorsOriginAccessMatchPriority priority_in)
    : protocol(std::move(protocol_in)),
      domain(std::move(domain_in)),
      port(std::move(port_in)),
      domain_match_mode(std::move(domain_match_mode_in)),
      port_match_mode(std::move(port_match_mode_in)),
      priority(std::move(priority_in)) {}

CorsOriginPattern::~CorsOriginPattern() = default;
size_t CorsOriginPattern::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->protocol);
  seed = mojo::internal::Hash(seed, this->domain);
  seed = mojo::internal::Hash(seed, this->port);
  seed = mojo::internal::Hash(seed, this->domain_match_mode);
  seed = mojo::internal::Hash(seed, this->port_match_mode);
  seed = mojo::internal::Hash(seed, this->priority);
  return seed;
}

void CorsOriginPattern::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("protocol", this->protocol);
  value->SetString("domain", this->domain);
  value->SetInteger("port", this->port);
  value->SetString("domain_match_mode", base::trace_event::ValueToString(this->domain_match_mode));
  value->SetString("port_match_mode", base::trace_event::ValueToString(this->port_match_mode));
  value->SetString("priority", base::trace_event::ValueToString(this->priority));
}

bool CorsOriginPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CorsOriginAccessPatterns::CorsOriginAccessPatterns()
    : source_origin(),
      allow_patterns(),
      block_patterns() {}

CorsOriginAccessPatterns::CorsOriginAccessPatterns(
    const ::url::Origin& source_origin_in,
    std::vector<CorsOriginPatternPtr> allow_patterns_in,
    std::vector<CorsOriginPatternPtr> block_patterns_in)
    : source_origin(std::move(source_origin_in)),
      allow_patterns(std::move(allow_patterns_in)),
      block_patterns(std::move(block_patterns_in)) {}

CorsOriginAccessPatterns::~CorsOriginAccessPatterns() = default;

void CorsOriginAccessPatterns::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("source_origin", base::trace_event::ValueToString(this->source_origin, "<value of type const ::url::Origin&>"));
  value->BeginArray("allow_patterns");
  for (const auto& item0 : this->allow_patterns) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("block_patterns");
  for (const auto& item0 : this->block_patterns) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool CorsOriginAccessPatterns::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CorsOriginPattern::DataView, ::network::mojom::CorsOriginPatternPtr>::Read(
    ::network::mojom::CorsOriginPattern::DataView input,
    ::network::mojom::CorsOriginPatternPtr* output) {
  bool success = true;
  ::network::mojom::CorsOriginPatternPtr result(::network::mojom::CorsOriginPattern::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadDomainMatchMode(&result->domain_match_mode))
        success = false;
      if (success && !input.ReadPortMatchMode(&result->port_match_mode))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CorsOriginAccessPatterns::DataView, ::network::mojom::CorsOriginAccessPatternsPtr>::Read(
    ::network::mojom::CorsOriginAccessPatterns::DataView input,
    ::network::mojom::CorsOriginAccessPatternsPtr* output) {
  bool success = true;
  ::network::mojom::CorsOriginAccessPatternsPtr result(::network::mojom::CorsOriginAccessPatterns::New());
  
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
      if (success && !input.ReadAllowPatterns(&result->allow_patterns))
        success = false;
      if (success && !input.ReadBlockPatterns(&result->block_patterns))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif