import { GetVersion } from '../types/GetVersion';
import { Index } from '../types/IndexType';
import { Options } from '../types/Options';
import { SpawnOptions } from '../types/SpawnOptions';
import { NpmOptions } from '../types/NpmOptions';
export interface NpmScope {
    npmAlwaysAuth?: boolean;
    npmAuthToken?: string;
    npmRegistryServer?: string;
}
/** Reads an auth token from a yarn config, interpolates it, and sets it on the npm config. */
export declare const setNpmAuthToken: (npmConfig: Index<string | boolean>, [dep, scopedConfig]: [string, NpmScope]) => void;
/**
 * Spawn yarn requires a different command on Windows.
 *
 * @param args
 * @param [yarnOptions={}]
 * @param [spawnOptions={}]
 * @returns
 */
declare function spawnYarn(args: string | string[], yarnOptions?: NpmOptions, spawnOptions?: SpawnOptions): Promise<string>;
/**
 * Get platform-specific default prefix to pass on to yarn.
 *
 * @param options
 * @param [options.global]
 * @param [options.prefix]
 * @returns
 */
export declare function defaultPrefix(options: Options): Promise<any>;
/**
 * Fetches the list of all installed packages.
 *
 * @param [options]
 * @param [options.cwd]
 * @param [options.global]
 * @param [options.prefix]
 * @returns
 */
export declare const list: (options?: Options, spawnOptions?: SpawnOptions) => Promise<Index<R>>;
/**
 * Fetches the highest version number, regardless of tag or publish time.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const greatest: GetVersion;
/**
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const distTag: GetVersion;
/**
 * Fetches the version published to the latest tag.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const latest: GetVersion;
/**
 * Fetches the most recently published version, regardless of version number.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const newest: GetVersion;
/**
 * Fetches the highest version with the same major version as currentVersion.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const minor: GetVersion;
/**
 * Fetches the highest version with the same minor and major version as currentVersion.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns
 */
export declare const patch: GetVersion;
export default spawnYarn;
