"use strict";

require("@testing-library/jest-dom/extend-expect");

var _react = require("@testing-library/react");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
(0, _react.configure)({
  testIdAttribute: "data-test-subj"
});
jest.mock("@elastic/eui/lib/components/form/form_row/make_id", () => () => "some_make_id");
jest.mock("@elastic/eui/lib/services/accessibility/html_id_generator", () => ({
  htmlIdGenerator: () => {
    return () => "some_html_id";
  }
})); // @ts-ignore

window.Worker = function () {
  this.postMessage = () => {}; // @ts-ignore


  this.terminate = () => {};
}; // @ts-ignore


window.URL = {
  createObjectURL: () => {
    return "";
  }
}; // https://github.com/elastic/eui/issues/2530

jest.mock("@elastic/eui/lib/components/icon", () => ({
  EuiIcon: () => "EuiIconMock",
  __esModule: true,
  IconPropType: require("@elastic/eui/lib/components/icon/icon").IconPropType,
  ICON_TYPES: require("@elastic/eui/lib/components/icon/icon").TYPES,
  ICON_SIZES: require("@elastic/eui/lib/components/icon/icon").SIZES,
  ICON_COLORS: require("@elastic/eui/lib/components/icon/icon").COLORS
}));
jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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