#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#include <wayland-client-core.h>
#include <wayland-server-core.h>
#include <wayland-version.h>

#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>

struct wl_listener_container {
    void *handle;
    struct wl_listener destroy_listener;
};

/* This code is taken from Weston (MIT licensed) to provide access to anonymous
 * files with CLOEXEC set
 * Copyright (c) 2012 Collabora, Ltd.
 * http://cgit.freedesktop.org/wayland/weston/tree/shared/os-compatibility.c?id=1.8.0
 */

static int
set_cloexec_or_close(int fd)
{
    long flags;

    if (fd == -1)
        return -1;

    flags = fcntl(fd, F_GETFD);
    if (flags == -1)
        goto err;

    if (fcntl(fd, F_SETFD, flags | FD_CLOEXEC) == -1)
        goto err;

    return fd;

err:
    close(fd);
    return -1;
}

static int
create_tmpfile_cloexec(char *tmpname)
{
    int fd;

#ifdef HAVE_MKOSTEMP
    fd = mkostemp(tmpname, O_CLOEXEC);
    if (fd >= 0)
        unlink(tmpname);
#else
    fd = mkstemp(tmpname);
    if (fd >= 0) {
        fd = set_cloexec_or_close(fd);
        unlink(tmpname);
    }
#endif

    return fd;
}

int
os_create_anonymous_file(off_t size)
{
    static const char template[] = "/weston-shared-XXXXXX";
    const char *path;
    char *name;
    int fd;
    int ret;

    path = getenv("XDG_RUNTIME_DIR");
    if (!path) {
        errno = ENOENT;
        return -1;
    }

    name = malloc(strlen(path) + sizeof(template));
    if (!name)
        return -1;

    strcpy(name, path);
    strcat(name, template);

    fd = create_tmpfile_cloexec(name);

    free(name);

    if (fd < 0)
        return -1;

#ifdef HAVE_POSIX_FALLOCATE
    ret = posix_fallocate(fd, 0, size);
    if (ret != 0) {
        close(fd);
        errno = ret;
        return -1;
    }
#else
    ret = ftruncate(fd, size);
    if (ret < 0) {
        close(fd);
        return -1;
    }
#endif

    return fd;
}


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // char const *()(struct wl_display *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 262), // struct wl_display *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 70), // double()(int32_t)
/*  4 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(int)
/*  7 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(int, uint32_t, void *)
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 283), // void *
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(int, void *)
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_display *)
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_display *, char const *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 256), // char const *
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_display *, struct wl_event_queue *)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 264), // struct wl_event_queue *
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_event_loop *)
/* 30 */ _CFFI_OP(_CFFI_OP_POINTER, 263), // struct wl_event_loop *
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_event_loop *, int)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_event_source *)
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // struct wl_event_source *
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_event_source *, int)
/* 40 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_event_source *, uint32_t)
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 45 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_list const *)
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 269), // struct wl_list const *
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_proxy *, int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *), void const *, void *)
/* 51 */ _CFFI_OP(_CFFI_OP_POINTER, 275), // struct wl_proxy *
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 62), // int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 53 */ _CFFI_OP(_CFFI_OP_POINTER, 283), // void const *
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(struct wl_resource *)
/* 57 */ _CFFI_OP(_CFFI_OP_POINTER, 276), // struct wl_resource *
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(void *)
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // int()(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 66 */ _CFFI_OP(_CFFI_OP_POINTER, 272), // struct wl_message const *
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 279), // union wl_argument *
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int32_t()(double)
/* 70 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int32_t()(int)
/* 73 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 139), // struct wl_client *()(struct wl_display *, int)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION, 139), // struct wl_client *()(struct wl_resource *)
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct wl_display *()(char const *)
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct wl_display *()(int)
/* 86 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct wl_display *()(void)
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // struct wl_event_loop *()(struct wl_display *)
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // struct wl_event_loop *()(void)
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 27), // struct wl_event_queue *()(struct wl_display *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 37), // struct wl_event_source *()(struct wl_event_loop *, int(*)(void *), void *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 100 */ _CFFI_OP(_CFFI_OP_POINTER, 59), // int(*)(void *)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 37), // struct wl_event_source *()(struct wl_event_loop *, int, int(*)(int, void *), void *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 106 */ _CFFI_OP(_CFFI_OP_POINTER, 14), // int(*)(int, void *)
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 37), // struct wl_event_source *()(struct wl_event_loop *, int, uint32_t, int(*)(int, uint32_t, void *), void *)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 113 */ _CFFI_OP(_CFFI_OP_POINTER, 9), // int(*)(int, uint32_t, void *)
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION, 37), // struct wl_event_source *()(struct wl_event_loop *, void(*)(void *), void *)
/* 117 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 118 */ _CFFI_OP(_CFFI_OP_POINTER, 253), // void(*)(void *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // struct wl_global *()(struct wl_display *, struct wl_interface const *, int, void *, void(*)(struct wl_client *, void *, uint32_t, uint32_t))
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 123 */ _CFFI_OP(_CFFI_OP_POINTER, 268), // struct wl_interface const *
/* 124 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 126 */ _CFFI_OP(_CFFI_OP_POINTER, 177), // void(*)(struct wl_client *, void *, uint32_t, uint32_t)
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // struct wl_proxy *()(struct wl_proxy *, struct wl_interface const *)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 123),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // struct wl_proxy *()(struct wl_proxy *, uint32_t, union wl_argument *, struct wl_interface const *)
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 123),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 57), // struct wl_resource *()(struct wl_client *, struct wl_interface const *, int, uint32_t)
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 261), // struct wl_client *
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 123),
/* 141 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 57), // struct wl_resource *()(struct wl_client *, uint32_t)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 278), // uint32_t *()(struct wl_display *, uint32_t)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // uint32_t()(struct wl_display *)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // uint32_t()(struct wl_resource *)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION, 12), // void *()(struct wl_proxy *)
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 12), // void *()(struct wl_resource *)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_client *)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_client *, int *, unsigned int *, unsigned int *)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 169 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // int *
/* 170 */ _CFFI_OP(_CFFI_OP_POINTER, 280), // unsigned int *
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 170),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_client *, struct wl_listener *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 175 */ _CFFI_OP(_CFFI_OP_POINTER, 270), // struct wl_listener *
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_client *, void *, uint32_t, uint32_t)
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 180 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_display *)
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_event_loop *)
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_event_loop *, struct wl_listener *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_event_queue *)
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_event_source *)
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_global *)
/* 200 */ _CFFI_OP(_CFFI_OP_POINTER, 266), // struct wl_global *
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_list *)
/* 203 */ _CFFI_OP(_CFFI_OP_POINTER, 269), // struct wl_list *
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_listener *, void *)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 207 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_proxy *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_proxy *, uint32_t, union wl_argument *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 214 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_proxy *, void *)
/* 218 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 219 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_resource *)
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_resource *, int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *), void const *, void *, void(*)(struct wl_resource *))
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 229 */ _CFFI_OP(_CFFI_OP_POINTER, 221), // void(*)(struct wl_resource *)
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_resource *, struct wl_listener *)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_resource *, uint32_t, char const *, ...)
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 237 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_resource *, uint32_t, union wl_argument *)
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 57),
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_signal *, struct wl_listener *)
/* 246 */ _CFFI_OP(_CFFI_OP_POINTER, 277), // struct wl_signal *
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 175),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(struct wl_signal *, void *)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 246),
/* 251 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION, 283), // void()(void *)
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 257 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum $1
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 259 */ _CFFI_OP(_CFFI_OP_POINTER, 260), // struct wl_array *
/* 260 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct wl_array
/* 261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct wl_client
/* 262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct wl_display
/* 263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct wl_event_loop
/* 264 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct wl_event_queue
/* 265 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct wl_event_source
/* 266 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct wl_global
/* 267 */ _CFFI_OP(_CFFI_OP_POINTER, 123), // struct wl_interface const * *
/* 268 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct wl_interface
/* 269 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct wl_list
/* 270 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct wl_listener
/* 271 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct wl_listener_container
/* 272 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct wl_message
/* 273 */ _CFFI_OP(_CFFI_OP_POINTER, 274), // struct wl_object *
/* 274 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct wl_object
/* 275 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct wl_proxy
/* 276 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct wl_resource
/* 277 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct wl_signal
/* 278 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // uint32_t *
/* 279 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union wl_argument
/* 280 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 281 */ _CFFI_OP(_CFFI_OP_POINTER, 205), // void(*)(struct wl_listener *, void *)
/* 282 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // void(*)(struct wl_resource *, uint32_t, char const *, ...)
/* 283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_WL_EVENT_READABLE(unsigned long long *o)
{
  int n = (WL_EVENT_READABLE) <= 0;
  *o = (unsigned long long)((WL_EVENT_READABLE) | 0);  /* check that WL_EVENT_READABLE is an integer */
  return n;
}

static int _cffi_const_WL_EVENT_WRITABLE(unsigned long long *o)
{
  int n = (WL_EVENT_WRITABLE) <= 0;
  *o = (unsigned long long)((WL_EVENT_WRITABLE) | 0);  /* check that WL_EVENT_WRITABLE is an integer */
  return n;
}

static int _cffi_const_WL_EVENT_HANGUP(unsigned long long *o)
{
  int n = (WL_EVENT_HANGUP) <= 0;
  *o = (unsigned long long)((WL_EVENT_HANGUP) | 0);  /* check that WL_EVENT_HANGUP is an integer */
  return n;
}

static int _cffi_const_WL_EVENT_ERROR(unsigned long long *o)
{
  int n = (WL_EVENT_ERROR) <= 0;
  *o = (unsigned long long)((WL_EVENT_ERROR) | 0);  /* check that WL_EVENT_ERROR is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__dispatcher_func =
  { "pywayland._ffi.dispatcher_func", (int)sizeof(int), 0, 0 };

static int dispatcher_func(void const * a0, void * a1, uint32_t a2, struct wl_message const * a3, union wl_argument * a4)
{
  char a[40];
  char *p = a;
  *(void const * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(uint32_t *)(p + 16) = a2;
  *(struct wl_message const * *)(p + 24) = a3;
  *(union wl_argument * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy__dispatcher_func, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__event_loop_fd_func =
  { "pywayland._ffi.event_loop_fd_func", (int)sizeof(int), 0, 0 };

static int event_loop_fd_func(int a0, uint32_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(uint32_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__event_loop_fd_func, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__event_loop_idle_func =
  { "pywayland._ffi.event_loop_idle_func", 0, 0, 0 };

static void event_loop_idle_func(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__event_loop_idle_func, p);
}

static struct _cffi_externpy_s _cffi_externpy__event_loop_signal_func =
  { "pywayland._ffi.event_loop_signal_func", (int)sizeof(int), 0, 0 };

static int event_loop_signal_func(int a0, void * a1)
{
  char a[16];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__event_loop_signal_func, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__event_loop_timer_func =
  { "pywayland._ffi.event_loop_timer_func", (int)sizeof(int), 0, 0 };

static int event_loop_timer_func(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__event_loop_timer_func, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__global_bind_func =
  { "pywayland._ffi.global_bind_func", 0, 0, 0 };

static void global_bind_func(struct wl_client * a0, void * a1, uint32_t a2, uint32_t a3)
{
  char a[32];
  char *p = a;
  *(struct wl_client * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(uint32_t *)(p + 16) = a2;
  *(uint32_t *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__global_bind_func, p);
}

static struct _cffi_externpy_s _cffi_externpy__notify_func =
  { "pywayland._ffi.notify_func", 0, 0, 0 };

static void notify_func(struct wl_listener * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct wl_listener * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__notify_func, p);
}

static struct _cffi_externpy_s _cffi_externpy__resource_destroy_func =
  { "pywayland._ffi.resource_destroy_func", 0, 0, 0 };

static void resource_destroy_func(struct wl_resource * a0)
{
  char a[8];
  char *p = a;
  *(struct wl_resource * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__resource_destroy_func, p);
}

static int _cffi_d_os_create_anonymous_file(int x0)
{
  return os_create_anonymous_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_os_create_anonymous_file(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = os_create_anonymous_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_os_create_anonymous_file _cffi_d_os_create_anonymous_file
#endif

static void _cffi_d_wl_client_add_destroy_listener(struct wl_client * x0, struct wl_listener * x1)
{
  wl_client_add_destroy_listener(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_add_destroy_listener(PyObject *self, PyObject *args)
{
  struct wl_client * x0;
  struct wl_listener * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_client_add_destroy_listener", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_listener *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_client_add_destroy_listener(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_client_add_destroy_listener _cffi_d_wl_client_add_destroy_listener
#endif

static struct wl_client * _cffi_d_wl_client_create(struct wl_display * x0, int x1)
{
  return wl_client_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_client * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_client_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_client_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(139));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_client_create _cffi_d_wl_client_create
#endif

static void _cffi_d_wl_client_destroy(struct wl_client * x0)
{
  wl_client_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_client * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_client_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_client_destroy _cffi_d_wl_client_destroy
#endif

static void _cffi_d_wl_client_flush(struct wl_client * x0)
{
  wl_client_flush(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_flush(PyObject *self, PyObject *arg0)
{
  struct wl_client * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_client_flush(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_client_flush _cffi_d_wl_client_flush
#endif

static void _cffi_d_wl_client_get_credentials(struct wl_client * x0, int * x1, unsigned int * x2, unsigned int * x3)
{
  wl_client_get_credentials(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_get_credentials(PyObject *self, PyObject *args)
{
  struct wl_client * x0;
  int * x1;
  unsigned int * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wl_client_get_credentials", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(169), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(169), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(170), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(170), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(170), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(170), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_client_get_credentials(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_client_get_credentials _cffi_d_wl_client_get_credentials
#endif

static struct wl_resource * _cffi_d_wl_client_get_object(struct wl_client * x0, uint32_t x1)
{
  return wl_client_get_object(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_client_get_object(PyObject *self, PyObject *args)
{
  struct wl_client * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_resource * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_client_get_object", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_client_get_object(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(57));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_client_get_object _cffi_d_wl_client_get_object
#endif

static uint32_t * _cffi_d_wl_display_add_shm_format(struct wl_display * x0, uint32_t x1)
{
  return wl_display_add_shm_format(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_add_shm_format(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_add_shm_format", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_add_shm_format(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(278));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_add_shm_format _cffi_d_wl_display_add_shm_format
#endif

static int _cffi_d_wl_display_add_socket(struct wl_display * x0, char const * x1)
{
  return wl_display_add_socket(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_add_socket(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_add_socket", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_add_socket(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_add_socket _cffi_d_wl_display_add_socket
#endif

static char const * _cffi_d_wl_display_add_socket_auto(struct wl_display * x0)
{
  return wl_display_add_socket_auto(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_add_socket_auto(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_add_socket_auto(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_add_socket_auto _cffi_d_wl_display_add_socket_auto
#endif

static struct wl_display * _cffi_d_wl_display_connect(char const * x0)
{
  return wl_display_connect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_connect(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_display * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_connect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_connect _cffi_d_wl_display_connect
#endif

static struct wl_display * _cffi_d_wl_display_connect_to_fd(int x0)
{
  return wl_display_connect_to_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_connect_to_fd(PyObject *self, PyObject *arg0)
{
  int x0;
  struct wl_display * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_connect_to_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_wl_display_connect_to_fd _cffi_d_wl_display_connect_to_fd
#endif

static struct wl_display * _cffi_d_wl_display_create(void)
{
  return wl_display_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_create(PyObject *self, PyObject *noarg)
{
  struct wl_display * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_wl_display_create _cffi_d_wl_display_create
#endif

static struct wl_event_queue * _cffi_d_wl_display_create_queue(struct wl_display * x0)
{
  return wl_display_create_queue(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_create_queue(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_queue * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_create_queue(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(27));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_create_queue _cffi_d_wl_display_create_queue
#endif

static void _cffi_d_wl_display_destroy(struct wl_display * x0)
{
  wl_display_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_destroy _cffi_d_wl_display_destroy
#endif

static void _cffi_d_wl_display_destroy_clients(struct wl_display * x0)
{
  wl_display_destroy_clients(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_destroy_clients(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_destroy_clients(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_destroy_clients _cffi_d_wl_display_destroy_clients
#endif

static void _cffi_d_wl_display_disconnect(struct wl_display * x0)
{
  wl_display_disconnect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_disconnect(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_disconnect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_disconnect _cffi_d_wl_display_disconnect
#endif

static int _cffi_d_wl_display_dispatch(struct wl_display * x0)
{
  return wl_display_dispatch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_dispatch(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_dispatch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_dispatch _cffi_d_wl_display_dispatch
#endif

static int _cffi_d_wl_display_dispatch_pending(struct wl_display * x0)
{
  return wl_display_dispatch_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_dispatch_pending(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_dispatch_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_dispatch_pending _cffi_d_wl_display_dispatch_pending
#endif

static int _cffi_d_wl_display_dispatch_queue(struct wl_display * x0, struct wl_event_queue * x1)
{
  return wl_display_dispatch_queue(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_dispatch_queue(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wl_event_queue * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_dispatch_queue", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_event_queue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_dispatch_queue(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_dispatch_queue _cffi_d_wl_display_dispatch_queue
#endif

static int _cffi_d_wl_display_dispatch_queue_pending(struct wl_display * x0, struct wl_event_queue * x1)
{
  return wl_display_dispatch_queue_pending(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_dispatch_queue_pending(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wl_event_queue * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_dispatch_queue_pending", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_event_queue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_dispatch_queue_pending(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_dispatch_queue_pending _cffi_d_wl_display_dispatch_queue_pending
#endif

static int _cffi_d_wl_display_flush(struct wl_display * x0)
{
  return wl_display_flush(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_flush(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_flush(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_flush _cffi_d_wl_display_flush
#endif

static void _cffi_d_wl_display_flush_clients(struct wl_display * x0)
{
  wl_display_flush_clients(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_flush_clients(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_flush_clients(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_flush_clients _cffi_d_wl_display_flush_clients
#endif

static int _cffi_d_wl_display_get_error(struct wl_display * x0)
{
  return wl_display_get_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_get_error(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_get_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_get_error _cffi_d_wl_display_get_error
#endif

static struct wl_event_loop * _cffi_d_wl_display_get_event_loop(struct wl_display * x0)
{
  return wl_display_get_event_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_get_event_loop(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_loop * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_get_event_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(30));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_get_event_loop _cffi_d_wl_display_get_event_loop
#endif

static int _cffi_d_wl_display_get_fd(struct wl_display * x0)
{
  return wl_display_get_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_get_fd(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_get_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_get_fd _cffi_d_wl_display_get_fd
#endif

static uint32_t _cffi_d_wl_display_get_serial(struct wl_display * x0)
{
  return wl_display_get_serial(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_get_serial(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_get_serial(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_get_serial _cffi_d_wl_display_get_serial
#endif

static int _cffi_d_wl_display_init_shm(struct wl_display * x0)
{
  return wl_display_init_shm(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_init_shm(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_init_shm(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_init_shm _cffi_d_wl_display_init_shm
#endif

static uint32_t _cffi_d_wl_display_next_serial(struct wl_display * x0)
{
  return wl_display_next_serial(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_next_serial(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_next_serial(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_next_serial _cffi_d_wl_display_next_serial
#endif

static int _cffi_d_wl_display_prepare_read(struct wl_display * x0)
{
  return wl_display_prepare_read(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_prepare_read(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_prepare_read(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_prepare_read _cffi_d_wl_display_prepare_read
#endif

static int _cffi_d_wl_display_prepare_read_queue(struct wl_display * x0, struct wl_event_queue * x1)
{
  return wl_display_prepare_read_queue(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_prepare_read_queue(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wl_event_queue * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_prepare_read_queue", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_event_queue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_prepare_read_queue(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_prepare_read_queue _cffi_d_wl_display_prepare_read_queue
#endif

static int _cffi_d_wl_display_read_events(struct wl_display * x0)
{
  return wl_display_read_events(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_read_events(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_read_events(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_read_events _cffi_d_wl_display_read_events
#endif

static int _cffi_d_wl_display_roundtrip(struct wl_display * x0)
{
  return wl_display_roundtrip(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_roundtrip(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_roundtrip(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_roundtrip _cffi_d_wl_display_roundtrip
#endif

static int _cffi_d_wl_display_roundtrip_queue(struct wl_display * x0, struct wl_event_queue * x1)
{
  return wl_display_roundtrip_queue(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_roundtrip_queue(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wl_event_queue * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_display_roundtrip_queue", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_event_queue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_display_roundtrip_queue(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_display_roundtrip_queue _cffi_d_wl_display_roundtrip_queue
#endif

static void _cffi_d_wl_display_run(struct wl_display * x0)
{
  wl_display_run(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_run(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_run(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_run _cffi_d_wl_display_run
#endif

static void _cffi_d_wl_display_terminate(struct wl_display * x0)
{
  wl_display_terminate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_display_terminate(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_display_terminate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_display_terminate _cffi_d_wl_display_terminate
#endif

static void _cffi_d_wl_event_loop_add_destroy_listener(struct wl_event_loop * x0, struct wl_listener * x1)
{
  wl_event_loop_add_destroy_listener(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_add_destroy_listener(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  struct wl_listener * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_add_destroy_listener", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_listener *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_event_loop_add_destroy_listener(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_event_loop_add_destroy_listener _cffi_d_wl_event_loop_add_destroy_listener
#endif

static struct wl_event_source * _cffi_d_wl_event_loop_add_fd(struct wl_event_loop * x0, int x1, uint32_t x2, int(* x3)(int, uint32_t, void *), void * x4)
{
  return wl_event_loop_add_fd(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_add_fd(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  int x1;
  uint32_t x2;
  int(* x3)(int, uint32_t, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_source * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_add_fd", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(int, uint32_t, void *))_cffi_to_c_pointer(arg3, _cffi_type(113));
  if (x3 == (int(*)(int, uint32_t, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_add_fd(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(37));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_add_fd _cffi_d_wl_event_loop_add_fd
#endif

static struct wl_event_source * _cffi_d_wl_event_loop_add_idle(struct wl_event_loop * x0, void(* x1)(void *), void * x2)
{
  return wl_event_loop_add_idle(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_add_idle(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  void(* x1)(void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_source * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_add_idle", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(void *))_cffi_to_c_pointer(arg1, _cffi_type(118));
  if (x1 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_add_idle(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(37));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_add_idle _cffi_d_wl_event_loop_add_idle
#endif

static struct wl_event_source * _cffi_d_wl_event_loop_add_signal(struct wl_event_loop * x0, int x1, int(* x2)(int, void *), void * x3)
{
  return wl_event_loop_add_signal(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_add_signal(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  int x1;
  int(* x2)(int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_source * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_add_signal", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(int, void *))_cffi_to_c_pointer(arg2, _cffi_type(106));
  if (x2 == (int(*)(int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_add_signal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(37));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_add_signal _cffi_d_wl_event_loop_add_signal
#endif

static struct wl_event_source * _cffi_d_wl_event_loop_add_timer(struct wl_event_loop * x0, int(* x1)(void *), void * x2)
{
  return wl_event_loop_add_timer(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_add_timer(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  int(* x1)(void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_event_source * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_add_timer", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(void *))_cffi_to_c_pointer(arg1, _cffi_type(100));
  if (x1 == (int(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_add_timer(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(37));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_add_timer _cffi_d_wl_event_loop_add_timer
#endif

static struct wl_event_loop * _cffi_d_wl_event_loop_create(void)
{
  return wl_event_loop_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_create(PyObject *self, PyObject *noarg)
{
  struct wl_event_loop * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(30));
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_create _cffi_d_wl_event_loop_create
#endif

static void _cffi_d_wl_event_loop_destroy(struct wl_event_loop * x0)
{
  wl_event_loop_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_event_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_event_loop_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_event_loop_destroy _cffi_d_wl_event_loop_destroy
#endif

static int _cffi_d_wl_event_loop_dispatch(struct wl_event_loop * x0, int x1)
{
  return wl_event_loop_dispatch(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_dispatch(PyObject *self, PyObject *args)
{
  struct wl_event_loop * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_event_loop_dispatch", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_dispatch(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_dispatch _cffi_d_wl_event_loop_dispatch
#endif

static void _cffi_d_wl_event_loop_dispatch_idle(struct wl_event_loop * x0)
{
  wl_event_loop_dispatch_idle(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_dispatch_idle(PyObject *self, PyObject *arg0)
{
  struct wl_event_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_event_loop_dispatch_idle(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_event_loop_dispatch_idle _cffi_d_wl_event_loop_dispatch_idle
#endif

static int _cffi_d_wl_event_loop_get_fd(struct wl_event_loop * x0)
{
  return wl_event_loop_get_fd(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_loop_get_fd(PyObject *self, PyObject *arg0)
{
  struct wl_event_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_loop_get_fd(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_loop_get_fd _cffi_d_wl_event_loop_get_fd
#endif

static void _cffi_d_wl_event_queue_destroy(struct wl_event_queue * x0)
{
  wl_event_queue_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_queue_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_event_queue * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_queue *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_event_queue_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_event_queue_destroy _cffi_d_wl_event_queue_destroy
#endif

static void _cffi_d_wl_event_source_check(struct wl_event_source * x0)
{
  wl_event_source_check(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_source_check(PyObject *self, PyObject *arg0)
{
  struct wl_event_source * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_event_source_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_event_source_check _cffi_d_wl_event_source_check
#endif

static int _cffi_d_wl_event_source_fd_update(struct wl_event_source * x0, uint32_t x1)
{
  return wl_event_source_fd_update(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_source_fd_update(PyObject *self, PyObject *args)
{
  struct wl_event_source * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_event_source_fd_update", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_source_fd_update(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_source_fd_update _cffi_d_wl_event_source_fd_update
#endif

static int _cffi_d_wl_event_source_remove(struct wl_event_source * x0)
{
  return wl_event_source_remove(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_source_remove(PyObject *self, PyObject *arg0)
{
  struct wl_event_source * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_source_remove(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_source_remove _cffi_d_wl_event_source_remove
#endif

static int _cffi_d_wl_event_source_timer_update(struct wl_event_source * x0, int x1)
{
  return wl_event_source_timer_update(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_event_source_timer_update(PyObject *self, PyObject *args)
{
  struct wl_event_source * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_event_source_timer_update", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_event_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_event_source_timer_update(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_event_source_timer_update _cffi_d_wl_event_source_timer_update
#endif

static int32_t _cffi_d_wl_fixed_from_double(double x0)
{
  return wl_fixed_from_double(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_fixed_from_double(PyObject *self, PyObject *arg0)
{
  double x0;
  int32_t result;
  PyObject *pyresult;

  x0 = (double)_cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_fixed_from_double(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int32_t);
  return pyresult;
}
#else
#  define _cffi_f_wl_fixed_from_double _cffi_d_wl_fixed_from_double
#endif

static int32_t _cffi_d_wl_fixed_from_int(int x0)
{
  return wl_fixed_from_int(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_fixed_from_int(PyObject *self, PyObject *arg0)
{
  int x0;
  int32_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_fixed_from_int(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int32_t);
  return pyresult;
}
#else
#  define _cffi_f_wl_fixed_from_int _cffi_d_wl_fixed_from_int
#endif

static double _cffi_d_wl_fixed_to_double(int32_t x0)
{
  return wl_fixed_to_double(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_fixed_to_double(PyObject *self, PyObject *arg0)
{
  int32_t x0;
  double result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int32_t);
  if (x0 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_fixed_to_double(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
#  define _cffi_f_wl_fixed_to_double _cffi_d_wl_fixed_to_double
#endif

static struct wl_global * _cffi_d_wl_global_create(struct wl_display * x0, struct wl_interface const * x1, int x2, void * x3, void(* x4)(struct wl_client *, void *, uint32_t, uint32_t))
{
  return wl_global_create(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_global_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wl_interface const * x1;
  int x2;
  void * x3;
  void(* x4)(struct wl_client *, void *, uint32_t, uint32_t);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_global * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wl_global_create", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(123), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_interface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(123), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(struct wl_client *, void *, uint32_t, uint32_t))_cffi_to_c_pointer(arg4, _cffi_type(126));
  if (x4 == (void(*)(struct wl_client *, void *, uint32_t, uint32_t))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_global_create(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(200));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_global_create _cffi_d_wl_global_create
#endif

static void _cffi_d_wl_global_destroy(struct wl_global * x0)
{
  wl_global_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_global_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_global * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(200), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_global *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(200), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_global_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_global_destroy _cffi_d_wl_global_destroy
#endif

static int _cffi_d_wl_list_empty(struct wl_list const * x0)
{
  return wl_list_empty(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_list_empty(PyObject *self, PyObject *arg0)
{
  struct wl_list const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_list const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_list_empty(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_list_empty _cffi_d_wl_list_empty
#endif

static void _cffi_d_wl_list_remove(struct wl_list * x0)
{
  wl_list_remove(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_list_remove(PyObject *self, PyObject *arg0)
{
  struct wl_list * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(203), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_list *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(203), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_list_remove(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_list_remove _cffi_d_wl_list_remove
#endif

static int _cffi_d_wl_proxy_add_dispatcher(struct wl_proxy * x0, int(* x1)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *), void const * x2, void * x3)
{
  return wl_proxy_add_dispatcher(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_add_dispatcher(PyObject *self, PyObject *args)
{
  struct wl_proxy * x0;
  int(* x1)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *);
  void const * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wl_proxy_add_dispatcher", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *))_cffi_to_c_pointer(arg1, _cffi_type(52));
  if (x1 == (int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(53), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_proxy_add_dispatcher(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_proxy_add_dispatcher _cffi_d_wl_proxy_add_dispatcher
#endif

static struct wl_proxy * _cffi_d_wl_proxy_create(struct wl_proxy * x0, struct wl_interface const * x1)
{
  return wl_proxy_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_create(PyObject *self, PyObject *args)
{
  struct wl_proxy * x0;
  struct wl_interface const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_proxy * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_proxy_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(123), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_interface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(123), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_proxy_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_proxy_create _cffi_d_wl_proxy_create
#endif

static void _cffi_d_wl_proxy_destroy(struct wl_proxy * x0)
{
  wl_proxy_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_proxy * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_proxy_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_proxy_destroy _cffi_d_wl_proxy_destroy
#endif

static void * _cffi_d_wl_proxy_get_user_data(struct wl_proxy * x0)
{
  return wl_proxy_get_user_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_get_user_data(PyObject *self, PyObject *arg0)
{
  struct wl_proxy * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_proxy_get_user_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(12));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_proxy_get_user_data _cffi_d_wl_proxy_get_user_data
#endif

static void _cffi_d_wl_proxy_marshal_array(struct wl_proxy * x0, uint32_t x1, union wl_argument * x2)
{
  wl_proxy_marshal_array(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_marshal_array(PyObject *self, PyObject *args)
{
  struct wl_proxy * x0;
  uint32_t x1;
  union wl_argument * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wl_proxy_marshal_array", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (union wl_argument *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_proxy_marshal_array(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_proxy_marshal_array _cffi_d_wl_proxy_marshal_array
#endif

static struct wl_proxy * _cffi_d_wl_proxy_marshal_array_constructor(struct wl_proxy * x0, uint32_t x1, union wl_argument * x2, struct wl_interface const * x3)
{
  return wl_proxy_marshal_array_constructor(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_marshal_array_constructor(PyObject *self, PyObject *args)
{
  struct wl_proxy * x0;
  uint32_t x1;
  union wl_argument * x2;
  struct wl_interface const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_proxy * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wl_proxy_marshal_array_constructor", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (union wl_argument *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(123), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct wl_interface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(123), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_proxy_marshal_array_constructor(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_proxy_marshal_array_constructor _cffi_d_wl_proxy_marshal_array_constructor
#endif

static void _cffi_d_wl_proxy_set_user_data(struct wl_proxy * x0, void * x1)
{
  wl_proxy_set_user_data(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_proxy_set_user_data(PyObject *self, PyObject *args)
{
  struct wl_proxy * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_proxy_set_user_data", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_proxy *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_proxy_set_user_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_proxy_set_user_data _cffi_d_wl_proxy_set_user_data
#endif

static void _cffi_d_wl_resource_add_destroy_listener(struct wl_resource * x0, struct wl_listener * x1)
{
  wl_resource_add_destroy_listener(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_add_destroy_listener(PyObject *self, PyObject *args)
{
  struct wl_resource * x0;
  struct wl_listener * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_resource_add_destroy_listener", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_listener *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_resource_add_destroy_listener(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_resource_add_destroy_listener _cffi_d_wl_resource_add_destroy_listener
#endif

static struct wl_resource * _cffi_d_wl_resource_create(struct wl_client * x0, struct wl_interface const * x1, int x2, uint32_t x3)
{
  return wl_resource_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_create(PyObject *self, PyObject *args)
{
  struct wl_client * x0;
  struct wl_interface const * x1;
  int x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_resource * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wl_resource_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(139), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_client *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(139), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(123), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_interface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(123), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_resource_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(57));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_resource_create _cffi_d_wl_resource_create
#endif

static void _cffi_d_wl_resource_destroy(struct wl_resource * x0)
{
  wl_resource_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_destroy(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_resource_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_resource_destroy _cffi_d_wl_resource_destroy
#endif

static struct wl_client * _cffi_d_wl_resource_get_client(struct wl_resource * x0)
{
  return wl_resource_get_client(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_get_client(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wl_client * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_resource_get_client(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(139));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_resource_get_client _cffi_d_wl_resource_get_client
#endif

static uint32_t _cffi_d_wl_resource_get_id(struct wl_resource * x0)
{
  return wl_resource_get_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_get_id(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_resource_get_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_resource_get_id _cffi_d_wl_resource_get_id
#endif

static void * _cffi_d_wl_resource_get_user_data(struct wl_resource * x0)
{
  return wl_resource_get_user_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_get_user_data(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_resource_get_user_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(12));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_resource_get_user_data _cffi_d_wl_resource_get_user_data
#endif

static int _cffi_d_wl_resource_get_version(struct wl_resource * x0)
{
  return wl_resource_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_get_version(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wl_resource_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wl_resource_get_version _cffi_d_wl_resource_get_version
#endif

static void _cffi_const_wl_resource_post_error(char *o)
{
  *(void(* *)(struct wl_resource *, uint32_t, char const *, ...))o = wl_resource_post_error;
}

static void _cffi_d_wl_resource_post_event_array(struct wl_resource * x0, uint32_t x1, union wl_argument * x2)
{
  wl_resource_post_event_array(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_post_event_array(PyObject *self, PyObject *args)
{
  struct wl_resource * x0;
  uint32_t x1;
  union wl_argument * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wl_resource_post_event_array", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (union wl_argument *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_resource_post_event_array(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_resource_post_event_array _cffi_d_wl_resource_post_event_array
#endif

static void _cffi_d_wl_resource_set_dispatcher(struct wl_resource * x0, int(* x1)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *), void const * x2, void * x3, void(* x4)(struct wl_resource *))
{
  wl_resource_set_dispatcher(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_resource_set_dispatcher(PyObject *self, PyObject *args)
{
  struct wl_resource * x0;
  int(* x1)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *);
  void const * x2;
  void * x3;
  void(* x4)(struct wl_resource *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wl_resource_set_dispatcher", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(57), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(57), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *))_cffi_to_c_pointer(arg1, _cffi_type(52));
  if (x1 == (int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(53), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(struct wl_resource *))_cffi_to_c_pointer(arg4, _cffi_type(229));
  if (x4 == (void(*)(struct wl_resource *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_resource_set_dispatcher(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_resource_set_dispatcher _cffi_d_wl_resource_set_dispatcher
#endif

static void _cffi_d_wl_signal_add(struct wl_signal * x0, struct wl_listener * x1)
{
  wl_signal_add(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_signal_add(PyObject *self, PyObject *args)
{
  struct wl_signal * x0;
  struct wl_listener * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_signal_add", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_signal *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(175), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_listener *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(175), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_signal_add(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_signal_add _cffi_d_wl_signal_add
#endif

static void _cffi_d_wl_signal_emit(struct wl_signal * x0, void * x1)
{
  wl_signal_emit(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wl_signal_emit(PyObject *self, PyObject *args)
{
  struct wl_signal * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wl_signal_emit", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_signal *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wl_signal_emit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wl_signal_emit _cffi_d_wl_signal_emit
#endif

static int _cffi_const_WAYLAND_VERSION_MAJOR(unsigned long long *o)
{
  int n = (WAYLAND_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((WAYLAND_VERSION_MAJOR) | 0);  /* check that WAYLAND_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_WAYLAND_VERSION_MICRO(unsigned long long *o)
{
  int n = (WAYLAND_VERSION_MICRO) <= 0;
  *o = (unsigned long long)((WAYLAND_VERSION_MICRO) | 0);  /* check that WAYLAND_VERSION_MICRO is an integer */
  return n;
}

static int _cffi_const_WAYLAND_VERSION_MINOR(unsigned long long *o)
{
  int n = (WAYLAND_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((WAYLAND_VERSION_MINOR) | 0);  /* check that WAYLAND_VERSION_MINOR is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_array(struct wl_array *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->size) | 0);  /* check that 'struct wl_array.size' is an integer */
  (void)((p->alloc) | 0);  /* check that 'struct wl_array.alloc' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wl_array { char x; struct wl_array y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_interface(struct wl_interface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->version) | 0);  /* check that 'struct wl_interface.version' is an integer */
  (void)((p->method_count) | 0);  /* check that 'struct wl_interface.method_count' is an integer */
  { struct wl_message const * *tmp = &p->methods; (void)tmp; }
  (void)((p->event_count) | 0);  /* check that 'struct wl_interface.event_count' is an integer */
  { struct wl_message const * *tmp = &p->events; (void)tmp; }
}
struct _cffi_align_struct_wl_interface { char x; struct wl_interface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_list(struct wl_list *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list * *tmp = &p->prev; (void)tmp; }
  { struct wl_list * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_wl_list { char x; struct wl_list y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener(struct wl_listener *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { void(* *tmp)(struct wl_listener *, void *) = &p->notify; (void)tmp; }
}
struct _cffi_align_struct_wl_listener { char x; struct wl_listener y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener_container(struct wl_listener_container *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->handle; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy_listener; (void)tmp; }
}
struct _cffi_align_struct_wl_listener_container { char x; struct wl_listener_container y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_message(struct wl_message *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->signature; (void)tmp; }
  { struct wl_interface const * * *tmp = &p->types; (void)tmp; }
}
struct _cffi_align_struct_wl_message { char x; struct wl_message y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_signal(struct wl_signal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->listener_list; (void)tmp; }
}
struct _cffi_align_struct_wl_signal { char x; struct wl_signal y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_union_wl_argument(union wl_argument *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->i) | 0);  /* check that 'union wl_argument.i' is an integer */
  (void)((p->u) | 0);  /* check that 'union wl_argument.u' is an integer */
  (void)((p->f) | 0);  /* check that 'union wl_argument.f' is an integer */
  { char const * *tmp = &p->s; (void)tmp; }
  { struct wl_object * *tmp = &p->o; (void)tmp; }
  (void)((p->n) | 0);  /* check that 'union wl_argument.n' is an integer */
  { struct wl_array * *tmp = &p->a; (void)tmp; }
  (void)((p->h) | 0);  /* check that 'union wl_argument.h' is an integer */
}
struct _cffi_align_union_wl_argument { char x; union wl_argument y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "WAYLAND_VERSION_MAJOR", (void *)_cffi_const_WAYLAND_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WAYLAND_VERSION_MICRO", (void *)_cffi_const_WAYLAND_VERSION_MICRO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WAYLAND_VERSION_MINOR", (void *)_cffi_const_WAYLAND_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WL_EVENT_ERROR", (void *)_cffi_const_WL_EVENT_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WL_EVENT_HANGUP", (void *)_cffi_const_WL_EVENT_HANGUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WL_EVENT_READABLE", (void *)_cffi_const_WL_EVENT_READABLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WL_EVENT_WRITABLE", (void *)_cffi_const_WL_EVENT_WRITABLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "dispatcher_func", (void *)&_cffi_externpy__dispatcher_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 52), (void *)dispatcher_func },
  { "event_loop_fd_func", (void *)&_cffi_externpy__event_loop_fd_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 113), (void *)event_loop_fd_func },
  { "event_loop_idle_func", (void *)&_cffi_externpy__event_loop_idle_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 118), (void *)event_loop_idle_func },
  { "event_loop_signal_func", (void *)&_cffi_externpy__event_loop_signal_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 106), (void *)event_loop_signal_func },
  { "event_loop_timer_func", (void *)&_cffi_externpy__event_loop_timer_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 100), (void *)event_loop_timer_func },
  { "global_bind_func", (void *)&_cffi_externpy__global_bind_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 126), (void *)global_bind_func },
  { "notify_func", (void *)&_cffi_externpy__notify_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 281), (void *)notify_func },
  { "os_create_anonymous_file", (void *)_cffi_f_os_create_anonymous_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_os_create_anonymous_file },
  { "resource_destroy_func", (void *)&_cffi_externpy__resource_destroy_func, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 229), (void *)resource_destroy_func },
  { "wl_client_add_destroy_listener", (void *)_cffi_f_wl_client_add_destroy_listener, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_wl_client_add_destroy_listener },
  { "wl_client_create", (void *)_cffi_f_wl_client_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_wl_client_create },
  { "wl_client_destroy", (void *)_cffi_f_wl_client_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 164), (void *)_cffi_d_wl_client_destroy },
  { "wl_client_flush", (void *)_cffi_f_wl_client_flush, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 164), (void *)_cffi_d_wl_client_flush },
  { "wl_client_get_credentials", (void *)_cffi_f_wl_client_get_credentials, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_wl_client_get_credentials },
  { "wl_client_get_object", (void *)_cffi_f_wl_client_get_object, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_wl_client_get_object },
  { "wl_display_add_shm_format", (void *)_cffi_f_wl_display_add_shm_format, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_wl_display_add_shm_format },
  { "wl_display_add_socket", (void *)_cffi_f_wl_display_add_socket, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 21), (void *)_cffi_d_wl_display_add_socket },
  { "wl_display_add_socket_auto", (void *)_cffi_f_wl_display_add_socket_auto, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_wl_display_add_socket_auto },
  { "wl_display_connect", (void *)_cffi_f_wl_display_connect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 82), (void *)_cffi_d_wl_display_connect },
  { "wl_display_connect_to_fd", (void *)_cffi_f_wl_display_connect_to_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_wl_display_connect_to_fd },
  { "wl_display_create", (void *)_cffi_f_wl_display_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 88), (void *)_cffi_d_wl_display_create },
  { "wl_display_create_queue", (void *)_cffi_f_wl_display_create_queue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 95), (void *)_cffi_d_wl_display_create_queue },
  { "wl_display_destroy", (void *)_cffi_f_wl_display_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_destroy },
  { "wl_display_destroy_clients", (void *)_cffi_f_wl_display_destroy_clients, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_destroy_clients },
  { "wl_display_disconnect", (void *)_cffi_f_wl_display_disconnect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_disconnect },
  { "wl_display_dispatch", (void *)_cffi_f_wl_display_dispatch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_dispatch },
  { "wl_display_dispatch_pending", (void *)_cffi_f_wl_display_dispatch_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_dispatch_pending },
  { "wl_display_dispatch_queue", (void *)_cffi_f_wl_display_dispatch_queue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_wl_display_dispatch_queue },
  { "wl_display_dispatch_queue_pending", (void *)_cffi_f_wl_display_dispatch_queue_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_wl_display_dispatch_queue_pending },
  { "wl_display_flush", (void *)_cffi_f_wl_display_flush, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_flush },
  { "wl_display_flush_clients", (void *)_cffi_f_wl_display_flush_clients, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_flush_clients },
  { "wl_display_get_error", (void *)_cffi_f_wl_display_get_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_get_error },
  { "wl_display_get_event_loop", (void *)_cffi_f_wl_display_get_event_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 90), (void *)_cffi_d_wl_display_get_event_loop },
  { "wl_display_get_fd", (void *)_cffi_f_wl_display_get_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_get_fd },
  { "wl_display_get_serial", (void *)_cffi_f_wl_display_get_serial, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_wl_display_get_serial },
  { "wl_display_init_shm", (void *)_cffi_f_wl_display_init_shm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_init_shm },
  { "wl_display_next_serial", (void *)_cffi_f_wl_display_next_serial, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_wl_display_next_serial },
  { "wl_display_prepare_read", (void *)_cffi_f_wl_display_prepare_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_prepare_read },
  { "wl_display_prepare_read_queue", (void *)_cffi_f_wl_display_prepare_read_queue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_wl_display_prepare_read_queue },
  { "wl_display_read_events", (void *)_cffi_f_wl_display_read_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_read_events },
  { "wl_display_roundtrip", (void *)_cffi_f_wl_display_roundtrip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_wl_display_roundtrip },
  { "wl_display_roundtrip_queue", (void *)_cffi_f_wl_display_roundtrip_queue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_wl_display_roundtrip_queue },
  { "wl_display_run", (void *)_cffi_f_wl_display_run, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_run },
  { "wl_display_terminate", (void *)_cffi_f_wl_display_terminate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 183), (void *)_cffi_d_wl_display_terminate },
  { "wl_event_loop_add_destroy_listener", (void *)_cffi_f_wl_event_loop_add_destroy_listener, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_wl_event_loop_add_destroy_listener },
  { "wl_event_loop_add_fd", (void *)_cffi_f_wl_event_loop_add_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_wl_event_loop_add_fd },
  { "wl_event_loop_add_idle", (void *)_cffi_f_wl_event_loop_add_idle, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 116), (void *)_cffi_d_wl_event_loop_add_idle },
  { "wl_event_loop_add_signal", (void *)_cffi_f_wl_event_loop_add_signal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_wl_event_loop_add_signal },
  { "wl_event_loop_add_timer", (void *)_cffi_f_wl_event_loop_add_timer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_wl_event_loop_add_timer },
  { "wl_event_loop_create", (void *)_cffi_f_wl_event_loop_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 93), (void *)_cffi_d_wl_event_loop_create },
  { "wl_event_loop_destroy", (void *)_cffi_f_wl_event_loop_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 186), (void *)_cffi_d_wl_event_loop_destroy },
  { "wl_event_loop_dispatch", (void *)_cffi_f_wl_event_loop_dispatch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_wl_event_loop_dispatch },
  { "wl_event_loop_dispatch_idle", (void *)_cffi_f_wl_event_loop_dispatch_idle, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 186), (void *)_cffi_d_wl_event_loop_dispatch_idle },
  { "wl_event_loop_get_fd", (void *)_cffi_f_wl_event_loop_get_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d_wl_event_loop_get_fd },
  { "wl_event_queue_destroy", (void *)_cffi_f_wl_event_queue_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 193), (void *)_cffi_d_wl_event_queue_destroy },
  { "wl_event_source_check", (void *)_cffi_f_wl_event_source_check, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 196), (void *)_cffi_d_wl_event_source_check },
  { "wl_event_source_fd_update", (void *)_cffi_f_wl_event_source_fd_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 43), (void *)_cffi_d_wl_event_source_fd_update },
  { "wl_event_source_remove", (void *)_cffi_f_wl_event_source_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 36), (void *)_cffi_d_wl_event_source_remove },
  { "wl_event_source_timer_update", (void *)_cffi_f_wl_event_source_timer_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 39), (void *)_cffi_d_wl_event_source_timer_update },
  { "wl_fixed_from_double", (void *)_cffi_f_wl_fixed_from_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_wl_fixed_from_double },
  { "wl_fixed_from_int", (void *)_cffi_f_wl_fixed_from_int, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_wl_fixed_from_int },
  { "wl_fixed_to_double", (void *)_cffi_f_wl_fixed_to_double, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wl_fixed_to_double },
  { "wl_global_create", (void *)_cffi_f_wl_global_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_wl_global_create },
  { "wl_global_destroy", (void *)_cffi_f_wl_global_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 199), (void *)_cffi_d_wl_global_destroy },
  { "wl_list_empty", (void *)_cffi_f_wl_list_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 47), (void *)_cffi_d_wl_list_empty },
  { "wl_list_remove", (void *)_cffi_f_wl_list_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 202), (void *)_cffi_d_wl_list_remove },
  { "wl_proxy_add_dispatcher", (void *)_cffi_f_wl_proxy_add_dispatcher, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_wl_proxy_add_dispatcher },
  { "wl_proxy_create", (void *)_cffi_f_wl_proxy_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_wl_proxy_create },
  { "wl_proxy_destroy", (void *)_cffi_f_wl_proxy_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_wl_proxy_destroy },
  { "wl_proxy_get_user_data", (void *)_cffi_f_wl_proxy_get_user_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 158), (void *)_cffi_d_wl_proxy_get_user_data },
  { "wl_proxy_marshal_array", (void *)_cffi_f_wl_proxy_marshal_array, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 212), (void *)_cffi_d_wl_proxy_marshal_array },
  { "wl_proxy_marshal_array_constructor", (void *)_cffi_f_wl_proxy_marshal_array_constructor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 132), (void *)_cffi_d_wl_proxy_marshal_array_constructor },
  { "wl_proxy_set_user_data", (void *)_cffi_f_wl_proxy_set_user_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 217), (void *)_cffi_d_wl_proxy_set_user_data },
  { "wl_resource_add_destroy_listener", (void *)_cffi_f_wl_resource_add_destroy_listener, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 231), (void *)_cffi_d_wl_resource_add_destroy_listener },
  { "wl_resource_create", (void *)_cffi_f_wl_resource_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 138), (void *)_cffi_d_wl_resource_create },
  { "wl_resource_destroy", (void *)_cffi_f_wl_resource_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 221), (void *)_cffi_d_wl_resource_destroy },
  { "wl_resource_get_client", (void *)_cffi_f_wl_resource_get_client, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 79), (void *)_cffi_d_wl_resource_get_client },
  { "wl_resource_get_id", (void *)_cffi_f_wl_resource_get_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 155), (void *)_cffi_d_wl_resource_get_id },
  { "wl_resource_get_user_data", (void *)_cffi_f_wl_resource_get_user_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 161), (void *)_cffi_d_wl_resource_get_user_data },
  { "wl_resource_get_version", (void *)_cffi_f_wl_resource_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 56), (void *)_cffi_d_wl_resource_get_version },
  { "wl_resource_post_error", (void *)_cffi_const_wl_resource_post_error, _CFFI_OP(_CFFI_OP_CONSTANT, 282), (void *)0 },
  { "wl_resource_post_event_array", (void *)_cffi_f_wl_resource_post_event_array, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 240), (void *)_cffi_d_wl_resource_post_event_array },
  { "wl_resource_set_dispatcher", (void *)_cffi_f_wl_resource_set_dispatcher, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 224), (void *)_cffi_d_wl_resource_set_dispatcher },
  { "wl_signal_add", (void *)_cffi_f_wl_signal_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 245), (void *)_cffi_d_wl_signal_add },
  { "wl_signal_emit", (void *)_cffi_f_wl_signal_emit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 249), (void *)_cffi_d_wl_signal_emit },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "size", offsetof(struct wl_array, size),
            sizeof(((struct wl_array *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 258) },
  { "alloc", offsetof(struct wl_array, alloc),
             sizeof(((struct wl_array *)0)->alloc),
             _CFFI_OP(_CFFI_OP_NOOP, 258) },
  { "data", offsetof(struct wl_array, data),
            sizeof(((struct wl_array *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "name", offsetof(struct wl_interface, name),
            sizeof(((struct wl_interface *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "version", offsetof(struct wl_interface, version),
               sizeof(((struct wl_interface *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "method_count", offsetof(struct wl_interface, method_count),
                    sizeof(((struct wl_interface *)0)->method_count),
                    _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "methods", offsetof(struct wl_interface, methods),
               sizeof(((struct wl_interface *)0)->methods),
               _CFFI_OP(_CFFI_OP_NOOP, 66) },
  { "event_count", offsetof(struct wl_interface, event_count),
                   sizeof(((struct wl_interface *)0)->event_count),
                   _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "events", offsetof(struct wl_interface, events),
              sizeof(((struct wl_interface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 66) },
  { "prev", offsetof(struct wl_list, prev),
            sizeof(((struct wl_list *)0)->prev),
            _CFFI_OP(_CFFI_OP_NOOP, 203) },
  { "next", offsetof(struct wl_list, next),
            sizeof(((struct wl_list *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 203) },
  { "link", offsetof(struct wl_listener, link),
            sizeof(((struct wl_listener *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 269) },
  { "notify", offsetof(struct wl_listener, notify),
              sizeof(((struct wl_listener *)0)->notify),
              _CFFI_OP(_CFFI_OP_NOOP, 281) },
  { "handle", offsetof(struct wl_listener_container, handle),
              sizeof(((struct wl_listener_container *)0)->handle),
              _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "destroy_listener", offsetof(struct wl_listener_container, destroy_listener),
                        sizeof(((struct wl_listener_container *)0)->destroy_listener),
                        _CFFI_OP(_CFFI_OP_NOOP, 270) },
  { "name", offsetof(struct wl_message, name),
            sizeof(((struct wl_message *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "signature", offsetof(struct wl_message, signature),
                 sizeof(((struct wl_message *)0)->signature),
                 _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "types", offsetof(struct wl_message, types),
             sizeof(((struct wl_message *)0)->types),
             _CFFI_OP(_CFFI_OP_NOOP, 267) },
  { "listener_list", offsetof(struct wl_signal, listener_list),
                     sizeof(((struct wl_signal *)0)->listener_list),
                     _CFFI_OP(_CFFI_OP_NOOP, 269) },
  { "i", offsetof(union wl_argument, i),
         sizeof(((union wl_argument *)0)->i),
         _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "u", offsetof(union wl_argument, u),
         sizeof(((union wl_argument *)0)->u),
         _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "f", offsetof(union wl_argument, f),
         sizeof(((union wl_argument *)0)->f),
         _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "s", offsetof(union wl_argument, s),
         sizeof(((union wl_argument *)0)->s),
         _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "o", offsetof(union wl_argument, o),
         sizeof(((union wl_argument *)0)->o),
         _CFFI_OP(_CFFI_OP_NOOP, 273) },
  { "n", offsetof(union wl_argument, n),
         sizeof(((union wl_argument *)0)->n),
         _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "a", offsetof(union wl_argument, a),
         sizeof(((union wl_argument *)0)->a),
         _CFFI_OP(_CFFI_OP_NOOP, 259) },
  { "h", offsetof(union wl_argument, h),
         sizeof(((union wl_argument *)0)->h),
         _CFFI_OP(_CFFI_OP_NOOP, 4) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "wl_argument", 279, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    sizeof(union wl_argument), offsetof(struct _cffi_align_union_wl_argument, y), 19, 8 },
  { "wl_array", 260, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_array), offsetof(struct _cffi_align_struct_wl_array, y), 0, 3 },
  { "wl_client", 261, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_display", 262, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_event_loop", 263, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_event_queue", 264, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_event_source", 265, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_global", 266, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_interface", 268, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_interface), offsetof(struct _cffi_align_struct_wl_interface, y), 3, 6 },
  { "wl_list", 269, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_list), offsetof(struct _cffi_align_struct_wl_list, y), 9, 2 },
  { "wl_listener", 270, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_listener), offsetof(struct _cffi_align_struct_wl_listener, y), 11, 2 },
  { "wl_listener_container", 271, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_listener_container), offsetof(struct _cffi_align_struct_wl_listener_container, y), 13, 2 },
  { "wl_message", 272, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_message), offsetof(struct _cffi_align_struct_wl_message, y), 15, 3 },
  { "wl_object", 274, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_proxy", 275, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_resource", 276, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wl_signal", 277, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wl_signal), offsetof(struct _cffi_align_struct_wl_signal, y), 18, 1 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$1", 257, _cffi_prim_int(4, 0),
    "WL_EVENT_READABLE,WL_EVENT_WRITABLE,WL_EVENT_HANGUP,WL_EVENT_ERROR" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "gid_t", 280 },
  { "pid_t", 7 },
  { "uid_t", 280 },
  { "wl_dispatcher_func_t", 52 },
  { "wl_event_loop_fd_func_t", 113 },
  { "wl_event_loop_idle_func_t", 118 },
  { "wl_event_loop_signal_func_t", 106 },
  { "wl_event_loop_timer_func_t", 100 },
  { "wl_fixed_t", 4 },
  { "wl_global_bind_func_t", 126 },
  { "wl_notify_func_t", 281 },
  { "wl_resource_destroy_func_t", 229 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  92,  /* num_globals */
  17,  /* num_struct_unions */
  1,  /* num_enums */
  12,  /* num_typenames */
  NULL,  /* no includes */
  284,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__ffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__ffi(void) { return NULL; }
#  else
     init_ffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__ffi(void)
{
  return _cffi_init("pywayland._ffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_ffi(void)
{
  _cffi_init("pywayland._ffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
