/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptEditorBase;
import com.sun.star.script.framework.provider.SwingInvocation;
import com.sun.star.script.framework.provider.beanshell.PlainSourceView;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import com.sun.star.script.framework.provider.beanshell.UnsavedChangesListener;
import com.sun.star.script.provider.XScriptContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class ScriptEditorForBeanShell
extends ScriptEditorBase
implements ActionListener {
    private JFrame frame;
    private String filename;
    private ScriptSourceModel model;
    private ScriptSourceView view;
    private URL scriptURL = null;
    private ClassLoader cl = null;
    private JButton saveBtn;
    private static ScriptEditorForBeanShell theScriptEditorForBeanShell;
    private static Map<String, ScriptEditorForBeanShell> BEING_EDITED;
    private static String BSHTEMPLATE;

    public static synchronized ScriptEditorForBeanShell getEditor() {
        if (theScriptEditorForBeanShell == null) {
            theScriptEditorForBeanShell = new ScriptEditorForBeanShell();
        }
        return theScriptEditorForBeanShell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEditorForBeanShell getEditor(URL url) {
        Map<String, ScriptEditorForBeanShell> map = BEING_EDITED;
        synchronized (map) {
            return BEING_EDITED.get(url.toExternalForm());
        }
    }

    public boolean isModified() {
        return this.view.isModified();
    }

    public String getText() {
        return this.view.getText();
    }

    @Override
    public String getTemplate() {
        return BSHTEMPLATE;
    }

    @Override
    public String getExtension() {
        return "bsh";
    }

    @Override
    public void indicateErrorLine(int lineNum) {
        this.model.indicateErrorLine(lineNum);
    }

    @Override
    public Object execute() throws Exception {
        if (!this.isMacroExecutionEnabled()) {
            this.showErrorMessage("Macro Execution has been disabled.");
            return null;
        }
        this.frame.toFront();
        return this.model.execute(this.context, this.cl);
    }

    @Override
    public void edit(final XScriptContext context, ScriptMetaData entry) {
        if (entry != null) {
            try {
                URLClassLoader cl = null;
                try {
                    cl = ClassLoaderFactory.getURLClassLoader(entry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final URLClassLoader theCl = cl;
                final URL url = entry.getSourceURL();
                SwingInvocation.invoke(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ScriptEditorForBeanShell editor;
                        Map map = BEING_EDITED;
                        synchronized (map) {
                            editor = (ScriptEditorForBeanShell)BEING_EDITED.get(url.toExternalForm());
                            if (editor == null) {
                                editor = new ScriptEditorForBeanShell(context, theCl, url);
                                BEING_EDITED.put(url.toExternalForm(), editor);
                            }
                        }
                        editor.frame.toFront();
                    }
                });
            }
            catch (IOException ioe) {
                this.showErrorMessage("Error loading file: " + ioe.getMessage());
            }
        }
    }

    private ScriptEditorForBeanShell() {
    }

    private ScriptEditorForBeanShell(XScriptContext context, ClassLoader cl, URL url) {
        this.setContext(context);
        this.scriptURL = url;
        this.model = new ScriptSourceModel(url);
        this.filename = ScriptMetaData.getFileName(url);
        this.cl = cl;
        try {
            Class<?> c = Class.forName("org.openoffice.netbeans.editor.NetBeansSourceView");
            Class[] types = new Class[]{ScriptSourceModel.class};
            Constructor<?> ctor = c.getConstructor(types);
            if (ctor != null) {
                Object[] args = new Object[]{this.model};
                this.view = (ScriptSourceView)ctor.newInstance(args);
            } else {
                this.view = new PlainSourceView(this.model);
            }
        }
        catch (Error err) {
            this.view = new PlainSourceView(this.model);
        }
        catch (Exception e) {
            this.view = new PlainSourceView(this.model);
        }
        this.model.setView(this.view);
        this.initUI();
        this.view.addListener(new UnsavedChangesListener(){

            @Override
            public void onUnsavedChanges(boolean isUnsaved) {
                if (ScriptEditorForBeanShell.this.filename != null) {
                    ScriptEditorForBeanShell.this.saveBtn.setEnabled(isUnsaved);
                }
            }
        });
        this.frame.setVisible(true);
    }

    private void initUI() {
        this.frame = new JFrame("BeanShell Debug Window: " + this.filename);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScriptEditorForBeanShell.this.doClose();
            }
        });
        String[] labels = new String[]{"Run", "Clear", "Save", "Undo", "Redo"};
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        for (String label : labels) {
            JButton b = new JButton(label);
            b.setToolTipText(label);
            b.addActionListener(this);
            toolbar.add(b);
            toolbar.addSeparator();
            if (!label.equals("Save")) continue;
            b.setEnabled(false);
            this.saveBtn = b;
        }
        this.frame.getContentPane().add((Component)((JComponent)((Object)this.view)), "Center");
        this.frame.add((Component)toolbar, "North");
        this.frame.pack();
        this.frame.setSize(590, 480);
        this.frame.setLocation(300, 200);
        this.frame.setMinimumSize(new Dimension(500, 300));
    }

    private void doClose() {
        if (this.view.isModified()) {
            boolean saveSuccess;
            int result = JOptionPane.showConfirmDialog(this.frame, "The script has been modified. Do you want to save the changes?");
            if (result == 2) {
                return;
            }
            if (result == 0 && !(saveSuccess = this.saveTextArea())) {
                return;
            }
        }
        this.frame.dispose();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveTextArea() {
        boolean result = true;
        if (!this.view.isModified()) {
            return true;
        }
        OutputStream fos = null;
        try {
            String s = this.view.getText();
            fos = this.scriptURL.openConnection().getOutputStream();
            if (fos != null) {
                fos.write(s.getBytes());
            } else {
                this.showErrorMessage("Error saving script: Could not open stream for file");
                result = false;
            }
            this.view.setModified(false);
        }
        catch (IOException ioe) {
            this.showErrorMessage("Error saving script: " + ioe.getMessage());
            result = false;
        }
        catch (Exception e) {
            this.showErrorMessage("Error saving script: " + e.getMessage());
            result = false;
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                }
                catch (IOException ioe) {}
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Map<String, ScriptEditorForBeanShell> map = BEING_EDITED;
        synchronized (map) {
            BEING_EDITED.remove(this.scriptURL.toExternalForm());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Run")) {
            try {
                this.execute();
            }
            catch (Exception invokeException) {
                this.showErrorMessage(invokeException.toString());
            }
        } else if (actionCommand.equals("Save")) {
            this.saveTextArea();
        } else if (actionCommand.equals("Clear")) {
            this.view.clear();
        } else if (actionCommand.equals("Undo")) {
            this.view.undo();
        } else if (actionCommand.equals("Redo")) {
            this.view.redo();
        }
    }

    static {
        BEING_EDITED = new HashMap<String, ScriptEditorForBeanShell>();
        BSHTEMPLATE = "// BeanShell script";
        try {
            URL url = ScriptEditorForBeanShell.class.getResource("template.bsh");
            if (url != null) {
                int len;
                InputStream in = url.openStream();
                StringBuilder buf = new StringBuilder();
                byte[] b = new byte[1024];
                while ((len = in.read(b)) != -1) {
                    buf.append(new String(b, 0, len));
                }
                in.close();
                BSHTEMPLATE = buf.toString();
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

