/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;

public class ModuleReference
extends ASTNode {
    public char[][] tokens;
    public long[] sourcePositions;
    public char[] moduleName;
    public ModuleBinding binding = null;

    public ModuleReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceEnd = (int)(lArray[lArray.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(lArray[0] >>> 32);
        this.moduleName = CharOperation.concatWith(cArray, '.');
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < this.tokens.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[i]);
        }
        return stringBuffer;
    }

    public ModuleBinding resolve(Scope scope) {
        if (scope == null || this.binding != null) {
            return this.binding;
        }
        this.binding = scope.environment().getModule(this.moduleName);
        return this.binding;
    }
}

