/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_PW = "Palau";
        final String metaValue_ae = "Avestesch";
        final String metaValue_ar = "Arabesch";
        final String metaValue_bn = "Bengalesch";
        final String metaValue_bo = "Tibetesch";
        final String metaValue_el = "Griichesch";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebr\u00e4esch";
        final String metaValue_hy = "Armenesch";
        final String metaValue_ja = "Japanesch";
        final String metaValue_ka = "Georgesch";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreanesch";
        final String metaValue_lo = "Laotesch";
        final String metaValue_mn = "Mongolesch";
        final String metaValue_my = "Birmanesch";
        final String metaValue_si = "Singhalesesch";
        final String metaValue_su = "Sundanesesch";
        final String metaValue_ta = "Tamilesch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Dagalog";
        final String metaValue_zh = "Chinesesch";
        final String metaValue_ban = "Balinesesch";
        final String metaValue_bug = "Buginesesch";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptesch";
        final String metaValue_got = "Gotesch";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_ota = "Osmanesch";
        final String metaValue_peo = "Alpersesch";
        final String metaValue_sam = "Samaritanesch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_syr = "Syresch";
        final String metaValue_uga = "Ugaritesch";
        final String metaValue_zbl = "Bliss-Symboler";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6lsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandesesch" },
            { "Zsym", "Symboler" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "egl", "Emilianesch" },
            { "mwv", "Mentawai" },
            { "%%NJIVA", "Njiva-Dialekt" },
            { "xmf", "Mingrelesch Sprooch" },
            { "egy", "Egyptesch" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Temne" },
            { "teo", "Teso" },
            { "rap", "Ouschterinsel-Sprooch" },
            { "ter", "Tereno-Sprooch" },
            { "AC", "Ascension" },
            { "rar", "Rarotonganesch" },
            { "tet", "Tetum-Sprooch" },
            { "%%BARLA", "Barlavento-Dialektgrupp vu Kabuverdianu" },
            { "AD", "Andorra" },
            { "AE", "Vereenegt Arabesch Emirater" },
            { "nl_BE", "Fl\u00e4mesch" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "type.ca.ethiopic", "Ethiopesche Kalenner" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "Teng", "Tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinien" },
            { "AS", "Amerikanesch-Samoa" },
            { "AT", "\u00c9istr\u00e4ich" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "en_US", "Amerikanescht Englesch" },
            { "AX", "\u00c5landinselen" },
            { "mye", "Myene" },
            { "AZ", "Aserbaidschan" },
            { "%%AREVELA", "Ostarmenesch" },
            { "BA", "Bosnien an Herzegowina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesch" },
            { "kum", "Kum\u00fckesch" },
            { "BE", "Belsch" },
            { "gmh", "M\u00ebttelh\u00e9ichd\u00e4itsch" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai-Sprooch" },
            { "myv", "Ersja-Mordwinesch" },
            { "BN", "Brunei" },
            { "BO", "Bolivien" },
            { "BQ", "Karibescht Holland" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsel" },
            { "BW", "Botsuana" },
            { "BY", "W\u00e4issrussland" },
            { "BZ", "Belize" },
            { "Visp", "Siichtbar Sprooch" },
            { "type.ca.persian", "Persesche Kalenner" },
            { "type.nu.hebr", "Hebr\u00e4esch Zifferen" },
            { "CA", "Kanada" },
            { "CC", "Kokosinselen" },
            { "mzn", "Mazandarani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikanesch Republik" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schw\u00e4iz" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookinselen" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbien" },
            { "CP", "Clipperton-Insel" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Chr\u00ebschtdagsinsel" },
            { "CY", "Zypern" },
            { "CZ", "Tschechien" },
            { "eka", "Ekajuk" },
            { "vls", "Westfl\u00e4mesch" },
            { "DE", "D\u00e4itschland" },
            { "goh", "Alh\u00e9ichd\u00e4itsch" },
            { "ace", "Aceh-Sprooch" },
            { "cgg", "Kiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goan-Konkani" },
            { "type.nu.deva", "Devanagari-Zifferen" },
            { "DJ", "Dschibuti" },
            { "DK", "D\u00e4nemark" },
            { "ach", "Acholi-Sprooch" },
            { "gon", "Gondi-Sprooch" },
            { "Brai", "Blanneschr\u00ebft" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenesch Zifferen a Klengschr\u00ebft" },
            { "DO", "Dominikanesch Republik" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "vmf", "Mainfr\u00e4nkesch" },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zuni-Sprooch" },
            { "tig", "Tigre" },
            { "DZ", "Algerien" },
            { "pag", "Pangasinan-Sprooch" },
            { "pal", "M\u00ebttelpersesch" },
            { "EA", "Ceuta a Melilla" },
            { "chb", "Chibcha-Sprooch" },
            { "pam", "Pampanggan-Sprooch" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estland" },
            { "tiv", "Tiv-Sprooch" },
            { "EG", "Egypten" },
            { "EH", "Westsahara" },
            { "chg", "Tschagataesch" },
            { "pau", metaValue_PW },
            { "chk", "Trukesesch" },
            { "chn", "Chinook" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Ethiopien" },
            { "EU", "Europ\u00e4esch Unioun" },
            { "elx", "Elamesch" },
            { "type.ca.gregorian", "Gregorianesche Kalenner" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Gujarati-Zifferen" },
            { "Inds", "Indus-Schr\u00ebft" },
            { "ady", "Adyg\u00e9iesch" },
            { "aeb", "Tunesescht Arabesch" },
            { "FI", "Finnland" },
            { "FJ", "Fidschi" },
            { "FK", "Falklandinselen" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6er" },
            { "Taml", metaValue_ta },
            { "FR", "Frankr\u00e4ich" },
            { "pcd", "Picardesch" },
            { "tkl", "Tokelauanesch" },
            { "grb", "Grebo-Sprooch" },
            { "root", "Root" },
            { "%%DAJNKO", "Dajnko-Alphabet" },
            { "type.ca.indian", "Indeschen Nationalkalenner" },
            { "rgn", "Romagnol" },
            { "grc", "Algriichesch" },
            { "GA", "Gabun" },
            { "tkr", "Tsachuresch" },
            { "vot", "Wotesch" },
            { "GB", "Groussbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Guayane" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "M\u00ebttelenglesch" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorialguinea" },
            { "GR", "Griicheland" },
            { "GS", "S\u00fcdgeorgien an d\u00e9i S\u00fcdlech Sandwichinselen" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvaniad\u00e4itsch" },
            { "GW", "Guinea-Bissau" },
            { "tli", "Tlingit-Sprooch" },
            { "tlh", "Klingonesch" },
            { "Talu", "Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Sorani" },
            { "zxx", "Keng Sproochinhalter" },
            { "tly", "Talesch" },
            { "pdt", "Plattd\u00e4itsch" },
            { "de_AT", "\u00c9istr\u00e4ichescht D\u00e4itsch" },
            { "HK", "Spezialverwaltungszon Hong Kong" },
            { "Vaii", "Vai" },
            { "HM", "Heard- a McDonald-Inselen" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "agq", "Aghem" },
            { "gsw", "Schw\u00e4izerd\u00e4itsch" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "rif", "Tarifit" },
            { "tmh", "Tamaseq" },
            { "IC", "Kanaresch Inselen" },
            { "nan", "Min-Nan-Chinesesch" },
            { "peo", metaValue_peo },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "nap", "Neapolitanesch" },
            { "%%NDYUKA", "Ndyuka-Dialekt" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "type.co.eor", "Europ\u00e4esch Zort\u00e9ierregelen" },
            { "IO", "Britescht Territorium am Indeschen Ozean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "type.nu.thai", "Thai-Zifferen" },
            { "vro", "Voro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Computer" },
            { "type.nu.beng", "Bengalesch Zifferen" },
            { "pfl", "Pf\u00e4lzesch D\u00e4itsch" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Islamesche Kalenner" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "%%EKAVSK", "Serbesch mat Ekavian-Aussprooch" },
            { "JO", "Jordanien" },
            { "gur", "Farefare" },
            { "JP", "Japan" },
            { "%%1606NICT", "Sp\u00e9it M\u00ebttelfrans\u00e9isch" },
            { "ain", "Ainu-Sprooch" },
            { "guz", "Gusii-Sprooch" },
            { "tog", "Tsonga-Sprooch" },
            { "type.nu.knda", "Kannada-Zifferen" },
            { "Kali", "Kayah Li" },
            { "de_CH", "Schw\u00e4izer H\u00e9ichd\u00e4itsch" },
            { "izh", "Ischoresch" },
            { "type.ca.buddhist", "Buddhistesche Kalenner" },
            { "KE", "Kenia" },
            { "419", "Lat\u00e4inamerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Komoren" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts an Nevis" },
            { "Zinh", "Geierfte Schr\u00ebftw\u00e4ert" },
            { "fr_CA", "Kanadescht Frans\u00e9isch" },
            { "KP", "Nordkorea" },
            { "KR", "S\u00fcdkorea" },
            { "Plrd", "Pollard Phonetesch" },
            { "fr_CH", "Schw\u00e4izer Frans\u00e9isch" },
            { "KW", "Kuwait" },
            { "tpi", "Neimelanesesch" },
            { "KY", "Kaimaninselen" },
            { "KZ", "Kasachstan" },
            { "Cyrl", "Kyrillesch" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "phn", "Ph\u00f6nikesch" },
            { "Cyrs", "Alkiercheslawesch" },
            { "gwi", "Kutchin-Sprooch" },
            { "nds", "Nidderd\u00e4itsch" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadesch" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "Yup\u2019ik" },
            { "LS", "Lesotho" },
            { "Phlv", "Pahlavi" },
            { "LT", "Litauen" },
            { "LU", "L\u00ebtzebuerg" },
            { "LV", "Lettland" },
            { "Kana", "Katakana" },
            { "LY", "Libyen" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldawien" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "lam", "Lamba-Sprooch" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinselen" },
            { "ale", "Aleutesch" },
            { "Thai", "Thai" },
            { "type.nu.vaii", "Vai-Zifferen" },
            { "MK", "Mazedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolei" },
            { "new", "Newari" },
            { "MO", "Spezialverwaltungszon Macau" },
            { "aln", "Gegesch" },
            { "MP", "N\u00ebrdlech Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Mauritius" },
            { "alt", "S\u00fcd-Alaesch" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "Japanesche Kalenner" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "Hebr\u00e4esche Kalenner" },
            { "type.co.dictionary", "Lexikographesch Zort\u00e9ierreiefolleg" },
            { "NC", "Neikaledonien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Vereenheetlecht iwwerschafft Rechtschreiwung" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsel" },
            { "NG", "Nigeria" },
            { "trv", "Seediq" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", "Holland" },
            { "NO", "Norwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsakonesch" },
            { "NU", "Niue" },
            { "Phnx", "Ph\u00f6nizesch" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian-Sprooch" },
            { "NZ", "Neis\u00e9iland" },
            { "rom", "Romani" },
            { "Mero", "Meroitesch" },
            { "crh", "Krimtataresch" },
            { "ang", "Alenglesch" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Biergerlechen islamesche Kalenner" },
            { "csb", "Kaschubesch" },
            { "en_GB", "Britescht Englesch" },
            { "PE", "Peru" },
            { "ttt", "Tatesch" },
            { "PF", "Frans\u00e9isch-Polynesien" },
            { "PG", "Papua-Neiguinea" },
            { "PH", "Philippinnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierre a Miquelon" },
            { "PN", "Pitcairninselen" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinensesch Autonomiegebidder" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "nia", "Nias-Sprooch" },
            { "type.nu.greklow", "Griichesch Zifferen a Klengschr\u00ebft" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka-Sprooch" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "%%SCOTLAND", "Schottescht Standardenglesch" },
            { "jam", "Jamaikanesch-Kreolesch" },
            { "pms", "Piemontesesch" },
            { "niu", "Niue-Sprooch" },
            { "QO", "Baussecht Ozeanien" },
            { "ext", "Extremaduresch" },
            { "lez", "Lesgesch" },
            { "%%FONUPA", "Phonetesch (UPA)" },
            { "tvl", "Elliceanesch" },
            { "%%SOTAV", "Sotavento-Dialekt-Grupp vu Kabuverdianu" },
            { "001", "Welt" },
            { "002", "Afrika" },
            { "njo", "Ao Naga" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00fcdamerika" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Pontesch" },
            { "Rjng", "Rejang" },
            { "009", "Ozeanien" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "%%METELKO", "Metelko-Alphabet" },
            { "Ugar", metaValue_uga },
            { "Mani", "Manich\u00e4esch" },
            { "Khar", "Kharoshthi" },
            { "SA", "Saudi-Arabien" },
            { "pon", "Ponapeanesch" },
            { "Mand", "Mand\u00e4esch" },
            { "SB", "Salomonen" },
            { "twq", "Tasawaq" },
            { "011", "Westafrika" },
            { "SC", "Seychellen" },
            { "SD", "Sudan" },
            { "013", "M\u00ebttelamerika" },
            { "SE", "Schweden" },
            { "014", "Ostafrika" },
            { "arc", "Aram\u00e4esch" },
            { "015", "Nordafrika" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "017", "Zentralafrika" },
            { "SI", "Slowenien" },
            { "018", "S\u00fcdlecht Afrika" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapudungun" },
            { "arp", "Arapaho-Sprooch" },
            { "type.nu.taml", "Tamilesch Zifferen" },
            { "SR", "Suriname" },
            { "aro", "Araona" },
            { "SS", "S\u00fcdsudan" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "arq", "Algerescht Arabesch" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "yao", "Yao-Sprooch" },
            { "SZ", "Swasiland" },
            { "arw", "Arawak-Sprooch" },
            { "arz", "Egyptescht Arabesch" },
            { "ary", "Marokkanescht Arabesch" },
            { "yap", "Yapesesch" },
            { "rtm", "Rotumanesch" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu (Tanzania)" },
            { "021", "N\u00ebrdlecht Amerika" },
            { "TC", "Turks- a Caicosinselen" },
            { "yav", "Yangben" },
            { "TD", "Tschad" },
            { "TF", "Frans\u00e9isch S\u00fcd- an Antarktisgebidder" },
            { "ase", "Amerikanesch Zeechesprooch" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikistan" },
            { "029", "Karibik" },
            { "TK", "Tokelau" },
            { "TL", "Osttimor" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Sich no Ufanksbuschtawen aus dem koreaneschen Alphabet" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "%%NULIK", "Modernt Volap\u00fck" },
            { "TR", "Tierkei" },
            { "TT", "Trinidad an Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturianesch" },
            { "rue", "Russinesch" },
            { "rug", "Roviana" },
            { "Orkh", "Orchon-Runen" },
            { "TZ", "Tansania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Oncod\u00e9iert Schr\u00ebft" },
            { "UA", "Ukrain" },
            { "lij", "Liguresch" },
            { "rup", "Aromunesch" },
            { "030", "Ostasien" },
            { "tyv", "Tuwinesch" },
            { "sw_CD", "Kongo-Swahili" },
            { "034", "S\u00fcdasien" },
            { "hai", "Haida-Sprooch" },
            { "035", "S\u00fcdostasien" },
            { "UG", "Uganda" },
            { "hak", "Hakka-Chinesesch" },
            { "type.co.pinyin", "Pinyin-Zort\u00e9ierregelen" },
            { "039", "S\u00fcdeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "Amerikanesch-Ozeanien" },
            { "liv", "Livesch" },
            { "US", "Vereenegt Staate vun Amerika" },
            { "haw", "Hawaiesch" },
            { "%%1959ACAD", "Akademesch" },
            { "type.co.gb2312han", "Vereinfacht Chinesesch - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Preisesch" },
            { "UZ", "Usbekistan" },
            { "tzm", "M\u00ebttlert-Atlas-Tamazight" },
            { "type.co.stroke", "Str\u00e9chfolleg" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatikanstad" },
            { "pro", "Alprovenzalesch" },
            { "VC", "St. Vincent an d\u2019Grenadinnen" },
            { "VE", "Venezuela" },
            { "VG", "Britesch Joffereninselen" },
            { "VI", "Amerikanesch Joffereninselen" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Alnordesch" },
            { "053", "Australien an Neis\u00e9iland" },
            { "%%AREVMDA", "Westarmenesch" },
            { "054", "Melanesien" },
            { "WF", "Wallis a Futuna" },
            { "type.co.traditional", "Traditionell Zort\u00e9ierregelen" },
            { "057", "Mikronesescht Inselgebitt" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota-Sprooch" },
            { "nov", "Novial" },
            { "avk", "Kotava" },
            { "%%HEPBURN", "Hepburn-Romanis\u00e9ierung" },
            { "wae", "Walliserd\u00e4itsch" },
            { "WS", "Samoa" },
            { "wal", "Walamo-Sprooch" },
            { "was", "Washo-Sprooch" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesien" },
            { "%%KSCOR", "Standard-Rechtschreiwung" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Ouni Schr\u00ebft" },
            { "Olck", "Ol Chiki" },
            { "Batk", "Battakesch" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Standard Zort\u00e9ierreiefolleg" },
            { "lmo", "Lombardesch" },
            { "fan", "Pangwe-Sprooch" },
            { "%%BALANKA", "Balanka-Dialekt vun Anii" },
            { "%%ROZAJ", "Resianesch" },
            { "fat", "Fanti-Sprooch" },
            { "Sgnw", "Zeechesprooch" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00fcdafrika" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgesch Zifferen" },
            { "type.co.zhuyin", "Zhuyin-Zort\u00e9ierregelen" },
            { "Hira", "Hiragana" },
            { "ZM", "Sambia" },
            { "%%PINYIN", "Pinyin" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Onbekannt Regioun" },
            { "Runr", "Runeschr\u00ebft" },
            { "type.ca.iso8601", "ISO-8601-Kalenner" },
            { "lol", "Mongo" },
            { "nso", "Nord-Sotho-Sprooch" },
            { "type.nu.telu", "Telugu-Zifferen" },
            { "loz", "Rotse-Sprooch" },
            { "jmc", "Machame" },
            { "hif", "Fidschi-Hindi" },
            { "type.nu.hansfin", "Vereinfacht-Chinesesch Finanzzifferen" },
            { "hil", "Hiligaynon-Sprooch" },
            { "type.nu.arabext", "Erweidert arabesch-indesch Zifferen" },
            { "nus", "Nuer" },
            { "dak", "Dakota-Sprooch" },
            { "type.nu.fullwide", "Vollbreet Zifferen" },
            { "hit", "Hethitesch" },
            { "dar", "Darginesch" },
            { "dav", "Taita" },
            { "Maya", "Maya-Hieroglyphen" },
            { "Copt", metaValue_cop },
            { "nwc", "Al-Newari" },
            { "udm", "Udmurtesch" },
            { "Khmr", "Khmer" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe-Sprooch" },
            { "type.nu.roman", "R\u00e9imesch Zifferen" },
            { "sah", "Jakutesch" },
            { "sam", metaValue_sam },
            { "ltg", "Lettgallesch" },
            { "%%SCOUSE", "Scouse-Dialekt" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Jiddesch-Persesch" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Aluku-Dialekt" },
            { "lua", "Luba-Lulua" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno-Sprooch" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi-Sprooch" },
            { "lun", "Lunda-Sprooch" },
            { "nyo", "Nyoro" },
            { "luo", "Luo-Sprooch" },
            { "fil", "Filipino" },
            { "hmn", "Miao-Sprooch" },
            { "del", "Delaware-Sprooch" },
            { "lus", "Lushai-Sprooch" },
            { "bal", "Belutschesch" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "Me\u00e4nkieli" },
            { "luy", "Olulujia" },
            { "bar", "Bairesch" },
            { "bas", "Basaa-Sprooch" },
            { "bax", "Bamun" },
            { "jrb", "Jiddesch-Arabesch" },
            { "es_ES", "Europ\u00e4escht Spuenesch" },
            { "nzi", "Nzima" },
            { "sco", "Schottesch" },
            { "scn", "Sizilianesch" },
            { "aa", "Afar" },
            { "ab", "Abchasesch" },
            { "bbc", "Batak Toba" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "bbj", "Ghom\u00e1l\u00e1\u2019" },
            { "am", "Amharesch" },
            { "Arab", metaValue_ar },
            { "an", "Aragonesesch" },
            { "%%SOLBA", "Solbica-Dialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana oder Hiragana" },
            { "as", "Assamesesch" },
            { "sdc", "Sassaresesch" },
            { "Lina", "Linear A" },
            { "av", "Awaresch" },
            { "Linb", "Linear B" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanesch" },
            { "%%OSOJS", "Osojane-Dialekt" },
            { "%%UNIFON", "Phonetescht Unifon-Alphabet" },
            { "ba", "Baschkiresch" },
            { "type.co.unihan", "Radikal-Str\u00e9ch-Zort\u00e9ierregelen" },
            { "be", "W\u00e4issrussesch" },
            { "bg", "Bulgaresch" },
            { "bi", "Bislama" },
            { "bm", "Bambara-Sprooch" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Bretonesch" },
            { "bs", "Bosnesch" },
            { "see", "Seneca" },
            { "Mymr", metaValue_my },
            { "sei", "Seri" },
            { "type.nu.laoo", "Laotesch Zifferen" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkupesch" },
            { "ca", "Katalanesch" },
            { "ses", "Koyra Senni" },
            { "ce", "Tschetschenesch" },
            { "ch", "Chamorro-Sprooch" },
            { "%%REVISED", "Revid\u00e9iert Rechtschreiwung" },
            { "co", "Korsesch" },
            { "Orya", "Oriya" },
            { "cr", "Cree" },
            { "cs", "Tschechesch" },
            { "cu", "Kiercheslawesch" },
            { "yrl", "Nheengatu" },
            { "cv", "Tschuwaschesch" },
            { "cy", "Walisesch" },
            { "type.nu.ethi", "Ethiopesch Zifferen" },
            { "Yiii", "Yi" },
            { "da", "D\u00e4nesch" },
            { "pt_PT", "Europ\u00e4escht Portugisesch" },
            { "de", "D\u00e4itsch" },
            { "bej", "Bedauye" },
            { "din", "Dinka-Sprooch" },
            { "jut", "J\u00fctesch" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba-Sprooch" },
            { "sga", "Aliresch" },
            { "type.nu.mong", "Mongolesch Zifferen" },
            { "dv", "Maldivesch" },
            { "es_419", "Lat\u00e4inamerikanescht Spuenesch" },
            { "bew", "Betawi" },
            { "dz", "Bhutanesch" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Chinesesche Kalenner" },
            { "lzh", "Klassescht Chinesesch" },
            { "dje", "Zarma" },
            { "sgs", "Samogitesch" },
            { "type.nu.grek", "Griichesch Zifferen" },
            { "ee", "Ewe-Sprooch" },
            { "bfd", "Bafut" },
            { "ro_MD", "Moldawesch" },
            { "el", metaValue_el },
            { "en", "Englesch" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Lasesch Sprooch" },
            { "type.co.big5han", "Traditionellt Chinesesch - Big5" },
            { "es", "Spuenesch" },
            { "et", "Estnesch" },
            { "eu", "Baskesch" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", metaValue_sam },
            { "shi", "Taschelhit" },
            { "Hani", metaValue_zh },
            { "hsb", "Uewersorbesch" },
            { "shn", "Schan-Sprooch" },
            { "Hano", "Hanunoo" },
            { "fa", "Persesch" },
            { "Hans", "Vereinfacht" },
            { "type.nu.latn", "Westlech Zifferen" },
            { "Hant", "Traditionell" },
            { "ff", "Ful" },
            { "shu", "Tschadesch-Arabesch" },
            { "hsn", "Xiang-Chinesesch" },
            { "fi", "Finnesch" },
            { "fj", "Fidschianesch" },
            { "fon", "Fon-Sprooch" },
            { "yue", "Kantonesesch" },
            { "fo", "F\u00e4r\u00f6esch" },
            { "umb", "Mbundu-Sprooch" },
            { "fr", "Frans\u00e9isch" },
            { "sid", "Sidamo" },
            { "fy", "Westfriesesch" },
            { "ga", "Iresch" },
            { "gd", "Schottescht G\u00e4llesch" },
            { "gl", "Galizesch" },
            { "gn", "Guarani" },
            { "bho", "Bhodschpuri" },
            { "und", "Onbest\u00ebmmt Sprooch" },
            { "type.ca.ethiopic-amete-alem", "Ethiopesche Kalenner \"Amete Alem\"" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol-Sprooch" },
            { "bin", "Bini-Sprooch" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroatesch" },
            { "ht", "Haitianesch" },
            { "hu", "Ungaresch" },
            { "hy", metaValue_hy },
            { "hz", "Herero-Sprooch" },
            { "frc", "Cajun" },
            { "%%FONIPA", "Phonetesch (IPA)" },
            { "ia", "Interlingua" },
            { "id", "Indonesesch" },
            { "type.nu.tibt", "Tibetesch Zifferen" },
            { "ie", "Interlingue" },
            { "ig", "Igbo-Sprooch" },
            { "ii", "Sichuan Yi" },
            { "frm", "M\u00ebttelfrans\u00e9isch" },
            { "ik", "Inupiak" },
            { "fro", "Alfrans\u00e9isch" },
            { "frp", "Frankoprovenzalesch" },
            { "io", "Ido-Sprooch" },
            { "frs", "Ostfriesesch" },
            { "bjn", "Banjaresesch" },
            { "frr", "Nordfriesesch" },
            { "is", "Isl\u00e4nnesch" },
            { "it", "Italienesch" },
            { "iu", "Inukitut" },
            { "sli", "Nidderschlesesch" },
            { "ja", metaValue_ja },
            { "Mlym", "Malaysesch" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "bkm", "Kom" },
            { "sma", "S\u00fcdsamesch" },
            { "jv", "Javanesch" },
            { "Shaw", "Shaw-Alphabet" },
            { "mad", "Maduresesch" },
            { "smj", "Lule-Lappesch" },
            { "mag", "Khotta" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari-Lappesch" },
            { "ka", metaValue_ka },
            { "bla", "Blackfoot-Sprooch" },
            { "mak", "Makassaresch" },
            { "wuu", "Wu-Chinesesch" },
            { "sms", "Skolt-Lappesch" },
            { "man", "Manding-Sprooch" },
            { "kg", "Kongolesesch" },
            { "Goth", metaValue_got },
            { "ki", "Kikuyu-Sprooch" },
            { "mas", "Massai-Sprooch" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachesch" },
            { "kl", "Gr\u00f6nl\u00e4nnesch" },
            { "km", "Kambodschanesch" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri-Sprooch" },
            { "ks", "Kaschmiresch" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdesch" },
            { "kv", "Komi-Sprooch" },
            { "kw", "Kornesch" },
            { "ky", "Kirgisesch" },
            { "snk", "Soninke-Sprooch" },
            { "la", "Lat\u00e4in" },
            { "lb", "L\u00ebtzebuergesch" },
            { "type.nu.mlym", "Malayalam-Zifferen" },
            { "lg", "Ganda-Sprooch" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgesch" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulesch" },
            { "lo", metaValue_lo },
            { "lt", "Litauesch" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lettesch" },
            { "sog", "Sogdesch" },
            { "mg", "Malagassi-Sprooch" },
            { "mh", "Marschallesesch" },
            { "type.co.ducet", "Unicode-Zort\u00e9ierung" },
            { "mi", "Maori" },
            { "mk", "Mazedonesch" },
            { "ml", "Malayalam" },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiesch" },
            { "mt", "Maltesesch" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Niddersorbesch" },
            { "Armi", "Armi" },
            { "na", "Nauruesch" },
            { "type.co.search", "Allgemeng Sich" },
            { "nb", "Norwegesch Bokm\u00e5l" },
            { "nd", "Nord-Ndebele-Sprooch" },
            { "ne", "Nepalesesch" },
            { "ng", "Ndonga" },
            { "mdr", "Mandaresesch" },
            { "nl", "Holl\u00e4nnesch" },
            { "nn", "Norwegesch Nynorsk" },
            { "no", "Norwegesch" },
            { "nr", "S\u00fcd-Ndebele-Sprooch" },
            { "nv", "Navajo" },
            { "kaa", "Karakalpakesch" },
            { "ny", "Nyanja-Sprooch" },
            { "kac", "Kachin-Sprooch" },
            { "kab", "Kabylesch" },
            { "%%POLYTON", "Polytonesch" },
            { "oc", "Okzitanesch" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende-Sprooch" },
            { "%%EMODENG", "Fr\u00e9it Modernt Englesch" },
            { "oj", "Ojibwa-Sprooch" },
            { "mer", "Meru-Sprooch" },
            { "type.nu.armn", "Armenesch Zifferen" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Zentral-Dusun" },
            { "or", "Orija" },
            { "os", "Ossetesch" },
            { "%%ALALC97", "ALA-LC-Romanis\u00e9ierung, Editioun vun 1997" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardinesch" },
            { "mfe", "Morisyen" },
            { "srn", "Srananesch" },
            { "pa", "Pandschabesch" },
            { "dua", "Duala" },
            { "srr", "Serer-Sprooch" },
            { "%%LIPAW", "Lipovaz-Dialekt" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bachtiaresch" },
            { "pl", "Polnesch" },
            { "dum", "M\u00ebttelholl\u00e4nnesch" },
            { "type.ca.dangi", "Dangi-Kalenner" },
            { "ps", "Paschtu" },
            { "pt", "Portugisesch" },
            { "mga", "M\u00ebtteliresch" },
            { "key.co", "Zort\u00e9ierung" },
            { "pt_BR", "Brasilianescht Portugisesch" },
            { "%%BOHORIC", "Bohori\u010d-Alphabet" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj-Bhakha" },
            { "key.ca", "Kalenner" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Myanmar-Zifferen" },
            { "qu", "Quechua" },
            { "zap", "Zapotekesch" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "stq", "Saterfriesesch" },
            { "Ethi", "Ethiopesch" },
            { "rm", "R\u00e4toromanesch" },
            { "rn", "Rundi-Sprooch" },
            { "key.cu", "W\u00e4hrung" },
            { "ro", "Rum\u00e4nesch" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Oriya-Zifferen" },
            { "type.nu.hanidec", "Chinesesch Dezimalzuelen" },
            { "ru", "Russesch" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Ruandesch" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac-Sprooch" },
            { "suk", "Sukuma-Sprooch" },
            { "en_AU", "Australescht Englesch" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Vereenheetlecht Rechtschreiwung" },
            { "sc", "Sardesch" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Nordsamesch" },
            { "min", "Minangkabau-Sprooch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatesch" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Sumeresch" },
            { "sk", "Slowakesch" },
            { "sl", "Slowenesch" },
            { "sm", "Samoanesch" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Arabesch-indesch Zifferen" },
            { "sq", "Albanesch" },
            { "sr", "Serbesch" },
            { "ss", "Swazi" },
            { "st", "S\u00fcd-Sotho-Sprooch" },
            { "Java", "Javanesesch" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-Dialekt" },
            { "sv", "Schwedesch" },
            { "sw", "Suaheli" },
            { "type.nu.hantfin", "Traditionell-Chinesesch Finanzzifferen" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asien" },
            { "bua", "Burjatesch" },
            { "143", "Zentralasien" },
            { "te", metaValue_te },
            { "145", "Westasien" },
            { "tg", "Tadschikesch" },
            { "th", "Thail\u00e4nnesch" },
            { "bug", metaValue_bug },
            { "ti", "Tigrinja" },
            { "kfo", "Koro" },
            { "en_CA", "Kanadescht Englesch" },
            { "tk", "Turkmenesch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana-Sprooch" },
            { "to", "Tongaesch" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japanesch Zifferen" },
            { "tr", "Tierkesch" },
            { "ts", "Tsonga" },
            { "swb", "Komoresch" },
            { "tt", "Tataresch" },
            { "dyu", "Dyula-Sprooch" },
            { "tw", "Twi" },
            { "ty", "Tahitesch" },
            { "%%BISKE", "Bela-Dialekt" },
            { "150", "Europa" },
            { "151", "Osteuropa" },
            { "154", "Nordeuropa" },
            { "dzg", "Dazaga" },
            { "155", "Westeuropa" },
            { "ug", "Uiguresch" },
            { "Kore", metaValue_ko },
            { "Ital", "Alitalesch" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Onbest\u00ebmmt" },
            { "uk", "Ukrainesch" },
            { "zea", "Seel\u00e4nnesch" },
            { "type.ca.coptic", "Koptesche Kalenner" },
            { "ur", "Urdu" },
            { "%%1994", "Standardis\u00e9iert Resianesch Rechtschreiwung" },
            { "xal", "Kalm\u00fcckesch" },
            { "zen", "Zenaga" },
            { "uz", "Usbekesch" },
            { "kha", "Khasi-Sprooch" },
            { "%%1996", "Nei D\u00e4itsch Rechtschreiwung" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda-Sprooch" },
            { "type.ca.roc", "Kalenner vun der Republik China" },
            { "vi", "Vietnamesesch" },
            { "kho", "Sakesch" },
            { "khq", "Koyra Chiini" },
            { "%%TARASK", "Taraskievica-Orthographie" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "syc", "Alsyresch" },
            { "Osma", metaValue_ota },
            { "quc", "Quich\u00e9-Sprooch" },
            { "qug", "Kichwa (Chimborazo-Gebidder)" },
            { "gaa", "Ga-Sprooch" },
            { "wa", "Wallounesch" },
            { "gag", "Gagausesch" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "Gan-Chinesesch" },
            { "kiu", "Kirmanjki" },
            { "Lydi", "Lydesch" },
            { "Xsux", "Sumeresch-akkadesch Keilschr\u00ebft" },
            { "wo", "Wolof" },
            { "zgh", "Marokkanescht Standard-Tamazight" },
            { "ar_001", "Modernt H\u00e9icharabesch" },
            { "Cans", "UCAS" },
            { "gay", "Gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "Mandschuresch" },
            { "Latf", "Lat\u00e9ngesch-Fraktur-Variant" },
            { "szl", "Schlesesch" },
            { "gba", "Gbaya-Sprooch" },
            { "mni", "Meithei-Sprooch" },
            { "Latn", "Lat\u00e9ngesch" },
            { "Latg", "Lat\u00e9ngesch-G\u00e4llesch Variant" },
            { "type.nu.hans", "Vereinfacht-Chinesesch Zifferen" },
            { "type.nu.hant", "Traditionell-Chinesesch Zifferen" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "R\u00e9imesch Zifferen a Klengschr\u00ebft" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Pamaka-Dialekt" },
            { "Lyci", "Lykesch" },
            { "osa", "Osage-Sprooch" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrianescht Dari" },
            { "Moon", "Moon" },
            { "moh", "Mohawk-Sprooch" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Klassescht Frans\u00e9isch" },
            { "Syrc", metaValue_syr },
            { "yi", "Jiddesch" },
            { "mos", "Mossi-Sprooch" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "es_MX", "Mexikanescht Spuenesch" },
            { "Syrj", "Westsyresch" },
            { "ota", metaValue_ota },
            { "Syre", "Syresch-Estrangelo-Variant" },
            { "vai", "Vai-Sprooch" },
            { "za", "Zhuang" },
            { "Cari", "Karesch" },
            { "kln", "Kalenjin" },
            { "zh", metaValue_zh },
            { "Bopo", "Bopomofo" },
            { "Perm", "Alpermesch" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Telefonsbuch-Zort\u00e9ierung" },
            { "%%MONOTON", "Monotonesch" },
            { "Geor", metaValue_ka },
            { "kmb", "Kimbundu-Sprooch" },
            { "type.nu.jpanfin", "Japanesch Finanzzifferen" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "mrj", "West-Mari" },
            { "Syrn", "Ostsyresch" },
            { "type.co.reformed", "Reform\u00e9iert Zort\u00e9ierreiefolleg" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egyptesch-Demotesch" },
            { "Egyh", "Egyptesch-Hieratesch" },
            { "ebu", "Kiembu" },
            { "Egyp", "Egyptesch Hieroglyphen" },
            { "Geok", "Khutsuri" },
            { "zh_Hans", "Chinesesch (vereinfacht)" },
            { "koi", "Komi-Permiak" },
            { "Hung", "Alungaresch" },
            { "kok", "Konkani" },
            { "%%1901", "Al D\u00e4itsch Rechtschreiwung" },
            { "kos", "Kosraeanesch" },
            { "vec", "Venezesch" },
            { "zh_Hant", "Chinesesch (traditionell)" },
            { "Sund", metaValue_su },
            { "vep", "Wepsesch" },
            { "kpe", "Kpelle-Sprooch" },
            { "type.nu.khmr", "Khmer-Zifferen" },
            { "ilo", "Ilokano-Sprooch" },
            { "%%VALENCIA", "Valencianesch" },
            { "Cprt", "Zypriotesch" },
            { "%%BAKU1926", "Eenheetlecht Tierkescht Alphabet" },
            { "%%IJEKAVSK", "Serbesch mat Ijekavian-Aussprooch" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi-Zifferen" },
            { "mul", "M\u00e9isproocheg" },
            { "cad", "Caddo" },
            { "mus", "Muskogee-Sprooch" },
            { "Glag", "Glagolitesch" },
            { "gil", "Gilbertesesch" },
            { "%%KKCOR", "Allgemeng Rechtschreiwung" },
            { "Cher", metaValue_chr },
            { "car", "Karibesch" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil-Zifferen" },
            { "krc", "Karatschaiesch-Balkaresch" },
            { "inh", "Inguschesch" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "krl", "Karelesch" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "Zuelen" },
            { "kru", "Oraon-Sprooch" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
