/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.apache.tomcat.jakartaee.ClassConverter;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.GlobMatcher;
import org.apache.tomcat.jakartaee.ManifestConverter;
import org.apache.tomcat.jakartaee.PassThroughConverter;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.TextConverter;
import org.apache.tomcat.jakartaee.Util;
import org.apache.tomcat.jakartaee.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.tomcat.jakartaee.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.tomcat.jakartaee.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.tomcat.jakartaee.commons.compress.archivers.zip.ZipFile;
import org.apache.tomcat.jakartaee.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.tomcat.jakartaee.commons.io.IOUtils;
import org.apache.tomcat.jakartaee.commons.io.input.CloseShieldInputStream;
import org.apache.tomcat.jakartaee.commons.io.output.CloseShieldOutputStream;

public class Migration {
    private static final Logger logger = Logger.getLogger(Migration.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(Migration.class);
    private static final Set<String> DEFAULT_EXCLUDES = new HashSet<String>();
    private EESpecProfile profile = EESpecProfile.TOMCAT;
    private boolean zipInMemory;
    private File source;
    private File destination;
    private final List<Converter> converters;
    private final Set<String> excludes = new HashSet<String>();

    public Migration() {
        this.converters = new ArrayList<Converter>();
        this.converters.add(new TextConverter());
        this.converters.add(new ClassConverter());
        this.converters.add(new ManifestConverter());
        this.converters.add(new PassThroughConverter());
    }

    public void setEESpecProfile(EESpecProfile profile) {
        this.profile = profile;
    }

    public EESpecProfile getEESpecProfile() {
        return this.profile;
    }

    public void setZipInMemory(boolean zipInMemory) {
        this.zipInMemory = zipInMemory;
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void setSource(File source) {
        if (!source.canRead()) {
            throw new IllegalArgumentException(sm.getString("migration.cannotReadSource", source.getAbsolutePath()));
        }
        this.source = source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws IOException {
        logger.log(Level.INFO, sm.getString("migration.execute", this.source.getAbsolutePath(), this.destination.getAbsolutePath(), this.profile.toString()));
        long t1 = System.nanoTime();
        if (this.source.isDirectory()) {
            if ((!this.destination.exists() || !this.destination.isDirectory()) && !this.destination.mkdirs()) throw new IOException(sm.getString("migration.mkdirError", this.destination.getAbsolutePath()));
            this.migrateDirectory(this.source, this.destination);
        } else {
            File parentDestination = this.destination.getAbsoluteFile().getParentFile();
            if (!parentDestination.exists() && !parentDestination.mkdirs()) throw new IOException(sm.getString("migration.mkdirError", parentDestination.getAbsolutePath()));
            this.migrateFile(this.source, this.destination);
        }
        logger.log(Level.INFO, sm.getString("migration.done", TimeUnit.MILLISECONDS.convert(System.nanoTime() - t1, TimeUnit.NANOSECONDS)));
    }

    private void migrateDirectory(File src, File dest) throws IOException {
        String[] files;
        for (String file : files = src.list()) {
            File srcFile = new File(src, file);
            File destFile = new File(dest, file);
            if (srcFile.isDirectory()) {
                if (destFile.exists() && destFile.isDirectory() || destFile.mkdir()) {
                    this.migrateDirectory(srcFile, destFile);
                    continue;
                }
                throw new IOException(sm.getString("migration.mkdirError", destFile.getAbsolutePath()));
            }
            this.migrateFile(srcFile, destFile);
        }
    }

    private void migrateFile(File src, File dest) throws IOException {
        block21: {
            boolean inplace = src.equals(dest);
            if (!inplace) {
                try (FileInputStream is = new FileInputStream(src);
                     FileOutputStream os = new FileOutputStream(dest);){
                    this.migrateStream(src.getName(), is, os);
                    break block21;
                }
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)((double)src.length() * 1.05));
            try (FileInputStream is = new FileInputStream(src);){
                this.migrateStream(src.getName(), is, buffer);
            }
            try (FileOutputStream os = new FileOutputStream(dest);){
                ((OutputStream)os).write(buffer.toByteArray());
            }
        }
    }

    private void migrateArchiveStreaming(InputStream src, OutputStream dest) throws IOException {
        try (ZipArchiveInputStream srcZipStream = new ZipArchiveInputStream(new CloseShieldInputStream(src));
             ZipArchiveOutputStream destZipStream = new ZipArchiveOutputStream(new CloseShieldOutputStream(dest));){
            ZipArchiveEntry srcZipEntry;
            while ((srcZipEntry = srcZipStream.getNextZipEntry()) != null) {
                String srcName = srcZipEntry.getName();
                if (this.isSignatureFile(srcName)) {
                    logger.log(Level.WARNING, sm.getString("migration.skipSignatureFile", srcName));
                    continue;
                }
                String destName = this.profile.convert(srcName);
                RenamableZipArchiveEntry destZipEntry = new RenamableZipArchiveEntry(srcZipEntry);
                destZipEntry.setName(destName);
                destZipStream.putArchiveEntry(destZipEntry);
                this.migrateStream(srcName, srcZipStream, destZipStream);
                destZipStream.closeArchiveEntry();
            }
        }
    }

    private void migrateArchiveInMemory(InputStream src, OutputStream dest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(src, (OutputStream)baos);
        baos.flush();
        SeekableInMemoryByteChannel srcByteChannel = new SeekableInMemoryByteChannel(baos.toByteArray());
        SeekableInMemoryByteChannel destByteChannel = new SeekableInMemoryByteChannel();
        try (ZipFile srcZipFile = new ZipFile(srcByteChannel);
             ZipArchiveOutputStream destZipStream = new ZipArchiveOutputStream(destByteChannel);){
            Enumeration<ZipArchiveEntry> entries = srcZipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry srcZipEntry = entries.nextElement();
                String srcName = srcZipEntry.getName();
                if (this.isSignatureFile(srcName)) {
                    logger.log(Level.WARNING, sm.getString("migration.skipSignatureFile", srcName));
                    continue;
                }
                String destName = this.profile.convert(srcName);
                RenamableZipArchiveEntry destZipEntry = new RenamableZipArchiveEntry(srcZipEntry);
                destZipEntry.setName(destName);
                destZipStream.putArchiveEntry(destZipEntry);
                this.migrateStream(srcName, srcZipFile.getInputStream(srcZipEntry), destZipStream);
                destZipStream.closeArchiveEntry();
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(destByteChannel.array(), 0, (int)destByteChannel.size());
        IOUtils.copy((InputStream)bais, dest);
    }

    private boolean isSignatureFile(String sourceName) {
        return sourceName.startsWith("META-INF/") && (sourceName.endsWith(".SF") || sourceName.endsWith(".RSA") || sourceName.endsWith(".DSA") || sourceName.endsWith(".EC"));
    }

    private void migrateStream(String name, InputStream src, OutputStream dest) throws IOException {
        if (this.isExcluded(name)) {
            Util.copy(src, dest);
            logger.log(Level.INFO, sm.getString("migration.skip", name));
        } else if (this.isArchive(name)) {
            if (this.zipInMemory) {
                logger.log(Level.INFO, sm.getString("migration.archive.memory", name));
                this.migrateArchiveInMemory(src, dest);
                logger.log(Level.INFO, sm.getString("migration.archive.complete", name));
            } else {
                logger.log(Level.INFO, sm.getString("migration.archive.stream", name));
                this.migrateArchiveStreaming(src, dest);
                logger.log(Level.INFO, sm.getString("migration.archive.complete", name));
            }
        } else {
            for (Converter converter : this.converters) {
                if (!converter.accepts(name)) continue;
                converter.convert(name, src, dest, this.profile);
                break;
            }
        }
    }

    private boolean isArchive(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".war") || fileName.endsWith(".zip");
    }

    private boolean isExcluded(String name) {
        File f = new File(name);
        String filename = f.getName();
        if (GlobMatcher.matchName(DEFAULT_EXCLUDES, filename, true)) {
            return true;
        }
        return GlobMatcher.matchName(this.excludes, filename, true);
    }

    static {
        DEFAULT_EXCLUDES.add("commons-codec-*.jar");
        DEFAULT_EXCLUDES.add("commons-lang-*.jar");
        DEFAULT_EXCLUDES.add("httpclient-*.jar");
        DEFAULT_EXCLUDES.add("httpcore-*.jar");
        DEFAULT_EXCLUDES.add("asm-*.jar");
        DEFAULT_EXCLUDES.add("aspectjweaver-*.jar");
        DEFAULT_EXCLUDES.add("bcprov*.jar");
        DEFAULT_EXCLUDES.add("bcpkix*.jar");
        DEFAULT_EXCLUDES.add("closure-compiler-*.jar");
        DEFAULT_EXCLUDES.add("ecj-*.jar");
        DEFAULT_EXCLUDES.add("hystrix-core-*.jar");
        DEFAULT_EXCLUDES.add("hystrix-serialization-*.jar");
        DEFAULT_EXCLUDES.add("jackson-annotations-*.jar");
        DEFAULT_EXCLUDES.add("jackson-core-*.jar");
        DEFAULT_EXCLUDES.add("jackson-module-afterburner-*.jar");
        DEFAULT_EXCLUDES.add("jul-to-slf4j-*.jar");
        DEFAULT_EXCLUDES.add("log4j-to-slf4j-*.jar");
        DEFAULT_EXCLUDES.add("slf4j-api-*.jar");
        DEFAULT_EXCLUDES.add("spring-aop-*.jar");
        DEFAULT_EXCLUDES.add("spring-expression-*.jar");
        DEFAULT_EXCLUDES.add("spring-security-crypto-*.jar");
        DEFAULT_EXCLUDES.add("spring-security-rsa-*.jar");
    }

    private static class RenamableZipArchiveEntry
    extends ZipArchiveEntry {
        public RenamableZipArchiveEntry(ZipArchiveEntry entry) throws ZipException {
            super(entry);
        }

        @Override
        public void setName(String name) {
            super.setName(name);
        }
    }
}

