/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator2) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator2));
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator2) {
        Preconditions.checkNotNull(comparator2);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (comparator2.compare(prev2, next2) > 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator2) {
        Preconditions.checkNotNull(comparator2);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (comparator2.compare(prev2, next2) >= 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }

    @Beta
    public static <T extends Comparable<? super T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    @ParametricNullness
    @Beta
    public static <T> T min(@ParametricNullness T a, @ParametricNullness T b, Comparator<T> comparator2) {
        return comparator2.compare(a, b) <= 0 ? a : b;
    }

    @Beta
    public static <T extends Comparable<? super T>> T max(T a, T b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    @ParametricNullness
    @Beta
    public static <T> T max(@ParametricNullness T a, @ParametricNullness T b, Comparator<T> comparator2) {
        return comparator2.compare(a, b) >= 0 ? a : b;
    }
}

