/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private static final byte ABSENT = -1;
    private static final int BYTE_MAX_SIZE = 128;
    private static final int SHORT_MAX_SIZE = 32768;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    @CheckForNull
    private final transient Object hashTable;
    @VisibleForTesting
    final transient @Nullable Object[] alternatingKeysAndValues;
    private final transient int size;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, @Nullable Object[] alternatingKeysAndValues) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(Objects.requireNonNull(alternatingKeysAndValues[0]), Objects.requireNonNull(alternatingKeysAndValues[1]));
            return new RegularImmutableMap<K, V>(null, alternatingKeysAndValues, 1);
        }
        Preconditions.checkPositionIndex(n, alternatingKeysAndValues.length >> 1);
        int tableSize = ImmutableSet.chooseTableSize(n);
        Object hashTable = RegularImmutableMap.createHashTable(alternatingKeysAndValues, n, tableSize, 0);
        return new RegularImmutableMap<K, V>(hashTable, alternatingKeysAndValues, n);
    }

    @CheckForNull
    static Object createHashTable(@Nullable Object[] alternatingKeysAndValues, int n, int tableSize, int keyOffset) {
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(Objects.requireNonNull(alternatingKeysAndValues[keyOffset]), Objects.requireNonNull(alternatingKeysAndValues[keyOffset ^ 1]));
            return null;
        }
        int mask = tableSize - 1;
        if (tableSize <= 128) {
            byte[] hashTable = new byte[tableSize];
            Arrays.fill(hashTable, (byte)-1);
            for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                Object key2 = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
                Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
                CollectPreconditions.checkEntryNotNull(key2, value);
                int h2 = Hashing.smear(key2.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h2 &= mask] & 0xFF) == 255) break;
                    if (key2.equals(alternatingKeysAndValues[previousKeyIndex])) {
                        throw RegularImmutableMap.duplicateKeyException(key2, value, alternatingKeysAndValues, previousKeyIndex);
                    }
                    ++h2;
                }
                hashTable[h2] = (byte)keyIndex;
            }
            return hashTable;
        }
        if (tableSize <= 32768) {
            short[] hashTable = new short[tableSize];
            Arrays.fill(hashTable, (short)-1);
            for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                Object key3 = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
                Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
                CollectPreconditions.checkEntryNotNull(key3, value);
                int h3 = Hashing.smear(key3.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h3 &= mask] & 0xFFFF) == 65535) break;
                    if (key3.equals(alternatingKeysAndValues[previousKeyIndex])) {
                        throw RegularImmutableMap.duplicateKeyException(key3, value, alternatingKeysAndValues, previousKeyIndex);
                    }
                    ++h3;
                }
                hashTable[h3] = (short)keyIndex;
            }
            return hashTable;
        }
        int[] hashTable = new int[tableSize];
        Arrays.fill(hashTable, -1);
        for (int i = 0; i < n; ++i) {
            int keyIndex = 2 * i + keyOffset;
            Object key4 = Objects.requireNonNull(alternatingKeysAndValues[keyIndex]);
            Object value = Objects.requireNonNull(alternatingKeysAndValues[keyIndex ^ 1]);
            CollectPreconditions.checkEntryNotNull(key4, value);
            int h4 = Hashing.smear(key4.hashCode());
            while (true) {
                int previousKeyIndex;
                if ((previousKeyIndex = hashTable[h4 &= mask]) == -1) break;
                if (key4.equals(alternatingKeysAndValues[previousKeyIndex])) {
                    throw RegularImmutableMap.duplicateKeyException(key4, value, alternatingKeysAndValues, previousKeyIndex);
                }
                ++h4;
            }
            hashTable[h4] = keyIndex;
        }
        return hashTable;
    }

    private static IllegalArgumentException duplicateKeyException(Object key2, Object value, @Nullable Object[] alternatingKeysAndValues, int previousKeyIndex) {
        String string2 = String.valueOf(key2);
        String string3 = String.valueOf(value);
        String string4 = String.valueOf(alternatingKeysAndValues[previousKeyIndex]);
        String string5 = String.valueOf(alternatingKeysAndValues[previousKeyIndex ^ 1]);
        return new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Multiple entries with same key: ").append(string2).append("=").append(string3).append(" and ").append(string4).append("=").append(string5).toString());
    }

    private RegularImmutableMap(@CheckForNull Object hashTable, @Nullable Object[] alternatingKeysAndValues, int size) {
        this.hashTable = hashTable;
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key2) {
        Object result = RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, key2);
        if (result == null) {
            return null;
        }
        return (V)result;
    }

    @CheckForNull
    static Object get(@CheckForNull Object hashTableObject, @Nullable Object[] alternatingKeysAndValues, int size, int keyOffset, @CheckForNull Object key2) {
        if (key2 == null) {
            return null;
        }
        if (size == 1) {
            return Objects.requireNonNull(alternatingKeysAndValues[keyOffset]).equals(key2) ? Objects.requireNonNull(alternatingKeysAndValues[keyOffset ^ 1]) : null;
        }
        if (hashTableObject == null) {
            return null;
        }
        if (hashTableObject instanceof byte[]) {
            byte[] hashTable = (byte[])hashTableObject;
            int mask = hashTable.length - 1;
            int h2 = Hashing.smear(key2.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h2 &= mask] & 0xFF) == 255) {
                    return null;
                }
                if (key2.equals(alternatingKeysAndValues[keyIndex])) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h2;
            }
        }
        if (hashTableObject instanceof short[]) {
            short[] hashTable = (short[])hashTableObject;
            int mask = hashTable.length - 1;
            int h3 = Hashing.smear(key2.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h3 &= mask] & 0xFFFF) == 65535) {
                    return null;
                }
                if (key2.equals(alternatingKeysAndValues[keyIndex])) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h3;
            }
        }
        int[] hashTable = (int[])hashTableObject;
        int mask = hashTable.length - 1;
        int h4 = Hashing.smear(key2.hashCode());
        int keyIndex;
        while ((keyIndex = hashTable[h4 &= mask]) != -1) {
            if (key2.equals(alternatingKeysAndValues[keyIndex])) {
                return alternatingKeysAndValues[keyIndex ^ 1];
            }
            ++h4;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keyList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keyList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> map2, ImmutableList<K> list) {
            this.map = map2;
            this.list = list;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.map.get(object) != null;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient @Nullable Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(@Nullable Object[] alternatingKeysAndValues, int offset, int size) {
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public Object get(int index2) {
            Preconditions.checkElementIndex(index2, this.size);
            return Objects.requireNonNull(this.alternatingKeysAndValues[2 * index2 + this.offset]);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient @Nullable Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> map2, @Nullable Object[] alternatingKeysAndValues, int keyOffset, int size) {
            this.map = map2;
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.keyOffset = keyOffset;
            this.size = size;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int index2) {
                    Preconditions.checkElementIndex(index2, size);
                    Object key2 = Objects.requireNonNull(alternatingKeysAndValues[2 * index2 + keyOffset]);
                    Object value = Objects.requireNonNull(alternatingKeysAndValues[2 * index2 + (keyOffset ^ 1)]);
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(key2, value);
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

