'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

var ES_REF_URL = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-cardinality-aggregation.html';

/**
 * A single-value metrics aggregation that calculates an approximate count of
 * distinct values. Values can be extracted either from specific fields in the
 * document or generated by a script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-cardinality-aggregation.html)
 *
 * Aggregation that calculates an approximate count of distinct values.
 *
 * @example
 * const agg = esb.cardinalityAggregation('author_count', 'author');
 *
 * @example
 * const agg = esb.cardinalityAggregation('author_count').script(
 *     esb.script(
 *         'inline',
 *         "doc['author.first_name'].value + ' ' + doc['author.last_name'].value"
 *     ).lang('painless')
 * );
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var CardinalityAggregation = function (_MetricsAggregationBa) {
    (0, _inherits3.default)(CardinalityAggregation, _MetricsAggregationBa);

    // eslint-disable-next-line require-jsdoc
    function CardinalityAggregation(name, field) {
        (0, _classCallCheck3.default)(this, CardinalityAggregation);
        return (0, _possibleConstructorReturn3.default)(this, (CardinalityAggregation.__proto__ || Object.getPrototypeOf(CardinalityAggregation)).call(this, name, 'cardinality', field));
    }

    /**
     * @override
     * @throws {Error} This method cannot be called on CardinalityAggregation
     */


    (0, _createClass3.default)(CardinalityAggregation, [{
        key: 'format',
        value: function format() {
            // Not 100% sure about this.
            console.log('Please refer ' + ES_REF_URL);
            throw new Error('format is not supported in CardinalityAggregation');
        }

        /**
         * The `precision_threshold` options allows to trade memory for accuracy,
         * and defines a unique count below which counts are expected to be close to accurate.
         *
         * @example
         * const agg = esb.cardinalityAggregation(
         *     'author_count',
         *     'author_hash'
         * ).precisionThreshold(100);
         *
         * @param {number} threshold The threshold value.
         * The maximum supported value is 40000, thresholds above this number
         * will have the same effect as a threshold of 40000. The default values is 3000.
         * @returns {CardinalityAggregation} returns `this` so that calls can be chained
         */

    }, {
        key: 'precisionThreshold',
        value: function precisionThreshold(threshold) {
            // TODO: Use validation and warning here
            this._aggsDef.precision_threshold = threshold;
            return this;
        }
    }]);
    return CardinalityAggregation;
}(MetricsAggregationBase);

module.exports = CardinalityAggregation;