/* Generated automatically -- do not modify!    -*- buffer-read-only: t -*- */

#include <config.h>
#include "lib/vswitch-idl.h"
#include <limits.h>
#include "ovs-thread.h"
#include "ovsdb-data.h"
#include "ovsdb-error.h"
#include "util.h"





static struct ovsrec_autoattach *
ovsrec_autoattach_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_autoattach, header_) : NULL;
}

static struct ovsrec_bridge *
ovsrec_bridge_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_bridge, header_) : NULL;
}

static struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_ct_timeout_policy, header_) : NULL;
}

static struct ovsrec_ct_zone *
ovsrec_ct_zone_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_ct_zone, header_) : NULL;
}

static struct ovsrec_controller *
ovsrec_controller_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_controller, header_) : NULL;
}

static struct ovsrec_datapath *
ovsrec_datapath_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_datapath, header_) : NULL;
}

static struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_flow_sample_collector_set, header_) : NULL;
}

static struct ovsrec_flow_table *
ovsrec_flow_table_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_flow_table, header_) : NULL;
}

static struct ovsrec_ipfix *
ovsrec_ipfix_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_ipfix, header_) : NULL;
}

static struct ovsrec_interface *
ovsrec_interface_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_interface, header_) : NULL;
}

static struct ovsrec_manager *
ovsrec_manager_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_manager, header_) : NULL;
}

static struct ovsrec_mirror *
ovsrec_mirror_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_mirror, header_) : NULL;
}

static struct ovsrec_netflow *
ovsrec_netflow_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_netflow, header_) : NULL;
}

static struct ovsrec_open_vswitch *
ovsrec_open_vswitch_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_open_vswitch, header_) : NULL;
}

static struct ovsrec_port *
ovsrec_port_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_port, header_) : NULL;
}

static struct ovsrec_qos *
ovsrec_qos_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_qos, header_) : NULL;
}

static struct ovsrec_queue *
ovsrec_queue_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_queue, header_) : NULL;
}

static struct ovsrec_ssl *
ovsrec_ssl_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_ssl, header_) : NULL;
}

static struct ovsrec_sflow *
ovsrec_sflow_cast(const struct ovsdb_idl_row *row)
{
    return row ? CONTAINER_OF(row, struct ovsrec_sflow, header_) : NULL;
}

/* AutoAttach table. */

const struct ovsrec_autoattach_table *
ovsrec_autoattach_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_autoattach_table *) idl;
}

const struct ovsrec_autoattach *
ovsrec_autoattach_table_first(const struct ovsrec_autoattach_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_autoattach_first(idl);
}


const struct ovsrec_autoattach *
ovsrec_autoattach_table_track_get_first(const struct ovsrec_autoattach_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_autoattach_track_get_first(idl);
}


static void
ovsrec_autoattach_parse_mappings(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_autoattach *row = ovsrec_autoattach_cast(row_);
    row->key_mappings = NULL;
    row->value_mappings = NULL;
    row->n_mappings = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_mappings) {
            row->key_mappings = xmalloc(datum->n * sizeof *row->key_mappings);
            row->value_mappings = xmalloc(datum->n * sizeof *row->value_mappings);
        }
        row->key_mappings[row->n_mappings] = datum->keys[i].integer;
        row->value_mappings[row->n_mappings] = datum->values[i].integer;
        row->n_mappings++;
    }
}

static void
ovsrec_autoattach_parse_system_description(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_autoattach *row = ovsrec_autoattach_cast(row_);

    if (datum->n >= 1) {
        row->system_description = datum->keys[0].string;
    } else {
        row->system_description = "";
    }
}

static void
ovsrec_autoattach_parse_system_name(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_autoattach *row = ovsrec_autoattach_cast(row_);

    if (datum->n >= 1) {
        row->system_name = datum->keys[0].string;
    } else {
        row->system_name = "";
    }
}

static void
ovsrec_autoattach_unparse_mappings(struct ovsdb_idl_row *row_)
{
    struct ovsrec_autoattach *row = ovsrec_autoattach_cast(row_);
    free(row->key_mappings);
    free(row->value_mappings);
}

static void
ovsrec_autoattach_unparse_system_description(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_autoattach_unparse_system_name(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_autoattach_init__(struct ovsdb_idl_row *row)
{
    ovsrec_autoattach_init(ovsrec_autoattach_cast(row));
}

/* Clears the contents of 'row' in table "AutoAttach". */
void
ovsrec_autoattach_init(struct ovsrec_autoattach *row)
{
    memset(row, 0, sizeof *row); 
    row->system_description = "";
    row->system_name = "";
}

/* Searches table "AutoAttach" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_autoattach *
ovsrec_autoattach_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_autoattach_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_autoattach, uuid));
}

/* Searches table "AutoAttach" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_autoattach *
ovsrec_autoattach_table_get_for_uuid(const struct ovsrec_autoattach_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_autoattach_get_for_uuid(idl, uuid);
}

/* Returns a row in table "AutoAttach" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_autoattach *
ovsrec_autoattach_first(const struct ovsdb_idl *idl)
{
    return ovsrec_autoattach_cast(ovsdb_idl_first_row(idl, &ovsrec_table_autoattach));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_autoattach *
ovsrec_autoattach_next(const struct ovsrec_autoattach *row)
{
    return ovsrec_autoattach_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_autoattach_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_autoattach);
}

unsigned int ovsrec_autoattach_row_get_seqno(const struct ovsrec_autoattach *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_autoattach *
ovsrec_autoattach_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_autoattach_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_autoattach));
}

const struct ovsrec_autoattach
*ovsrec_autoattach_track_get_next(const struct ovsrec_autoattach *row)
{
    return ovsrec_autoattach_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "AutoAttach".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_autoattach_delete(const struct ovsrec_autoattach *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "AutoAttach" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_autoattach *
ovsrec_autoattach_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_autoattach_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_autoattach, NULL));
}

bool
ovsrec_autoattach_is_updated(const struct ovsrec_autoattach *row, enum ovsrec_autoattach_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_autoattach_columns[column]);
}

/* Causes the original contents of column "mappings" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mappings" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mappings" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mappings" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_autoattach_insert()).
 *
 *   - If "mappings" has already been modified (with
 *     ovsrec_autoattach_set_mappings()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_autoattach_set_mappings() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_autoattach_verify_mappings(const struct ovsrec_autoattach *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_autoattach_col_mappings);
}

/* Causes the original contents of column "system_description" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "system_description" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "system_description" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "system_description" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_autoattach_insert()).
 *
 *   - If "system_description" has already been modified (with
 *     ovsrec_autoattach_set_system_description()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_autoattach_set_system_description() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_autoattach_verify_system_description(const struct ovsrec_autoattach *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_autoattach_col_system_description);
}

/* Causes the original contents of column "system_name" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "system_name" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "system_name" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "system_name" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_autoattach_insert()).
 *
 *   - If "system_name" has already been modified (with
 *     ovsrec_autoattach_set_system_name()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_autoattach_set_system_name() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_autoattach_verify_system_name(const struct ovsrec_autoattach *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_autoattach_col_system_name);
}

/* Returns the "mappings" column's value from the "AutoAttach" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * 'value_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes mappings's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mappings" member in ovsrec_autoattach. */
const struct ovsdb_datum *
ovsrec_autoattach_get_mappings(const struct ovsrec_autoattach *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    ovs_assert(value_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_autoattach_col_mappings);
}

/* Returns the "system_description" column's value from the "AutoAttach" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes system_description's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "system_description" member in ovsrec_autoattach. */
const struct ovsdb_datum *
ovsrec_autoattach_get_system_description(const struct ovsrec_autoattach *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_autoattach_col_system_description);
}

/* Returns the "system_name" column's value from the "AutoAttach" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes system_name's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "system_name" member in ovsrec_autoattach. */
const struct ovsdb_datum *
ovsrec_autoattach_get_system_name(const struct ovsrec_autoattach *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_autoattach_col_system_name);
}

/* Sets the "mappings" column from the "AutoAttach" table in 'row' to
 * the map with keys 'key_mappings' and values 'value_mappings'
 * with 'n_mappings' entries.
 *
 * Argument constraints: key in range 0 to 16,777,215, value in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_set_mappings(const struct ovsrec_autoattach *row, const int64_t *key_mappings, const int64_t *value_mappings, size_t n_mappings)
{
    struct ovsdb_datum datum;

    datum.n = n_mappings;
    datum.keys = n_mappings ? xmalloc(n_mappings * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_mappings * sizeof *datum.values);
    for (size_t i = 0; i < n_mappings; i++) {
        datum.keys[i].integer = key_mappings[i];
        datum.values[i].integer = value_mappings[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_autoattach_col_mappings, &datum);
}

/* Sets the "system_description" column from the "AutoAttach" table in 'row' to
 * 'system_description'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_set_system_description(const struct ovsrec_autoattach *row, const char *system_description)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, system_description);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_autoattach_col_system_description, &datum);
}

/* Sets the "system_name" column from the "AutoAttach" table in 'row' to
 * 'system_name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_set_system_name(const struct ovsrec_autoattach *row, const char *system_name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, system_name);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_autoattach_col_system_name, &datum);
}

/* Sets an element of the "mappings" map column from the "AutoAttach" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_autoattach_update_mappings_setkey(const struct ovsrec_autoattach *row, int64_t new_key, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].integer = new_key;
    datum->values[0].integer = new_value;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_autoattach_col_mappings,
                                    datum);
}

/* Deletes an element of the "mappings" map column from the "AutoAttach" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_autoattach_update_mappings_delkey(const struct ovsrec_autoattach *row, int64_t delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].integer = delete_key;

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_autoattach_col_mappings,
                                    datum);
}

/* Sets the "mappings" column from the "AutoAttach" table in 'row' to
 * the map with keys 'key_mappings' and values 'value_mappings'
 * with 'n_mappings' entries.
 *
 * Argument constraints: key in range 0 to 16,777,215, value in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_add_clause_mappings(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *key_mappings, const int64_t *value_mappings, size_t n_mappings)
{
    struct ovsdb_datum datum;
    datum.n = n_mappings;
    datum.keys = n_mappings ? xmalloc(n_mappings * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_mappings * sizeof *datum.values);
    for (size_t i = 0; i < n_mappings; i++) {
        datum.keys[i].integer = key_mappings[i];
        datum.values[i].integer = value_mappings[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_INTEGER);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_autoattach_col_mappings,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Sets the "system_description" column from the "AutoAttach" table in 'row' to
 * 'system_description'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_add_clause_system_description(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *system_description)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, system_description);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_autoattach_col_system_description,
                          &datum);
}

/* Sets the "system_name" column from the "AutoAttach" table in 'row' to
 * 'system_name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_add_clause_system_name(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *system_name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, system_name);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_autoattach_col_system_name,
                          &datum);
}

/* Destroy 'row' of kind "AutoAttach". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_autoattach_index_destroy_row(const struct ovsrec_autoattach *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "AutoAttach". */
struct ovsrec_autoattach *
ovsrec_autoattach_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_autoattach);
    return ALIGNED_CAST(struct ovsrec_autoattach *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_autoattach *
ovsrec_autoattach_index_find(struct ovsdb_idl_index *index, const struct ovsrec_autoattach *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_autoattach);
    return ovsrec_autoattach_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_autoattach_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_autoattach *a, 
    const struct ovsrec_autoattach *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_autoattach_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_autoattach);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_autoattach_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_autoattach *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_autoattach);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_autoattach_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_autoattach *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_autoattach);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_autoattach *
ovsrec_autoattach_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_autoattach_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "mappings" column from the "AutoAttach" table in 'row' to
 * the map with keys 'key_mappings' and values 'value_mappings'
 * with 'n_mappings' entries.
 *
 * Argument constraints: key in range 0 to 16,777,215, value in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_index_set_mappings(const struct ovsrec_autoattach *row, const int64_t *key_mappings, const int64_t *value_mappings, size_t n_mappings)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_mappings;
    datum.keys = n_mappings ? xmalloc(n_mappings * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_mappings * sizeof *datum.values);
    for (i = 0; i < n_mappings; i++) {
        datum.keys[i].integer = key_mappings[i];
        datum.values[i].integer = value_mappings[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_INTEGER);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_autoattach_columns[ OVSREC_AUTOATTACH_COL_MAPPINGS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_AUTOATTACH]);
}

/* Sets the "system_description" column from the "AutoAttach" table in 'row' to
 * 'system_description'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_index_set_system_description(const struct ovsrec_autoattach *row, const char *system_description)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, system_description);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_autoattach_columns[ OVSREC_AUTOATTACH_COL_SYSTEM_DESCRIPTION ], &datum, &ovsrec_table_classes[OVSREC_TABLE_AUTOATTACH]);
}

/* Sets the "system_name" column from the "AutoAttach" table in 'row' to
 * 'system_name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_autoattach_index_set_system_name(const struct ovsrec_autoattach *row, const char *system_name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, system_name);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_autoattach_columns[ OVSREC_AUTOATTACH_COL_SYSTEM_NAME ], &datum, &ovsrec_table_classes[OVSREC_TABLE_AUTOATTACH]);
}

struct ovsdb_idl_column ovsrec_autoattach_columns[OVSREC_AUTOATTACH_N_COLUMNS];

unsigned int
ovsrec_autoattach_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_autoattach, condition);
}

struct ovsdb_idl_column ovsrec_autoattach_columns[OVSREC_AUTOATTACH_N_COLUMNS] = {
    [OVSREC_AUTOATTACH_COL_MAPPINGS] = {
         .name = "mappings",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(16777215) },
            },
            .value = {
                .type = OVSDB_TYPE_INTEGER,
                .integer = { .min = INT64_C(0), .max = INT64_C(4095) },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_autoattach_parse_mappings,
         .unparse = ovsrec_autoattach_unparse_mappings,
    },

    [OVSREC_AUTOATTACH_COL_SYSTEM_DESCRIPTION] = {
         .name = "system_description",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_autoattach_parse_system_description,
         .unparse = ovsrec_autoattach_unparse_system_description,
    },

    [OVSREC_AUTOATTACH_COL_SYSTEM_NAME] = {
         .name = "system_name",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_autoattach_parse_system_name,
         .unparse = ovsrec_autoattach_unparse_system_name,
    },

};

/* Bridge table. */

const struct ovsrec_bridge_table *
ovsrec_bridge_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_bridge_table *) idl;
}

const struct ovsrec_bridge *
ovsrec_bridge_table_first(const struct ovsrec_bridge_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_bridge_first(idl);
}


const struct ovsrec_bridge *
ovsrec_bridge_table_track_get_first(const struct ovsrec_bridge_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_bridge_track_get_first(idl);
}


static void
ovsrec_bridge_parse_auto_attach(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->auto_attach = ovsrec_autoattach_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_autoattach, &datum->keys[0].uuid));
    } else {
        row->auto_attach = NULL;
    }
}

static void
ovsrec_bridge_parse_controller(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    row->controller = NULL;
    row->n_controller = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_controller *keyRow = ovsrec_controller_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_controller, &datum->keys[i].uuid));
        if (!keyRow) {
            continue;
        }
        if (!row->n_controller) {
            row->controller = xmalloc(datum->n * sizeof *row->controller);
        }
        row->controller[row->n_controller] = keyRow;
        row->n_controller++;
    }
}

static void
ovsrec_bridge_parse_datapath_id(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->datapath_id = datum->keys[0].string;
    } else {
        row->datapath_id = NULL;
    }
}

static void
ovsrec_bridge_parse_datapath_type(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->datapath_type = datum->keys[0].string;
    } else {
        row->datapath_type = "";
    }
}

static void
ovsrec_bridge_parse_datapath_version(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->datapath_version = datum->keys[0].string;
    } else {
        row->datapath_version = "";
    }
}

static void
ovsrec_bridge_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_bridge_parse_fail_mode(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->fail_mode = datum->keys[0].string;
    } else {
        row->fail_mode = NULL;
    }
}

static void
ovsrec_bridge_parse_flood_vlans(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    size_t n = MIN(4096, datum->n);
    row->flood_vlans = NULL;
    row->n_flood_vlans = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_flood_vlans) {
            row->flood_vlans = xmalloc(n * sizeof *row->flood_vlans);
        }
        row->flood_vlans[row->n_flood_vlans] = datum->keys[i].integer;
        row->n_flood_vlans++;
    }
}

static void
ovsrec_bridge_parse_flow_tables(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    row->key_flow_tables = NULL;
    row->value_flow_tables = NULL;
    row->n_flow_tables = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_flow_table *valueRow = ovsrec_flow_table_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_flow_table, &datum->values[i].uuid));
        if (!valueRow) {
            continue;
        }
        if (!row->n_flow_tables) {
            row->key_flow_tables = xmalloc(datum->n * sizeof *row->key_flow_tables);
            row->value_flow_tables = xmalloc(datum->n * sizeof *row->value_flow_tables);
        }
        row->key_flow_tables[row->n_flow_tables] = datum->keys[i].integer;
        row->value_flow_tables[row->n_flow_tables] = valueRow;
        row->n_flow_tables++;
    }
}

static void
ovsrec_bridge_parse_ipfix(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->ipfix = ovsrec_ipfix_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_ipfix, &datum->keys[0].uuid));
    } else {
        row->ipfix = NULL;
    }
}

static void
ovsrec_bridge_parse_mcast_snooping_enable(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->mcast_snooping_enable = datum->keys[0].boolean;
    } else {
        row->mcast_snooping_enable = false;
    }
}

static void
ovsrec_bridge_parse_mirrors(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    row->mirrors = NULL;
    row->n_mirrors = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_mirror *keyRow = ovsrec_mirror_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_mirror, &datum->keys[i].uuid));
        if (!keyRow) {
            continue;
        }
        if (!row->n_mirrors) {
            row->mirrors = xmalloc(datum->n * sizeof *row->mirrors);
        }
        row->mirrors[row->n_mirrors] = keyRow;
        row->n_mirrors++;
    }
}

static void
ovsrec_bridge_parse_name(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->name = datum->keys[0].string;
    } else {
        row->name = "";
    }
}

static void
ovsrec_bridge_parse_netflow(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->netflow = ovsrec_netflow_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_netflow, &datum->keys[0].uuid));
    } else {
        row->netflow = NULL;
    }
}

static void
ovsrec_bridge_parse_other_config(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_init(&row->other_config);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->other_config,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_bridge_parse_ports(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    row->ports = NULL;
    row->n_ports = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_port *keyRow = ovsrec_port_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_port, &datum->keys[i].uuid));
        if (!keyRow) {
            continue;
        }
        if (!row->n_ports) {
            row->ports = xmalloc(datum->n * sizeof *row->ports);
        }
        row->ports[row->n_ports] = keyRow;
        row->n_ports++;
    }
}

static void
ovsrec_bridge_parse_protocols(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    row->protocols = NULL;
    row->n_protocols = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_protocols) {
            row->protocols = xmalloc(datum->n * sizeof *row->protocols);
        }
        row->protocols[row->n_protocols] = datum->keys[i].string;
        row->n_protocols++;
    }
}

static void
ovsrec_bridge_parse_rstp_enable(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->rstp_enable = datum->keys[0].boolean;
    } else {
        row->rstp_enable = false;
    }
}

static void
ovsrec_bridge_parse_rstp_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_init(&row->rstp_status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->rstp_status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_bridge_parse_sflow(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->sflow = ovsrec_sflow_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_sflow, &datum->keys[0].uuid));
    } else {
        row->sflow = NULL;
    }
}

static void
ovsrec_bridge_parse_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_init(&row->status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_bridge_parse_stp_enable(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);

    if (datum->n >= 1) {
        row->stp_enable = datum->keys[0].boolean;
    } else {
        row->stp_enable = false;
    }
}

static void
ovsrec_bridge_unparse_auto_attach(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_controller(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->controller);
}

static void
ovsrec_bridge_unparse_datapath_id(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_datapath_type(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_datapath_version(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_bridge_unparse_fail_mode(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_flood_vlans(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->flood_vlans);
}

static void
ovsrec_bridge_unparse_flow_tables(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->key_flow_tables);
    free(row->value_flow_tables);
}

static void
ovsrec_bridge_unparse_ipfix(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_mcast_snooping_enable(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_mirrors(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->mirrors);
}

static void
ovsrec_bridge_unparse_name(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_netflow(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_other_config(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_destroy(&row->other_config);
}

static void
ovsrec_bridge_unparse_ports(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->ports);
}

static void
ovsrec_bridge_unparse_protocols(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    free(row->protocols);
}

static void
ovsrec_bridge_unparse_rstp_enable(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_rstp_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_destroy(&row->rstp_status);
}

static void
ovsrec_bridge_unparse_sflow(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_unparse_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_bridge *row = ovsrec_bridge_cast(row_);
    smap_destroy(&row->status);
}

static void
ovsrec_bridge_unparse_stp_enable(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_bridge_init__(struct ovsdb_idl_row *row)
{
    ovsrec_bridge_init(ovsrec_bridge_cast(row));
}

/* Clears the contents of 'row' in table "Bridge". */
void
ovsrec_bridge_init(struct ovsrec_bridge *row)
{
    memset(row, 0, sizeof *row); 
    row->datapath_type = "";
    row->datapath_version = "";
    smap_init(&row->external_ids);
    row->name = "";
    smap_init(&row->other_config);
    smap_init(&row->rstp_status);
    smap_init(&row->status);
}

/* Searches table "Bridge" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_bridge *
ovsrec_bridge_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_bridge_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_bridge, uuid));
}

/* Searches table "Bridge" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_bridge *
ovsrec_bridge_table_get_for_uuid(const struct ovsrec_bridge_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_bridge_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Bridge" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_bridge *
ovsrec_bridge_first(const struct ovsdb_idl *idl)
{
    return ovsrec_bridge_cast(ovsdb_idl_first_row(idl, &ovsrec_table_bridge));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_bridge *
ovsrec_bridge_next(const struct ovsrec_bridge *row)
{
    return ovsrec_bridge_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_bridge_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_bridge);
}

unsigned int ovsrec_bridge_row_get_seqno(const struct ovsrec_bridge *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_bridge *
ovsrec_bridge_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_bridge_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_bridge));
}

const struct ovsrec_bridge
*ovsrec_bridge_track_get_next(const struct ovsrec_bridge *row)
{
    return ovsrec_bridge_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Bridge".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_delete(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Bridge" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_bridge *
ovsrec_bridge_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_bridge_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_bridge, NULL));
}

bool
ovsrec_bridge_is_updated(const struct ovsrec_bridge *row, enum ovsrec_bridge_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_bridge_columns[column]);
}

/* Causes the original contents of column "auto_attach" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "auto_attach" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "auto_attach" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "auto_attach" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "auto_attach" has already been modified (with
 *     ovsrec_bridge_set_auto_attach()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_auto_attach() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_auto_attach(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_auto_attach);
}

/* Causes the original contents of column "controller" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "controller" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "controller" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "controller" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "controller" has already been modified (with
 *     ovsrec_bridge_set_controller()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_controller() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_controller(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_controller);
}

/* Causes the original contents of column "datapath_id" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "datapath_id" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "datapath_id" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "datapath_id" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "datapath_id" has already been modified (with
 *     ovsrec_bridge_set_datapath_id()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_datapath_id() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_datapath_id(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_datapath_id);
}

/* Causes the original contents of column "datapath_type" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "datapath_type" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "datapath_type" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "datapath_type" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "datapath_type" has already been modified (with
 *     ovsrec_bridge_set_datapath_type()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_datapath_type() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_datapath_type(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_datapath_type);
}

/* Causes the original contents of column "datapath_version" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "datapath_version" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "datapath_version" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "datapath_version" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "datapath_version" has already been modified (with
 *     ovsrec_bridge_set_datapath_version()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_datapath_version() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_datapath_version(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_datapath_version);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_bridge_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_external_ids(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_external_ids);
}

/* Causes the original contents of column "fail_mode" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "fail_mode" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "fail_mode" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "fail_mode" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "fail_mode" has already been modified (with
 *     ovsrec_bridge_set_fail_mode()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_fail_mode() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_fail_mode(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_fail_mode);
}

/* Causes the original contents of column "flood_vlans" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "flood_vlans" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "flood_vlans" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "flood_vlans" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "flood_vlans" has already been modified (with
 *     ovsrec_bridge_set_flood_vlans()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_flood_vlans() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_flood_vlans(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_flood_vlans);
}

/* Causes the original contents of column "flow_tables" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "flow_tables" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "flow_tables" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "flow_tables" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "flow_tables" has already been modified (with
 *     ovsrec_bridge_set_flow_tables()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_flow_tables() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_flow_tables(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_flow_tables);
}

/* Causes the original contents of column "ipfix" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ipfix" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ipfix" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ipfix" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "ipfix" has already been modified (with
 *     ovsrec_bridge_set_ipfix()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_ipfix() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_ipfix(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_ipfix);
}

/* Causes the original contents of column "mcast_snooping_enable" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mcast_snooping_enable" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mcast_snooping_enable" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mcast_snooping_enable" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "mcast_snooping_enable" has already been modified (with
 *     ovsrec_bridge_set_mcast_snooping_enable()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_mcast_snooping_enable() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_mcast_snooping_enable(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_mcast_snooping_enable);
}

/* Causes the original contents of column "mirrors" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mirrors" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mirrors" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mirrors" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "mirrors" has already been modified (with
 *     ovsrec_bridge_set_mirrors()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_mirrors() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_mirrors(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_mirrors);
}

/* Causes the original contents of column "name" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "name" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "name" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "name" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "name" has already been modified (with
 *     ovsrec_bridge_set_name()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_name() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_name(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_name);
}

/* Causes the original contents of column "netflow" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "netflow" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "netflow" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "netflow" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "netflow" has already been modified (with
 *     ovsrec_bridge_set_netflow()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_netflow() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_netflow(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_netflow);
}

/* Causes the original contents of column "other_config" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "other_config" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "other_config" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "other_config" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "other_config" has already been modified (with
 *     ovsrec_bridge_set_other_config()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_other_config() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_other_config(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_other_config);
}

/* Causes the original contents of column "ports" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ports" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ports" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ports" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "ports" has already been modified (with
 *     ovsrec_bridge_set_ports()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_ports() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_ports(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_ports);
}

/* Causes the original contents of column "protocols" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "protocols" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "protocols" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "protocols" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "protocols" has already been modified (with
 *     ovsrec_bridge_set_protocols()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_protocols() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_protocols(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_protocols);
}

/* Causes the original contents of column "rstp_enable" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "rstp_enable" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "rstp_enable" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "rstp_enable" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "rstp_enable" has already been modified (with
 *     ovsrec_bridge_set_rstp_enable()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_rstp_enable() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_rstp_enable(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_rstp_enable);
}

/* Causes the original contents of column "rstp_status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "rstp_status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "rstp_status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "rstp_status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "rstp_status" has already been modified (with
 *     ovsrec_bridge_set_rstp_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_rstp_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_rstp_status(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_rstp_status);
}

/* Causes the original contents of column "sflow" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "sflow" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "sflow" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "sflow" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "sflow" has already been modified (with
 *     ovsrec_bridge_set_sflow()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_sflow() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_sflow(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_sflow);
}

/* Causes the original contents of column "status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "status" has already been modified (with
 *     ovsrec_bridge_set_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_status(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_status);
}

/* Causes the original contents of column "stp_enable" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "stp_enable" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "stp_enable" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "stp_enable" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_bridge_insert()).
 *
 *   - If "stp_enable" has already been modified (with
 *     ovsrec_bridge_set_stp_enable()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_bridge_set_stp_enable() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_bridge_verify_stp_enable(const struct ovsrec_bridge *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_bridge_col_stp_enable);
}

/* Returns the "auto_attach" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes auto_attach's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "auto_attach" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_auto_attach(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_auto_attach);
}

/* Returns the "controller" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes controller's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "controller" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_controller(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_controller);
}

/* Returns the "datapath_id" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes datapath_id's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "datapath_id" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_datapath_id(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_datapath_id);
}

/* Returns the "datapath_type" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes datapath_type's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "datapath_type" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_datapath_type(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_datapath_type);
}

/* Returns the "datapath_version" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes datapath_version's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "datapath_version" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_datapath_version(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_datapath_version);
}

/* Returns the "external_ids" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_external_ids(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_external_ids);
}

/* Returns the "fail_mode" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes fail_mode's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "fail_mode" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_fail_mode(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_fail_mode);
}

/* Returns the "flood_vlans" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes flood_vlans's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "flood_vlans" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_flood_vlans(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_flood_vlans);
}

/* Returns the "flow_tables" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * 'value_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes flow_tables's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "flow_tables" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_flow_tables(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    ovs_assert(value_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_flow_tables);
}

/* Returns the "ipfix" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes ipfix's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ipfix" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_ipfix(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_ipfix);
}

/* Returns the "mcast_snooping_enable" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes mcast_snooping_enable's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mcast_snooping_enable" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_mcast_snooping_enable(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_mcast_snooping_enable);
}

/* Returns the "mirrors" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes mirrors's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mirrors" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_mirrors(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_mirrors);
}

/* Returns the "name" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes name's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "name" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_name(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_name);
}

/* Returns the "netflow" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes netflow's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "netflow" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_netflow(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_netflow);
}

/* Returns the "other_config" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes other_config's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "other_config" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_other_config(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_other_config);
}

/* Returns the "ports" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes ports's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ports" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_ports(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_ports);
}

/* Returns the "protocols" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes protocols's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "protocols" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_protocols(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_protocols);
}

/* Returns the "rstp_enable" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes rstp_enable's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "rstp_enable" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_rstp_enable(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_rstp_enable);
}

/* Returns the "rstp_status" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes rstp_status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "rstp_status" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_rstp_status(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_rstp_status);
}

/* Returns the "sflow" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes sflow's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "sflow" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_sflow(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_sflow);
}

/* Returns the "status" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "status" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_status(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_status);
}

/* Returns the "stp_enable" column's value from the "Bridge" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes stp_enable's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "stp_enable" member in ovsrec_bridge. */
const struct ovsdb_datum *
ovsrec_bridge_get_stp_enable(const struct ovsrec_bridge *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_bridge_col_stp_enable);
}

/* Sets the "auto_attach" column from the "Bridge" table in 'row' to
 * the 'auto_attach' set.
 *
 * If "auto_attach" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_auto_attach(const struct ovsrec_bridge *row, const struct ovsrec_autoattach *auto_attach)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (auto_attach) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = auto_attach->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_auto_attach, &datum);
}

/* Sets the "controller" column from the "Bridge" table in 'row' to
 * the 'controller' set with 'n_controller' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_controller(const struct ovsrec_bridge *row, struct ovsrec_controller **controller, size_t n_controller)
{
    struct ovsdb_datum datum;

    datum.n = n_controller;
    datum.keys = n_controller ? xmalloc(n_controller * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_controller; i++) {
        datum.keys[i].uuid = controller[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_controller, &datum);
}

/* Sets the "datapath_id" column from the "Bridge" table in 'row' to
 * the 'datapath_id' set.
 *
 * If "datapath_id" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_datapath_id(const struct ovsrec_bridge *row, const char *datapath_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (datapath_id) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, datapath_id);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_datapath_id, &datum);
}

/* Sets the "datapath_type" column from the "Bridge" table in 'row' to
 * 'datapath_type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_datapath_type(const struct ovsrec_bridge *row, const char *datapath_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_type);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_datapath_type, &datum);
}

/* Sets the "datapath_version" column from the "Bridge" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_datapath_version(const struct ovsrec_bridge *row, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_datapath_version, &datum);
}

/* Sets the "external_ids" column's value from the "Bridge" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_bridge_set_external_ids(const struct ovsrec_bridge *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_bridge_col_external_ids,
                        &datum);
}


/* Sets the "fail_mode" column from the "Bridge" table in 'row' to
 * the 'fail_mode' set.
 *
 * If "fail_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "secure" or "standalone"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_fail_mode(const struct ovsrec_bridge *row, const char *fail_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (fail_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, fail_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_fail_mode, &datum);
}

/* Sets the "flood_vlans" column from the "Bridge" table in 'row' to
 * the 'flood_vlans' set with 'n_flood_vlans' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_flood_vlans(const struct ovsrec_bridge *row, const int64_t *flood_vlans, size_t n_flood_vlans)
{
    struct ovsdb_datum datum;

    datum.n = n_flood_vlans;
    datum.keys = n_flood_vlans ? xmalloc(n_flood_vlans * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_flood_vlans; i++) {
        datum.keys[i].integer = flood_vlans[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_flood_vlans, &datum);
}

/* Sets the "flow_tables" column from the "Bridge" table in 'row' to
 * the map with keys 'key_flow_tables' and values 'value_flow_tables'
 * with 'n_flow_tables' entries.
 *
 * Argument constraints: key in range 0 to 254
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_flow_tables(const struct ovsrec_bridge *row, const int64_t *key_flow_tables, struct ovsrec_flow_table **value_flow_tables, size_t n_flow_tables)
{
    struct ovsdb_datum datum;

    datum.n = n_flow_tables;
    datum.keys = n_flow_tables ? xmalloc(n_flow_tables * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_flow_tables * sizeof *datum.values);
    for (size_t i = 0; i < n_flow_tables; i++) {
        datum.keys[i].integer = key_flow_tables[i];
        datum.values[i].uuid = value_flow_tables[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_flow_tables, &datum);
}

/* Sets the "ipfix" column from the "Bridge" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_ipfix(const struct ovsrec_bridge *row, const struct ovsrec_ipfix *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (ipfix) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = ipfix->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_ipfix, &datum);
}

/* Sets the "mcast_snooping_enable" column from the "Bridge" table in 'row' to
 * 'mcast_snooping_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_mcast_snooping_enable(const struct ovsrec_bridge *row, bool mcast_snooping_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = mcast_snooping_enable;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_mcast_snooping_enable, &datum);
}

/* Sets the "mirrors" column from the "Bridge" table in 'row' to
 * the 'mirrors' set with 'n_mirrors' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_mirrors(const struct ovsrec_bridge *row, struct ovsrec_mirror **mirrors, size_t n_mirrors)
{
    struct ovsdb_datum datum;

    datum.n = n_mirrors;
    datum.keys = n_mirrors ? xmalloc(n_mirrors * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_mirrors; i++) {
        datum.keys[i].uuid = mirrors[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_mirrors, &datum);
}

/* Sets the "name" column from the "Bridge" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_name(const struct ovsrec_bridge *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_name, &datum);
}

/* Sets the "netflow" column from the "Bridge" table in 'row' to
 * the 'netflow' set.
 *
 * If "netflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_netflow(const struct ovsrec_bridge *row, const struct ovsrec_netflow *netflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (netflow) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = netflow->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_netflow, &datum);
}

/* Sets the "other_config" column's value from the "Bridge" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_bridge_set_other_config(const struct ovsrec_bridge *row, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_bridge_col_other_config,
                        &datum);
}


/* Sets the "ports" column from the "Bridge" table in 'row' to
 * the 'ports' set with 'n_ports' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_ports(const struct ovsrec_bridge *row, struct ovsrec_port **ports, size_t n_ports)
{
    struct ovsdb_datum datum;

    datum.n = n_ports;
    datum.keys = n_ports ? xmalloc(n_ports * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_ports; i++) {
        datum.keys[i].uuid = ports[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_ports, &datum);
}

/* Sets the "protocols" column from the "Bridge" table in 'row' to
 * the 'protocols' set with 'n_protocols' entries.
 *
 * Argument constraints: one of "OpenFlow10", "OpenFlow11", "OpenFlow12", "OpenFlow13", "OpenFlow14", or "OpenFlow15"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_protocols(const struct ovsrec_bridge *row, const char **protocols, size_t n_protocols)
{
    struct ovsdb_datum datum;

    datum.n = n_protocols;
    datum.keys = n_protocols ? xmalloc(n_protocols * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_protocols; i++) {
        datum.keys[i].string = xstrdup(protocols[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_bridge_col_protocols, &datum);
}

/* Sets the "rstp_enable" column from the "Bridge" table in 'row' to
 * 'rstp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_rstp_enable(const struct ovsrec_bridge *row, bool rstp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = rstp_enable;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_rstp_enable, &datum);
}

/* Sets the "rstp_status" column's value from the "Bridge" table in 'row'
 * to 'rstp_status'.
 *
 * The caller retains ownership of 'rstp_status' and everything in it. */
void
ovsrec_bridge_set_rstp_status(const struct ovsrec_bridge *row, const struct smap *rstp_status)
{
    struct ovsdb_datum datum;

    if (rstp_status) {
        ovsdb_datum_from_smap(&datum, rstp_status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_bridge_col_rstp_status,
                        &datum);
}


/* Sets the "sflow" column from the "Bridge" table in 'row' to
 * the 'sflow' set.
 *
 * If "sflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_sflow(const struct ovsrec_bridge *row, const struct ovsrec_sflow *sflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (sflow) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = sflow->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_sflow, &datum);
}

/* Sets the "status" column's value from the "Bridge" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_bridge_set_status(const struct ovsrec_bridge *row, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_bridge_col_status,
                        &datum);
}


/* Sets the "stp_enable" column from the "Bridge" table in 'row' to
 * 'stp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_set_stp_enable(const struct ovsrec_bridge *row, bool stp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = stp_enable;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_bridge_col_stp_enable, &datum);
}

/* Adds the value 'new_value' to the "auto_attach" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_auto_attach_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_autoattach *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_auto_attach,
                                    datum);
}

/* Deletes the value 'delete_value' from the "auto_attach" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_auto_attach_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_autoattach *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_auto_attach,
                                    datum);
}

/* Adds the value 'new_value' to the "controller" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_controller_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_controller *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_controller,
                                    datum);
}

/* Deletes the value 'delete_value' from the "controller" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_controller_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_controller *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_controller,
                                    datum);
}

/* Adds the value 'new_value' to the "datapath_id" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_datapath_id_addvalue(const struct ovsrec_bridge *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_datapath_id,
                                    datum);
}

/* Deletes the value 'delete_value' from the "datapath_id" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_datapath_id_delvalue(const struct ovsrec_bridge *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_datapath_id,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "Bridge" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_bridge_update_external_ids_setkey(const struct ovsrec_bridge *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_bridge_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Bridge" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_bridge_update_external_ids_delkey(const struct ovsrec_bridge *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_bridge_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "fail_mode" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_fail_mode_addvalue(const struct ovsrec_bridge *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_fail_mode,
                                    datum);
}

/* Deletes the value 'delete_value' from the "fail_mode" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_fail_mode_delvalue(const struct ovsrec_bridge *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_fail_mode,
                                    datum);
}

/* Adds the value 'new_value' to the "flood_vlans" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_flood_vlans_addvalue(const struct ovsrec_bridge *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_flood_vlans,
                                    datum);
}

/* Deletes the value 'delete_value' from the "flood_vlans" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_flood_vlans_delvalue(const struct ovsrec_bridge *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_flood_vlans,
                                    datum);
}

/* Sets an element of the "flow_tables" map column from the "Bridge" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_bridge_update_flow_tables_setkey(const struct ovsrec_bridge *row, int64_t new_key, const struct ovsrec_flow_table *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].integer = new_key;
    datum->values[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_bridge_col_flow_tables,
                                    datum);
}

/* Deletes an element of the "flow_tables" map column from the "Bridge" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_bridge_update_flow_tables_delkey(const struct ovsrec_bridge *row, int64_t delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].integer = delete_key;

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_bridge_col_flow_tables,
                                    datum);
}

/* Adds the value 'new_value' to the "ipfix" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_ipfix_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_ipfix *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_ipfix,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ipfix" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_ipfix_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_ipfix *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_ipfix,
                                    datum);
}

/* Adds the value 'new_value' to the "mirrors" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_mirrors_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_mirror *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_mirrors,
                                    datum);
}

/* Deletes the value 'delete_value' from the "mirrors" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_mirrors_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_mirror *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_mirrors,
                                    datum);
}

/* Adds the value 'new_value' to the "netflow" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_netflow_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_netflow *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_netflow,
                                    datum);
}

/* Deletes the value 'delete_value' from the "netflow" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_netflow_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_netflow *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_netflow,
                                    datum);
}

/* Sets an element of the "other_config" map column from the "Bridge" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_bridge_update_other_config_setkey(const struct ovsrec_bridge *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_bridge_col_other_config,
                                    datum);
}

/* Deletes an element of the "other_config" map column from the "Bridge" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_bridge_update_other_config_delkey(const struct ovsrec_bridge *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_bridge_col_other_config,
                                    datum);
}

/* Adds the value 'new_value' to the "ports" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_ports_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_port *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_ports,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ports" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_ports_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_port *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_ports,
                                    datum);
}

/* Adds the value 'new_value' to the "protocols" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_protocols_addvalue(const struct ovsrec_bridge *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_protocols,
                                    datum);
}

/* Deletes the value 'delete_value' from the "protocols" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_protocols_delvalue(const struct ovsrec_bridge *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_protocols,
                                    datum);
}

/* Sets an element of the "rstp_status" map column from the "Bridge" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_bridge_update_rstp_status_setkey(const struct ovsrec_bridge *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_bridge_col_rstp_status,
                                    datum);
}

/* Deletes an element of the "rstp_status" map column from the "Bridge" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_bridge_update_rstp_status_delkey(const struct ovsrec_bridge *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_bridge_col_rstp_status,
                                    datum);
}

/* Adds the value 'new_value' to the "sflow" set column from the "Bridge" table
 * in 'row'.
 *
 */
void
ovsrec_bridge_update_sflow_addvalue(const struct ovsrec_bridge *row, const struct ovsrec_sflow *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_bridge_col_sflow,
                                    datum);
}

/* Deletes the value 'delete_value' from the "sflow" set column from the
 * "Bridge" table in 'row'.
 *
 */
void
ovsrec_bridge_update_sflow_delvalue(const struct ovsrec_bridge *row, const struct ovsrec_sflow *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_bridge_col_sflow,
                                    datum);
}

/* Sets an element of the "status" map column from the "Bridge" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_bridge_update_status_setkey(const struct ovsrec_bridge *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_bridge_col_status,
                                    datum);
}

/* Deletes an element of the "status" map column from the "Bridge" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_bridge_update_status_delkey(const struct ovsrec_bridge *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_bridge_col_status,
                                    datum);
}

/* Sets the "auto_attach" column from the "Bridge" table in 'row' to
 * the 'auto_attach' set.
 *
 * If "auto_attach" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_auto_attach(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *auto_attach)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (auto_attach) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *auto_attach;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_auto_attach,
                          &datum);
}

/* Sets the "controller" column from the "Bridge" table in 'row' to
 * the 'controller' set with 'n_controller' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_controller(struct ovsdb_idl_condition *cond, enum ovsdb_function function, struct uuid **controller, size_t n_controller)
{
    struct ovsdb_datum datum;
    datum.n = n_controller;
    datum.keys = n_controller ? xmalloc(n_controller * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_controller; i++) {
        datum.keys[i].uuid = *controller[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_controller,
                          &datum);
    free(datum.keys);
}

/* Sets the "datapath_id" column from the "Bridge" table in 'row' to
 * the 'datapath_id' set.
 *
 * If "datapath_id" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_datapath_id(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *datapath_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (datapath_id) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, datapath_id);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_datapath_id,
                          &datum);
}

/* Sets the "datapath_type" column from the "Bridge" table in 'row' to
 * 'datapath_type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_datapath_type(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *datapath_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_type);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_datapath_type,
                          &datum);
}

/* Sets the "datapath_version" column from the "Bridge" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_datapath_version(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_datapath_version,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Bridge" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_bridge_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_bridge_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_bridge_col_external_ids.type);
}


/* Sets the "fail_mode" column from the "Bridge" table in 'row' to
 * the 'fail_mode' set.
 *
 * If "fail_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "secure" or "standalone"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_fail_mode(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *fail_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (fail_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, fail_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_fail_mode,
                          &datum);
}

/* Sets the "flood_vlans" column from the "Bridge" table in 'row' to
 * the 'flood_vlans' set with 'n_flood_vlans' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_flood_vlans(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *flood_vlans, size_t n_flood_vlans)
{
    struct ovsdb_datum datum;
    datum.n = n_flood_vlans;
    datum.keys = n_flood_vlans ? xmalloc(n_flood_vlans * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_flood_vlans; i++) {
        datum.keys[i].integer = flood_vlans[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_flood_vlans,
                          &datum);
    free(datum.keys);
}

/* Sets the "flow_tables" column from the "Bridge" table in 'row' to
 * the map with keys 'key_flow_tables' and values 'value_flow_tables'
 * with 'n_flow_tables' entries.
 *
 * Argument constraints: key in range 0 to 254
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_flow_tables(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *key_flow_tables, struct uuid **value_flow_tables, size_t n_flow_tables)
{
    struct ovsdb_datum datum;
    datum.n = n_flow_tables;
    datum.keys = n_flow_tables ? xmalloc(n_flow_tables * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_flow_tables * sizeof *datum.values);
    for (size_t i = 0; i < n_flow_tables; i++) {
        datum.keys[i].integer = key_flow_tables[i];
        datum.values[i].uuid = *value_flow_tables[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_UUID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_flow_tables,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Sets the "ipfix" column from the "Bridge" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_ipfix(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (ipfix) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *ipfix;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_ipfix,
                          &datum);
}

/* Sets the "mcast_snooping_enable" column from the "Bridge" table in 'row' to
 * 'mcast_snooping_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_mcast_snooping_enable(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool mcast_snooping_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = mcast_snooping_enable;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_mcast_snooping_enable,
                          &datum);
}

/* Sets the "mirrors" column from the "Bridge" table in 'row' to
 * the 'mirrors' set with 'n_mirrors' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_mirrors(struct ovsdb_idl_condition *cond, enum ovsdb_function function, struct uuid **mirrors, size_t n_mirrors)
{
    struct ovsdb_datum datum;
    datum.n = n_mirrors;
    datum.keys = n_mirrors ? xmalloc(n_mirrors * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_mirrors; i++) {
        datum.keys[i].uuid = *mirrors[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_mirrors,
                          &datum);
    free(datum.keys);
}

/* Sets the "name" column from the "Bridge" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_name(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_name,
                          &datum);
}

/* Sets the "netflow" column from the "Bridge" table in 'row' to
 * the 'netflow' set.
 *
 * If "netflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_netflow(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *netflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (netflow) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *netflow;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_netflow,
                          &datum);
}

/* Sets the "other_config" column's value from the "Bridge" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_bridge_add_clause_other_config(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_bridge_col_other_config,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_bridge_col_other_config.type);
}


/* Sets the "ports" column from the "Bridge" table in 'row' to
 * the 'ports' set with 'n_ports' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_ports(struct ovsdb_idl_condition *cond, enum ovsdb_function function, struct uuid **ports, size_t n_ports)
{
    struct ovsdb_datum datum;
    datum.n = n_ports;
    datum.keys = n_ports ? xmalloc(n_ports * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_ports; i++) {
        datum.keys[i].uuid = *ports[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_ports,
                          &datum);
    free(datum.keys);
}

/* Sets the "protocols" column from the "Bridge" table in 'row' to
 * the 'protocols' set with 'n_protocols' entries.
 *
 * Argument constraints: one of "OpenFlow10", "OpenFlow11", "OpenFlow12", "OpenFlow13", "OpenFlow14", or "OpenFlow15"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_protocols(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **protocols, size_t n_protocols)
{
    struct ovsdb_datum datum;
    datum.n = n_protocols;
    datum.keys = n_protocols ? xmalloc(n_protocols * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_protocols; i++) {
        datum.keys[i].string = CONST_CAST(char *, protocols[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_protocols,
                          &datum);
    free(datum.keys);
}

/* Sets the "rstp_enable" column from the "Bridge" table in 'row' to
 * 'rstp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_rstp_enable(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool rstp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = rstp_enable;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_rstp_enable,
                          &datum);
}

/* Sets the "rstp_status" column's value from the "Bridge" table in 'row'
 * to 'rstp_status'.
 *
 * The caller retains ownership of 'rstp_status' and everything in it. */
void
ovsrec_bridge_add_clause_rstp_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *rstp_status)
{
    struct ovsdb_datum datum;

    if (rstp_status) {
        ovsdb_datum_from_smap(&datum, rstp_status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_bridge_col_rstp_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_bridge_col_rstp_status.type);
}


/* Sets the "sflow" column from the "Bridge" table in 'row' to
 * the 'sflow' set.
 *
 * If "sflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_sflow(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *sflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (sflow) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *sflow;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_sflow,
                          &datum);
}

/* Sets the "status" column's value from the "Bridge" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_bridge_add_clause_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_bridge_col_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_bridge_col_status.type);
}


/* Sets the "stp_enable" column from the "Bridge" table in 'row' to
 * 'stp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_add_clause_stp_enable(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool stp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = stp_enable;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_bridge_col_stp_enable,
                          &datum);
}

/* Destroy 'row' of kind "Bridge". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_bridge_index_destroy_row(const struct ovsrec_bridge *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Bridge". */
struct ovsrec_bridge *
ovsrec_bridge_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_bridge);
    return ALIGNED_CAST(struct ovsrec_bridge *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_bridge *
ovsrec_bridge_index_find(struct ovsdb_idl_index *index, const struct ovsrec_bridge *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_bridge);
    return ovsrec_bridge_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_bridge_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_bridge *a, 
    const struct ovsrec_bridge *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_bridge_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_bridge);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_bridge_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_bridge *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_bridge);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_bridge_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_bridge *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_bridge);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_bridge *
ovsrec_bridge_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_bridge_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "auto_attach" column from the "Bridge" table in 'row' to
 * the 'auto_attach' set.
 *
 * If "auto_attach" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_auto_attach(const struct ovsrec_bridge *row, const struct ovsrec_autoattach *auto_attach)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (auto_attach) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = auto_attach->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_AUTO_ATTACH ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "controller" column from the "Bridge" table in 'row' to
 * the 'controller' set with 'n_controller' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_controller(const struct ovsrec_bridge *row, struct ovsrec_controller **controller, size_t n_controller)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_controller;
    datum.keys = n_controller ? xmalloc(n_controller * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_controller; i++) {
        datum.keys[i].uuid = controller[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_CONTROLLER ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "datapath_id" column from the "Bridge" table in 'row' to
 * the 'datapath_id' set.
 *
 * If "datapath_id" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_datapath_id(const struct ovsrec_bridge *row, const char *datapath_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (datapath_id) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, datapath_id);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_DATAPATH_ID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "datapath_type" column from the "Bridge" table in 'row' to
 * 'datapath_type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_datapath_type(const struct ovsrec_bridge *row, const char *datapath_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, datapath_type);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_DATAPATH_TYPE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "datapath_version" column from the "Bridge" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_datapath_version(const struct ovsrec_bridge *row, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_DATAPATH_VERSION ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "external_ids" column's value from the "Bridge" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_bridge_index_set_external_ids(const struct ovsrec_bridge *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_bridge_columns[OVSREC_BRIDGE_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
    free(datum);
}


/* Sets the "fail_mode" column from the "Bridge" table in 'row' to
 * the 'fail_mode' set.
 *
 * If "fail_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "secure" or "standalone"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_fail_mode(const struct ovsrec_bridge *row, const char *fail_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (fail_mode) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, fail_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_FAIL_MODE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "flood_vlans" column from the "Bridge" table in 'row' to
 * the 'flood_vlans' set with 'n_flood_vlans' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_flood_vlans(const struct ovsrec_bridge *row, const int64_t *flood_vlans, size_t n_flood_vlans)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_flood_vlans;
    datum.keys = n_flood_vlans ? xmalloc(n_flood_vlans * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_flood_vlans; i++) {
        datum.keys[i].integer = flood_vlans[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_FLOOD_VLANS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "flow_tables" column from the "Bridge" table in 'row' to
 * the map with keys 'key_flow_tables' and values 'value_flow_tables'
 * with 'n_flow_tables' entries.
 *
 * Argument constraints: key in range 0 to 254
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_flow_tables(const struct ovsrec_bridge *row, const int64_t *key_flow_tables, struct ovsrec_flow_table **value_flow_tables, size_t n_flow_tables)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_flow_tables;
    datum.keys = n_flow_tables ? xmalloc(n_flow_tables * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_flow_tables * sizeof *datum.values);
    for (i = 0; i < n_flow_tables; i++) {
        datum.keys[i].integer = key_flow_tables[i];
        datum.values[i].uuid = value_flow_tables[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_UUID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_FLOW_TABLES ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "ipfix" column from the "Bridge" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_ipfix(const struct ovsrec_bridge *row, const struct ovsrec_ipfix *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (ipfix) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = ipfix->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_IPFIX ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "mcast_snooping_enable" column from the "Bridge" table in 'row' to
 * 'mcast_snooping_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_mcast_snooping_enable(const struct ovsrec_bridge *row, bool mcast_snooping_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = mcast_snooping_enable;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_MCAST_SNOOPING_ENABLE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "mirrors" column from the "Bridge" table in 'row' to
 * the 'mirrors' set with 'n_mirrors' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_mirrors(const struct ovsrec_bridge *row, struct ovsrec_mirror **mirrors, size_t n_mirrors)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_mirrors;
    datum.keys = n_mirrors ? xmalloc(n_mirrors * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_mirrors; i++) {
        datum.keys[i].uuid = mirrors[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_MIRRORS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "name" column from the "Bridge" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_name(const struct ovsrec_bridge *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_NAME ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "netflow" column from the "Bridge" table in 'row' to
 * the 'netflow' set.
 *
 * If "netflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_netflow(const struct ovsrec_bridge *row, const struct ovsrec_netflow *netflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (netflow) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = netflow->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_NETFLOW ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "other_config" column's value from the "Bridge" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_bridge_index_set_other_config(const struct ovsrec_bridge *row, const struct smap *other_config)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (other_config) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(other_config);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, other_config) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_bridge_columns[OVSREC_BRIDGE_COL_OTHER_CONFIG],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
    free(datum);
}


/* Sets the "ports" column from the "Bridge" table in 'row' to
 * the 'ports' set with 'n_ports' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_ports(const struct ovsrec_bridge *row, struct ovsrec_port **ports, size_t n_ports)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_ports;
    datum.keys = n_ports ? xmalloc(n_ports * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_ports; i++) {
        datum.keys[i].uuid = ports[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_PORTS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "protocols" column from the "Bridge" table in 'row' to
 * the 'protocols' set with 'n_protocols' entries.
 *
 * Argument constraints: one of "OpenFlow10", "OpenFlow11", "OpenFlow12", "OpenFlow13", "OpenFlow14", or "OpenFlow15"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_protocols(const struct ovsrec_bridge *row, const char **protocols, size_t n_protocols)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_protocols;
    datum.keys = n_protocols ? xmalloc(n_protocols * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_protocols; i++) {
        datum.keys[i].string = xstrdup(protocols[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_PROTOCOLS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "rstp_enable" column from the "Bridge" table in 'row' to
 * 'rstp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_rstp_enable(const struct ovsrec_bridge *row, bool rstp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = rstp_enable;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_RSTP_ENABLE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "rstp_status" column's value from the "Bridge" table in 'row'
 * to 'rstp_status'.
 *
 * The caller retains ownership of 'rstp_status' and everything in it. */
void
ovsrec_bridge_index_set_rstp_status(const struct ovsrec_bridge *row, const struct smap *rstp_status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (rstp_status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(rstp_status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, rstp_status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_bridge_columns[OVSREC_BRIDGE_COL_RSTP_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
    free(datum);
}


/* Sets the "sflow" column from the "Bridge" table in 'row' to
 * the 'sflow' set.
 *
 * If "sflow" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_sflow(const struct ovsrec_bridge *row, const struct ovsrec_sflow *sflow)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (sflow) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = sflow->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_SFLOW ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

/* Sets the "status" column's value from the "Bridge" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_bridge_index_set_status(const struct ovsrec_bridge *row, const struct smap *status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_bridge_columns[OVSREC_BRIDGE_COL_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
    free(datum);
}


/* Sets the "stp_enable" column from the "Bridge" table in 'row' to
 * 'stp_enable'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_bridge_index_set_stp_enable(const struct ovsrec_bridge *row, bool stp_enable)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = stp_enable;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_bridge_columns[ OVSREC_BRIDGE_COL_STP_ENABLE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_BRIDGE]);
}

struct ovsdb_idl_column ovsrec_bridge_columns[OVSREC_BRIDGE_N_COLUMNS];

unsigned int
ovsrec_bridge_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_bridge, condition);
}
static union ovsdb_atom Bridge_col_fail_mode_key_enum_keys[2] = {
    { .string = "secure" },
    { .string = "standalone" },
};
static struct ovsdb_datum Bridge_col_fail_mode_key_enum = {
    .n = 2,
    .keys = Bridge_col_fail_mode_key_enum_keys,
};
static union ovsdb_atom Bridge_col_protocols_key_enum_keys[6] = {
    { .string = "OpenFlow10" },
    { .string = "OpenFlow11" },
    { .string = "OpenFlow12" },
    { .string = "OpenFlow13" },
    { .string = "OpenFlow14" },
    { .string = "OpenFlow15" },
};
static struct ovsdb_datum Bridge_col_protocols_key_enum = {
    .n = 6,
    .keys = Bridge_col_protocols_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_bridge_columns[OVSREC_BRIDGE_N_COLUMNS] = {
    [OVSREC_BRIDGE_COL_AUTO_ATTACH] = {
         .name = "auto_attach",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "AutoAttach", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_auto_attach,
         .unparse = ovsrec_bridge_unparse_auto_attach,
    },

    [OVSREC_BRIDGE_COL_CONTROLLER] = {
         .name = "controller",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Controller", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_controller,
         .unparse = ovsrec_bridge_unparse_controller,
    },

    [OVSREC_BRIDGE_COL_DATAPATH_ID] = {
         .name = "datapath_id",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_datapath_id,
         .unparse = ovsrec_bridge_unparse_datapath_id,
    },

    [OVSREC_BRIDGE_COL_DATAPATH_TYPE] = {
         .name = "datapath_type",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_datapath_type,
         .unparse = ovsrec_bridge_unparse_datapath_type,
    },

    [OVSREC_BRIDGE_COL_DATAPATH_VERSION] = {
         .name = "datapath_version",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_datapath_version,
         .unparse = ovsrec_bridge_unparse_datapath_version,
    },

    [OVSREC_BRIDGE_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_external_ids,
         .unparse = ovsrec_bridge_unparse_external_ids,
    },

    [OVSREC_BRIDGE_COL_FAIL_MODE] = {
         .name = "fail_mode",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Bridge_col_fail_mode_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_fail_mode,
         .unparse = ovsrec_bridge_unparse_fail_mode,
    },

    [OVSREC_BRIDGE_COL_FLOOD_VLANS] = {
         .name = "flood_vlans",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4095) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 4096,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_flood_vlans,
         .unparse = ovsrec_bridge_unparse_flood_vlans,
    },

    [OVSREC_BRIDGE_COL_FLOW_TABLES] = {
         .name = "flow_tables",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(254) },
            },
            .value = {
                .type = OVSDB_TYPE_UUID,
                .uuid = { .refTableName = "Flow_Table", .refType = OVSDB_REF_STRONG },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_flow_tables,
         .unparse = ovsrec_bridge_unparse_flow_tables,
    },

    [OVSREC_BRIDGE_COL_IPFIX] = {
         .name = "ipfix",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "IPFIX", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_ipfix,
         .unparse = ovsrec_bridge_unparse_ipfix,
    },

    [OVSREC_BRIDGE_COL_MCAST_SNOOPING_ENABLE] = {
         .name = "mcast_snooping_enable",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_mcast_snooping_enable,
         .unparse = ovsrec_bridge_unparse_mcast_snooping_enable,
    },

    [OVSREC_BRIDGE_COL_MIRRORS] = {
         .name = "mirrors",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Mirror", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_mirrors,
         .unparse = ovsrec_bridge_unparse_mirrors,
    },

    [OVSREC_BRIDGE_COL_NAME] = {
         .name = "name",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = false,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_name,
         .unparse = ovsrec_bridge_unparse_name,
    },

    [OVSREC_BRIDGE_COL_NETFLOW] = {
         .name = "netflow",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "NetFlow", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_netflow,
         .unparse = ovsrec_bridge_unparse_netflow,
    },

    [OVSREC_BRIDGE_COL_OTHER_CONFIG] = {
         .name = "other_config",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_other_config,
         .unparse = ovsrec_bridge_unparse_other_config,
    },

    [OVSREC_BRIDGE_COL_PORTS] = {
         .name = "ports",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Port", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_ports,
         .unparse = ovsrec_bridge_unparse_ports,
    },

    [OVSREC_BRIDGE_COL_PROTOCOLS] = {
         .name = "protocols",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Bridge_col_protocols_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_protocols,
         .unparse = ovsrec_bridge_unparse_protocols,
    },

    [OVSREC_BRIDGE_COL_RSTP_ENABLE] = {
         .name = "rstp_enable",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_rstp_enable,
         .unparse = ovsrec_bridge_unparse_rstp_enable,
    },

    [OVSREC_BRIDGE_COL_RSTP_STATUS] = {
         .name = "rstp_status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_rstp_status,
         .unparse = ovsrec_bridge_unparse_rstp_status,
    },

    [OVSREC_BRIDGE_COL_SFLOW] = {
         .name = "sflow",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "sFlow", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_sflow,
         .unparse = ovsrec_bridge_unparse_sflow,
    },

    [OVSREC_BRIDGE_COL_STATUS] = {
         .name = "status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_status,
         .unparse = ovsrec_bridge_unparse_status,
    },

    [OVSREC_BRIDGE_COL_STP_ENABLE] = {
         .name = "stp_enable",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_bridge_parse_stp_enable,
         .unparse = ovsrec_bridge_unparse_stp_enable,
    },

};

/* CT_Timeout_Policy table. */

const struct ovsrec_ct_timeout_policy_table *
ovsrec_ct_timeout_policy_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_ct_timeout_policy_table *) idl;
}

const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_table_first(const struct ovsrec_ct_timeout_policy_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ct_timeout_policy_first(idl);
}


const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_table_track_get_first(const struct ovsrec_ct_timeout_policy_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_ct_timeout_policy_track_get_first(idl);
}


static void
ovsrec_ct_timeout_policy_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ct_timeout_policy *row = ovsrec_ct_timeout_policy_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_ct_timeout_policy_parse_timeouts(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ct_timeout_policy *row = ovsrec_ct_timeout_policy_cast(row_);
    row->key_timeouts = NULL;
    row->value_timeouts = NULL;
    row->n_timeouts = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_timeouts) {
            row->key_timeouts = xmalloc(datum->n * sizeof *row->key_timeouts);
            row->value_timeouts = xmalloc(datum->n * sizeof *row->value_timeouts);
        }
        row->key_timeouts[row->n_timeouts] = datum->keys[i].string;
        row->value_timeouts[row->n_timeouts] = datum->values[i].integer;
        row->n_timeouts++;
    }
}

static void
ovsrec_ct_timeout_policy_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ct_timeout_policy *row = ovsrec_ct_timeout_policy_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_ct_timeout_policy_unparse_timeouts(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ct_timeout_policy *row = ovsrec_ct_timeout_policy_cast(row_);
    free(row->key_timeouts);
    free(row->value_timeouts);
}

static void
ovsrec_ct_timeout_policy_init__(struct ovsdb_idl_row *row)
{
    ovsrec_ct_timeout_policy_init(ovsrec_ct_timeout_policy_cast(row));
}

/* Clears the contents of 'row' in table "CT_Timeout_Policy". */
void
ovsrec_ct_timeout_policy_init(struct ovsrec_ct_timeout_policy *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
}

/* Searches table "CT_Timeout_Policy" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_ct_timeout_policy, uuid));
}

/* Searches table "CT_Timeout_Policy" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_table_get_for_uuid(const struct ovsrec_ct_timeout_policy_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ct_timeout_policy_get_for_uuid(idl, uuid);
}

/* Returns a row in table "CT_Timeout_Policy" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_first_row(idl, &ovsrec_table_ct_timeout_policy));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_next(const struct ovsrec_ct_timeout_policy *row)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_ct_timeout_policy_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_ct_timeout_policy);
}

unsigned int ovsrec_ct_timeout_policy_row_get_seqno(const struct ovsrec_ct_timeout_policy *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_ct_timeout_policy));
}

const struct ovsrec_ct_timeout_policy
*ovsrec_ct_timeout_policy_track_get_next(const struct ovsrec_ct_timeout_policy *row)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "CT_Timeout_Policy".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_timeout_policy_delete(const struct ovsrec_ct_timeout_policy *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "CT_Timeout_Policy" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_ct_timeout_policy, NULL));
}

bool
ovsrec_ct_timeout_policy_is_updated(const struct ovsrec_ct_timeout_policy *row, enum ovsrec_ct_timeout_policy_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_ct_timeout_policy_columns[column]);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ct_timeout_policy_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_ct_timeout_policy_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ct_timeout_policy_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_timeout_policy_verify_external_ids(const struct ovsrec_ct_timeout_policy *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ct_timeout_policy_col_external_ids);
}

/* Causes the original contents of column "timeouts" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "timeouts" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "timeouts" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "timeouts" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ct_timeout_policy_insert()).
 *
 *   - If "timeouts" has already been modified (with
 *     ovsrec_ct_timeout_policy_set_timeouts()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ct_timeout_policy_set_timeouts() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_timeout_policy_verify_timeouts(const struct ovsrec_ct_timeout_policy *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ct_timeout_policy_col_timeouts);
}

/* Returns the "external_ids" column's value from the "CT_Timeout_Policy" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_ct_timeout_policy. */
const struct ovsdb_datum *
ovsrec_ct_timeout_policy_get_external_ids(const struct ovsrec_ct_timeout_policy *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_ct_timeout_policy_col_external_ids);
}

/* Returns the "timeouts" column's value from the "CT_Timeout_Policy" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes timeouts's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "timeouts" member in ovsrec_ct_timeout_policy. */
const struct ovsdb_datum *
ovsrec_ct_timeout_policy_get_timeouts(const struct ovsrec_ct_timeout_policy *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ct_timeout_policy_col_timeouts);
}

/* Sets the "external_ids" column's value from the "CT_Timeout_Policy" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_timeout_policy_set_external_ids(const struct ovsrec_ct_timeout_policy *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_ct_timeout_policy_col_external_ids,
                        &datum);
}


/* Sets the "timeouts" column from the "CT_Timeout_Policy" table in 'row' to
 * the map with keys 'key_timeouts' and values 'value_timeouts'
 * with 'n_timeouts' entries.
 *
 * Argument constraints: key one of "icmp_first", "icmp_reply", "tcp_close", "tcp_close_wait", "tcp_established", "tcp_fin_wait", "tcp_last_ack", "tcp_retransmit", "tcp_syn_recv", "tcp_syn_sent", "tcp_syn_sent2", "tcp_time_wait", "tcp_unack", "udp_first", "udp_multiple", or "udp_single", value in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_timeout_policy_set_timeouts(const struct ovsrec_ct_timeout_policy *row, const char **key_timeouts, const int64_t *value_timeouts, size_t n_timeouts)
{
    struct ovsdb_datum datum;

    datum.n = n_timeouts;
    datum.keys = n_timeouts ? xmalloc(n_timeouts * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_timeouts * sizeof *datum.values);
    for (size_t i = 0; i < n_timeouts; i++) {
        datum.keys[i].string = xstrdup(key_timeouts[i]);
        datum.values[i].integer = value_timeouts[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_ct_timeout_policy_col_timeouts, &datum);
}

/* Sets an element of the "external_ids" map column from the "CT_Timeout_Policy" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_ct_timeout_policy_update_external_ids_setkey(const struct ovsrec_ct_timeout_policy *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_ct_timeout_policy_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "CT_Timeout_Policy" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_ct_timeout_policy_update_external_ids_delkey(const struct ovsrec_ct_timeout_policy *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_ct_timeout_policy_col_external_ids,
                                    datum);
}

/* Sets an element of the "timeouts" map column from the "CT_Timeout_Policy" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_ct_timeout_policy_update_timeouts_setkey(const struct ovsrec_ct_timeout_policy *row, const char *new_key, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].integer = new_value;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_ct_timeout_policy_col_timeouts,
                                    datum);
}

/* Deletes an element of the "timeouts" map column from the "CT_Timeout_Policy" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_ct_timeout_policy_update_timeouts_delkey(const struct ovsrec_ct_timeout_policy *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_ct_timeout_policy_col_timeouts,
                                    datum);
}

/* Sets the "external_ids" column's value from the "CT_Timeout_Policy" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_timeout_policy_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_ct_timeout_policy_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_ct_timeout_policy_col_external_ids.type);
}


/* Sets the "timeouts" column from the "CT_Timeout_Policy" table in 'row' to
 * the map with keys 'key_timeouts' and values 'value_timeouts'
 * with 'n_timeouts' entries.
 *
 * Argument constraints: key one of "icmp_first", "icmp_reply", "tcp_close", "tcp_close_wait", "tcp_established", "tcp_fin_wait", "tcp_last_ack", "tcp_retransmit", "tcp_syn_recv", "tcp_syn_sent", "tcp_syn_sent2", "tcp_time_wait", "tcp_unack", "udp_first", "udp_multiple", or "udp_single", value in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_timeout_policy_add_clause_timeouts(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **key_timeouts, const int64_t *value_timeouts, size_t n_timeouts)
{
    struct ovsdb_datum datum;
    datum.n = n_timeouts;
    datum.keys = n_timeouts ? xmalloc(n_timeouts * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_timeouts * sizeof *datum.values);
    for (size_t i = 0; i < n_timeouts; i++) {
        datum.keys[i].string = CONST_CAST(char *, key_timeouts[i]);
        datum.values[i].integer = value_timeouts[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ct_timeout_policy_col_timeouts,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Destroy 'row' of kind "CT_Timeout_Policy". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_ct_timeout_policy_index_destroy_row(const struct ovsrec_ct_timeout_policy *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "CT_Timeout_Policy". */
struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_timeout_policy);
    return ALIGNED_CAST(struct ovsrec_ct_timeout_policy *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_index_find(struct ovsdb_idl_index *index, const struct ovsrec_ct_timeout_policy *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_timeout_policy);
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_ct_timeout_policy_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_ct_timeout_policy *a, 
    const struct ovsrec_ct_timeout_policy *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_ct_timeout_policy_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_timeout_policy);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_ct_timeout_policy_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_ct_timeout_policy *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_timeout_policy);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_ct_timeout_policy_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_ct_timeout_policy *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_timeout_policy);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_ct_timeout_policy *
ovsrec_ct_timeout_policy_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_ct_timeout_policy_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "external_ids" column's value from the "CT_Timeout_Policy" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_timeout_policy_index_set_external_ids(const struct ovsrec_ct_timeout_policy *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_ct_timeout_policy_columns[OVSREC_CT_TIMEOUT_POLICY_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_CT_TIMEOUT_POLICY]);
    free(datum);
}


/* Sets the "timeouts" column from the "CT_Timeout_Policy" table in 'row' to
 * the map with keys 'key_timeouts' and values 'value_timeouts'
 * with 'n_timeouts' entries.
 *
 * Argument constraints: key one of "icmp_first", "icmp_reply", "tcp_close", "tcp_close_wait", "tcp_established", "tcp_fin_wait", "tcp_last_ack", "tcp_retransmit", "tcp_syn_recv", "tcp_syn_sent", "tcp_syn_sent2", "tcp_time_wait", "tcp_unack", "udp_first", "udp_multiple", or "udp_single", value in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_timeout_policy_index_set_timeouts(const struct ovsrec_ct_timeout_policy *row, const char **key_timeouts, const int64_t *value_timeouts, size_t n_timeouts)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_timeouts;
    datum.keys = n_timeouts ? xmalloc(n_timeouts * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_timeouts * sizeof *datum.values);
    for (i = 0; i < n_timeouts; i++) {
        datum.keys[i].string = xstrdup(key_timeouts[i]);
        datum.values[i].integer = value_timeouts[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ct_timeout_policy_columns[ OVSREC_CT_TIMEOUT_POLICY_COL_TIMEOUTS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CT_TIMEOUT_POLICY]);
}

struct ovsdb_idl_column ovsrec_ct_timeout_policy_columns[OVSREC_CT_TIMEOUT_POLICY_N_COLUMNS];

unsigned int
ovsrec_ct_timeout_policy_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_ct_timeout_policy, condition);
}
static union ovsdb_atom CT_Timeout_Policy_col_timeouts_key_enum_keys[16] = {
    { .string = "icmp_first" },
    { .string = "icmp_reply" },
    { .string = "tcp_close" },
    { .string = "tcp_close_wait" },
    { .string = "tcp_established" },
    { .string = "tcp_fin_wait" },
    { .string = "tcp_last_ack" },
    { .string = "tcp_retransmit" },
    { .string = "tcp_syn_recv" },
    { .string = "tcp_syn_sent" },
    { .string = "tcp_syn_sent2" },
    { .string = "tcp_time_wait" },
    { .string = "tcp_unack" },
    { .string = "udp_first" },
    { .string = "udp_multiple" },
    { .string = "udp_single" },
};
static struct ovsdb_datum CT_Timeout_Policy_col_timeouts_key_enum = {
    .n = 16,
    .keys = CT_Timeout_Policy_col_timeouts_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_ct_timeout_policy_columns[OVSREC_CT_TIMEOUT_POLICY_N_COLUMNS] = {
    [OVSREC_CT_TIMEOUT_POLICY_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ct_timeout_policy_parse_external_ids,
         .unparse = ovsrec_ct_timeout_policy_unparse_external_ids,
    },

    [OVSREC_CT_TIMEOUT_POLICY_COL_TIMEOUTS] = {
         .name = "timeouts",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &CT_Timeout_Policy_col_timeouts_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_INTEGER,
                .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ct_timeout_policy_parse_timeouts,
         .unparse = ovsrec_ct_timeout_policy_unparse_timeouts,
    },

};

/* CT_Zone table. */

const struct ovsrec_ct_zone_table *
ovsrec_ct_zone_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_ct_zone_table *) idl;
}

const struct ovsrec_ct_zone *
ovsrec_ct_zone_table_first(const struct ovsrec_ct_zone_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ct_zone_first(idl);
}


const struct ovsrec_ct_zone *
ovsrec_ct_zone_table_track_get_first(const struct ovsrec_ct_zone_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_ct_zone_track_get_first(idl);
}


static void
ovsrec_ct_zone_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ct_zone *row = ovsrec_ct_zone_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_ct_zone_parse_timeout_policy(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ct_zone *row = ovsrec_ct_zone_cast(row_);

    if (datum->n >= 1) {
        row->timeout_policy = ovsrec_ct_timeout_policy_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_ct_timeout_policy, &datum->keys[0].uuid));
    } else {
        row->timeout_policy = NULL;
    }
}

static void
ovsrec_ct_zone_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ct_zone *row = ovsrec_ct_zone_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_ct_zone_unparse_timeout_policy(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_ct_zone_init__(struct ovsdb_idl_row *row)
{
    ovsrec_ct_zone_init(ovsrec_ct_zone_cast(row));
}

/* Clears the contents of 'row' in table "CT_Zone". */
void
ovsrec_ct_zone_init(struct ovsrec_ct_zone *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
}

/* Searches table "CT_Zone" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ct_zone *
ovsrec_ct_zone_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_ct_zone, uuid));
}

/* Searches table "CT_Zone" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ct_zone *
ovsrec_ct_zone_table_get_for_uuid(const struct ovsrec_ct_zone_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ct_zone_get_for_uuid(idl, uuid);
}

/* Returns a row in table "CT_Zone" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_ct_zone *
ovsrec_ct_zone_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_first_row(idl, &ovsrec_table_ct_zone));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_ct_zone *
ovsrec_ct_zone_next(const struct ovsrec_ct_zone *row)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_ct_zone_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_ct_zone);
}

unsigned int ovsrec_ct_zone_row_get_seqno(const struct ovsrec_ct_zone *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_ct_zone *
ovsrec_ct_zone_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_ct_zone));
}

const struct ovsrec_ct_zone
*ovsrec_ct_zone_track_get_next(const struct ovsrec_ct_zone *row)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "CT_Zone".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_zone_delete(const struct ovsrec_ct_zone *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "CT_Zone" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_ct_zone *
ovsrec_ct_zone_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_ct_zone, NULL));
}

bool
ovsrec_ct_zone_is_updated(const struct ovsrec_ct_zone *row, enum ovsrec_ct_zone_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_ct_zone_columns[column]);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ct_zone_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_ct_zone_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ct_zone_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_zone_verify_external_ids(const struct ovsrec_ct_zone *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ct_zone_col_external_ids);
}

/* Causes the original contents of column "timeout_policy" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "timeout_policy" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "timeout_policy" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "timeout_policy" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ct_zone_insert()).
 *
 *   - If "timeout_policy" has already been modified (with
 *     ovsrec_ct_zone_set_timeout_policy()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ct_zone_set_timeout_policy() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ct_zone_verify_timeout_policy(const struct ovsrec_ct_zone *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ct_zone_col_timeout_policy);
}

/* Returns the "external_ids" column's value from the "CT_Zone" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_ct_zone. */
const struct ovsdb_datum *
ovsrec_ct_zone_get_external_ids(const struct ovsrec_ct_zone *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_ct_zone_col_external_ids);
}

/* Returns the "timeout_policy" column's value from the "CT_Zone" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes timeout_policy's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "timeout_policy" member in ovsrec_ct_zone. */
const struct ovsdb_datum *
ovsrec_ct_zone_get_timeout_policy(const struct ovsrec_ct_zone *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_ct_zone_col_timeout_policy);
}

/* Sets the "external_ids" column's value from the "CT_Zone" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_zone_set_external_ids(const struct ovsrec_ct_zone *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_ct_zone_col_external_ids,
                        &datum);
}


/* Sets the "timeout_policy" column from the "CT_Zone" table in 'row' to
 * the 'timeout_policy' set.
 *
 * If "timeout_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_zone_set_timeout_policy(const struct ovsrec_ct_zone *row, const struct ovsrec_ct_timeout_policy *timeout_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (timeout_policy) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = timeout_policy->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ct_zone_col_timeout_policy, &datum);
}

/* Sets an element of the "external_ids" map column from the "CT_Zone" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_ct_zone_update_external_ids_setkey(const struct ovsrec_ct_zone *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_ct_zone_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "CT_Zone" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_ct_zone_update_external_ids_delkey(const struct ovsrec_ct_zone *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_ct_zone_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "timeout_policy" set column from the "CT_Zone" table
 * in 'row'.
 *
 */
void
ovsrec_ct_zone_update_timeout_policy_addvalue(const struct ovsrec_ct_zone *row, const struct ovsrec_ct_timeout_policy *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ct_zone_col_timeout_policy,
                                    datum);
}

/* Deletes the value 'delete_value' from the "timeout_policy" set column from the
 * "CT_Zone" table in 'row'.
 *
 */
void
ovsrec_ct_zone_update_timeout_policy_delvalue(const struct ovsrec_ct_zone *row, const struct ovsrec_ct_timeout_policy *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ct_zone_col_timeout_policy,
                                    datum);
}

/* Sets the "external_ids" column's value from the "CT_Zone" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_zone_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_ct_zone_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_ct_zone_col_external_ids.type);
}


/* Sets the "timeout_policy" column from the "CT_Zone" table in 'row' to
 * the 'timeout_policy' set.
 *
 * If "timeout_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_zone_add_clause_timeout_policy(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *timeout_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (timeout_policy) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *timeout_policy;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ct_zone_col_timeout_policy,
                          &datum);
}

/* Destroy 'row' of kind "CT_Zone". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_ct_zone_index_destroy_row(const struct ovsrec_ct_zone *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "CT_Zone". */
struct ovsrec_ct_zone *
ovsrec_ct_zone_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_zone);
    return ALIGNED_CAST(struct ovsrec_ct_zone *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_ct_zone *
ovsrec_ct_zone_index_find(struct ovsdb_idl_index *index, const struct ovsrec_ct_zone *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_zone);
    return ovsrec_ct_zone_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_ct_zone_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_ct_zone *a, 
    const struct ovsrec_ct_zone *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_ct_zone_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_zone);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_ct_zone_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_ct_zone *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_zone);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_ct_zone_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_ct_zone *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ct_zone);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_ct_zone *
ovsrec_ct_zone_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_ct_zone_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "external_ids" column's value from the "CT_Zone" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ct_zone_index_set_external_ids(const struct ovsrec_ct_zone *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_ct_zone_columns[OVSREC_CT_ZONE_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_CT_ZONE]);
    free(datum);
}


/* Sets the "timeout_policy" column from the "CT_Zone" table in 'row' to
 * the 'timeout_policy' set.
 *
 * If "timeout_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ct_zone_index_set_timeout_policy(const struct ovsrec_ct_zone *row, const struct ovsrec_ct_timeout_policy *timeout_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (timeout_policy) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = timeout_policy->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ct_zone_columns[ OVSREC_CT_ZONE_COL_TIMEOUT_POLICY ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CT_ZONE]);
}

struct ovsdb_idl_column ovsrec_ct_zone_columns[OVSREC_CT_ZONE_N_COLUMNS];

unsigned int
ovsrec_ct_zone_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_ct_zone, condition);
}

struct ovsdb_idl_column ovsrec_ct_zone_columns[OVSREC_CT_ZONE_N_COLUMNS] = {
    [OVSREC_CT_ZONE_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ct_zone_parse_external_ids,
         .unparse = ovsrec_ct_zone_unparse_external_ids,
    },

    [OVSREC_CT_ZONE_COL_TIMEOUT_POLICY] = {
         .name = "timeout_policy",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "CT_Timeout_Policy", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ct_zone_parse_timeout_policy,
         .unparse = ovsrec_ct_zone_unparse_timeout_policy,
    },

};

/* Controller table. */

const struct ovsrec_controller_table *
ovsrec_controller_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_controller_table *) idl;
}

const struct ovsrec_controller *
ovsrec_controller_table_first(const struct ovsrec_controller_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_controller_first(idl);
}


const struct ovsrec_controller *
ovsrec_controller_table_track_get_first(const struct ovsrec_controller_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_controller_track_get_first(idl);
}


static void
ovsrec_controller_parse_connection_mode(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->connection_mode = datum->keys[0].string;
    } else {
        row->connection_mode = NULL;
    }
}

static void
ovsrec_controller_parse_controller_burst_limit(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->controller_burst_limit = NULL;
    row->n_controller_burst_limit = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_controller_burst_limit) {
            row->controller_burst_limit = xmalloc(n * sizeof *row->controller_burst_limit);
        }
        row->controller_burst_limit[row->n_controller_burst_limit] = datum->keys[i].integer;
        row->n_controller_burst_limit++;
    }
}

static void
ovsrec_controller_parse_controller_queue_size(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->controller_queue_size = NULL;
    row->n_controller_queue_size = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_controller_queue_size) {
            row->controller_queue_size = xmalloc(n * sizeof *row->controller_queue_size);
        }
        row->controller_queue_size[row->n_controller_queue_size] = datum->keys[i].integer;
        row->n_controller_queue_size++;
    }
}

static void
ovsrec_controller_parse_controller_rate_limit(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->controller_rate_limit = NULL;
    row->n_controller_rate_limit = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_controller_rate_limit) {
            row->controller_rate_limit = xmalloc(n * sizeof *row->controller_rate_limit);
        }
        row->controller_rate_limit[row->n_controller_rate_limit] = datum->keys[i].integer;
        row->n_controller_rate_limit++;
    }
}

static void
ovsrec_controller_parse_enable_async_messages(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->enable_async_messages = NULL;
    row->n_enable_async_messages = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_enable_async_messages) {
            row->enable_async_messages = xmalloc(n * sizeof *row->enable_async_messages);
        }
        row->enable_async_messages[row->n_enable_async_messages] = datum->keys[i].boolean;
        row->n_enable_async_messages++;
    }
}

static void
ovsrec_controller_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_controller_parse_inactivity_probe(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->inactivity_probe = NULL;
    row->n_inactivity_probe = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_inactivity_probe) {
            row->inactivity_probe = xmalloc(n * sizeof *row->inactivity_probe);
        }
        row->inactivity_probe[row->n_inactivity_probe] = datum->keys[i].integer;
        row->n_inactivity_probe++;
    }
}

static void
ovsrec_controller_parse_is_connected(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->is_connected = datum->keys[0].boolean;
    } else {
        row->is_connected = false;
    }
}

static void
ovsrec_controller_parse_local_gateway(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->local_gateway = datum->keys[0].string;
    } else {
        row->local_gateway = NULL;
    }
}

static void
ovsrec_controller_parse_local_ip(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->local_ip = datum->keys[0].string;
    } else {
        row->local_ip = NULL;
    }
}

static void
ovsrec_controller_parse_local_netmask(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->local_netmask = datum->keys[0].string;
    } else {
        row->local_netmask = NULL;
    }
}

static void
ovsrec_controller_parse_max_backoff(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    size_t n = MIN(1, datum->n);
    row->max_backoff = NULL;
    row->n_max_backoff = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_max_backoff) {
            row->max_backoff = xmalloc(n * sizeof *row->max_backoff);
        }
        row->max_backoff[row->n_max_backoff] = datum->keys[i].integer;
        row->n_max_backoff++;
    }
}

static void
ovsrec_controller_parse_other_config(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_init(&row->other_config);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->other_config,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_controller_parse_role(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->role = datum->keys[0].string;
    } else {
        row->role = NULL;
    }
}

static void
ovsrec_controller_parse_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_init(&row->status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_controller_parse_target(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->target = datum->keys[0].string;
    } else {
        row->target = "";
    }
}

static void
ovsrec_controller_parse_type(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);

    if (datum->n >= 1) {
        row->type = datum->keys[0].string;
    } else {
        row->type = NULL;
    }
}

static void
ovsrec_controller_unparse_connection_mode(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_controller_burst_limit(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->controller_burst_limit);
}

static void
ovsrec_controller_unparse_controller_queue_size(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->controller_queue_size);
}

static void
ovsrec_controller_unparse_controller_rate_limit(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->controller_rate_limit);
}

static void
ovsrec_controller_unparse_enable_async_messages(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->enable_async_messages);
}

static void
ovsrec_controller_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_controller_unparse_inactivity_probe(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->inactivity_probe);
}

static void
ovsrec_controller_unparse_is_connected(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_local_gateway(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_local_ip(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_local_netmask(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_max_backoff(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    free(row->max_backoff);
}

static void
ovsrec_controller_unparse_other_config(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_destroy(&row->other_config);
}

static void
ovsrec_controller_unparse_role(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_controller *row = ovsrec_controller_cast(row_);
    smap_destroy(&row->status);
}

static void
ovsrec_controller_unparse_target(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_unparse_type(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_controller_init__(struct ovsdb_idl_row *row)
{
    ovsrec_controller_init(ovsrec_controller_cast(row));
}

/* Clears the contents of 'row' in table "Controller". */
void
ovsrec_controller_init(struct ovsrec_controller *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
    smap_init(&row->other_config);
    smap_init(&row->status);
    row->target = "";
}

/* Searches table "Controller" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_controller *
ovsrec_controller_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_controller_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_controller, uuid));
}

/* Searches table "Controller" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_controller *
ovsrec_controller_table_get_for_uuid(const struct ovsrec_controller_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_controller_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Controller" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_controller *
ovsrec_controller_first(const struct ovsdb_idl *idl)
{
    return ovsrec_controller_cast(ovsdb_idl_first_row(idl, &ovsrec_table_controller));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_controller *
ovsrec_controller_next(const struct ovsrec_controller *row)
{
    return ovsrec_controller_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_controller_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_controller);
}

unsigned int ovsrec_controller_row_get_seqno(const struct ovsrec_controller *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_controller *
ovsrec_controller_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_controller_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_controller));
}

const struct ovsrec_controller
*ovsrec_controller_track_get_next(const struct ovsrec_controller *row)
{
    return ovsrec_controller_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Controller".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_delete(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Controller" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_controller *
ovsrec_controller_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_controller_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_controller, NULL));
}

bool
ovsrec_controller_is_updated(const struct ovsrec_controller *row, enum ovsrec_controller_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_controller_columns[column]);
}

/* Causes the original contents of column "connection_mode" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "connection_mode" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "connection_mode" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "connection_mode" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "connection_mode" has already been modified (with
 *     ovsrec_controller_set_connection_mode()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_connection_mode() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_connection_mode(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_connection_mode);
}

/* Causes the original contents of column "controller_burst_limit" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "controller_burst_limit" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "controller_burst_limit" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "controller_burst_limit" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "controller_burst_limit" has already been modified (with
 *     ovsrec_controller_set_controller_burst_limit()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_controller_burst_limit() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_controller_burst_limit(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_controller_burst_limit);
}

/* Causes the original contents of column "controller_queue_size" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "controller_queue_size" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "controller_queue_size" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "controller_queue_size" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "controller_queue_size" has already been modified (with
 *     ovsrec_controller_set_controller_queue_size()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_controller_queue_size() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_controller_queue_size(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_controller_queue_size);
}

/* Causes the original contents of column "controller_rate_limit" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "controller_rate_limit" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "controller_rate_limit" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "controller_rate_limit" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "controller_rate_limit" has already been modified (with
 *     ovsrec_controller_set_controller_rate_limit()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_controller_rate_limit() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_controller_rate_limit(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_controller_rate_limit);
}

/* Causes the original contents of column "enable_async_messages" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "enable_async_messages" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "enable_async_messages" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "enable_async_messages" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "enable_async_messages" has already been modified (with
 *     ovsrec_controller_set_enable_async_messages()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_enable_async_messages() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_enable_async_messages(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_enable_async_messages);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_controller_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_external_ids(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_external_ids);
}

/* Causes the original contents of column "inactivity_probe" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "inactivity_probe" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "inactivity_probe" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "inactivity_probe" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "inactivity_probe" has already been modified (with
 *     ovsrec_controller_set_inactivity_probe()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_inactivity_probe() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_inactivity_probe(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_inactivity_probe);
}

/* Causes the original contents of column "is_connected" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "is_connected" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "is_connected" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "is_connected" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "is_connected" has already been modified (with
 *     ovsrec_controller_set_is_connected()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_is_connected() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_is_connected(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_is_connected);
}

/* Causes the original contents of column "local_gateway" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "local_gateway" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "local_gateway" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "local_gateway" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "local_gateway" has already been modified (with
 *     ovsrec_controller_set_local_gateway()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_local_gateway() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_local_gateway(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_local_gateway);
}

/* Causes the original contents of column "local_ip" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "local_ip" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "local_ip" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "local_ip" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "local_ip" has already been modified (with
 *     ovsrec_controller_set_local_ip()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_local_ip() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_local_ip(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_local_ip);
}

/* Causes the original contents of column "local_netmask" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "local_netmask" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "local_netmask" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "local_netmask" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "local_netmask" has already been modified (with
 *     ovsrec_controller_set_local_netmask()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_local_netmask() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_local_netmask(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_local_netmask);
}

/* Causes the original contents of column "max_backoff" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "max_backoff" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "max_backoff" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "max_backoff" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "max_backoff" has already been modified (with
 *     ovsrec_controller_set_max_backoff()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_max_backoff() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_max_backoff(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_max_backoff);
}

/* Causes the original contents of column "other_config" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "other_config" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "other_config" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "other_config" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "other_config" has already been modified (with
 *     ovsrec_controller_set_other_config()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_other_config() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_other_config(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_other_config);
}

/* Causes the original contents of column "role" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "role" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "role" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "role" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "role" has already been modified (with
 *     ovsrec_controller_set_role()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_role() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_role(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_role);
}

/* Causes the original contents of column "status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "status" has already been modified (with
 *     ovsrec_controller_set_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_status(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_status);
}

/* Causes the original contents of column "target" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "target" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "target" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "target" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "target" has already been modified (with
 *     ovsrec_controller_set_target()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_target() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_target(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_target);
}

/* Causes the original contents of column "type" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "type" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "type" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "type" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_controller_insert()).
 *
 *   - If "type" has already been modified (with
 *     ovsrec_controller_set_type()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_controller_set_type() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_controller_verify_type(const struct ovsrec_controller *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_controller_col_type);
}

/* Returns the "connection_mode" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes connection_mode's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "connection_mode" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_connection_mode(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_connection_mode);
}

/* Returns the "controller_burst_limit" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes controller_burst_limit's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "controller_burst_limit" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_controller_burst_limit(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_controller_burst_limit);
}

/* Returns the "controller_queue_size" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes controller_queue_size's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "controller_queue_size" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_controller_queue_size(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_controller_queue_size);
}

/* Returns the "controller_rate_limit" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes controller_rate_limit's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "controller_rate_limit" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_controller_rate_limit(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_controller_rate_limit);
}

/* Returns the "enable_async_messages" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes enable_async_messages's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "enable_async_messages" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_enable_async_messages(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_enable_async_messages);
}

/* Returns the "external_ids" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_external_ids(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_external_ids);
}

/* Returns the "inactivity_probe" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes inactivity_probe's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "inactivity_probe" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_inactivity_probe(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_inactivity_probe);
}

/* Returns the "is_connected" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes is_connected's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "is_connected" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_is_connected(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_is_connected);
}

/* Returns the "local_gateway" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes local_gateway's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "local_gateway" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_local_gateway(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_local_gateway);
}

/* Returns the "local_ip" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes local_ip's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "local_ip" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_local_ip(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_local_ip);
}

/* Returns the "local_netmask" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes local_netmask's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "local_netmask" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_local_netmask(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_local_netmask);
}

/* Returns the "max_backoff" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes max_backoff's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "max_backoff" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_max_backoff(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_max_backoff);
}

/* Returns the "other_config" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes other_config's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "other_config" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_other_config(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_other_config);
}

/* Returns the "role" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes role's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "role" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_role(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_role);
}

/* Returns the "status" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "status" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_status(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_status);
}

/* Returns the "target" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes target's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "target" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_target(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_target);
}

/* Returns the "type" column's value from the "Controller" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes type's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "type" member in ovsrec_controller. */
const struct ovsdb_datum *
ovsrec_controller_get_type(const struct ovsrec_controller *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_controller_col_type);
}

/* Sets the "connection_mode" column from the "Controller" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_connection_mode(const struct ovsrec_controller *row, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (connection_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_connection_mode, &datum);
}

/* Sets the "controller_burst_limit" column from the "Controller" table in 'row' to
 * the 'controller_burst_limit' set with 'n_controller_burst_limit' entries.
 *
 * 'n_controller_burst_limit' may be 0 or 1; if it is 0, then 'controller_burst_limit'
 * may be NULL.
 *
 * Argument constraints: at least 25
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_controller_burst_limit(const struct ovsrec_controller *row, const int64_t *controller_burst_limit, size_t n_controller_burst_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_burst_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_burst_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_controller_burst_limit, &datum);
}

/* Sets the "controller_queue_size" column from the "Controller" table in 'row' to
 * the 'controller_queue_size' set with 'n_controller_queue_size' entries.
 *
 * 'n_controller_queue_size' may be 0 or 1; if it is 0, then 'controller_queue_size'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 512
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_controller_queue_size(const struct ovsrec_controller *row, const int64_t *controller_queue_size, size_t n_controller_queue_size)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_queue_size) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_queue_size;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_controller_queue_size, &datum);
}

/* Sets the "controller_rate_limit" column from the "Controller" table in 'row' to
 * the 'controller_rate_limit' set with 'n_controller_rate_limit' entries.
 *
 * 'n_controller_rate_limit' may be 0 or 1; if it is 0, then 'controller_rate_limit'
 * may be NULL.
 *
 * Argument constraints: at least 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_controller_rate_limit(const struct ovsrec_controller *row, const int64_t *controller_rate_limit, size_t n_controller_rate_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_rate_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_rate_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_controller_rate_limit, &datum);
}

/* Sets the "enable_async_messages" column from the "Controller" table in 'row' to
 * the 'enable_async_messages' set with 'n_enable_async_messages' entries.
 *
 * 'n_enable_async_messages' may be 0 or 1; if it is 0, then 'enable_async_messages'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_enable_async_messages(const struct ovsrec_controller *row, const bool *enable_async_messages, size_t n_enable_async_messages)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_enable_async_messages) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *enable_async_messages;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_enable_async_messages, &datum);
}

/* Sets the "external_ids" column's value from the "Controller" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_controller_set_external_ids(const struct ovsrec_controller *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_controller_col_external_ids,
                        &datum);
}


/* Sets the "inactivity_probe" column from the "Controller" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_inactivity_probe(const struct ovsrec_controller *row, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_inactivity_probe) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_inactivity_probe, &datum);
}

/* Sets the "is_connected" column from the "Controller" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_is_connected(const struct ovsrec_controller *row, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_is_connected, &datum);
}

/* Sets the "local_gateway" column from the "Controller" table in 'row' to
 * the 'local_gateway' set.
 *
 * If "local_gateway" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_local_gateway(const struct ovsrec_controller *row, const char *local_gateway)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_gateway) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_gateway);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_local_gateway, &datum);
}

/* Sets the "local_ip" column from the "Controller" table in 'row' to
 * the 'local_ip' set.
 *
 * If "local_ip" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_local_ip(const struct ovsrec_controller *row, const char *local_ip)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_ip) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_ip);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_local_ip, &datum);
}

/* Sets the "local_netmask" column from the "Controller" table in 'row' to
 * the 'local_netmask' set.
 *
 * If "local_netmask" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_local_netmask(const struct ovsrec_controller *row, const char *local_netmask)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_netmask) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_netmask);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_local_netmask, &datum);
}

/* Sets the "max_backoff" column from the "Controller" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_max_backoff(const struct ovsrec_controller *row, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_max_backoff) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_max_backoff, &datum);
}

/* Sets the "other_config" column's value from the "Controller" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_controller_set_other_config(const struct ovsrec_controller *row, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_controller_col_other_config,
                        &datum);
}


/* Sets the "role" column from the "Controller" table in 'row' to
 * the 'role' set.
 *
 * If "role" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: one of "master", "other", or "slave"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_role(const struct ovsrec_controller *row, const char *role)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (role) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, role);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_role, &datum);
}

/* Sets the "status" column's value from the "Controller" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_controller_set_status(const struct ovsrec_controller *row, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_controller_col_status,
                        &datum);
}


/* Sets the "target" column from the "Controller" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_target(const struct ovsrec_controller *row, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_target, &datum);
}

/* Sets the "type" column from the "Controller" table in 'row' to
 * the 'type' set.
 *
 * If "type" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "primary" or "service"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_set_type(const struct ovsrec_controller *row, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (type) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, type);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_controller_col_type, &datum);
}

/* Adds the value 'new_value' to the "connection_mode" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_connection_mode_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_connection_mode,
                                    datum);
}

/* Deletes the value 'delete_value' from the "connection_mode" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_connection_mode_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_connection_mode,
                                    datum);
}

/* Adds the value 'new_value' to the "controller_burst_limit" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_controller_burst_limit_addvalue(const struct ovsrec_controller *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_burst_limit,
                                    datum);
}

/* Deletes the value 'delete_value' from the "controller_burst_limit" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_controller_burst_limit_delvalue(const struct ovsrec_controller *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_burst_limit,
                                    datum);
}

/* Adds the value 'new_value' to the "controller_queue_size" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_controller_queue_size_addvalue(const struct ovsrec_controller *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_queue_size,
                                    datum);
}

/* Deletes the value 'delete_value' from the "controller_queue_size" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_controller_queue_size_delvalue(const struct ovsrec_controller *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_queue_size,
                                    datum);
}

/* Adds the value 'new_value' to the "controller_rate_limit" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_controller_rate_limit_addvalue(const struct ovsrec_controller *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_rate_limit,
                                    datum);
}

/* Deletes the value 'delete_value' from the "controller_rate_limit" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_controller_rate_limit_delvalue(const struct ovsrec_controller *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_controller_rate_limit,
                                    datum);
}

/* Adds the value 'new_value' to the "enable_async_messages" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_enable_async_messages_addvalue(const struct ovsrec_controller *row, bool new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_enable_async_messages,
                                    datum);
}

/* Deletes the value 'delete_value' from the "enable_async_messages" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_enable_async_messages_delvalue(const struct ovsrec_controller *row, bool delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_enable_async_messages,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "Controller" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_controller_update_external_ids_setkey(const struct ovsrec_controller *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_controller_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Controller" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_controller_update_external_ids_delkey(const struct ovsrec_controller *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_controller_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "inactivity_probe" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_inactivity_probe_addvalue(const struct ovsrec_controller *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_inactivity_probe,
                                    datum);
}

/* Deletes the value 'delete_value' from the "inactivity_probe" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_inactivity_probe_delvalue(const struct ovsrec_controller *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_inactivity_probe,
                                    datum);
}

/* Adds the value 'new_value' to the "local_gateway" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_local_gateway_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_gateway,
                                    datum);
}

/* Deletes the value 'delete_value' from the "local_gateway" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_local_gateway_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_gateway,
                                    datum);
}

/* Adds the value 'new_value' to the "local_ip" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_local_ip_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_ip,
                                    datum);
}

/* Deletes the value 'delete_value' from the "local_ip" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_local_ip_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_ip,
                                    datum);
}

/* Adds the value 'new_value' to the "local_netmask" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_local_netmask_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_netmask,
                                    datum);
}

/* Deletes the value 'delete_value' from the "local_netmask" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_local_netmask_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_local_netmask,
                                    datum);
}

/* Adds the value 'new_value' to the "max_backoff" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_max_backoff_addvalue(const struct ovsrec_controller *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_max_backoff,
                                    datum);
}

/* Deletes the value 'delete_value' from the "max_backoff" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_max_backoff_delvalue(const struct ovsrec_controller *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_max_backoff,
                                    datum);
}

/* Sets an element of the "other_config" map column from the "Controller" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_controller_update_other_config_setkey(const struct ovsrec_controller *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_controller_col_other_config,
                                    datum);
}

/* Deletes an element of the "other_config" map column from the "Controller" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_controller_update_other_config_delkey(const struct ovsrec_controller *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_controller_col_other_config,
                                    datum);
}

/* Adds the value 'new_value' to the "role" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_role_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_role,
                                    datum);
}

/* Deletes the value 'delete_value' from the "role" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_role_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_role,
                                    datum);
}

/* Sets an element of the "status" map column from the "Controller" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_controller_update_status_setkey(const struct ovsrec_controller *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_controller_col_status,
                                    datum);
}

/* Deletes an element of the "status" map column from the "Controller" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_controller_update_status_delkey(const struct ovsrec_controller *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_controller_col_status,
                                    datum);
}

/* Adds the value 'new_value' to the "type" set column from the "Controller" table
 * in 'row'.
 *
 */
void
ovsrec_controller_update_type_addvalue(const struct ovsrec_controller *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_controller_col_type,
                                    datum);
}

/* Deletes the value 'delete_value' from the "type" set column from the
 * "Controller" table in 'row'.
 *
 */
void
ovsrec_controller_update_type_delvalue(const struct ovsrec_controller *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_controller_col_type,
                                    datum);
}

/* Sets the "connection_mode" column from the "Controller" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_connection_mode(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (connection_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_connection_mode,
                          &datum);
}

/* Sets the "controller_burst_limit" column from the "Controller" table in 'row' to
 * the 'controller_burst_limit' set with 'n_controller_burst_limit' entries.
 *
 * 'n_controller_burst_limit' may be 0 or 1; if it is 0, then 'controller_burst_limit'
 * may be NULL.
 *
 * Argument constraints: at least 25
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_controller_burst_limit(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *controller_burst_limit, size_t n_controller_burst_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_burst_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_burst_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_controller_burst_limit,
                          &datum);
}

/* Sets the "controller_queue_size" column from the "Controller" table in 'row' to
 * the 'controller_queue_size' set with 'n_controller_queue_size' entries.
 *
 * 'n_controller_queue_size' may be 0 or 1; if it is 0, then 'controller_queue_size'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 512
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_controller_queue_size(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *controller_queue_size, size_t n_controller_queue_size)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_queue_size) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_queue_size;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_controller_queue_size,
                          &datum);
}

/* Sets the "controller_rate_limit" column from the "Controller" table in 'row' to
 * the 'controller_rate_limit' set with 'n_controller_rate_limit' entries.
 *
 * 'n_controller_rate_limit' may be 0 or 1; if it is 0, then 'controller_rate_limit'
 * may be NULL.
 *
 * Argument constraints: at least 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_controller_rate_limit(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *controller_rate_limit, size_t n_controller_rate_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_controller_rate_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *controller_rate_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_controller_rate_limit,
                          &datum);
}

/* Sets the "enable_async_messages" column from the "Controller" table in 'row' to
 * the 'enable_async_messages' set with 'n_enable_async_messages' entries.
 *
 * 'n_enable_async_messages' may be 0 or 1; if it is 0, then 'enable_async_messages'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_enable_async_messages(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const bool *enable_async_messages, size_t n_enable_async_messages)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_enable_async_messages) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *enable_async_messages;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_enable_async_messages,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Controller" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_controller_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_controller_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_controller_col_external_ids.type);
}


/* Sets the "inactivity_probe" column from the "Controller" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_inactivity_probe(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_inactivity_probe) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_inactivity_probe,
                          &datum);
}

/* Sets the "is_connected" column from the "Controller" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_is_connected(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_is_connected,
                          &datum);
}

/* Sets the "local_gateway" column from the "Controller" table in 'row' to
 * the 'local_gateway' set.
 *
 * If "local_gateway" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_local_gateway(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *local_gateway)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_gateway) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_gateway);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_local_gateway,
                          &datum);
}

/* Sets the "local_ip" column from the "Controller" table in 'row' to
 * the 'local_ip' set.
 *
 * If "local_ip" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_local_ip(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *local_ip)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_ip) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_ip);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_local_ip,
                          &datum);
}

/* Sets the "local_netmask" column from the "Controller" table in 'row' to
 * the 'local_netmask' set.
 *
 * If "local_netmask" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_local_netmask(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *local_netmask)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (local_netmask) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, local_netmask);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_local_netmask,
                          &datum);
}

/* Sets the "max_backoff" column from the "Controller" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_max_backoff(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_max_backoff) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_max_backoff,
                          &datum);
}

/* Sets the "other_config" column's value from the "Controller" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_controller_add_clause_other_config(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_controller_col_other_config,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_controller_col_other_config.type);
}


/* Sets the "role" column from the "Controller" table in 'row' to
 * the 'role' set.
 *
 * If "role" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: one of "master", "other", or "slave"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_role(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *role)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (role) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, role);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_role,
                          &datum);
}

/* Sets the "status" column's value from the "Controller" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_controller_add_clause_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_controller_col_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_controller_col_status.type);
}


/* Sets the "target" column from the "Controller" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_target(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_target,
                          &datum);
}

/* Sets the "type" column from the "Controller" table in 'row' to
 * the 'type' set.
 *
 * If "type" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "primary" or "service"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_add_clause_type(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (type) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, type);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_controller_col_type,
                          &datum);
}

/* Destroy 'row' of kind "Controller". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_controller_index_destroy_row(const struct ovsrec_controller *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Controller". */
struct ovsrec_controller *
ovsrec_controller_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_controller);
    return ALIGNED_CAST(struct ovsrec_controller *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_controller *
ovsrec_controller_index_find(struct ovsdb_idl_index *index, const struct ovsrec_controller *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_controller);
    return ovsrec_controller_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_controller_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_controller *a, 
    const struct ovsrec_controller *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_controller_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_controller);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_controller_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_controller *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_controller);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_controller_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_controller *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_controller);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_controller *
ovsrec_controller_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_controller_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "connection_mode" column from the "Controller" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_connection_mode(const struct ovsrec_controller *row, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (connection_mode) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_CONNECTION_MODE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "controller_burst_limit" column from the "Controller" table in 'row' to
 * the 'controller_burst_limit' set with 'n_controller_burst_limit' entries.
 *
 * 'n_controller_burst_limit' may be 0 or 1; if it is 0, then 'controller_burst_limit'
 * may be NULL.
 *
 * Argument constraints: at least 25
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_controller_burst_limit(const struct ovsrec_controller *row, const int64_t *controller_burst_limit, size_t n_controller_burst_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_controller_burst_limit) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *controller_burst_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_CONTROLLER_BURST_LIMIT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "controller_queue_size" column from the "Controller" table in 'row' to
 * the 'controller_queue_size' set with 'n_controller_queue_size' entries.
 *
 * 'n_controller_queue_size' may be 0 or 1; if it is 0, then 'controller_queue_size'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 512
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_controller_queue_size(const struct ovsrec_controller *row, const int64_t *controller_queue_size, size_t n_controller_queue_size)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_controller_queue_size) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *controller_queue_size;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_CONTROLLER_QUEUE_SIZE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "controller_rate_limit" column from the "Controller" table in 'row' to
 * the 'controller_rate_limit' set with 'n_controller_rate_limit' entries.
 *
 * 'n_controller_rate_limit' may be 0 or 1; if it is 0, then 'controller_rate_limit'
 * may be NULL.
 *
 * Argument constraints: at least 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_controller_rate_limit(const struct ovsrec_controller *row, const int64_t *controller_rate_limit, size_t n_controller_rate_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_controller_rate_limit) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *controller_rate_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_CONTROLLER_RATE_LIMIT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "enable_async_messages" column from the "Controller" table in 'row' to
 * the 'enable_async_messages' set with 'n_enable_async_messages' entries.
 *
 * 'n_enable_async_messages' may be 0 or 1; if it is 0, then 'enable_async_messages'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_enable_async_messages(const struct ovsrec_controller *row, const bool *enable_async_messages, size_t n_enable_async_messages)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_enable_async_messages) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->boolean = *enable_async_messages;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_ENABLE_ASYNC_MESSAGES ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "external_ids" column's value from the "Controller" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_controller_index_set_external_ids(const struct ovsrec_controller *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_controller_columns[OVSREC_CONTROLLER_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
    free(datum);
}


/* Sets the "inactivity_probe" column from the "Controller" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_inactivity_probe(const struct ovsrec_controller *row, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_inactivity_probe) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_INACTIVITY_PROBE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "is_connected" column from the "Controller" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_is_connected(const struct ovsrec_controller *row, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_IS_CONNECTED ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "local_gateway" column from the "Controller" table in 'row' to
 * the 'local_gateway' set.
 *
 * If "local_gateway" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_local_gateway(const struct ovsrec_controller *row, const char *local_gateway)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (local_gateway) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, local_gateway);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_LOCAL_GATEWAY ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "local_ip" column from the "Controller" table in 'row' to
 * the 'local_ip' set.
 *
 * If "local_ip" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_local_ip(const struct ovsrec_controller *row, const char *local_ip)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (local_ip) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, local_ip);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_LOCAL_IP ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "local_netmask" column from the "Controller" table in 'row' to
 * the 'local_netmask' set.
 *
 * If "local_netmask" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_local_netmask(const struct ovsrec_controller *row, const char *local_netmask)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (local_netmask) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, local_netmask);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_LOCAL_NETMASK ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "max_backoff" column from the "Controller" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_max_backoff(const struct ovsrec_controller *row, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_max_backoff) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_MAX_BACKOFF ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "other_config" column's value from the "Controller" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_controller_index_set_other_config(const struct ovsrec_controller *row, const struct smap *other_config)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (other_config) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(other_config);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, other_config) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_controller_columns[OVSREC_CONTROLLER_COL_OTHER_CONFIG],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
    free(datum);
}


/* Sets the "role" column from the "Controller" table in 'row' to
 * the 'role' set.
 *
 * If "role" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: one of "master", "other", or "slave"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_role(const struct ovsrec_controller *row, const char *role)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (role) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, role);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_ROLE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "status" column's value from the "Controller" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_controller_index_set_status(const struct ovsrec_controller *row, const struct smap *status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_controller_columns[OVSREC_CONTROLLER_COL_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
    free(datum);
}


/* Sets the "target" column from the "Controller" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_target(const struct ovsrec_controller *row, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_TARGET ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

/* Sets the "type" column from the "Controller" table in 'row' to
 * the 'type' set.
 *
 * If "type" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "primary" or "service"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_controller_index_set_type(const struct ovsrec_controller *row, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (type) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, type);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_controller_columns[ OVSREC_CONTROLLER_COL_TYPE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_CONTROLLER]);
}

struct ovsdb_idl_column ovsrec_controller_columns[OVSREC_CONTROLLER_N_COLUMNS];

unsigned int
ovsrec_controller_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_controller, condition);
}
static union ovsdb_atom Controller_col_connection_mode_key_enum_keys[2] = {
    { .string = "in-band" },
    { .string = "out-of-band" },
};
static struct ovsdb_datum Controller_col_connection_mode_key_enum = {
    .n = 2,
    .keys = Controller_col_connection_mode_key_enum_keys,
};
static union ovsdb_atom Controller_col_role_key_enum_keys[3] = {
    { .string = "master" },
    { .string = "other" },
    { .string = "slave" },
};
static struct ovsdb_datum Controller_col_role_key_enum = {
    .n = 3,
    .keys = Controller_col_role_key_enum_keys,
};
static union ovsdb_atom Controller_col_type_key_enum_keys[2] = {
    { .string = "primary" },
    { .string = "service" },
};
static struct ovsdb_datum Controller_col_type_key_enum = {
    .n = 2,
    .keys = Controller_col_type_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_controller_columns[OVSREC_CONTROLLER_N_COLUMNS] = {
    [OVSREC_CONTROLLER_COL_CONNECTION_MODE] = {
         .name = "connection_mode",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Controller_col_connection_mode_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_connection_mode,
         .unparse = ovsrec_controller_unparse_connection_mode,
    },

    [OVSREC_CONTROLLER_COL_CONTROLLER_BURST_LIMIT] = {
         .name = "controller_burst_limit",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(25), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_controller_burst_limit,
         .unparse = ovsrec_controller_unparse_controller_burst_limit,
    },

    [OVSREC_CONTROLLER_COL_CONTROLLER_QUEUE_SIZE] = {
         .name = "controller_queue_size",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1), .max = INT64_C(512) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_controller_queue_size,
         .unparse = ovsrec_controller_unparse_controller_queue_size,
    },

    [OVSREC_CONTROLLER_COL_CONTROLLER_RATE_LIMIT] = {
         .name = "controller_rate_limit",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(100), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_controller_rate_limit,
         .unparse = ovsrec_controller_unparse_controller_rate_limit,
    },

    [OVSREC_CONTROLLER_COL_ENABLE_ASYNC_MESSAGES] = {
         .name = "enable_async_messages",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_enable_async_messages,
         .unparse = ovsrec_controller_unparse_enable_async_messages,
    },

    [OVSREC_CONTROLLER_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_external_ids,
         .unparse = ovsrec_controller_unparse_external_ids,
    },

    [OVSREC_CONTROLLER_COL_INACTIVITY_PROBE] = {
         .name = "inactivity_probe",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_inactivity_probe,
         .unparse = ovsrec_controller_unparse_inactivity_probe,
    },

    [OVSREC_CONTROLLER_COL_IS_CONNECTED] = {
         .name = "is_connected",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_is_connected,
         .unparse = ovsrec_controller_unparse_is_connected,
    },

    [OVSREC_CONTROLLER_COL_LOCAL_GATEWAY] = {
         .name = "local_gateway",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_local_gateway,
         .unparse = ovsrec_controller_unparse_local_gateway,
    },

    [OVSREC_CONTROLLER_COL_LOCAL_IP] = {
         .name = "local_ip",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_local_ip,
         .unparse = ovsrec_controller_unparse_local_ip,
    },

    [OVSREC_CONTROLLER_COL_LOCAL_NETMASK] = {
         .name = "local_netmask",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_local_netmask,
         .unparse = ovsrec_controller_unparse_local_netmask,
    },

    [OVSREC_CONTROLLER_COL_MAX_BACKOFF] = {
         .name = "max_backoff",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1000), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_max_backoff,
         .unparse = ovsrec_controller_unparse_max_backoff,
    },

    [OVSREC_CONTROLLER_COL_OTHER_CONFIG] = {
         .name = "other_config",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_other_config,
         .unparse = ovsrec_controller_unparse_other_config,
    },

    [OVSREC_CONTROLLER_COL_ROLE] = {
         .name = "role",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Controller_col_role_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_role,
         .unparse = ovsrec_controller_unparse_role,
    },

    [OVSREC_CONTROLLER_COL_STATUS] = {
         .name = "status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_status,
         .unparse = ovsrec_controller_unparse_status,
    },

    [OVSREC_CONTROLLER_COL_TARGET] = {
         .name = "target",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_target,
         .unparse = ovsrec_controller_unparse_target,
    },

    [OVSREC_CONTROLLER_COL_TYPE] = {
         .name = "type",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Controller_col_type_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_controller_parse_type,
         .unparse = ovsrec_controller_unparse_type,
    },

};

/* Datapath table. */

const struct ovsrec_datapath_table *
ovsrec_datapath_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_datapath_table *) idl;
}

const struct ovsrec_datapath *
ovsrec_datapath_table_first(const struct ovsrec_datapath_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_datapath_first(idl);
}


const struct ovsrec_datapath *
ovsrec_datapath_table_track_get_first(const struct ovsrec_datapath_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_datapath_track_get_first(idl);
}


static void
ovsrec_datapath_parse_capabilities(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    smap_init(&row->capabilities);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->capabilities,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_datapath_parse_ct_zones(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    row->key_ct_zones = NULL;
    row->value_ct_zones = NULL;
    row->n_ct_zones = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_ct_zone *valueRow = ovsrec_ct_zone_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_ct_zone, &datum->values[i].uuid));
        if (!valueRow) {
            continue;
        }
        if (!row->n_ct_zones) {
            row->key_ct_zones = xmalloc(datum->n * sizeof *row->key_ct_zones);
            row->value_ct_zones = xmalloc(datum->n * sizeof *row->value_ct_zones);
        }
        row->key_ct_zones[row->n_ct_zones] = datum->keys[i].integer;
        row->value_ct_zones[row->n_ct_zones] = valueRow;
        row->n_ct_zones++;
    }
}

static void
ovsrec_datapath_parse_datapath_version(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);

    if (datum->n >= 1) {
        row->datapath_version = datum->keys[0].string;
    } else {
        row->datapath_version = "";
    }
}

static void
ovsrec_datapath_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_datapath_unparse_capabilities(struct ovsdb_idl_row *row_)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    smap_destroy(&row->capabilities);
}

static void
ovsrec_datapath_unparse_ct_zones(struct ovsdb_idl_row *row_)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    free(row->key_ct_zones);
    free(row->value_ct_zones);
}

static void
ovsrec_datapath_unparse_datapath_version(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_datapath_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_datapath *row = ovsrec_datapath_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_datapath_init__(struct ovsdb_idl_row *row)
{
    ovsrec_datapath_init(ovsrec_datapath_cast(row));
}

/* Clears the contents of 'row' in table "Datapath". */
void
ovsrec_datapath_init(struct ovsrec_datapath *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->capabilities);
    row->datapath_version = "";
    smap_init(&row->external_ids);
}

/* Searches table "Datapath" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_datapath *
ovsrec_datapath_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_datapath_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_datapath, uuid));
}

/* Searches table "Datapath" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_datapath *
ovsrec_datapath_table_get_for_uuid(const struct ovsrec_datapath_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_datapath_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Datapath" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_datapath *
ovsrec_datapath_first(const struct ovsdb_idl *idl)
{
    return ovsrec_datapath_cast(ovsdb_idl_first_row(idl, &ovsrec_table_datapath));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_datapath *
ovsrec_datapath_next(const struct ovsrec_datapath *row)
{
    return ovsrec_datapath_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_datapath_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_datapath);
}

unsigned int ovsrec_datapath_row_get_seqno(const struct ovsrec_datapath *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_datapath *
ovsrec_datapath_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_datapath_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_datapath));
}

const struct ovsrec_datapath
*ovsrec_datapath_track_get_next(const struct ovsrec_datapath *row)
{
    return ovsrec_datapath_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Datapath".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_datapath_delete(const struct ovsrec_datapath *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Datapath" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_datapath *
ovsrec_datapath_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_datapath_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_datapath, NULL));
}

bool
ovsrec_datapath_is_updated(const struct ovsrec_datapath *row, enum ovsrec_datapath_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_datapath_columns[column]);
}

/* Causes the original contents of column "capabilities" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "capabilities" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "capabilities" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "capabilities" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_datapath_insert()).
 *
 *   - If "capabilities" has already been modified (with
 *     ovsrec_datapath_set_capabilities()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_datapath_set_capabilities() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_datapath_verify_capabilities(const struct ovsrec_datapath *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_datapath_col_capabilities);
}

/* Causes the original contents of column "ct_zones" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ct_zones" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ct_zones" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ct_zones" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_datapath_insert()).
 *
 *   - If "ct_zones" has already been modified (with
 *     ovsrec_datapath_set_ct_zones()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_datapath_set_ct_zones() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_datapath_verify_ct_zones(const struct ovsrec_datapath *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_datapath_col_ct_zones);
}

/* Causes the original contents of column "datapath_version" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "datapath_version" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "datapath_version" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "datapath_version" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_datapath_insert()).
 *
 *   - If "datapath_version" has already been modified (with
 *     ovsrec_datapath_set_datapath_version()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_datapath_set_datapath_version() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_datapath_verify_datapath_version(const struct ovsrec_datapath *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_datapath_col_datapath_version);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_datapath_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_datapath_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_datapath_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_datapath_verify_external_ids(const struct ovsrec_datapath *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_datapath_col_external_ids);
}

/* Returns the "capabilities" column's value from the "Datapath" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes capabilities's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "capabilities" member in ovsrec_datapath. */
const struct ovsdb_datum *
ovsrec_datapath_get_capabilities(const struct ovsrec_datapath *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_datapath_col_capabilities);
}

/* Returns the "ct_zones" column's value from the "Datapath" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * 'value_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes ct_zones's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ct_zones" member in ovsrec_datapath. */
const struct ovsdb_datum *
ovsrec_datapath_get_ct_zones(const struct ovsrec_datapath *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    ovs_assert(value_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_datapath_col_ct_zones);
}

/* Returns the "datapath_version" column's value from the "Datapath" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes datapath_version's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "datapath_version" member in ovsrec_datapath. */
const struct ovsdb_datum *
ovsrec_datapath_get_datapath_version(const struct ovsrec_datapath *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_datapath_col_datapath_version);
}

/* Returns the "external_ids" column's value from the "Datapath" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_datapath. */
const struct ovsdb_datum *
ovsrec_datapath_get_external_ids(const struct ovsrec_datapath *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_datapath_col_external_ids);
}

/* Sets the "capabilities" column's value from the "Datapath" table in 'row'
 * to 'capabilities'.
 *
 * The caller retains ownership of 'capabilities' and everything in it. */
void
ovsrec_datapath_set_capabilities(const struct ovsrec_datapath *row, const struct smap *capabilities)
{
    struct ovsdb_datum datum;

    if (capabilities) {
        ovsdb_datum_from_smap(&datum, capabilities);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_datapath_col_capabilities,
                        &datum);
}


/* Sets the "ct_zones" column from the "Datapath" table in 'row' to
 * the map with keys 'key_ct_zones' and values 'value_ct_zones'
 * with 'n_ct_zones' entries.
 *
 * Argument constraints: key in range 0 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_set_ct_zones(const struct ovsrec_datapath *row, const int64_t *key_ct_zones, struct ovsrec_ct_zone **value_ct_zones, size_t n_ct_zones)
{
    struct ovsdb_datum datum;

    datum.n = n_ct_zones;
    datum.keys = n_ct_zones ? xmalloc(n_ct_zones * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_ct_zones * sizeof *datum.values);
    for (size_t i = 0; i < n_ct_zones; i++) {
        datum.keys[i].integer = key_ct_zones[i];
        datum.values[i].uuid = value_ct_zones[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_datapath_col_ct_zones, &datum);
}

/* Sets the "datapath_version" column from the "Datapath" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_set_datapath_version(const struct ovsrec_datapath *row, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_datapath_col_datapath_version, &datum);
}

/* Sets the "external_ids" column's value from the "Datapath" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_datapath_set_external_ids(const struct ovsrec_datapath *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_datapath_col_external_ids,
                        &datum);
}


/* Sets an element of the "capabilities" map column from the "Datapath" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_datapath_update_capabilities_setkey(const struct ovsrec_datapath *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_datapath_col_capabilities,
                                    datum);
}

/* Deletes an element of the "capabilities" map column from the "Datapath" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_datapath_update_capabilities_delkey(const struct ovsrec_datapath *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_datapath_col_capabilities,
                                    datum);
}

/* Sets an element of the "ct_zones" map column from the "Datapath" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_datapath_update_ct_zones_setkey(const struct ovsrec_datapath *row, int64_t new_key, const struct ovsrec_ct_zone *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].integer = new_key;
    datum->values[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_datapath_col_ct_zones,
                                    datum);
}

/* Deletes an element of the "ct_zones" map column from the "Datapath" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_datapath_update_ct_zones_delkey(const struct ovsrec_datapath *row, int64_t delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].integer = delete_key;

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_datapath_col_ct_zones,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "Datapath" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_datapath_update_external_ids_setkey(const struct ovsrec_datapath *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_datapath_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Datapath" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_datapath_update_external_ids_delkey(const struct ovsrec_datapath *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_datapath_col_external_ids,
                                    datum);
}

/* Sets the "capabilities" column's value from the "Datapath" table in 'row'
 * to 'capabilities'.
 *
 * The caller retains ownership of 'capabilities' and everything in it. */
void
ovsrec_datapath_add_clause_capabilities(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *capabilities)
{
    struct ovsdb_datum datum;

    if (capabilities) {
        ovsdb_datum_from_smap(&datum, capabilities);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_datapath_col_capabilities,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_datapath_col_capabilities.type);
}


/* Sets the "ct_zones" column from the "Datapath" table in 'row' to
 * the map with keys 'key_ct_zones' and values 'value_ct_zones'
 * with 'n_ct_zones' entries.
 *
 * Argument constraints: key in range 0 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_add_clause_ct_zones(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *key_ct_zones, struct uuid **value_ct_zones, size_t n_ct_zones)
{
    struct ovsdb_datum datum;
    datum.n = n_ct_zones;
    datum.keys = n_ct_zones ? xmalloc(n_ct_zones * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_ct_zones * sizeof *datum.values);
    for (size_t i = 0; i < n_ct_zones; i++) {
        datum.keys[i].integer = key_ct_zones[i];
        datum.values[i].uuid = *value_ct_zones[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_UUID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_datapath_col_ct_zones,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Sets the "datapath_version" column from the "Datapath" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_add_clause_datapath_version(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_datapath_col_datapath_version,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Datapath" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_datapath_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_datapath_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_datapath_col_external_ids.type);
}


/* Destroy 'row' of kind "Datapath". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_datapath_index_destroy_row(const struct ovsrec_datapath *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Datapath". */
struct ovsrec_datapath *
ovsrec_datapath_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_datapath);
    return ALIGNED_CAST(struct ovsrec_datapath *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_datapath *
ovsrec_datapath_index_find(struct ovsdb_idl_index *index, const struct ovsrec_datapath *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_datapath);
    return ovsrec_datapath_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_datapath_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_datapath *a, 
    const struct ovsrec_datapath *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_datapath_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_datapath);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_datapath_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_datapath *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_datapath);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_datapath_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_datapath *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_datapath);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_datapath *
ovsrec_datapath_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_datapath_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "capabilities" column's value from the "Datapath" table in 'row'
 * to 'capabilities'.
 *
 * The caller retains ownership of 'capabilities' and everything in it. */
void
ovsrec_datapath_index_set_capabilities(const struct ovsrec_datapath *row, const struct smap *capabilities)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (capabilities) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(capabilities);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, capabilities) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_datapath_columns[OVSREC_DATAPATH_COL_CAPABILITIES],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_DATAPATH]);
    free(datum);
}


/* Sets the "ct_zones" column from the "Datapath" table in 'row' to
 * the map with keys 'key_ct_zones' and values 'value_ct_zones'
 * with 'n_ct_zones' entries.
 *
 * Argument constraints: key in range 0 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_index_set_ct_zones(const struct ovsrec_datapath *row, const int64_t *key_ct_zones, struct ovsrec_ct_zone **value_ct_zones, size_t n_ct_zones)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_ct_zones;
    datum.keys = n_ct_zones ? xmalloc(n_ct_zones * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_ct_zones * sizeof *datum.values);
    for (i = 0; i < n_ct_zones; i++) {
        datum.keys[i].integer = key_ct_zones[i];
        datum.values[i].uuid = value_ct_zones[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_UUID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_datapath_columns[ OVSREC_DATAPATH_COL_CT_ZONES ], &datum, &ovsrec_table_classes[OVSREC_TABLE_DATAPATH]);
}

/* Sets the "datapath_version" column from the "Datapath" table in 'row' to
 * 'datapath_version'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_datapath_index_set_datapath_version(const struct ovsrec_datapath *row, const char *datapath_version)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, datapath_version);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_datapath_columns[ OVSREC_DATAPATH_COL_DATAPATH_VERSION ], &datum, &ovsrec_table_classes[OVSREC_TABLE_DATAPATH]);
}

/* Sets the "external_ids" column's value from the "Datapath" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_datapath_index_set_external_ids(const struct ovsrec_datapath *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_datapath_columns[OVSREC_DATAPATH_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_DATAPATH]);
    free(datum);
}


struct ovsdb_idl_column ovsrec_datapath_columns[OVSREC_DATAPATH_N_COLUMNS];

unsigned int
ovsrec_datapath_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_datapath, condition);
}

struct ovsdb_idl_column ovsrec_datapath_columns[OVSREC_DATAPATH_N_COLUMNS] = {
    [OVSREC_DATAPATH_COL_CAPABILITIES] = {
         .name = "capabilities",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_datapath_parse_capabilities,
         .unparse = ovsrec_datapath_unparse_capabilities,
    },

    [OVSREC_DATAPATH_COL_CT_ZONES] = {
         .name = "ct_zones",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(65535) },
            },
            .value = {
                .type = OVSDB_TYPE_UUID,
                .uuid = { .refTableName = "CT_Zone", .refType = OVSDB_REF_STRONG },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_datapath_parse_ct_zones,
         .unparse = ovsrec_datapath_unparse_ct_zones,
    },

    [OVSREC_DATAPATH_COL_DATAPATH_VERSION] = {
         .name = "datapath_version",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_datapath_parse_datapath_version,
         .unparse = ovsrec_datapath_unparse_datapath_version,
    },

    [OVSREC_DATAPATH_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_datapath_parse_external_ids,
         .unparse = ovsrec_datapath_unparse_external_ids,
    },

};

/* Flow_Sample_Collector_Set table. */

const struct ovsrec_flow_sample_collector_set_table *
ovsrec_flow_sample_collector_set_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_flow_sample_collector_set_table *) idl;
}

const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_table_first(const struct ovsrec_flow_sample_collector_set_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_flow_sample_collector_set_first(idl);
}


const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_table_track_get_first(const struct ovsrec_flow_sample_collector_set_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_flow_sample_collector_set_track_get_first(idl);
}


static void
ovsrec_flow_sample_collector_set_parse_bridge(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_sample_collector_set *row = ovsrec_flow_sample_collector_set_cast(row_);

    if (datum->n >= 1) {
        row->bridge = ovsrec_bridge_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_bridge, &datum->keys[0].uuid));
    } else {
        row->bridge = NULL;
    }
}

static void
ovsrec_flow_sample_collector_set_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_sample_collector_set *row = ovsrec_flow_sample_collector_set_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_flow_sample_collector_set_parse_id(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_sample_collector_set *row = ovsrec_flow_sample_collector_set_cast(row_);

    if (datum->n >= 1) {
        row->id = datum->keys[0].integer;
    } else {
        row->id = 0;
    }
}

static void
ovsrec_flow_sample_collector_set_parse_ipfix(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_sample_collector_set *row = ovsrec_flow_sample_collector_set_cast(row_);

    if (datum->n >= 1) {
        row->ipfix = ovsrec_ipfix_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_ipfix, &datum->keys[0].uuid));
    } else {
        row->ipfix = NULL;
    }
}

static void
ovsrec_flow_sample_collector_set_unparse_bridge(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_flow_sample_collector_set_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_flow_sample_collector_set *row = ovsrec_flow_sample_collector_set_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_flow_sample_collector_set_unparse_id(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_flow_sample_collector_set_unparse_ipfix(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_flow_sample_collector_set_init__(struct ovsdb_idl_row *row)
{
    ovsrec_flow_sample_collector_set_init(ovsrec_flow_sample_collector_set_cast(row));
}

/* Clears the contents of 'row' in table "Flow_Sample_Collector_Set". */
void
ovsrec_flow_sample_collector_set_init(struct ovsrec_flow_sample_collector_set *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
}

/* Searches table "Flow_Sample_Collector_Set" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_flow_sample_collector_set, uuid));
}

/* Searches table "Flow_Sample_Collector_Set" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_table_get_for_uuid(const struct ovsrec_flow_sample_collector_set_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_flow_sample_collector_set_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Flow_Sample_Collector_Set" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_first(const struct ovsdb_idl *idl)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_first_row(idl, &ovsrec_table_flow_sample_collector_set));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_next(const struct ovsrec_flow_sample_collector_set *row)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_flow_sample_collector_set_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_flow_sample_collector_set);
}

unsigned int ovsrec_flow_sample_collector_set_row_get_seqno(const struct ovsrec_flow_sample_collector_set *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_flow_sample_collector_set));
}

const struct ovsrec_flow_sample_collector_set
*ovsrec_flow_sample_collector_set_track_get_next(const struct ovsrec_flow_sample_collector_set *row)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Flow_Sample_Collector_Set".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_sample_collector_set_delete(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Flow_Sample_Collector_Set" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_flow_sample_collector_set, NULL));
}

bool
ovsrec_flow_sample_collector_set_is_updated(const struct ovsrec_flow_sample_collector_set *row, enum ovsrec_flow_sample_collector_set_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_flow_sample_collector_set_columns[column]);
}

/* Causes the original contents of column "bridge" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "bridge" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "bridge" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "bridge" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_sample_collector_set_insert()).
 *
 *   - If "bridge" has already been modified (with
 *     ovsrec_flow_sample_collector_set_set_bridge()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_sample_collector_set_set_bridge() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_sample_collector_set_verify_bridge(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_sample_collector_set_col_bridge);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_sample_collector_set_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_flow_sample_collector_set_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_sample_collector_set_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_sample_collector_set_verify_external_ids(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_sample_collector_set_col_external_ids);
}

/* Causes the original contents of column "id" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "id" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "id" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "id" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_sample_collector_set_insert()).
 *
 *   - If "id" has already been modified (with
 *     ovsrec_flow_sample_collector_set_set_id()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_sample_collector_set_set_id() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_sample_collector_set_verify_id(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_sample_collector_set_col_id);
}

/* Causes the original contents of column "ipfix" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ipfix" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ipfix" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ipfix" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_sample_collector_set_insert()).
 *
 *   - If "ipfix" has already been modified (with
 *     ovsrec_flow_sample_collector_set_set_ipfix()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_sample_collector_set_set_ipfix() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_sample_collector_set_verify_ipfix(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_sample_collector_set_col_ipfix);
}

/* Returns the "bridge" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes bridge's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "bridge" member in ovsrec_flow_sample_collector_set. */
const struct ovsdb_datum *
ovsrec_flow_sample_collector_set_get_bridge(const struct ovsrec_flow_sample_collector_set *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_sample_collector_set_col_bridge);
}

/* Returns the "external_ids" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_flow_sample_collector_set. */
const struct ovsdb_datum *
ovsrec_flow_sample_collector_set_get_external_ids(const struct ovsrec_flow_sample_collector_set *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_sample_collector_set_col_external_ids);
}

/* Returns the "id" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes id's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "id" member in ovsrec_flow_sample_collector_set. */
const struct ovsdb_datum *
ovsrec_flow_sample_collector_set_get_id(const struct ovsrec_flow_sample_collector_set *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_sample_collector_set_col_id);
}

/* Returns the "ipfix" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes ipfix's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ipfix" member in ovsrec_flow_sample_collector_set. */
const struct ovsdb_datum *
ovsrec_flow_sample_collector_set_get_ipfix(const struct ovsrec_flow_sample_collector_set *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_sample_collector_set_col_ipfix);
}

/* Sets the "bridge" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'bridge'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_set_bridge(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_bridge *bridge)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.uuid = bridge->header_.uuid;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_sample_collector_set_col_bridge, &datum);
}

/* Sets the "external_ids" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_sample_collector_set_set_external_ids(const struct ovsrec_flow_sample_collector_set *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_flow_sample_collector_set_col_external_ids,
                        &datum);
}


/* Sets the "id" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'id'.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_set_id(const struct ovsrec_flow_sample_collector_set *row, int64_t id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = id;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_sample_collector_set_col_id, &datum);
}

/* Sets the "ipfix" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_set_ipfix(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_ipfix *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (ipfix) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = ipfix->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_sample_collector_set_col_ipfix, &datum);
}

/* Sets an element of the "external_ids" map column from the "Flow_Sample_Collector_Set" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_flow_sample_collector_set_update_external_ids_setkey(const struct ovsrec_flow_sample_collector_set *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_flow_sample_collector_set_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Flow_Sample_Collector_Set" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_flow_sample_collector_set_update_external_ids_delkey(const struct ovsrec_flow_sample_collector_set *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_flow_sample_collector_set_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "ipfix" set column from the "Flow_Sample_Collector_Set" table
 * in 'row'.
 *
 */
void
ovsrec_flow_sample_collector_set_update_ipfix_addvalue(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_ipfix *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_sample_collector_set_col_ipfix,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ipfix" set column from the
 * "Flow_Sample_Collector_Set" table in 'row'.
 *
 */
void
ovsrec_flow_sample_collector_set_update_ipfix_delvalue(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_ipfix *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_sample_collector_set_col_ipfix,
                                    datum);
}

/* Sets the "bridge" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'bridge'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_add_clause_bridge(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *bridge)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.uuid = *bridge;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_sample_collector_set_col_bridge,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_sample_collector_set_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_flow_sample_collector_set_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_flow_sample_collector_set_col_external_ids.type);
}


/* Sets the "id" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'id'.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_add_clause_id(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = id;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_sample_collector_set_col_id,
                          &datum);
}

/* Sets the "ipfix" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_add_clause_ipfix(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (ipfix) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *ipfix;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_sample_collector_set_col_ipfix,
                          &datum);
}

/* Destroy 'row' of kind "Flow_Sample_Collector_Set". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_flow_sample_collector_set_index_destroy_row(const struct ovsrec_flow_sample_collector_set *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Flow_Sample_Collector_Set". */
struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_sample_collector_set);
    return ALIGNED_CAST(struct ovsrec_flow_sample_collector_set *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_index_find(struct ovsdb_idl_index *index, const struct ovsrec_flow_sample_collector_set *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_sample_collector_set);
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_flow_sample_collector_set_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_flow_sample_collector_set *a, 
    const struct ovsrec_flow_sample_collector_set *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_flow_sample_collector_set_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_sample_collector_set);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_flow_sample_collector_set_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_flow_sample_collector_set *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_sample_collector_set);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_flow_sample_collector_set_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_flow_sample_collector_set *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_sample_collector_set);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_flow_sample_collector_set *
ovsrec_flow_sample_collector_set_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_flow_sample_collector_set_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "bridge" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'bridge'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_index_set_bridge(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_bridge *bridge)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->uuid = bridge->header_.uuid;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_sample_collector_set_columns[ OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_BRIDGE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_SAMPLE_COLLECTOR_SET]);
}

/* Sets the "external_ids" column's value from the "Flow_Sample_Collector_Set" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_sample_collector_set_index_set_external_ids(const struct ovsrec_flow_sample_collector_set *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_flow_sample_collector_set_columns[OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_FLOW_SAMPLE_COLLECTOR_SET]);
    free(datum);
}


/* Sets the "id" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * 'id'.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_index_set_id(const struct ovsrec_flow_sample_collector_set *row, int64_t id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = id;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_sample_collector_set_columns[ OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_ID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_SAMPLE_COLLECTOR_SET]);
}

/* Sets the "ipfix" column from the "Flow_Sample_Collector_Set" table in 'row' to
 * the 'ipfix' set.
 *
 * If "ipfix" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_sample_collector_set_index_set_ipfix(const struct ovsrec_flow_sample_collector_set *row, const struct ovsrec_ipfix *ipfix)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (ipfix) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = ipfix->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_sample_collector_set_columns[ OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_IPFIX ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_SAMPLE_COLLECTOR_SET]);
}

struct ovsdb_idl_column ovsrec_flow_sample_collector_set_columns[OVSREC_FLOW_SAMPLE_COLLECTOR_SET_N_COLUMNS];

unsigned int
ovsrec_flow_sample_collector_set_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_flow_sample_collector_set, condition);
}

struct ovsdb_idl_column ovsrec_flow_sample_collector_set_columns[OVSREC_FLOW_SAMPLE_COLLECTOR_SET_N_COLUMNS] = {
    [OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_BRIDGE] = {
         .name = "bridge",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Bridge", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_sample_collector_set_parse_bridge,
         .unparse = ovsrec_flow_sample_collector_set_unparse_bridge,
    },

    [OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_sample_collector_set_parse_external_ids,
         .unparse = ovsrec_flow_sample_collector_set_unparse_external_ids,
    },

    [OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_ID] = {
         .name = "id",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_sample_collector_set_parse_id,
         .unparse = ovsrec_flow_sample_collector_set_unparse_id,
    },

    [OVSREC_FLOW_SAMPLE_COLLECTOR_SET_COL_IPFIX] = {
         .name = "ipfix",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "IPFIX", .refType = OVSDB_REF_STRONG },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_sample_collector_set_parse_ipfix,
         .unparse = ovsrec_flow_sample_collector_set_unparse_ipfix,
    },

};

/* Flow_Table table. */

const struct ovsrec_flow_table_table *
ovsrec_flow_table_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_flow_table_table *) idl;
}

const struct ovsrec_flow_table *
ovsrec_flow_table_table_first(const struct ovsrec_flow_table_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_flow_table_first(idl);
}


const struct ovsrec_flow_table *
ovsrec_flow_table_table_track_get_first(const struct ovsrec_flow_table_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_flow_table_track_get_first(idl);
}


static void
ovsrec_flow_table_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_flow_table_parse_flow_limit(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    size_t n = MIN(1, datum->n);
    row->flow_limit = NULL;
    row->n_flow_limit = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_flow_limit) {
            row->flow_limit = xmalloc(n * sizeof *row->flow_limit);
        }
        row->flow_limit[row->n_flow_limit] = datum->keys[i].integer;
        row->n_flow_limit++;
    }
}

static void
ovsrec_flow_table_parse_groups(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    row->groups = NULL;
    row->n_groups = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_groups) {
            row->groups = xmalloc(datum->n * sizeof *row->groups);
        }
        row->groups[row->n_groups] = datum->keys[i].string;
        row->n_groups++;
    }
}

static void
ovsrec_flow_table_parse_name(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);

    if (datum->n >= 1) {
        row->name = datum->keys[0].string;
    } else {
        row->name = NULL;
    }
}

static void
ovsrec_flow_table_parse_overflow_policy(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);

    if (datum->n >= 1) {
        row->overflow_policy = datum->keys[0].string;
    } else {
        row->overflow_policy = NULL;
    }
}

static void
ovsrec_flow_table_parse_prefixes(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    size_t n = MIN(3, datum->n);
    row->prefixes = NULL;
    row->n_prefixes = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_prefixes) {
            row->prefixes = xmalloc(n * sizeof *row->prefixes);
        }
        row->prefixes[row->n_prefixes] = datum->keys[i].string;
        row->n_prefixes++;
    }
}

static void
ovsrec_flow_table_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_flow_table_unparse_flow_limit(struct ovsdb_idl_row *row_)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    free(row->flow_limit);
}

static void
ovsrec_flow_table_unparse_groups(struct ovsdb_idl_row *row_)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    free(row->groups);
}

static void
ovsrec_flow_table_unparse_name(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_flow_table_unparse_overflow_policy(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_flow_table_unparse_prefixes(struct ovsdb_idl_row *row_)
{
    struct ovsrec_flow_table *row = ovsrec_flow_table_cast(row_);
    free(row->prefixes);
}

static void
ovsrec_flow_table_init__(struct ovsdb_idl_row *row)
{
    ovsrec_flow_table_init(ovsrec_flow_table_cast(row));
}

/* Clears the contents of 'row' in table "Flow_Table". */
void
ovsrec_flow_table_init(struct ovsrec_flow_table *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
}

/* Searches table "Flow_Table" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_flow_table *
ovsrec_flow_table_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_flow_table_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_flow_table, uuid));
}

/* Searches table "Flow_Table" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_flow_table *
ovsrec_flow_table_table_get_for_uuid(const struct ovsrec_flow_table_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_flow_table_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Flow_Table" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_flow_table *
ovsrec_flow_table_first(const struct ovsdb_idl *idl)
{
    return ovsrec_flow_table_cast(ovsdb_idl_first_row(idl, &ovsrec_table_flow_table));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_flow_table *
ovsrec_flow_table_next(const struct ovsrec_flow_table *row)
{
    return ovsrec_flow_table_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_flow_table_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_flow_table);
}

unsigned int ovsrec_flow_table_row_get_seqno(const struct ovsrec_flow_table *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_flow_table *
ovsrec_flow_table_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_flow_table_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_flow_table));
}

const struct ovsrec_flow_table
*ovsrec_flow_table_track_get_next(const struct ovsrec_flow_table *row)
{
    return ovsrec_flow_table_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Flow_Table".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_delete(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Flow_Table" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_flow_table *
ovsrec_flow_table_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_flow_table_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_flow_table, NULL));
}

bool
ovsrec_flow_table_is_updated(const struct ovsrec_flow_table *row, enum ovsrec_flow_table_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_flow_table_columns[column]);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_flow_table_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_external_ids(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_external_ids);
}

/* Causes the original contents of column "flow_limit" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "flow_limit" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "flow_limit" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "flow_limit" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "flow_limit" has already been modified (with
 *     ovsrec_flow_table_set_flow_limit()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_flow_limit() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_flow_limit(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_flow_limit);
}

/* Causes the original contents of column "groups" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "groups" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "groups" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "groups" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "groups" has already been modified (with
 *     ovsrec_flow_table_set_groups()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_groups() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_groups(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_groups);
}

/* Causes the original contents of column "name" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "name" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "name" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "name" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "name" has already been modified (with
 *     ovsrec_flow_table_set_name()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_name() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_name(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_name);
}

/* Causes the original contents of column "overflow_policy" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "overflow_policy" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "overflow_policy" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "overflow_policy" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "overflow_policy" has already been modified (with
 *     ovsrec_flow_table_set_overflow_policy()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_overflow_policy() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_overflow_policy(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_overflow_policy);
}

/* Causes the original contents of column "prefixes" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "prefixes" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "prefixes" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "prefixes" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_flow_table_insert()).
 *
 *   - If "prefixes" has already been modified (with
 *     ovsrec_flow_table_set_prefixes()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_flow_table_set_prefixes() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_flow_table_verify_prefixes(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_flow_table_col_prefixes);
}

/* Returns the "external_ids" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_external_ids(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_external_ids);
}

/* Returns the "flow_limit" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes flow_limit's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "flow_limit" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_flow_limit(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_flow_limit);
}

/* Returns the "groups" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes groups's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "groups" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_groups(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_groups);
}

/* Returns the "name" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes name's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "name" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_name(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_name);
}

/* Returns the "overflow_policy" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes overflow_policy's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "overflow_policy" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_overflow_policy(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_overflow_policy);
}

/* Returns the "prefixes" column's value from the "Flow_Table" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes prefixes's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "prefixes" member in ovsrec_flow_table. */
const struct ovsdb_datum *
ovsrec_flow_table_get_prefixes(const struct ovsrec_flow_table *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_flow_table_col_prefixes);
}

/* Sets the "external_ids" column's value from the "Flow_Table" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_table_set_external_ids(const struct ovsrec_flow_table *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_flow_table_col_external_ids,
                        &datum);
}


/* Sets the "flow_limit" column from the "Flow_Table" table in 'row' to
 * the 'flow_limit' set with 'n_flow_limit' entries.
 *
 * 'n_flow_limit' may be 0 or 1; if it is 0, then 'flow_limit'
 * may be NULL.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_set_flow_limit(const struct ovsrec_flow_table *row, const int64_t *flow_limit, size_t n_flow_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_flow_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *flow_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_table_col_flow_limit, &datum);
}

/* Sets the "groups" column from the "Flow_Table" table in 'row' to
 * the 'groups' set with 'n_groups' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_set_groups(const struct ovsrec_flow_table *row, const char **groups, size_t n_groups)
{
    struct ovsdb_datum datum;

    datum.n = n_groups;
    datum.keys = n_groups ? xmalloc(n_groups * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_groups; i++) {
        datum.keys[i].string = xstrdup(groups[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_flow_table_col_groups, &datum);
}

/* Sets the "name" column from the "Flow_Table" table in 'row' to
 * the 'name' set.
 *
 * If "name" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_set_name(const struct ovsrec_flow_table *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (name) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, name);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_table_col_name, &datum);
}

/* Sets the "overflow_policy" column from the "Flow_Table" table in 'row' to
 * the 'overflow_policy' set.
 *
 * If "overflow_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "evict" or "refuse"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_set_overflow_policy(const struct ovsrec_flow_table *row, const char *overflow_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (overflow_policy) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, overflow_policy);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_flow_table_col_overflow_policy, &datum);
}

/* Sets the "prefixes" column from the "Flow_Table" table in 'row' to
 * the 'prefixes' set with 'n_prefixes' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_set_prefixes(const struct ovsrec_flow_table *row, const char **prefixes, size_t n_prefixes)
{
    struct ovsdb_datum datum;

    datum.n = n_prefixes;
    datum.keys = n_prefixes ? xmalloc(n_prefixes * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_prefixes; i++) {
        datum.keys[i].string = xstrdup(prefixes[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_flow_table_col_prefixes, &datum);
}

/* Sets an element of the "external_ids" map column from the "Flow_Table" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_flow_table_update_external_ids_setkey(const struct ovsrec_flow_table *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_flow_table_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Flow_Table" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_flow_table_update_external_ids_delkey(const struct ovsrec_flow_table *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_flow_table_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "flow_limit" set column from the "Flow_Table" table
 * in 'row'.
 *
 */
void
ovsrec_flow_table_update_flow_limit_addvalue(const struct ovsrec_flow_table *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_flow_limit,
                                    datum);
}

/* Deletes the value 'delete_value' from the "flow_limit" set column from the
 * "Flow_Table" table in 'row'.
 *
 */
void
ovsrec_flow_table_update_flow_limit_delvalue(const struct ovsrec_flow_table *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_flow_limit,
                                    datum);
}

/* Adds the value 'new_value' to the "groups" set column from the "Flow_Table" table
 * in 'row'.
 *
 */
void
ovsrec_flow_table_update_groups_addvalue(const struct ovsrec_flow_table *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_groups,
                                    datum);
}

/* Deletes the value 'delete_value' from the "groups" set column from the
 * "Flow_Table" table in 'row'.
 *
 */
void
ovsrec_flow_table_update_groups_delvalue(const struct ovsrec_flow_table *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_groups,
                                    datum);
}

/* Adds the value 'new_value' to the "name" set column from the "Flow_Table" table
 * in 'row'.
 *
 */
void
ovsrec_flow_table_update_name_addvalue(const struct ovsrec_flow_table *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_name,
                                    datum);
}

/* Deletes the value 'delete_value' from the "name" set column from the
 * "Flow_Table" table in 'row'.
 *
 */
void
ovsrec_flow_table_update_name_delvalue(const struct ovsrec_flow_table *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_name,
                                    datum);
}

/* Adds the value 'new_value' to the "overflow_policy" set column from the "Flow_Table" table
 * in 'row'.
 *
 */
void
ovsrec_flow_table_update_overflow_policy_addvalue(const struct ovsrec_flow_table *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_overflow_policy,
                                    datum);
}

/* Deletes the value 'delete_value' from the "overflow_policy" set column from the
 * "Flow_Table" table in 'row'.
 *
 */
void
ovsrec_flow_table_update_overflow_policy_delvalue(const struct ovsrec_flow_table *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_overflow_policy,
                                    datum);
}

/* Adds the value 'new_value' to the "prefixes" set column from the "Flow_Table" table
 * in 'row'.
 *
 */
void
ovsrec_flow_table_update_prefixes_addvalue(const struct ovsrec_flow_table *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_prefixes,
                                    datum);
}

/* Deletes the value 'delete_value' from the "prefixes" set column from the
 * "Flow_Table" table in 'row'.
 *
 */
void
ovsrec_flow_table_update_prefixes_delvalue(const struct ovsrec_flow_table *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_flow_table_col_prefixes,
                                    datum);
}

/* Sets the "external_ids" column's value from the "Flow_Table" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_table_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_flow_table_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_flow_table_col_external_ids.type);
}


/* Sets the "flow_limit" column from the "Flow_Table" table in 'row' to
 * the 'flow_limit' set with 'n_flow_limit' entries.
 *
 * 'n_flow_limit' may be 0 or 1; if it is 0, then 'flow_limit'
 * may be NULL.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_add_clause_flow_limit(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *flow_limit, size_t n_flow_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_flow_limit) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *flow_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_table_col_flow_limit,
                          &datum);
}

/* Sets the "groups" column from the "Flow_Table" table in 'row' to
 * the 'groups' set with 'n_groups' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_add_clause_groups(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **groups, size_t n_groups)
{
    struct ovsdb_datum datum;
    datum.n = n_groups;
    datum.keys = n_groups ? xmalloc(n_groups * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_groups; i++) {
        datum.keys[i].string = CONST_CAST(char *, groups[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_table_col_groups,
                          &datum);
    free(datum.keys);
}

/* Sets the "name" column from the "Flow_Table" table in 'row' to
 * the 'name' set.
 *
 * If "name" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_add_clause_name(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (name) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, name);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_table_col_name,
                          &datum);
}

/* Sets the "overflow_policy" column from the "Flow_Table" table in 'row' to
 * the 'overflow_policy' set.
 *
 * If "overflow_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "evict" or "refuse"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_add_clause_overflow_policy(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *overflow_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (overflow_policy) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, overflow_policy);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_table_col_overflow_policy,
                          &datum);
}

/* Sets the "prefixes" column from the "Flow_Table" table in 'row' to
 * the 'prefixes' set with 'n_prefixes' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_add_clause_prefixes(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **prefixes, size_t n_prefixes)
{
    struct ovsdb_datum datum;
    datum.n = n_prefixes;
    datum.keys = n_prefixes ? xmalloc(n_prefixes * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_prefixes; i++) {
        datum.keys[i].string = CONST_CAST(char *, prefixes[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_flow_table_col_prefixes,
                          &datum);
    free(datum.keys);
}

/* Destroy 'row' of kind "Flow_Table". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_flow_table_index_destroy_row(const struct ovsrec_flow_table *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Flow_Table". */
struct ovsrec_flow_table *
ovsrec_flow_table_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_table);
    return ALIGNED_CAST(struct ovsrec_flow_table *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_flow_table *
ovsrec_flow_table_index_find(struct ovsdb_idl_index *index, const struct ovsrec_flow_table *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_table);
    return ovsrec_flow_table_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_flow_table_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_flow_table *a, 
    const struct ovsrec_flow_table *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_flow_table_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_table);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_flow_table_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_flow_table *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_table);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_flow_table_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_flow_table *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_flow_table);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_flow_table *
ovsrec_flow_table_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_flow_table_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "external_ids" column's value from the "Flow_Table" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_flow_table_index_set_external_ids(const struct ovsrec_flow_table *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_flow_table_columns[OVSREC_FLOW_TABLE_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
    free(datum);
}


/* Sets the "flow_limit" column from the "Flow_Table" table in 'row' to
 * the 'flow_limit' set with 'n_flow_limit' entries.
 *
 * 'n_flow_limit' may be 0 or 1; if it is 0, then 'flow_limit'
 * may be NULL.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_index_set_flow_limit(const struct ovsrec_flow_table *row, const int64_t *flow_limit, size_t n_flow_limit)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_flow_limit) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *flow_limit;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_table_columns[ OVSREC_FLOW_TABLE_COL_FLOW_LIMIT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
}

/* Sets the "groups" column from the "Flow_Table" table in 'row' to
 * the 'groups' set with 'n_groups' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_index_set_groups(const struct ovsrec_flow_table *row, const char **groups, size_t n_groups)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_groups;
    datum.keys = n_groups ? xmalloc(n_groups * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_groups; i++) {
        datum.keys[i].string = xstrdup(groups[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_table_columns[ OVSREC_FLOW_TABLE_COL_GROUPS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
}

/* Sets the "name" column from the "Flow_Table" table in 'row' to
 * the 'name' set.
 *
 * If "name" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_index_set_name(const struct ovsrec_flow_table *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (name) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, name);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_table_columns[ OVSREC_FLOW_TABLE_COL_NAME ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
}

/* Sets the "overflow_policy" column from the "Flow_Table" table in 'row' to
 * the 'overflow_policy' set.
 *
 * If "overflow_policy" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "evict" or "refuse"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_index_set_overflow_policy(const struct ovsrec_flow_table *row, const char *overflow_policy)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (overflow_policy) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, overflow_policy);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_table_columns[ OVSREC_FLOW_TABLE_COL_OVERFLOW_POLICY ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
}

/* Sets the "prefixes" column from the "Flow_Table" table in 'row' to
 * the 'prefixes' set with 'n_prefixes' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_flow_table_index_set_prefixes(const struct ovsrec_flow_table *row, const char **prefixes, size_t n_prefixes)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_prefixes;
    datum.keys = n_prefixes ? xmalloc(n_prefixes * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_prefixes; i++) {
        datum.keys[i].string = xstrdup(prefixes[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_flow_table_columns[ OVSREC_FLOW_TABLE_COL_PREFIXES ], &datum, &ovsrec_table_classes[OVSREC_TABLE_FLOW_TABLE]);
}

struct ovsdb_idl_column ovsrec_flow_table_columns[OVSREC_FLOW_TABLE_N_COLUMNS];

unsigned int
ovsrec_flow_table_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_flow_table, condition);
}
static union ovsdb_atom Flow_Table_col_overflow_policy_key_enum_keys[2] = {
    { .string = "evict" },
    { .string = "refuse" },
};
static struct ovsdb_datum Flow_Table_col_overflow_policy_key_enum = {
    .n = 2,
    .keys = Flow_Table_col_overflow_policy_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_flow_table_columns[OVSREC_FLOW_TABLE_N_COLUMNS] = {
    [OVSREC_FLOW_TABLE_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_external_ids,
         .unparse = ovsrec_flow_table_unparse_external_ids,
    },

    [OVSREC_FLOW_TABLE_COL_FLOW_LIMIT] = {
         .name = "flow_limit",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_flow_limit,
         .unparse = ovsrec_flow_table_unparse_flow_limit,
    },

    [OVSREC_FLOW_TABLE_COL_GROUPS] = {
         .name = "groups",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_groups,
         .unparse = ovsrec_flow_table_unparse_groups,
    },

    [OVSREC_FLOW_TABLE_COL_NAME] = {
         .name = "name",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_name,
         .unparse = ovsrec_flow_table_unparse_name,
    },

    [OVSREC_FLOW_TABLE_COL_OVERFLOW_POLICY] = {
         .name = "overflow_policy",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Flow_Table_col_overflow_policy_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_overflow_policy,
         .unparse = ovsrec_flow_table_unparse_overflow_policy,
    },

    [OVSREC_FLOW_TABLE_COL_PREFIXES] = {
         .name = "prefixes",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 3,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_flow_table_parse_prefixes,
         .unparse = ovsrec_flow_table_unparse_prefixes,
    },

};

/* IPFIX table. */

const struct ovsrec_ipfix_table *
ovsrec_ipfix_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_ipfix_table *) idl;
}

const struct ovsrec_ipfix *
ovsrec_ipfix_table_first(const struct ovsrec_ipfix_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ipfix_first(idl);
}


const struct ovsrec_ipfix *
ovsrec_ipfix_table_track_get_first(const struct ovsrec_ipfix_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_ipfix_track_get_first(idl);
}


static void
ovsrec_ipfix_parse_cache_active_timeout(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cache_active_timeout = NULL;
    row->n_cache_active_timeout = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cache_active_timeout) {
            row->cache_active_timeout = xmalloc(n * sizeof *row->cache_active_timeout);
        }
        row->cache_active_timeout[row->n_cache_active_timeout] = datum->keys[i].integer;
        row->n_cache_active_timeout++;
    }
}

static void
ovsrec_ipfix_parse_cache_max_flows(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cache_max_flows = NULL;
    row->n_cache_max_flows = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cache_max_flows) {
            row->cache_max_flows = xmalloc(n * sizeof *row->cache_max_flows);
        }
        row->cache_max_flows[row->n_cache_max_flows] = datum->keys[i].integer;
        row->n_cache_max_flows++;
    }
}

static void
ovsrec_ipfix_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_ipfix_parse_obs_domain_id(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    size_t n = MIN(1, datum->n);
    row->obs_domain_id = NULL;
    row->n_obs_domain_id = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_obs_domain_id) {
            row->obs_domain_id = xmalloc(n * sizeof *row->obs_domain_id);
        }
        row->obs_domain_id[row->n_obs_domain_id] = datum->keys[i].integer;
        row->n_obs_domain_id++;
    }
}

static void
ovsrec_ipfix_parse_obs_point_id(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    size_t n = MIN(1, datum->n);
    row->obs_point_id = NULL;
    row->n_obs_point_id = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_obs_point_id) {
            row->obs_point_id = xmalloc(n * sizeof *row->obs_point_id);
        }
        row->obs_point_id[row->n_obs_point_id] = datum->keys[i].integer;
        row->n_obs_point_id++;
    }
}

static void
ovsrec_ipfix_parse_other_config(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    smap_init(&row->other_config);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->other_config,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_ipfix_parse_sampling(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    size_t n = MIN(1, datum->n);
    row->sampling = NULL;
    row->n_sampling = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_sampling) {
            row->sampling = xmalloc(n * sizeof *row->sampling);
        }
        row->sampling[row->n_sampling] = datum->keys[i].integer;
        row->n_sampling++;
    }
}

static void
ovsrec_ipfix_parse_targets(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    row->targets = NULL;
    row->n_targets = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_targets) {
            row->targets = xmalloc(datum->n * sizeof *row->targets);
        }
        row->targets[row->n_targets] = datum->keys[i].string;
        row->n_targets++;
    }
}

static void
ovsrec_ipfix_unparse_cache_active_timeout(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->cache_active_timeout);
}

static void
ovsrec_ipfix_unparse_cache_max_flows(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->cache_max_flows);
}

static void
ovsrec_ipfix_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_ipfix_unparse_obs_domain_id(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->obs_domain_id);
}

static void
ovsrec_ipfix_unparse_obs_point_id(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->obs_point_id);
}

static void
ovsrec_ipfix_unparse_other_config(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    smap_destroy(&row->other_config);
}

static void
ovsrec_ipfix_unparse_sampling(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->sampling);
}

static void
ovsrec_ipfix_unparse_targets(struct ovsdb_idl_row *row_)
{
    struct ovsrec_ipfix *row = ovsrec_ipfix_cast(row_);
    free(row->targets);
}

static void
ovsrec_ipfix_init__(struct ovsdb_idl_row *row)
{
    ovsrec_ipfix_init(ovsrec_ipfix_cast(row));
}

/* Clears the contents of 'row' in table "IPFIX". */
void
ovsrec_ipfix_init(struct ovsrec_ipfix *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
    smap_init(&row->other_config);
}

/* Searches table "IPFIX" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ipfix *
ovsrec_ipfix_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_ipfix_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_ipfix, uuid));
}

/* Searches table "IPFIX" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_ipfix *
ovsrec_ipfix_table_get_for_uuid(const struct ovsrec_ipfix_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_ipfix_get_for_uuid(idl, uuid);
}

/* Returns a row in table "IPFIX" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_ipfix *
ovsrec_ipfix_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ipfix_cast(ovsdb_idl_first_row(idl, &ovsrec_table_ipfix));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_ipfix *
ovsrec_ipfix_next(const struct ovsrec_ipfix *row)
{
    return ovsrec_ipfix_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_ipfix_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_ipfix);
}

unsigned int ovsrec_ipfix_row_get_seqno(const struct ovsrec_ipfix *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_ipfix *
ovsrec_ipfix_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_ipfix_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_ipfix));
}

const struct ovsrec_ipfix
*ovsrec_ipfix_track_get_next(const struct ovsrec_ipfix *row)
{
    return ovsrec_ipfix_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "IPFIX".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_delete(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "IPFIX" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_ipfix *
ovsrec_ipfix_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_ipfix_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_ipfix, NULL));
}

bool
ovsrec_ipfix_is_updated(const struct ovsrec_ipfix *row, enum ovsrec_ipfix_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_ipfix_columns[column]);
}

/* Causes the original contents of column "cache_active_timeout" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cache_active_timeout" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cache_active_timeout" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cache_active_timeout" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "cache_active_timeout" has already been modified (with
 *     ovsrec_ipfix_set_cache_active_timeout()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_cache_active_timeout() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_cache_active_timeout(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_cache_active_timeout);
}

/* Causes the original contents of column "cache_max_flows" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cache_max_flows" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cache_max_flows" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cache_max_flows" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "cache_max_flows" has already been modified (with
 *     ovsrec_ipfix_set_cache_max_flows()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_cache_max_flows() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_cache_max_flows(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_cache_max_flows);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_ipfix_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_external_ids(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_external_ids);
}

/* Causes the original contents of column "obs_domain_id" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "obs_domain_id" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "obs_domain_id" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "obs_domain_id" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "obs_domain_id" has already been modified (with
 *     ovsrec_ipfix_set_obs_domain_id()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_obs_domain_id() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_obs_domain_id(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_obs_domain_id);
}

/* Causes the original contents of column "obs_point_id" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "obs_point_id" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "obs_point_id" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "obs_point_id" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "obs_point_id" has already been modified (with
 *     ovsrec_ipfix_set_obs_point_id()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_obs_point_id() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_obs_point_id(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_obs_point_id);
}

/* Causes the original contents of column "other_config" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "other_config" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "other_config" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "other_config" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "other_config" has already been modified (with
 *     ovsrec_ipfix_set_other_config()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_other_config() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_other_config(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_other_config);
}

/* Causes the original contents of column "sampling" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "sampling" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "sampling" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "sampling" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "sampling" has already been modified (with
 *     ovsrec_ipfix_set_sampling()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_sampling() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_sampling(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_sampling);
}

/* Causes the original contents of column "targets" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "targets" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "targets" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "targets" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_ipfix_insert()).
 *
 *   - If "targets" has already been modified (with
 *     ovsrec_ipfix_set_targets()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_ipfix_set_targets() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_ipfix_verify_targets(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_ipfix_col_targets);
}

/* Returns the "cache_active_timeout" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cache_active_timeout's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cache_active_timeout" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_cache_active_timeout(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_cache_active_timeout);
}

/* Returns the "cache_max_flows" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cache_max_flows's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cache_max_flows" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_cache_max_flows(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_cache_max_flows);
}

/* Returns the "external_ids" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_external_ids(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_external_ids);
}

/* Returns the "obs_domain_id" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes obs_domain_id's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "obs_domain_id" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_obs_domain_id(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_obs_domain_id);
}

/* Returns the "obs_point_id" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes obs_point_id's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "obs_point_id" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_obs_point_id(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_obs_point_id);
}

/* Returns the "other_config" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes other_config's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "other_config" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_other_config(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_other_config);
}

/* Returns the "sampling" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes sampling's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "sampling" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_sampling(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_sampling);
}

/* Returns the "targets" column's value from the "IPFIX" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes targets's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "targets" member in ovsrec_ipfix. */
const struct ovsdb_datum *
ovsrec_ipfix_get_targets(const struct ovsrec_ipfix *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_ipfix_col_targets);
}

/* Sets the "cache_active_timeout" column from the "IPFIX" table in 'row' to
 * the 'cache_active_timeout' set with 'n_cache_active_timeout' entries.
 *
 * 'n_cache_active_timeout' may be 0 or 1; if it is 0, then 'cache_active_timeout'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,200
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_cache_active_timeout(const struct ovsrec_ipfix *row, const int64_t *cache_active_timeout, size_t n_cache_active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cache_active_timeout) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cache_active_timeout;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ipfix_col_cache_active_timeout, &datum);
}

/* Sets the "cache_max_flows" column from the "IPFIX" table in 'row' to
 * the 'cache_max_flows' set with 'n_cache_max_flows' entries.
 *
 * 'n_cache_max_flows' may be 0 or 1; if it is 0, then 'cache_max_flows'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_cache_max_flows(const struct ovsrec_ipfix *row, const int64_t *cache_max_flows, size_t n_cache_max_flows)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cache_max_flows) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cache_max_flows;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ipfix_col_cache_max_flows, &datum);
}

/* Sets the "external_ids" column's value from the "IPFIX" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ipfix_set_external_ids(const struct ovsrec_ipfix *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_ipfix_col_external_ids,
                        &datum);
}


/* Sets the "obs_domain_id" column from the "IPFIX" table in 'row' to
 * the 'obs_domain_id' set with 'n_obs_domain_id' entries.
 *
 * 'n_obs_domain_id' may be 0 or 1; if it is 0, then 'obs_domain_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_obs_domain_id(const struct ovsrec_ipfix *row, const int64_t *obs_domain_id, size_t n_obs_domain_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_obs_domain_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *obs_domain_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ipfix_col_obs_domain_id, &datum);
}

/* Sets the "obs_point_id" column from the "IPFIX" table in 'row' to
 * the 'obs_point_id' set with 'n_obs_point_id' entries.
 *
 * 'n_obs_point_id' may be 0 or 1; if it is 0, then 'obs_point_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_obs_point_id(const struct ovsrec_ipfix *row, const int64_t *obs_point_id, size_t n_obs_point_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_obs_point_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *obs_point_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ipfix_col_obs_point_id, &datum);
}

/* Sets the "other_config" column's value from the "IPFIX" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_ipfix_set_other_config(const struct ovsrec_ipfix *row, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_ipfix_col_other_config,
                        &datum);
}


/* Sets the "sampling" column from the "IPFIX" table in 'row' to
 * the 'sampling' set with 'n_sampling' entries.
 *
 * 'n_sampling' may be 0 or 1; if it is 0, then 'sampling'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_sampling(const struct ovsrec_ipfix *row, const int64_t *sampling, size_t n_sampling)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_sampling) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *sampling;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_ipfix_col_sampling, &datum);
}

/* Sets the "targets" column from the "IPFIX" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_set_targets(const struct ovsrec_ipfix *row, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;

    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_targets; i++) {
        datum.keys[i].string = xstrdup(targets[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_ipfix_col_targets, &datum);
}

/* Adds the value 'new_value' to the "cache_active_timeout" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_cache_active_timeout_addvalue(const struct ovsrec_ipfix *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_cache_active_timeout,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cache_active_timeout" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_cache_active_timeout_delvalue(const struct ovsrec_ipfix *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_cache_active_timeout,
                                    datum);
}

/* Adds the value 'new_value' to the "cache_max_flows" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_cache_max_flows_addvalue(const struct ovsrec_ipfix *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_cache_max_flows,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cache_max_flows" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_cache_max_flows_delvalue(const struct ovsrec_ipfix *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_cache_max_flows,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "IPFIX" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_ipfix_update_external_ids_setkey(const struct ovsrec_ipfix *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_ipfix_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "IPFIX" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_ipfix_update_external_ids_delkey(const struct ovsrec_ipfix *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_ipfix_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "obs_domain_id" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_obs_domain_id_addvalue(const struct ovsrec_ipfix *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_obs_domain_id,
                                    datum);
}

/* Deletes the value 'delete_value' from the "obs_domain_id" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_obs_domain_id_delvalue(const struct ovsrec_ipfix *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_obs_domain_id,
                                    datum);
}

/* Adds the value 'new_value' to the "obs_point_id" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_obs_point_id_addvalue(const struct ovsrec_ipfix *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_obs_point_id,
                                    datum);
}

/* Deletes the value 'delete_value' from the "obs_point_id" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_obs_point_id_delvalue(const struct ovsrec_ipfix *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_obs_point_id,
                                    datum);
}

/* Sets an element of the "other_config" map column from the "IPFIX" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_ipfix_update_other_config_setkey(const struct ovsrec_ipfix *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_ipfix_col_other_config,
                                    datum);
}

/* Deletes an element of the "other_config" map column from the "IPFIX" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_ipfix_update_other_config_delkey(const struct ovsrec_ipfix *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_ipfix_col_other_config,
                                    datum);
}

/* Adds the value 'new_value' to the "sampling" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_sampling_addvalue(const struct ovsrec_ipfix *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_sampling,
                                    datum);
}

/* Deletes the value 'delete_value' from the "sampling" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_sampling_delvalue(const struct ovsrec_ipfix *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_sampling,
                                    datum);
}

/* Adds the value 'new_value' to the "targets" set column from the "IPFIX" table
 * in 'row'.
 *
 */
void
ovsrec_ipfix_update_targets_addvalue(const struct ovsrec_ipfix *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_targets,
                                    datum);
}

/* Deletes the value 'delete_value' from the "targets" set column from the
 * "IPFIX" table in 'row'.
 *
 */
void
ovsrec_ipfix_update_targets_delvalue(const struct ovsrec_ipfix *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_ipfix_col_targets,
                                    datum);
}

/* Sets the "cache_active_timeout" column from the "IPFIX" table in 'row' to
 * the 'cache_active_timeout' set with 'n_cache_active_timeout' entries.
 *
 * 'n_cache_active_timeout' may be 0 or 1; if it is 0, then 'cache_active_timeout'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,200
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_cache_active_timeout(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cache_active_timeout, size_t n_cache_active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cache_active_timeout) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cache_active_timeout;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_cache_active_timeout,
                          &datum);
}

/* Sets the "cache_max_flows" column from the "IPFIX" table in 'row' to
 * the 'cache_max_flows' set with 'n_cache_max_flows' entries.
 *
 * 'n_cache_max_flows' may be 0 or 1; if it is 0, then 'cache_max_flows'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_cache_max_flows(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cache_max_flows, size_t n_cache_max_flows)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cache_max_flows) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cache_max_flows;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_cache_max_flows,
                          &datum);
}

/* Sets the "external_ids" column's value from the "IPFIX" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ipfix_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_ipfix_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_ipfix_col_external_ids.type);
}


/* Sets the "obs_domain_id" column from the "IPFIX" table in 'row' to
 * the 'obs_domain_id' set with 'n_obs_domain_id' entries.
 *
 * 'n_obs_domain_id' may be 0 or 1; if it is 0, then 'obs_domain_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_obs_domain_id(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *obs_domain_id, size_t n_obs_domain_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_obs_domain_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *obs_domain_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_obs_domain_id,
                          &datum);
}

/* Sets the "obs_point_id" column from the "IPFIX" table in 'row' to
 * the 'obs_point_id' set with 'n_obs_point_id' entries.
 *
 * 'n_obs_point_id' may be 0 or 1; if it is 0, then 'obs_point_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_obs_point_id(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *obs_point_id, size_t n_obs_point_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_obs_point_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *obs_point_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_obs_point_id,
                          &datum);
}

/* Sets the "other_config" column's value from the "IPFIX" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_ipfix_add_clause_other_config(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_ipfix_col_other_config,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_ipfix_col_other_config.type);
}


/* Sets the "sampling" column from the "IPFIX" table in 'row' to
 * the 'sampling' set with 'n_sampling' entries.
 *
 * 'n_sampling' may be 0 or 1; if it is 0, then 'sampling'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_sampling(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *sampling, size_t n_sampling)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_sampling) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *sampling;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_sampling,
                          &datum);
}

/* Sets the "targets" column from the "IPFIX" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_add_clause_targets(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;
    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_targets; i++) {
        datum.keys[i].string = CONST_CAST(char *, targets[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_ipfix_col_targets,
                          &datum);
    free(datum.keys);
}

/* Destroy 'row' of kind "IPFIX". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_ipfix_index_destroy_row(const struct ovsrec_ipfix *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "IPFIX". */
struct ovsrec_ipfix *
ovsrec_ipfix_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ipfix);
    return ALIGNED_CAST(struct ovsrec_ipfix *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_ipfix *
ovsrec_ipfix_index_find(struct ovsdb_idl_index *index, const struct ovsrec_ipfix *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ipfix);
    return ovsrec_ipfix_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_ipfix_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_ipfix *a, 
    const struct ovsrec_ipfix *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_ipfix_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ipfix);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_ipfix_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_ipfix *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ipfix);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_ipfix_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_ipfix *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_ipfix);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_ipfix *
ovsrec_ipfix_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_ipfix_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "cache_active_timeout" column from the "IPFIX" table in 'row' to
 * the 'cache_active_timeout' set with 'n_cache_active_timeout' entries.
 *
 * 'n_cache_active_timeout' may be 0 or 1; if it is 0, then 'cache_active_timeout'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,200
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_cache_active_timeout(const struct ovsrec_ipfix *row, const int64_t *cache_active_timeout, size_t n_cache_active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cache_active_timeout) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *cache_active_timeout;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_CACHE_ACTIVE_TIMEOUT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

/* Sets the "cache_max_flows" column from the "IPFIX" table in 'row' to
 * the 'cache_max_flows' set with 'n_cache_max_flows' entries.
 *
 * 'n_cache_max_flows' may be 0 or 1; if it is 0, then 'cache_max_flows'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_cache_max_flows(const struct ovsrec_ipfix *row, const int64_t *cache_max_flows, size_t n_cache_max_flows)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cache_max_flows) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *cache_max_flows;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_CACHE_MAX_FLOWS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

/* Sets the "external_ids" column's value from the "IPFIX" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_ipfix_index_set_external_ids(const struct ovsrec_ipfix *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_ipfix_columns[OVSREC_IPFIX_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
    free(datum);
}


/* Sets the "obs_domain_id" column from the "IPFIX" table in 'row' to
 * the 'obs_domain_id' set with 'n_obs_domain_id' entries.
 *
 * 'n_obs_domain_id' may be 0 or 1; if it is 0, then 'obs_domain_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_obs_domain_id(const struct ovsrec_ipfix *row, const int64_t *obs_domain_id, size_t n_obs_domain_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_obs_domain_id) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *obs_domain_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_OBS_DOMAIN_ID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

/* Sets the "obs_point_id" column from the "IPFIX" table in 'row' to
 * the 'obs_point_id' set with 'n_obs_point_id' entries.
 *
 * 'n_obs_point_id' may be 0 or 1; if it is 0, then 'obs_point_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_obs_point_id(const struct ovsrec_ipfix *row, const int64_t *obs_point_id, size_t n_obs_point_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_obs_point_id) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *obs_point_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_OBS_POINT_ID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

/* Sets the "other_config" column's value from the "IPFIX" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_ipfix_index_set_other_config(const struct ovsrec_ipfix *row, const struct smap *other_config)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (other_config) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(other_config);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, other_config) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_ipfix_columns[OVSREC_IPFIX_COL_OTHER_CONFIG],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
    free(datum);
}


/* Sets the "sampling" column from the "IPFIX" table in 'row' to
 * the 'sampling' set with 'n_sampling' entries.
 *
 * 'n_sampling' may be 0 or 1; if it is 0, then 'sampling'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_sampling(const struct ovsrec_ipfix *row, const int64_t *sampling, size_t n_sampling)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_sampling) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *sampling;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_SAMPLING ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

/* Sets the "targets" column from the "IPFIX" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_ipfix_index_set_targets(const struct ovsrec_ipfix *row, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_targets; i++) {
        datum.keys[i].string = xstrdup(targets[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_ipfix_columns[ OVSREC_IPFIX_COL_TARGETS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_IPFIX]);
}

struct ovsdb_idl_column ovsrec_ipfix_columns[OVSREC_IPFIX_N_COLUMNS];

unsigned int
ovsrec_ipfix_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_ipfix, condition);
}

struct ovsdb_idl_column ovsrec_ipfix_columns[OVSREC_IPFIX_N_COLUMNS] = {
    [OVSREC_IPFIX_COL_CACHE_ACTIVE_TIMEOUT] = {
         .name = "cache_active_timeout",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4200) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_cache_active_timeout,
         .unparse = ovsrec_ipfix_unparse_cache_active_timeout,
    },

    [OVSREC_IPFIX_COL_CACHE_MAX_FLOWS] = {
         .name = "cache_max_flows",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_cache_max_flows,
         .unparse = ovsrec_ipfix_unparse_cache_max_flows,
    },

    [OVSREC_IPFIX_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_external_ids,
         .unparse = ovsrec_ipfix_unparse_external_ids,
    },

    [OVSREC_IPFIX_COL_OBS_DOMAIN_ID] = {
         .name = "obs_domain_id",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_obs_domain_id,
         .unparse = ovsrec_ipfix_unparse_obs_domain_id,
    },

    [OVSREC_IPFIX_COL_OBS_POINT_ID] = {
         .name = "obs_point_id",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_obs_point_id,
         .unparse = ovsrec_ipfix_unparse_obs_point_id,
    },

    [OVSREC_IPFIX_COL_OTHER_CONFIG] = {
         .name = "other_config",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_other_config,
         .unparse = ovsrec_ipfix_unparse_other_config,
    },

    [OVSREC_IPFIX_COL_SAMPLING] = {
         .name = "sampling",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_sampling,
         .unparse = ovsrec_ipfix_unparse_sampling,
    },

    [OVSREC_IPFIX_COL_TARGETS] = {
         .name = "targets",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_ipfix_parse_targets,
         .unparse = ovsrec_ipfix_unparse_targets,
    },

};

/* Interface table. */

const struct ovsrec_interface_table *
ovsrec_interface_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_interface_table *) idl;
}

const struct ovsrec_interface *
ovsrec_interface_table_first(const struct ovsrec_interface_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_interface_first(idl);
}


const struct ovsrec_interface *
ovsrec_interface_table_track_get_first(const struct ovsrec_interface_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_interface_track_get_first(idl);
}


static void
ovsrec_interface_parse_admin_state(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->admin_state = datum->keys[0].string;
    } else {
        row->admin_state = NULL;
    }
}

static void
ovsrec_interface_parse_bfd(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->bfd);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->bfd,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_bfd_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->bfd_status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->bfd_status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_cfm_fault(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cfm_fault = NULL;
    row->n_cfm_fault = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cfm_fault) {
            row->cfm_fault = xmalloc(n * sizeof *row->cfm_fault);
        }
        row->cfm_fault[row->n_cfm_fault] = datum->keys[i].boolean;
        row->n_cfm_fault++;
    }
}

static void
ovsrec_interface_parse_cfm_fault_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    row->cfm_fault_status = NULL;
    row->n_cfm_fault_status = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_cfm_fault_status) {
            row->cfm_fault_status = xmalloc(datum->n * sizeof *row->cfm_fault_status);
        }
        row->cfm_fault_status[row->n_cfm_fault_status] = datum->keys[i].string;
        row->n_cfm_fault_status++;
    }
}

static void
ovsrec_interface_parse_cfm_flap_count(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cfm_flap_count = NULL;
    row->n_cfm_flap_count = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cfm_flap_count) {
            row->cfm_flap_count = xmalloc(n * sizeof *row->cfm_flap_count);
        }
        row->cfm_flap_count[row->n_cfm_flap_count] = datum->keys[i].integer;
        row->n_cfm_flap_count++;
    }
}

static void
ovsrec_interface_parse_cfm_health(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cfm_health = NULL;
    row->n_cfm_health = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cfm_health) {
            row->cfm_health = xmalloc(n * sizeof *row->cfm_health);
        }
        row->cfm_health[row->n_cfm_health] = datum->keys[i].integer;
        row->n_cfm_health++;
    }
}

static void
ovsrec_interface_parse_cfm_mpid(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->cfm_mpid = NULL;
    row->n_cfm_mpid = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_cfm_mpid) {
            row->cfm_mpid = xmalloc(n * sizeof *row->cfm_mpid);
        }
        row->cfm_mpid[row->n_cfm_mpid] = datum->keys[i].integer;
        row->n_cfm_mpid++;
    }
}

static void
ovsrec_interface_parse_cfm_remote_mpids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    row->cfm_remote_mpids = NULL;
    row->n_cfm_remote_mpids = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_cfm_remote_mpids) {
            row->cfm_remote_mpids = xmalloc(datum->n * sizeof *row->cfm_remote_mpids);
        }
        row->cfm_remote_mpids[row->n_cfm_remote_mpids] = datum->keys[i].integer;
        row->n_cfm_remote_mpids++;
    }
}

static void
ovsrec_interface_parse_cfm_remote_opstate(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->cfm_remote_opstate = datum->keys[0].string;
    } else {
        row->cfm_remote_opstate = NULL;
    }
}

static void
ovsrec_interface_parse_duplex(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->duplex = datum->keys[0].string;
    } else {
        row->duplex = NULL;
    }
}

static void
ovsrec_interface_parse_error(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->error = datum->keys[0].string;
    } else {
        row->error = NULL;
    }
}

static void
ovsrec_interface_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_ifindex(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->ifindex = NULL;
    row->n_ifindex = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_ifindex) {
            row->ifindex = xmalloc(n * sizeof *row->ifindex);
        }
        row->ifindex[row->n_ifindex] = datum->keys[i].integer;
        row->n_ifindex++;
    }
}

static void
ovsrec_interface_parse_ingress_policing_burst(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->ingress_policing_burst = datum->keys[0].integer;
    } else {
        row->ingress_policing_burst = 0;
    }
}

static void
ovsrec_interface_parse_ingress_policing_kpkts_burst(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->ingress_policing_kpkts_burst = datum->keys[0].integer;
    } else {
        row->ingress_policing_kpkts_burst = 0;
    }
}

static void
ovsrec_interface_parse_ingress_policing_kpkts_rate(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->ingress_policing_kpkts_rate = datum->keys[0].integer;
    } else {
        row->ingress_policing_kpkts_rate = 0;
    }
}

static void
ovsrec_interface_parse_ingress_policing_rate(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->ingress_policing_rate = datum->keys[0].integer;
    } else {
        row->ingress_policing_rate = 0;
    }
}

static void
ovsrec_interface_parse_lacp_current(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->lacp_current = NULL;
    row->n_lacp_current = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_lacp_current) {
            row->lacp_current = xmalloc(n * sizeof *row->lacp_current);
        }
        row->lacp_current[row->n_lacp_current] = datum->keys[i].boolean;
        row->n_lacp_current++;
    }
}

static void
ovsrec_interface_parse_link_resets(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->link_resets = NULL;
    row->n_link_resets = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_link_resets) {
            row->link_resets = xmalloc(n * sizeof *row->link_resets);
        }
        row->link_resets[row->n_link_resets] = datum->keys[i].integer;
        row->n_link_resets++;
    }
}

static void
ovsrec_interface_parse_link_speed(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->link_speed = NULL;
    row->n_link_speed = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_link_speed) {
            row->link_speed = xmalloc(n * sizeof *row->link_speed);
        }
        row->link_speed[row->n_link_speed] = datum->keys[i].integer;
        row->n_link_speed++;
    }
}

static void
ovsrec_interface_parse_link_state(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->link_state = datum->keys[0].string;
    } else {
        row->link_state = NULL;
    }
}

static void
ovsrec_interface_parse_lldp(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->lldp);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->lldp,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_mac(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->mac = datum->keys[0].string;
    } else {
        row->mac = NULL;
    }
}

static void
ovsrec_interface_parse_mac_in_use(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->mac_in_use = datum->keys[0].string;
    } else {
        row->mac_in_use = NULL;
    }
}

static void
ovsrec_interface_parse_mtu(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->mtu = NULL;
    row->n_mtu = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_mtu) {
            row->mtu = xmalloc(n * sizeof *row->mtu);
        }
        row->mtu[row->n_mtu] = datum->keys[i].integer;
        row->n_mtu++;
    }
}

static void
ovsrec_interface_parse_mtu_request(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->mtu_request = NULL;
    row->n_mtu_request = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_mtu_request) {
            row->mtu_request = xmalloc(n * sizeof *row->mtu_request);
        }
        row->mtu_request[row->n_mtu_request] = datum->keys[i].integer;
        row->n_mtu_request++;
    }
}

static void
ovsrec_interface_parse_name(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->name = datum->keys[0].string;
    } else {
        row->name = "";
    }
}

static void
ovsrec_interface_parse_ofport(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->ofport = NULL;
    row->n_ofport = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_ofport) {
            row->ofport = xmalloc(n * sizeof *row->ofport);
        }
        row->ofport[row->n_ofport] = datum->keys[i].integer;
        row->n_ofport++;
    }
}

static void
ovsrec_interface_parse_ofport_request(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    size_t n = MIN(1, datum->n);
    row->ofport_request = NULL;
    row->n_ofport_request = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_ofport_request) {
            row->ofport_request = xmalloc(n * sizeof *row->ofport_request);
        }
        row->ofport_request[row->n_ofport_request] = datum->keys[i].integer;
        row->n_ofport_request++;
    }
}

static void
ovsrec_interface_parse_options(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->options);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->options,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_other_config(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->other_config);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->other_config,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_statistics(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    row->key_statistics = NULL;
    row->value_statistics = NULL;
    row->n_statistics = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_statistics) {
            row->key_statistics = xmalloc(datum->n * sizeof *row->key_statistics);
            row->value_statistics = xmalloc(datum->n * sizeof *row->value_statistics);
        }
        row->key_statistics[row->n_statistics] = datum->keys[i].string;
        row->value_statistics[row->n_statistics] = datum->values[i].integer;
        row->n_statistics++;
    }
}

static void
ovsrec_interface_parse_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_init(&row->status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_interface_parse_type(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);

    if (datum->n >= 1) {
        row->type = datum->keys[0].string;
    } else {
        row->type = "";
    }
}

static void
ovsrec_interface_unparse_admin_state(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_bfd(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->bfd);
}

static void
ovsrec_interface_unparse_bfd_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->bfd_status);
}

static void
ovsrec_interface_unparse_cfm_fault(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_fault);
}

static void
ovsrec_interface_unparse_cfm_fault_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_fault_status);
}

static void
ovsrec_interface_unparse_cfm_flap_count(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_flap_count);
}

static void
ovsrec_interface_unparse_cfm_health(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_health);
}

static void
ovsrec_interface_unparse_cfm_mpid(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_mpid);
}

static void
ovsrec_interface_unparse_cfm_remote_mpids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->cfm_remote_mpids);
}

static void
ovsrec_interface_unparse_cfm_remote_opstate(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_duplex(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_error(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_interface_unparse_ifindex(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->ifindex);
}

static void
ovsrec_interface_unparse_ingress_policing_burst(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_ingress_policing_kpkts_burst(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_ingress_policing_kpkts_rate(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_ingress_policing_rate(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_lacp_current(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->lacp_current);
}

static void
ovsrec_interface_unparse_link_resets(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->link_resets);
}

static void
ovsrec_interface_unparse_link_speed(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->link_speed);
}

static void
ovsrec_interface_unparse_link_state(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_lldp(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->lldp);
}

static void
ovsrec_interface_unparse_mac(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_mac_in_use(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_mtu(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->mtu);
}

static void
ovsrec_interface_unparse_mtu_request(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->mtu_request);
}

static void
ovsrec_interface_unparse_name(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_unparse_ofport(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->ofport);
}

static void
ovsrec_interface_unparse_ofport_request(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->ofport_request);
}

static void
ovsrec_interface_unparse_options(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->options);
}

static void
ovsrec_interface_unparse_other_config(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->other_config);
}

static void
ovsrec_interface_unparse_statistics(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    free(row->key_statistics);
    free(row->value_statistics);
}

static void
ovsrec_interface_unparse_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_interface *row = ovsrec_interface_cast(row_);
    smap_destroy(&row->status);
}

static void
ovsrec_interface_unparse_type(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_interface_init__(struct ovsdb_idl_row *row)
{
    ovsrec_interface_init(ovsrec_interface_cast(row));
}

/* Clears the contents of 'row' in table "Interface". */
void
ovsrec_interface_init(struct ovsrec_interface *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->bfd);
    smap_init(&row->bfd_status);
    smap_init(&row->external_ids);
    smap_init(&row->lldp);
    row->name = "";
    smap_init(&row->options);
    smap_init(&row->other_config);
    smap_init(&row->status);
    row->type = "";
}

/* Searches table "Interface" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_interface *
ovsrec_interface_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_interface_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_interface, uuid));
}

/* Searches table "Interface" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_interface *
ovsrec_interface_table_get_for_uuid(const struct ovsrec_interface_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_interface_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Interface" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_interface *
ovsrec_interface_first(const struct ovsdb_idl *idl)
{
    return ovsrec_interface_cast(ovsdb_idl_first_row(idl, &ovsrec_table_interface));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_interface *
ovsrec_interface_next(const struct ovsrec_interface *row)
{
    return ovsrec_interface_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_interface_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_interface);
}

unsigned int ovsrec_interface_row_get_seqno(const struct ovsrec_interface *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_interface *
ovsrec_interface_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_interface_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_interface));
}

const struct ovsrec_interface
*ovsrec_interface_track_get_next(const struct ovsrec_interface *row)
{
    return ovsrec_interface_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Interface".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_delete(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Interface" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_interface *
ovsrec_interface_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_interface_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_interface, NULL));
}

bool
ovsrec_interface_is_updated(const struct ovsrec_interface *row, enum ovsrec_interface_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_interface_columns[column]);
}

/* Causes the original contents of column "admin_state" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "admin_state" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "admin_state" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "admin_state" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "admin_state" has already been modified (with
 *     ovsrec_interface_set_admin_state()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_admin_state() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_admin_state(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_admin_state);
}

/* Causes the original contents of column "bfd" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "bfd" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "bfd" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "bfd" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "bfd" has already been modified (with
 *     ovsrec_interface_set_bfd()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_bfd() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_bfd(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_bfd);
}

/* Causes the original contents of column "bfd_status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "bfd_status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "bfd_status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "bfd_status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "bfd_status" has already been modified (with
 *     ovsrec_interface_set_bfd_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_bfd_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_bfd_status(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_bfd_status);
}

/* Causes the original contents of column "cfm_fault" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_fault" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_fault" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_fault" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_fault" has already been modified (with
 *     ovsrec_interface_set_cfm_fault()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_fault() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_fault(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_fault);
}

/* Causes the original contents of column "cfm_fault_status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_fault_status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_fault_status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_fault_status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_fault_status" has already been modified (with
 *     ovsrec_interface_set_cfm_fault_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_fault_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_fault_status(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_fault_status);
}

/* Causes the original contents of column "cfm_flap_count" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_flap_count" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_flap_count" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_flap_count" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_flap_count" has already been modified (with
 *     ovsrec_interface_set_cfm_flap_count()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_flap_count() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_flap_count(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_flap_count);
}

/* Causes the original contents of column "cfm_health" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_health" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_health" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_health" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_health" has already been modified (with
 *     ovsrec_interface_set_cfm_health()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_health() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_health(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_health);
}

/* Causes the original contents of column "cfm_mpid" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_mpid" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_mpid" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_mpid" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_mpid" has already been modified (with
 *     ovsrec_interface_set_cfm_mpid()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_mpid() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_mpid(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_mpid);
}

/* Causes the original contents of column "cfm_remote_mpids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_remote_mpids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_remote_mpids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_remote_mpids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_remote_mpids" has already been modified (with
 *     ovsrec_interface_set_cfm_remote_mpids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_remote_mpids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_remote_mpids(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_remote_mpids);
}

/* Causes the original contents of column "cfm_remote_opstate" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "cfm_remote_opstate" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "cfm_remote_opstate" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "cfm_remote_opstate" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "cfm_remote_opstate" has already been modified (with
 *     ovsrec_interface_set_cfm_remote_opstate()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_cfm_remote_opstate() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_cfm_remote_opstate(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_cfm_remote_opstate);
}

/* Causes the original contents of column "duplex" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "duplex" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "duplex" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "duplex" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "duplex" has already been modified (with
 *     ovsrec_interface_set_duplex()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_duplex() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_duplex(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_duplex);
}

/* Causes the original contents of column "error" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "error" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "error" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "error" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "error" has already been modified (with
 *     ovsrec_interface_set_error()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_error() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_error(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_error);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_interface_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_external_ids(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_external_ids);
}

/* Causes the original contents of column "ifindex" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ifindex" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ifindex" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ifindex" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ifindex" has already been modified (with
 *     ovsrec_interface_set_ifindex()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ifindex() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ifindex(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ifindex);
}

/* Causes the original contents of column "ingress_policing_burst" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ingress_policing_burst" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ingress_policing_burst" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ingress_policing_burst" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ingress_policing_burst" has already been modified (with
 *     ovsrec_interface_set_ingress_policing_burst()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ingress_policing_burst() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ingress_policing_burst(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ingress_policing_burst);
}

/* Causes the original contents of column "ingress_policing_kpkts_burst" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ingress_policing_kpkts_burst" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ingress_policing_kpkts_burst" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ingress_policing_kpkts_burst" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ingress_policing_kpkts_burst" has already been modified (with
 *     ovsrec_interface_set_ingress_policing_kpkts_burst()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ingress_policing_kpkts_burst() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ingress_policing_kpkts_burst(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_burst);
}

/* Causes the original contents of column "ingress_policing_kpkts_rate" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ingress_policing_kpkts_rate" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ingress_policing_kpkts_rate" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ingress_policing_kpkts_rate" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ingress_policing_kpkts_rate" has already been modified (with
 *     ovsrec_interface_set_ingress_policing_kpkts_rate()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ingress_policing_kpkts_rate() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ingress_policing_kpkts_rate(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_rate);
}

/* Causes the original contents of column "ingress_policing_rate" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ingress_policing_rate" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ingress_policing_rate" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ingress_policing_rate" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ingress_policing_rate" has already been modified (with
 *     ovsrec_interface_set_ingress_policing_rate()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ingress_policing_rate() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ingress_policing_rate(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ingress_policing_rate);
}

/* Causes the original contents of column "lacp_current" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "lacp_current" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "lacp_current" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "lacp_current" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "lacp_current" has already been modified (with
 *     ovsrec_interface_set_lacp_current()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_lacp_current() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_lacp_current(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_lacp_current);
}

/* Causes the original contents of column "link_resets" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "link_resets" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "link_resets" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "link_resets" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "link_resets" has already been modified (with
 *     ovsrec_interface_set_link_resets()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_link_resets() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_link_resets(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_link_resets);
}

/* Causes the original contents of column "link_speed" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "link_speed" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "link_speed" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "link_speed" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "link_speed" has already been modified (with
 *     ovsrec_interface_set_link_speed()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_link_speed() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_link_speed(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_link_speed);
}

/* Causes the original contents of column "link_state" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "link_state" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "link_state" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "link_state" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "link_state" has already been modified (with
 *     ovsrec_interface_set_link_state()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_link_state() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_link_state(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_link_state);
}

/* Causes the original contents of column "lldp" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "lldp" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "lldp" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "lldp" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "lldp" has already been modified (with
 *     ovsrec_interface_set_lldp()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_lldp() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_lldp(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_lldp);
}

/* Causes the original contents of column "mac" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mac" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mac" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mac" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "mac" has already been modified (with
 *     ovsrec_interface_set_mac()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_mac() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_mac(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_mac);
}

/* Causes the original contents of column "mac_in_use" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mac_in_use" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mac_in_use" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mac_in_use" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "mac_in_use" has already been modified (with
 *     ovsrec_interface_set_mac_in_use()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_mac_in_use() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_mac_in_use(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_mac_in_use);
}

/* Causes the original contents of column "mtu" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mtu" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mtu" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mtu" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "mtu" has already been modified (with
 *     ovsrec_interface_set_mtu()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_mtu() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_mtu(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_mtu);
}

/* Causes the original contents of column "mtu_request" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "mtu_request" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "mtu_request" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "mtu_request" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "mtu_request" has already been modified (with
 *     ovsrec_interface_set_mtu_request()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_mtu_request() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_mtu_request(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_mtu_request);
}

/* Causes the original contents of column "name" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "name" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "name" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "name" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "name" has already been modified (with
 *     ovsrec_interface_set_name()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_name() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_name(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_name);
}

/* Causes the original contents of column "ofport" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ofport" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ofport" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ofport" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ofport" has already been modified (with
 *     ovsrec_interface_set_ofport()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ofport() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ofport(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ofport);
}

/* Causes the original contents of column "ofport_request" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "ofport_request" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "ofport_request" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "ofport_request" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "ofport_request" has already been modified (with
 *     ovsrec_interface_set_ofport_request()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_ofport_request() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_ofport_request(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_ofport_request);
}

/* Causes the original contents of column "options" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "options" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "options" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "options" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "options" has already been modified (with
 *     ovsrec_interface_set_options()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_options() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_options(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_options);
}

/* Causes the original contents of column "other_config" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "other_config" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "other_config" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "other_config" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "other_config" has already been modified (with
 *     ovsrec_interface_set_other_config()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_other_config() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_other_config(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_other_config);
}

/* Causes the original contents of column "statistics" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "statistics" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "statistics" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "statistics" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "statistics" has already been modified (with
 *     ovsrec_interface_set_statistics()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_statistics() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_statistics(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_statistics);
}

/* Causes the original contents of column "status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "status" has already been modified (with
 *     ovsrec_interface_set_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_status(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_status);
}

/* Causes the original contents of column "type" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "type" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "type" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "type" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_interface_insert()).
 *
 *   - If "type" has already been modified (with
 *     ovsrec_interface_set_type()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_interface_set_type() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_interface_verify_type(const struct ovsrec_interface *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_interface_col_type);
}

/* Returns the "admin_state" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes admin_state's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "admin_state" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_admin_state(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_admin_state);
}

/* Returns the "bfd" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes bfd's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "bfd" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_bfd(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_bfd);
}

/* Returns the "bfd_status" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes bfd_status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "bfd_status" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_bfd_status(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_bfd_status);
}

/* Returns the "cfm_fault" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes cfm_fault's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_fault" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_fault(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_fault);
}

/* Returns the "cfm_fault_status" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes cfm_fault_status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_fault_status" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_fault_status(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_fault_status);
}

/* Returns the "cfm_flap_count" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cfm_flap_count's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_flap_count" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_flap_count(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_flap_count);
}

/* Returns the "cfm_health" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cfm_health's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_health" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_health(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_health);
}

/* Returns the "cfm_mpid" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cfm_mpid's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_mpid" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_mpid(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_mpid);
}

/* Returns the "cfm_remote_mpids" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes cfm_remote_mpids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_remote_mpids" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_remote_mpids(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_remote_mpids);
}

/* Returns the "cfm_remote_opstate" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes cfm_remote_opstate's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "cfm_remote_opstate" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_cfm_remote_opstate(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_cfm_remote_opstate);
}

/* Returns the "duplex" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes duplex's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "duplex" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_duplex(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_duplex);
}

/* Returns the "error" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes error's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "error" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_error(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_error);
}

/* Returns the "external_ids" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_external_ids(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_external_ids);
}

/* Returns the "ifindex" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ifindex's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ifindex" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ifindex(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ifindex);
}

/* Returns the "ingress_policing_burst" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ingress_policing_burst's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ingress_policing_burst" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ingress_policing_burst(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ingress_policing_burst);
}

/* Returns the "ingress_policing_kpkts_burst" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ingress_policing_kpkts_burst's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ingress_policing_kpkts_burst" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ingress_policing_kpkts_burst(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_burst);
}

/* Returns the "ingress_policing_kpkts_rate" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ingress_policing_kpkts_rate's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ingress_policing_kpkts_rate" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ingress_policing_kpkts_rate(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_rate);
}

/* Returns the "ingress_policing_rate" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ingress_policing_rate's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ingress_policing_rate" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ingress_policing_rate(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ingress_policing_rate);
}

/* Returns the "lacp_current" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes lacp_current's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "lacp_current" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_lacp_current(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_lacp_current);
}

/* Returns the "link_resets" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes link_resets's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "link_resets" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_link_resets(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_link_resets);
}

/* Returns the "link_speed" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes link_speed's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "link_speed" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_link_speed(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_link_speed);
}

/* Returns the "link_state" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes link_state's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "link_state" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_link_state(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_link_state);
}

/* Returns the "lldp" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes lldp's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "lldp" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_lldp(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_lldp);
}

/* Returns the "mac" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes mac's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mac" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_mac(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_mac);
}

/* Returns the "mac_in_use" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes mac_in_use's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mac_in_use" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_mac_in_use(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_mac_in_use);
}

/* Returns the "mtu" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes mtu's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mtu" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_mtu(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_mtu);
}

/* Returns the "mtu_request" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes mtu_request's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "mtu_request" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_mtu_request(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_mtu_request);
}

/* Returns the "name" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes name's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "name" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_name(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_name);
}

/* Returns the "ofport" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ofport's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ofport" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ofport(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ofport);
}

/* Returns the "ofport_request" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes ofport_request's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "ofport_request" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_ofport_request(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_ofport_request);
}

/* Returns the "options" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes options's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "options" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_options(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_options);
}

/* Returns the "other_config" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes other_config's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "other_config" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_other_config(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_other_config);
}

/* Returns the "statistics" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes statistics's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "statistics" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_statistics(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_statistics);
}

/* Returns the "status" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "status" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_status(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_status);
}

/* Returns the "type" column's value from the "Interface" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes type's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "type" member in ovsrec_interface. */
const struct ovsdb_datum *
ovsrec_interface_get_type(const struct ovsrec_interface *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_interface_col_type);
}

/* Sets the "admin_state" column from the "Interface" table in 'row' to
 * the 'admin_state' set.
 *
 * If "admin_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_admin_state(const struct ovsrec_interface *row, const char *admin_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (admin_state) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, admin_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_admin_state, &datum);
}

/* Sets the "bfd" column's value from the "Interface" table in 'row'
 * to 'bfd'.
 *
 * The caller retains ownership of 'bfd' and everything in it. */
void
ovsrec_interface_set_bfd(const struct ovsrec_interface *row, const struct smap *bfd)
{
    struct ovsdb_datum datum;

    if (bfd) {
        ovsdb_datum_from_smap(&datum, bfd);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_bfd,
                        &datum);
}


/* Sets the "bfd_status" column's value from the "Interface" table in 'row'
 * to 'bfd_status'.
 *
 * The caller retains ownership of 'bfd_status' and everything in it. */
void
ovsrec_interface_set_bfd_status(const struct ovsrec_interface *row, const struct smap *bfd_status)
{
    struct ovsdb_datum datum;

    if (bfd_status) {
        ovsdb_datum_from_smap(&datum, bfd_status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_bfd_status,
                        &datum);
}


/* Sets the "cfm_fault" column from the "Interface" table in 'row' to
 * the 'cfm_fault' set with 'n_cfm_fault' entries.
 *
 * 'n_cfm_fault' may be 0 or 1; if it is 0, then 'cfm_fault'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_fault(const struct ovsrec_interface *row, const bool *cfm_fault, size_t n_cfm_fault)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_fault) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *cfm_fault;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_cfm_fault, &datum);
}

/* Sets the "cfm_fault_status" column from the "Interface" table in 'row' to
 * the 'cfm_fault_status' set with 'n_cfm_fault_status' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_fault_status(const struct ovsrec_interface *row, const char **cfm_fault_status, size_t n_cfm_fault_status)
{
    struct ovsdb_datum datum;

    datum.n = n_cfm_fault_status;
    datum.keys = n_cfm_fault_status ? xmalloc(n_cfm_fault_status * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_cfm_fault_status; i++) {
        datum.keys[i].string = xstrdup(cfm_fault_status[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_interface_col_cfm_fault_status, &datum);
}

/* Sets the "cfm_flap_count" column from the "Interface" table in 'row' to
 * the 'cfm_flap_count' set with 'n_cfm_flap_count' entries.
 *
 * 'n_cfm_flap_count' may be 0 or 1; if it is 0, then 'cfm_flap_count'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_flap_count(const struct ovsrec_interface *row, const int64_t *cfm_flap_count, size_t n_cfm_flap_count)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_flap_count) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_flap_count;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_cfm_flap_count, &datum);
}

/* Sets the "cfm_health" column from the "Interface" table in 'row' to
 * the 'cfm_health' set with 'n_cfm_health' entries.
 *
 * 'n_cfm_health' may be 0 or 1; if it is 0, then 'cfm_health'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_health(const struct ovsrec_interface *row, const int64_t *cfm_health, size_t n_cfm_health)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_health) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_health;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_cfm_health, &datum);
}

/* Sets the "cfm_mpid" column from the "Interface" table in 'row' to
 * the 'cfm_mpid' set with 'n_cfm_mpid' entries.
 *
 * 'n_cfm_mpid' may be 0 or 1; if it is 0, then 'cfm_mpid'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_mpid(const struct ovsrec_interface *row, const int64_t *cfm_mpid, size_t n_cfm_mpid)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_mpid) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_mpid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_cfm_mpid, &datum);
}

/* Sets the "cfm_remote_mpids" column from the "Interface" table in 'row' to
 * the 'cfm_remote_mpids' set with 'n_cfm_remote_mpids' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_remote_mpids(const struct ovsrec_interface *row, const int64_t *cfm_remote_mpids, size_t n_cfm_remote_mpids)
{
    struct ovsdb_datum datum;

    datum.n = n_cfm_remote_mpids;
    datum.keys = n_cfm_remote_mpids ? xmalloc(n_cfm_remote_mpids * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_cfm_remote_mpids; i++) {
        datum.keys[i].integer = cfm_remote_mpids[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_interface_col_cfm_remote_mpids, &datum);
}

/* Sets the "cfm_remote_opstate" column from the "Interface" table in 'row' to
 * the 'cfm_remote_opstate' set.
 *
 * If "cfm_remote_opstate" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_cfm_remote_opstate(const struct ovsrec_interface *row, const char *cfm_remote_opstate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (cfm_remote_opstate) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, cfm_remote_opstate);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_cfm_remote_opstate, &datum);
}

/* Sets the "duplex" column from the "Interface" table in 'row' to
 * the 'duplex' set.
 *
 * If "duplex" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "full" or "half"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_duplex(const struct ovsrec_interface *row, const char *duplex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (duplex) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, duplex);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_duplex, &datum);
}

/* Sets the "error" column from the "Interface" table in 'row' to
 * the 'error' set.
 *
 * If "error" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_error(const struct ovsrec_interface *row, const char *error)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (error) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, error);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_error, &datum);
}

/* Sets the "external_ids" column's value from the "Interface" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_interface_set_external_ids(const struct ovsrec_interface *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_external_ids,
                        &datum);
}


/* Sets the "ifindex" column from the "Interface" table in 'row' to
 * the 'ifindex' set with 'n_ifindex' entries.
 *
 * 'n_ifindex' may be 0 or 1; if it is 0, then 'ifindex'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ifindex(const struct ovsrec_interface *row, const int64_t *ifindex, size_t n_ifindex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ifindex) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ifindex;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ifindex, &datum);
}

/* Sets the "ingress_policing_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ingress_policing_burst(const struct ovsrec_interface *row, int64_t ingress_policing_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_burst;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ingress_policing_burst, &datum);
}

/* Sets the "ingress_policing_kpkts_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ingress_policing_kpkts_burst(const struct ovsrec_interface *row, int64_t ingress_policing_kpkts_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_kpkts_burst;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_burst, &datum);
}

/* Sets the "ingress_policing_kpkts_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ingress_policing_kpkts_rate(const struct ovsrec_interface *row, int64_t ingress_policing_kpkts_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_kpkts_rate;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ingress_policing_kpkts_rate, &datum);
}

/* Sets the "ingress_policing_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ingress_policing_rate(const struct ovsrec_interface *row, int64_t ingress_policing_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_rate;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ingress_policing_rate, &datum);
}

/* Sets the "lacp_current" column from the "Interface" table in 'row' to
 * the 'lacp_current' set with 'n_lacp_current' entries.
 *
 * 'n_lacp_current' may be 0 or 1; if it is 0, then 'lacp_current'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_lacp_current(const struct ovsrec_interface *row, const bool *lacp_current, size_t n_lacp_current)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_lacp_current) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *lacp_current;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_lacp_current, &datum);
}

/* Sets the "link_resets" column from the "Interface" table in 'row' to
 * the 'link_resets' set with 'n_link_resets' entries.
 *
 * 'n_link_resets' may be 0 or 1; if it is 0, then 'link_resets'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_link_resets(const struct ovsrec_interface *row, const int64_t *link_resets, size_t n_link_resets)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_link_resets) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *link_resets;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_link_resets, &datum);
}

/* Sets the "link_speed" column from the "Interface" table in 'row' to
 * the 'link_speed' set with 'n_link_speed' entries.
 *
 * 'n_link_speed' may be 0 or 1; if it is 0, then 'link_speed'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_link_speed(const struct ovsrec_interface *row, const int64_t *link_speed, size_t n_link_speed)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_link_speed) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *link_speed;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_link_speed, &datum);
}

/* Sets the "link_state" column from the "Interface" table in 'row' to
 * the 'link_state' set.
 *
 * If "link_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_link_state(const struct ovsrec_interface *row, const char *link_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (link_state) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, link_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_link_state, &datum);
}

/* Sets the "lldp" column's value from the "Interface" table in 'row'
 * to 'lldp'.
 *
 * The caller retains ownership of 'lldp' and everything in it. */
void
ovsrec_interface_set_lldp(const struct ovsrec_interface *row, const struct smap *lldp)
{
    struct ovsdb_datum datum;

    if (lldp) {
        ovsdb_datum_from_smap(&datum, lldp);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_lldp,
                        &datum);
}


/* Sets the "mac" column from the "Interface" table in 'row' to
 * the 'mac' set.
 *
 * If "mac" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_mac(const struct ovsrec_interface *row, const char *mac)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (mac) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, mac);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_mac, &datum);
}

/* Sets the "mac_in_use" column from the "Interface" table in 'row' to
 * the 'mac_in_use' set.
 *
 * If "mac_in_use" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_mac_in_use(const struct ovsrec_interface *row, const char *mac_in_use)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (mac_in_use) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, mac_in_use);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_mac_in_use, &datum);
}

/* Sets the "mtu" column from the "Interface" table in 'row' to
 * the 'mtu' set with 'n_mtu' entries.
 *
 * 'n_mtu' may be 0 or 1; if it is 0, then 'mtu'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_mtu(const struct ovsrec_interface *row, const int64_t *mtu, size_t n_mtu)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_mtu) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *mtu;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_mtu, &datum);
}

/* Sets the "mtu_request" column from the "Interface" table in 'row' to
 * the 'mtu_request' set with 'n_mtu_request' entries.
 *
 * 'n_mtu_request' may be 0 or 1; if it is 0, then 'mtu_request'
 * may be NULL.
 *
 * Argument constraints: at least 1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_mtu_request(const struct ovsrec_interface *row, const int64_t *mtu_request, size_t n_mtu_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_mtu_request) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *mtu_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_mtu_request, &datum);
}

/* Sets the "name" column from the "Interface" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_name(const struct ovsrec_interface *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_name, &datum);
}

/* Sets the "ofport" column from the "Interface" table in 'row' to
 * the 'ofport' set with 'n_ofport' entries.
 *
 * 'n_ofport' may be 0 or 1; if it is 0, then 'ofport'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ofport(const struct ovsrec_interface *row, const int64_t *ofport, size_t n_ofport)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ofport) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ofport;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ofport, &datum);
}

/* Sets the "ofport_request" column from the "Interface" table in 'row' to
 * the 'ofport_request' set with 'n_ofport_request' entries.
 *
 * 'n_ofport_request' may be 0 or 1; if it is 0, then 'ofport_request'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 65,279
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_ofport_request(const struct ovsrec_interface *row, const int64_t *ofport_request, size_t n_ofport_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ofport_request) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ofport_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_ofport_request, &datum);
}

/* Sets the "options" column's value from the "Interface" table in 'row'
 * to 'options'.
 *
 * The caller retains ownership of 'options' and everything in it. */
void
ovsrec_interface_set_options(const struct ovsrec_interface *row, const struct smap *options)
{
    struct ovsdb_datum datum;

    if (options) {
        ovsdb_datum_from_smap(&datum, options);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_options,
                        &datum);
}


/* Sets the "other_config" column's value from the "Interface" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_interface_set_other_config(const struct ovsrec_interface *row, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_other_config,
                        &datum);
}


/* Sets the "statistics" column from the "Interface" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_statistics(const struct ovsrec_interface *row, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;

    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (size_t i = 0; i < n_statistics; i++) {
        datum.keys[i].string = xstrdup(key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_interface_col_statistics, &datum);
}

/* Sets the "status" column's value from the "Interface" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_interface_set_status(const struct ovsrec_interface *row, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_interface_col_status,
                        &datum);
}


/* Sets the "type" column from the "Interface" table in 'row' to
 * 'type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_set_type(const struct ovsrec_interface *row, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, type);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_interface_col_type, &datum);
}

/* Adds the value 'new_value' to the "admin_state" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_admin_state_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_admin_state,
                                    datum);
}

/* Deletes the value 'delete_value' from the "admin_state" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_admin_state_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_admin_state,
                                    datum);
}

/* Sets an element of the "bfd" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_bfd_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_bfd,
                                    datum);
}

/* Deletes an element of the "bfd" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_bfd_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_bfd,
                                    datum);
}

/* Sets an element of the "bfd_status" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_bfd_status_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_bfd_status,
                                    datum);
}

/* Deletes an element of the "bfd_status" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_bfd_status_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_bfd_status,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_fault" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_fault_addvalue(const struct ovsrec_interface *row, bool new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_fault,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_fault" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_fault_delvalue(const struct ovsrec_interface *row, bool delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_fault,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_fault_status" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_fault_status_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_fault_status,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_fault_status" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_fault_status_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_fault_status,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_flap_count" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_flap_count_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_flap_count,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_flap_count" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_flap_count_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_flap_count,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_health" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_health_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_health,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_health" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_health_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_health,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_mpid" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_mpid_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_mpid,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_mpid" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_mpid_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_mpid,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_remote_mpids" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_remote_mpids_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_remote_mpids,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_remote_mpids" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_remote_mpids_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_remote_mpids,
                                    datum);
}

/* Adds the value 'new_value' to the "cfm_remote_opstate" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_remote_opstate_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_remote_opstate,
                                    datum);
}

/* Deletes the value 'delete_value' from the "cfm_remote_opstate" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_cfm_remote_opstate_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_cfm_remote_opstate,
                                    datum);
}

/* Adds the value 'new_value' to the "duplex" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_duplex_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_duplex,
                                    datum);
}

/* Deletes the value 'delete_value' from the "duplex" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_duplex_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_duplex,
                                    datum);
}

/* Adds the value 'new_value' to the "error" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_error_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_error,
                                    datum);
}

/* Deletes the value 'delete_value' from the "error" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_error_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_error,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_external_ids_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_external_ids_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "ifindex" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_ifindex_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_ifindex,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ifindex" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_ifindex_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_ifindex,
                                    datum);
}

/* Adds the value 'new_value' to the "lacp_current" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_lacp_current_addvalue(const struct ovsrec_interface *row, bool new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_lacp_current,
                                    datum);
}

/* Deletes the value 'delete_value' from the "lacp_current" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_lacp_current_delvalue(const struct ovsrec_interface *row, bool delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].boolean = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_lacp_current,
                                    datum);
}

/* Adds the value 'new_value' to the "link_resets" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_link_resets_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_resets,
                                    datum);
}

/* Deletes the value 'delete_value' from the "link_resets" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_link_resets_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_resets,
                                    datum);
}

/* Adds the value 'new_value' to the "link_speed" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_link_speed_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_speed,
                                    datum);
}

/* Deletes the value 'delete_value' from the "link_speed" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_link_speed_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_speed,
                                    datum);
}

/* Adds the value 'new_value' to the "link_state" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_link_state_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_state,
                                    datum);
}

/* Deletes the value 'delete_value' from the "link_state" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_link_state_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_link_state,
                                    datum);
}

/* Sets an element of the "lldp" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_lldp_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_lldp,
                                    datum);
}

/* Deletes an element of the "lldp" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_lldp_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_lldp,
                                    datum);
}

/* Adds the value 'new_value' to the "mac" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_mac_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_mac,
                                    datum);
}

/* Deletes the value 'delete_value' from the "mac" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_mac_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_mac,
                                    datum);
}

/* Adds the value 'new_value' to the "mac_in_use" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_mac_in_use_addvalue(const struct ovsrec_interface *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_mac_in_use,
                                    datum);
}

/* Deletes the value 'delete_value' from the "mac_in_use" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_mac_in_use_delvalue(const struct ovsrec_interface *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_mac_in_use,
                                    datum);
}

/* Adds the value 'new_value' to the "mtu" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_mtu_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_mtu,
                                    datum);
}

/* Deletes the value 'delete_value' from the "mtu" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_mtu_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_mtu,
                                    datum);
}

/* Adds the value 'new_value' to the "mtu_request" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_mtu_request_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_mtu_request,
                                    datum);
}

/* Deletes the value 'delete_value' from the "mtu_request" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_mtu_request_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_mtu_request,
                                    datum);
}

/* Adds the value 'new_value' to the "ofport" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_ofport_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_ofport,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ofport" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_ofport_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_ofport,
                                    datum);
}

/* Adds the value 'new_value' to the "ofport_request" set column from the "Interface" table
 * in 'row'.
 *
 */
void
ovsrec_interface_update_ofport_request_addvalue(const struct ovsrec_interface *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_interface_col_ofport_request,
                                    datum);
}

/* Deletes the value 'delete_value' from the "ofport_request" set column from the
 * "Interface" table in 'row'.
 *
 */
void
ovsrec_interface_update_ofport_request_delvalue(const struct ovsrec_interface *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_interface_col_ofport_request,
                                    datum);
}

/* Sets an element of the "options" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_options_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_options,
                                    datum);
}

/* Deletes an element of the "options" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_options_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_options,
                                    datum);
}

/* Sets an element of the "other_config" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_other_config_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_other_config,
                                    datum);
}

/* Deletes an element of the "other_config" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_other_config_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_other_config,
                                    datum);
}

/* Sets an element of the "statistics" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_statistics_setkey(const struct ovsrec_interface *row, const char *new_key, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].integer = new_value;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_statistics,
                                    datum);
}

/* Deletes an element of the "statistics" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_statistics_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_statistics,
                                    datum);
}

/* Sets an element of the "status" map column from the "Interface" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_interface_update_status_setkey(const struct ovsrec_interface *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_interface_col_status,
                                    datum);
}

/* Deletes an element of the "status" map column from the "Interface" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_interface_update_status_delkey(const struct ovsrec_interface *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_interface_col_status,
                                    datum);
}

/* Sets the "admin_state" column from the "Interface" table in 'row' to
 * the 'admin_state' set.
 *
 * If "admin_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_admin_state(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *admin_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (admin_state) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, admin_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_admin_state,
                          &datum);
}

/* Sets the "bfd" column's value from the "Interface" table in 'row'
 * to 'bfd'.
 *
 * The caller retains ownership of 'bfd' and everything in it. */
void
ovsrec_interface_add_clause_bfd(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *bfd)
{
    struct ovsdb_datum datum;

    if (bfd) {
        ovsdb_datum_from_smap(&datum, bfd);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_bfd,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_bfd.type);
}


/* Sets the "bfd_status" column's value from the "Interface" table in 'row'
 * to 'bfd_status'.
 *
 * The caller retains ownership of 'bfd_status' and everything in it. */
void
ovsrec_interface_add_clause_bfd_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *bfd_status)
{
    struct ovsdb_datum datum;

    if (bfd_status) {
        ovsdb_datum_from_smap(&datum, bfd_status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_bfd_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_bfd_status.type);
}


/* Sets the "cfm_fault" column from the "Interface" table in 'row' to
 * the 'cfm_fault' set with 'n_cfm_fault' entries.
 *
 * 'n_cfm_fault' may be 0 or 1; if it is 0, then 'cfm_fault'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_fault(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const bool *cfm_fault, size_t n_cfm_fault)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_fault) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *cfm_fault;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_fault,
                          &datum);
}

/* Sets the "cfm_fault_status" column from the "Interface" table in 'row' to
 * the 'cfm_fault_status' set with 'n_cfm_fault_status' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_fault_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **cfm_fault_status, size_t n_cfm_fault_status)
{
    struct ovsdb_datum datum;
    datum.n = n_cfm_fault_status;
    datum.keys = n_cfm_fault_status ? xmalloc(n_cfm_fault_status * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_cfm_fault_status; i++) {
        datum.keys[i].string = CONST_CAST(char *, cfm_fault_status[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_fault_status,
                          &datum);
    free(datum.keys);
}

/* Sets the "cfm_flap_count" column from the "Interface" table in 'row' to
 * the 'cfm_flap_count' set with 'n_cfm_flap_count' entries.
 *
 * 'n_cfm_flap_count' may be 0 or 1; if it is 0, then 'cfm_flap_count'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_flap_count(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cfm_flap_count, size_t n_cfm_flap_count)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_flap_count) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_flap_count;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_flap_count,
                          &datum);
}

/* Sets the "cfm_health" column from the "Interface" table in 'row' to
 * the 'cfm_health' set with 'n_cfm_health' entries.
 *
 * 'n_cfm_health' may be 0 or 1; if it is 0, then 'cfm_health'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_health(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cfm_health, size_t n_cfm_health)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_health) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_health;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_health,
                          &datum);
}

/* Sets the "cfm_mpid" column from the "Interface" table in 'row' to
 * the 'cfm_mpid' set with 'n_cfm_mpid' entries.
 *
 * 'n_cfm_mpid' may be 0 or 1; if it is 0, then 'cfm_mpid'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_mpid(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cfm_mpid, size_t n_cfm_mpid)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_cfm_mpid) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *cfm_mpid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_mpid,
                          &datum);
}

/* Sets the "cfm_remote_mpids" column from the "Interface" table in 'row' to
 * the 'cfm_remote_mpids' set with 'n_cfm_remote_mpids' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_remote_mpids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *cfm_remote_mpids, size_t n_cfm_remote_mpids)
{
    struct ovsdb_datum datum;
    datum.n = n_cfm_remote_mpids;
    datum.keys = n_cfm_remote_mpids ? xmalloc(n_cfm_remote_mpids * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_cfm_remote_mpids; i++) {
        datum.keys[i].integer = cfm_remote_mpids[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_remote_mpids,
                          &datum);
    free(datum.keys);
}

/* Sets the "cfm_remote_opstate" column from the "Interface" table in 'row' to
 * the 'cfm_remote_opstate' set.
 *
 * If "cfm_remote_opstate" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_cfm_remote_opstate(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *cfm_remote_opstate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (cfm_remote_opstate) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, cfm_remote_opstate);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_cfm_remote_opstate,
                          &datum);
}

/* Sets the "duplex" column from the "Interface" table in 'row' to
 * the 'duplex' set.
 *
 * If "duplex" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "full" or "half"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_duplex(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *duplex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (duplex) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, duplex);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_duplex,
                          &datum);
}

/* Sets the "error" column from the "Interface" table in 'row' to
 * the 'error' set.
 *
 * If "error" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_error(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *error)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (error) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, error);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_error,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Interface" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_interface_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_external_ids.type);
}


/* Sets the "ifindex" column from the "Interface" table in 'row' to
 * the 'ifindex' set with 'n_ifindex' entries.
 *
 * 'n_ifindex' may be 0 or 1; if it is 0, then 'ifindex'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ifindex(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *ifindex, size_t n_ifindex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ifindex) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ifindex;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ifindex,
                          &datum);
}

/* Sets the "ingress_policing_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ingress_policing_burst(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t ingress_policing_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_burst;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ingress_policing_burst,
                          &datum);
}

/* Sets the "ingress_policing_kpkts_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ingress_policing_kpkts_burst(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t ingress_policing_kpkts_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_kpkts_burst;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ingress_policing_kpkts_burst,
                          &datum);
}

/* Sets the "ingress_policing_kpkts_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ingress_policing_kpkts_rate(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t ingress_policing_kpkts_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_kpkts_rate;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ingress_policing_kpkts_rate,
                          &datum);
}

/* Sets the "ingress_policing_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ingress_policing_rate(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t ingress_policing_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = ingress_policing_rate;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ingress_policing_rate,
                          &datum);
}

/* Sets the "lacp_current" column from the "Interface" table in 'row' to
 * the 'lacp_current' set with 'n_lacp_current' entries.
 *
 * 'n_lacp_current' may be 0 or 1; if it is 0, then 'lacp_current'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_lacp_current(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const bool *lacp_current, size_t n_lacp_current)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_lacp_current) {
        datum.n = 1;
        datum.keys = &key;
        key.boolean = *lacp_current;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_lacp_current,
                          &datum);
}

/* Sets the "link_resets" column from the "Interface" table in 'row' to
 * the 'link_resets' set with 'n_link_resets' entries.
 *
 * 'n_link_resets' may be 0 or 1; if it is 0, then 'link_resets'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_link_resets(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *link_resets, size_t n_link_resets)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_link_resets) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *link_resets;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_link_resets,
                          &datum);
}

/* Sets the "link_speed" column from the "Interface" table in 'row' to
 * the 'link_speed' set with 'n_link_speed' entries.
 *
 * 'n_link_speed' may be 0 or 1; if it is 0, then 'link_speed'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_link_speed(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *link_speed, size_t n_link_speed)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_link_speed) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *link_speed;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_link_speed,
                          &datum);
}

/* Sets the "link_state" column from the "Interface" table in 'row' to
 * the 'link_state' set.
 *
 * If "link_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_link_state(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *link_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (link_state) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, link_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_link_state,
                          &datum);
}

/* Sets the "lldp" column's value from the "Interface" table in 'row'
 * to 'lldp'.
 *
 * The caller retains ownership of 'lldp' and everything in it. */
void
ovsrec_interface_add_clause_lldp(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *lldp)
{
    struct ovsdb_datum datum;

    if (lldp) {
        ovsdb_datum_from_smap(&datum, lldp);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_lldp,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_lldp.type);
}


/* Sets the "mac" column from the "Interface" table in 'row' to
 * the 'mac' set.
 *
 * If "mac" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_mac(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *mac)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (mac) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, mac);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_mac,
                          &datum);
}

/* Sets the "mac_in_use" column from the "Interface" table in 'row' to
 * the 'mac_in_use' set.
 *
 * If "mac_in_use" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_mac_in_use(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *mac_in_use)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (mac_in_use) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, mac_in_use);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_mac_in_use,
                          &datum);
}

/* Sets the "mtu" column from the "Interface" table in 'row' to
 * the 'mtu' set with 'n_mtu' entries.
 *
 * 'n_mtu' may be 0 or 1; if it is 0, then 'mtu'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_mtu(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *mtu, size_t n_mtu)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_mtu) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *mtu;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_mtu,
                          &datum);
}

/* Sets the "mtu_request" column from the "Interface" table in 'row' to
 * the 'mtu_request' set with 'n_mtu_request' entries.
 *
 * 'n_mtu_request' may be 0 or 1; if it is 0, then 'mtu_request'
 * may be NULL.
 *
 * Argument constraints: at least 1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_mtu_request(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *mtu_request, size_t n_mtu_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_mtu_request) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *mtu_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_mtu_request,
                          &datum);
}

/* Sets the "name" column from the "Interface" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_name(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_name,
                          &datum);
}

/* Sets the "ofport" column from the "Interface" table in 'row' to
 * the 'ofport' set with 'n_ofport' entries.
 *
 * 'n_ofport' may be 0 or 1; if it is 0, then 'ofport'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ofport(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *ofport, size_t n_ofport)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ofport) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ofport;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ofport,
                          &datum);
}

/* Sets the "ofport_request" column from the "Interface" table in 'row' to
 * the 'ofport_request' set with 'n_ofport_request' entries.
 *
 * 'n_ofport_request' may be 0 or 1; if it is 0, then 'ofport_request'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 65,279
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_ofport_request(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *ofport_request, size_t n_ofport_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_ofport_request) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *ofport_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_ofport_request,
                          &datum);
}

/* Sets the "options" column's value from the "Interface" table in 'row'
 * to 'options'.
 *
 * The caller retains ownership of 'options' and everything in it. */
void
ovsrec_interface_add_clause_options(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *options)
{
    struct ovsdb_datum datum;

    if (options) {
        ovsdb_datum_from_smap(&datum, options);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_options,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_options.type);
}


/* Sets the "other_config" column's value from the "Interface" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_interface_add_clause_other_config(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_other_config,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_other_config.type);
}


/* Sets the "statistics" column from the "Interface" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_statistics(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;
    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (size_t i = 0; i < n_statistics; i++) {
        datum.keys[i].string = CONST_CAST(char *, key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_statistics,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Sets the "status" column's value from the "Interface" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_interface_add_clause_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_interface_col_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_interface_col_status.type);
}


/* Sets the "type" column from the "Interface" table in 'row' to
 * 'type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_add_clause_type(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, type);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_interface_col_type,
                          &datum);
}

/* Destroy 'row' of kind "Interface". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_interface_index_destroy_row(const struct ovsrec_interface *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Interface". */
struct ovsrec_interface *
ovsrec_interface_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_interface);
    return ALIGNED_CAST(struct ovsrec_interface *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_interface *
ovsrec_interface_index_find(struct ovsdb_idl_index *index, const struct ovsrec_interface *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_interface);
    return ovsrec_interface_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_interface_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_interface *a, 
    const struct ovsrec_interface *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_interface_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_interface);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_interface_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_interface *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_interface);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_interface_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_interface *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_interface);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_interface *
ovsrec_interface_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_interface_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "admin_state" column from the "Interface" table in 'row' to
 * the 'admin_state' set.
 *
 * If "admin_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_admin_state(const struct ovsrec_interface *row, const char *admin_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (admin_state) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, admin_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_ADMIN_STATE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "bfd" column's value from the "Interface" table in 'row'
 * to 'bfd'.
 *
 * The caller retains ownership of 'bfd' and everything in it. */
void
ovsrec_interface_index_set_bfd(const struct ovsrec_interface *row, const struct smap *bfd)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (bfd) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(bfd);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, bfd) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_BFD],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "bfd_status" column's value from the "Interface" table in 'row'
 * to 'bfd_status'.
 *
 * The caller retains ownership of 'bfd_status' and everything in it. */
void
ovsrec_interface_index_set_bfd_status(const struct ovsrec_interface *row, const struct smap *bfd_status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (bfd_status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(bfd_status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, bfd_status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_BFD_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "cfm_fault" column from the "Interface" table in 'row' to
 * the 'cfm_fault' set with 'n_cfm_fault' entries.
 *
 * 'n_cfm_fault' may be 0 or 1; if it is 0, then 'cfm_fault'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_fault(const struct ovsrec_interface *row, const bool *cfm_fault, size_t n_cfm_fault)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cfm_fault) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->boolean = *cfm_fault;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_FAULT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_fault_status" column from the "Interface" table in 'row' to
 * the 'cfm_fault_status' set with 'n_cfm_fault_status' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_fault_status(const struct ovsrec_interface *row, const char **cfm_fault_status, size_t n_cfm_fault_status)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_cfm_fault_status;
    datum.keys = n_cfm_fault_status ? xmalloc(n_cfm_fault_status * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_cfm_fault_status; i++) {
        datum.keys[i].string = xstrdup(cfm_fault_status[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_FAULT_STATUS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_flap_count" column from the "Interface" table in 'row' to
 * the 'cfm_flap_count' set with 'n_cfm_flap_count' entries.
 *
 * 'n_cfm_flap_count' may be 0 or 1; if it is 0, then 'cfm_flap_count'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_flap_count(const struct ovsrec_interface *row, const int64_t *cfm_flap_count, size_t n_cfm_flap_count)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cfm_flap_count) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *cfm_flap_count;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_FLAP_COUNT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_health" column from the "Interface" table in 'row' to
 * the 'cfm_health' set with 'n_cfm_health' entries.
 *
 * 'n_cfm_health' may be 0 or 1; if it is 0, then 'cfm_health'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 100
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_health(const struct ovsrec_interface *row, const int64_t *cfm_health, size_t n_cfm_health)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cfm_health) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *cfm_health;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_HEALTH ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_mpid" column from the "Interface" table in 'row' to
 * the 'cfm_mpid' set with 'n_cfm_mpid' entries.
 *
 * 'n_cfm_mpid' may be 0 or 1; if it is 0, then 'cfm_mpid'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_mpid(const struct ovsrec_interface *row, const int64_t *cfm_mpid, size_t n_cfm_mpid)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_cfm_mpid) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *cfm_mpid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_MPID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_remote_mpids" column from the "Interface" table in 'row' to
 * the 'cfm_remote_mpids' set with 'n_cfm_remote_mpids' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_remote_mpids(const struct ovsrec_interface *row, const int64_t *cfm_remote_mpids, size_t n_cfm_remote_mpids)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_cfm_remote_mpids;
    datum.keys = n_cfm_remote_mpids ? xmalloc(n_cfm_remote_mpids * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_cfm_remote_mpids; i++) {
        datum.keys[i].integer = cfm_remote_mpids[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_REMOTE_MPIDS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "cfm_remote_opstate" column from the "Interface" table in 'row' to
 * the 'cfm_remote_opstate' set.
 *
 * If "cfm_remote_opstate" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_cfm_remote_opstate(const struct ovsrec_interface *row, const char *cfm_remote_opstate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (cfm_remote_opstate) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, cfm_remote_opstate);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_CFM_REMOTE_OPSTATE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "duplex" column from the "Interface" table in 'row' to
 * the 'duplex' set.
 *
 * If "duplex" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "full" or "half"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_duplex(const struct ovsrec_interface *row, const char *duplex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (duplex) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, duplex);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_DUPLEX ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "error" column from the "Interface" table in 'row' to
 * the 'error' set.
 *
 * If "error" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_error(const struct ovsrec_interface *row, const char *error)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (error) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, error);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_ERROR ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "external_ids" column's value from the "Interface" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_interface_index_set_external_ids(const struct ovsrec_interface *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "ifindex" column from the "Interface" table in 'row' to
 * the 'ifindex' set with 'n_ifindex' entries.
 *
 * 'n_ifindex' may be 0 or 1; if it is 0, then 'ifindex'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 4,294,967,295
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ifindex(const struct ovsrec_interface *row, const int64_t *ifindex, size_t n_ifindex)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_ifindex) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *ifindex;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_IFINDEX ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ingress_policing_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ingress_policing_burst(const struct ovsrec_interface *row, int64_t ingress_policing_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = ingress_policing_burst;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_INGRESS_POLICING_BURST ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ingress_policing_kpkts_burst" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_burst'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ingress_policing_kpkts_burst(const struct ovsrec_interface *row, int64_t ingress_policing_kpkts_burst)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = ingress_policing_kpkts_burst;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_INGRESS_POLICING_KPKTS_BURST ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ingress_policing_kpkts_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_kpkts_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ingress_policing_kpkts_rate(const struct ovsrec_interface *row, int64_t ingress_policing_kpkts_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = ingress_policing_kpkts_rate;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_INGRESS_POLICING_KPKTS_RATE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ingress_policing_rate" column from the "Interface" table in 'row' to
 * 'ingress_policing_rate'.
 *
 * Argument constraints: at least 0
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ingress_policing_rate(const struct ovsrec_interface *row, int64_t ingress_policing_rate)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = ingress_policing_rate;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_INGRESS_POLICING_RATE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "lacp_current" column from the "Interface" table in 'row' to
 * the 'lacp_current' set with 'n_lacp_current' entries.
 *
 * 'n_lacp_current' may be 0 or 1; if it is 0, then 'lacp_current'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_lacp_current(const struct ovsrec_interface *row, const bool *lacp_current, size_t n_lacp_current)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_lacp_current) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->boolean = *lacp_current;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_LACP_CURRENT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "link_resets" column from the "Interface" table in 'row' to
 * the 'link_resets' set with 'n_link_resets' entries.
 *
 * 'n_link_resets' may be 0 or 1; if it is 0, then 'link_resets'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_link_resets(const struct ovsrec_interface *row, const int64_t *link_resets, size_t n_link_resets)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_link_resets) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *link_resets;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_LINK_RESETS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "link_speed" column from the "Interface" table in 'row' to
 * the 'link_speed' set with 'n_link_speed' entries.
 *
 * 'n_link_speed' may be 0 or 1; if it is 0, then 'link_speed'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_link_speed(const struct ovsrec_interface *row, const int64_t *link_speed, size_t n_link_speed)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_link_speed) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *link_speed;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_LINK_SPEED ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "link_state" column from the "Interface" table in 'row' to
 * the 'link_state' set.
 *
 * If "link_state" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "down" or "up"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_link_state(const struct ovsrec_interface *row, const char *link_state)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (link_state) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, link_state);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_LINK_STATE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "lldp" column's value from the "Interface" table in 'row'
 * to 'lldp'.
 *
 * The caller retains ownership of 'lldp' and everything in it. */
void
ovsrec_interface_index_set_lldp(const struct ovsrec_interface *row, const struct smap *lldp)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (lldp) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(lldp);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, lldp) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_LLDP],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "mac" column from the "Interface" table in 'row' to
 * the 'mac' set.
 *
 * If "mac" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_mac(const struct ovsrec_interface *row, const char *mac)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (mac) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, mac);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_MAC ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "mac_in_use" column from the "Interface" table in 'row' to
 * the 'mac_in_use' set.
 *
 * If "mac_in_use" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_mac_in_use(const struct ovsrec_interface *row, const char *mac_in_use)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (mac_in_use) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, mac_in_use);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_MAC_IN_USE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "mtu" column from the "Interface" table in 'row' to
 * the 'mtu' set with 'n_mtu' entries.
 *
 * 'n_mtu' may be 0 or 1; if it is 0, then 'mtu'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_mtu(const struct ovsrec_interface *row, const int64_t *mtu, size_t n_mtu)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_mtu) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *mtu;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_MTU ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "mtu_request" column from the "Interface" table in 'row' to
 * the 'mtu_request' set with 'n_mtu_request' entries.
 *
 * 'n_mtu_request' may be 0 or 1; if it is 0, then 'mtu_request'
 * may be NULL.
 *
 * Argument constraints: at least 1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_mtu_request(const struct ovsrec_interface *row, const int64_t *mtu_request, size_t n_mtu_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_mtu_request) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *mtu_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_MTU_REQUEST ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "name" column from the "Interface" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_name(const struct ovsrec_interface *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_NAME ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ofport" column from the "Interface" table in 'row' to
 * the 'ofport' set with 'n_ofport' entries.
 *
 * 'n_ofport' may be 0 or 1; if it is 0, then 'ofport'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ofport(const struct ovsrec_interface *row, const int64_t *ofport, size_t n_ofport)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_ofport) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *ofport;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_OFPORT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "ofport_request" column from the "Interface" table in 'row' to
 * the 'ofport_request' set with 'n_ofport_request' entries.
 *
 * 'n_ofport_request' may be 0 or 1; if it is 0, then 'ofport_request'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 65,279
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_ofport_request(const struct ovsrec_interface *row, const int64_t *ofport_request, size_t n_ofport_request)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_ofport_request) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *ofport_request;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_OFPORT_REQUEST ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "options" column's value from the "Interface" table in 'row'
 * to 'options'.
 *
 * The caller retains ownership of 'options' and everything in it. */
void
ovsrec_interface_index_set_options(const struct ovsrec_interface *row, const struct smap *options)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (options) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(options);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, options) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_OPTIONS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "other_config" column's value from the "Interface" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_interface_index_set_other_config(const struct ovsrec_interface *row, const struct smap *other_config)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (other_config) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(other_config);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, other_config) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_OTHER_CONFIG],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "statistics" column from the "Interface" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_statistics(const struct ovsrec_interface *row, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (i = 0; i < n_statistics; i++) {
        datum.keys[i].string = xstrdup(key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_STATISTICS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

/* Sets the "status" column's value from the "Interface" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_interface_index_set_status(const struct ovsrec_interface *row, const struct smap *status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_interface_columns[OVSREC_INTERFACE_COL_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
    free(datum);
}


/* Sets the "type" column from the "Interface" table in 'row' to
 * 'type'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_interface_index_set_type(const struct ovsrec_interface *row, const char *type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, type);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_interface_columns[ OVSREC_INTERFACE_COL_TYPE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_INTERFACE]);
}

struct ovsdb_idl_column ovsrec_interface_columns[OVSREC_INTERFACE_N_COLUMNS];

unsigned int
ovsrec_interface_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_interface, condition);
}
static union ovsdb_atom Interface_col_admin_state_key_enum_keys[2] = {
    { .string = "down" },
    { .string = "up" },
};
static struct ovsdb_datum Interface_col_admin_state_key_enum = {
    .n = 2,
    .keys = Interface_col_admin_state_key_enum_keys,
};
static union ovsdb_atom Interface_col_cfm_remote_opstate_key_enum_keys[2] = {
    { .string = "down" },
    { .string = "up" },
};
static struct ovsdb_datum Interface_col_cfm_remote_opstate_key_enum = {
    .n = 2,
    .keys = Interface_col_cfm_remote_opstate_key_enum_keys,
};
static union ovsdb_atom Interface_col_duplex_key_enum_keys[2] = {
    { .string = "full" },
    { .string = "half" },
};
static struct ovsdb_datum Interface_col_duplex_key_enum = {
    .n = 2,
    .keys = Interface_col_duplex_key_enum_keys,
};
static union ovsdb_atom Interface_col_link_state_key_enum_keys[2] = {
    { .string = "down" },
    { .string = "up" },
};
static struct ovsdb_datum Interface_col_link_state_key_enum = {
    .n = 2,
    .keys = Interface_col_link_state_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_interface_columns[OVSREC_INTERFACE_N_COLUMNS] = {
    [OVSREC_INTERFACE_COL_ADMIN_STATE] = {
         .name = "admin_state",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Interface_col_admin_state_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_admin_state,
         .unparse = ovsrec_interface_unparse_admin_state,
    },

    [OVSREC_INTERFACE_COL_BFD] = {
         .name = "bfd",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_bfd,
         .unparse = ovsrec_interface_unparse_bfd,
    },

    [OVSREC_INTERFACE_COL_BFD_STATUS] = {
         .name = "bfd_status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_bfd_status,
         .unparse = ovsrec_interface_unparse_bfd_status,
    },

    [OVSREC_INTERFACE_COL_CFM_FAULT] = {
         .name = "cfm_fault",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_fault,
         .unparse = ovsrec_interface_unparse_cfm_fault,
    },

    [OVSREC_INTERFACE_COL_CFM_FAULT_STATUS] = {
         .name = "cfm_fault_status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_fault_status,
         .unparse = ovsrec_interface_unparse_cfm_fault_status,
    },

    [OVSREC_INTERFACE_COL_CFM_FLAP_COUNT] = {
         .name = "cfm_flap_count",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_flap_count,
         .unparse = ovsrec_interface_unparse_cfm_flap_count,
    },

    [OVSREC_INTERFACE_COL_CFM_HEALTH] = {
         .name = "cfm_health",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(100) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_health,
         .unparse = ovsrec_interface_unparse_cfm_health,
    },

    [OVSREC_INTERFACE_COL_CFM_MPID] = {
         .name = "cfm_mpid",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_mpid,
         .unparse = ovsrec_interface_unparse_cfm_mpid,
    },

    [OVSREC_INTERFACE_COL_CFM_REMOTE_MPIDS] = {
         .name = "cfm_remote_mpids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_remote_mpids,
         .unparse = ovsrec_interface_unparse_cfm_remote_mpids,
    },

    [OVSREC_INTERFACE_COL_CFM_REMOTE_OPSTATE] = {
         .name = "cfm_remote_opstate",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Interface_col_cfm_remote_opstate_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_cfm_remote_opstate,
         .unparse = ovsrec_interface_unparse_cfm_remote_opstate,
    },

    [OVSREC_INTERFACE_COL_DUPLEX] = {
         .name = "duplex",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Interface_col_duplex_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_duplex,
         .unparse = ovsrec_interface_unparse_duplex,
    },

    [OVSREC_INTERFACE_COL_ERROR] = {
         .name = "error",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_error,
         .unparse = ovsrec_interface_unparse_error,
    },

    [OVSREC_INTERFACE_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_external_ids,
         .unparse = ovsrec_interface_unparse_external_ids,
    },

    [OVSREC_INTERFACE_COL_IFINDEX] = {
         .name = "ifindex",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4294967295) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ifindex,
         .unparse = ovsrec_interface_unparse_ifindex,
    },

    [OVSREC_INTERFACE_COL_INGRESS_POLICING_BURST] = {
         .name = "ingress_policing_burst",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ingress_policing_burst,
         .unparse = ovsrec_interface_unparse_ingress_policing_burst,
    },

    [OVSREC_INTERFACE_COL_INGRESS_POLICING_KPKTS_BURST] = {
         .name = "ingress_policing_kpkts_burst",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ingress_policing_kpkts_burst,
         .unparse = ovsrec_interface_unparse_ingress_policing_kpkts_burst,
    },

    [OVSREC_INTERFACE_COL_INGRESS_POLICING_KPKTS_RATE] = {
         .name = "ingress_policing_kpkts_rate",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ingress_policing_kpkts_rate,
         .unparse = ovsrec_interface_unparse_ingress_policing_kpkts_rate,
    },

    [OVSREC_INTERFACE_COL_INGRESS_POLICING_RATE] = {
         .name = "ingress_policing_rate",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ingress_policing_rate,
         .unparse = ovsrec_interface_unparse_ingress_policing_rate,
    },

    [OVSREC_INTERFACE_COL_LACP_CURRENT] = {
         .name = "lacp_current",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_lacp_current,
         .unparse = ovsrec_interface_unparse_lacp_current,
    },

    [OVSREC_INTERFACE_COL_LINK_RESETS] = {
         .name = "link_resets",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_link_resets,
         .unparse = ovsrec_interface_unparse_link_resets,
    },

    [OVSREC_INTERFACE_COL_LINK_SPEED] = {
         .name = "link_speed",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_link_speed,
         .unparse = ovsrec_interface_unparse_link_speed,
    },

    [OVSREC_INTERFACE_COL_LINK_STATE] = {
         .name = "link_state",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Interface_col_link_state_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_link_state,
         .unparse = ovsrec_interface_unparse_link_state,
    },

    [OVSREC_INTERFACE_COL_LLDP] = {
         .name = "lldp",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_lldp,
         .unparse = ovsrec_interface_unparse_lldp,
    },

    [OVSREC_INTERFACE_COL_MAC] = {
         .name = "mac",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_mac,
         .unparse = ovsrec_interface_unparse_mac,
    },

    [OVSREC_INTERFACE_COL_MAC_IN_USE] = {
         .name = "mac_in_use",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_mac_in_use,
         .unparse = ovsrec_interface_unparse_mac_in_use,
    },

    [OVSREC_INTERFACE_COL_MTU] = {
         .name = "mtu",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_mtu,
         .unparse = ovsrec_interface_unparse_mtu,
    },

    [OVSREC_INTERFACE_COL_MTU_REQUEST] = {
         .name = "mtu_request",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_mtu_request,
         .unparse = ovsrec_interface_unparse_mtu_request,
    },

    [OVSREC_INTERFACE_COL_NAME] = {
         .name = "name",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = false,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_name,
         .unparse = ovsrec_interface_unparse_name,
    },

    [OVSREC_INTERFACE_COL_OFPORT] = {
         .name = "ofport",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ofport,
         .unparse = ovsrec_interface_unparse_ofport,
    },

    [OVSREC_INTERFACE_COL_OFPORT_REQUEST] = {
         .name = "ofport_request",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1), .max = INT64_C(65279) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_ofport_request,
         .unparse = ovsrec_interface_unparse_ofport_request,
    },

    [OVSREC_INTERFACE_COL_OPTIONS] = {
         .name = "options",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_options,
         .unparse = ovsrec_interface_unparse_options,
    },

    [OVSREC_INTERFACE_COL_OTHER_CONFIG] = {
         .name = "other_config",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_other_config,
         .unparse = ovsrec_interface_unparse_other_config,
    },

    [OVSREC_INTERFACE_COL_STATISTICS] = {
         .name = "statistics",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_INTEGER,
                .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_statistics,
         .unparse = ovsrec_interface_unparse_statistics,
    },

    [OVSREC_INTERFACE_COL_STATUS] = {
         .name = "status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_status,
         .unparse = ovsrec_interface_unparse_status,
    },

    [OVSREC_INTERFACE_COL_TYPE] = {
         .name = "type",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_interface_parse_type,
         .unparse = ovsrec_interface_unparse_type,
    },

};

/* Manager table. */

const struct ovsrec_manager_table *
ovsrec_manager_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_manager_table *) idl;
}

const struct ovsrec_manager *
ovsrec_manager_table_first(const struct ovsrec_manager_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_manager_first(idl);
}


const struct ovsrec_manager *
ovsrec_manager_table_track_get_first(const struct ovsrec_manager_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_manager_track_get_first(idl);
}


static void
ovsrec_manager_parse_connection_mode(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);

    if (datum->n >= 1) {
        row->connection_mode = datum->keys[0].string;
    } else {
        row->connection_mode = NULL;
    }
}

static void
ovsrec_manager_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_manager_parse_inactivity_probe(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    size_t n = MIN(1, datum->n);
    row->inactivity_probe = NULL;
    row->n_inactivity_probe = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_inactivity_probe) {
            row->inactivity_probe = xmalloc(n * sizeof *row->inactivity_probe);
        }
        row->inactivity_probe[row->n_inactivity_probe] = datum->keys[i].integer;
        row->n_inactivity_probe++;
    }
}

static void
ovsrec_manager_parse_is_connected(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);

    if (datum->n >= 1) {
        row->is_connected = datum->keys[0].boolean;
    } else {
        row->is_connected = false;
    }
}

static void
ovsrec_manager_parse_max_backoff(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    size_t n = MIN(1, datum->n);
    row->max_backoff = NULL;
    row->n_max_backoff = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_max_backoff) {
            row->max_backoff = xmalloc(n * sizeof *row->max_backoff);
        }
        row->max_backoff[row->n_max_backoff] = datum->keys[i].integer;
        row->n_max_backoff++;
    }
}

static void
ovsrec_manager_parse_other_config(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_init(&row->other_config);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->other_config,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_manager_parse_status(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_init(&row->status);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->status,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_manager_parse_target(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);

    if (datum->n >= 1) {
        row->target = datum->keys[0].string;
    } else {
        row->target = "";
    }
}

static void
ovsrec_manager_unparse_connection_mode(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_manager_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_manager_unparse_inactivity_probe(struct ovsdb_idl_row *row_)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    free(row->inactivity_probe);
}

static void
ovsrec_manager_unparse_is_connected(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_manager_unparse_max_backoff(struct ovsdb_idl_row *row_)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    free(row->max_backoff);
}

static void
ovsrec_manager_unparse_other_config(struct ovsdb_idl_row *row_)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_destroy(&row->other_config);
}

static void
ovsrec_manager_unparse_status(struct ovsdb_idl_row *row_)
{
    struct ovsrec_manager *row = ovsrec_manager_cast(row_);
    smap_destroy(&row->status);
}

static void
ovsrec_manager_unparse_target(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_manager_init__(struct ovsdb_idl_row *row)
{
    ovsrec_manager_init(ovsrec_manager_cast(row));
}

/* Clears the contents of 'row' in table "Manager". */
void
ovsrec_manager_init(struct ovsrec_manager *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
    smap_init(&row->other_config);
    smap_init(&row->status);
    row->target = "";
}

/* Searches table "Manager" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_manager *
ovsrec_manager_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_manager_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_manager, uuid));
}

/* Searches table "Manager" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_manager *
ovsrec_manager_table_get_for_uuid(const struct ovsrec_manager_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_manager_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Manager" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_manager *
ovsrec_manager_first(const struct ovsdb_idl *idl)
{
    return ovsrec_manager_cast(ovsdb_idl_first_row(idl, &ovsrec_table_manager));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_manager *
ovsrec_manager_next(const struct ovsrec_manager *row)
{
    return ovsrec_manager_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_manager_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_manager);
}

unsigned int ovsrec_manager_row_get_seqno(const struct ovsrec_manager *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_manager *
ovsrec_manager_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_manager_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_manager));
}

const struct ovsrec_manager
*ovsrec_manager_track_get_next(const struct ovsrec_manager *row)
{
    return ovsrec_manager_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Manager".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_delete(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Manager" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_manager *
ovsrec_manager_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_manager_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_manager, NULL));
}

bool
ovsrec_manager_is_updated(const struct ovsrec_manager *row, enum ovsrec_manager_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_manager_columns[column]);
}

/* Causes the original contents of column "connection_mode" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "connection_mode" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "connection_mode" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "connection_mode" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "connection_mode" has already been modified (with
 *     ovsrec_manager_set_connection_mode()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_connection_mode() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_connection_mode(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_connection_mode);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_manager_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_external_ids(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_external_ids);
}

/* Causes the original contents of column "inactivity_probe" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "inactivity_probe" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "inactivity_probe" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "inactivity_probe" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "inactivity_probe" has already been modified (with
 *     ovsrec_manager_set_inactivity_probe()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_inactivity_probe() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_inactivity_probe(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_inactivity_probe);
}

/* Causes the original contents of column "is_connected" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "is_connected" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "is_connected" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "is_connected" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "is_connected" has already been modified (with
 *     ovsrec_manager_set_is_connected()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_is_connected() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_is_connected(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_is_connected);
}

/* Causes the original contents of column "max_backoff" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "max_backoff" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "max_backoff" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "max_backoff" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "max_backoff" has already been modified (with
 *     ovsrec_manager_set_max_backoff()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_max_backoff() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_max_backoff(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_max_backoff);
}

/* Causes the original contents of column "other_config" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "other_config" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "other_config" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "other_config" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "other_config" has already been modified (with
 *     ovsrec_manager_set_other_config()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_other_config() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_other_config(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_other_config);
}

/* Causes the original contents of column "status" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "status" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "status" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "status" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "status" has already been modified (with
 *     ovsrec_manager_set_status()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_status() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_status(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_status);
}

/* Causes the original contents of column "target" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "target" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "target" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "target" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_manager_insert()).
 *
 *   - If "target" has already been modified (with
 *     ovsrec_manager_set_target()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_manager_set_target() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_manager_verify_target(const struct ovsrec_manager *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_manager_col_target);
}

/* Returns the "connection_mode" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes connection_mode's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "connection_mode" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_connection_mode(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_connection_mode);
}

/* Returns the "external_ids" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_external_ids(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_external_ids);
}

/* Returns the "inactivity_probe" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes inactivity_probe's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "inactivity_probe" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_inactivity_probe(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_inactivity_probe);
}

/* Returns the "is_connected" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes is_connected's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "is_connected" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_is_connected(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_is_connected);
}

/* Returns the "max_backoff" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes max_backoff's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "max_backoff" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_max_backoff(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_max_backoff);
}

/* Returns the "other_config" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes other_config's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "other_config" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_other_config(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_other_config);
}

/* Returns the "status" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes status's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "status" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_status(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_status);
}

/* Returns the "target" column's value from the "Manager" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes target's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "target" member in ovsrec_manager. */
const struct ovsdb_datum *
ovsrec_manager_get_target(const struct ovsrec_manager *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_manager_col_target);
}

/* Sets the "connection_mode" column from the "Manager" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_set_connection_mode(const struct ovsrec_manager *row, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (connection_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_manager_col_connection_mode, &datum);
}

/* Sets the "external_ids" column's value from the "Manager" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_manager_set_external_ids(const struct ovsrec_manager *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_manager_col_external_ids,
                        &datum);
}


/* Sets the "inactivity_probe" column from the "Manager" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_set_inactivity_probe(const struct ovsrec_manager *row, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_inactivity_probe) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_manager_col_inactivity_probe, &datum);
}

/* Sets the "is_connected" column from the "Manager" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_set_is_connected(const struct ovsrec_manager *row, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_manager_col_is_connected, &datum);
}

/* Sets the "max_backoff" column from the "Manager" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_set_max_backoff(const struct ovsrec_manager *row, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_max_backoff) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_manager_col_max_backoff, &datum);
}

/* Sets the "other_config" column's value from the "Manager" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_manager_set_other_config(const struct ovsrec_manager *row, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_manager_col_other_config,
                        &datum);
}


/* Sets the "status" column's value from the "Manager" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_manager_set_status(const struct ovsrec_manager *row, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_manager_col_status,
                        &datum);
}


/* Sets the "target" column from the "Manager" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_set_target(const struct ovsrec_manager *row, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_manager_col_target, &datum);
}

/* Adds the value 'new_value' to the "connection_mode" set column from the "Manager" table
 * in 'row'.
 *
 */
void
ovsrec_manager_update_connection_mode_addvalue(const struct ovsrec_manager *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_manager_col_connection_mode,
                                    datum);
}

/* Deletes the value 'delete_value' from the "connection_mode" set column from the
 * "Manager" table in 'row'.
 *
 */
void
ovsrec_manager_update_connection_mode_delvalue(const struct ovsrec_manager *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_manager_col_connection_mode,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "Manager" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_manager_update_external_ids_setkey(const struct ovsrec_manager *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_manager_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Manager" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_manager_update_external_ids_delkey(const struct ovsrec_manager *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_manager_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "inactivity_probe" set column from the "Manager" table
 * in 'row'.
 *
 */
void
ovsrec_manager_update_inactivity_probe_addvalue(const struct ovsrec_manager *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_manager_col_inactivity_probe,
                                    datum);
}

/* Deletes the value 'delete_value' from the "inactivity_probe" set column from the
 * "Manager" table in 'row'.
 *
 */
void
ovsrec_manager_update_inactivity_probe_delvalue(const struct ovsrec_manager *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_manager_col_inactivity_probe,
                                    datum);
}

/* Adds the value 'new_value' to the "max_backoff" set column from the "Manager" table
 * in 'row'.
 *
 */
void
ovsrec_manager_update_max_backoff_addvalue(const struct ovsrec_manager *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_manager_col_max_backoff,
                                    datum);
}

/* Deletes the value 'delete_value' from the "max_backoff" set column from the
 * "Manager" table in 'row'.
 *
 */
void
ovsrec_manager_update_max_backoff_delvalue(const struct ovsrec_manager *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_manager_col_max_backoff,
                                    datum);
}

/* Sets an element of the "other_config" map column from the "Manager" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_manager_update_other_config_setkey(const struct ovsrec_manager *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_manager_col_other_config,
                                    datum);
}

/* Deletes an element of the "other_config" map column from the "Manager" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_manager_update_other_config_delkey(const struct ovsrec_manager *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_manager_col_other_config,
                                    datum);
}

/* Sets an element of the "status" map column from the "Manager" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_manager_update_status_setkey(const struct ovsrec_manager *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_manager_col_status,
                                    datum);
}

/* Deletes an element of the "status" map column from the "Manager" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_manager_update_status_delkey(const struct ovsrec_manager *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_manager_col_status,
                                    datum);
}

/* Sets the "connection_mode" column from the "Manager" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_add_clause_connection_mode(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (connection_mode) {
        datum.n = 1;
        datum.keys = &key;
        key.string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_manager_col_connection_mode,
                          &datum);
}

/* Sets the "external_ids" column's value from the "Manager" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_manager_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_manager_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_manager_col_external_ids.type);
}


/* Sets the "inactivity_probe" column from the "Manager" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_add_clause_inactivity_probe(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_inactivity_probe) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_manager_col_inactivity_probe,
                          &datum);
}

/* Sets the "is_connected" column from the "Manager" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_add_clause_is_connected(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_manager_col_is_connected,
                          &datum);
}

/* Sets the "max_backoff" column from the "Manager" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_add_clause_max_backoff(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_max_backoff) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_manager_col_max_backoff,
                          &datum);
}

/* Sets the "other_config" column's value from the "Manager" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_manager_add_clause_other_config(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *other_config)
{
    struct ovsdb_datum datum;

    if (other_config) {
        ovsdb_datum_from_smap(&datum, other_config);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_manager_col_other_config,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_manager_col_other_config.type);
}


/* Sets the "status" column's value from the "Manager" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_manager_add_clause_status(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *status)
{
    struct ovsdb_datum datum;

    if (status) {
        ovsdb_datum_from_smap(&datum, status);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_manager_col_status,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_manager_col_status.type);
}


/* Sets the "target" column from the "Manager" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_add_clause_target(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_manager_col_target,
                          &datum);
}

/* Destroy 'row' of kind "Manager". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_manager_index_destroy_row(const struct ovsrec_manager *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Manager". */
struct ovsrec_manager *
ovsrec_manager_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_manager);
    return ALIGNED_CAST(struct ovsrec_manager *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_manager *
ovsrec_manager_index_find(struct ovsdb_idl_index *index, const struct ovsrec_manager *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_manager);
    return ovsrec_manager_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_manager_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_manager *a, 
    const struct ovsrec_manager *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_manager_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_manager);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_manager_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_manager *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_manager);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_manager_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_manager *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_manager);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_manager *
ovsrec_manager_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_manager_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "connection_mode" column from the "Manager" table in 'row' to
 * the 'connection_mode' set.
 *
 * If "connection_mode" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * Argument constraints: either "in-band" or "out-of-band"
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_index_set_connection_mode(const struct ovsrec_manager *row, const char *connection_mode)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (connection_mode) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->string = CONST_CAST(char *, connection_mode);
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_manager_columns[ OVSREC_MANAGER_COL_CONNECTION_MODE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
}

/* Sets the "external_ids" column's value from the "Manager" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_manager_index_set_external_ids(const struct ovsrec_manager *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_manager_columns[OVSREC_MANAGER_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
    free(datum);
}


/* Sets the "inactivity_probe" column from the "Manager" table in 'row' to
 * the 'inactivity_probe' set with 'n_inactivity_probe' entries.
 *
 * 'n_inactivity_probe' may be 0 or 1; if it is 0, then 'inactivity_probe'
 * may be NULL.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_index_set_inactivity_probe(const struct ovsrec_manager *row, const int64_t *inactivity_probe, size_t n_inactivity_probe)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_inactivity_probe) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *inactivity_probe;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_manager_columns[ OVSREC_MANAGER_COL_INACTIVITY_PROBE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
}

/* Sets the "is_connected" column from the "Manager" table in 'row' to
 * 'is_connected'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_index_set_is_connected(const struct ovsrec_manager *row, bool is_connected)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = is_connected;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_manager_columns[ OVSREC_MANAGER_COL_IS_CONNECTED ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
}

/* Sets the "max_backoff" column from the "Manager" table in 'row' to
 * the 'max_backoff' set with 'n_max_backoff' entries.
 *
 * 'n_max_backoff' may be 0 or 1; if it is 0, then 'max_backoff'
 * may be NULL.
 *
 * Argument constraints: at least 1,000
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_index_set_max_backoff(const struct ovsrec_manager *row, const int64_t *max_backoff, size_t n_max_backoff)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_max_backoff) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *max_backoff;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_manager_columns[ OVSREC_MANAGER_COL_MAX_BACKOFF ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
}

/* Sets the "other_config" column's value from the "Manager" table in 'row'
 * to 'other_config'.
 *
 * The caller retains ownership of 'other_config' and everything in it. */
void
ovsrec_manager_index_set_other_config(const struct ovsrec_manager *row, const struct smap *other_config)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (other_config) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(other_config);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, other_config) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_manager_columns[OVSREC_MANAGER_COL_OTHER_CONFIG],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
    free(datum);
}


/* Sets the "status" column's value from the "Manager" table in 'row'
 * to 'status'.
 *
 * The caller retains ownership of 'status' and everything in it. */
void
ovsrec_manager_index_set_status(const struct ovsrec_manager *row, const struct smap *status)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (status) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(status);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, status) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_manager_columns[OVSREC_MANAGER_COL_STATUS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
    free(datum);
}


/* Sets the "target" column from the "Manager" table in 'row' to
 * 'target'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_manager_index_set_target(const struct ovsrec_manager *row, const char *target)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, target);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_manager_columns[ OVSREC_MANAGER_COL_TARGET ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MANAGER]);
}

struct ovsdb_idl_column ovsrec_manager_columns[OVSREC_MANAGER_N_COLUMNS];

unsigned int
ovsrec_manager_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_manager, condition);
}
static union ovsdb_atom Manager_col_connection_mode_key_enum_keys[2] = {
    { .string = "in-band" },
    { .string = "out-of-band" },
};
static struct ovsdb_datum Manager_col_connection_mode_key_enum = {
    .n = 2,
    .keys = Manager_col_connection_mode_key_enum_keys,
};

struct ovsdb_idl_column ovsrec_manager_columns[OVSREC_MANAGER_N_COLUMNS] = {
    [OVSREC_MANAGER_COL_CONNECTION_MODE] = {
         .name = "connection_mode",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .enum_ = &Manager_col_connection_mode_key_enum,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_connection_mode,
         .unparse = ovsrec_manager_unparse_connection_mode,
    },

    [OVSREC_MANAGER_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_external_ids,
         .unparse = ovsrec_manager_unparse_external_ids,
    },

    [OVSREC_MANAGER_COL_INACTIVITY_PROBE] = {
         .name = "inactivity_probe",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_inactivity_probe,
         .unparse = ovsrec_manager_unparse_inactivity_probe,
    },

    [OVSREC_MANAGER_COL_IS_CONNECTED] = {
         .name = "is_connected",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_is_connected,
         .unparse = ovsrec_manager_unparse_is_connected,
    },

    [OVSREC_MANAGER_COL_MAX_BACKOFF] = {
         .name = "max_backoff",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1000), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_max_backoff,
         .unparse = ovsrec_manager_unparse_max_backoff,
    },

    [OVSREC_MANAGER_COL_OTHER_CONFIG] = {
         .name = "other_config",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_other_config,
         .unparse = ovsrec_manager_unparse_other_config,
    },

    [OVSREC_MANAGER_COL_STATUS] = {
         .name = "status",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_status,
         .unparse = ovsrec_manager_unparse_status,
    },

    [OVSREC_MANAGER_COL_TARGET] = {
         .name = "target",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_manager_parse_target,
         .unparse = ovsrec_manager_unparse_target,
    },

};

/* Mirror table. */

const struct ovsrec_mirror_table *
ovsrec_mirror_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_mirror_table *) idl;
}

const struct ovsrec_mirror *
ovsrec_mirror_table_first(const struct ovsrec_mirror_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_mirror_first(idl);
}


const struct ovsrec_mirror *
ovsrec_mirror_table_track_get_first(const struct ovsrec_mirror_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_mirror_track_get_first(idl);
}


static void
ovsrec_mirror_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_mirror_parse_name(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);

    if (datum->n >= 1) {
        row->name = datum->keys[0].string;
    } else {
        row->name = "";
    }
}

static void
ovsrec_mirror_parse_output_port(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);

    if (datum->n >= 1) {
        row->output_port = ovsrec_port_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_port, &datum->keys[0].uuid));
    } else {
        row->output_port = NULL;
    }
}

static void
ovsrec_mirror_parse_output_vlan(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    size_t n = MIN(1, datum->n);
    row->output_vlan = NULL;
    row->n_output_vlan = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_output_vlan) {
            row->output_vlan = xmalloc(n * sizeof *row->output_vlan);
        }
        row->output_vlan[row->n_output_vlan] = datum->keys[i].integer;
        row->n_output_vlan++;
    }
}

static void
ovsrec_mirror_parse_select_all(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);

    if (datum->n >= 1) {
        row->select_all = datum->keys[0].boolean;
    } else {
        row->select_all = false;
    }
}

static void
ovsrec_mirror_parse_select_dst_port(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    row->select_dst_port = NULL;
    row->n_select_dst_port = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_port *keyRow = ovsrec_port_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_port, &datum->keys[i].uuid));
        if (!keyRow) {
            continue;
        }
        if (!row->n_select_dst_port) {
            row->select_dst_port = xmalloc(datum->n * sizeof *row->select_dst_port);
        }
        row->select_dst_port[row->n_select_dst_port] = keyRow;
        row->n_select_dst_port++;
    }
}

static void
ovsrec_mirror_parse_select_src_port(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    row->select_src_port = NULL;
    row->n_select_src_port = 0;
    for (size_t i = 0; i < datum->n; i++) {
        struct ovsrec_port *keyRow = ovsrec_port_cast(ovsdb_idl_get_row_arc(row_, &ovsrec_table_port, &datum->keys[i].uuid));
        if (!keyRow) {
            continue;
        }
        if (!row->n_select_src_port) {
            row->select_src_port = xmalloc(datum->n * sizeof *row->select_src_port);
        }
        row->select_src_port[row->n_select_src_port] = keyRow;
        row->n_select_src_port++;
    }
}

static void
ovsrec_mirror_parse_select_vlan(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    size_t n = MIN(4096, datum->n);
    row->select_vlan = NULL;
    row->n_select_vlan = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_select_vlan) {
            row->select_vlan = xmalloc(n * sizeof *row->select_vlan);
        }
        row->select_vlan[row->n_select_vlan] = datum->keys[i].integer;
        row->n_select_vlan++;
    }
}

static void
ovsrec_mirror_parse_snaplen(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    size_t n = MIN(1, datum->n);
    row->snaplen = NULL;
    row->n_snaplen = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_snaplen) {
            row->snaplen = xmalloc(n * sizeof *row->snaplen);
        }
        row->snaplen[row->n_snaplen] = datum->keys[i].integer;
        row->n_snaplen++;
    }
}

static void
ovsrec_mirror_parse_statistics(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    row->key_statistics = NULL;
    row->value_statistics = NULL;
    row->n_statistics = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_statistics) {
            row->key_statistics = xmalloc(datum->n * sizeof *row->key_statistics);
            row->value_statistics = xmalloc(datum->n * sizeof *row->value_statistics);
        }
        row->key_statistics[row->n_statistics] = datum->keys[i].string;
        row->value_statistics[row->n_statistics] = datum->values[i].integer;
        row->n_statistics++;
    }
}

static void
ovsrec_mirror_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_mirror_unparse_name(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_mirror_unparse_output_port(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_mirror_unparse_output_vlan(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->output_vlan);
}

static void
ovsrec_mirror_unparse_select_all(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_mirror_unparse_select_dst_port(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->select_dst_port);
}

static void
ovsrec_mirror_unparse_select_src_port(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->select_src_port);
}

static void
ovsrec_mirror_unparse_select_vlan(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->select_vlan);
}

static void
ovsrec_mirror_unparse_snaplen(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->snaplen);
}

static void
ovsrec_mirror_unparse_statistics(struct ovsdb_idl_row *row_)
{
    struct ovsrec_mirror *row = ovsrec_mirror_cast(row_);
    free(row->key_statistics);
    free(row->value_statistics);
}

static void
ovsrec_mirror_init__(struct ovsdb_idl_row *row)
{
    ovsrec_mirror_init(ovsrec_mirror_cast(row));
}

/* Clears the contents of 'row' in table "Mirror". */
void
ovsrec_mirror_init(struct ovsrec_mirror *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
    row->name = "";
}

/* Searches table "Mirror" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_mirror *
ovsrec_mirror_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_mirror_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_mirror, uuid));
}

/* Searches table "Mirror" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_mirror *
ovsrec_mirror_table_get_for_uuid(const struct ovsrec_mirror_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_mirror_get_for_uuid(idl, uuid);
}

/* Returns a row in table "Mirror" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_mirror *
ovsrec_mirror_first(const struct ovsdb_idl *idl)
{
    return ovsrec_mirror_cast(ovsdb_idl_first_row(idl, &ovsrec_table_mirror));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_mirror *
ovsrec_mirror_next(const struct ovsrec_mirror *row)
{
    return ovsrec_mirror_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_mirror_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_mirror);
}

unsigned int ovsrec_mirror_row_get_seqno(const struct ovsrec_mirror *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_mirror *
ovsrec_mirror_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_mirror_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_mirror));
}

const struct ovsrec_mirror
*ovsrec_mirror_track_get_next(const struct ovsrec_mirror *row)
{
    return ovsrec_mirror_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "Mirror".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_delete(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "Mirror" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_mirror *
ovsrec_mirror_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_mirror_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_mirror, NULL));
}

bool
ovsrec_mirror_is_updated(const struct ovsrec_mirror *row, enum ovsrec_mirror_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_mirror_columns[column]);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_mirror_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_external_ids(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_external_ids);
}

/* Causes the original contents of column "name" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "name" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "name" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "name" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "name" has already been modified (with
 *     ovsrec_mirror_set_name()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_name() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_name(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_name);
}

/* Causes the original contents of column "output_port" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "output_port" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "output_port" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "output_port" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "output_port" has already been modified (with
 *     ovsrec_mirror_set_output_port()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_output_port() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_output_port(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_output_port);
}

/* Causes the original contents of column "output_vlan" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "output_vlan" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "output_vlan" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "output_vlan" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "output_vlan" has already been modified (with
 *     ovsrec_mirror_set_output_vlan()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_output_vlan() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_output_vlan(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_output_vlan);
}

/* Causes the original contents of column "select_all" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "select_all" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "select_all" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "select_all" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "select_all" has already been modified (with
 *     ovsrec_mirror_set_select_all()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_select_all() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_select_all(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_select_all);
}

/* Causes the original contents of column "select_dst_port" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "select_dst_port" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "select_dst_port" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "select_dst_port" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "select_dst_port" has already been modified (with
 *     ovsrec_mirror_set_select_dst_port()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_select_dst_port() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_select_dst_port(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_select_dst_port);
}

/* Causes the original contents of column "select_src_port" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "select_src_port" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "select_src_port" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "select_src_port" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "select_src_port" has already been modified (with
 *     ovsrec_mirror_set_select_src_port()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_select_src_port() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_select_src_port(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_select_src_port);
}

/* Causes the original contents of column "select_vlan" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "select_vlan" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "select_vlan" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "select_vlan" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "select_vlan" has already been modified (with
 *     ovsrec_mirror_set_select_vlan()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_select_vlan() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_select_vlan(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_select_vlan);
}

/* Causes the original contents of column "snaplen" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "snaplen" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "snaplen" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "snaplen" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "snaplen" has already been modified (with
 *     ovsrec_mirror_set_snaplen()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_snaplen() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_snaplen(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_snaplen);
}

/* Causes the original contents of column "statistics" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "statistics" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "statistics" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "statistics" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_mirror_insert()).
 *
 *   - If "statistics" has already been modified (with
 *     ovsrec_mirror_set_statistics()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_mirror_set_statistics() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_mirror_verify_statistics(const struct ovsrec_mirror *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_mirror_col_statistics);
}

/* Returns the "external_ids" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_external_ids(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_external_ids);
}

/* Returns the "name" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes name's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "name" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_name(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_name);
}

/* Returns the "output_port" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes output_port's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "output_port" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_output_port(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_output_port);
}

/* Returns the "output_vlan" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes output_vlan's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "output_vlan" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_output_vlan(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_output_vlan);
}

/* Returns the "select_all" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes select_all's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "select_all" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_select_all(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_select_all);
}

/* Returns the "select_dst_port" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes select_dst_port's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "select_dst_port" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_select_dst_port(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_select_dst_port);
}

/* Returns the "select_src_port" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_UUID.
 * (This helps to avoid silent bugs if someone changes select_src_port's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "select_src_port" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_select_src_port(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_UUID);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_select_src_port);
}

/* Returns the "select_vlan" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes select_vlan's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "select_vlan" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_select_vlan(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_select_vlan);
}

/* Returns the "snaplen" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes snaplen's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "snaplen" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_snaplen(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_snaplen);
}

/* Returns the "statistics" column's value from the "Mirror" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes statistics's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "statistics" member in ovsrec_mirror. */
const struct ovsdb_datum *
ovsrec_mirror_get_statistics(const struct ovsrec_mirror *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_mirror_col_statistics);
}

/* Sets the "external_ids" column's value from the "Mirror" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_mirror_set_external_ids(const struct ovsrec_mirror *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_mirror_col_external_ids,
                        &datum);
}


/* Sets the "name" column from the "Mirror" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_name(const struct ovsrec_mirror *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_mirror_col_name, &datum);
}

/* Sets the "output_port" column from the "Mirror" table in 'row' to
 * the 'output_port' set.
 *
 * If "output_port" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_output_port(const struct ovsrec_mirror *row, const struct ovsrec_port *output_port)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (output_port) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = output_port->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_mirror_col_output_port, &datum);
}

/* Sets the "output_vlan" column from the "Mirror" table in 'row' to
 * the 'output_vlan' set with 'n_output_vlan' entries.
 *
 * 'n_output_vlan' may be 0 or 1; if it is 0, then 'output_vlan'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_output_vlan(const struct ovsrec_mirror *row, const int64_t *output_vlan, size_t n_output_vlan)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_output_vlan) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *output_vlan;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_mirror_col_output_vlan, &datum);
}

/* Sets the "select_all" column from the "Mirror" table in 'row' to
 * 'select_all'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_select_all(const struct ovsrec_mirror *row, bool select_all)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = select_all;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_mirror_col_select_all, &datum);
}

/* Sets the "select_dst_port" column from the "Mirror" table in 'row' to
 * the 'select_dst_port' set with 'n_select_dst_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_select_dst_port(const struct ovsrec_mirror *row, struct ovsrec_port **select_dst_port, size_t n_select_dst_port)
{
    struct ovsdb_datum datum;

    datum.n = n_select_dst_port;
    datum.keys = n_select_dst_port ? xmalloc(n_select_dst_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_dst_port; i++) {
        datum.keys[i].uuid = select_dst_port[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_mirror_col_select_dst_port, &datum);
}

/* Sets the "select_src_port" column from the "Mirror" table in 'row' to
 * the 'select_src_port' set with 'n_select_src_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_select_src_port(const struct ovsrec_mirror *row, struct ovsrec_port **select_src_port, size_t n_select_src_port)
{
    struct ovsdb_datum datum;

    datum.n = n_select_src_port;
    datum.keys = n_select_src_port ? xmalloc(n_select_src_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_src_port; i++) {
        datum.keys[i].uuid = select_src_port[i]->header_.uuid;
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_mirror_col_select_src_port, &datum);
}

/* Sets the "select_vlan" column from the "Mirror" table in 'row' to
 * the 'select_vlan' set with 'n_select_vlan' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_select_vlan(const struct ovsrec_mirror *row, const int64_t *select_vlan, size_t n_select_vlan)
{
    struct ovsdb_datum datum;

    datum.n = n_select_vlan;
    datum.keys = n_select_vlan ? xmalloc(n_select_vlan * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_vlan; i++) {
        datum.keys[i].integer = select_vlan[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_mirror_col_select_vlan, &datum);
}

/* Sets the "snaplen" column from the "Mirror" table in 'row' to
 * the 'snaplen' set with 'n_snaplen' entries.
 *
 * 'n_snaplen' may be 0 or 1; if it is 0, then 'snaplen'
 * may be NULL.
 *
 * Argument constraints: in range 14 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_snaplen(const struct ovsrec_mirror *row, const int64_t *snaplen, size_t n_snaplen)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_snaplen) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *snaplen;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_mirror_col_snaplen, &datum);
}

/* Sets the "statistics" column from the "Mirror" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_set_statistics(const struct ovsrec_mirror *row, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;

    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (size_t i = 0; i < n_statistics; i++) {
        datum.keys[i].string = xstrdup(key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_mirror_col_statistics, &datum);
}

/* Sets an element of the "external_ids" map column from the "Mirror" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_mirror_update_external_ids_setkey(const struct ovsrec_mirror *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_mirror_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "Mirror" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_mirror_update_external_ids_delkey(const struct ovsrec_mirror *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_mirror_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "output_port" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_output_port_addvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_output_port,
                                    datum);
}

/* Deletes the value 'delete_value' from the "output_port" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_output_port_delvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_output_port,
                                    datum);
}

/* Adds the value 'new_value' to the "output_vlan" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_output_vlan_addvalue(const struct ovsrec_mirror *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_output_vlan,
                                    datum);
}

/* Deletes the value 'delete_value' from the "output_vlan" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_output_vlan_delvalue(const struct ovsrec_mirror *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_output_vlan,
                                    datum);
}

/* Adds the value 'new_value' to the "select_dst_port" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_select_dst_port_addvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_dst_port,
                                    datum);
}

/* Deletes the value 'delete_value' from the "select_dst_port" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_select_dst_port_delvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_dst_port,
                                    datum);
}

/* Adds the value 'new_value' to the "select_src_port" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_select_src_port_addvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = new_value->header_.uuid;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_src_port,
                                    datum);
}

/* Deletes the value 'delete_value' from the "select_src_port" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_select_src_port_delvalue(const struct ovsrec_mirror *row, const struct ovsrec_port *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].uuid = delete_value->header_.uuid;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_src_port,
                                    datum);
}

/* Adds the value 'new_value' to the "select_vlan" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_select_vlan_addvalue(const struct ovsrec_mirror *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_vlan,
                                    datum);
}

/* Deletes the value 'delete_value' from the "select_vlan" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_select_vlan_delvalue(const struct ovsrec_mirror *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_select_vlan,
                                    datum);
}

/* Adds the value 'new_value' to the "snaplen" set column from the "Mirror" table
 * in 'row'.
 *
 */
void
ovsrec_mirror_update_snaplen_addvalue(const struct ovsrec_mirror *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_mirror_col_snaplen,
                                    datum);
}

/* Deletes the value 'delete_value' from the "snaplen" set column from the
 * "Mirror" table in 'row'.
 *
 */
void
ovsrec_mirror_update_snaplen_delvalue(const struct ovsrec_mirror *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_mirror_col_snaplen,
                                    datum);
}

/* Sets an element of the "statistics" map column from the "Mirror" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_mirror_update_statistics_setkey(const struct ovsrec_mirror *row, const char *new_key, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].integer = new_value;

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_mirror_col_statistics,
                                    datum);
}

/* Deletes an element of the "statistics" map column from the "Mirror" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_mirror_update_statistics_delkey(const struct ovsrec_mirror *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_mirror_col_statistics,
                                    datum);
}

/* Sets the "external_ids" column's value from the "Mirror" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_mirror_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_mirror_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_mirror_col_external_ids.type);
}


/* Sets the "name" column from the "Mirror" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_name(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_name,
                          &datum);
}

/* Sets the "output_port" column from the "Mirror" table in 'row' to
 * the 'output_port' set.
 *
 * If "output_port" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_output_port(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct uuid *output_port)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (output_port) {
        datum.n = 1;
        datum.keys = &key;
        key.uuid = *output_port;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_output_port,
                          &datum);
}

/* Sets the "output_vlan" column from the "Mirror" table in 'row' to
 * the 'output_vlan' set with 'n_output_vlan' entries.
 *
 * 'n_output_vlan' may be 0 or 1; if it is 0, then 'output_vlan'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_output_vlan(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *output_vlan, size_t n_output_vlan)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_output_vlan) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *output_vlan;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_output_vlan,
                          &datum);
}

/* Sets the "select_all" column from the "Mirror" table in 'row' to
 * 'select_all'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_select_all(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool select_all)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = select_all;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_select_all,
                          &datum);
}

/* Sets the "select_dst_port" column from the "Mirror" table in 'row' to
 * the 'select_dst_port' set with 'n_select_dst_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_select_dst_port(struct ovsdb_idl_condition *cond, enum ovsdb_function function, struct uuid **select_dst_port, size_t n_select_dst_port)
{
    struct ovsdb_datum datum;
    datum.n = n_select_dst_port;
    datum.keys = n_select_dst_port ? xmalloc(n_select_dst_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_dst_port; i++) {
        datum.keys[i].uuid = *select_dst_port[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_select_dst_port,
                          &datum);
    free(datum.keys);
}

/* Sets the "select_src_port" column from the "Mirror" table in 'row' to
 * the 'select_src_port' set with 'n_select_src_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_select_src_port(struct ovsdb_idl_condition *cond, enum ovsdb_function function, struct uuid **select_src_port, size_t n_select_src_port)
{
    struct ovsdb_datum datum;
    datum.n = n_select_src_port;
    datum.keys = n_select_src_port ? xmalloc(n_select_src_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_src_port; i++) {
        datum.keys[i].uuid = *select_src_port[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_select_src_port,
                          &datum);
    free(datum.keys);
}

/* Sets the "select_vlan" column from the "Mirror" table in 'row' to
 * the 'select_vlan' set with 'n_select_vlan' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_select_vlan(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *select_vlan, size_t n_select_vlan)
{
    struct ovsdb_datum datum;
    datum.n = n_select_vlan;
    datum.keys = n_select_vlan ? xmalloc(n_select_vlan * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_select_vlan; i++) {
        datum.keys[i].integer = select_vlan[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_select_vlan,
                          &datum);
    free(datum.keys);
}

/* Sets the "snaplen" column from the "Mirror" table in 'row' to
 * the 'snaplen' set with 'n_snaplen' entries.
 *
 * 'n_snaplen' may be 0 or 1; if it is 0, then 'snaplen'
 * may be NULL.
 *
 * Argument constraints: in range 14 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_snaplen(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *snaplen, size_t n_snaplen)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_snaplen) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *snaplen;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_snaplen,
                          &datum);
}

/* Sets the "statistics" column from the "Mirror" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_add_clause_statistics(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;
    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (size_t i = 0; i < n_statistics; i++) {
        datum.keys[i].string = CONST_CAST(char *, key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_mirror_col_statistics,
                          &datum);
    free(datum.keys);
    free(datum.values);
}

/* Destroy 'row' of kind "Mirror". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_mirror_index_destroy_row(const struct ovsrec_mirror *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "Mirror". */
struct ovsrec_mirror *
ovsrec_mirror_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_mirror);
    return ALIGNED_CAST(struct ovsrec_mirror *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_mirror *
ovsrec_mirror_index_find(struct ovsdb_idl_index *index, const struct ovsrec_mirror *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_mirror);
    return ovsrec_mirror_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_mirror_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_mirror *a, 
    const struct ovsrec_mirror *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_mirror_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_mirror);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_mirror_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_mirror *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_mirror);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_mirror_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_mirror *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_mirror);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_mirror *
ovsrec_mirror_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_mirror_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "external_ids" column's value from the "Mirror" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_mirror_index_set_external_ids(const struct ovsrec_mirror *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_mirror_columns[OVSREC_MIRROR_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
    free(datum);
}


/* Sets the "name" column from the "Mirror" table in 'row' to
 * 'name'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_name(const struct ovsrec_mirror *row, const char *name)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->string = CONST_CAST(char *, name);
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_NAME ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "output_port" column from the "Mirror" table in 'row' to
 * the 'output_port' set.
 *
 * If "output_port" is null, the column will be the empty set,
 * otherwise it will contain the specified value.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_output_port(const struct ovsrec_mirror *row, const struct ovsrec_port *output_port)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (output_port) {
        key = xmalloc(sizeof (union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->uuid = output_port->header_.uuid;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_OUTPUT_PORT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "output_vlan" column from the "Mirror" table in 'row' to
 * the 'output_vlan' set with 'n_output_vlan' entries.
 *
 * 'n_output_vlan' may be 0 or 1; if it is 0, then 'output_vlan'
 * may be NULL.
 *
 * Argument constraints: in range 1 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_output_vlan(const struct ovsrec_mirror *row, const int64_t *output_vlan, size_t n_output_vlan)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_output_vlan) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *output_vlan;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_OUTPUT_VLAN ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "select_all" column from the "Mirror" table in 'row' to
 * 'select_all'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_select_all(const struct ovsrec_mirror *row, bool select_all)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = select_all;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_SELECT_ALL ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "select_dst_port" column from the "Mirror" table in 'row' to
 * the 'select_dst_port' set with 'n_select_dst_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_select_dst_port(const struct ovsrec_mirror *row, struct ovsrec_port **select_dst_port, size_t n_select_dst_port)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_select_dst_port;
    datum.keys = n_select_dst_port ? xmalloc(n_select_dst_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_select_dst_port; i++) {
        datum.keys[i].uuid = select_dst_port[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_SELECT_DST_PORT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "select_src_port" column from the "Mirror" table in 'row' to
 * the 'select_src_port' set with 'n_select_src_port' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_select_src_port(const struct ovsrec_mirror *row, struct ovsrec_port **select_src_port, size_t n_select_src_port)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_select_src_port;
    datum.keys = n_select_src_port ? xmalloc(n_select_src_port * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_select_src_port; i++) {
        datum.keys[i].uuid = select_src_port[i]->header_.uuid;
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_UUID, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_SELECT_SRC_PORT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "select_vlan" column from the "Mirror" table in 'row' to
 * the 'select_vlan' set with 'n_select_vlan' entries.
 *
 * Argument constraints: in range 0 to 4,095
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_select_vlan(const struct ovsrec_mirror *row, const int64_t *select_vlan, size_t n_select_vlan)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_select_vlan;
    datum.keys = n_select_vlan ? xmalloc(n_select_vlan * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_select_vlan; i++) {
        datum.keys[i].integer = select_vlan[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_INTEGER, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_SELECT_VLAN ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "snaplen" column from the "Mirror" table in 'row' to
 * the 'snaplen' set with 'n_snaplen' entries.
 *
 * 'n_snaplen' may be 0 or 1; if it is 0, then 'snaplen'
 * may be NULL.
 *
 * Argument constraints: in range 14 to 65,535
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_snaplen(const struct ovsrec_mirror *row, const int64_t *snaplen, size_t n_snaplen)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_snaplen) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *snaplen;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_SNAPLEN ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

/* Sets the "statistics" column from the "Mirror" table in 'row' to
 * the map with keys 'key_statistics' and values 'value_statistics'
 * with 'n_statistics' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_mirror_index_set_statistics(const struct ovsrec_mirror *row, const char **key_statistics, const int64_t *value_statistics, size_t n_statistics)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_statistics;
    datum.keys = n_statistics ? xmalloc(n_statistics * sizeof *datum.keys) : NULL;
    datum.values = xmalloc(n_statistics * sizeof *datum.values);
    for (i = 0; i < n_statistics; i++) {
        datum.keys[i].string = xstrdup(key_statistics[i]);
        datum.values[i].integer = value_statistics[i];
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_INTEGER);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_mirror_columns[ OVSREC_MIRROR_COL_STATISTICS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_MIRROR]);
}

struct ovsdb_idl_column ovsrec_mirror_columns[OVSREC_MIRROR_N_COLUMNS];

unsigned int
ovsrec_mirror_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_mirror, condition);
}

struct ovsdb_idl_column ovsrec_mirror_columns[OVSREC_MIRROR_N_COLUMNS] = {
    [OVSREC_MIRROR_COL_EXTERNAL_IDS] = {
         .name = "external_ids",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_STRING,
                .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_external_ids,
         .unparse = ovsrec_mirror_unparse_external_ids,
    },

    [OVSREC_MIRROR_COL_NAME] = {
         .name = "name",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_name,
         .unparse = ovsrec_mirror_unparse_name,
    },

    [OVSREC_MIRROR_COL_OUTPUT_PORT] = {
         .name = "output_port",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Port", .refType = OVSDB_REF_WEAK },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_output_port,
         .unparse = ovsrec_mirror_unparse_output_port,
    },

    [OVSREC_MIRROR_COL_OUTPUT_VLAN] = {
         .name = "output_vlan",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(1), .max = INT64_C(4095) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_output_vlan,
         .unparse = ovsrec_mirror_unparse_output_vlan,
    },

    [OVSREC_MIRROR_COL_SELECT_ALL] = {
         .name = "select_all",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_select_all,
         .unparse = ovsrec_mirror_unparse_select_all,
    },

    [OVSREC_MIRROR_COL_SELECT_DST_PORT] = {
         .name = "select_dst_port",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Port", .refType = OVSDB_REF_WEAK },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_select_dst_port,
         .unparse = ovsrec_mirror_unparse_select_dst_port,
    },

    [OVSREC_MIRROR_COL_SELECT_SRC_PORT] = {
         .name = "select_src_port",
         .type = {
            .key = {
               .type = OVSDB_TYPE_UUID,
               .uuid = { .refTableName = "Port", .refType = OVSDB_REF_WEAK },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_select_src_port,
         .unparse = ovsrec_mirror_unparse_select_src_port,
    },

    [OVSREC_MIRROR_COL_SELECT_VLAN] = {
         .name = "select_vlan",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(0), .max = INT64_C(4095) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 4096,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_select_vlan,
         .unparse = ovsrec_mirror_unparse_select_vlan,
    },

    [OVSREC_MIRROR_COL_SNAPLEN] = {
         .name = "snaplen",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(14), .max = INT64_C(65535) },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 0,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_snaplen,
         .unparse = ovsrec_mirror_unparse_snaplen,
    },

    [OVSREC_MIRROR_COL_STATISTICS] = {
         .name = "statistics",
         .type = {
            .key = {
               .type = OVSDB_TYPE_STRING,
               .string = { .minLen = 0, .maxLen = UINT_MAX },
            },
            .value = {
                .type = OVSDB_TYPE_INTEGER,
                .integer = { .min = INT64_MIN, .max = INT64_MAX },
            },
            .n_min = 0,
            .n_max = UINT_MAX,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_mirror_parse_statistics,
         .unparse = ovsrec_mirror_unparse_statistics,
    },

};

/* NetFlow table. */

const struct ovsrec_netflow_table *
ovsrec_netflow_table_get(const struct ovsdb_idl *idl)
{
    return (const struct ovsrec_netflow_table *) idl;
}

const struct ovsrec_netflow *
ovsrec_netflow_table_first(const struct ovsrec_netflow_table *table)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_netflow_first(idl);
}


const struct ovsrec_netflow *
ovsrec_netflow_table_track_get_first(const struct ovsrec_netflow_table *table)
{
    const struct ovsdb_idl *idl =  (const struct ovsdb_idl *) table;
    return ovsrec_netflow_track_get_first(idl);
}


static void
ovsrec_netflow_parse_active_timeout(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);

    if (datum->n >= 1) {
        row->active_timeout = datum->keys[0].integer;
    } else {
        row->active_timeout = 0;
    }
}

static void
ovsrec_netflow_parse_add_id_to_interface(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);

    if (datum->n >= 1) {
        row->add_id_to_interface = datum->keys[0].boolean;
    } else {
        row->add_id_to_interface = false;
    }
}

static void
ovsrec_netflow_parse_engine_id(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    size_t n = MIN(1, datum->n);
    row->engine_id = NULL;
    row->n_engine_id = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_engine_id) {
            row->engine_id = xmalloc(n * sizeof *row->engine_id);
        }
        row->engine_id[row->n_engine_id] = datum->keys[i].integer;
        row->n_engine_id++;
    }
}

static void
ovsrec_netflow_parse_engine_type(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    size_t n = MIN(1, datum->n);
    row->engine_type = NULL;
    row->n_engine_type = 0;
    for (size_t i = 0; i < n; i++) {
        if (!row->n_engine_type) {
            row->engine_type = xmalloc(n * sizeof *row->engine_type);
        }
        row->engine_type[row->n_engine_type] = datum->keys[i].integer;
        row->n_engine_type++;
    }
}

static void
ovsrec_netflow_parse_external_ids(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    smap_init(&row->external_ids);
    for (size_t i = 0; i < datum->n; i++) {
        smap_add(&row->external_ids,
                 datum->keys[i].string,
                 datum->values[i].string);
    }
}

static void
ovsrec_netflow_parse_targets(struct ovsdb_idl_row *row_, const struct ovsdb_datum *datum)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    row->targets = NULL;
    row->n_targets = 0;
    for (size_t i = 0; i < datum->n; i++) {
        if (!row->n_targets) {
            row->targets = xmalloc(datum->n * sizeof *row->targets);
        }
        row->targets[row->n_targets] = datum->keys[i].string;
        row->n_targets++;
    }
}

static void
ovsrec_netflow_unparse_active_timeout(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_netflow_unparse_add_id_to_interface(struct ovsdb_idl_row *row OVS_UNUSED)
{
    /* Nothing to do. */
}

static void
ovsrec_netflow_unparse_engine_id(struct ovsdb_idl_row *row_)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    free(row->engine_id);
}

static void
ovsrec_netflow_unparse_engine_type(struct ovsdb_idl_row *row_)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    free(row->engine_type);
}

static void
ovsrec_netflow_unparse_external_ids(struct ovsdb_idl_row *row_)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    smap_destroy(&row->external_ids);
}

static void
ovsrec_netflow_unparse_targets(struct ovsdb_idl_row *row_)
{
    struct ovsrec_netflow *row = ovsrec_netflow_cast(row_);
    free(row->targets);
}

static void
ovsrec_netflow_init__(struct ovsdb_idl_row *row)
{
    ovsrec_netflow_init(ovsrec_netflow_cast(row));
}

/* Clears the contents of 'row' in table "NetFlow". */
void
ovsrec_netflow_init(struct ovsrec_netflow *row)
{
    memset(row, 0, sizeof *row); 
    smap_init(&row->external_ids);
}

/* Searches table "NetFlow" in 'idl' for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_netflow *
ovsrec_netflow_get_for_uuid(const struct ovsdb_idl *idl, const struct uuid *uuid)
{
    return ovsrec_netflow_cast(ovsdb_idl_get_row_for_uuid(idl, &ovsrec_table_netflow, uuid));
}

/* Searches table "NetFlow" for a row with UUID 'uuid'.  Returns
 * a pointer to the row if there is one, otherwise a null pointer.  */
const struct ovsrec_netflow *
ovsrec_netflow_table_get_for_uuid(const struct ovsrec_netflow_table *table, const struct uuid *uuid)
{
    const struct ovsdb_idl *idl = (const struct ovsdb_idl *) table;
    return ovsrec_netflow_get_for_uuid(idl, uuid);
}

/* Returns a row in table "NetFlow" in 'idl', or a null pointer if that
 * table is empty.
 *
 * Database tables are internally maintained as hash tables, so adding or
 * removing rows while traversing the same table can cause some rows to be
 * visited twice or not at apply. */
const struct ovsrec_netflow *
ovsrec_netflow_first(const struct ovsdb_idl *idl)
{
    return ovsrec_netflow_cast(ovsdb_idl_first_row(idl, &ovsrec_table_netflow));
}

/* Returns a row following 'row' within its table, or a null pointer if 'row'
 * is the last row in its table. */
const struct ovsrec_netflow *
ovsrec_netflow_next(const struct ovsrec_netflow *row)
{
    return ovsrec_netflow_cast(ovsdb_idl_next_row(&row->header_));
}

unsigned int ovsrec_netflow_get_seqno(const struct ovsdb_idl *idl)
{
    return ovsdb_idl_table_get_seqno(idl, &ovsrec_table_netflow);
}

unsigned int ovsrec_netflow_row_get_seqno(const struct ovsrec_netflow *row, enum ovsdb_idl_change change)
{
    return ovsdb_idl_row_get_seqno(&row->header_, change);
}

const struct ovsrec_netflow *
ovsrec_netflow_track_get_first(const struct ovsdb_idl *idl)
{
    return ovsrec_netflow_cast(ovsdb_idl_track_get_first(idl, &ovsrec_table_netflow));
}

const struct ovsrec_netflow
*ovsrec_netflow_track_get_next(const struct ovsrec_netflow *row)
{
    return ovsrec_netflow_cast(ovsdb_idl_track_get_next(&row->header_));
}


/* Deletes 'row' from table "NetFlow".  'row' may be freed, so it must not be
 * accessed afterward.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_delete(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_delete(&row->header_);
}

/* Inserts and returns a new row in the table "NetFlow" in the database
 * with open transaction 'txn'.
 *
 * The new row is assigned a randomly generated provisional UUID.
 * ovsdb-server will assign a different UUID when 'txn' is committed,
 * but the IDL will replace any uses of the provisional UUID in the
 * data to be to be committed by the UUID assigned by ovsdb-server. */
struct ovsrec_netflow *
ovsrec_netflow_insert(struct ovsdb_idl_txn *txn)
{
    return ovsrec_netflow_cast(ovsdb_idl_txn_insert(txn, &ovsrec_table_netflow, NULL));
}

bool
ovsrec_netflow_is_updated(const struct ovsrec_netflow *row, enum ovsrec_netflow_column_id column)
{
    return ovsdb_idl_track_is_updated(&row->header_, &ovsrec_netflow_columns[column]);
}

/* Causes the original contents of column "active_timeout" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "active_timeout" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "active_timeout" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "active_timeout" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "active_timeout" has already been modified (with
 *     ovsrec_netflow_set_active_timeout()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_active_timeout() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_active_timeout(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_active_timeout);
}

/* Causes the original contents of column "add_id_to_interface" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "add_id_to_interface" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "add_id_to_interface" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "add_id_to_interface" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "add_id_to_interface" has already been modified (with
 *     ovsrec_netflow_set_add_id_to_interface()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_add_id_to_interface() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_add_id_to_interface(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_add_id_to_interface);
}

/* Causes the original contents of column "engine_id" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "engine_id" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "engine_id" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "engine_id" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "engine_id" has already been modified (with
 *     ovsrec_netflow_set_engine_id()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_engine_id() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_engine_id(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_engine_id);
}

/* Causes the original contents of column "engine_type" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "engine_type" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "engine_type" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "engine_type" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "engine_type" has already been modified (with
 *     ovsrec_netflow_set_engine_type()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_engine_type() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_engine_type(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_engine_type);
}

/* Causes the original contents of column "external_ids" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "external_ids" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "external_ids" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "external_ids" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "external_ids" has already been modified (with
 *     ovsrec_netflow_set_external_ids()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_external_ids() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_external_ids(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_external_ids);
}

/* Causes the original contents of column "targets" in 'row' to be
 * verified as a prerequisite to completing the transaction.  That is, if
 * "targets" in 'row' changed (or if 'row' was deleted) between the
 * time that the IDL originally read its contents and the time that the
 * transaction aborts and ovsdb_idl_txn_commit() returns TXN_TRY_AGAIN.
 *
 * The intention is that, to ensure that no transaction commits based on dirty
 * reads, an application should call this function any time "targets" is
 * read as part of a read-modify-write operation.
 *
 * In some cases this function reduces to a no-op, because the current value
 * of "targets" is already known:
 *
 *   - If 'row' is a row created by the current transaction (returned by
 *     ovsrec_netflow_insert()).
 *
 *   - If "targets" has already been modified (with
 *     ovsrec_netflow_set_targets()) within the current transaction.
 *
 * Because of the latter property, always call this function *before*
 * ovsrec_netflow_set_targets() for a given read-modify-write.
 *
 * The caller must have started a transaction with ovsdb_idl_txn_create(). */
void
ovsrec_netflow_verify_targets(const struct ovsrec_netflow *row)
{
    ovsdb_idl_txn_verify(&row->header_, &ovsrec_netflow_col_targets);
}

/* Returns the "active_timeout" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes active_timeout's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "active_timeout" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_active_timeout(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_active_timeout);
}

/* Returns the "add_id_to_interface" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_BOOLEAN.
 * (This helps to avoid silent bugs if someone changes add_id_to_interface's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "add_id_to_interface" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_add_id_to_interface(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_BOOLEAN);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_add_id_to_interface);
}

/* Returns the "engine_id" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes engine_id's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "engine_id" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_engine_id(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_engine_id);
}

/* Returns the "engine_type" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_INTEGER.
 * (This helps to avoid silent bugs if someone changes engine_type's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "engine_type" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_engine_type(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_INTEGER);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_engine_type);
}

/* Returns the "external_ids" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * 'value_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes external_ids's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "external_ids" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_external_ids(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED,
	enum ovsdb_atomic_type value_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    ovs_assert(value_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_external_ids);
}

/* Returns the "targets" column's value from the "NetFlow" table in 'row'
 * as a struct ovsdb_datum.  This is useful occasionally: for example,
 * ovsdb_datum_find_key() is an easier and more efficient way to search
 * for a given key than implementing the same operation on the "cooked"
 * form in 'row'.
 *
 * 'key_type' must be OVSDB_TYPE_STRING.
 * (This helps to avoid silent bugs if someone changes targets's
 * type without updating the caller.)
 *
 * The caller must not modify or free the returned value.
 *
 * Various kinds of changes can invalidate the returned value: modifying
 * 'column' within 'row', deleting 'row', or completing an ongoing transaction.
 * If the returned value is needed for a long time, it is best to make a copy
 * of it with ovsdb_datum_clone().
 *
 * This function is rarely useful, since it is easier to access the value
 * directly through the "targets" member in ovsrec_netflow. */
const struct ovsdb_datum *
ovsrec_netflow_get_targets(const struct ovsrec_netflow *row,
	enum ovsdb_atomic_type key_type OVS_UNUSED)
{
    ovs_assert(key_type == OVSDB_TYPE_STRING);
    return ovsdb_idl_read(&row->header_, &ovsrec_netflow_col_targets);
}

/* Sets the "active_timeout" column from the "NetFlow" table in 'row' to
 * 'active_timeout'.
 *
 * Argument constraints: at least -1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_set_active_timeout(const struct ovsrec_netflow *row, int64_t active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = active_timeout;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_netflow_col_active_timeout, &datum);
}

/* Sets the "add_id_to_interface" column from the "NetFlow" table in 'row' to
 * 'add_id_to_interface'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_set_add_id_to_interface(const struct ovsrec_netflow *row, bool add_id_to_interface)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = add_id_to_interface;
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_netflow_col_add_id_to_interface, &datum);
}

/* Sets the "engine_id" column from the "NetFlow" table in 'row' to
 * the 'engine_id' set with 'n_engine_id' entries.
 *
 * 'n_engine_id' may be 0 or 1; if it is 0, then 'engine_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_set_engine_id(const struct ovsrec_netflow *row, const int64_t *engine_id, size_t n_engine_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_engine_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *engine_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_netflow_col_engine_id, &datum);
}

/* Sets the "engine_type" column from the "NetFlow" table in 'row' to
 * the 'engine_type' set with 'n_engine_type' entries.
 *
 * 'n_engine_type' may be 0 or 1; if it is 0, then 'engine_type'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_set_engine_type(const struct ovsrec_netflow *row, const int64_t *engine_type, size_t n_engine_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_engine_type) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *engine_type;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_txn_write_clone(&row->header_, &ovsrec_netflow_col_engine_type, &datum);
}

/* Sets the "external_ids" column's value from the "NetFlow" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_netflow_set_external_ids(const struct ovsrec_netflow *row, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }
    ovsdb_idl_txn_write(&row->header_,
                        &ovsrec_netflow_col_external_ids,
                        &datum);
}


/* Sets the "targets" column from the "NetFlow" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_set_targets(const struct ovsrec_netflow *row, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;

    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_targets; i++) {
        datum.keys[i].string = xstrdup(targets[i]);
    }
    ovsdb_idl_txn_write(&row->header_, &ovsrec_netflow_col_targets, &datum);
}

/* Adds the value 'new_value' to the "engine_id" set column from the "NetFlow" table
 * in 'row'.
 *
 */
void
ovsrec_netflow_update_engine_id_addvalue(const struct ovsrec_netflow *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_netflow_col_engine_id,
                                    datum);
}

/* Deletes the value 'delete_value' from the "engine_id" set column from the
 * "NetFlow" table in 'row'.
 *
 */
void
ovsrec_netflow_update_engine_id_delvalue(const struct ovsrec_netflow *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_netflow_col_engine_id,
                                    datum);
}

/* Adds the value 'new_value' to the "engine_type" set column from the "NetFlow" table
 * in 'row'.
 *
 */
void
ovsrec_netflow_update_engine_type_addvalue(const struct ovsrec_netflow *row, int64_t new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = new_value;

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_netflow_col_engine_type,
                                    datum);
}

/* Deletes the value 'delete_value' from the "engine_type" set column from the
 * "NetFlow" table in 'row'.
 *
 */
void
ovsrec_netflow_update_engine_type_delvalue(const struct ovsrec_netflow *row, int64_t delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].integer = delete_value;

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_netflow_col_engine_type,
                                    datum);
}

/* Sets an element of the "external_ids" map column from the "NetFlow" table in 'row'
 * to 'new_value' given the key value 'new_key'.
 *
 */
void
ovsrec_netflow_update_external_ids_setkey(const struct ovsrec_netflow *row, const char *new_key, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = xmalloc(datum->n * sizeof *datum->values);

    datum->keys[0].string = xstrdup(new_key);
    datum->values[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_map(&row->header_,
                                    &ovsrec_netflow_col_external_ids,
                                    datum);
}

/* Deletes an element of the "external_ids" map column from the "NetFlow" table in 'row'
 * given the key value 'delete_key'.
 *
 */
void
ovsrec_netflow_update_external_ids_delkey(const struct ovsrec_netflow *row, const char *delete_key)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->keys);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_key);

    ovsdb_idl_txn_delete_partial_map(&row->header_,
                                    &ovsrec_netflow_col_external_ids,
                                    datum);
}

/* Adds the value 'new_value' to the "targets" set column from the "NetFlow" table
 * in 'row'.
 *
 */
void
ovsrec_netflow_update_targets_addvalue(const struct ovsrec_netflow *row, const char *new_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(new_value);

    ovsdb_idl_txn_write_partial_set(&row->header_,
                                    &ovsrec_netflow_col_targets,
                                    datum);
}

/* Deletes the value 'delete_value' from the "targets" set column from the
 * "NetFlow" table in 'row'.
 *
 */
void
ovsrec_netflow_update_targets_delvalue(const struct ovsrec_netflow *row, const char *delete_value)
{
    struct ovsdb_datum *datum;

    datum = xmalloc(sizeof *datum);
    datum->n = 1;
    datum->keys = xmalloc(datum->n * sizeof *datum->values);
    datum->values = NULL;

    datum->keys[0].string = xstrdup(delete_value);

    ovsdb_idl_txn_delete_partial_set(&row->header_,
                                    &ovsrec_netflow_col_targets,
                                    datum);
}

/* Sets the "active_timeout" column from the "NetFlow" table in 'row' to
 * 'active_timeout'.
 *
 * Argument constraints: at least -1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_add_clause_active_timeout(struct ovsdb_idl_condition *cond, enum ovsdb_function function, int64_t active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.integer = active_timeout;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_netflow_col_active_timeout,
                          &datum);
}

/* Sets the "add_id_to_interface" column from the "NetFlow" table in 'row' to
 * 'add_id_to_interface'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_add_clause_add_id_to_interface(struct ovsdb_idl_condition *cond, enum ovsdb_function function, bool add_id_to_interface)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    datum.n = 1;
    datum.keys = &key;
    key.boolean = add_id_to_interface;
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_netflow_col_add_id_to_interface,
                          &datum);
}

/* Sets the "engine_id" column from the "NetFlow" table in 'row' to
 * the 'engine_id' set with 'n_engine_id' entries.
 *
 * 'n_engine_id' may be 0 or 1; if it is 0, then 'engine_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_add_clause_engine_id(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *engine_id, size_t n_engine_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_engine_id) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *engine_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_netflow_col_engine_id,
                          &datum);
}

/* Sets the "engine_type" column from the "NetFlow" table in 'row' to
 * the 'engine_type' set with 'n_engine_type' entries.
 *
 * 'n_engine_type' may be 0 or 1; if it is 0, then 'engine_type'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_add_clause_engine_type(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const int64_t *engine_type, size_t n_engine_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom key;

    if (n_engine_type) {
        datum.n = 1;
        datum.keys = &key;
        key.integer = *engine_type;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_netflow_col_engine_type,
                          &datum);
}

/* Sets the "external_ids" column's value from the "NetFlow" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_netflow_add_clause_external_ids(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const struct smap *external_ids)
{
    struct ovsdb_datum datum;

    if (external_ids) {
        ovsdb_datum_from_smap(&datum, external_ids);
    } else {
        ovsdb_datum_init_empty(&datum);
    }

    ovsdb_idl_condition_add_clause(cond,
                                   function,
                                   &ovsrec_netflow_col_external_ids,
                                   &datum);

    ovsdb_datum_destroy(&datum, &ovsrec_netflow_col_external_ids.type);
}


/* Sets the "targets" column from the "NetFlow" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_add_clause_targets(struct ovsdb_idl_condition *cond, enum ovsdb_function function, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;
    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (size_t i = 0; i < n_targets; i++) {
        datum.keys[i].string = CONST_CAST(char *, targets[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_condition_add_clause(cond,
                          function,
                          &ovsrec_netflow_col_targets,
                          &datum);
    free(datum.keys);
}

/* Destroy 'row' of kind "NetFlow". The row must have been
 * created with ovsdb_idl_index_init_row.
 */
void
ovsrec_netflow_index_destroy_row(const struct ovsrec_netflow *row)
{
    ovsdb_idl_index_destroy_row(&row->header_);
}
        

/* Creates a new row of kind "NetFlow". */
struct ovsrec_netflow *
ovsrec_netflow_index_init_row(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_netflow);
    return ALIGNED_CAST(struct ovsrec_netflow *, ovsdb_idl_index_init_row(index));
}

struct ovsrec_netflow *
ovsrec_netflow_index_find(struct ovsdb_idl_index *index, const struct ovsrec_netflow *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_netflow);
    return ovsrec_netflow_cast(ovsdb_idl_index_find(index, &target->header_));
}

/* Compares 'a' to 'b' and returns a strcmp()-type result. */
int
ovsrec_netflow_index_compare(
    struct ovsdb_idl_index *index, 
    const struct ovsrec_netflow *a, 
    const struct ovsrec_netflow *b)
{
    return ovsdb_idl_index_compare(index, &a->header_, &b->header_);
}

struct ovsdb_idl_cursor
ovsrec_netflow_cursor_first(struct ovsdb_idl_index *index)
{
    ovs_assert(index->table->class_ == &ovsrec_table_netflow);
    return ovsdb_idl_cursor_first(index);
}

struct ovsdb_idl_cursor
ovsrec_netflow_cursor_first_eq(
    struct ovsdb_idl_index *index, const struct ovsrec_netflow *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_netflow);
    return ovsdb_idl_cursor_first_eq(index, &target->header_);
}

struct ovsdb_idl_cursor
ovsrec_netflow_cursor_first_ge(
    struct ovsdb_idl_index *index, const struct ovsrec_netflow *target)
{
    ovs_assert(index->table->class_ == &ovsrec_table_netflow);
    return ovsdb_idl_cursor_first_ge(index, target ? &target->header_ : NULL);
}

struct ovsrec_netflow *
ovsrec_netflow_cursor_data(struct ovsdb_idl_cursor *cursor)
{
    return ovsrec_netflow_cast(ovsdb_idl_cursor_data(cursor));
}


/* Sets the "active_timeout" column from the "NetFlow" table in 'row' to
 * 'active_timeout'.
 *
 * Argument constraints: at least -1
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_index_set_active_timeout(const struct ovsrec_netflow *row, int64_t active_timeout)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->integer = active_timeout;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_netflow_columns[ OVSREC_NETFLOW_COL_ACTIVE_TIMEOUT ], &datum, &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
}

/* Sets the "add_id_to_interface" column from the "NetFlow" table in 'row' to
 * 'add_id_to_interface'.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_index_set_add_id_to_interface(const struct ovsrec_netflow *row, bool add_id_to_interface)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key = xmalloc(sizeof(union ovsdb_atom));

    datum.n = 1;
    datum.keys = key;
    key->boolean = add_id_to_interface;
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_netflow_columns[ OVSREC_NETFLOW_COL_ADD_ID_TO_INTERFACE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
}

/* Sets the "engine_id" column from the "NetFlow" table in 'row' to
 * the 'engine_id' set with 'n_engine_id' entries.
 *
 * 'n_engine_id' may be 0 or 1; if it is 0, then 'engine_id'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_index_set_engine_id(const struct ovsrec_netflow *row, const int64_t *engine_id, size_t n_engine_id)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_engine_id) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *engine_id;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_netflow_columns[ OVSREC_NETFLOW_COL_ENGINE_ID ], &datum, &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
}

/* Sets the "engine_type" column from the "NetFlow" table in 'row' to
 * the 'engine_type' set with 'n_engine_type' entries.
 *
 * 'n_engine_type' may be 0 or 1; if it is 0, then 'engine_type'
 * may be NULL.
 *
 * Argument constraints: in range 0 to 255
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_index_set_engine_type(const struct ovsrec_netflow *row, const int64_t *engine_type, size_t n_engine_type)
{
    struct ovsdb_datum datum;
    union ovsdb_atom *key;

    if (n_engine_type) {
        key = xmalloc(sizeof(union ovsdb_atom));
        datum.n = 1;
        datum.keys = key;
        key->integer = *engine_type;
    } else {
        datum.n = 0;
        datum.keys = NULL;
    }
    datum.values = NULL;
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_netflow_columns[ OVSREC_NETFLOW_COL_ENGINE_TYPE ], &datum, &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
}

/* Sets the "external_ids" column's value from the "NetFlow" table in 'row'
 * to 'external_ids'.
 *
 * The caller retains ownership of 'external_ids' and everything in it. */
void
ovsrec_netflow_index_set_external_ids(const struct ovsrec_netflow *row, const struct smap *external_ids)
{
    struct ovsdb_datum *datum = xmalloc(sizeof(struct ovsdb_datum));

    if (external_ids) {
        struct smap_node *node;
        size_t i;

        datum->n = smap_count(external_ids);
        datum->keys = xmalloc(datum->n * sizeof *datum->keys);
        datum->values = xmalloc(datum->n * sizeof *datum->values);

        i = 0;
        SMAP_FOR_EACH (node, external_ids) {
            datum->keys[i].string = node->key;
            datum->values[i].string = node->value;
            i++;
        }
        ovsdb_datum_sort_unique(datum, OVSDB_TYPE_STRING, OVSDB_TYPE_STRING);
    } else {
        ovsdb_datum_init_empty(datum);
    }
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_),
                          &ovsrec_netflow_columns[OVSREC_NETFLOW_COL_EXTERNAL_IDS],
                          datum,
                          &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
    free(datum);
}


/* Sets the "targets" column from the "NetFlow" table in 'row' to
 * the 'targets' set with 'n_targets' entries.
 *
 * The caller retains ownership of the arguments. */
void
ovsrec_netflow_index_set_targets(const struct ovsrec_netflow *row, const char **targets, size_t n_targets)
{
    struct ovsdb_datum datum;
    size_t i;

    datum.n = n_targets;
    datum.keys = n_targets ? xmalloc(n_targets * sizeof *datum.keys) : NULL;
    datum.values = NULL;
    for (i = 0; i < n_targets; i++) {
        datum.keys[i].string = xstrdup(targets[i]);
    }
    ovsdb_datum_sort_unique(&datum, OVSDB_TYPE_STRING, OVSDB_TYPE_VOID);
    ovsdb_idl_index_write(CONST_CAST(struct ovsdb_idl_row *, &row->header_), &ovsrec_netflow_columns[ OVSREC_NETFLOW_COL_TARGETS ], &datum, &ovsrec_table_classes[OVSREC_TABLE_NETFLOW]);
}

struct ovsdb_idl_column ovsrec_netflow_columns[OVSREC_NETFLOW_N_COLUMNS];

unsigned int
ovsrec_netflow_set_condition(struct ovsdb_idl *idl, struct ovsdb_idl_condition *condition)
{
    return ovsdb_idl_set_condition(idl, &ovsrec_table_netflow, condition);
}

struct ovsdb_idl_column ovsrec_netflow_columns[OVSREC_NETFLOW_N_COLUMNS] = {
    [OVSREC_NETFLOW_COL_ACTIVE_TIMEOUT] = {
         .name = "active_timeout",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
               .integer = { .min = INT64_C(-1), .max = INT64_MAX },
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_netflow_parse_active_timeout,
         .unparse = ovsrec_netflow_unparse_active_timeout,
    },

    [OVSREC_NETFLOW_COL_ADD_ID_TO_INTERFACE] = {
         .name = "add_id_to_interface",
         .type = {
            .key = {
               .type = OVSDB_TYPE_BOOLEAN,
            },
            .value = OVSDB_BASE_VOID_INIT,
            .n_min = 1,
            .n_max = 1,
         },
         .is_mutable = true,
         .is_synthetic = false,
         .parse = ovsrec_netflow_parse_add_id_to_interface,
         .unparse = ovsrec_netflow_unparse_add_id_to_interface,
    },

    [OVSREC_NETFLOW_COL_ENGINE_ID] = {
         .name = "engine_id",
         .type = {
            .key = {
               .type = OVSDB_TYPE_INTEGER,
       