/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.ATabbedPaneListener;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.StainedListener;
import net.sf.sdedit.util.Utilities;

public class ATabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -1422640863L;
    private static Image clean = Icons.getIcon("close").getImage();
    private static Image stain = Icons.getIcon("close2").getImage();
    private List<ATabbedPaneListener> listeners = new LinkedList<ATabbedPaneListener>();

    public ATabbedPane() {
        super(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int tabNumber = ATabbedPane.this.getUI().tabForCoordinate(ATabbedPane.this, e.getX(), e.getY());
                if (tabNumber < 0) {
                    return;
                }
                Rectangle rect = ((ACloseTabIcon)ATabbedPane.this.getIconAt(tabNumber)).getBounds();
                if (rect.contains(e.getX(), e.getY())) {
                    ATabbedPane.this.selectAndCloseTab(tabNumber);
                }
            }
        });
    }

    public String getCurrentTitle() {
        if (this.getSelectedIndex() == -1) {
            return "";
        }
        return this.getTitleAt(this.getSelectedIndex());
    }

    public void addListener(ATabbedPaneListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ATabbedPaneListener listener) {
        this.listeners.remove(listener);
    }

    private String generateUniqueTabName(String tabName) {
        LinkedList<String> titles = new LinkedList<String>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            titles.add(this.getTitleAt(i));
        }
        return Utilities.findUniqueName(tabName, titles);
    }

    public void setTabTitle(String title) {
        int i = this.getSelectedIndex();
        this.setTitleAt(i, "");
        title = this.generateUniqueTabName(title);
        this.setTitleAt(i, title);
    }

    public String addTab(Component tab, String title) {
        title = this.generateUniqueTabName(title);
        ACloseTabIcon icon = new ACloseTabIcon(tab, this);
        this.addTab(title, icon, tab);
        this.setSelectedIndex(this.getTabCount() - 1);
        return title;
    }

    public String addTab(Component tab, String title, Icon closeIcon) {
        title = this.generateUniqueTabName(title);
        ACloseTabIcon icon = null;
        if (closeIcon != null) {
            icon = new ACloseTabIcon(tab, this, closeIcon);
        }
        this.addTab(title, icon, tab);
        this.setSelectedIndex(this.getTabCount() - 1);
        return title;
    }

    public boolean removeCurrentTab(boolean oneOpen) {
        if (this.getTabCount() == 0) {
            return false;
        }
        if (oneOpen && this.getTabCount() == 1) {
            return false;
        }
        int number = this.getSelectedIndex();
        if (number != -1) {
            this.remove(number);
            return true;
        }
        return false;
    }

    public void selectByName(String tabName) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String title = this.getTitleAt(i);
            if (!title.equals(tabName)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    protected void fireCurrentTabClosing() {
        Component selected = this.getSelectedComponent();
        for (ATabbedPaneListener listener : this.listeners) {
            listener.tabClosing(selected);
        }
    }

    protected void selectAndCloseTab(int number) {
        this.setSelectedIndex(number);
        if (this.getTabCount() > 1) {
            this.fireCurrentTabClosing();
        }
    }

    private class ACloseTabIcon
    implements Icon,
    StainedListener {
        private int x_pos;
        private int y_pos;
        private Image image;

        public ACloseTabIcon(Component tab, ATabbedPane pane, Icon icon) {
            this.image = ((ImageIcon)icon).getImage();
        }

        public ACloseTabIcon(Component tab, ATabbedPane pane) {
            if (tab instanceof Stainable) {
                ((Stainable)((Object)tab)).addStainedListener(this);
            }
            this.image = clean;
        }

        @Override
        public void stainedStatusChanged(Stainable stainable, boolean stained) {
            this.image = stained ? stain : clean;
            ATabbedPane.this.repaint();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.image, x, y, c);
            this.x_pos = x;
            this.y_pos = y;
        }

        @Override
        public int getIconWidth() {
            return this.image.getWidth(null);
        }

        @Override
        public int getIconHeight() {
            return this.image.getHeight(null);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.getIconWidth(), this.getIconHeight());
        }
    }
}

