// services/network/public/mojom/isolation_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/isolation_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/isolation_info.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, IsolationInfoRedirectMode value) {
  switch(value) {
    case IsolationInfoRedirectMode::kUpdateTopFrame:
      return os << "IsolationInfoRedirectMode::kUpdateTopFrame";
    case IsolationInfoRedirectMode::kUpdateFrameOnly:
      return os << "IsolationInfoRedirectMode::kUpdateFrameOnly";
    case IsolationInfoRedirectMode::kUpdateNothing:
      return os << "IsolationInfoRedirectMode::kUpdateNothing";
    default:
      return os << "Unknown IsolationInfoRedirectMode value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool IsolationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IsolationInfo_Data* object = static_cast<const IsolationInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::IsolationInfoRedirectMode_Data
        ::Validate(object->redirect_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  return true;
}

IsolationInfo_Data::IsolationInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network