// third_party/blink/public/mojom/loader/resource_load_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
CommonNetworkInfo::CommonNetworkInfo()
    : network_accessed(),
      always_access_network(),
      remote_endpoint() {}

CommonNetworkInfo::CommonNetworkInfo(
    bool network_accessed_in,
    bool always_access_network_in,
    const base::Optional<::net::IPEndPoint>& remote_endpoint_in)
    : network_accessed(std::move(network_accessed_in)),
      always_access_network(std::move(always_access_network_in)),
      remote_endpoint(std::move(remote_endpoint_in)) {}

CommonNetworkInfo::~CommonNetworkInfo() = default;

void CommonNetworkInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("network_accessed", this->network_accessed);
  value->SetBoolean("always_access_network", this->always_access_network);
  value->SetString("remote_endpoint", base::trace_event::ValueToString(this->remote_endpoint, "<value of type const base::Optional<::net::IPEndPoint>&>"));
}

bool CommonNetworkInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RedirectInfo::RedirectInfo()
    : origin_of_new_url(),
      network_info() {}

RedirectInfo::RedirectInfo(
    const ::url::Origin& origin_of_new_url_in,
    CommonNetworkInfoPtr network_info_in)
    : origin_of_new_url(std::move(origin_of_new_url_in)),
      network_info(std::move(network_info_in)) {}

RedirectInfo::~RedirectInfo() = default;

void RedirectInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("origin_of_new_url", base::trace_event::ValueToString(this->origin_of_new_url, "<value of type const ::url::Origin&>"));
  if (this->network_info.is_null()) {
    value->SetString("network_info", "nullptr");
  } else {
    value->BeginDictionary("network_info");
    this->network_info->AsValueInto(value);
    value->EndDictionary();
  }
}

bool RedirectInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResourceLoadInfo::ResourceLoadInfo()
    : request_id(),
      final_url(),
      referrer(),
      original_url(),
      method(),
      request_destination(),
      request_priority(),
      mime_type(),
      was_cached(),
      network_info(),
      net_error(),
      load_timing_info(),
      raw_body_bytes(),
      total_received_bytes(),
      redirect_info_chain() {}

ResourceLoadInfo::ResourceLoadInfo(
    int64_t request_id_in,
    const ::GURL& final_url_in,
    const ::GURL& referrer_in,
    const ::GURL& original_url_in,
    const std::string& method_in,
    ::network::mojom::RequestDestination request_destination_in,
    ::net::RequestPriority request_priority_in,
    const std::string& mime_type_in,
    bool was_cached_in,
    CommonNetworkInfoPtr network_info_in,
    int32_t net_error_in,
    const ::net::LoadTimingInfo& load_timing_info_in,
    int64_t raw_body_bytes_in,
    int64_t total_received_bytes_in,
    std::vector<RedirectInfoPtr> redirect_info_chain_in)
    : request_id(std::move(request_id_in)),
      final_url(std::move(final_url_in)),
      referrer(std::move(referrer_in)),
      original_url(std::move(original_url_in)),
      method(std::move(method_in)),
      request_destination(std::move(request_destination_in)),
      request_priority(std::move(request_priority_in)),
      mime_type(std::move(mime_type_in)),
      was_cached(std::move(was_cached_in)),
      network_info(std::move(network_info_in)),
      net_error(std::move(net_error_in)),
      load_timing_info(std::move(load_timing_info_in)),
      raw_body_bytes(std::move(raw_body_bytes_in)),
      total_received_bytes(std::move(total_received_bytes_in)),
      redirect_info_chain(std::move(redirect_info_chain_in)) {}

ResourceLoadInfo::~ResourceLoadInfo() = default;

void ResourceLoadInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("request_id", base::NumberToString(this->request_id));
  value->SetString("final_url", base::trace_event::ValueToString(this->final_url, "<value of type const ::GURL&>"));
  value->SetString("referrer", base::trace_event::ValueToString(this->referrer, "<value of type const ::GURL&>"));
  value->SetString("original_url", base::trace_event::ValueToString(this->original_url, "<value of type const ::GURL&>"));
  value->SetString("method", this->method);
  value->SetString("request_destination", base::trace_event::ValueToString(this->request_destination));
  value->SetInteger("request_priority", static_cast<int>(this->request_priority));
  value->SetString("mime_type", this->mime_type);
  value->SetBoolean("was_cached", this->was_cached);
  if (this->network_info.is_null()) {
    value->SetString("network_info", "nullptr");
  } else {
    value->BeginDictionary("network_info");
    this->network_info->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("net_error", this->net_error);
  value->SetString("load_timing_info", base::trace_event::ValueToString(this->load_timing_info, "<value of type const ::net::LoadTimingInfo&>"));
  value->SetString("raw_body_bytes", base::NumberToString(this->raw_body_bytes));
  value->SetString("total_received_bytes", base::NumberToString(this->total_received_bytes));
  value->BeginArray("redirect_info_chain");
  for (const auto& item0 : this->redirect_info_chain) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool ResourceLoadInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::CommonNetworkInfo::DataView, ::blink::mojom::CommonNetworkInfoPtr>::Read(
    ::blink::mojom::CommonNetworkInfo::DataView input,
    ::blink::mojom::CommonNetworkInfoPtr* output) {
  bool success = true;
  ::blink::mojom::CommonNetworkInfoPtr result(::blink::mojom::CommonNetworkInfo::New());
  
      if (success)
        result->network_accessed = input.network_accessed();
      if (success)
        result->always_access_network = input.always_access_network();
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::RedirectInfo::DataView, ::blink::mojom::RedirectInfoPtr>::Read(
    ::blink::mojom::RedirectInfo::DataView input,
    ::blink::mojom::RedirectInfoPtr* output) {
  bool success = true;
  ::blink::mojom::RedirectInfoPtr result(::blink::mojom::RedirectInfo::New());
  
      if (success && !input.ReadOriginOfNewUrl(&result->origin_of_new_url))
        success = false;
      if (success && !input.ReadNetworkInfo(&result->network_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ResourceLoadInfo::DataView, ::blink::mojom::ResourceLoadInfoPtr>::Read(
    ::blink::mojom::ResourceLoadInfo::DataView input,
    ::blink::mojom::ResourceLoadInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ResourceLoadInfoPtr result(::blink::mojom::ResourceLoadInfo::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success && !input.ReadFinalUrl(&result->final_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadRequestDestination(&result->request_destination))
        success = false;
      if (success && !input.ReadRequestPriority(&result->request_priority))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->was_cached = input.was_cached();
      if (success && !input.ReadNetworkInfo(&result->network_info))
        success = false;
      if (success)
        result->net_error = input.net_error();
      if (success && !input.ReadLoadTimingInfo(&result->load_timing_info))
        success = false;
      if (success)
        result->raw_body_bytes = input.raw_body_bytes();
      if (success)
        result->total_received_bytes = input.total_received_bytes();
      if (success && !input.ReadRedirectInfoChain(&result->redirect_info_chain))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif