/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.ExitableReturn;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.interpreter.ExitableInterpreterContext;
import org.jruby.ir.interpreter.ExitableInterpreterEngineState;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.interpreter.Profiler;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.RubyStringBuilder;

public class ExitableInterpreterEngine
extends InterpreterEngine {
    public ExitableReturn interpret(ThreadContext context, Block block, IRubyObject self2, ExitableInterpreterContext interpreterContext, ExitableInterpreterEngineState state2, RubyModule implClass, String name2, IRubyObject[] args2, Block blockArg) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = state2.getTemporaryVariables();
        int n = instrs.length;
        int ipc = state2.getIPC();
        int exitIPC = interpreterContext.getExitIPC();
        Throwable exception2 = null;
        boolean acceptsKeywordArgument = interpreterContext.receivesKeywordArguments();
        if (acceptsKeywordArgument) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, interpreterContext.getRequiredArgsCount());
        }
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        int[] rescuePCs = interpreterContext.getRescueIPCs();
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Integer scopeVersion = profile ? Profiler.initProfiling(interpreterContext.getScope()) : 0;
        block17: while (ipc < n) {
            if (ipc == exitIPC) {
                state2.setIPC(ipc + 1);
                return new ExitableReturn(context.runtime.newArray(interpreterContext.getArgs(context, self2, currScope, currDynScope, temp)), ((CallBase)instrs[ipc]).prepareBlock(context, self2, currScope, currDynScope, temp));
            }
            Instr instr = instrs[ipc];
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: " + ipc + ", R: " + rescuePCs[ipc] + " - " + instr + ">", new Object[0]);
                ++Interpreter.interpInstrsCount;
            } else if (profile) {
                Profiler.instrTick(operation);
                ++Interpreter.interpInstrsCount;
            }
            try {
                block1 : switch (operation.opClass) {
                    case ARG_OP: {
                        ExitableInterpreterEngine.receiveArg(context, instr, operation, args2, acceptsKeywordArgument, currDynScope, temp, exception2, blockArg);
                        break;
                    }
                    case CALL_OP: {
                        if (profile) {
                            Profiler.updateCallSite(instr, interpreterContext.getScope(), scopeVersion);
                        }
                        ExitableInterpreterEngine.processCall(context, instr, operation, currDynScope, currScope, temp, self2);
                        break;
                    }
                    case RET_OP: {
                        ExitableInterpreterEngine.processReturnOp(context, block, instr, operation, currDynScope, temp, self2, currScope);
                        return new ExitableReturn(context.runtime.newArray(), Block.NULL_BLOCK);
                    }
                    case BRANCH_OP: {
                        switch (operation) {
                            case JUMP: {
                                JumpInstr jump = (JumpInstr)instr;
                                ipc = jump.getJumpTarget().getTargetPC();
                                continue block17;
                            }
                        }
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc + 1);
                        continue block17;
                    }
                    case BOOK_KEEPING_OP: {
                        switch (operation) {
                            case PUSH_METHOD_BINDING: {
                                currDynScope = interpreterContext.newDynamicScope(context);
                                context.pushScope(currDynScope);
                            }
                            case EXC_REGION_START: 
                            case EXC_REGION_END: {
                                break block1;
                            }
                        }
                        ExitableInterpreterEngine.processBookKeepingOp(context, block, instr, operation, name2, args2, self2, blockArg, implClass, currDynScope, temp, currScope);
                        break;
                    }
                    case OTHER_OP: {
                        ExitableInterpreterEngine.processOtherOp(context, block, instr, operation, currDynScope, currScope, temp, self2);
                    }
                }
                ++ipc;
            }
            catch (Throwable t) {
                if (debug) {
                    ExitableInterpreterEngine.extractToMethodToAvoidC2Crash(instr, t);
                }
                int n2 = ipc = rescuePCs == null ? -1 : rescuePCs[ipc];
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    protected static void processOtherOp(ThreadContext context, Block block, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2) {
        switch (operation) {
            case RECV_SELF: {
                break;
            }
            case COPY: {
                CopyInstr c = (CopyInstr)instr;
                ExitableInterpreterEngine.setResult(temp, currDynScope, c.getResult(), ExitableInterpreterEngine.retrieveOp(c.getSource(), context, self2, currDynScope, currScope, temp));
                break;
            }
            case GET_FIELD: {
                IRubyObject result2;
                GetFieldInstr gfi = (GetFieldInstr)instr;
                IRubyObject object = (IRubyObject)gfi.getSource().retrieve(context, self2, currScope, currDynScope, temp);
                VariableAccessor a = gfi.getAccessor(object);
                IRubyObject iRubyObject = result2 = a == null ? null : (IRubyObject)a.get(object);
                if (result2 == null) {
                    if (context.runtime.isVerbose()) {
                        context.runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, RubyStringBuilder.str(context.runtime, "instance variable ", RubyStringBuilder.ids(context.runtime, gfi.getId()), " not initialized"));
                    }
                    result2 = context.nil;
                }
                ExitableInterpreterEngine.setResult(temp, currDynScope, gfi.getResult(), (Object)result2);
                break;
            }
            case RUNTIME_HELPER: {
                RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                ExitableInterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, block));
                break;
            }
            case CHECK_FOR_LJE: {
                ((CheckForLJEInstr)instr).check(context, currDynScope, block);
                break;
            }
            case LOAD_FRAME_CLOSURE: {
                ExitableInterpreterEngine.setResult(temp, currDynScope, instr, (Object)context.getFrameBlock());
                return;
            }
            default: {
                ExitableInterpreterEngine.setResult(temp, currDynScope, instr, instr.interpret(context, currScope, currDynScope, self2, temp));
            }
        }
    }
}

