"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeDraggable = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../../services");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiRangeDraggable = function EuiRangeDraggable(_ref) {
  var className = _ref.className,
      showTicks = _ref.showTicks,
      lowerPosition = _ref.lowerPosition,
      upperPosition = _ref.upperPosition,
      compressed = _ref.compressed,
      onChange = _ref.onChange,
      min = _ref.min,
      max = _ref.max,
      disabled = _ref.disabled,
      value = _ref.value,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "showTicks", "lowerPosition", "upperPosition", "compressed", "onChange", "min", "max", "disabled", "value"]);
  var outerStyle = {
    left: "calc(".concat(lowerPosition, ")"),
    right: "calc(100% - ".concat(upperPosition, " - 16px)")
  };
  var classes = (0, _classnames.default)('euiRangeDraggable', {
    'euiRangeDraggable--hasTicks': showTicks,
    'euiRangeDraggable--compressed': compressed,
    'euiRangeDraggable--disabled': disabled
  }, className);

  var handleChange = function handleChange(_ref2, isFirstInteraction) {
    var x = _ref2.x;
    if (disabled) return;
    onChange(x, isFirstInteraction);
  };

  var _useMouseMove = (0, _services.useMouseMove)(handleChange),
      _useMouseMove2 = (0, _slicedToArray2.default)(_useMouseMove, 2),
      handleMouseDown = _useMouseMove2[0],
      handleInteraction = _useMouseMove2[1];

  var commonProps = {
    className: classes,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': value[0],
    'aria-valuetext': "".concat(value[0], ", ").concat(value[1]),
    'aria-disabled': !!disabled,
    tabIndex: !!disabled ? -1 : 0
  };
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    style: outerStyle
  }, commonProps, rest), /*#__PURE__*/_react.default.createElement("div", {
    className: "euiRangeDraggle__inner",
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction
  }));
};

exports.EuiRangeDraggable = EuiRangeDraggable;
EuiRangeDraggable.propTypes = {
  min: _propTypes.default.number.isRequired,
  max: _propTypes.default.number.isRequired,
  value: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  disabled: _propTypes.default.bool,
  compressed: _propTypes.default.bool,
  showTicks: _propTypes.default.bool,
  lowerPosition: _propTypes.default.string.isRequired,
  upperPosition: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired
};