Changelog
=========

#### 1.3.6 - March 27, 2019

**Improvements**

- Don't strip HTML from variable replacements in HTML emails. This change allows you to link to uploaded files properly.


#### 1.3.5 - January 29, 2019

**Improvements**

- Allow adding form field variables to the form's redirect URL.


#### 1.3.4 - January 9, 2019

**Improvements**

- Reload available field variables when adding action on form settings page.
- Add role="alert" attribute to all form messages.
- Emit "message" event whenever message is shown to user.


#### 1.3.3 - November 6, 2018

**Fixes**

- Fix selected state of email content type.

**Improvements**

- Add filter & action hook for extending forms with custom messages & message settings.
- Don't add line-breaks automatically when using HTML emails.
- Delete all related postmeta when deleting a submission.


#### 1.3.2 - Aug 6, 2018

**Improvements**

- Default to an empty string value in conditional fields logic. This allows you to show or hide elements when a field is empty or has not been set yet.


#### 1.3.1 - June 12, 2018

**Improvements**

- Format dates, files and arrays when using data variables.
- Format dates, files and arrays on the submissions overview and submissions details pages.
- Allow cancelling a form's submit event in JavaScript (with `event.stopPropagation()`) to prevent form submission.


#### 1.3.0 - May 28, 2018

**Fixes**

- PHP notice because of namespace import outside of any namespace.
- Removed usage of PHP 5.4+ feature.
- Enforce HTTPS in form preview iframe when WP Admin uses HTTPS but public site does not.

**Improvements**

- Hook into GDPR Personal Data Export & Erase functionality. Requires WP 4.9.6.
- Allow updating stored Submissions with empty values. [Allows clearing out IP address & user agents](https://github.com/ibericode/html-forms-code-snippets/blob/master/do-not-store-ip-address-and-user-agent.php).
- Internal field should start with underscore to hide it in column view.
- Add for attribute to generated label element. Allows for simple [multi-step forms](https://github.com/ibericode/html-forms-code-snippets/blob/master/multi-step-form.html).

**Additions**

- Add support for button clicks in conditional element logic.


#### 1.2.0 - April 24, 2018

**Fixes**

- Remove use of short-array syntax, which is only available in PHP 5.4 or later.

**Improvements**

- You can now hide columns on the submissions tab using screen options (in the top right corner).
- You can now disable saving submissions on a per-form basis.
- Allow pre-checking multiple checkboxes when using the field helper
- Fields with matching URL parameter names will automatically be prefilled.
- Use SVG icon in admin menu.

**Additions**

- Add simple action for subscribing to MailChimp. Requires [MailChimp for WordPress](https://wordpress.org/plugins/mailchimp-for-wp/).


#### 1.1.5 - April 9, 2018

**Fixes**

- Conditionally hidden fields are now ignored in server-side required field validation too. Thanks [Jeroen Sormani](https://github.com/JeroenSormani)!

**Improvements**

- Added foundational stuff for being able to handle file uploads.

**Additions**

- Added `hf_process_form` action to execute code before the form actions run.


#### 1.1.4 - March 28, 2018

**Fixes**

- Ensure form is fully functional in live preview.
- Show all forms on the forms overview page (limit was 5).
- Parse field variables in custom email headers. Thanks [Jeroen Sormani](https://github.com/JeroenSormani)!

**Improvements**

- You can now [bind JavaScript events](https://kb.htmlforms.io/javascript-events/) using the default browser API, eg `document.getElementById('hf-form-5').addEventListener('hf-success', ..);`
- Only load JavaScript file on pages with a form on it. 
- Don't add line-breaks in HTML generated by the Field Builder.
- [Conditional elements](https://kb.htmlforms.io/conditional-elements/) now accept wildcard values: `*`
- Available field variables in email action settings are now clickable.

**Additions**

- Added several action & filter hooks to enable advanced functionality in [HTML Forms Premium](https://www.htmlforms.io/premium-features/).


#### 1.1.3 - February 12, 2018

**Fixes**

- Form preview was not working when WPML was activated.

**Improvements**

- Improved theme compatibility for the form preview.
- Print submission details as JSON instead of PHP object.
- Form messages are now added to the element as data attributes, so they can be used in JavaScript event callbacks.

**Additions**

- [Conditional logic](https://kb.htmlforms.io/conditional-elements/) now accepts multiple values, separated by the |-character.


#### 1.1.2 - January 18, 2018

**Fixes**

- Conditional elements visible in form preview.
- WP_List_Table issue on forms overview page.

**Improvements**

- Allow disabling submission storage through a global setting.
- Hide submissions tab when submission storage is disabled.
- Prevent PHP notice if `$_SERVER` global is missing properties.
- Update JavaScript dependencies.

**Additions**

- Filter: `hf_ignored_field_names`


#### 1.1.1 - December 21, 2017

**Fixes**

- Incorrect role capability for administrators.


#### 1.1 - December 21, 2017

**Fixes**

- JavaScript error in some older browser when submitting the form.

**Improvements**

- Use custom user capability base for editing & viewing forms.
- Delay form response until a later hook so other plugins get a chance to hook in.
- Disable client-side validation for conditional fields marked as required.

**Additions**

- Added live preview to the form editor.


#### 1.0.6 - December 11, 2017

**Fixes**

- Array replacements in email message were showing "Array" instead of a comma separated list of values.
- Don't reset form when there are errors. Thanks [Jeroen Sormani](https://github.com/JeroenSormani)!

**Additions**

- You can now use certain [template variables](https://kb.htmlforms.io/template-variables/) in the form content which will be dynamically replaced. 
- Added `hf_validate_form_{$form_slug}` filter hook.
- Added `hf_form_{$form_slug}_success` action hook.


#### 1.0.5 - November 18, 2017

**Fixes**

- Could not save more than one "Email" action.


#### 1.0.4 - November 10, 2017

**Fixes**

- Incompatibility with PHP versions before 5.6.
- Data variables could not be placed on the same line.

**Improvements**

- Clear output buffer before sending AJAX response to prevent issues with response parsing.

**Additions**

- Added `hf_form_message_{$code}` filter hook.



#### 1.0.3 - November 6, 2017

**Additions**

- Added [support for conditional elements](https://kb.htmlforms.io/conditional-elements/) by using `data-show-if` and `data-hide-if` attributes.

**Improvements**

- Accept `id` argument in `[hf_form]` shortcode.
- Catch errors in shortcode's `slug` attribute.
- Allow changing form slug after initial form is saved.

**Fixes**

- Fixes stylesheet URL when option to load stylesheet is toggled.



#### 1.0.2 - October 30, 2017

**Fixes**

- Form validation always failing when form has 0 required fields.

**Improvements**

- Fake success response when honeypot validation fails.
- Validate request by comparing size of POST array with number of form fields.
- Ensure submit button never has label element when using the field helper.
- Optimize URL generation of asset files on frontend.

**Additions**

- Added `hf_validate_form_request_size` filter hook.


#### 1.0.1 - October 28, 2017

**Improvements**
- Added SVG admin menu icon.
- Field names are now sanitized before they are saved in the database.
- Submit button was missing for default form fields.
- Unneeded `<form>` tags are now stripped from the form before saving.

**Additions**
- Added `data-title` and `data-slug` attributes to the `<form>` element on the frontend.


#### 1.0 - October 25, 2017

Introducing a first version of HTML Forms, a different approach to forms for WordPress sites.


