
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "pluginspec_wrapper.h"

// inner classes

// Extra includes
#include <plugins.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PluginSpec_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PluginSpec >()))
        return -1;

    ::PluginSpec *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PluginSpec.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "PluginSpec", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PluginSpec::PluginSpec()
    // 1: PluginSpec::PluginSpec(PluginSpec)
    if (numArgs == 0) {
        overloadId = 0; // PluginSpec()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PluginSpec(PluginSpec)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PluginSpec_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // PluginSpec()
        {

            if (!PyErr_Occurred()) {
                // PluginSpec()
                cptr = new ::PluginSpec();
            }
            break;
        }
        case 1: // PluginSpec(const PluginSpec & PluginSpec)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PluginSpec cppArg0_local;
            ::PluginSpec *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // PluginSpec(PluginSpec)
                cptr = new ::PluginSpec(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PluginSpec >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_PluginSpec_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_PluginSpec_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_PluginSpec___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PluginSpec_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PluginSpec_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PluginSpec___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_PluginSpec_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), (pyArg)))) {
                // operator==(const PluginSpec & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PluginSpec cppArg0_local;
                ::PluginSpec *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_PluginSpec_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_PluginSpec_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_PluginSpec_get_name(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->name);
    return pyOut;
}
static int Sbk_PluginSpec_set_name(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'name' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'name', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->name;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_description(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->description);
    return pyOut;
}
static int Sbk_PluginSpec_set_description(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'description' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'description', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->description;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_author(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->author);
    return pyOut;
}
static int Sbk_PluginSpec_set_author(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'author' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'author', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->author;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_version(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->version);
    return pyOut;
}
static int Sbk_PluginSpec_set_version(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'version' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'version', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->version;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_PluginSpec_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QPixmap' or convertible type expected");
        return -1;
    }

    ::QPixmap& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_hasSettings(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->hasSettings;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_PluginSpec_set_hasSettings(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'hasSettings' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'hasSettings', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->hasSettings;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->hasSettings = cppOut_local;

    return 0;
}

// Getters and Setters for PluginSpec
static PyGetSetDef Sbk_PluginSpec_getsetlist[] = {
    {const_cast<char *>("name"), Sbk_PluginSpec_get_name, Sbk_PluginSpec_set_name},
    {const_cast<char *>("description"), Sbk_PluginSpec_get_description, Sbk_PluginSpec_set_description},
    {const_cast<char *>("author"), Sbk_PluginSpec_get_author, Sbk_PluginSpec_set_author},
    {const_cast<char *>("version"), Sbk_PluginSpec_get_version, Sbk_PluginSpec_set_version},
    {const_cast<char *>("icon"), Sbk_PluginSpec_get_icon, Sbk_PluginSpec_set_icon},
    {const_cast<char *>("hasSettings"), Sbk_PluginSpec_get_hasSettings, Sbk_PluginSpec_set_hasSettings},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PluginSpec_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PluginSpec_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PluginSpec_Type = nullptr;
static SbkObjectType *Sbk_PluginSpec_TypeF(void)
{
    return _Sbk_PluginSpec_Type;
}

static PyType_Slot Sbk_PluginSpec_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PluginSpec_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PluginSpec_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_PluginSpec_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PluginSpec_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PluginSpec_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PluginSpec_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PluginSpec_spec = {
    "1:PyFalkon.PluginSpec",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PluginSpec_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PluginSpec_PythonToCpp_PluginSpec_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PluginSpec_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PluginSpec_PythonToCpp_PluginSpec_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PluginSpec_TypeF())))
        return PluginSpec_PythonToCpp_PluginSpec_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PluginSpec_PTR_CppToPython_PluginSpec(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::PluginSpec *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_PluginSpec_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *PluginSpec_COPY_CppToPython_PluginSpec(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_PluginSpec_TypeF(), new ::PluginSpec(*reinterpret_cast<const ::PluginSpec *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void PluginSpec_PythonToCpp_PluginSpec_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::PluginSpec *>(cppOut) = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PluginSpec_PythonToCpp_PluginSpec_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PluginSpec_TypeF())))
        return PluginSpec_PythonToCpp_PluginSpec_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PluginSpec_SignatureStrings[] = {
    "1:PyFalkon.PluginSpec(self)",
    "0:PyFalkon.PluginSpec(self,PluginSpec:PyFalkon.PluginSpec)",
    "PyFalkon.PluginSpec.__copy__()",
    nullptr}; // Sentinel

void init_PluginSpec(PyObject *module)
{
    _Sbk_PluginSpec_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PluginSpec",
        "PluginSpec",
        &Sbk_PluginSpec_spec,
        &Shiboken::callCppDestructor< ::PluginSpec >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PluginSpec_Type);
    InitSignatureStrings(pyType, PluginSpec_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PluginSpec_Type), Sbk_PluginSpec_PropertyStrings);
    SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PluginSpec_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PluginSpec_TypeF(),
        PluginSpec_PythonToCpp_PluginSpec_PTR,
        is_PluginSpec_PythonToCpp_PluginSpec_PTR_Convertible,
        PluginSpec_PTR_CppToPython_PluginSpec,
        PluginSpec_COPY_CppToPython_PluginSpec);

    Shiboken::Conversions::registerConverterName(converter, "PluginSpec");
    Shiboken::Conversions::registerConverterName(converter, "PluginSpec*");
    Shiboken::Conversions::registerConverterName(converter, "PluginSpec&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginSpec).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PluginSpec_PythonToCpp_PluginSpec_COPY,
        is_PluginSpec_PythonToCpp_PluginSpec_COPY_Convertible);

    qRegisterMetaType< ::PluginSpec >("PluginSpec");
}
