/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public abstract class NodeAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final long serialVersionUID = -5672895970450115226L;
    private static final String PROP_HAS_LISTENERS = "hasListeners";
    private static final String PROP_LAST_NODES = "lastNodes";
    private static final String PROP_LAST_ENABLED = "lastEnabled";
    private static NodesL l;
    private static final Set<NodeAction> listeningActions;

    protected void initialize() {
        super.initialize();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNotify() {
        super.addNotify();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.TRUE);
        Set<NodeAction> set = listeningActions;
        synchronized (set) {
            if (l == null) {
                l = new NodesL();
            }
            if (listeningActions.isEmpty()) {
                l.setActive(true);
            }
            listeningActions.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        Set<NodeAction> set = listeningActions;
        synchronized (set) {
            listeningActions.remove((Object)this);
            if (listeningActions.isEmpty()) {
                l.setActive(false);
            }
        }
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object[] objectArray = null;
        Boolean bl = null;
        Object object = this.getLock();
        synchronized (object) {
            bl = (Boolean)this.getProperty("enabled");
            if (l == null) {
                l = new NodesL();
                l.setActive(true);
            }
            NodesL nodesL = l;
            if (bl == null) {
                objectArray = nodesL.getActivatedNodes(this.surviveFocusChange());
                Reference reference = (Reference)this.getProperty(PROP_LAST_NODES);
                if (reference != null && Arrays.equals((Node[])reference.get(), objectArray)) {
                    bl = (Boolean)this.getProperty(PROP_LAST_ENABLED);
                    if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                        this.putProperty("enabled", bl);
                    }
                }
            }
        }
        if (bl == null) {
            bl = objectArray != null && this.enable((Node[])objectArray) ? Boolean.TRUE : Boolean.FALSE;
            object = this.getLock();
            synchronized (object) {
                this.putProperty(PROP_LAST_NODES, new WeakReference<Object[]>(objectArray));
                this.putProperty(PROP_LAST_ENABLED, bl);
                if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                    this.putProperty("enabled", bl);
                }
            }
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        this.putProperty(PROP_LAST_ENABLED, null);
        this.putProperty(PROP_LAST_NODES, null);
        Boolean bl2 = (Boolean)this.getProperty(PROP_HAS_LISTENERS);
        if (bl2 != null && bl2.booleanValue()) {
            super.setEnabled(bl);
        } else {
            this.putProperty("enabled", null, true);
        }
    }

    @Deprecated
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? null : actionEvent.getSource();
        if (object instanceof Node) {
            ActionInvoker.invokeAction((Action)((Object)this), (ActionEvent)actionEvent, (boolean)this.amIasynchronous(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    NodeAction.this.performAction(new Node[]{(Node)object});
                }
            });
        } else if (object instanceof Node[]) {
            ActionInvoker.invokeAction((Action)((Object)this), (ActionEvent)actionEvent, (boolean)this.amIasynchronous(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    NodeAction.this.performAction((Node[])object);
                }
            });
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Deprecated
    public void performAction() {
        this.performAction(this.getActivatedNodes());
    }

    public final Node[] getActivatedNodes() {
        NodesL nodesL = l;
        return nodesL == null ? new Node[]{} : nodesL.getActivatedNodes(true);
    }

    protected boolean surviveFocusChange() {
        return true;
    }

    protected abstract void performAction(Node[] var1);

    protected abstract boolean enable(Node[] var1);

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeFireEnabledChange() {
        boolean bl = false;
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty("enabled") != null) {
                this.putProperty("enabled", null);
                bl = true;
            }
        }
        if (bl) {
            try {
                this.firePropertyChange("enabled", null, null);
            }
            catch (NullPointerException nullPointerException) {
                Exceptions.attachMessage((Throwable)nullPointerException, (String)("You cannot add " + ((Object)((Object)this)).getClass().getName() + " directly to a JMenu etc.; use org.openide.awt.Actions.connect instead"));
                Logger.getLogger(NodeAction.class.getName()).log(Level.WARNING, null, nullPointerException);
            }
        }
    }

    final boolean amIasynchronous() {
        return this.asynchronous();
    }

    static {
        listeningActions = new WeakSet(100);
    }

    static class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
        private NodeAction delegate;
        private Lookup.Result<Node> result;
        private boolean enabled = true;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(NodeAction nodeAction, Lookup lookup) {
            this.delegate = nodeAction;
            this.result = lookup.lookupResult(Node.class);
            this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public final synchronized Node[] nodes() {
            if (this.result != null) {
                return this.result.allInstances().toArray(EMPTY_NODE_ARRAY);
            }
            return EMPTY_NODE_ARRAY;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionInvoker.invokeAction((Action)((Object)this.delegate), (ActionEvent)actionEvent, (boolean)this.delegate.amIasynchronous(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    delegate.performAction(this.nodes());
                }
            });
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            final boolean bl = this.enabled;
            this.enabled = this.delegate.enable(this.nodes());
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    support.firePropertyChange("enabled", bl, enabled);
                }
            });
        }

        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return new Actions.MenuItem((Action)this, true);
        }

        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return new Actions.ToolbarButton((Action)this);
        }

        private boolean isMethodOverridden(NodeAction nodeAction, String string) {
            try {
                Method method = ((Object)((Object)nodeAction)).getClass().getMethod(string, new Class[0]);
                return method.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                throw new IllegalStateException("Error searching for method " + string + " in " + (Object)((Object)nodeAction));
            }
        }
    }

    private static final class NodesL
    implements LookupListener {
        private volatile Lookup.Result<Node> result;
        private boolean chgSFC = false;
        private boolean chgNSFC = false;
        private Reference<Node>[] activatedNodes;

        public Node[] getActivatedNodes(boolean bl) {
            Node[] nodeArray;
            block3: {
                if (bl && this.activatedNodes != null) {
                    nodeArray = new Node[this.activatedNodes.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        nodeArray[i] = this.activatedNodes[i].get();
                        if (nodeArray[i] != null) {
                            continue;
                        }
                        break block3;
                    }
                    return nodeArray;
                }
            }
            return (nodeArray = this.result) == null ? new Node[]{} : nodeArray.allInstances().toArray(new Node[0]);
        }

        synchronized void setActive(boolean bl) {
            Lookup lookup = Utilities.actionsGlobalContext();
            if (bl) {
                if (this.result == null) {
                    this.result = lookup.lookupResult(Node.class);
                    this.result.addLookupListener((LookupListener)this);
                }
            } else {
                this.forget(true);
                this.forget(false);
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Object object;
            Lookup.Result<Node> result = this.result;
            if (result == null) {
                return;
            }
            this.chgSFC = true;
            this.chgNSFC = true;
            Collection collection = this.result.allItems();
            boolean bl = true;
            if (collection.size() == 1 && "none".equals((object = (Lookup.Item)collection.iterator().next()).getId()) && object.getInstance() == null) {
                bl = false;
            }
            if (bl) {
                object = this.result.allInstances().iterator();
                ArrayList arrayList = new ArrayList();
                while (object.hasNext()) {
                    arrayList.add(new WeakReference(object.next()));
                }
                this.activatedNodes = arrayList.toArray(new Reference[arrayList.size()]);
            }
            this.update();
        }

        public void update() {
            if (this.chgSFC) {
                this.forget(true);
                this.chgSFC = false;
            }
            if (this.chgNSFC) {
                this.forget(false);
                this.chgNSFC = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forget(boolean bl) {
            ArrayList arrayList;
            Set set = listeningActions;
            synchronized (set) {
                arrayList = new ArrayList(listeningActions.size());
                Object object = listeningActions.iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next());
                }
            }
            for (Object object : arrayList) {
                if (((NodeAction)((Object)object)).surviveFocusChange() != bl) continue;
                Mutex.EVENT.readAccess(new Runnable((NodeAction)((Object)object)){
                    final /* synthetic */ NodeAction val$a;
                    {
                        this.val$a = nodeAction;
                    }

                    @Override
                    public void run() {
                        this.val$a.maybeFireEnabledChange();
                    }
                });
            }
        }
    }
}

