/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.ProxySettings;
import org.netbeans.core.network.proxy.NetworkProxyReloader;
import org.netbeans.core.network.proxy.ProxyAutoConfig;
import org.openide.util.RequestProcessor;

public final class NbProxySelector
extends ProxySelector {
    private final ProxySelector original = ProxySelector.getDefault();
    private static final Logger LOG = Logger.getLogger(NbProxySelector.class.getName());
    private static Boolean useSystemProxies;
    private static final String DEFAULT_PROXY_SELECTOR_CLASS_NAME = "sun.net.spi.DefaultProxySelector";
    private static final RequestProcessor RP;
    private static final int DNS_TIMEOUT = 10000;

    public NbProxySelector() {
        LOG.log(Level.FINE, "java.net.useSystemProxies has been set to {0}", NbProxySelector.useSystemProxies());
        if (this.original == null || this.original.getClass().getName().equals(DEFAULT_PROXY_SELECTOR_CLASS_NAME)) {
            NetworkProxyReloader.reloadNetworkProxy();
        }
        ProxySettings.addPreferenceChangeListener((PreferenceChangeListener)new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    @Override
    public List<Proxy> select(URI uRI) {
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        int n = ProxySettings.getProxyType();
        switch (n) {
            case 0: {
                arrayList.add(Proxy.NO_PROXY);
                break;
            }
            case 1: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original == null) break;
                    arrayList.addAll(this.original.select(uRI));
                    break;
                }
                String string = uRI.getScheme();
                assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.getSystemNonProxyHosts(), uRI.getHost())) {
                    arrayList.add(Proxy.NO_PROXY);
                    break;
                }
                if (string.toLowerCase(Locale.US).startsWith("http")) {
                    String string2 = ProxySettings.getSystemHttpPort();
                    if (string2 != null && string2.length() > 0 && ProxySettings.getSystemHttpHost().length() > 0) {
                        int n2 = Integer.parseInt(string2);
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.getSystemHttpHost(), n2));
                        arrayList.add(proxy);
                    }
                } else {
                    String string3 = ProxySettings.getSystemSocksPort();
                    String string4 = ProxySettings.getSystemSocksHost();
                    if (string3 != null && string3.length() > 0 && string4.length() > 0) {
                        int n3 = Integer.parseInt(string3);
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string4, n3));
                        arrayList.add(proxy);
                    }
                }
                if (this.original == null) break;
                arrayList.addAll(this.original.select(uRI));
                break;
            }
            case 2: {
                String string = uRI.getScheme();
                assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uRI.getHost())) {
                    arrayList.add(Proxy.NO_PROXY);
                    break;
                }
                if (string.toLowerCase(Locale.US).startsWith("http")) {
                    String string5 = ProxySettings.getHttpHost();
                    String string6 = ProxySettings.getHttpPort();
                    if (string6 != null && string6.length() > 0 && string5.length() > 0) {
                        int n4 = Integer.parseInt(string6);
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string5, n4));
                        arrayList.add(proxy);
                    } else {
                        LOG.log(Level.FINE, "Incomplete HTTP Proxy [{0}/{1}] found in ProxySelector[Type: {2}] for uri {3}. ", new Object[]{string5, string6, ProxySettings.getProxyType(), uRI});
                        if (this.original != null) {
                            LOG.log(Level.FINEST, "Fallback to the default ProxySelector which returns {0}", this.original.select(uRI));
                            arrayList.addAll(this.original.select(uRI));
                        }
                    }
                } else {
                    String string7 = ProxySettings.getSocksPort();
                    String string8 = ProxySettings.getSocksHost();
                    if (string7 != null && string7.length() > 0 && string8.length() > 0) {
                        int n5 = Integer.parseInt(string7);
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string8, n5));
                        arrayList.add(proxy);
                    } else {
                        LOG.log(Level.FINE, "Incomplete SOCKS Server [{0}/{1}] found in ProxySelector[Type: {2}] for uri {3}. ", new Object[]{string8, string7, ProxySettings.getProxyType(), uRI});
                        if (this.original != null) {
                            LOG.log(Level.FINEST, "Fallback to the default ProxySelector which returns {0}", this.original.select(uRI));
                            arrayList.addAll(this.original.select(uRI));
                        }
                    }
                }
                arrayList.add(Proxy.NO_PROXY);
                break;
            }
            case 3: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original != null) {
                        arrayList.addAll(this.original.select(uRI));
                    }
                } else {
                    ProxyAutoConfig proxyAutoConfig = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                    assert (proxyAutoConfig != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                    if (proxyAutoConfig == null) {
                        LOG.log(Level.FINEST, "No instance of ProxyAutoConfig({0}) for URI {1}", new Object[]{NbProxySelector.getPacFile(), uRI});
                        arrayList.add(Proxy.NO_PROXY);
                    }
                    if (proxyAutoConfig.getPacURI().getHost() == null) {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString()});
                        arrayList.addAll(proxyAutoConfig.findProxyForURL(uRI));
                    } else if (proxyAutoConfig.getPacURI().getHost().equals(uRI.getHost())) {
                        arrayList.add(Proxy.NO_PROXY);
                    } else {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString(), proxyAutoConfig.getPacURI().getHost()});
                        arrayList.addAll(proxyAutoConfig.findProxyForURL(uRI));
                    }
                }
                if (this.original != null) {
                    arrayList.addAll(this.original.select(uRI));
                }
                arrayList.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                ProxyAutoConfig proxyAutoConfig = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                assert (proxyAutoConfig != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                if (proxyAutoConfig == null) {
                    LOG.log(Level.FINEST, "No instance of ProxyAutoConfig({0}) for URI {1}", new Object[]{NbProxySelector.getPacFile(), uRI});
                    arrayList.add(Proxy.NO_PROXY);
                }
                if (proxyAutoConfig.getPacURI().getHost() == null) {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString()});
                    arrayList.addAll(proxyAutoConfig.findProxyForURL(uRI));
                } else if (proxyAutoConfig.getPacURI().getHost().equals(uRI.getHost())) {
                    arrayList.add(Proxy.NO_PROXY);
                } else {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uRI.toString(), uRI.getHost(), proxyAutoConfig.getPacURI().toString(), proxyAutoConfig.getPacURI().getHost()});
                    arrayList.addAll(proxyAutoConfig.findProxyForURL(uRI));
                }
                arrayList.add(Proxy.NO_PROXY);
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + n;
                break;
            }
        }
        LOG.log(Level.FINEST, "NbProxySelector[Type: {0}, Use HTTP for all protocols: {1}] returns {2} for URI {3}", new Object[]{ProxySettings.getProxyType(), ProxySettings.useProxyAllProtocols(), arrayList, uRI});
        return arrayList;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        LOG.log(Level.INFO, "connectionFailed(" + uRI + ", " + socketAddress + ")", iOException);
    }

    private void copySettingsToSystem() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = ProxySettings.getProxyType();
        switch (n) {
            case 0: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                string3 = null;
                string4 = null;
                string5 = null;
                break;
            }
            case 1: {
                string = ProxySettings.getSystemHttpHost();
                string2 = ProxySettings.getSystemHttpPort();
                string6 = ProxySettings.getSystemHttpsHost();
                string7 = ProxySettings.getSystemHttpsPort();
                string4 = ProxySettings.getSystemSocksHost();
                string5 = ProxySettings.getSystemSocksPort();
                string3 = ProxySettings.getSystemNonProxyHosts();
                break;
            }
            case 2: {
                string = ProxySettings.getHttpHost();
                string2 = ProxySettings.getHttpPort();
                string6 = ProxySettings.getHttpsHost();
                string7 = ProxySettings.getHttpsPort();
                string3 = ProxySettings.getNonProxyHosts();
                string4 = ProxySettings.getSocksHost();
                string5 = ProxySettings.getSocksPort();
                break;
            }
            case 3: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                string3 = null;
                string4 = null;
                string5 = null;
                break;
            }
            case 4: {
                string = null;
                string2 = null;
                string6 = null;
                string7 = null;
                string3 = ProxySettings.getNonProxyHosts();
                string4 = null;
                string5 = null;
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + n;
                break;
            }
        }
        this.setOrClearProperty("http.proxyHost", string, false);
        this.setOrClearProperty("http.proxyPort", string2, true);
        this.setOrClearProperty("http.nonProxyHosts", string3, false);
        this.setOrClearProperty("https.proxyHost", string6, false);
        this.setOrClearProperty("https.proxyPort", string7, true);
        this.setOrClearProperty("https.nonProxyHosts", string3, false);
        this.setOrClearProperty("socksProxyHost", string4, false);
        this.setOrClearProperty("socksProxyPort", string5, true);
        LOG.log(Level.FINE, "Set System''s http.proxyHost/Port/NonProxyHost to {0}/{1}/{2}", new Object[]{string, string2, string3});
        LOG.log(Level.FINE, "Set System''s https.proxyHost/Port to {0}/{1}", new Object[]{string6, string7});
        LOG.log(Level.FINE, "Set System''s socksProxyHost/Port to {0}/{1}", new Object[]{string4, string5});
    }

    private void setOrClearProperty(String string, String string2, boolean bl) {
        assert (string != null);
        if (string2 == null || string2.length() == 0) {
            System.clearProperty(string);
        } else {
            if (bl) {
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                }
            }
            System.setProperty(string, string2);
        }
    }

    static boolean dontUseProxy(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (NbProxySelector.dontUseIp(string, string2)) {
            return true;
        }
        return NbProxySelector.dontUseHostName(string, string2);
    }

    private static boolean dontUseHostName(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf("*");
            if (n == -1) {
                bl = string3.equals(string2);
                if (!bl) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), string2, string});
                continue;
            }
            String string4 = string3.substring(0, n - 1 < 0 ? 0 : n - 1);
            String string5 = string3.substring(n + 1 > string3.length() ? string3.length() : n + 1);
            boolean bl2 = n > 0;
            boolean bl3 = n < string3.length() - 1;
            bl = bl2 && string2.startsWith(string4) || bl3 && string2.endsWith(string5);
            if (!bl) continue;
            LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), string2, string});
        }
        return bl;
    }

    private static boolean dontUseIp(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        DnsTimeoutTask dnsTimeoutTask = new DnsTimeoutTask(string2);
        RequestProcessor.Task task = RP.post((Runnable)dnsTimeoutTask);
        try {
            task.waitFinished(10000L);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.INFO, "Timeout when waiting for DNS response. ({0})", string2);
        }
        String string3 = dnsTimeoutTask.getIp();
        if (string3 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf("*");
            if (n == -1) {
                bl = string4.equals(string3);
                if (!bl) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host''s IP {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), string3, string});
                continue;
            }
            try {
                bl = Pattern.matches(string4, string3);
                if (!bl) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host''s IP{1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), string3, string});
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return bl;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            Properties properties = new Properties();
            String string = System.getProperty("java.home");
            if (string == null) {
                return false;
            }
            try {
                File file = new File(string, "lib");
                File file2 = new File(file, "net.properties");
                if (!file2.exists()) {
                    file = new File(string, "conf");
                    file2 = new File(file, "net.properties");
                }
                string = file2.getCanonicalPath();
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
                String string2 = properties.getProperty("java.net.useSystemProxies");
                string2 = System.getProperty("java.net.useSystemProxies", string2);
                useSystemProxies = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                useSystemProxies = false;
            }
        }
        return useSystemProxies;
    }

    static boolean usePAC() {
        String string = ProxySettings.getSystemPac();
        return string != null;
    }

    private static String getPacFile() {
        return ProxySettings.getSystemPac();
    }

    static {
        RP = new RequestProcessor(NbProxySelector.class.getName(), 5);
    }

    private static class DnsTimeoutTask
    implements Runnable {
        private final String host;
        private String ip = null;

        public DnsTimeoutTask(String string) {
            this.host = string;
        }

        @Override
        public void run() {
            try {
                this.ip = InetAddress.getByName(this.host).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                LOG.log(Level.FINE, unknownHostException.getLocalizedMessage(), unknownHostException);
            }
        }

        public String getIp() {
            return this.ip;
        }
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey().startsWith("proxy") || preferenceChangeEvent.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

