"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicAuthentication = void 0;

var _routes = require("./routes");

var _authentication_type = require("../authentication_type");

var _common = require("../../../../common");

var _next_url = require("../../../utils/next_url");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BasicAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", 'basicauth');

    this.init();
  }

  async init() {
    const routes = new _routes.BasicAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.securityClient, this.coreSetup);
    routes.setupRoutes();
  } // override functions inherited from AuthenticationType


  requestIncludesAuthInfo(request) {
    return request.headers[BasicAuthentication.AUTH_HEADER_NAME] ? true : false;
  }

  getAdditionalAuthHeader(request) {
    return {};
  }

  getCookie(request, authInfo) {
    if (this.config.auth.anonymous_auth_enabled && authInfo.user_name === 'opendistro_security_anonymous') {
      return {
        username: authInfo.user_name,
        authType: this.type,
        expiryTime: Date.now() + this.config.session.ttl,
        isAnonymousAuth: true
      };
    }

    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: request.headers[BasicAuthentication.AUTH_HEADER_NAME]
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }

  async isValidCookie(cookie) {
    var _cookie$credentials;

    return cookie.authType === this.type && cookie.expiryTime && (cookie.username && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue) || this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth);
  }

  handleUnauthedRequest(request, response, toolkit) {
    if (this.isPageRequest(request)) {
      const nextUrlParam = (0, _next_url.composeNextUrlQueryParam)(request, this.coreSetup.http.basePath.serverBasePath);

      if (this.config.auth.anonymous_auth_enabled) {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}/auth/anonymous?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      } else {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}${_common.LOGIN_PAGE_URI}?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      }
    } else {
      return response.unauthorized({
        body: `Authentication required`
      });
    }
  }

  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;

    if (this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth) {
      return {};
    }

    const headers = {};
    Object.assign(headers, {
      authorization: (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue
    });
    return headers;
  }

}

exports.BasicAuthentication = BasicAuthentication;

_defineProperty(BasicAuthentication, "AUTH_HEADER_NAME", 'authorization');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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