
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-ms-sar.h"
#include "mbim-message-private.h"
#include "mbim-enum-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Struct: MbimSarConfigState */

static void
_mbim_sar_config_state_free (MbimSarConfigState *var)
{
    if (!var)
        return;

    g_free (var);
}

void
mbim_sar_config_state_array_free (MbimSarConfigStateArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_sar_config_state_free (array[i]);
    g_free (array);
}

static MbimSarConfigState *
_mbim_message_read_mbim_sar_config_state_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimSarConfigState *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimSarConfigState, 1);

    if (!_mbim_message_read_guint32 (self, offset, &out->antenna_index, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->backoff_index, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_sar_config_state_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    gboolean refs,
    MbimSarConfigStateArray **out_array,
    GError **error)
{
    GError *inner_error = NULL;
    MbimSarConfigStateArray *out;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_new0 (MbimSarConfigState *, array_size + 1);

    if (!refs) {
        _mbim_message_read_guint32 (self, relative_offset_array_start, &offset, &inner_error);
        for (i = 0; !inner_error && (i < array_size); i++, offset += 8)
            out[i] = _mbim_message_read_mbim_sar_config_state_struct (self, offset, NULL, &inner_error);
    } else {
        offset = relative_offset_array_start;
        for (i = 0; !inner_error && (i < array_size); i++, offset += 8) {
            guint32 tmp_offset;

            if (_mbim_message_read_guint32 (self, offset, &tmp_offset, &inner_error))
                out[i] = _mbim_message_read_mbim_sar_config_state_struct (self, tmp_offset, NULL, &inner_error);
        }
    }

    if (!inner_error) {
        *out_array = out;
        return TRUE;
    }

    mbim_sar_config_state_array_free (out);
    g_propagate_error (error, inner_error);
    return FALSE;
}

static gchar *
_mbim_message_print_mbim_sar_config_state_struct (
    const MbimSarConfigState *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  AntennaIndex = ", line_prefix);
    {
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->antenna_index);
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BackoffIndex = ", line_prefix);
    {
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->backoff_index);
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_sar_config_state_struct_new (const MbimSarConfigState *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->antenna_index);
    _mbim_struct_builder_append_guint32 (builder, value->backoff_index);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_sar_config_state_struct (
    MbimStructBuilder *builder,
    const MbimSarConfigState *value)
{
    GByteArray *raw;

    raw = _mbim_sar_config_state_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_sar_config_state_struct (
    MbimMessageCommandBuilder *builder,
    const MbimSarConfigState *value)
{
    _mbim_struct_builder_append_mbim_sar_config_state_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_sar_config_state_struct_array (
    MbimStructBuilder *builder,
    const MbimSarConfigState *const *values,
    guint32 n_values,
    gboolean refs)
{
    guint32 offset;
    guint32 i;
    GByteArray *raw_all = NULL;

    if (!refs) {
        for (i = 0; i < n_values; i++) {
            GByteArray *raw;

            raw = _mbim_sar_config_state_struct_new (values[i]);
            if (!raw_all)
                raw_all = raw;
            else {
                g_byte_array_append (raw_all, raw->data, raw->len);
                g_byte_array_unref (raw);
            }
        }

        if (!raw_all) {
            offset = 0;
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        } else {
            guint32 offset_offset;

            /* Offset of the offset */
            offset_offset = builder->fixed_buffer->len;
            /* Length *not* in LE yet */
            offset = builder->variable_buffer->len;
            /* Add the offset value */
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
            /* Configure the value to get updated */
            g_array_append_val (builder->offsets, offset_offset);
            /* Add the final array itself */
            g_byte_array_append (builder->variable_buffer, raw_all->data, raw_all->len);
            g_byte_array_unref (raw_all);
        }
    } else {
        for (i = 0; i < n_values; i++) {
            guint32 length;
            guint32 offset_offset;
            GByteArray *raw;

            raw = _mbim_sar_config_state_struct_new (values[i]);
            g_assert (raw->len > 0);

            /* Offset of the offset */
            offset_offset = builder->fixed_buffer->len;

            /* Length *not* in LE yet */
            offset = builder->variable_buffer->len;
            /* Add the offset value */
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
            /* Configure the value to get updated */
            g_array_append_val (builder->offsets, offset_offset);

            /* Add the length value */
            length = GUINT32_TO_LE (raw->len);
            g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

            /* And finally, the bytearray itself to the variable buffer */
            g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
            g_byte_array_unref (raw);
        }
    }
}

static void
_mbim_message_command_builder_append_mbim_sar_config_state_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimSarConfigState *const *values,
    guint32 n_values,
    gboolean refs)
{
    _mbim_struct_builder_append_mbim_sar_config_state_struct_array (builder->contents_builder, values, n_values, refs);
}

/*****************************************************************************/
/* Message (Query): MBIM Message MS SAR Config */

MbimMessage *
mbim_message_ms_sar_config_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_SAR,
                                                 MBIM_CID_MS_SAR_CONFIG,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_sar_config_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS SAR Config */

MbimMessage *
mbim_message_ms_sar_config_set_new (
    MbimSarControlMode mode,
    MbimSarBackoffState backoff_state,
    guint32 config_states_count,
    const MbimSarConfigState *const *config_states,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_SAR,
                                                 MBIM_CID_MS_SAR_CONFIG,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, mode);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, backoff_state);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, config_states_count);
    }
    {
        _mbim_message_command_builder_append_mbim_sar_config_state_struct_array (builder, config_states, config_states_count, TRUE);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_sar_config_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _config_states_count;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Mode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_SAR_CONTROL_MODE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_sar_control_mode_get_string ((MbimSarControlMode)tmp));
#elif defined __MBIM_SAR_CONTROL_MODE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sar_control_mode_build_string_from_mask ((MbimSarControlMode)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  BackoffState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_SAR_BACKOFF_STATE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_sar_backoff_state_get_string ((MbimSarBackoffState)tmp));
#elif defined __MBIM_SAR_BACKOFF_STATE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sar_backoff_state_build_string_from_mask ((MbimSarBackoffState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigStatesCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_config_states_count, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _config_states_count);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigStates = ", line_prefix);
    {
        g_autoptr(MbimSarConfigStateArray) tmp = NULL;
        g_autofree gchar *new_line_prefix = NULL;
        guint i;

        if (!_mbim_message_read_mbim_sar_config_state_struct_array (message, _config_states_count, offset, TRUE, &tmp, &inner_error))
            goto out;
        offset += (8 * _config_states_count);
        new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
        g_string_append (str, "'{\n");
        for (i = 0; i < _config_states_count; i++) {
            g_autofree gchar *struct_str = NULL;

            g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
            struct_str = _mbim_message_print_mbim_sar_config_state_struct (tmp[i], new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s    },\n", line_prefix);
        }
        g_string_append_printf (str, "%s  }'", line_prefix);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS SAR Config */

gboolean
mbim_message_ms_sar_config_response_parse (
    const MbimMessage *message,
    MbimSarControlMode *out_mode,
    MbimSarBackoffState *out_backoff_state,
    MbimSarWifiHardwareState *out_wifi_integration,
    guint32 *out_config_states_count,
    MbimSarConfigStateArray **out_config_states,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _config_states_count;
    MbimSarConfigState **_config_states = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'Mode' variable */
    {
        if (out_mode != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_mode = (MbimSarControlMode)aux;
        }
        offset += 4;
    }

    /* Read the 'BackoffState' variable */
    {
        if (out_backoff_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_backoff_state = (MbimSarBackoffState)aux;
        }
        offset += 4;
    }

    /* Read the 'WifiIntegration' variable */
    {
        if (out_wifi_integration != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_wifi_integration = (MbimSarWifiHardwareState)aux;
        }
        offset += 4;
    }

    /* Read the 'ConfigStatesCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_config_states_count, error))
            goto out;
        if (out_config_states_count != NULL)
            *out_config_states_count = _config_states_count;
        offset += 4;
    }

    /* Read the 'ConfigStates' variable */
    {
        if ((out_config_states != NULL) && !_mbim_message_read_mbim_sar_config_state_struct_array (message, _config_states_count, offset, TRUE, &_config_states, error))
            goto out;
        offset += (8 * _config_states_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_config_states != NULL)
            *out_config_states = _config_states;
    } else {
        mbim_sar_config_state_array_free (_config_states);
    }

    return success;
}

static gchar *
mbim_message_ms_sar_config_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _config_states_count;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Mode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_SAR_CONTROL_MODE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_sar_control_mode_get_string ((MbimSarControlMode)tmp));
#elif defined __MBIM_SAR_CONTROL_MODE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sar_control_mode_build_string_from_mask ((MbimSarControlMode)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  BackoffState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_SAR_BACKOFF_STATE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_sar_backoff_state_get_string ((MbimSarBackoffState)tmp));
#elif defined __MBIM_SAR_BACKOFF_STATE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sar_backoff_state_build_string_from_mask ((MbimSarBackoffState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  WifiIntegration = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_SAR_WIFI_HARDWARE_STATE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_sar_wifi_hardware_state_get_string ((MbimSarWifiHardwareState)tmp));
#elif defined __MBIM_SAR_WIFI_HARDWARE_STATE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sar_wifi_hardware_state_build_string_from_mask ((MbimSarWifiHardwareState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigStatesCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_config_states_count, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _config_states_count);
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigStates = ", line_prefix);
    {
        g_autoptr(MbimSarConfigStateArray) tmp = NULL;
        g_autofree gchar *new_line_prefix = NULL;
        guint i;

        if (!_mbim_message_read_mbim_sar_config_state_struct_array (message, _config_states_count, offset, TRUE, &tmp, &inner_error))
            goto out;
        offset += (8 * _config_states_count);
        new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
        g_string_append (str, "'{\n");
        for (i = 0; i < _config_states_count; i++) {
            g_autofree gchar *struct_str = NULL;

            g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
            struct_str = _mbim_message_print_mbim_sar_config_state_struct (tmp[i], new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s    },\n", line_prefix);
        }
        g_string_append_printf (str, "%s  }'", line_prefix);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message MS SAR Transmission status */

MbimMessage *
mbim_message_ms_sar_transmission_status_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_SAR,
                                                 MBIM_CID_MS_SAR_TRANSMISSION_STATUS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_sar_transmission_status_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message MS SAR Transmission status */

MbimMessage *
mbim_message_ms_sar_transmission_status_set_new (
    MbimTransmissionNotificationStatus channel_notification,
    guint32 hysteresis_timer,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_SAR,
                                                 MBIM_CID_MS_SAR_TRANSMISSION_STATUS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, channel_notification);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, hysteresis_timer);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_sar_transmission_status_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ChannelNotification = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_transmission_notification_status_get_string ((MbimTransmissionNotificationStatus)tmp));
#elif defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_transmission_notification_status_build_string_from_mask ((MbimTransmissionNotificationStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  HysteresisTimer = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message MS SAR Transmission status */

gboolean
mbim_message_ms_sar_transmission_status_response_parse (
    const MbimMessage *message,
    MbimTransmissionNotificationStatus *out_channel_notification,
    MbimTransmissionState *out_transmission_status,
    guint32 *out_hysteresis_timer,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ChannelNotification' variable */
    {
        if (out_channel_notification != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_channel_notification = (MbimTransmissionNotificationStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'TransmissionStatus' variable */
    {
        if (out_transmission_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_transmission_status = (MbimTransmissionState)aux;
        }
        offset += 4;
    }

    /* Read the 'HysteresisTimer' variable */
    {
        if ((out_hysteresis_timer != NULL) && !_mbim_message_read_guint32 (message, offset, out_hysteresis_timer, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_sar_transmission_status_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_response_get_result (message, MBIM_MESSAGE_TYPE_COMMAND_DONE, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ChannelNotification = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_transmission_notification_status_get_string ((MbimTransmissionNotificationStatus)tmp));
#elif defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_transmission_notification_status_build_string_from_mask ((MbimTransmissionNotificationStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TransmissionStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_TRANSMISSION_STATE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_transmission_state_get_string ((MbimTransmissionState)tmp));
#elif defined __MBIM_TRANSMISSION_STATE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_transmission_state_build_string_from_mask ((MbimTransmissionState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  HysteresisTimer = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message MS SAR Transmission status */

gboolean
mbim_message_ms_sar_transmission_status_notification_parse (
    const MbimMessage *message,
    MbimTransmissionNotificationStatus *out_channel_notification,
    MbimTransmissionState *out_transmission_status,
    guint32 *out_hysteresis_timer,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ChannelNotification' variable */
    {
        if (out_channel_notification != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_channel_notification = (MbimTransmissionNotificationStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'TransmissionStatus' variable */
    {
        if (out_transmission_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_transmission_status = (MbimTransmissionState)aux;
        }
        offset += 4;
    }

    /* Read the 'HysteresisTimer' variable */
    {
        if ((out_hysteresis_timer != NULL) && !_mbim_message_read_guint32 (message, offset, out_hysteresis_timer, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_sar_transmission_status_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ChannelNotification = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_transmission_notification_status_get_string ((MbimTransmissionNotificationStatus)tmp));
#elif defined __MBIM_TRANSMISSION_NOTIFICATION_STATUS_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_transmission_notification_status_build_string_from_mask ((MbimTransmissionNotificationStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TransmissionStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
#if defined __MBIM_TRANSMISSION_STATE_IS_ENUM__
        g_string_append_printf (str, "'%s'", mbim_transmission_state_get_string ((MbimTransmissionState)tmp));
#elif defined __MBIM_TRANSMISSION_STATE_IS_FLAGS__
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_transmission_state_build_string_from_mask ((MbimTransmissionState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
        }
#else
# error neither enum nor flags
#endif

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  HysteresisTimer = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks get_printable_callbacks[] = {
    [MBIM_CID_MS_SAR_CONFIG] = {
        .query_cb = mbim_message_ms_sar_config_query_get_printable,
        .set_cb = mbim_message_ms_sar_config_set_get_printable,
        .response_cb = mbim_message_ms_sar_config_response_get_printable,
    },
    [MBIM_CID_MS_SAR_TRANSMISSION_STATUS] = {
        .query_cb = mbim_message_ms_sar_transmission_status_query_get_printable,
        .set_cb = mbim_message_ms_sar_transmission_status_set_get_printable,
        .response_cb = mbim_message_ms_sar_transmission_status_response_get_printable,
        .notification_cb = mbim_message_ms_sar_transmission_status_notification_get_printable,
    },
};

gchar *
__mbim_message_ms_sar_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (get_printable_callbacks[cid].query_cb)
                            return get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (get_printable_callbacks[cid].set_cb)
                            return get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                if (get_printable_callbacks[cid].response_cb)
                    return get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (get_printable_callbacks)) {
                if (get_printable_callbacks[cid].notification_cb)
                    return get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_INVALID_MESSAGE,
                 "Unknown contents");
    return NULL;
}
