/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPage.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"
#include "WebPreferencesStore.h"
#include <WebCore/DeprecatedGlobalSettings.h>
#include <WebCore/Page.h>
#include <WebCore/RuntimeEnabledFeatures.h>
#include <WebCore/Settings.h>

namespace WebKit {

void WebPage::updateSettingsGenerated(const WebPreferencesStore& store, WebCore::Settings& settings)
{
    settings.setAcceleratedCompositingEnabled(store.getBoolValueForKey(WebPreferencesKey::acceleratedCompositingEnabledKey()));
    settings.setAcceleratedCompositingForFixedPositionEnabled(store.getBoolValueForKey(WebPreferencesKey::acceleratedCompositingForFixedPositionEnabledKey()));
    settings.setAcceleratedDrawingEnabled(store.getBoolValueForKey(WebPreferencesKey::acceleratedDrawingEnabledKey()));
#if USE(CORE_IMAGE)
    settings.setAcceleratedFiltersEnabled(store.getBoolValueForKey(WebPreferencesKey::acceleratedFiltersEnabledKey()));
#endif
    settings.setAccentColorEnabled(store.getBoolValueForKey(WebPreferencesKey::accentColorEnabledKey()));
    settings.setAccessHandleEnabled(store.getBoolValueForKey(WebPreferencesKey::accessHandleEnabledKey()));
    settings.setAggressiveTileRetentionEnabled(store.getBoolValueForKey(WebPreferencesKey::aggressiveTileRetentionEnabledKey()));
    settings.setAllowContentSecurityPolicySourceStarToMatchAnyProtocol(store.getBoolValueForKey(WebPreferencesKey::allowContentSecurityPolicySourceStarToMatchAnyProtocolKey()));
    settings.setAllowCrossOriginSubresourcesToAskForCredentials(store.getBoolValueForKey(WebPreferencesKey::allowCrossOriginSubresourcesToAskForCredentialsKey()));
    settings.setAllowDisplayOfInsecureContent(store.getBoolValueForKey(WebPreferencesKey::allowDisplayOfInsecureContentKey()));
    settings.setAllowFileAccessFromFileURLs(store.getBoolValueForKey(WebPreferencesKey::allowFileAccessFromFileURLsKey()));
    settings.setAllowMediaContentTypesRequiringHardwareSupportAsFallback(store.getBoolValueForKey(WebPreferencesKey::allowMediaContentTypesRequiringHardwareSupportAsFallbackKey()));
    settings.setAllowMultiElementImplicitSubmission(store.getBoolValueForKey(WebPreferencesKey::allowMultiElementImplicitSubmissionKey()));
    settings.setAllowRunningOfInsecureContent(store.getBoolValueForKey(WebPreferencesKey::allowRunningOfInsecureContentKey()));
    settings.setAllowSettingAnyXHRHeaderFromFileURLs(store.getBoolValueForKey(WebPreferencesKey::allowSettingAnyXHRHeaderFromFileURLsKey()));
    settings.setAllowTopNavigationToDataURLs(store.getBoolValueForKey(WebPreferencesKey::allowTopNavigationToDataURLsKey()));
    settings.setAllowUniversalAccessFromFileURLs(store.getBoolValueForKey(WebPreferencesKey::allowUniversalAccessFromFileURLsKey()));
#if PLATFORM(IOS_FAMILY)
    settings.setAllowViewportShrinkToFitContent(store.getBoolValueForKey(WebPreferencesKey::allowViewportShrinkToFitContentKey()));
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    settings.setAllowsAirPlayForMediaPlayback(store.getBoolValueForKey(WebPreferencesKey::allowsAirPlayForMediaPlaybackKey()));
#endif
    settings.setAllowsInlineMediaPlayback(store.getBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackKey()));
    settings.setAllowsInlineMediaPlaybackAfterFullscreen(store.getBoolValueForKey(WebPreferencesKey::allowsInlineMediaPlaybackAfterFullscreenKey()));
    settings.setAllowsPictureInPictureMediaPlayback(store.getBoolValueForKey(WebPreferencesKey::allowsPictureInPictureMediaPlaybackKey()));
#if PLATFORM(IOS_FAMILY)
    settings.setAlternateFormControlDesignEnabled(store.getBoolValueForKey(WebPreferencesKey::alternateFormControlDesignEnabledKey()));
#endif
    settings.setAlwaysUseAcceleratedOverflowScroll(store.getBoolValueForKey(WebPreferencesKey::alwaysUseAcceleratedOverflowScrollKey()));
    settings.setAnimatedImageAsyncDecodingEnabled(store.getBoolValueForKey(WebPreferencesKey::animatedImageAsyncDecodingEnabledKey()));
#if ENABLE(APP_HIGHLIGHTS)
    settings.setAppHighlightsEnabled(store.getBoolValueForKey(WebPreferencesKey::appHighlightsEnabledKey()));
#endif
    settings.setAppleMailPaginationQuirkEnabled(store.getBoolValueForKey(WebPreferencesKey::appleMailPaginationQuirkEnabledKey()));
#if ENABLE(APPLE_PAY)
    settings.setApplePayCapabilityDisclosureAllowed(store.getBoolValueForKey(WebPreferencesKey::applePayCapabilityDisclosureAllowedKey()));
#endif
#if ENABLE(APPLE_PAY)
    settings.setApplePayEnabled(store.getBoolValueForKey(WebPreferencesKey::applePayEnabledKey()));
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
    settings.setApplePayRemoteUIEnabled(store.getBoolValueForKey(WebPreferencesKey::applePayRemoteUIEnabledKey()));
#endif
    settings.setAspectRatioEnabled(store.getBoolValueForKey(WebPreferencesKey::aspectRatioEnabledKey()));
    settings.setAspectRatioOfImgFromWidthAndHeightEnabled(store.getBoolValueForKey(WebPreferencesKey::aspectRatioOfImgFromWidthAndHeightEnabledKey()));
    settings.setAsyncClipboardAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::asyncClipboardAPIEnabledKey()));
    settings.setAsyncFrameScrollingEnabled(store.getBoolValueForKey(WebPreferencesKey::asyncFrameScrollingEnabledKey()));
    settings.setAsyncOverflowScrollingEnabled(store.getBoolValueForKey(WebPreferencesKey::asyncOverflowScrollingEnabledKey()));
    settings.setAsynchronousSpellCheckingEnabled(store.getBoolValueForKey(WebPreferencesKey::asynchronousSpellCheckingEnabledKey()));
    settings.setAuthorAndUserStylesEnabled(store.getBoolValueForKey(WebPreferencesKey::authorAndUserStylesEnabledKey()));
    settings.setBackspaceKeyNavigationEnabled(store.getBoolValueForKey(WebPreferencesKey::backspaceKeyNavigationEnabledKey()));
    settings.setBeaconAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::beaconAPIEnabledKey()));
    settings.setBlankAnchorTargetImpliesNoOpenerEnabled(store.getBoolValueForKey(WebPreferencesKey::blankAnchorTargetImpliesNoOpenerEnabledKey()));
    settings.setBroadcastChannelEnabled(store.getBoolValueForKey(WebPreferencesKey::broadcastChannelEnabledKey()));
    settings.setBroadcastChannelOriginPartitioningEnabled(store.getBoolValueForKey(WebPreferencesKey::broadcastChannelOriginPartitioningEnabledKey()));
    settings.setCSS3DTransformInteroperabilityEnabled(store.getBoolValueForKey(WebPreferencesKey::css3DTransformInteroperabilityEnabledKey()));
    settings.setCSSCascadeLayersEnabled(store.getBoolValueForKey(WebPreferencesKey::cssCascadeLayersEnabledKey()));
    settings.setCSSColor4(store.getBoolValueForKey(WebPreferencesKey::cssColor4Key()));
    settings.setCSSColorContrastEnabled(store.getBoolValueForKey(WebPreferencesKey::cssColorContrastEnabledKey()));
    settings.setCSSColorMixEnabled(store.getBoolValueForKey(WebPreferencesKey::cssColorMixEnabledKey()));
    settings.setCSSContainerQueriesEnabled(store.getBoolValueForKey(WebPreferencesKey::cssContainerQueriesEnabledKey()));
    settings.setCSSContainmentEnabled(store.getBoolValueForKey(WebPreferencesKey::cssContainmentEnabledKey()));
    settings.setCSSCounterStyleAtRuleImageSymbolsEnabled(store.getBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRuleImageSymbolsEnabledKey()));
    settings.setCSSCounterStyleAtRulesEnabled(store.getBoolValueForKey(WebPreferencesKey::cssCounterStyleAtRulesEnabledKey()));
    settings.setCSSCustomPropertiesAndValuesEnabled(store.getBoolValueForKey(WebPreferencesKey::cssCustomPropertiesAndValuesEnabledKey()));
    settings.setCSSGradientInterpolationColorSpacesEnabled(store.getBoolValueForKey(WebPreferencesKey::cssGradientInterpolationColorSpacesEnabledKey()));
    settings.setCSSGradientPremultipliedAlphaInterpolationEnabled(store.getBoolValueForKey(WebPreferencesKey::cssGradientPremultipliedAlphaInterpolationEnabledKey()));
    settings.setCSSIndividualTransformPropertiesEnabled(store.getBoolValueForKey(WebPreferencesKey::cssIndividualTransformPropertiesEnabledKey()));
    settings.setCSSInputSecurityEnabled(store.getBoolValueForKey(WebPreferencesKey::cssInputSecurityEnabledKey()));
    settings.setCSSMotionPathEnabled(store.getBoolValueForKey(WebPreferencesKey::cssMotionPathEnabledKey()));
    settings.setCSSOMViewScrollingAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::cssOMViewScrollingAPIEnabledKey()));
    settings.setCSSOMViewSmoothScrollingEnabled(store.getBoolValueForKey(WebPreferencesKey::cssOMViewSmoothScrollingEnabledKey()));
    settings.setCSSRelativeColorSyntaxEnabled(store.getBoolValueForKey(WebPreferencesKey::cssRelativeColorSyntaxEnabledKey()));
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
    settings.setCSSTransformStyleOptimized3DEnabled(store.getBoolValueForKey(WebPreferencesKey::cssTransformStyleOptimized3DEnabledKey()));
#endif
    settings.setCanvasColorSpaceEnabled(store.getBoolValueForKey(WebPreferencesKey::canvasColorSpaceEnabledKey()));
    settings.setCanvasUsesAcceleratedDrawing(store.getBoolValueForKey(WebPreferencesKey::canvasUsesAcceleratedDrawingKey()));
    settings.setCaretBrowsingEnabled(store.getBoolValueForKey(WebPreferencesKey::caretBrowsingEnabledKey()));
    settings.setColorFilterEnabled(store.getBoolValueForKey(WebPreferencesKey::colorFilterEnabledKey()));
    settings.setShowDebugBorders(store.getBoolValueForKey(WebPreferencesKey::compositingBordersVisibleKey()));
    settings.setShowRepaintCounter(store.getBoolValueForKey(WebPreferencesKey::compositingRepaintCountersVisibleKey()));
    settings.setConstantPropertiesEnabled(store.getBoolValueForKey(WebPreferencesKey::constantPropertiesEnabledKey()));
    settings.setContactPickerAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::contactPickerAPIEnabledKey()));
#if ENABLE(CONTENT_CHANGE_OBSERVER)
    settings.setContentChangeObserverEnabled(store.getBoolValueForKey(WebPreferencesKey::contentChangeObserverEnabledKey()));
#endif
    settings.setContentDispositionAttachmentSandboxEnabled(store.getBoolValueForKey(WebPreferencesKey::contentDispositionAttachmentSandboxEnabledKey()));
    settings.setCookieConsentAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::cookieConsentAPIEnabledKey()));
    settings.setCookieEnabled(store.getBoolValueForKey(WebPreferencesKey::cookieEnabledKey()));
    settings.setCoreMathMLEnabled(store.getBoolValueForKey(WebPreferencesKey::coreMathMLEnabledKey()));
    settings.setCrossOriginEmbedderPolicyEnabled(store.getBoolValueForKey(WebPreferencesKey::crossOriginEmbedderPolicyEnabledKey()));
    settings.setCrossOriginOpenerPolicyEnabled(store.getBoolValueForKey(WebPreferencesKey::crossOriginOpenerPolicyEnabledKey()));
    settings.setCursiveFontFamily(store.getStringValueForKey(WebPreferencesKey::cursiveFontFamilyKey()));
    settings.setDNSPrefetchingEnabled(store.getBoolValueForKey(WebPreferencesKey::dnsPrefetchingEnabledKey()));
    settings.setDOMPasteAccessRequestsEnabled(store.getBoolValueForKey(WebPreferencesKey::domPasteAccessRequestsEnabledKey()));
    settings.setDOMPasteAllowed(store.getBoolValueForKey(WebPreferencesKey::domPasteAllowedKey()));
    settings.setDOMTimersThrottlingEnabled(store.getBoolValueForKey(WebPreferencesKey::domTimersThrottlingEnabledKey()));
    settings.setDataTransferItemsEnabled(store.getBoolValueForKey(WebPreferencesKey::dataTransferItemsEnabledKey()));
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    settings.setDateTimeInputsEditableComponentsEnabled(store.getBoolValueForKey(WebPreferencesKey::dateTimeInputsEditableComponentsEnabledKey()));
#endif
    settings.setDefaultFixedFontSize(store.getDoubleValueForKey(WebPreferencesKey::defaultFixedFontSizeKey()));
    settings.setDefaultFontSize(store.getDoubleValueForKey(WebPreferencesKey::defaultFontSizeKey()));
    settings.setDefaultTextEncodingName(store.getStringValueForKey(WebPreferencesKey::defaultTextEncodingNameKey()));
    settings.setDeferredCSSParserEnabled(store.getBoolValueForKey(WebPreferencesKey::deferredCSSParserEnabledKey()));
    settings.setDeveloperExtrasEnabled(store.getBoolValueForKey(WebPreferencesKey::developerExtrasEnabledKey()));
    settings.setDeviceHeight(store.getUInt32ValueForKey(WebPreferencesKey::deviceHeightKey()));
#if ENABLE(DEVICE_ORIENTATION)
    settings.setDeviceOrientationEventEnabled(store.getBoolValueForKey(WebPreferencesKey::deviceOrientationEventEnabledKey()));
#endif
#if ENABLE(DEVICE_ORIENTATION)
    settings.setDeviceOrientationPermissionAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::deviceOrientationPermissionAPIEnabledKey()));
#endif
    settings.setDeviceWidth(store.getUInt32ValueForKey(WebPreferencesKey::deviceWidthKey()));
    settings.setDiagnosticLoggingEnabled(store.getBoolValueForKey(WebPreferencesKey::diagnosticLoggingEnabledKey()));
    settings.setDialogElementEnabled(store.getBoolValueForKey(WebPreferencesKey::dialogElementEnabledKey()));
    settings.setDisabledAdaptationsMetaTagEnabled(store.getBoolValueForKey(WebPreferencesKey::disabledAdaptationsMetaTagEnabledKey()));
    settings.setDisallowSyncXHRDuringPageDismissalEnabled(store.getBoolValueForKey(WebPreferencesKey::disallowSyncXHRDuringPageDismissalEnabledKey()));
    settings.setDisplayListDrawingEnabled(store.getBoolValueForKey(WebPreferencesKey::displayListDrawingEnabledKey()));
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    settings.setDownloadAttributeEnabled(store.getBoolValueForKey(WebPreferencesKey::downloadAttributeEnabledKey()));
#endif
    settings.setEnableInheritURIQueryComponent(store.getBoolValueForKey(WebPreferencesKey::enableInheritURIQueryComponentKey()));
#if ENABLE(ENCRYPTED_MEDIA)
    settings.setEncryptedMediaAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::encryptedMediaAPIEnabledKey()));
#endif
    settings.setEnterKeyHintEnabled(store.getBoolValueForKey(WebPreferencesKey::enterKeyHintEnabledKey()));
    settings.setEventHandlerDrivenSmoothKeyboardScrollingEnabled(store.getBoolValueForKey(WebPreferencesKey::eventHandlerDrivenSmoothKeyboardScrollingEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setExposeSpeakersEnabled(store.getBoolValueForKey(WebPreferencesKey::exposeSpeakersEnabledKey()));
#endif
    settings.setFTPDirectoryTemplatePath(store.getStringValueForKey(WebPreferencesKey::ftpDirectoryTemplatePathKey()));
    settings.setFTPEnabled(store.getBoolValueForKey(WebPreferencesKey::ftpEnabledKey()));
    settings.setFantasyFontFamily(store.getStringValueForKey(WebPreferencesKey::fantasyFontFamilyKey()));
    settings.setFileSystemAccessEnabled(store.getBoolValueForKey(WebPreferencesKey::fileSystemAccessEnabledKey()));
    settings.setFixedFontFamily(store.getStringValueForKey(WebPreferencesKey::fixedFontFamilyKey()));
    settings.setFocusVisibleEnabled(store.getBoolValueForKey(WebPreferencesKey::focusVisibleEnabledKey()));
    settings.setForceFTPDirectoryListings(store.getBoolValueForKey(WebPreferencesKey::forceFTPDirectoryListingsKey()));
    settings.setForceWebGLUsesLowPower(store.getBoolValueForKey(WebPreferencesKey::forceWebGLUsesLowPowerKey()));
#if ENABLE(FULLSCREEN_API)
    settings.setFullScreenEnabled(store.getBoolValueForKey(WebPreferencesKey::fullScreenEnabledKey()));
#endif
#if ENABLE(GAMEPAD)
    settings.setGamepadsEnabled(store.getBoolValueForKey(WebPreferencesKey::gamepadsEnabledKey()));
#endif
#if ENABLE(VIDEO)
    settings.setGenericCueAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::genericCueAPIEnabledKey()));
#endif
#if ENABLE(MEDIA_STREAM)
    settings.setGetUserMediaRequiresFocus(store.getBoolValueForKey(WebPreferencesKey::getUserMediaRequiresFocusKey()));
#endif
    settings.setGoogleAntiFlickerOptimizationQuirkEnabled(store.getBoolValueForKey(WebPreferencesKey::googleAntiFlickerOptimizationQuirkEnabledKey()));
    settings.setHDRMediaCapabilitiesEnabled(store.getBoolValueForKey(WebPreferencesKey::hDRMediaCapabilitiesEnabledKey()));
    settings.setHttpEquivEnabled(store.getBoolValueForKey(WebPreferencesKey::httpEquivEnabledKey()));
    settings.setHasPseudoClassEnabled(store.getBoolValueForKey(WebPreferencesKey::hasPseudoClassEnabledKey()));
    settings.setHiddenPageCSSAnimationSuspensionEnabled(store.getBoolValueForKey(WebPreferencesKey::hiddenPageCSSAnimationSuspensionEnabledKey()));
    settings.setHiddenPageDOMTimerThrottlingAutoIncreases(store.getBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingAutoIncreasesKey()));
    settings.setHiddenPageDOMTimerThrottlingEnabled(store.getBoolValueForKey(WebPreferencesKey::hiddenPageDOMTimerThrottlingEnabledKey()));
    settings.setHyperlinkAuditingEnabled(store.getBoolValueForKey(WebPreferencesKey::hyperlinkAuditingEnabledKey()));
    settings.setICECandidateFilteringEnabled(store.getBoolValueForKey(WebPreferencesKey::iceCandidateFilteringEnabledKey()));
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
    settings.setIOSFormControlRefreshEnabled(store.getBoolValueForKey(WebPreferencesKey::iOSFormControlRefreshEnabledKey()));
#endif
#if ENABLE(IMAGE_ANALYSIS)
    settings.setImageAnalysisMarkupEnabled(store.getBoolValueForKey(WebPreferencesKey::imageAnalysisMarkupEnabledKey()));
#endif
#if ENABLE(IMAGE_ANALYSIS)
    settings.setImageAnalysisQueueEnabled(store.getBoolValueForKey(WebPreferencesKey::imageAnalysisQueueEnabledKey()));
#endif
#if ENABLE(SERVICE_CONTROLS)
    settings.setImageControlsEnabled(store.getBoolValueForKey(WebPreferencesKey::imageControlsEnabledKey()));
#endif
    settings.setInProcessCookieCacheEnabled(store.getBoolValueForKey(WebPreferencesKey::inProcessCookieCacheEnabledKey()));
    settings.setIncompleteImageBorderEnabled(store.getBoolValueForKey(WebPreferencesKey::incompleteImageBorderEnabledKey()));
    settings.setIncrementalRenderingSuppressionTimeoutInSeconds(store.getDoubleValueForKey(WebPreferencesKey::incrementalRenderingSuppressionTimeoutKey()));
    settings.setInertAttributeEnabled(store.getBoolValueForKey(WebPreferencesKey::inertAttributeEnabledKey()));
    settings.setInlineMediaPlaybackRequiresPlaysInlineAttribute(store.getBoolValueForKey(WebPreferencesKey::inlineMediaPlaybackRequiresPlaysInlineAttributeKey()));
#if ENABLE(INPUT_TYPE_COLOR)
    settings.setInputTypeColorEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeColorEnabledKey()));
#endif
#if ENABLE(INPUT_TYPE_DATE)
    settings.setInputTypeDateEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeDateEnabledKey()));
#endif
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
    settings.setInputTypeDateTimeLocalEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeDateTimeLocalEnabledKey()));
#endif
#if ENABLE(INPUT_TYPE_MONTH)
    settings.setInputTypeMonthEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeMonthEnabledKey()));
#endif
#if ENABLE(INPUT_TYPE_TIME)
    settings.setInputTypeTimeEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeTimeEnabledKey()));
#endif
#if ENABLE(INPUT_TYPE_WEEK)
    settings.setInputTypeWeekEnabled(store.getBoolValueForKey(WebPreferencesKey::inputTypeWeekEnabledKey()));
#endif
    settings.setInteractiveFormValidationEnabled(store.getBoolValueForKey(WebPreferencesKey::interactiveFormValidationEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setInterruptAudioOnPageVisibilityChangeEnabled(store.getBoolValueForKey(WebPreferencesKey::interruptAudioOnPageVisibilityChangeEnabledKey()));
#endif
    settings.setIntersectionObserverEnabled(store.getBoolValueForKey(WebPreferencesKey::intersectionObserverEnabledKey()));
    settings.setInvisibleAutoplayNotPermitted(store.getBoolValueForKey(WebPreferencesKey::invisibleAutoplayNotPermittedKey()));
    settings.setIsFirstPartyWebsiteDataRemovalDisabled(store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalDisabledKey()));
    settings.setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled(store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalLiveOnTestingEnabledKey()));
    settings.setIsFirstPartyWebsiteDataRemovalReproTestingEnabled(store.getBoolValueForKey(WebPreferencesKey::isFirstPartyWebsiteDataRemovalReproTestingEnabledKey()));
    settings.setIsLoggedInAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::isLoggedInAPIEnabledKey()));
    settings.setIsSameSiteStrictEnforcementEnabled(store.getBoolValueForKey(WebPreferencesKey::isSameSiteStrictEnforcementEnabledKey()));
    settings.setIsThirdPartyCookieBlockingDisabled(store.getBoolValueForKey(WebPreferencesKey::isThirdPartyCookieBlockingDisabledKey()));
    settings.setJavaEnabled(store.getBoolValueForKey(WebPreferencesKey::javaEnabledKey()));
    settings.setJavaEnabledForLocalFiles(store.getBoolValueForKey(WebPreferencesKey::javaEnabledForLocalFilesKey()));
    settings.setJavaScriptCanAccessClipboard(store.getBoolValueForKey(WebPreferencesKey::javaScriptCanAccessClipboardKey()));
    settings.setJavaScriptCanOpenWindowsAutomatically(store.getBoolValueForKey(WebPreferencesKey::javaScriptCanOpenWindowsAutomaticallyKey()));
    settings.setScriptEnabled(store.getBoolValueForKey(WebPreferencesKey::javaScriptEnabledKey()));
    settings.setScriptMarkupEnabled(store.getBoolValueForKey(WebPreferencesKey::javaScriptMarkupEnabledKey()));
    settings.setLargeImageAsyncDecodingEnabled(store.getBoolValueForKey(WebPreferencesKey::largeImageAsyncDecodingEnabledKey()));
#if ENABLE(LAYER_BASED_SVG_ENGINE)
    settings.setLayerBasedSVGEngineEnabled(store.getBoolValueForKey(WebPreferencesKey::layerBasedSVGEngineEnabledKey()));
#endif
    settings.setLayoutFallbackWidth(store.getUInt32ValueForKey(WebPreferencesKey::layoutFallbackWidthKey()));
    settings.setLayoutViewportHeightExpansionFactor(store.getDoubleValueForKey(WebPreferencesKey::layoutViewportHeightExpansionFactorKey()));
    settings.setLazyIframeLoadingEnabled(store.getBoolValueForKey(WebPreferencesKey::lazyIframeLoadingEnabledKey()));
    settings.setLazyImageLoadingEnabled(store.getBoolValueForKey(WebPreferencesKey::lazyImageLoadingEnabledKey()));
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    settings.setLegacyEncryptedMediaAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::legacyEncryptedMediaAPIEnabledKey()));
#endif
    settings.setLegacyLineLayoutVisualCoverageEnabled(store.getBoolValueForKey(WebPreferencesKey::legacyLineLayoutVisualCoverageEnabledKey()));
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
    settings.setLegacyOverflowScrollingTouchEnabled(store.getBoolValueForKey(WebPreferencesKey::legacyOverflowScrollingTouchEnabledKey()));
#endif
    settings.setLinkPreconnectEnabled(store.getBoolValueForKey(WebPreferencesKey::linkPreconnectKey()));
    settings.setLinkPrefetchEnabled(store.getBoolValueForKey(WebPreferencesKey::linkPrefetchEnabledKey()));
    settings.setLinkPreloadEnabled(store.getBoolValueForKey(WebPreferencesKey::linkPreloadEnabledKey()));
    settings.setLinkPreloadResponsiveImagesEnabled(store.getBoolValueForKey(WebPreferencesKey::linkPreloadResponsiveImagesEnabledKey()));
    settings.setLinkSanitizerEnabled(store.getBoolValueForKey(WebPreferencesKey::linkSanitizerEnabledKey()));
    settings.setLiveRangeSelectionEnabled(store.getBoolValueForKey(WebPreferencesKey::liveRangeSelectionEnabledKey()));
    settings.setLoadDeferringEnabled(store.getBoolValueForKey(WebPreferencesKey::loadDeferringEnabledKey()));
    settings.setLoadsImagesAutomatically(store.getBoolValueForKey(WebPreferencesKey::loadsImagesAutomaticallyKey()));
    settings.setLoadsSiteIconsIgnoringImageLoadingSetting(store.getBoolValueForKey(WebPreferencesKey::loadsSiteIconsIgnoringImageLoadingPreferenceKey()));
    settings.setLocalFileContentSniffingEnabled(store.getBoolValueForKey(WebPreferencesKey::localFileContentSniffingEnabledKey()));
    settings.setLocalStorageEnabled(store.getBoolValueForKey(WebPreferencesKey::localStorageEnabledKey()));
    settings.setLogsPageMessagesToSystemConsoleEnabled(store.getBoolValueForKey(WebPreferencesKey::logsPageMessagesToSystemConsoleEnabledKey()));
    settings.setMainContentUserGestureOverrideEnabled(store.getBoolValueForKey(WebPreferencesKey::mainContentUserGestureOverrideEnabledKey()));
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
    settings.setMaskWebGLStringsEnabled(store.getBoolValueForKey(WebPreferencesKey::maskWebGLStringsEnabledKey()));
#endif
#if ENABLE(MATHML)
    settings.setMathMLEnabled(store.getBoolValueForKey(WebPreferencesKey::mathMLEnabledKey()));
#endif
    settings.setMaxParseDuration(store.getDoubleValueForKey(WebPreferencesKey::maxParseDurationKey()));
    settings.setMediaCapabilitiesEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaCapabilitiesEnabledKey()));
    settings.setMediaCapabilitiesExtensionsEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaCapabilitiesExtensionsEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setMediaCaptureRequiresSecureConnection(store.getBoolValueForKey(WebPreferencesKey::mediaCaptureRequiresSecureConnectionKey()));
#endif
    settings.setMediaContentTypesRequiringHardwareSupport(store.getStringValueForKey(WebPreferencesKey::mediaContentTypesRequiringHardwareSupportKey()));
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
    settings.setMediaControlsContextMenusEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaControlsContextMenusEnabledKey()));
#endif
    settings.setMediaControlsScaleWithPageZoom(store.getBoolValueForKey(WebPreferencesKey::mediaControlsScaleWithPageZoomKey()));
    settings.setMediaDataLoadsAutomatically(store.getBoolValueForKey(WebPreferencesKey::mediaDataLoadsAutomaticallyKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setMediaDevicesEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaDevicesEnabledKey()));
#endif
#if ENABLE(VIDEO)
    settings.setMediaEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaEnabledKey()));
#endif
    settings.setMediaPreloadingEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaPreloadingEnabledKey()));
#if ENABLE(MEDIA_RECORDER)
    settings.setMediaRecorderEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaRecorderEnabledKey()));
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    settings.setMediaSessionCoordinatorEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaSessionCoordinatorEnabledKey()));
#endif
#if ENABLE(MEDIA_SESSION)
    settings.setMediaSessionEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaSessionEnabledKey()));
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
    settings.setMediaSessionPlaylistEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaSessionPlaylistEnabledKey()));
#endif
    settings.setMediaSourceEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaSourceEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setMediaStreamEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaStreamEnabledKey()));
#endif
    settings.setMediaUserGestureInheritsFromDocument(store.getBoolValueForKey(WebPreferencesKey::mediaUserGestureInheritsFromDocumentKey()));
    settings.setMinimumFontSize(store.getDoubleValueForKey(WebPreferencesKey::minimumFontSizeKey()));
    settings.setMinimumLogicalFontSize(store.getDoubleValueForKey(WebPreferencesKey::minimumLogicalFontSizeKey()));
#if ENABLE(TEXT_AUTOSIZING)
    settings.setMinimumZoomFontSize(store.getDoubleValueForKey(WebPreferencesKey::minimumZoomFontSizeKey()));
#endif
#if ENABLE(MEDIA_STREAM)
    settings.setMockCaptureDevicesEnabled(store.getBoolValueForKey(WebPreferencesKey::mockCaptureDevicesEnabledKey()));
#endif
    settings.setMockScrollbarsControllerEnabled(store.getBoolValueForKey(WebPreferencesKey::mockScrollbarsControllerEnabledKey()));
#if ENABLE(MODEL_ELEMENT)
    settings.setModelElementEnabled(store.getBoolValueForKey(WebPreferencesKey::modelElementEnabledKey()));
#endif
    settings.setMomentumScrollingAnimatorEnabled(store.getBoolValueForKey(WebPreferencesKey::momentumScrollingAnimatorEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setMuteCameraOnMicrophoneInterruptionEnabled(store.getBoolValueForKey(WebPreferencesKey::muteCameraOnMicrophoneInterruptionEnabledKey()));
#endif
    settings.setNeedsAdobeFrameReloadingQuirk(store.getBoolValueForKey(WebPreferencesKey::needsAdobeFrameReloadingQuirkKey()));
    settings.setNeedsFrameNameFallbackToIdQuirk(store.getBoolValueForKey(WebPreferencesKey::needsFrameNameFallbackToIdQuirkKey()));
    settings.setNeedsKeyboardEventDisambiguationQuirks(store.getBoolValueForKey(WebPreferencesKey::needsKeyboardEventDisambiguationQuirksKey()));
    settings.setNeedsSiteSpecificQuirks(store.getBoolValueForKey(WebPreferencesKey::needsSiteSpecificQuirksKey()));
    settings.setNeedsStorageAccessFromFileURLsQuirk(store.getBoolValueForKey(WebPreferencesKey::needsStorageAccessFromFileURLsQuirkKey()));
#if ENABLE(NOTIFICATIONS)
    settings.setNotificationsEnabled(store.getBoolValueForKey(WebPreferencesKey::notificationsEnabledKey()));
#endif
    settings.setOfflineWebApplicationCacheEnabled(store.getBoolValueForKey(WebPreferencesKey::offlineWebApplicationCacheEnabledKey()));
    settings.setOverflowClipEnabled(store.getBoolValueForKey(WebPreferencesKey::overflowClipEnabledKey()));
    settings.setOverscrollBehaviorEnabled(store.getBoolValueForKey(WebPreferencesKey::overscrollBehaviorEnabledKey()));
    settings.setPaginateDuringLayoutEnabled(store.getBoolValueForKey(WebPreferencesKey::paginateDuringLayoutEnabledKey()));
    settings.setPassiveTouchListenersAsDefaultOnDocument(store.getBoolValueForKey(WebPreferencesKey::passiveTouchListenersAsDefaultOnDocumentKey()));
    settings.setPassiveWheelListenersAsDefaultOnDocument(store.getBoolValueForKey(WebPreferencesKey::passiveWheelListenersAsDefaultOnDocumentKey()));
    settings.setPasswordEchoDurationInSeconds(store.getDoubleValueForKey(WebPreferencesKey::passwordEchoDurationKey()));
    settings.setPasswordEchoEnabled(store.getBoolValueForKey(WebPreferencesKey::passwordEchoEnabledKey()));
    settings.setPdfJSViewerEnabled(store.getBoolValueForKey(WebPreferencesKey::pdfJSViewerEnabledKey()));
#if ENABLE(WEB_RTC)
    settings.setPeerConnectionEnabled(store.getBoolValueForKey(WebPreferencesKey::peerConnectionEnabledKey()));
#endif
#if ENABLE(MEDIA_STREAM)
    settings.setPerElementSpeakerSelectionEnabled(store.getBoolValueForKey(WebPreferencesKey::perElementSpeakerSelectionEnabledKey()));
#endif
    settings.setPerformanceNavigationTimingAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::performanceNavigationTimingAPIEnabledKey()));
    settings.setPerformanceResourceTimingSensitivePropertiesEnabled(store.getBoolValueForKey(WebPreferencesKey::performanceResourceTimingSensitivePropertiesEnabledKey()));
    settings.setPermissionsAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::permissionsAPIEnabledKey()));
    settings.setPictographFontFamily(store.getStringValueForKey(WebPreferencesKey::pictographFontFamilyKey()));
#if ENABLE(PICTURE_IN_PICTURE_API)
    settings.setPictureInPictureAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::pictureInPictureAPIEnabledKey()));
#endif
    settings.setPluginsEnabled(store.getBoolValueForKey(WebPreferencesKey::pluginsEnabledKey()));
#if ENABLE(IMAGE_ANALYSIS)
    settings.setPreferInlineTextSelectionInImages(store.getBoolValueForKey(WebPreferencesKey::preferInlineTextSelectionInImagesKey()));
#endif
    settings.setPreferPageRenderingUpdatesNear60FPSEnabled(store.getBoolValueForKey(WebPreferencesKey::preferPageRenderingUpdatesNear60FPSEnabledKey()));
    settings.setPrivateClickMeasurementEnabled(store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementEnabledKey()));
    settings.setPunchOutWhiteBackgroundsInDarkMode(store.getBoolValueForKey(WebPreferencesKey::punchOutWhiteBackgroundsInDarkModeKey()));
    settings.setReferrerPolicyAttributeEnabled(store.getBoolValueForKey(WebPreferencesKey::referrerPolicyAttributeEnabledKey()));
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    settings.setRemotePlaybackEnabled(store.getBoolValueForKey(WebPreferencesKey::remotePlaybackEnabledKey()));
#endif
    settings.setRequestIdleCallbackEnabled(store.getBoolValueForKey(WebPreferencesKey::requestIdleCallbackEnabledKey()));
    settings.setRequestSubmitEnabled(store.getBoolValueForKey(WebPreferencesKey::requestSubmitEnabledKey()));
    settings.setRequestVideoFrameCallbackEnabled(store.getBoolValueForKey(WebPreferencesKey::requestVideoFrameCallbackEnabledKey()));
    settings.setRequiresPageVisibilityToPlayAudio(store.getBoolValueForKey(WebPreferencesKey::requiresPageVisibilityToPlayAudioKey()));
    settings.setRequiresUserGestureToLoadVideo(store.getBoolValueForKey(WebPreferencesKey::requiresUserGestureToLoadVideoKey()));
    settings.setResizeObserverEnabled(store.getBoolValueForKey(WebPreferencesKey::resizeObserverEnabledKey()));
    settings.setResolutionMediaFeatureEnabled(store.getBoolValueForKey(WebPreferencesKey::resolutionMediaFeatureEnabledKey()));
    settings.setResourceLoadSchedulingEnabled(store.getBoolValueForKey(WebPreferencesKey::resourceLoadSchedulingEnabledKey()));
#if ENABLE(RESOURCE_USAGE)
    settings.setResourceUsageOverlayVisible(store.getBoolValueForKey(WebPreferencesKey::resourceUsageOverlayVisibleKey()));
#endif
#if HAVE(RUBBER_BANDING)
    settings.setRubberBandingForSubScrollableRegionsEnabled(store.getBoolValueForKey(WebPreferencesKey::rubberBandingForSubScrollableRegionsEnabledKey()));
#endif
    settings.setSampledPageTopColorMaxDifference(store.getDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMaxDifferenceKey()));
    settings.setSampledPageTopColorMinHeight(store.getDoubleValueForKey(WebPreferencesKey::sampledPageTopColorMinHeightKey()));
    settings.setSansSerifFontFamily(store.getStringValueForKey(WebPreferencesKey::sansSerifFontFamilyKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setScreenCaptureEnabled(store.getBoolValueForKey(WebPreferencesKey::screenCaptureEnabledKey()));
#endif
    settings.setScrollAnimatorEnabled(store.getBoolValueForKey(WebPreferencesKey::scrollAnimatorEnabledKey()));
    settings.setScrollToTextFragmentEnabled(store.getBoolValueForKey(WebPreferencesKey::scrollToTextFragmentEnabledKey()));
    settings.setScrollingPerformanceTestingEnabled(store.getBoolValueForKey(WebPreferencesKey::scrollingPerformanceTestingEnabledKey()));
    settings.setSelectTrailingWhitespaceEnabled(store.getBoolValueForKey(WebPreferencesKey::selectTrailingWhitespaceEnabledKey()));
    settings.setSelectionPaintingWithoutSelectionGapsEnabled(store.getBoolValueForKey(WebPreferencesKey::selectionPaintingWithoutSelectionGapsEnabledKey()));
    settings.setSerifFontFamily(store.getStringValueForKey(WebPreferencesKey::serifFontFamilyKey()));
#if ENABLE(SERVICE_CONTROLS)
    settings.setServiceControlsEnabled(store.getBoolValueForKey(WebPreferencesKey::serviceControlsEnabledKey()));
#endif
#if ENABLE(SERVICE_WORKER)
    settings.setServiceWorkerNavigationPreloadEnabled(store.getBoolValueForKey(WebPreferencesKey::serviceWorkerNavigationPreloadEnabledKey()));
#endif
    settings.setSharedWorkerEnabled(store.getBoolValueForKey(WebPreferencesKey::sharedWorkerEnabledKey()));
    settings.setShouldAllowUserInstalledFonts(store.getBoolValueForKey(WebPreferencesKey::shouldAllowUserInstalledFontsKey()));
    settings.setShouldConvertInvalidURLsToBlank(store.getBoolValueForKey(WebPreferencesKey::shouldConvertInvalidURLsToBlankKey()));
    settings.setShouldConvertPositionStyleOnCopy(store.getBoolValueForKey(WebPreferencesKey::shouldConvertPositionStyleOnCopyKey()));
    settings.setShouldDecidePolicyBeforeLoadingQuickLookPreview(store.getBoolValueForKey(WebPreferencesKey::shouldDecidePolicyBeforeLoadingQuickLookPreviewKey()));
    settings.setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(store.getBoolValueForKey(WebPreferencesKey::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaintKey()));
#if ENABLE(VIDEO)
    settings.setShouldDisplayCaptions(store.getBoolValueForKey(WebPreferencesKey::shouldDisplayCaptionsKey()));
#endif
#if ENABLE(VIDEO)
    settings.setShouldDisplaySubtitles(store.getBoolValueForKey(WebPreferencesKey::shouldDisplaySubtitlesKey()));
#endif
#if ENABLE(VIDEO)
    settings.setShouldDisplayTextDescriptions(store.getBoolValueForKey(WebPreferencesKey::shouldDisplayTextDescriptionsKey()));
#endif
#if ENABLE(TEXT_AUTOSIZING)
    settings.setShouldEnableTextAutosizingBoost(store.getBoolValueForKey(WebPreferencesKey::shouldEnableTextAutosizingBoostKey()));
#endif
    settings.setShouldIgnoreMetaViewport(store.getBoolValueForKey(WebPreferencesKey::shouldIgnoreMetaViewportKey()));
    settings.setShouldPrintBackgrounds(store.getBoolValueForKey(WebPreferencesKey::shouldPrintBackgroundsKey()));
    settings.setShouldRespectImageOrientation(store.getBoolValueForKey(WebPreferencesKey::shouldRespectImageOrientationKey()));
    settings.setShouldRestrictBaseURLSchemes(store.getBoolValueForKey(WebPreferencesKey::shouldRestrictBaseURLSchemesKey()));
    settings.setShouldSuppressTextInputFromEditingDuringProvisionalNavigation(store.getBoolValueForKey(WebPreferencesKey::shouldSuppressTextInputFromEditingDuringProvisionalNavigationKey()));
    settings.setShouldUseServiceWorkerShortTimeout(store.getBoolValueForKey(WebPreferencesKey::shouldUseServiceWorkerShortTimeoutKey()));
    settings.setShowsToolTipOverTruncatedText(store.getBoolValueForKey(WebPreferencesKey::showsToolTipOverTruncatedTextKey()));
    settings.setShowsURLsInToolTips(store.getBoolValueForKey(WebPreferencesKey::showsURLsInToolTipsEnabledKey()));
    settings.setShrinksStandaloneImagesToFit(store.getBoolValueForKey(WebPreferencesKey::shrinksStandaloneImagesToFitKey()));
    settings.setSimpleLineLayoutEnabled(store.getBoolValueForKey(WebPreferencesKey::simpleLineLayoutEnabledKey()));
    settings.setSmartInsertDeleteEnabled(store.getBoolValueForKey(WebPreferencesKey::smartInsertDeleteEnabledKey()));
#if ENABLE(MEDIA_SOURCE)
    settings.setSourceBufferChangeTypeEnabled(store.getBoolValueForKey(WebPreferencesKey::sourceBufferChangeTypeEnabledKey()));
#endif
    settings.setSpatialNavigationEnabled(store.getBoolValueForKey(WebPreferencesKey::spatialNavigationEnabledKey()));
#if ENABLE(MEDIA_STREAM)
    settings.setSpeakerSelectionRequiresUserGesture(store.getBoolValueForKey(WebPreferencesKey::speakerSelectionRequiresUserGestureKey()));
#endif
    settings.setSpeechRecognitionEnabled(store.getBoolValueForKey(WebPreferencesKey::speechRecognitionEnabledKey()));
    settings.setSpringTimingFunctionEnabled(store.getBoolValueForKey(WebPreferencesKey::springTimingFunctionEnabledKey()));
    settings.setStandalone(store.getBoolValueForKey(WebPreferencesKey::standaloneKey()));
    settings.setStandardFontFamily(store.getStringValueForKey(WebPreferencesKey::standardFontFamilyKey()));
    settings.setStorageAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::storageAPIEnabledKey()));
    settings.setStorageAccessAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::storageAccessAPIEnabledKey()));
    settings.setSubgridEnabled(store.getBoolValueForKey(WebPreferencesKey::subgridEnabledKey()));
    settings.setSubpixelAntialiasedLayerTextEnabled(store.getBoolValueForKey(WebPreferencesKey::subpixelAntialiasedLayerTextEnabledKey()));
    settings.setSuppressesIncrementalRendering(store.getBoolValueForKey(WebPreferencesKey::suppressesIncrementalRenderingKey()));
    settings.setSyntheticEditingCommandsEnabled(store.getBoolValueForKey(WebPreferencesKey::syntheticEditingCommandsEnabledKey()));
#if USE(SYSTEM_PREVIEW)
    settings.setSystemPreviewEnabled(store.getBoolValueForKey(WebPreferencesKey::systemPreviewEnabledKey()));
#endif
    settings.setTelephoneNumberParsingEnabled(store.getBoolValueForKey(WebPreferencesKey::telephoneNumberParsingEnabledKey()));
    settings.setTemporaryTileCohortRetentionEnabled(store.getBoolValueForKey(WebPreferencesKey::temporaryTileCohortRetentionEnabledKey()));
    settings.setTextAreasAreResizable(store.getBoolValueForKey(WebPreferencesKey::textAreasAreResizableKey()));
#if ENABLE(TEXT_AUTOSIZING)
    settings.setTextAutosizingEnabled(store.getBoolValueForKey(WebPreferencesKey::textAutosizingEnabledKey()));
#endif
#if ENABLE(TEXT_AUTOSIZING)
    settings.setTextAutosizingUsesIdempotentMode(store.getBoolValueForKey(WebPreferencesKey::textAutosizingUsesIdempotentModeKey()));
#endif
    settings.setTextInteractionEnabled(store.getBoolValueForKey(WebPreferencesKey::textInteractionEnabledKey()));
#if ENABLE(IMAGE_ANALYSIS)
    settings.setTextRecognitionEnhancementsEnabled(store.getBoolValueForKey(WebPreferencesKey::textRecognitionEnhancementsEnabledKey()));
#endif
    settings.setThirdPartyIframeRedirectBlockingEnabled(store.getBoolValueForKey(WebPreferencesKey::thirdPartyIframeRedirectBlockingEnabledKey()));
    settings.setShowTiledScrollingIndicator(store.getBoolValueForKey(WebPreferencesKey::tiledScrollingIndicatorVisibleKey()));
    settings.setTrackConfigurationEnabled(store.getBoolValueForKey(WebPreferencesKey::trackConfigurationEnabledKey()));
    settings.setTransformStreamAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::transformStreamAPIEnabledKey()));
    settings.setTreatsAnyTextCSSLinkAsStylesheet(store.getBoolValueForKey(WebPreferencesKey::treatsAnyTextCSSLinkAsStylesheetKey()));
    settings.setUndoManagerAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::undoManagerAPIEnabledKey()));
    settings.setUseGiantTiles(store.getBoolValueForKey(WebPreferencesKey::useGiantTilesKey()));
    settings.setUseImageDocumentForSubframePDF(store.getBoolValueForKey(WebPreferencesKey::useImageDocumentForSubframePDFKey()));
    settings.setUseLegacyBackgroundSizeShorthandBehavior(store.getBoolValueForKey(WebPreferencesKey::useLegacyBackgroundSizeShorthandBehaviorKey()));
    settings.setUseLegacyTextAlignPositionedElementBehavior(store.getBoolValueForKey(WebPreferencesKey::useLegacyTextAlignPositionedElementBehaviorKey()));
    settings.setUsePreHTML5ParserQuirks(store.getBoolValueForKey(WebPreferencesKey::usePreHTML5ParserQuirksKey()));
#if HAVE(SCREEN_CAPTURE_KIT)
    settings.setUseScreenCaptureKit(store.getBoolValueForKey(WebPreferencesKey::useScreenCaptureKitKey()));
#endif
    settings.setUsesBackForwardCache(store.getBoolValueForKey(WebPreferencesKey::usesBackForwardCacheKey()));
    settings.setUsesEncodingDetector(store.getBoolValueForKey(WebPreferencesKey::usesEncodingDetectorKey()));
#if ENABLE(VP9)
    settings.setVP9DecoderEnabled(store.getBoolValueForKey(WebPreferencesKey::vp9DecoderEnabledKey()));
#endif
#if ENABLE(VIDEO)
    settings.setVideoQualityIncludesDisplayCompositingEnabled(store.getBoolValueForKey(WebPreferencesKey::videoQualityIncludesDisplayCompositingEnabledKey()));
#endif
    settings.setViewportFitEnabled(store.getBoolValueForKey(WebPreferencesKey::viewportFitEnabledKey()));
    settings.setVisibleDebugOverlayRegions(store.getUInt32ValueForKey(WebPreferencesKey::visibleDebugOverlayRegionsKey()));
    settings.setVisualViewportAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::visualViewportAPIEnabledKey()));
    settings.setVisualViewportEnabled(store.getBoolValueForKey(WebPreferencesKey::visualViewportEnabledKey()));
    settings.setWantsBalancedSetDefersLoadingBehavior(store.getBoolValueForKey(WebPreferencesKey::wantsBalancedSetDefersLoadingBehaviorKey()));
    settings.setWebAnimationsCompositeOperationsEnabled(store.getBoolValueForKey(WebPreferencesKey::webAnimationsCompositeOperationsEnabledKey()));
    settings.setWebAnimationsCustomEffectsEnabled(store.getBoolValueForKey(WebPreferencesKey::webAnimationsCustomEffectsEnabledKey()));
    settings.setWebAnimationsCustomFrameRateEnabled(store.getBoolValueForKey(WebPreferencesKey::webAnimationsCustomFrameRateEnabledKey()));
    settings.setWebAnimationsMutableTimelinesEnabled(store.getBoolValueForKey(WebPreferencesKey::webAnimationsMutableTimelinesEnabledKey()));
#if ENABLE(WEB_ARCHIVE)
    settings.setWebArchiveDebugModeEnabled(store.getBoolValueForKey(WebPreferencesKey::webArchiveDebugModeEnabledKey()));
#endif
#if ENABLE(WEB_AUDIO)
    settings.setWebAudioEnabled(store.getBoolValueForKey(WebPreferencesKey::webAudioEnabledKey()));
#endif
#if ENABLE(WEB_AUTHN)
    settings.setWebAuthenticationEnabled(store.getBoolValueForKey(WebPreferencesKey::webAuthenticationEnabledKey()));
#endif
#if ENABLE(WEBGL2)
    settings.setWebGL2Enabled(store.getBoolValueForKey(WebPreferencesKey::webGL2EnabledKey()));
#endif
    settings.setWebGLEnabled(store.getBoolValueForKey(WebPreferencesKey::webGLEnabledKey()));
#if ENABLE(WEBGL) && PLATFORM(COCOA)
    settings.setWebGLUsingMetal(store.getBoolValueForKey(WebPreferencesKey::webGLUsingMetalKey()));
#endif
    settings.setWebGPU(store.getBoolValueForKey(WebPreferencesKey::webGPUKey()));
    settings.setWebKitAdditionsFeature1Enabled(store.getBoolValueForKey(WebPreferencesKey::webKitAdditionsFeature1EnabledKey()));
    settings.setWebLocksAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::webLocksAPIEnabledKey()));
#if ENABLE(WEB_RTC)
    settings.setWebRTCEncodedTransformEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCEncodedTransformEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCH265CodecEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCH265CodecEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCPlatformCodecsInGPUProcessEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformCodecsInGPUProcessEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCRemoteVideoFrameEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCRemoteVideoFrameEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCSFrameTransformEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCSFrameTransformEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCSocketsProxyingEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCSocketsProxyingEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCVP9Profile0CodecEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCVP9Profile0CodecEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    settings.setWebRTCVP9Profile2CodecEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCVP9Profile2CodecEnabledKey()));
#endif
    settings.setWebSecurityEnabled(store.getBoolValueForKey(WebPreferencesKey::webSecurityEnabledKey()));
    settings.setWebShareEnabled(store.getBoolValueForKey(WebPreferencesKey::webShareEnabledKey()));
    settings.setWebShareFileAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::webShareFileAPIEnabledKey()));
#if ENABLE(WEBXR)
    settings.setWebXRAugmentedRealityModuleEnabled(store.getBoolValueForKey(WebPreferencesKey::webXRAugmentedRealityModuleEnabledKey()));
#endif
#if ENABLE(WEBXR)
    settings.setWebXREnabled(store.getBoolValueForKey(WebPreferencesKey::webXREnabledKey()));
#endif
#if ENABLE(WEBXR)
    settings.setWebXRGamepadsModuleEnabled(store.getBoolValueForKey(WebPreferencesKey::webXRGamepadsModuleEnabledKey()));
#endif
#if ENABLE(WEBXR_HANDS)
    settings.setWebXRHandInputModuleEnabled(store.getBoolValueForKey(WebPreferencesKey::webXRHandInputModuleEnabledKey()));
#endif
    settings.setWheelEventGesturesBecomeNonBlocking(store.getBoolValueForKey(WebPreferencesKey::wheelEventGesturesBecomeNonBlockingKey()));
    settings.setWindowFocusRestricted(store.getBoolValueForKey(WebPreferencesKey::windowFocusRestrictedKey()));
    settings.setXSSAuditorEnabled(store.getBoolValueForKey(WebPreferencesKey::xssAuditorEnabledKey()));
}

void WebPage::updatePreferencesGenerated(const WebPreferencesStore& store)
{
#if USE(AVFOUNDATION)
    WebCore::DeprecatedGlobalSettings::setAVFoundationEnabled(store.getBoolValueForKey(WebPreferencesKey::isAVFoundationEnabledKey()));
#endif
#if USE(AVFOUNDATION)
    WebCore::DeprecatedGlobalSettings::setAVFoundationNSURLSessionEnabled(store.getBoolValueForKey(WebPreferencesKey::isAVFoundationNSURLSessionEnabledKey()));
#endif
#if PLATFORM(IOS_FAMILY)
    WebCore::DeprecatedGlobalSettings::setDisableScreenSizeOverride(store.getBoolValueForKey(WebPreferencesKey::disableScreenSizeOverrideKey()));
#endif
#if USE(GSTREAMER)
    WebCore::DeprecatedGlobalSettings::setGStreamerEnabled(store.getBoolValueForKey(WebPreferencesKey::isGStreamerEnabledKey()));
#endif
    WebCore::DeprecatedGlobalSettings::setLowPowerVideoAudioBufferSizeEnabled(store.getBoolValueForKey(WebPreferencesKey::lowPowerVideoAudioBufferSizeEnabledKey()));
    WebCore::DeprecatedGlobalSettings::setMockScrollbarsEnabled(store.getBoolValueForKey(WebPreferencesKey::mockScrollbarsEnabledKey()));

    WebCore::RuntimeEnabledFeatures::sharedFeatures().setAccessibilityObjectModelEnabled(store.getBoolValueForKey(WebPreferencesKey::accessibilityObjectModelEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setAriaReflectionEnabled(store.getBoolValueForKey(WebPreferencesKey::ariaReflectionEnabledKey()));
#if ENABLE(ATTACHMENT_ELEMENT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setAttachmentElementEnabled(store.getBoolValueForKey(WebPreferencesKey::attachmentElementEnabledKey()));
#endif
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setBuiltInNotificationsEnabled(store.getBoolValueForKey(WebPreferencesKey::builtInNotificationsEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCSSDisplayContentsAXSupportEnabled(store.getBoolValueForKey(WebPreferencesKey::cssDisplayContentsAXSupportEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCSSLogicalEnabled(store.getBoolValueForKey(WebPreferencesKey::cssLogicalEnabledKey()));
#if ENABLE(CSS_PAINTING_API)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCSSPaintingAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::cssPaintingAPIEnabledKey()));
#endif
#if ENABLE(CSS_TYPED_OM)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCSSTypedOMEnabled(store.getBoolValueForKey(WebPreferencesKey::cssTypedOMEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCacheAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::cacheAPIEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setCustomPasteboardDataEnabled(store.getBoolValueForKey(WebPreferencesKey::customPasteboardDataEnabledKey()));
#if ENABLE(DATALIST_ELEMENT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setDataListElementEnabled(store.getBoolValueForKey(WebPreferencesKey::dataListElementEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setDirectoryUploadEnabled(store.getBoolValueForKey(WebPreferencesKey::directoryUploadEnabledKey()));
#if HAVE(CELESTIAL)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setDisableMediaExperiencePIDInheritance(store.getBoolValueForKey(WebPreferencesKey::disableMediaExperiencePIDInheritanceKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setFetchAPIKeepAliveEnabled(store.getBoolValueForKey(WebPreferencesKey::fetchAPIKeepAliveEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setHighlightAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::highlightAPIEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setImageBitmapEnabled(store.getBoolValueForKey(WebPreferencesKey::imageBitmapEnabledKey()));
#if HAVE(INCREMENTAL_PDF_APIS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setIncrementalPDFLoadingEnabled(store.getBoolValueForKey(WebPreferencesKey::incrementalPDFLoadingEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setInspectorAdditionsEnabled(store.getBoolValueForKey(WebPreferencesKey::inspectorAdditionsEnabledKey()));
#if ENABLE(ACCESSIBILITY_ISOLATED_TREE)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setIsAccessibilityIsolatedTreeEnabled(store.getBoolValueForKey(WebPreferencesKey::isAccessibilityIsolatedTreeEnabledKey()));
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setIsNSURLSessionWebSocketEnabled(store.getBoolValueForKey(WebPreferencesKey::isNSURLSessionWebSocketEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setItpDebugModeEnabled(store.getBoolValueForKey(WebPreferencesKey::itpDebugModeEnabledKey()));
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setLayoutFormattingContextEnabled(store.getBoolValueForKey(WebPreferencesKey::layoutFormattingContextEnabledKey()));
#endif
#if ENABLE(LAYOUT_FORMATTING_CONTEXT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setLayoutFormattingContextIntegrationEnabled(store.getBoolValueForKey(WebPreferencesKey::layoutFormattingContextIntegrationEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setLineHeightUnitsEnabled(store.getBoolValueForKey(WebPreferencesKey::lineHeightUnitsEnabledKey()));
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setMediaSourceInlinePaintingEnabled(store.getBoolValueForKey(WebPreferencesKey::mediaSourceInlinePaintingEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setMenuItemElementEnabled(store.getBoolValueForKey(WebPreferencesKey::menuItemElementEnabledKey()));
#if ENABLE(MODEL_ELEMENT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setModelDocumentEnabled(store.getBoolValueForKey(WebPreferencesKey::modelDocumentEnabledKey()));
#endif
#if ENABLE(TOUCH_EVENTS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setMouseEventsSimulationEnabled(store.getBoolValueForKey(WebPreferencesKey::mouseEventsSimulationEnabledKey()));
#endif
#if ENABLE(NOTIFICATION_EVENT)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setNotificationEventEnabled(store.getBoolValueForKey(WebPreferencesKey::notificationEventEnabledKey()));
#endif
#if ENABLE(OFFSCREEN_CANVAS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setOffscreenCanvasEnabled(store.getBoolValueForKey(WebPreferencesKey::offscreenCanvasEnabledKey()));
#endif
#if ENABLE(OFFSCREEN_CANVAS_IN_WORKERS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setOffscreenCanvasInWorkersEnabled(store.getBoolValueForKey(WebPreferencesKey::offscreenCanvasInWorkersEnabledKey()));
#endif
#if ENABLE(OPUS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setOpusDecoderEnabled(store.getBoolValueForKey(WebPreferencesKey::opusDecoderEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setPageAtRuleSupportEnabled(store.getBoolValueForKey(WebPreferencesKey::pageAtRuleSupportEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setPaintTimingEnabled(store.getBoolValueForKey(WebPreferencesKey::paintTimingEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setPrivateClickMeasurementDebugModeEnabled(store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementDebugModeEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setPrivateClickMeasurementFraudPreventionEnabled(store.getBoolValueForKey(WebPreferencesKey::privateClickMeasurementFraudPreventionEnabledKey()));
#if ENABLE(SERVICE_WORKER)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setPushAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::pushAPIEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setReadableByteStreamAPIEnabled(store.getBoolValueForKey(WebPreferencesKey::readableByteStreamAPIEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setRestrictedHTTPResponseAccess(store.getBoolValueForKey(WebPreferencesKey::restrictedHTTPResponseAccessKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setSecureContextChecksEnabled(store.getBoolValueForKey(WebPreferencesKey::secureContextChecksEnabledKey()));
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setServerTimingEnabled(store.getBoolValueForKey(WebPreferencesKey::serverTimingEnabledKey()));
#if ENABLE(SERVICE_WORKER)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setServiceWorkerEnabled(store.getBoolValueForKey(WebPreferencesKey::serviceWorkersEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setUserGesturePromisePropagationEnabled(store.getBoolValueForKey(WebPreferencesKey::userGesturePromisePropagationEnabledKey()));
#if ENABLE(VORBIS)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setVorbisDecoderEnabled(store.getBoolValueForKey(WebPreferencesKey::vorbisDecoderEnabledKey()));
#endif
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebAPIStatisticsEnabled(store.getBoolValueForKey(WebPreferencesKey::webAPIStatisticsEnabledKey()));
#if ENABLE(WEB_AUTHN)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebAuthenticationModernEnabled(store.getBoolValueForKey(WebPreferencesKey::webAuthenticationModernEnabledKey()));
#endif
#if ENABLE(WEBM_FORMAT_READER)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebMFormatReaderEnabled(store.getBoolValueForKey(WebPreferencesKey::webMFormatReaderEnabledKey()));
#endif
#if ENABLE(MEDIA_SOURCE)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebMParserEnabled(store.getBoolValueForKey(WebPreferencesKey::webMParserEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCDTMFEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCDTMFEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCH264LowLatencyEncoderEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCH264LowLatencyEncoderEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCH264SimulcastEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCH264SimulcastEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCMDNSICECandidatesEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCMDNSICECandidatesEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCPlatformTCPSocketsEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformTCPSocketsEnabledKey()));
#endif
#if ENABLE(WEB_RTC)
    WebCore::RuntimeEnabledFeatures::sharedFeatures().setWebRTCPlatformUDPSocketsEnabled(store.getBoolValueForKey(WebPreferencesKey::webRTCPlatformUDPSocketsEnabledKey()));
#endif
}

}
