/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.io.exporter.plugin.ExporterSpreadsheet;
import org.gephi.project.api.ProjectController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class UIExporterSpreadsheetPanel
extends JPanel {
    private static final String SEPARATOR_SAVED_PREFERENCES = "UIExporterSpreadsheetPanel_Separator";
    private static final String TABLE_SAVED_PREFERENCES = "UIExporterSpreadsheetPanel_Table";
    private ColumnCheckboxWrapper[] columnsCheckBoxes;
    private GraphModel graphModel;
    private JLabel columnsLabel;
    private JPanel columnsPanel;
    private JScrollPane scroll;
    private JComboBox separatorComboBox;
    private JLabel separatorLabel;
    private JComboBox tableComboBox;
    private JLabel tableLabel;

    public UIExporterSpreadsheetPanel() {
        this.initComponents();
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(','), this.getMessage("UIExporterSpreadsheetPanel.comma")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(';'), this.getMessage("UIExporterSpreadsheetPanel.semicolon")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf('\t'), this.getMessage("UIExporterSpreadsheetPanel.tab")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(' '), this.getMessage("UIExporterSpreadsheetPanel.space")));
        this.separatorComboBox.setSelectedIndex(NbPreferences.forModule(UIExporterSpreadsheetPanel.class).getInt(SEPARATOR_SAVED_PREFERENCES, 0));
        this.tableComboBox.addItem(this.getMessage("UIExporterSpreadsheetPanel.table.nodes"));
        this.tableComboBox.addItem(this.getMessage("UIExporterSpreadsheetPanel.table.edges"));
        this.separatorComboBox.setSelectedIndex(NbPreferences.forModule(UIExporterSpreadsheetPanel.class).getInt(SEPARATOR_SAVED_PREFERENCES, 0));
        this.tableComboBox.setSelectedIndex(NbPreferences.forModule(UIExporterSpreadsheetPanel.class).getInt(TABLE_SAVED_PREFERENCES, 1));
    }

    public void unSetup() {
        NbPreferences.forModule(UIExporterSpreadsheetPanel.class).putInt(SEPARATOR_SAVED_PREFERENCES, this.separatorComboBox.getSelectedIndex());
        NbPreferences.forModule(UIExporterSpreadsheetPanel.class).putInt(TABLE_SAVED_PREFERENCES, this.tableComboBox.getSelectedIndex());
    }

    private void refreshColumns() {
        if (this.graphModel == null) {
            return;
        }
        this.columnsPanel.removeAll();
        this.columnsPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        ArrayList<ColumnCheckboxWrapper> columnCheckboxesList = new ArrayList<ColumnCheckboxWrapper>();
        Table table = this.getSelectedTable() == ExporterSpreadsheet.ExportTable.NODES ? this.graphModel.getNodeTable() : this.graphModel.getEdgeTable();
        for (Column column : table) {
            columnCheckboxesList.add(new ColumnCheckboxWrapper(column.getId(), column.getTitle()));
        }
        for (ColumnCheckboxWrapper columnCheckboxWrapper : this.columnsCheckBoxes = columnCheckboxesList.toArray(new ColumnCheckboxWrapper[0])) {
            this.columnsPanel.add((Component)columnCheckboxWrapper, "wrap");
        }
        this.columnsPanel.revalidate();
        this.columnsPanel.repaint();
    }

    public Character getSelectedSeparator() {
        Object item = this.separatorComboBox.getSelectedItem();
        if (item instanceof SeparatorWrapper) {
            return ((SeparatorWrapper)item).separator;
        }
        return Character.valueOf(item.toString().charAt(0));
    }

    public LinkedHashSet<String> getSelectedColumnsIds() {
        LinkedHashSet<String> columnsIds = new LinkedHashSet<String>();
        for (ColumnCheckboxWrapper columnsCheckBox : this.columnsCheckBoxes) {
            if (!columnsCheckBox.isSelected()) continue;
            columnsIds.add(columnsCheckBox.id);
        }
        return columnsIds;
    }

    public ExporterSpreadsheet.ExportTable getSelectedTable() {
        return this.tableComboBox.getSelectedIndex() == 0 ? ExporterSpreadsheet.ExportTable.NODES : ExporterSpreadsheet.ExportTable.EDGES;
    }

    public void setup(ExporterSpreadsheet exporter) {
        ExporterSpreadsheet.ExportTable tableToExport = exporter.getTableToExport();
        if (tableToExport != null) {
            this.tableComboBox.setSelectedIndex(tableToExport == ExporterSpreadsheet.ExportTable.NODES ? 0 : 1);
        }
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.graphModel = (GraphModel)projectController.getCurrentWorkspace().getLookup().lookup(GraphModel.class);
        this.refreshColumns();
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)resName);
    }

    private void initComponents() {
        this.separatorLabel = new JLabel();
        this.separatorComboBox = new JComboBox();
        this.scroll = new JScrollPane();
        this.columnsPanel = new JPanel();
        this.columnsLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableComboBox = new JComboBox();
        this.separatorLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.separatorLabel.text"));
        this.columnsPanel.setLayout(new GridLayout(1, 0));
        this.scroll.setViewportView(this.columnsPanel);
        this.columnsLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.columnsLabel.text"));
        this.tableLabel.setText(NbBundle.getMessage(UIExporterSpreadsheetPanel.class, (String)"UIExporterSpreadsheetPanel.tableLabel.text"));
        this.tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIExporterSpreadsheetPanel.this.tableComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 235, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.columnsLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tableLabel, -2, 1, Short.MAX_VALUE).addComponent(this.separatorLabel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separatorComboBox, 0, 151, Short.MAX_VALUE).addComponent(this.tableComboBox, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableLabel).addComponent(this.tableComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separatorLabel).addComponent(this.separatorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 225, Short.MAX_VALUE).addContainerGap()));
    }

    private void tableComboBoxActionPerformed(ActionEvent evt) {
        this.refreshColumns();
    }

    private class ColumnCheckboxWrapper
    extends JCheckBox {
        private final String id;

        public ColumnCheckboxWrapper(String id, String title) {
            super(title, true);
            this.id = id;
        }
    }

    private class SeparatorWrapper {
        private final Character separator;
        private String displayText;

        public SeparatorWrapper(Character separator) {
            this.separator = separator;
        }

        public SeparatorWrapper(Character separator, String displayText) {
            this.separator = separator;
            this.displayText = displayText;
        }

        public String toString() {
            if (this.displayText != null) {
                return this.displayText;
            }
            return String.valueOf(this.separator);
        }
    }
}

