/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.ProxyPolicy;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ProxyPreferencesPanel
extends VerticallyScrollablePanel {
    private transient Map<ProxyPolicy, JRadioButton> rbProxyPolicy;
    private final JosmTextField tfProxyHttpHost = new JosmTextField();
    private final JosmTextField tfProxyHttpPort = new JosmTextField(5);
    private final JosmTextField tfProxySocksHost = new JosmTextField(20);
    private final JosmTextField tfProxySocksPort = new JosmTextField(5);
    private final JosmTextField tfProxyHttpUser = new JosmTextField(20);
    private final JosmPasswordField tfProxyHttpPassword = new JosmPasswordField(20);
    private JPanel pnlHttpProxyConfigurationPanel;
    private JPanel pnlSocksProxyConfigurationPanel;

    protected final JPanel buildHttpProxyConfigurationPanel() {
        AutoSizePanel pnl = new AutoSizePanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 21;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxyHttpHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxyHttpPort, gc);
        this.tfProxyHttpPort.setMinimumSize(this.tfProxyHttpPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Please enter a username and a password if your proxy requires authentication.", new Object[0])), gc);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 1;
        gc.fill = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("User:", new Object[0])), gc);
        gc.gridy = 3;
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxyHttpUser, gc);
        this.tfProxyHttpUser.setMinimumSize(this.tfProxyHttpUser.getPreferredSize());
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Password:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxyHttpPassword, gc);
        this.tfProxyHttpPassword.setMinimumSize(this.tfProxyHttpPassword.getPreferredSize());
        gc.gridy = 5;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final JPanel buildSocksProxyConfigurationPanel() {
        AutoSizePanel pnl = new AutoSizePanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 21;
        gc.insets = new Insets(5, 5, 0, 0);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxySocksHost, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        pnl.add((Component)new JLabel(I18n.trc("server", "Port:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfProxySocksPort, gc);
        this.tfProxySocksPort.setMinimumSize(this.tfProxySocksPort.getPreferredSize());
        gc.gridy = 2;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final JPanel buildProxySettingsPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        ButtonGroup bgProxyPolicy = new ButtonGroup();
        this.rbProxyPolicy = new EnumMap<ProxyPolicy, JRadioButton>(ProxyPolicy.class);
        ProxyPolicyChangeListener policyChangeListener = new ProxyPolicyChangeListener();
        for (ProxyPolicy pp : ProxyPolicy.values()) {
            this.rbProxyPolicy.put(pp, new JRadioButton());
            bgProxyPolicy.add(this.rbProxyPolicy.get((Object)pp));
            this.rbProxyPolicy.get((Object)pp).addItemListener(policyChangeListener);
        }
        pnl.add((Component)this.newRadioButton(ProxyPolicy.NO_PROXY, I18n.tr("No proxy", new Object[0])), GBC.eop().anchor(18));
        pnl.add((Component)this.newRadioButton(ProxyPolicy.USE_SYSTEM_SETTINGS, I18n.tr("Use standard system settings", new Object[0])), GBC.eol());
        if (!DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            String msg = I18n.tr("Use standard system settings (disabled. Start JOSM with <tt>-Djava.net.useSystemProxies=true</tt> to enable)", new Object[0]);
            pnl.add((Component)new JMultilineLabel("<html>" + msg + "</html>"), GBC.eop().fill(2));
        }
        pnl.add((Component)this.newRadioButton(ProxyPolicy.USE_HTTP_PROXY, I18n.tr("Manually configure a HTTP proxy", new Object[0])), GBC.eol());
        this.pnlHttpProxyConfigurationPanel = this.buildHttpProxyConfigurationPanel();
        pnl.add((Component)this.pnlHttpProxyConfigurationPanel, GBC.eop().fill(2));
        pnl.add((Component)this.newRadioButton(ProxyPolicy.USE_SOCKS_PROXY, I18n.tr("Use a SOCKS proxy", new Object[0])), GBC.eol());
        this.pnlSocksProxyConfigurationPanel = this.buildSocksProxyConfigurationPanel();
        pnl.add((Component)this.pnlSocksProxyConfigurationPanel, GBC.eop().fill(2));
        pnl.add(Box.createVerticalGlue(), GBC.eol().fill());
        return pnl;
    }

    private JRadioButton newRadioButton(ProxyPolicy policy, String text) {
        JRadioButton radioButton = this.rbProxyPolicy.get((Object)policy);
        radioButton.setText(text);
        return radioButton;
    }

    public final void initFromPreferences() {
        IPreferences pref = Config.getPref();
        ProxyPolicy pp = Optional.ofNullable(ProxyPolicy.fromName(pref.get("proxy.policy", null))).orElse(ProxyPolicy.NO_PROXY);
        this.rbProxyPolicy.get((Object)pp).setSelected(true);
        this.tfProxyHttpHost.setText(pref.get("proxy.http.host", ""));
        this.tfProxyHttpPort.setText(pref.get("proxy.http.port", ""));
        this.tfProxySocksHost.setText(pref.get("proxy.socks.host", ""));
        this.tfProxySocksPort.setText(pref.get("proxy.socks.port", ""));
        if (pp == ProxyPolicy.USE_SYSTEM_SETTINGS && !DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            Logging.warn(I18n.tr("JOSM is configured to use proxies from the system setting, but the JVM is not configured to retrieve them. Resetting preferences to ''No proxy''", new Object[0]));
            pp = ProxyPolicy.NO_PROXY;
            this.rbProxyPolicy.get((Object)pp).setSelected(true);
        }
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText());
            if (pa == null) {
                this.tfProxyHttpUser.setText("");
                this.tfProxyHttpPassword.setText("");
            } else {
                this.tfProxyHttpUser.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfProxyHttpPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            this.tfProxyHttpUser.setText("");
            this.tfProxyHttpPassword.setText("");
        }
    }

    protected final void updateEnabledState() {
        boolean isHttpProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY).isSelected();
        for (Component c : this.pnlHttpProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isHttpProxy);
        }
        boolean isSocksProxy = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY).isSelected();
        for (Component c : this.pnlSocksProxyConfigurationPanel.getComponents()) {
            c.setEnabled(isSocksProxy);
        }
        this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS).setEnabled(DefaultProxySelector.willJvmRetrieveSystemProxies());
    }

    public ProxyPreferencesPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildProxySettingsPanel(), GBC.eop().anchor(18).fill(1));
        this.initFromPreferences();
        this.updateEnabledState();
    }

    public void saveToPreferences() {
        ProxyPolicy policy = Arrays.stream(ProxyPolicy.values()).filter(pp -> this.rbProxyPolicy.get(pp).isSelected()).findFirst().orElse(null);
        IPreferences pref = Config.getPref();
        pref.put("proxy.policy", Optional.ofNullable(policy).orElse(ProxyPolicy.NO_PROXY).getName());
        pref.put("proxy.http.host", this.tfProxyHttpHost.getText());
        pref.put("proxy.http.port", this.tfProxyHttpPort.getText());
        pref.put("proxy.socks.host", this.tfProxySocksHost.getText());
        pref.put("proxy.socks.port", this.tfProxySocksPort.getText());
        ProxySelector selector = ProxySelector.getDefault();
        if (selector instanceof DefaultProxySelector) {
            ((DefaultProxySelector)selector).initFromPreferences();
        }
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = new PasswordAuthentication(this.tfProxyHttpUser.getText().trim(), this.tfProxyHttpPassword.getPassword());
            cm.store(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText(), pa);
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
        }
    }

    class ProxyPolicyChangeListener
    implements ItemListener {
        ProxyPolicyChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ProxyPreferencesPanel.this.updateEnabledState();
        }
    }

    static final class AutoSizePanel
    extends JPanel {
        AutoSizePanel() {
            super(new GridBagLayout());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

