"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.latest = void 0;
const fs_1 = __importDefault(require("fs"));
const fast_memoize_1 = __importDefault(require("fast-memoize"));
/**
 * Returns registry object given a valid path
 *
 * @param path
 * @returns a registry object
 */
const readStaticRegistry = (path) => {
    return JSON.parse(fs_1.default.readFileSync(path, 'utf8'));
};
const registryMemoized = (0, fast_memoize_1.default)(readStaticRegistry);
/**
 * Fetches the version in static registry.
 *
 * @param packageName
 * @param currentVersion
 * @param options
 * @returns A promise that fulfills to string value or null
 */
const latest = (packageName, currentVersion, options = {}) => {
    const registry = registryMemoized(options.registry);
    return Promise.resolve(registry[packageName] || null);
};
exports.latest = latest;
//# sourceMappingURL=staticRegistry.js.map