/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class TextBlockBordered
extends AbstractTextBlock
implements TextBlock {
    private final double cornersize;
    private final HColor backgroundColor;
    private final HColor borderColor;
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private final UStroke stroke;
    private final boolean withShadow;
    private final TextBlock textBlock;

    TextBlockBordered(TextBlock textBlock, UStroke stroke, HColor borderColor, HColor backgroundColor, double cornersize, double marginX, double marginY) {
        this.top = marginY;
        this.right = marginX;
        this.bottom = marginY;
        this.left = marginX;
        this.cornersize = cornersize;
        this.textBlock = textBlock;
        this.withShadow = false;
        this.stroke = stroke;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
    }

    TextBlockBordered(TextBlock textBlock, UStroke stroke, HColor borderColor, HColor backgroundColor, double cornersize, ClockwiseTopRightBottomLeft margins) {
        this.top = margins.getTop();
        this.right = margins.getRight();
        this.bottom = margins.getBottom();
        this.left = margins.getLeft();
        this.cornersize = cornersize;
        this.textBlock = textBlock;
        this.withShadow = false;
        this.stroke = stroke;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
    }

    TextBlockBordered(TextBlock textBlock, UStroke stroke, HColor borderColor, HColor backgroundColor, double cornersize) {
        this(textBlock, stroke, borderColor, backgroundColor, cornersize, 6.0, 5.0);
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + this.top + this.bottom;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + this.left + this.right;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(width + 1.0, height + 1.0);
    }

    private UGraphic applyStroke(UGraphic ug) {
        if (this.stroke == null) {
            return ug;
        }
        return ug.apply(this.stroke);
    }

    private boolean noBorder() {
        if (this.stroke == null) {
            return false;
        }
        return this.stroke.getThickness() == 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color;
        StringBounder stringBounder = ug.getStringBounder();
        Shadowable polygon = this.getPolygonNormal(stringBounder);
        UGraphic ugOriginal = ug;
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        ug = this.backgroundColor == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.backgroundColor.bg());
        HColor hColor = color = this.noBorder() ? this.backgroundColor : this.borderColor;
        if (color == null) {
            color = new HColorNone();
        }
        ug = ug.apply(color);
        ug = this.applyStroke(ug);
        ug.draw(polygon);
        TextBlock toDraw = this.textBlock;
        if (this.textBlock instanceof SheetBlock2) {
            toDraw = ((SheetBlock2)this.textBlock).enlargeMe(this.left, this.right);
        }
        toDraw.drawU(ugOriginal.apply(color).apply(new UTranslate(this.left, this.top)));
    }

    private Shadowable getPolygonNormal(StringBounder stringBounder) {
        double height = this.getTextHeight(stringBounder);
        double width = this.getTextWidth(stringBounder);
        return new URectangle(width, height).rounded(this.cornersize);
    }
}

