/* contacts-main-window.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-main-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
typedef struct _ContactsMainWindowPrivate ContactsMainWindowPrivate;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;
enum  {
	CONTACTS_MAIN_WINDOW_0_PROPERTY,
	CONTACTS_MAIN_WINDOW_STATE_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY,
	CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY,
	CONTACTS_MAIN_WINDOW_STORE_PROPERTY,
	CONTACTS_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_main_window_properties[CONTACTS_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;
typedef struct _Block37Data Block37Data;

struct _ContactsMainWindow {
	AdwApplicationWindow parent_instance;
	ContactsMainWindowPrivate * priv;
	ContactsOperation* last_operation;
};

struct _ContactsMainWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ContactsMainWindowPrivate {
	AdwLeaflet* content_box;
	GtkRevealer* back_revealer;
	GtkStack* list_pane_stack;
	GtkOverlay* contact_pane_container;
	GtkBox* list_pane_page;
	GtkBox* contact_pane_page;
	AdwHeaderBar* left_header;
	AdwHeaderBar* right_header;
	AdwToastOverlay* toast_overlay;
	GtkButton* select_cancel_button;
	GtkMenuButton* hamburger_menu_button;
	GtkBox* contact_sheet_buttons;
	GtkToggleButton* favorite_button;
	gboolean ignore_favorite_button_toggled;
	GtkButton* add_button;
	GtkButton* cancel_button;
	GtkButton* done_button;
	GtkButton* selection_button;
	ContactsListPane* list_pane;
	ContactsContactPane* contact_pane;
	GSimpleActionGroup* actions;
	gboolean delete_cancelled;
	ContactsUiState _state;
	gint _window_width;
	gint _window_height;
	ContactsSettings* _settings;
	ContactsStore* _store;
};

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsListPane {
	AdwBin parent_instance;
	ContactsListPanePrivate * priv;
	GtkSearchEntry* filter_entry;
};

struct _ContactsListPaneClass {
	AdwBinClass parent_class;
};

struct _Block37Data {
	int _ref_count_;
	ContactsMainWindow* self;
	GeeList* individuals;
};

static gint ContactsMainWindow_private_offset;
static gpointer contacts_main_window_parent_class = NULL;

VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
VALA_EXTERN GType contacts_list_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsListPane, g_object_unref)
VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN void contacts_main_window_new_contact (ContactsMainWindow* self,
                                       GSimpleAction* action,
                                       GVariant* parameter);
static void _contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void contacts_main_window_edit_contact (ContactsMainWindow* self,
                                        GSimpleAction* action,
                                        GVariant* parameter);
static void _contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_delete_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* new_state);
static void _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                 GVariant* value,
                                                                                 gpointer self);
static void contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                                 GSimpleAction* action,
                                                 GVariant* parameter);
static void _contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void contacts_main_window_undo_delete_action (ContactsMainWindow* self,
                                              GSimpleAction* action,
                                              GVariant* parameter);
static void _contacts_main_window_undo_delete_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN ContactsMainWindow* contacts_main_window_new (ContactsSettings* settings,
                                              ContactsApp* app,
                                              ContactsStore* contacts_store);
VALA_EXTERN ContactsMainWindow* contacts_main_window_construct (GType object_type,
                                                    ContactsSettings* settings,
                                                    ContactsApp* app,
                                                    ContactsStore* contacts_store);
VALA_EXTERN ContactsSettings* contacts_main_window_get_settings (ContactsMainWindow* self);
VALA_EXTERN gboolean contacts_settings_get_sort_on_surname (ContactsSettings* self);
static void contacts_main_window_restore_window_state (ContactsMainWindow* self);
VALA_EXTERN gint contacts_settings_get_window_width (ContactsSettings* self);
VALA_EXTERN gint contacts_settings_get_window_height (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_maximized (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_fullscreen (ContactsSettings* self);
static void contacts_main_window_create_contact_pane (ContactsMainWindow* self);
VALA_EXTERN ContactsStore* contacts_main_window_get_store (ContactsMainWindow* self);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsMainWindow* main_window,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsMainWindow* main_window,
                                                      ContactsStore* contacts_store);
static void contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                           const gchar* main_contact,
                                                           const gchar* linked_contact,
                                                           ContactsLinkOperation* operation);
static void _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                                  const gchar* main_contact,
                                                                                                  const gchar* linked_contact,
                                                                                                  ContactsLinkOperation* operation,
                                                                                                  gpointer self);
VALA_EXTERN void contacts_main_window_show_contact_list (ContactsMainWindow* self);
VALA_EXTERN ContactsListPane* contacts_list_pane_new (GtkWindow* window,
                                          ContactsSettings* settings,
                                          ContactsStore* contacts_store);
VALA_EXTERN ContactsListPane* contacts_list_pane_construct (GType object_type,
                                                GtkWindow* window,
                                                ContactsSettings* settings,
                                                ContactsStore* contacts_store);
static void contacts_main_window_list_pane_selection_changed_cb (ContactsMainWindow* self,
                                                          FolksIndividual* new_selection);
static void _contacts_main_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender,
                                                                                                FolksIndividual* individual,
                                                                                                gpointer self);
static void contacts_main_window_list_pane_link_contacts_cb (ContactsMainWindow* self,
                                                      GeeLinkedList* contact_list);
static void _contacts_main_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender,
                                                                                        GeeLinkedList* individual,
                                                                                        gpointer self);
static void contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                           GeeList* individuals);
static void _contacts_main_window_delete_contacts_contacts_list_pane_delete_contacts (ContactsListPane* _sender,
                                                                               GeeLinkedList* individual,
                                                                               gpointer self);
static void __lambda55_ (ContactsMainWindow* self,
                  gint nr_contacts);
VALA_EXTERN ContactsUiState contacts_main_window_get_state (ContactsMainWindow* self);
static void ___lambda55__contacts_list_pane_contacts_marked (ContactsListPane* _sender,
                                                      gint contacts_marked,
                                                      gpointer self);
VALA_EXTERN FolksIndividual* contacts_contact_pane_get_individual (ContactsContactPane* self);
VALA_EXTERN void contacts_list_pane_select_contact (ContactsListPane* self,
                                        FolksIndividual* individual);
static void contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                               GObject* obj,
                                               GParamSpec* pspec);
VALA_EXTERN gboolean contacts_ui_state_editing (ContactsUiState self);
static void contacts_main_window_on_back_clicked (ContactsMainWindow* self);
static void contacts_main_window_show_list_pane (ContactsMainWindow* self);
static void _contacts_main_window_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
VALA_EXTERN void contacts_main_window_set_state (ContactsMainWindow* self,
                                     ContactsUiState value);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
static void contacts_main_window_on_favorite_button_toggled (ContactsMainWindow* self,
                                                      GtkToggleButton* button);
static void _contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                 gpointer self);
static void contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self);
static void _contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
VALA_EXTERN void contacts_main_window_set_shown_contact (ContactsMainWindow* self,
                                             FolksIndividual* i);
static void __lambda50_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda50__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void contacts_list_pane_set_contact_visible (ContactsListPane* self,
                                             FolksIndividual* individual,
                                             gboolean visible);
VALA_EXTERN void contacts_settings_set_sort_on_surname (ContactsSettings* self,
                                            gboolean value);
static void __lambda53_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda53__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void contacts_main_window_stop_editing (ContactsMainWindow* self,
                                        gboolean cancel);
static void contacts_main_window_show_contact_pane (ContactsMainWindow* self);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
VALA_EXTERN void contacts_list_pane_scroll_to_contact (ContactsListPane* self);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void contacts_main_window_on_cancel_visible (ContactsMainWindow* self);
static void contacts_main_window_update_header (ContactsMainWindow* self);
static void _contacts_main_window_on_cancel_visible_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void contacts_main_window_on_folded (ContactsMainWindow* self);
static void _contacts_main_window_on_folded_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void contacts_main_window_on_child_transition_running (ContactsMainWindow* self);
static void _contacts_main_window_on_child_transition_running_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
VALA_EXTERN void contacts_main_window_show_search (ContactsMainWindow* self,
                                       const gchar* query);
static void contacts_main_window_connect_button_signals (ContactsMainWindow* self);
static void __lambda56_ (ContactsMainWindow* self);
static void ___lambda56__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda57_ (ContactsMainWindow* self);
static void ___lambda57__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda58_ (ContactsMainWindow* self);
static void ___lambda58__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda59_ (ContactsMainWindow* self);
static void ___lambda59__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean contacts_main_window_real_close_request (GtkWindow* base);
VALA_EXTERN void contacts_settings_set_window_width (ContactsSettings* self,
                                         gint value);
VALA_EXTERN void contacts_settings_set_window_height (ContactsSettings* self,
                                          gint value);
VALA_EXTERN void contacts_settings_set_window_maximized (ContactsSettings* self,
                                             gboolean value);
VALA_EXTERN void contacts_settings_set_window_fullscreen (ContactsSettings* self,
                                              gboolean value);
static void __lambda54_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda54__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void __lambda51_ (Block37Data* _data37_);
static void ___lambda52_ (ContactsMainWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda52__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda51__adw_toast_dismissed (AdwToast* _sender,
                                       gpointer self);
VALA_EXTERN gint contacts_main_window_get_window_width (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_width (ContactsMainWindow* self,
                                            gint value);
VALA_EXTERN gint contacts_main_window_get_window_height (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_height (ContactsMainWindow* self,
                                             gint value);
VALA_EXTERN void contacts_main_window_set_settings (ContactsMainWindow* self,
                                        ContactsSettings* value);
VALA_EXTERN void contacts_main_window_set_store (ContactsMainWindow* self,
                                     ContactsStore* value);
static GObject * contacts_main_window_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void contacts_main_window_finalize (GObject * obj);
static GType contacts_main_window_get_type_once (void);
static void _vala_contacts_main_window_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_contacts_main_window_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static const GActionEntry CONTACTS_MAIN_WINDOW_ACTION_ENTRIES[7] = {{"new-contact", _contacts_main_window_new_contact_gsimple_action_activate_callback}, {"edit-contact", _contacts_main_window_edit_contact_gsimple_action_activate_callback}, {"unlink-contact", _contacts_main_window_unlink_contact_gsimple_action_activate_callback}, {"delete-contact", _contacts_main_window_delete_contact_gsimple_action_activate_callback}, {"sort-on", NULL, "s", "'surname'", _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback}, {"undo-operation", _contacts_main_window_undo_operation_action_gsimple_action_activate_callback}, {"undo-delete", _contacts_main_window_undo_delete_action_gsimple_action_activate_callback}};

static inline gpointer
contacts_main_window_get_instance_private (ContactsMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsMainWindow_private_offset);
}

static void
_contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	contacts_main_window_new_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	contacts_main_window_edit_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_unlink_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_delete_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                            GVariant* value,
                                                                            gpointer self)
{
	contacts_main_window_sort_on_changed ((ContactsMainWindow*) self, action, value);
}

static void
_contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	contacts_main_window_undo_operation_action ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_undo_delete_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	contacts_main_window_undo_delete_action ((ContactsMainWindow*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsMainWindow*
contacts_main_window_construct (GType object_type,
                                ContactsSettings* settings,
                                ContactsApp* app,
                                ContactsStore* contacts_store)
{
	ContactsMainWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	ContactsSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* sort_key = NULL;
	GSimpleAction* sort_action = NULL;
	GSimpleActionGroup* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsMainWindow*) g_object_new (object_type, "application", app, "settings", settings, "store", contacts_store, NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_sort_on_surname (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "surname";
	} else {
		_tmp0_ = "firstname";
	}
	sort_key = _tmp0_;
	_tmp4_ = self->priv->actions;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, "sort-on");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	sort_action = _tmp6_;
	_tmp7_ = g_variant_new_string (sort_key);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	g_simple_action_set_state (sort_action, _tmp8_);
	_g_variant_unref0 (_tmp8_);
	_g_object_unref0 (sort_action);
	return self;
}

ContactsMainWindow*
contacts_main_window_new (ContactsSettings* settings,
                          ContactsApp* app,
                          ContactsStore* contacts_store)
{
	return contacts_main_window_construct (CONTACTS_TYPE_MAIN_WINDOW, settings, app, contacts_store);
}

static void
contacts_main_window_restore_window_state (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ContactsSettings* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_window_width (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ContactsSettings* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->_settings;
		_tmp5_ = contacts_settings_get_window_height (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsSettings* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		ContactsSettings* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp7_ = self->priv->_settings;
		_tmp8_ = contacts_settings_get_window_width (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_settings;
		_tmp11_ = contacts_settings_get_window_height (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_window_set_default_size ((GtkWindow*) self, _tmp9_, _tmp12_);
	}
	_tmp13_ = self->priv->_settings;
	_tmp14_ = contacts_settings_get_window_maximized (_tmp13_);
	_tmp15_ = _tmp14_;
	g_object_set ((GtkWindow*) self, "maximized", _tmp15_, NULL);
	_tmp16_ = self->priv->_settings;
	_tmp17_ = contacts_settings_get_window_fullscreen (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set ((GtkWindow*) self, "fullscreened", _tmp18_, NULL);
}

static void
_contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                             const gchar* main_contact,
                                                                                             const gchar* linked_contact,
                                                                                             ContactsLinkOperation* operation,
                                                                                             gpointer self)
{
	contacts_main_window_contact_pane_contacts_linked_cb ((ContactsMainWindow*) self, main_contact, linked_contact, operation);
}

static void
contacts_main_window_create_contact_pane (ContactsMainWindow* self)
{
	ContactsStore* _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContactPane* _tmp4_;
	GtkOverlay* _tmp5_;
	ContactsContactPane* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_contact_pane_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->contact_pane);
	self->priv->contact_pane = _tmp1_;
	_tmp2_ = self->priv->contact_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->contact_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->contact_pane;
	g_signal_connect_object (_tmp4_, "contacts-linked", (GCallback) _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked, self, 0);
	_tmp5_ = self->priv->contact_pane_container;
	_tmp6_ = self->priv->contact_pane;
	gtk_overlay_set_child (_tmp5_, (GtkWidget*) _tmp6_);
}

/**
   * This shows the contact list on the left. This needs to be called
   * explicitly when contacts are loaded, as the original setup will
   * only show a loading spinner.
   */
static void
_contacts_main_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender,
                                                                                           FolksIndividual* individual,
                                                                                           gpointer self)
{
	contacts_main_window_list_pane_selection_changed_cb ((ContactsMainWindow*) self, individual);
}

static void
_contacts_main_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender,
                                                                                   GeeLinkedList* individual,
                                                                                   gpointer self)
{
	contacts_main_window_list_pane_link_contacts_cb ((ContactsMainWindow*) self, individual);
}

static void
_contacts_main_window_delete_contacts_contacts_list_pane_delete_contacts (ContactsListPane* _sender,
                                                                          GeeLinkedList* individual,
                                                                          gpointer self)
{
	contacts_main_window_delete_contacts ((ContactsMainWindow*) self, individual);
}

static void
__lambda55_ (ContactsMainWindow* self,
             gint nr_contacts)
{
	gchar* left_title = NULL;
	gchar* _tmp0_;
	ContactsUiState _tmp1_;
	AdwHeaderBar* _tmp3_;
	const gchar* _tmp4_;
	AdwWindowTitle* _tmp5_;
	AdwWindowTitle* _tmp6_;
	_tmp0_ = g_strdup (_ ("Contacts"));
	left_title = _tmp0_;
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_SELECTING) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (ngettext ("%d Selected", "%d Selected", (gulong) nr_contacts), nr_contacts);
		_g_free0 (left_title);
		left_title = _tmp2_;
	}
	_tmp3_ = self->priv->left_header;
	_tmp4_ = left_title;
	_tmp5_ = (AdwWindowTitle*) adw_window_title_new (_tmp4_, "");
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	adw_header_bar_set_title_widget (_tmp3_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (left_title);
}

static void
___lambda55__contacts_list_pane_contacts_marked (ContactsListPane* _sender,
                                                 gint contacts_marked,
                                                 gpointer self)
{
	__lambda55_ ((ContactsMainWindow*) self, contacts_marked);
}

void
contacts_main_window_show_contact_list (ContactsMainWindow* self)
{
	ContactsListPane* _tmp0_;
	ContactsSettings* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsListPane* _tmp3_;
	ContactsListPane* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsListPane* _tmp6_;
	ContactsListPane* _tmp7_;
	ContactsListPane* _tmp8_;
	GtkStack* _tmp9_;
	ContactsListPane* _tmp10_;
	GtkStack* _tmp11_;
	ContactsListPane* _tmp12_;
	ContactsContactPane* _tmp13_;
	FolksIndividual* _tmp14_;
	FolksIndividual* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_settings;
	_tmp2_ = self->priv->_store;
	_tmp3_ = contacts_list_pane_new ((GtkWindow*) self, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp3_;
	_tmp4_ = self->priv->list_pane;
	g_object_bind_property_with_closures ((GObject*) self, "state", (GObject*) _tmp4_, "state", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->list_pane;
	g_signal_connect_object (_tmp5_, "selection-changed", (GCallback) _contacts_main_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed, self, 0);
	_tmp6_ = self->priv->list_pane;
	g_signal_connect_object (_tmp6_, "link-contacts", (GCallback) _contacts_main_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts, self, 0);
	_tmp7_ = self->priv->list_pane;
	g_signal_connect_object (_tmp7_, "delete-contacts", (GCallback) _contacts_main_window_delete_contacts_contacts_list_pane_delete_contacts, self, 0);
	_tmp8_ = self->priv->list_pane;
	g_signal_connect_object (_tmp8_, "contacts-marked", (GCallback) ___lambda55__contacts_list_pane_contacts_marked, self, 0);
	_tmp9_ = self->priv->list_pane_stack;
	_tmp10_ = self->priv->list_pane;
	gtk_stack_add_child (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->list_pane_stack;
	_tmp12_ = self->priv->list_pane;
	gtk_stack_set_visible_child (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->contact_pane;
	_tmp14_ = contacts_contact_pane_get_individual (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ContactsListPane* _tmp16_;
		ContactsContactPane* _tmp17_;
		FolksIndividual* _tmp18_;
		FolksIndividual* _tmp19_;
		_tmp16_ = self->priv->list_pane;
		_tmp17_ = self->priv->contact_pane;
		_tmp18_ = contacts_contact_pane_get_individual (_tmp17_);
		_tmp19_ = _tmp18_;
		contacts_list_pane_select_contact (_tmp16_, _tmp19_);
	}
}

static void
contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                          GObject* obj,
                                          GParamSpec* pspec)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	GtkButton* _tmp3_;
	GtkMenuButton* _tmp4_;
	GtkBox* _tmp5_;
	ContactsUiState _tmp6_;
	GtkButton* _tmp7_;
	ContactsUiState _tmp8_;
	gboolean _tmp9_ = FALSE;
	ContactsUiState _tmp10_;
	GtkButton* _tmp12_;
	ContactsUiState _tmp13_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	AdwHeaderBar* _tmp19_;
	ContactsUiState _tmp20_;
	AdwHeaderBar* _tmp21_;
	ContactsUiState _tmp22_;
	ContactsUiState _tmp23_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	ContactsUiState _tmp30_;
	AdwLeaflet* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_SHOWING;
	}
	_tmp3_ = self->priv->add_button;
	_tmp4_ = self->priv->hamburger_menu_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp0_);
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp0_);
	_tmp5_ = self->priv->contact_sheet_buttons;
	_tmp6_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp6_ == CONTACTS_UI_STATE_SHOWING);
	_tmp7_ = self->priv->select_cancel_button;
	_tmp8_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ == CONTACTS_UI_STATE_SELECTING);
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		_tmp9_ = TRUE;
	} else {
		ContactsUiState _tmp11_;
		_tmp11_ = self->priv->_state;
		_tmp9_ = contacts_ui_state_editing (_tmp11_);
	}
	_tmp12_ = self->priv->selection_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, !_tmp9_);
	_tmp13_ = self->priv->_state;
	if (_tmp13_ != CONTACTS_UI_STATE_SELECTING) {
		AdwHeaderBar* _tmp14_;
		AdwWindowTitle* _tmp15_;
		AdwWindowTitle* _tmp16_;
		_tmp14_ = self->priv->left_header;
		_tmp15_ = (AdwWindowTitle*) adw_window_title_new (_ ("Contacts"), "");
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		adw_header_bar_set_title_widget (_tmp14_, (GtkWidget*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->cancel_button;
	_tmp18_ = self->priv->done_button;
	_tmp19_ = self->priv->right_header;
	_tmp20_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp19_, contacts_ui_state_editing (_tmp20_));
	gtk_widget_set_visible ((GtkWidget*) _tmp18_, contacts_ui_state_editing (_tmp20_));
	gtk_widget_set_visible ((GtkWidget*) _tmp17_, contacts_ui_state_editing (_tmp20_));
	_tmp21_ = self->priv->right_header;
	_tmp22_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp21_, !contacts_ui_state_editing (_tmp22_));
	_tmp23_ = self->priv->_state;
	if (contacts_ui_state_editing (_tmp23_)) {
		const gchar* _tmp24_ = NULL;
		ContactsUiState _tmp25_;
		GtkButton* _tmp26_;
		GtkButton* _tmp27_;
		_tmp25_ = self->priv->_state;
		if (_tmp25_ == CONTACTS_UI_STATE_CREATING) {
			_tmp24_ = _ ("_Add");
		} else {
			_tmp24_ = _ ("Done");
		}
		_tmp26_ = self->priv->done_button;
		gtk_button_set_label (_tmp26_, _tmp24_);
		_tmp27_ = self->priv->done_button;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp27_, TRUE);
	}
	_tmp30_ = self->priv->_state;
	if (_tmp30_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp29_ = TRUE;
	} else {
		ContactsUiState _tmp31_;
		_tmp31_ = self->priv->_state;
		_tmp29_ = _tmp31_ == CONTACTS_UI_STATE_SHOWING;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		ContactsUiState _tmp32_;
		_tmp32_ = self->priv->_state;
		_tmp28_ = _tmp32_ == CONTACTS_UI_STATE_SELECTING;
	}
	_tmp33_ = self->priv->content_box;
	adw_leaflet_set_can_navigate_back (_tmp33_, _tmp28_);
}

static void
contacts_main_window_on_back_clicked (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_show_list_pane (self);
}

static void
_contacts_main_window_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	contacts_main_window_on_back_clicked ((ContactsMainWindow*) self);
}

static void
contacts_main_window_edit_contact (ContactsMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter)
{
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	const gchar* name = NULL;
	ContactsContactPane* _tmp3_;
	FolksIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* title = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	AdwHeaderBar* _tmp10_;
	const gchar* _tmp11_;
	AdwWindowTitle* _tmp12_;
	AdwWindowTitle* _tmp13_;
	ContactsContactPane* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_UPDATING);
	_tmp3_ = self->priv->contact_pane;
	_tmp4_ = contacts_contact_pane_get_individual (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_individual_get_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	name = _tmp7_;
	_tmp8_ = name;
	_tmp9_ = g_strdup_printf (_ ("Editing %s"), _tmp8_);
	title = _tmp9_;
	_tmp10_ = self->priv->right_header;
	_tmp11_ = title;
	_tmp12_ = (AdwWindowTitle*) adw_window_title_new (_tmp11_, "");
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	adw_header_bar_set_title_widget (_tmp10_, (GtkWidget*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->contact_pane;
	contacts_contact_pane_edit_contact (_tmp14_);
	_g_free0 (title);
}

static void
contacts_main_window_on_favorite_button_toggled (ContactsMainWindow* self,
                                                 GtkToggleButton* button)
{
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	gboolean is_fav = FALSE;
	ContactsContactPane* _tmp3_;
	FolksIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ContactsContactPane* _tmp8_;
	FolksIndividual* _tmp9_;
	FolksIndividual* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (self->priv->ignore_favorite_button_toggled) {
		return;
	}
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->contact_pane;
	_tmp4_ = contacts_contact_pane_get_individual (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp5_);
	_tmp7_ = _tmp6_;
	is_fav = _tmp7_;
	_tmp8_ = self->priv->contact_pane;
	_tmp9_ = contacts_contact_pane_get_individual (_tmp8_);
	_tmp10_ = _tmp9_;
	folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp10_, !is_fav);
}

static void
_contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                            gpointer self)
{
	contacts_main_window_on_favorite_button_toggled ((ContactsMainWindow*) self, _sender);
}

static void
contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self)
{
	gchar* left_title = NULL;
	gchar* _tmp0_;
	AdwHeaderBar* _tmp1_;
	AdwWindowTitle* _tmp2_;
	AdwWindowTitle* _tmp3_;
	g_return_if_fail (self != NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_SELECTING);
	_tmp0_ = g_strdup_printf (ngettext ("%d Selected", "%d Selected", (gulong) 0), 0);
	left_title = _tmp0_;
	_tmp1_ = self->priv->left_header;
	_tmp2_ = (AdwWindowTitle*) adw_window_title_new (left_title, "");
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	adw_header_bar_set_title_widget (_tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (left_title);
}

static void
_contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	contacts_main_window_on_selection_button_clicked ((ContactsMainWindow*) self);
}

static void
__lambda50_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperation* _tmp0_;
		_tmp0_ = self->last_operation;
		contacts_operation_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:253: Error unlinking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda50__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda50_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	FolksIndividual* individual = NULL;
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	ContactsStore* _tmp4_;
	FolksIndividual* _tmp5_;
	ContactsUnlinkOperation* _tmp6_;
	ContactsOperation* _tmp7_;
	AdwToast* toast = NULL;
	ContactsOperation* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	AdwToast* _tmp12_;
	AdwToast* _tmp13_;
	AdwToast* _tmp14_;
	AdwToast* _tmp15_;
	AdwToastOverlay* _tmp16_;
	AdwToast* _tmp17_;
	AdwToast* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	individual = _tmp2_;
	_tmp3_ = individual;
	if (_tmp3_ == NULL) {
		return;
	}
	contacts_main_window_set_shown_contact (self, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp4_ = self->priv->_store;
	_tmp5_ = individual;
	_tmp6_ = contacts_unlink_operation_new (_tmp4_, _tmp5_);
	_g_object_unref0 (self->last_operation);
	self->last_operation = (ContactsOperation*) _tmp6_;
	_tmp7_ = self->last_operation;
	contacts_operation_execute (_tmp7_, ___lambda50__gasync_ready_callback, g_object_ref (self));
	_tmp8_ = self->last_operation;
	_tmp9_ = contacts_operation_get_description (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp12_ = adw_toast_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	toast = _tmp13_;
	_tmp14_ = toast;
	adw_toast_set_button_label (_tmp14_, _ ("_Undo"));
	_tmp15_ = toast;
	adw_toast_set_action_name (_tmp15_, "window.undo-operation");
	_tmp16_ = self->priv->toast_overlay;
	_tmp17_ = toast;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	adw_toast_overlay_add_toast (_tmp16_, _tmp18_);
	_g_object_unref0 (toast);
}

static void
contacts_main_window_delete_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	FolksIndividual* individual = NULL;
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	ContactsListPane* _tmp5_;
	FolksIndividual* _tmp6_;
	FolksIndividual* _tmp7_;
	FolksIndividual* _tmp8_;
	FolksIndividual** _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	individual = _tmp3_;
	_tmp4_ = individual;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (individual);
		return;
	}
	_tmp5_ = self->priv->list_pane;
	_tmp6_ = individual;
	contacts_list_pane_set_contact_visible (_tmp5_, _tmp6_, FALSE);
	_tmp7_ = individual;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = g_new0 (FolksIndividual*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = gee_array_list_new_wrap (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp9_, 1, NULL, NULL, NULL);
	_tmp11_ = _tmp10_;
	contacts_main_window_delete_contacts (self, (GeeList*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (individual);
}

static void
contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* new_state)
{
	const gchar* sort_key = NULL;
	const gchar* _tmp0_;
	ContactsSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (new_state, NULL);
	sort_key = _tmp0_;
	_tmp1_ = self->priv->_settings;
	contacts_settings_set_sort_on_surname (_tmp1_, g_strcmp0 (sort_key, "surname") == 0);
	g_simple_action_set_state (action, new_state);
}

static void
__lambda53_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsOperation* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperation* _tmp0_;
		_tmp0_ = self->last_operation;
		contacts_operation_undo_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		ContactsOperation* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->last_operation;
		_tmp2_ = contacts_operation_get_description (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("contacts-main-window.vala:290: Couldn't undo operation '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = self->last_operation;
	_tmp8_ = contacts_operation_get_description (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	g_debug ("contacts-main-window.vala:292: Finished undoing operation '%s'", _tmp10_);
	_g_free0 (_tmp10_);
}

static void
___lambda53__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda53_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                            GSimpleAction* action,
                                            GVariant* parameter)
{
	ContactsOperation* _tmp0_;
	ContactsOperation* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ContactsOperation* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->last_operation;
	if (_tmp0_ == NULL) {
		g_warning ("contacts-main-window.vala:281: Undo action was called without anything" \
" that can be undone?");
		return;
	}
	_tmp1_ = self->last_operation;
	_tmp2_ = contacts_operation_get_description (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_debug ("contacts-main-window.vala:285: Undoing operation '%s'", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->last_operation;
	contacts_operation_undo (_tmp5_, ___lambda53__gasync_ready_callback, g_object_ref (self));
}

static void
contacts_main_window_undo_delete_action (ContactsMainWindow* self,
                                         GSimpleAction* action,
                                         GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	self->priv->delete_cancelled = TRUE;
}

static void
contacts_main_window_stop_editing (ContactsMainWindow* self,
                                   gboolean cancel)
{
	ContactsUiState _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsListPane* _tmp2_;
	AdwHeaderBar* _tmp3_;
	AdwWindowTitle* _tmp4_;
	AdwWindowTitle* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CONTACTS_UI_STATE_CREATING) {
		if (cancel) {
			contacts_main_window_show_list_pane (self);
		}
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	} else {
		contacts_main_window_show_contact_pane (self);
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
	_tmp1_ = self->priv->contact_pane;
	contacts_contact_pane_stop_editing (_tmp1_, cancel);
	_tmp2_ = self->priv->list_pane;
	contacts_list_pane_scroll_to_contact (_tmp2_);
	_tmp3_ = self->priv->right_header;
	_tmp4_ = (AdwWindowTitle*) adw_window_title_new ("", "");
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	adw_header_bar_set_title_widget (_tmp3_, (GtkWidget*) _tmp5_);
	_g_object_unref0 (_tmp5_);
}

void
contacts_main_window_set_shown_contact (ContactsMainWindow* self,
                                        FolksIndividual* i)
{
	ContactsContactPane* _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsListPane* _tmp2_;
	AdwHeaderBar* _tmp4_;
	AdwWindowTitle* _tmp5_;
	AdwWindowTitle* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	if (_tmp0_->on_edit_mode) {
		contacts_main_window_stop_editing (self, FALSE);
	}
	_tmp1_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp1_, i);
	_tmp2_ = self->priv->list_pane;
	if (_tmp2_ != NULL) {
		ContactsListPane* _tmp3_;
		_tmp3_ = self->priv->list_pane;
		contacts_list_pane_select_contact (_tmp3_, i);
	}
	_tmp4_ = self->priv->right_header;
	_tmp5_ = (AdwWindowTitle*) adw_window_title_new ("", "");
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	adw_header_bar_set_title_widget (_tmp4_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (i != NULL) {
		GtkToggleButton* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_;
		gboolean _tmp12_;
		GtkToggleButton* _tmp13_;
		self->priv->ignore_favorite_button_toggled = TRUE;
		_tmp7_ = self->priv->favorite_button;
		_tmp8_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) i);
		_tmp9_ = _tmp8_;
		gtk_toggle_button_set_active (_tmp7_, _tmp9_);
		self->priv->ignore_favorite_button_toggled = FALSE;
		_tmp11_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) i);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			_tmp10_ = _ ("Unmark as favorite");
		} else {
			_tmp10_ = _ ("Mark as favorite");
		}
		_tmp13_ = self->priv->favorite_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp10_);
	}
}

void
contacts_main_window_new_contact (ContactsMainWindow* self,
                                  GSimpleAction* action,
                                  GVariant* parameter)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	ContactsListPane* _tmp3_;
	AdwHeaderBar* _tmp4_;
	AdwWindowTitle* _tmp5_;
	AdwWindowTitle* _tmp6_;
	ContactsContactPane* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_UPDATING) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_CREATING;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->list_pane;
	contacts_list_pane_select_contact (_tmp3_, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_CREATING);
	_tmp4_ = self->priv->right_header;
	_tmp5_ = (AdwWindowTitle*) adw_window_title_new (_ ("New Contact"), "");
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	adw_header_bar_set_title_widget (_tmp4_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->contact_pane;
	contacts_contact_pane_new_contact (_tmp7_);
	contacts_main_window_show_contact_pane (self);
}

static void
contacts_main_window_on_cancel_visible (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_update_header (self);
}

static void
_contacts_main_window_on_cancel_visible_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	contacts_main_window_on_cancel_visible ((ContactsMainWindow*) self);
}

static void
contacts_main_window_on_folded (ContactsMainWindow* self)
{
	g_return_if_fail (self != NULL);
	contacts_main_window_update_header (self);
}

static void
_contacts_main_window_on_folded_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	contacts_main_window_on_folded ((ContactsMainWindow*) self);
}

static void
contacts_main_window_on_child_transition_running (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	AdwLeaflet* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->content_box;
	_tmp2_ = adw_leaflet_get_child_transition_running (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		AdwLeaflet* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		GtkBox* _tmp7_;
		_tmp4_ = self->priv->content_box;
		_tmp5_ = adw_leaflet_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->list_pane_page;
		_tmp0_ = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsListPane* _tmp8_;
		_tmp8_ = self->priv->list_pane;
		contacts_list_pane_select_contact (_tmp8_, NULL);
	}
}

static void
_contacts_main_window_on_child_transition_running_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	contacts_main_window_on_child_transition_running ((ContactsMainWindow*) self);
}

static void
contacts_main_window_update_header (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	AdwLeaflet* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkRevealer* _tmp12_;
	GtkRevealer* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->content_box;
	_tmp3_ = adw_leaflet_get_folded (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->cancel_button;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AdwLeaflet* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkBox* _tmp11_;
		_tmp8_ = self->priv->content_box;
		_tmp9_ = adw_leaflet_get_visible_child (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->contact_pane_page;
		_tmp0_ = _tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = self->priv->back_revealer;
	_tmp13_ = self->priv->back_revealer;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp0_);
	gtk_revealer_set_reveal_child (_tmp12_, _tmp0_);
}

static void
contacts_main_window_show_list_pane (ContactsMainWindow* self)
{
	AdwLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	adw_leaflet_navigate (_tmp0_, ADW_NAVIGATION_DIRECTION_BACK);
	contacts_main_window_update_header (self);
}

static void
contacts_main_window_show_contact_pane (ContactsMainWindow* self)
{
	AdwLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	adw_leaflet_navigate (_tmp0_, ADW_NAVIGATION_DIRECTION_FORWARD);
	contacts_main_window_update_header (self);
}

void
contacts_main_window_show_search (ContactsMainWindow* self,
                                  const gchar* query)
{
	ContactsListPane* _tmp0_;
	GtkSearchEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = _tmp0_->filter_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp1_, query);
}

static void
__lambda56_ (ContactsMainWindow* self)
{
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	} else {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	}
}

static void
___lambda56__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda56_ ((ContactsMainWindow*) self);
}

static void
__lambda57_ (ContactsMainWindow* self)
{
	contacts_main_window_stop_editing (self, FALSE);
}

static void
___lambda57__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda57_ ((ContactsMainWindow*) self);
}

static void
__lambda58_ (ContactsMainWindow* self)
{
	contacts_main_window_stop_editing (self, TRUE);
}

static void
___lambda58__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda58_ ((ContactsMainWindow*) self);
}

static void
__lambda59_ (ContactsMainWindow* self)
{
	FolksIndividual* individual = NULL;
	ContactsContactPane* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	GAction* unlink_action = NULL;
	GSimpleActionGroup* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	FolksIndividual* _tmp8_;
	GeeSet* _tmp9_;
	GeeSet* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = contacts_contact_pane_get_individual (_tmp0_);
	_tmp2_ = _tmp1_;
	individual = _tmp2_;
	_tmp3_ = individual;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->actions;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, "unlink-contact");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	unlink_action = _tmp6_;
	_tmp7_ = unlink_action;
	_tmp8_ = individual;
	_tmp9_ = folks_individual_get_personas (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction), _tmp12_ > 1);
	_g_object_unref0 (unlink_action);
}

static void
___lambda59__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda59_ ((ContactsMainWindow*) self);
}

static void
contacts_main_window_connect_button_signals (ContactsMainWindow* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	ContactsContactPane* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->select_cancel_button;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) ___lambda56__gtk_button_clicked, self, 0);
	_tmp1_ = self->priv->done_button;
	g_signal_connect_object (_tmp1_, "clicked", (GCallback) ___lambda57__gtk_button_clicked, self, 0);
	_tmp2_ = self->priv->cancel_button;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda58__gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->contact_pane;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::individual", (GCallback) ___lambda59__g_object_notify, self, 0);
}

static gboolean
contacts_main_window_real_close_request (GtkWindow* base)
{
	ContactsMainWindow * self;
	ContactsContactPane* _tmp0_;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ContactsSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ContactsSettings* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean result;
	self = (ContactsMainWindow*) base;
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL);
	_tmp1_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-width", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	contacts_settings_set_window_width (_tmp1_, _tmp3_);
	_tmp4_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-height", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	contacts_settings_set_window_height (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	contacts_settings_set_window_maximized (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "fullscreened", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	contacts_settings_set_window_fullscreen (_tmp10_, _tmp12_);
	result = GTK_WINDOW_CLASS (contacts_main_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
contacts_main_window_list_pane_selection_changed_cb (ContactsMainWindow* self,
                                                     FolksIndividual* new_selection)
{
	ContactsUiState _tmp0_;
	g_return_if_fail (self != NULL);
	contacts_main_window_set_shown_contact (self, new_selection);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != CONTACTS_UI_STATE_SELECTING) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
	if (new_selection != NULL) {
		contacts_main_window_show_contact_pane (self);
	}
}

static void
__lambda54_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperation* _tmp0_;
		_tmp0_ = self->last_operation;
		contacts_operation_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:440: Error linking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda54__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda54_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_list_pane_link_contacts_cb (ContactsMainWindow* self,
                                                 GeeLinkedList* contact_list)
{
	ContactsStore* _tmp0_;
	ContactsLinkOperation* _tmp1_;
	ContactsOperation* _tmp2_;
	AdwToast* toast = NULL;
	ContactsOperation* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	AdwToast* _tmp7_;
	AdwToast* _tmp8_;
	AdwToastOverlay* _tmp9_;
	AdwToast* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact_list != NULL);
	contacts_main_window_set_shown_contact (self, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_link_operation_new (_tmp0_, contact_list);
	_g_object_unref0 (self->last_operation);
	self->last_operation = (ContactsOperation*) _tmp1_;
	_tmp2_ = self->last_operation;
	contacts_operation_execute (_tmp2_, ___lambda54__gasync_ready_callback, g_object_ref (self));
	_tmp3_ = self->last_operation;
	_tmp4_ = contacts_operation_get_description (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = adw_toast_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	toast = _tmp8_;
	adw_toast_set_button_label (toast, _ ("_Undo"));
	adw_toast_set_action_name (toast, "window.undo-operation");
	_tmp9_ = self->priv->toast_overlay;
	_tmp10_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp9_, _tmp10_);
	_g_object_unref0 (toast);
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->individuals);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static void
___lambda52_ (ContactsMainWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperation* _tmp0_;
		_tmp0_ = self->last_operation;
		contacts_operation_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("contacts-main-window.vala:470: Coudln't remove persona: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda52__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda52_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda51_ (Block37Data* _data37_)
{
	ContactsMainWindow* self;
	self = _data37_->self;
	if (self->priv->delete_cancelled) {
		ContactsListPane* _tmp0_;
		gpointer _tmp1_;
		FolksIndividual* _tmp2_;
		gpointer _tmp3_;
		FolksIndividual* _tmp4_;
		_tmp0_ = self->priv->list_pane;
		_tmp1_ = gee_list_get (_data37_->individuals, 0);
		_tmp2_ = (FolksIndividual*) _tmp1_;
		contacts_list_pane_set_contact_visible (_tmp0_, _tmp2_, TRUE);
		_g_object_unref0 (_tmp2_);
		_tmp3_ = gee_list_get (_data37_->individuals, 0);
		_tmp4_ = (FolksIndividual*) _tmp3_;
		contacts_main_window_set_shown_contact (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	} else {
		ContactsOperation* _tmp5_;
		_tmp5_ = self->last_operation;
		contacts_operation_execute (_tmp5_, ____lambda52__gasync_ready_callback, g_object_ref (self));
	}
}

static void
___lambda51__adw_toast_dismissed (AdwToast* _sender,
                                  gpointer self)
{
	__lambda51_ (self);
}

static void
contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                      GeeList* individuals)
{
	Block37Data* _data37_;
	GeeList* _tmp0_;
	ContactsDeleteOperation* _tmp1_;
	AdwToast* toast = NULL;
	ContactsOperation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	AdwToast* _tmp6_;
	AdwToast* _tmp7_;
	AdwToastOverlay* _tmp8_;
	AdwToast* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individuals != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (individuals);
	_g_object_unref0 (_data37_->individuals);
	_data37_->individuals = _tmp0_;
	contacts_main_window_set_shown_contact (self, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp1_ = contacts_delete_operation_new (_data37_->individuals);
	_g_object_unref0 (self->last_operation);
	self->last_operation = (ContactsOperation*) _tmp1_;
	_tmp2_ = self->last_operation;
	_tmp3_ = contacts_operation_get_description (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = adw_toast_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	toast = _tmp7_;
	adw_toast_set_button_label (toast, _ ("_Undo"));
	adw_toast_set_action_name (toast, "window.undo-delete");
	self->priv->delete_cancelled = FALSE;
	g_signal_connect_data (toast, "dismissed", (GCallback) ___lambda51__adw_toast_dismissed, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_tmp8_ = self->priv->toast_overlay;
	_tmp9_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp8_, _tmp9_);
	_g_object_unref0 (toast);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}

static void
contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                      const gchar* main_contact,
                                                      const gchar* linked_contact,
                                                      ContactsLinkOperation* operation)
{
	ContactsOperation* _tmp0_;
	AdwToast* toast = NULL;
	ContactsOperation* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	AdwToast* _tmp5_;
	AdwToast* _tmp6_;
	AdwToastOverlay* _tmp7_;
	AdwToast* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (linked_contact != NULL);
	g_return_if_fail (operation != NULL);
	_tmp0_ = _g_object_ref0 ((ContactsOperation*) operation);
	_g_object_unref0 (self->last_operation);
	self->last_operation = _tmp0_;
	_tmp1_ = self->last_operation;
	_tmp2_ = contacts_operation_get_description (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = adw_toast_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	toast = _tmp6_;
	adw_toast_set_button_label (toast, _ ("_Undo"));
	adw_toast_set_action_name (toast, "window.undo-operation");
	_tmp7_ = self->priv->toast_overlay;
	_tmp8_ = _g_object_ref0 (toast);
	adw_toast_overlay_add_toast (_tmp7_, _tmp8_);
	_g_object_unref0 (toast);
}

ContactsUiState
contacts_main_window_get_state (ContactsMainWindow* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_main_window_set_state (ContactsMainWindow* self,
                                ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_width (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_width;
	return result;
}

void
contacts_main_window_set_window_width (ContactsMainWindow* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_width (self);
	if (old_value != value) {
		self->priv->_window_width = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_height (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_height;
	return result;
}

void
contacts_main_window_set_window_height (ContactsMainWindow* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_height (self);
	if (old_value != value) {
		self->priv->_window_height = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY]);
	}
}

ContactsSettings*
contacts_main_window_get_settings (ContactsMainWindow* self)
{
	ContactsSettings* result;
	ContactsSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_settings (ContactsMainWindow* self,
                                   ContactsSettings* value)
{
	ContactsSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_settings (self);
	if (old_value != value) {
		ContactsSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY]);
	}
}

ContactsStore*
contacts_main_window_get_store (ContactsMainWindow* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_store (ContactsMainWindow* self,
                                ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY]);
	}
}

static void
_contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	contacts_main_window_on_ui_state_changed ((ContactsMainWindow*) self, _sender, pspec);
}

static GObject *
contacts_main_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsMainWindow * self;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	_tmp0_ = self->priv->actions;
	g_action_map_add_action_entries ((GActionMap*) _tmp0_, CONTACTS_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CONTACTS_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp1_ = self->priv->actions;
	gtk_widget_insert_action_group ((GtkWidget*) self, "window", (GActionGroup*) _tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _contacts_main_window_on_ui_state_changed_g_object_notify, self, 0);
	contacts_main_window_create_contact_pane (self);
	contacts_main_window_connect_button_signals (self);
	contacts_main_window_restore_window_state (self);
	if (g_strcmp0 (PROFILE, "development") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	return obj;
}

static void
contacts_main_window_class_init (ContactsMainWindowClass * klass,
                                 gpointer klass_data)
{
	contacts_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsMainWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) contacts_main_window_real_close_request;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STATE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, CONTACTS_UI_STATE_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", CONTACTS_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STORE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_box", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, content_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_revealer", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, back_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_stack", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_container", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_header", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, left_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_header", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, right_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, select_cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_menu_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, hamburger_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_buttons", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_sheet_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "done_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "selection_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, selection_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_back_clicked", G_CALLBACK(_contacts_main_window_on_back_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_favorite_button_toggled", G_CALLBACK(_contacts_main_window_on_favorite_button_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_selection_button_clicked", G_CALLBACK(_contacts_main_window_on_selection_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_cancel_visible", G_CALLBACK(_contacts_main_window_on_cancel_visible_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_folded", G_CALLBACK(_contacts_main_window_on_folded_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_child_transition_running", G_CALLBACK(_contacts_main_window_on_child_transition_running_g_object_notify));
}

static void
contacts_main_window_instance_init (ContactsMainWindow * self,
                                    gpointer klass)
{
	GSimpleActionGroup* _tmp0_;
	self->priv = contacts_main_window_get_instance_private (self);
	_tmp0_ = g_simple_action_group_new ();
	self->priv->actions = _tmp0_;
	self->priv->_state = CONTACTS_UI_STATE_NORMAL;
	self->last_operation = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_main_window_finalize (GObject * obj)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->contact_pane);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->last_operation);
	G_OBJECT_CLASS (contacts_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsMainWindow), 0, (GInstanceInitFunc) contacts_main_window_instance_init, NULL };
	GType contacts_main_window_type_id;
	contacts_main_window_type_id = g_type_register_static (adw_application_window_get_type (), "ContactsMainWindow", &g_define_type_info, 0);
	ContactsMainWindow_private_offset = g_type_add_instance_private (contacts_main_window_type_id, sizeof (ContactsMainWindowPrivate));
	return contacts_main_window_type_id;
}

GType
contacts_main_window_get_type (void)
{
	static volatile gsize contacts_main_window_type_id__once = 0;
	if (g_once_init_enter (&contacts_main_window_type_id__once)) {
		GType contacts_main_window_type_id;
		contacts_main_window_type_id = contacts_main_window_get_type_once ();
		g_once_init_leave (&contacts_main_window_type_id__once, contacts_main_window_type_id);
	}
	return contacts_main_window_type_id__once;
}

static void
_vala_contacts_main_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		g_value_set_enum (value, contacts_main_window_get_state (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_width (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_height (self));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_settings (self));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_main_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		contacts_main_window_set_state (self, g_value_get_enum (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		contacts_main_window_set_window_width (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		contacts_main_window_set_window_height (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		contacts_main_window_set_settings (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		contacts_main_window_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

