/* rygel-player-controller.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Atlantic PuffinPack AB.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-renderer.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static GType rygel_player_controller_get_type_once (void);

gboolean
rygel_player_controller_next (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->next) {
		return _iface_->next (self);
	}
	return FALSE;
}

gboolean
rygel_player_controller_previous (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->previous) {
		return _iface_->previous (self);
	}
	return FALSE;
}

void
rygel_player_controller_set_single_play_uri (RygelPlayerController* self,
                                             const gchar* uri,
                                             const gchar* metadata,
                                             const gchar* mime,
                                             const gchar* features)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_single_play_uri) {
		_iface_->set_single_play_uri (self, uri, metadata, mime, features);
	}
}

void
rygel_player_controller_set_playlist_uri (RygelPlayerController* self,
                                          const gchar* uri,
                                          const gchar* metadata,
                                          GUPnPMediaCollection* collection)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_playlist_uri) {
		_iface_->set_playlist_uri (self, uri, metadata, collection);
	}
}

void
rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self,
                                                  const gchar* uri,
                                                  const gchar* metadata,
                                                  const gchar* mime,
                                                  const gchar* features)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_next_single_play_uri) {
		_iface_->set_next_single_play_uri (self, uri, metadata, mime, features);
	}
}

void
rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self,
                                               const gchar* uri,
                                               const gchar* metadata,
                                               GUPnPMediaCollection* collection)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_next_playlist_uri) {
		_iface_->set_next_playlist_uri (self, uri, metadata, collection);
	}
}

gboolean
rygel_player_controller_is_play_mode_valid (RygelPlayerController* self,
                                            const gchar* play_mode)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->is_play_mode_valid) {
		return _iface_->is_play_mode_valid (self, play_mode);
	}
	return FALSE;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
rygel_player_controller_unescape (RygelPlayerController* self,
                                  const gchar* input)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = string_replace (input, "&quot;", "\"");
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = string_replace (_tmp1_, "&lt;", "<");
	_g_free0 (_result_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	_tmp4_ = string_replace (_tmp3_, "&gt;", ">");
	_g_free0 (_result_);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	_tmp6_ = string_replace (_tmp5_, "&apos;", "'");
	_g_free0 (_result_);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	_tmp8_ = string_replace (_tmp7_, "&amp;", "&");
	_g_free0 (_result_);
	_result_ = _tmp8_;
	result = _result_;
	return result;
}

const gchar*
rygel_player_controller_get_playback_state (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_playback_state) {
		return _iface_->get_playback_state (self);
	}
	return NULL;
}

void
rygel_player_controller_set_playback_state (RygelPlayerController* self,
                                            const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_playback_state) {
		_iface_->set_playback_state (self, value);
	}
}

guint
rygel_player_controller_get_n_tracks (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_n_tracks) {
		return _iface_->get_n_tracks (self);
	}
	return 0U;
}

void
rygel_player_controller_set_n_tracks (RygelPlayerController* self,
                                      guint value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_n_tracks) {
		_iface_->set_n_tracks (self, value);
	}
}

guint
rygel_player_controller_get_track (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_track) {
		return _iface_->get_track (self);
	}
	return 0U;
}

void
rygel_player_controller_set_track (RygelPlayerController* self,
                                   guint value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_track) {
		_iface_->set_track (self, value);
	}
}

gchar*
rygel_player_controller_get_uri (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_uri) {
		return _iface_->get_uri (self);
	}
	return NULL;
}

void
rygel_player_controller_set_uri (RygelPlayerController* self,
                                 const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_uri) {
		_iface_->set_uri (self, value);
	}
}

gchar*
rygel_player_controller_get_metadata (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_metadata) {
		return _iface_->get_metadata (self);
	}
	return NULL;
}

void
rygel_player_controller_set_metadata (RygelPlayerController* self,
                                      const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_metadata) {
		_iface_->set_metadata (self, value);
	}
}

gchar*
rygel_player_controller_get_track_uri (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_track_uri) {
		return _iface_->get_track_uri (self);
	}
	return NULL;
}

void
rygel_player_controller_set_track_uri (RygelPlayerController* self,
                                       const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_track_uri) {
		_iface_->set_track_uri (self, value);
	}
}

gchar*
rygel_player_controller_get_track_metadata (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_track_metadata) {
		return _iface_->get_track_metadata (self);
	}
	return NULL;
}

void
rygel_player_controller_set_track_metadata (RygelPlayerController* self,
                                            const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_track_metadata) {
		_iface_->set_track_metadata (self, value);
	}
}

gchar*
rygel_player_controller_get_next_uri (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_next_uri) {
		return _iface_->get_next_uri (self);
	}
	return NULL;
}

void
rygel_player_controller_set_next_uri (RygelPlayerController* self,
                                      const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_next_uri) {
		_iface_->set_next_uri (self, value);
	}
}

gchar*
rygel_player_controller_get_next_metadata (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_next_metadata) {
		return _iface_->get_next_metadata (self);
	}
	return NULL;
}

void
rygel_player_controller_set_next_metadata (RygelPlayerController* self,
                                           const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_next_metadata) {
		_iface_->set_next_metadata (self, value);
	}
}

gchar*
rygel_player_controller_get_current_transport_actions (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_current_transport_actions) {
		return _iface_->get_current_transport_actions (self);
	}
	return NULL;
}

const gchar*
rygel_player_controller_get_play_mode (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_play_mode) {
		return _iface_->get_play_mode (self);
	}
	return NULL;
}

void
rygel_player_controller_set_play_mode (RygelPlayerController* self,
                                       const gchar* value)
{
	RygelPlayerControllerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->set_play_mode) {
		_iface_->set_play_mode (self, value);
	}
}

gboolean
rygel_player_controller_get_can_pause (RygelPlayerController* self)
{
	RygelPlayerControllerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RYGEL_PLAYER_CONTROLLER_GET_INTERFACE (self);
	if (_iface_->get_can_pause) {
		return _iface_->get_can_pause (self);
	}
	return FALSE;
}

static void
rygel_player_controller_default_init (RygelPlayerControllerIface * iface,
                                      gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("next-uri", "next-uri", "next-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("next-metadata", "next-metadata", "next-metadata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("play-mode", "play-mode", "play-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_boolean ("can-pause", "can-pause", "can-pause", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
static GType
rygel_player_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlayerControllerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_player_controller_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_player_controller_type_id;
	rygel_player_controller_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelPlayerController", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_player_controller_type_id, G_TYPE_OBJECT);
	return rygel_player_controller_type_id;
}

GType
rygel_player_controller_get_type (void)
{
	static volatile gsize rygel_player_controller_type_id__once = 0;
	if (g_once_init_enter (&rygel_player_controller_type_id__once)) {
		GType rygel_player_controller_type_id;
		rygel_player_controller_type_id = rygel_player_controller_get_type_once ();
		g_once_init_leave (&rygel_player_controller_type_id__once, rygel_player_controller_type_id);
	}
	return rygel_player_controller_type_id__once;
}

